/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetHostNPortEnclosed is the corresponding interface of BACnetHostNPortEnclosed
type BACnetHostNPortEnclosed interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	// GetOpeningTag returns OpeningTag (property field)
	GetOpeningTag() BACnetOpeningTag
	// GetBacnetHostNPort returns BacnetHostNPort (property field)
	GetBacnetHostNPort() BACnetHostNPort
	// GetClosingTag returns ClosingTag (property field)
	GetClosingTag() BACnetClosingTag
	// IsBACnetHostNPortEnclosed is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetHostNPortEnclosed()
	// CreateBuilder creates a BACnetHostNPortEnclosedBuilder
	CreateBACnetHostNPortEnclosedBuilder() BACnetHostNPortEnclosedBuilder
}

// _BACnetHostNPortEnclosed is the data-structure of this message
type _BACnetHostNPortEnclosed struct {
	OpeningTag      BACnetOpeningTag
	BacnetHostNPort BACnetHostNPort
	ClosingTag      BACnetClosingTag

	// Arguments.
	TagNumber uint8
}

var _ BACnetHostNPortEnclosed = (*_BACnetHostNPortEnclosed)(nil)

// NewBACnetHostNPortEnclosed factory function for _BACnetHostNPortEnclosed
func NewBACnetHostNPortEnclosed(openingTag BACnetOpeningTag, bacnetHostNPort BACnetHostNPort, closingTag BACnetClosingTag, tagNumber uint8) *_BACnetHostNPortEnclosed {
	if openingTag == nil {
		panic("openingTag of type BACnetOpeningTag for BACnetHostNPortEnclosed must not be nil")
	}
	if bacnetHostNPort == nil {
		panic("bacnetHostNPort of type BACnetHostNPort for BACnetHostNPortEnclosed must not be nil")
	}
	if closingTag == nil {
		panic("closingTag of type BACnetClosingTag for BACnetHostNPortEnclosed must not be nil")
	}
	return &_BACnetHostNPortEnclosed{OpeningTag: openingTag, BacnetHostNPort: bacnetHostNPort, ClosingTag: closingTag, TagNumber: tagNumber}
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetHostNPortEnclosedBuilder is a builder for BACnetHostNPortEnclosed
type BACnetHostNPortEnclosedBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(openingTag BACnetOpeningTag, bacnetHostNPort BACnetHostNPort, closingTag BACnetClosingTag) BACnetHostNPortEnclosedBuilder
	// WithOpeningTag adds OpeningTag (property field)
	WithOpeningTag(BACnetOpeningTag) BACnetHostNPortEnclosedBuilder
	// WithOpeningTagBuilder adds OpeningTag (property field) which is build by the builder
	WithOpeningTagBuilder(func(BACnetOpeningTagBuilder) BACnetOpeningTagBuilder) BACnetHostNPortEnclosedBuilder
	// WithBacnetHostNPort adds BacnetHostNPort (property field)
	WithBacnetHostNPort(BACnetHostNPort) BACnetHostNPortEnclosedBuilder
	// WithBacnetHostNPortBuilder adds BacnetHostNPort (property field) which is build by the builder
	WithBacnetHostNPortBuilder(func(BACnetHostNPortBuilder) BACnetHostNPortBuilder) BACnetHostNPortEnclosedBuilder
	// WithClosingTag adds ClosingTag (property field)
	WithClosingTag(BACnetClosingTag) BACnetHostNPortEnclosedBuilder
	// WithClosingTagBuilder adds ClosingTag (property field) which is build by the builder
	WithClosingTagBuilder(func(BACnetClosingTagBuilder) BACnetClosingTagBuilder) BACnetHostNPortEnclosedBuilder
	// WithArgTagNumber sets a parser argument
	WithArgTagNumber(uint8) BACnetHostNPortEnclosedBuilder
	// Build builds the BACnetHostNPortEnclosed or returns an error if something is wrong
	Build() (BACnetHostNPortEnclosed, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetHostNPortEnclosed
}

// NewBACnetHostNPortEnclosedBuilder() creates a BACnetHostNPortEnclosedBuilder
func NewBACnetHostNPortEnclosedBuilder() BACnetHostNPortEnclosedBuilder {
	return &_BACnetHostNPortEnclosedBuilder{_BACnetHostNPortEnclosed: new(_BACnetHostNPortEnclosed)}
}

type _BACnetHostNPortEnclosedBuilder struct {
	*_BACnetHostNPortEnclosed

	err *utils.MultiError
}

var _ (BACnetHostNPortEnclosedBuilder) = (*_BACnetHostNPortEnclosedBuilder)(nil)

func (b *_BACnetHostNPortEnclosedBuilder) WithMandatoryFields(openingTag BACnetOpeningTag, bacnetHostNPort BACnetHostNPort, closingTag BACnetClosingTag) BACnetHostNPortEnclosedBuilder {
	return b.WithOpeningTag(openingTag).WithBacnetHostNPort(bacnetHostNPort).WithClosingTag(closingTag)
}

func (b *_BACnetHostNPortEnclosedBuilder) WithOpeningTag(openingTag BACnetOpeningTag) BACnetHostNPortEnclosedBuilder {
	b.OpeningTag = openingTag
	return b
}

func (b *_BACnetHostNPortEnclosedBuilder) WithOpeningTagBuilder(builderSupplier func(BACnetOpeningTagBuilder) BACnetOpeningTagBuilder) BACnetHostNPortEnclosedBuilder {
	builder := builderSupplier(b.OpeningTag.CreateBACnetOpeningTagBuilder())
	var err error
	b.OpeningTag, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "BACnetOpeningTagBuilder failed"))
	}
	return b
}

func (b *_BACnetHostNPortEnclosedBuilder) WithBacnetHostNPort(bacnetHostNPort BACnetHostNPort) BACnetHostNPortEnclosedBuilder {
	b.BacnetHostNPort = bacnetHostNPort
	return b
}

func (b *_BACnetHostNPortEnclosedBuilder) WithBacnetHostNPortBuilder(builderSupplier func(BACnetHostNPortBuilder) BACnetHostNPortBuilder) BACnetHostNPortEnclosedBuilder {
	builder := builderSupplier(b.BacnetHostNPort.CreateBACnetHostNPortBuilder())
	var err error
	b.BacnetHostNPort, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "BACnetHostNPortBuilder failed"))
	}
	return b
}

func (b *_BACnetHostNPortEnclosedBuilder) WithClosingTag(closingTag BACnetClosingTag) BACnetHostNPortEnclosedBuilder {
	b.ClosingTag = closingTag
	return b
}

func (b *_BACnetHostNPortEnclosedBuilder) WithClosingTagBuilder(builderSupplier func(BACnetClosingTagBuilder) BACnetClosingTagBuilder) BACnetHostNPortEnclosedBuilder {
	builder := builderSupplier(b.ClosingTag.CreateBACnetClosingTagBuilder())
	var err error
	b.ClosingTag, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "BACnetClosingTagBuilder failed"))
	}
	return b
}

func (b *_BACnetHostNPortEnclosedBuilder) WithArgTagNumber(tagNumber uint8) BACnetHostNPortEnclosedBuilder {
	b.TagNumber = tagNumber
	return b
}

func (b *_BACnetHostNPortEnclosedBuilder) Build() (BACnetHostNPortEnclosed, error) {
	if b.OpeningTag == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'openingTag' not set"))
	}
	if b.BacnetHostNPort == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'bacnetHostNPort' not set"))
	}
	if b.ClosingTag == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'closingTag' not set"))
	}
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._BACnetHostNPortEnclosed.deepCopy(), nil
}

func (b *_BACnetHostNPortEnclosedBuilder) MustBuild() BACnetHostNPortEnclosed {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetHostNPortEnclosedBuilder) DeepCopy() any {
	_copy := b.CreateBACnetHostNPortEnclosedBuilder().(*_BACnetHostNPortEnclosedBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateBACnetHostNPortEnclosedBuilder creates a BACnetHostNPortEnclosedBuilder
func (b *_BACnetHostNPortEnclosed) CreateBACnetHostNPortEnclosedBuilder() BACnetHostNPortEnclosedBuilder {
	if b == nil {
		return NewBACnetHostNPortEnclosedBuilder()
	}
	return &_BACnetHostNPortEnclosedBuilder{_BACnetHostNPortEnclosed: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetHostNPortEnclosed) GetOpeningTag() BACnetOpeningTag {
	return m.OpeningTag
}

func (m *_BACnetHostNPortEnclosed) GetBacnetHostNPort() BACnetHostNPort {
	return m.BacnetHostNPort
}

func (m *_BACnetHostNPortEnclosed) GetClosingTag() BACnetClosingTag {
	return m.ClosingTag
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetHostNPortEnclosed(structType any) BACnetHostNPortEnclosed {
	if casted, ok := structType.(BACnetHostNPortEnclosed); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetHostNPortEnclosed); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetHostNPortEnclosed) GetTypeName() string {
	return "BACnetHostNPortEnclosed"
}

func (m *_BACnetHostNPortEnclosed) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(0)

	// Simple field (openingTag)
	lengthInBits += m.OpeningTag.GetLengthInBits(ctx)

	// Simple field (bacnetHostNPort)
	lengthInBits += m.BacnetHostNPort.GetLengthInBits(ctx)

	// Simple field (closingTag)
	lengthInBits += m.ClosingTag.GetLengthInBits(ctx)

	return lengthInBits
}

func (m *_BACnetHostNPortEnclosed) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func BACnetHostNPortEnclosedParse(ctx context.Context, theBytes []byte, tagNumber uint8) (BACnetHostNPortEnclosed, error) {
	return BACnetHostNPortEnclosedParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes), tagNumber)
}

func BACnetHostNPortEnclosedParseWithBufferProducer(tagNumber uint8) func(ctx context.Context, readBuffer utils.ReadBuffer) (BACnetHostNPortEnclosed, error) {
	return func(ctx context.Context, readBuffer utils.ReadBuffer) (BACnetHostNPortEnclosed, error) {
		return BACnetHostNPortEnclosedParseWithBuffer(ctx, readBuffer, tagNumber)
	}
}

func BACnetHostNPortEnclosedParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer, tagNumber uint8) (BACnetHostNPortEnclosed, error) {
	v, err := (&_BACnetHostNPortEnclosed{TagNumber: tagNumber}).parse(ctx, readBuffer, tagNumber)
	if err != nil {
		return nil, err
	}
	return v, nil
}

func (m *_BACnetHostNPortEnclosed) parse(ctx context.Context, readBuffer utils.ReadBuffer, tagNumber uint8) (__bACnetHostNPortEnclosed BACnetHostNPortEnclosed, err error) {
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetHostNPortEnclosed"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetHostNPortEnclosed")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	openingTag, err := ReadSimpleField[BACnetOpeningTag](ctx, "openingTag", ReadComplex[BACnetOpeningTag](BACnetOpeningTagParseWithBufferProducer((uint8)(tagNumber)), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'openingTag' field"))
	}
	m.OpeningTag = openingTag

	bacnetHostNPort, err := ReadSimpleField[BACnetHostNPort](ctx, "bacnetHostNPort", ReadComplex[BACnetHostNPort](BACnetHostNPortParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'bacnetHostNPort' field"))
	}
	m.BacnetHostNPort = bacnetHostNPort

	closingTag, err := ReadSimpleField[BACnetClosingTag](ctx, "closingTag", ReadComplex[BACnetClosingTag](BACnetClosingTagParseWithBufferProducer((uint8)(tagNumber)), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'closingTag' field"))
	}
	m.ClosingTag = closingTag

	if closeErr := readBuffer.CloseContext("BACnetHostNPortEnclosed"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetHostNPortEnclosed")
	}

	return m, nil
}

func (m *_BACnetHostNPortEnclosed) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetHostNPortEnclosed) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pushErr := writeBuffer.PushContext("BACnetHostNPortEnclosed"); pushErr != nil {
		return errors.Wrap(pushErr, "Error pushing for BACnetHostNPortEnclosed")
	}

	if err := WriteSimpleField[BACnetOpeningTag](ctx, "openingTag", m.GetOpeningTag(), WriteComplex[BACnetOpeningTag](writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'openingTag' field")
	}

	if err := WriteSimpleField[BACnetHostNPort](ctx, "bacnetHostNPort", m.GetBacnetHostNPort(), WriteComplex[BACnetHostNPort](writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'bacnetHostNPort' field")
	}

	if err := WriteSimpleField[BACnetClosingTag](ctx, "closingTag", m.GetClosingTag(), WriteComplex[BACnetClosingTag](writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'closingTag' field")
	}

	if popErr := writeBuffer.PopContext("BACnetHostNPortEnclosed"); popErr != nil {
		return errors.Wrap(popErr, "Error popping for BACnetHostNPortEnclosed")
	}
	return nil
}

////
// Arguments Getter

func (m *_BACnetHostNPortEnclosed) GetTagNumber() uint8 {
	return m.TagNumber
}

//
////

func (m *_BACnetHostNPortEnclosed) IsBACnetHostNPortEnclosed() {}

func (m *_BACnetHostNPortEnclosed) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetHostNPortEnclosed) deepCopy() *_BACnetHostNPortEnclosed {
	if m == nil {
		return nil
	}
	_BACnetHostNPortEnclosedCopy := &_BACnetHostNPortEnclosed{
		utils.DeepCopy[BACnetOpeningTag](m.OpeningTag),
		utils.DeepCopy[BACnetHostNPort](m.BacnetHostNPort),
		utils.DeepCopy[BACnetClosingTag](m.ClosingTag),
		m.TagNumber,
	}
	return _BACnetHostNPortEnclosedCopy
}

func (m *_BACnetHostNPortEnclosed) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
