/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetFaultParameterFaultOutOfRange is the corresponding interface of BACnetFaultParameterFaultOutOfRange
type BACnetFaultParameterFaultOutOfRange interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetFaultParameter
	// GetOpeningTag returns OpeningTag (property field)
	GetOpeningTag() BACnetOpeningTag
	// GetMinNormalValue returns MinNormalValue (property field)
	GetMinNormalValue() BACnetFaultParameterFaultOutOfRangeMinNormalValue
	// GetMaxNormalValue returns MaxNormalValue (property field)
	GetMaxNormalValue() BACnetFaultParameterFaultOutOfRangeMaxNormalValue
	// GetClosingTag returns ClosingTag (property field)
	GetClosingTag() BACnetClosingTag
	// IsBACnetFaultParameterFaultOutOfRange is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetFaultParameterFaultOutOfRange()
	// CreateBuilder creates a BACnetFaultParameterFaultOutOfRangeBuilder
	CreateBACnetFaultParameterFaultOutOfRangeBuilder() BACnetFaultParameterFaultOutOfRangeBuilder
}

// _BACnetFaultParameterFaultOutOfRange is the data-structure of this message
type _BACnetFaultParameterFaultOutOfRange struct {
	BACnetFaultParameterContract
	OpeningTag     BACnetOpeningTag
	MinNormalValue BACnetFaultParameterFaultOutOfRangeMinNormalValue
	MaxNormalValue BACnetFaultParameterFaultOutOfRangeMaxNormalValue
	ClosingTag     BACnetClosingTag
}

var _ BACnetFaultParameterFaultOutOfRange = (*_BACnetFaultParameterFaultOutOfRange)(nil)
var _ BACnetFaultParameterRequirements = (*_BACnetFaultParameterFaultOutOfRange)(nil)

// NewBACnetFaultParameterFaultOutOfRange factory function for _BACnetFaultParameterFaultOutOfRange
func NewBACnetFaultParameterFaultOutOfRange(peekedTagHeader BACnetTagHeader, openingTag BACnetOpeningTag, minNormalValue BACnetFaultParameterFaultOutOfRangeMinNormalValue, maxNormalValue BACnetFaultParameterFaultOutOfRangeMaxNormalValue, closingTag BACnetClosingTag) *_BACnetFaultParameterFaultOutOfRange {
	if openingTag == nil {
		panic("openingTag of type BACnetOpeningTag for BACnetFaultParameterFaultOutOfRange must not be nil")
	}
	if minNormalValue == nil {
		panic("minNormalValue of type BACnetFaultParameterFaultOutOfRangeMinNormalValue for BACnetFaultParameterFaultOutOfRange must not be nil")
	}
	if maxNormalValue == nil {
		panic("maxNormalValue of type BACnetFaultParameterFaultOutOfRangeMaxNormalValue for BACnetFaultParameterFaultOutOfRange must not be nil")
	}
	if closingTag == nil {
		panic("closingTag of type BACnetClosingTag for BACnetFaultParameterFaultOutOfRange must not be nil")
	}
	_result := &_BACnetFaultParameterFaultOutOfRange{
		BACnetFaultParameterContract: NewBACnetFaultParameter(peekedTagHeader),
		OpeningTag:                   openingTag,
		MinNormalValue:               minNormalValue,
		MaxNormalValue:               maxNormalValue,
		ClosingTag:                   closingTag,
	}
	_result.BACnetFaultParameterContract.(*_BACnetFaultParameter)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetFaultParameterFaultOutOfRangeBuilder is a builder for BACnetFaultParameterFaultOutOfRange
type BACnetFaultParameterFaultOutOfRangeBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(openingTag BACnetOpeningTag, minNormalValue BACnetFaultParameterFaultOutOfRangeMinNormalValue, maxNormalValue BACnetFaultParameterFaultOutOfRangeMaxNormalValue, closingTag BACnetClosingTag) BACnetFaultParameterFaultOutOfRangeBuilder
	// WithOpeningTag adds OpeningTag (property field)
	WithOpeningTag(BACnetOpeningTag) BACnetFaultParameterFaultOutOfRangeBuilder
	// WithOpeningTagBuilder adds OpeningTag (property field) which is build by the builder
	WithOpeningTagBuilder(func(BACnetOpeningTagBuilder) BACnetOpeningTagBuilder) BACnetFaultParameterFaultOutOfRangeBuilder
	// WithMinNormalValue adds MinNormalValue (property field)
	WithMinNormalValue(BACnetFaultParameterFaultOutOfRangeMinNormalValue) BACnetFaultParameterFaultOutOfRangeBuilder
	// WithMinNormalValueBuilder adds MinNormalValue (property field) which is build by the builder
	WithMinNormalValueBuilder(func(BACnetFaultParameterFaultOutOfRangeMinNormalValueBuilder) BACnetFaultParameterFaultOutOfRangeMinNormalValueBuilder) BACnetFaultParameterFaultOutOfRangeBuilder
	// WithMaxNormalValue adds MaxNormalValue (property field)
	WithMaxNormalValue(BACnetFaultParameterFaultOutOfRangeMaxNormalValue) BACnetFaultParameterFaultOutOfRangeBuilder
	// WithMaxNormalValueBuilder adds MaxNormalValue (property field) which is build by the builder
	WithMaxNormalValueBuilder(func(BACnetFaultParameterFaultOutOfRangeMaxNormalValueBuilder) BACnetFaultParameterFaultOutOfRangeMaxNormalValueBuilder) BACnetFaultParameterFaultOutOfRangeBuilder
	// WithClosingTag adds ClosingTag (property field)
	WithClosingTag(BACnetClosingTag) BACnetFaultParameterFaultOutOfRangeBuilder
	// WithClosingTagBuilder adds ClosingTag (property field) which is build by the builder
	WithClosingTagBuilder(func(BACnetClosingTagBuilder) BACnetClosingTagBuilder) BACnetFaultParameterFaultOutOfRangeBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetFaultParameterBuilder
	// Build builds the BACnetFaultParameterFaultOutOfRange or returns an error if something is wrong
	Build() (BACnetFaultParameterFaultOutOfRange, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetFaultParameterFaultOutOfRange
}

// NewBACnetFaultParameterFaultOutOfRangeBuilder() creates a BACnetFaultParameterFaultOutOfRangeBuilder
func NewBACnetFaultParameterFaultOutOfRangeBuilder() BACnetFaultParameterFaultOutOfRangeBuilder {
	return &_BACnetFaultParameterFaultOutOfRangeBuilder{_BACnetFaultParameterFaultOutOfRange: new(_BACnetFaultParameterFaultOutOfRange)}
}

type _BACnetFaultParameterFaultOutOfRangeBuilder struct {
	*_BACnetFaultParameterFaultOutOfRange

	parentBuilder *_BACnetFaultParameterBuilder

	err *utils.MultiError
}

var _ (BACnetFaultParameterFaultOutOfRangeBuilder) = (*_BACnetFaultParameterFaultOutOfRangeBuilder)(nil)

func (b *_BACnetFaultParameterFaultOutOfRangeBuilder) setParent(contract BACnetFaultParameterContract) {
	b.BACnetFaultParameterContract = contract
	contract.(*_BACnetFaultParameter)._SubType = b._BACnetFaultParameterFaultOutOfRange
}

func (b *_BACnetFaultParameterFaultOutOfRangeBuilder) WithMandatoryFields(openingTag BACnetOpeningTag, minNormalValue BACnetFaultParameterFaultOutOfRangeMinNormalValue, maxNormalValue BACnetFaultParameterFaultOutOfRangeMaxNormalValue, closingTag BACnetClosingTag) BACnetFaultParameterFaultOutOfRangeBuilder {
	return b.WithOpeningTag(openingTag).WithMinNormalValue(minNormalValue).WithMaxNormalValue(maxNormalValue).WithClosingTag(closingTag)
}

func (b *_BACnetFaultParameterFaultOutOfRangeBuilder) WithOpeningTag(openingTag BACnetOpeningTag) BACnetFaultParameterFaultOutOfRangeBuilder {
	b.OpeningTag = openingTag
	return b
}

func (b *_BACnetFaultParameterFaultOutOfRangeBuilder) WithOpeningTagBuilder(builderSupplier func(BACnetOpeningTagBuilder) BACnetOpeningTagBuilder) BACnetFaultParameterFaultOutOfRangeBuilder {
	builder := builderSupplier(b.OpeningTag.CreateBACnetOpeningTagBuilder())
	var err error
	b.OpeningTag, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "BACnetOpeningTagBuilder failed"))
	}
	return b
}

func (b *_BACnetFaultParameterFaultOutOfRangeBuilder) WithMinNormalValue(minNormalValue BACnetFaultParameterFaultOutOfRangeMinNormalValue) BACnetFaultParameterFaultOutOfRangeBuilder {
	b.MinNormalValue = minNormalValue
	return b
}

func (b *_BACnetFaultParameterFaultOutOfRangeBuilder) WithMinNormalValueBuilder(builderSupplier func(BACnetFaultParameterFaultOutOfRangeMinNormalValueBuilder) BACnetFaultParameterFaultOutOfRangeMinNormalValueBuilder) BACnetFaultParameterFaultOutOfRangeBuilder {
	builder := builderSupplier(b.MinNormalValue.CreateBACnetFaultParameterFaultOutOfRangeMinNormalValueBuilder())
	var err error
	b.MinNormalValue, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "BACnetFaultParameterFaultOutOfRangeMinNormalValueBuilder failed"))
	}
	return b
}

func (b *_BACnetFaultParameterFaultOutOfRangeBuilder) WithMaxNormalValue(maxNormalValue BACnetFaultParameterFaultOutOfRangeMaxNormalValue) BACnetFaultParameterFaultOutOfRangeBuilder {
	b.MaxNormalValue = maxNormalValue
	return b
}

func (b *_BACnetFaultParameterFaultOutOfRangeBuilder) WithMaxNormalValueBuilder(builderSupplier func(BACnetFaultParameterFaultOutOfRangeMaxNormalValueBuilder) BACnetFaultParameterFaultOutOfRangeMaxNormalValueBuilder) BACnetFaultParameterFaultOutOfRangeBuilder {
	builder := builderSupplier(b.MaxNormalValue.CreateBACnetFaultParameterFaultOutOfRangeMaxNormalValueBuilder())
	var err error
	b.MaxNormalValue, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "BACnetFaultParameterFaultOutOfRangeMaxNormalValueBuilder failed"))
	}
	return b
}

func (b *_BACnetFaultParameterFaultOutOfRangeBuilder) WithClosingTag(closingTag BACnetClosingTag) BACnetFaultParameterFaultOutOfRangeBuilder {
	b.ClosingTag = closingTag
	return b
}

func (b *_BACnetFaultParameterFaultOutOfRangeBuilder) WithClosingTagBuilder(builderSupplier func(BACnetClosingTagBuilder) BACnetClosingTagBuilder) BACnetFaultParameterFaultOutOfRangeBuilder {
	builder := builderSupplier(b.ClosingTag.CreateBACnetClosingTagBuilder())
	var err error
	b.ClosingTag, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "BACnetClosingTagBuilder failed"))
	}
	return b
}

func (b *_BACnetFaultParameterFaultOutOfRangeBuilder) Build() (BACnetFaultParameterFaultOutOfRange, error) {
	if b.OpeningTag == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'openingTag' not set"))
	}
	if b.MinNormalValue == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'minNormalValue' not set"))
	}
	if b.MaxNormalValue == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'maxNormalValue' not set"))
	}
	if b.ClosingTag == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'closingTag' not set"))
	}
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._BACnetFaultParameterFaultOutOfRange.deepCopy(), nil
}

func (b *_BACnetFaultParameterFaultOutOfRangeBuilder) MustBuild() BACnetFaultParameterFaultOutOfRange {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetFaultParameterFaultOutOfRangeBuilder) Done() BACnetFaultParameterBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetFaultParameterBuilder().(*_BACnetFaultParameterBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetFaultParameterFaultOutOfRangeBuilder) buildForBACnetFaultParameter() (BACnetFaultParameter, error) {
	return b.Build()
}

func (b *_BACnetFaultParameterFaultOutOfRangeBuilder) DeepCopy() any {
	_copy := b.CreateBACnetFaultParameterFaultOutOfRangeBuilder().(*_BACnetFaultParameterFaultOutOfRangeBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateBACnetFaultParameterFaultOutOfRangeBuilder creates a BACnetFaultParameterFaultOutOfRangeBuilder
func (b *_BACnetFaultParameterFaultOutOfRange) CreateBACnetFaultParameterFaultOutOfRangeBuilder() BACnetFaultParameterFaultOutOfRangeBuilder {
	if b == nil {
		return NewBACnetFaultParameterFaultOutOfRangeBuilder()
	}
	return &_BACnetFaultParameterFaultOutOfRangeBuilder{_BACnetFaultParameterFaultOutOfRange: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetFaultParameterFaultOutOfRange) GetParent() BACnetFaultParameterContract {
	return m.BACnetFaultParameterContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetFaultParameterFaultOutOfRange) GetOpeningTag() BACnetOpeningTag {
	return m.OpeningTag
}

func (m *_BACnetFaultParameterFaultOutOfRange) GetMinNormalValue() BACnetFaultParameterFaultOutOfRangeMinNormalValue {
	return m.MinNormalValue
}

func (m *_BACnetFaultParameterFaultOutOfRange) GetMaxNormalValue() BACnetFaultParameterFaultOutOfRangeMaxNormalValue {
	return m.MaxNormalValue
}

func (m *_BACnetFaultParameterFaultOutOfRange) GetClosingTag() BACnetClosingTag {
	return m.ClosingTag
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetFaultParameterFaultOutOfRange(structType any) BACnetFaultParameterFaultOutOfRange {
	if casted, ok := structType.(BACnetFaultParameterFaultOutOfRange); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetFaultParameterFaultOutOfRange); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetFaultParameterFaultOutOfRange) GetTypeName() string {
	return "BACnetFaultParameterFaultOutOfRange"
}

func (m *_BACnetFaultParameterFaultOutOfRange) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetFaultParameterContract.(*_BACnetFaultParameter).getLengthInBits(ctx))

	// Simple field (openingTag)
	lengthInBits += m.OpeningTag.GetLengthInBits(ctx)

	// Simple field (minNormalValue)
	lengthInBits += m.MinNormalValue.GetLengthInBits(ctx)

	// Simple field (maxNormalValue)
	lengthInBits += m.MaxNormalValue.GetLengthInBits(ctx)

	// Simple field (closingTag)
	lengthInBits += m.ClosingTag.GetLengthInBits(ctx)

	return lengthInBits
}

func (m *_BACnetFaultParameterFaultOutOfRange) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetFaultParameterFaultOutOfRange) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetFaultParameter) (__bACnetFaultParameterFaultOutOfRange BACnetFaultParameterFaultOutOfRange, err error) {
	m.BACnetFaultParameterContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetFaultParameterFaultOutOfRange"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetFaultParameterFaultOutOfRange")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	openingTag, err := ReadSimpleField[BACnetOpeningTag](ctx, "openingTag", ReadComplex[BACnetOpeningTag](BACnetOpeningTagParseWithBufferProducer((uint8)(uint8(6))), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'openingTag' field"))
	}
	m.OpeningTag = openingTag

	minNormalValue, err := ReadSimpleField[BACnetFaultParameterFaultOutOfRangeMinNormalValue](ctx, "minNormalValue", ReadComplex[BACnetFaultParameterFaultOutOfRangeMinNormalValue](BACnetFaultParameterFaultOutOfRangeMinNormalValueParseWithBufferProducer[BACnetFaultParameterFaultOutOfRangeMinNormalValue]((uint8)(uint8(0))), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'minNormalValue' field"))
	}
	m.MinNormalValue = minNormalValue

	maxNormalValue, err := ReadSimpleField[BACnetFaultParameterFaultOutOfRangeMaxNormalValue](ctx, "maxNormalValue", ReadComplex[BACnetFaultParameterFaultOutOfRangeMaxNormalValue](BACnetFaultParameterFaultOutOfRangeMaxNormalValueParseWithBufferProducer[BACnetFaultParameterFaultOutOfRangeMaxNormalValue]((uint8)(uint8(0))), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'maxNormalValue' field"))
	}
	m.MaxNormalValue = maxNormalValue

	closingTag, err := ReadSimpleField[BACnetClosingTag](ctx, "closingTag", ReadComplex[BACnetClosingTag](BACnetClosingTagParseWithBufferProducer((uint8)(uint8(6))), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'closingTag' field"))
	}
	m.ClosingTag = closingTag

	if closeErr := readBuffer.CloseContext("BACnetFaultParameterFaultOutOfRange"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetFaultParameterFaultOutOfRange")
	}

	return m, nil
}

func (m *_BACnetFaultParameterFaultOutOfRange) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetFaultParameterFaultOutOfRange) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetFaultParameterFaultOutOfRange"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetFaultParameterFaultOutOfRange")
		}

		if err := WriteSimpleField[BACnetOpeningTag](ctx, "openingTag", m.GetOpeningTag(), WriteComplex[BACnetOpeningTag](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'openingTag' field")
		}

		if err := WriteSimpleField[BACnetFaultParameterFaultOutOfRangeMinNormalValue](ctx, "minNormalValue", m.GetMinNormalValue(), WriteComplex[BACnetFaultParameterFaultOutOfRangeMinNormalValue](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'minNormalValue' field")
		}

		if err := WriteSimpleField[BACnetFaultParameterFaultOutOfRangeMaxNormalValue](ctx, "maxNormalValue", m.GetMaxNormalValue(), WriteComplex[BACnetFaultParameterFaultOutOfRangeMaxNormalValue](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'maxNormalValue' field")
		}

		if err := WriteSimpleField[BACnetClosingTag](ctx, "closingTag", m.GetClosingTag(), WriteComplex[BACnetClosingTag](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'closingTag' field")
		}

		if popErr := writeBuffer.PopContext("BACnetFaultParameterFaultOutOfRange"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetFaultParameterFaultOutOfRange")
		}
		return nil
	}
	return m.BACnetFaultParameterContract.(*_BACnetFaultParameter).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetFaultParameterFaultOutOfRange) IsBACnetFaultParameterFaultOutOfRange() {}

func (m *_BACnetFaultParameterFaultOutOfRange) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetFaultParameterFaultOutOfRange) deepCopy() *_BACnetFaultParameterFaultOutOfRange {
	if m == nil {
		return nil
	}
	_BACnetFaultParameterFaultOutOfRangeCopy := &_BACnetFaultParameterFaultOutOfRange{
		m.BACnetFaultParameterContract.(*_BACnetFaultParameter).deepCopy(),
		utils.DeepCopy[BACnetOpeningTag](m.OpeningTag),
		utils.DeepCopy[BACnetFaultParameterFaultOutOfRangeMinNormalValue](m.MinNormalValue),
		utils.DeepCopy[BACnetFaultParameterFaultOutOfRangeMaxNormalValue](m.MaxNormalValue),
		utils.DeepCopy[BACnetClosingTag](m.ClosingTag),
	}
	_BACnetFaultParameterFaultOutOfRangeCopy.BACnetFaultParameterContract.(*_BACnetFaultParameter)._SubType = m
	return _BACnetFaultParameterFaultOutOfRangeCopy
}

func (m *_BACnetFaultParameterFaultOutOfRange) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
