/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetFaultParameterFaultListed is the corresponding interface of BACnetFaultParameterFaultListed
type BACnetFaultParameterFaultListed interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetFaultParameter
	// GetOpeningTag returns OpeningTag (property field)
	GetOpeningTag() BACnetOpeningTag
	// GetFaultListReference returns FaultListReference (property field)
	GetFaultListReference() BACnetDeviceObjectPropertyReferenceEnclosed
	// GetClosingTag returns ClosingTag (property field)
	GetClosingTag() BACnetClosingTag
	// IsBACnetFaultParameterFaultListed is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetFaultParameterFaultListed()
	// CreateBuilder creates a BACnetFaultParameterFaultListedBuilder
	CreateBACnetFaultParameterFaultListedBuilder() BACnetFaultParameterFaultListedBuilder
}

// _BACnetFaultParameterFaultListed is the data-structure of this message
type _BACnetFaultParameterFaultListed struct {
	BACnetFaultParameterContract
	OpeningTag         BACnetOpeningTag
	FaultListReference BACnetDeviceObjectPropertyReferenceEnclosed
	ClosingTag         BACnetClosingTag
}

var _ BACnetFaultParameterFaultListed = (*_BACnetFaultParameterFaultListed)(nil)
var _ BACnetFaultParameterRequirements = (*_BACnetFaultParameterFaultListed)(nil)

// NewBACnetFaultParameterFaultListed factory function for _BACnetFaultParameterFaultListed
func NewBACnetFaultParameterFaultListed(peekedTagHeader BACnetTagHeader, openingTag BACnetOpeningTag, faultListReference BACnetDeviceObjectPropertyReferenceEnclosed, closingTag BACnetClosingTag) *_BACnetFaultParameterFaultListed {
	if openingTag == nil {
		panic("openingTag of type BACnetOpeningTag for BACnetFaultParameterFaultListed must not be nil")
	}
	if faultListReference == nil {
		panic("faultListReference of type BACnetDeviceObjectPropertyReferenceEnclosed for BACnetFaultParameterFaultListed must not be nil")
	}
	if closingTag == nil {
		panic("closingTag of type BACnetClosingTag for BACnetFaultParameterFaultListed must not be nil")
	}
	_result := &_BACnetFaultParameterFaultListed{
		BACnetFaultParameterContract: NewBACnetFaultParameter(peekedTagHeader),
		OpeningTag:                   openingTag,
		FaultListReference:           faultListReference,
		ClosingTag:                   closingTag,
	}
	_result.BACnetFaultParameterContract.(*_BACnetFaultParameter)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetFaultParameterFaultListedBuilder is a builder for BACnetFaultParameterFaultListed
type BACnetFaultParameterFaultListedBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(openingTag BACnetOpeningTag, faultListReference BACnetDeviceObjectPropertyReferenceEnclosed, closingTag BACnetClosingTag) BACnetFaultParameterFaultListedBuilder
	// WithOpeningTag adds OpeningTag (property field)
	WithOpeningTag(BACnetOpeningTag) BACnetFaultParameterFaultListedBuilder
	// WithOpeningTagBuilder adds OpeningTag (property field) which is build by the builder
	WithOpeningTagBuilder(func(BACnetOpeningTagBuilder) BACnetOpeningTagBuilder) BACnetFaultParameterFaultListedBuilder
	// WithFaultListReference adds FaultListReference (property field)
	WithFaultListReference(BACnetDeviceObjectPropertyReferenceEnclosed) BACnetFaultParameterFaultListedBuilder
	// WithFaultListReferenceBuilder adds FaultListReference (property field) which is build by the builder
	WithFaultListReferenceBuilder(func(BACnetDeviceObjectPropertyReferenceEnclosedBuilder) BACnetDeviceObjectPropertyReferenceEnclosedBuilder) BACnetFaultParameterFaultListedBuilder
	// WithClosingTag adds ClosingTag (property field)
	WithClosingTag(BACnetClosingTag) BACnetFaultParameterFaultListedBuilder
	// WithClosingTagBuilder adds ClosingTag (property field) which is build by the builder
	WithClosingTagBuilder(func(BACnetClosingTagBuilder) BACnetClosingTagBuilder) BACnetFaultParameterFaultListedBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetFaultParameterBuilder
	// Build builds the BACnetFaultParameterFaultListed or returns an error if something is wrong
	Build() (BACnetFaultParameterFaultListed, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetFaultParameterFaultListed
}

// NewBACnetFaultParameterFaultListedBuilder() creates a BACnetFaultParameterFaultListedBuilder
func NewBACnetFaultParameterFaultListedBuilder() BACnetFaultParameterFaultListedBuilder {
	return &_BACnetFaultParameterFaultListedBuilder{_BACnetFaultParameterFaultListed: new(_BACnetFaultParameterFaultListed)}
}

type _BACnetFaultParameterFaultListedBuilder struct {
	*_BACnetFaultParameterFaultListed

	parentBuilder *_BACnetFaultParameterBuilder

	err *utils.MultiError
}

var _ (BACnetFaultParameterFaultListedBuilder) = (*_BACnetFaultParameterFaultListedBuilder)(nil)

func (b *_BACnetFaultParameterFaultListedBuilder) setParent(contract BACnetFaultParameterContract) {
	b.BACnetFaultParameterContract = contract
	contract.(*_BACnetFaultParameter)._SubType = b._BACnetFaultParameterFaultListed
}

func (b *_BACnetFaultParameterFaultListedBuilder) WithMandatoryFields(openingTag BACnetOpeningTag, faultListReference BACnetDeviceObjectPropertyReferenceEnclosed, closingTag BACnetClosingTag) BACnetFaultParameterFaultListedBuilder {
	return b.WithOpeningTag(openingTag).WithFaultListReference(faultListReference).WithClosingTag(closingTag)
}

func (b *_BACnetFaultParameterFaultListedBuilder) WithOpeningTag(openingTag BACnetOpeningTag) BACnetFaultParameterFaultListedBuilder {
	b.OpeningTag = openingTag
	return b
}

func (b *_BACnetFaultParameterFaultListedBuilder) WithOpeningTagBuilder(builderSupplier func(BACnetOpeningTagBuilder) BACnetOpeningTagBuilder) BACnetFaultParameterFaultListedBuilder {
	builder := builderSupplier(b.OpeningTag.CreateBACnetOpeningTagBuilder())
	var err error
	b.OpeningTag, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "BACnetOpeningTagBuilder failed"))
	}
	return b
}

func (b *_BACnetFaultParameterFaultListedBuilder) WithFaultListReference(faultListReference BACnetDeviceObjectPropertyReferenceEnclosed) BACnetFaultParameterFaultListedBuilder {
	b.FaultListReference = faultListReference
	return b
}

func (b *_BACnetFaultParameterFaultListedBuilder) WithFaultListReferenceBuilder(builderSupplier func(BACnetDeviceObjectPropertyReferenceEnclosedBuilder) BACnetDeviceObjectPropertyReferenceEnclosedBuilder) BACnetFaultParameterFaultListedBuilder {
	builder := builderSupplier(b.FaultListReference.CreateBACnetDeviceObjectPropertyReferenceEnclosedBuilder())
	var err error
	b.FaultListReference, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "BACnetDeviceObjectPropertyReferenceEnclosedBuilder failed"))
	}
	return b
}

func (b *_BACnetFaultParameterFaultListedBuilder) WithClosingTag(closingTag BACnetClosingTag) BACnetFaultParameterFaultListedBuilder {
	b.ClosingTag = closingTag
	return b
}

func (b *_BACnetFaultParameterFaultListedBuilder) WithClosingTagBuilder(builderSupplier func(BACnetClosingTagBuilder) BACnetClosingTagBuilder) BACnetFaultParameterFaultListedBuilder {
	builder := builderSupplier(b.ClosingTag.CreateBACnetClosingTagBuilder())
	var err error
	b.ClosingTag, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "BACnetClosingTagBuilder failed"))
	}
	return b
}

func (b *_BACnetFaultParameterFaultListedBuilder) Build() (BACnetFaultParameterFaultListed, error) {
	if b.OpeningTag == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'openingTag' not set"))
	}
	if b.FaultListReference == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'faultListReference' not set"))
	}
	if b.ClosingTag == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'closingTag' not set"))
	}
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._BACnetFaultParameterFaultListed.deepCopy(), nil
}

func (b *_BACnetFaultParameterFaultListedBuilder) MustBuild() BACnetFaultParameterFaultListed {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetFaultParameterFaultListedBuilder) Done() BACnetFaultParameterBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetFaultParameterBuilder().(*_BACnetFaultParameterBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetFaultParameterFaultListedBuilder) buildForBACnetFaultParameter() (BACnetFaultParameter, error) {
	return b.Build()
}

func (b *_BACnetFaultParameterFaultListedBuilder) DeepCopy() any {
	_copy := b.CreateBACnetFaultParameterFaultListedBuilder().(*_BACnetFaultParameterFaultListedBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateBACnetFaultParameterFaultListedBuilder creates a BACnetFaultParameterFaultListedBuilder
func (b *_BACnetFaultParameterFaultListed) CreateBACnetFaultParameterFaultListedBuilder() BACnetFaultParameterFaultListedBuilder {
	if b == nil {
		return NewBACnetFaultParameterFaultListedBuilder()
	}
	return &_BACnetFaultParameterFaultListedBuilder{_BACnetFaultParameterFaultListed: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetFaultParameterFaultListed) GetParent() BACnetFaultParameterContract {
	return m.BACnetFaultParameterContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetFaultParameterFaultListed) GetOpeningTag() BACnetOpeningTag {
	return m.OpeningTag
}

func (m *_BACnetFaultParameterFaultListed) GetFaultListReference() BACnetDeviceObjectPropertyReferenceEnclosed {
	return m.FaultListReference
}

func (m *_BACnetFaultParameterFaultListed) GetClosingTag() BACnetClosingTag {
	return m.ClosingTag
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetFaultParameterFaultListed(structType any) BACnetFaultParameterFaultListed {
	if casted, ok := structType.(BACnetFaultParameterFaultListed); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetFaultParameterFaultListed); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetFaultParameterFaultListed) GetTypeName() string {
	return "BACnetFaultParameterFaultListed"
}

func (m *_BACnetFaultParameterFaultListed) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetFaultParameterContract.(*_BACnetFaultParameter).getLengthInBits(ctx))

	// Simple field (openingTag)
	lengthInBits += m.OpeningTag.GetLengthInBits(ctx)

	// Simple field (faultListReference)
	lengthInBits += m.FaultListReference.GetLengthInBits(ctx)

	// Simple field (closingTag)
	lengthInBits += m.ClosingTag.GetLengthInBits(ctx)

	return lengthInBits
}

func (m *_BACnetFaultParameterFaultListed) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetFaultParameterFaultListed) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetFaultParameter) (__bACnetFaultParameterFaultListed BACnetFaultParameterFaultListed, err error) {
	m.BACnetFaultParameterContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetFaultParameterFaultListed"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetFaultParameterFaultListed")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	openingTag, err := ReadSimpleField[BACnetOpeningTag](ctx, "openingTag", ReadComplex[BACnetOpeningTag](BACnetOpeningTagParseWithBufferProducer((uint8)(uint8(7))), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'openingTag' field"))
	}
	m.OpeningTag = openingTag

	faultListReference, err := ReadSimpleField[BACnetDeviceObjectPropertyReferenceEnclosed](ctx, "faultListReference", ReadComplex[BACnetDeviceObjectPropertyReferenceEnclosed](BACnetDeviceObjectPropertyReferenceEnclosedParseWithBufferProducer((uint8)(uint8(0))), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'faultListReference' field"))
	}
	m.FaultListReference = faultListReference

	closingTag, err := ReadSimpleField[BACnetClosingTag](ctx, "closingTag", ReadComplex[BACnetClosingTag](BACnetClosingTagParseWithBufferProducer((uint8)(uint8(7))), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'closingTag' field"))
	}
	m.ClosingTag = closingTag

	if closeErr := readBuffer.CloseContext("BACnetFaultParameterFaultListed"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetFaultParameterFaultListed")
	}

	return m, nil
}

func (m *_BACnetFaultParameterFaultListed) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetFaultParameterFaultListed) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetFaultParameterFaultListed"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetFaultParameterFaultListed")
		}

		if err := WriteSimpleField[BACnetOpeningTag](ctx, "openingTag", m.GetOpeningTag(), WriteComplex[BACnetOpeningTag](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'openingTag' field")
		}

		if err := WriteSimpleField[BACnetDeviceObjectPropertyReferenceEnclosed](ctx, "faultListReference", m.GetFaultListReference(), WriteComplex[BACnetDeviceObjectPropertyReferenceEnclosed](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'faultListReference' field")
		}

		if err := WriteSimpleField[BACnetClosingTag](ctx, "closingTag", m.GetClosingTag(), WriteComplex[BACnetClosingTag](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'closingTag' field")
		}

		if popErr := writeBuffer.PopContext("BACnetFaultParameterFaultListed"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetFaultParameterFaultListed")
		}
		return nil
	}
	return m.BACnetFaultParameterContract.(*_BACnetFaultParameter).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetFaultParameterFaultListed) IsBACnetFaultParameterFaultListed() {}

func (m *_BACnetFaultParameterFaultListed) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetFaultParameterFaultListed) deepCopy() *_BACnetFaultParameterFaultListed {
	if m == nil {
		return nil
	}
	_BACnetFaultParameterFaultListedCopy := &_BACnetFaultParameterFaultListed{
		m.BACnetFaultParameterContract.(*_BACnetFaultParameter).deepCopy(),
		utils.DeepCopy[BACnetOpeningTag](m.OpeningTag),
		utils.DeepCopy[BACnetDeviceObjectPropertyReferenceEnclosed](m.FaultListReference),
		utils.DeepCopy[BACnetClosingTag](m.ClosingTag),
	}
	_BACnetFaultParameterFaultListedCopy.BACnetFaultParameterContract.(*_BACnetFaultParameter)._SubType = m
	return _BACnetFaultParameterFaultListedCopy
}

func (m *_BACnetFaultParameterFaultListed) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
