/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetFaultParameterFaultExtendedParametersEntryEnumerated is the corresponding interface of BACnetFaultParameterFaultExtendedParametersEntryEnumerated
type BACnetFaultParameterFaultExtendedParametersEntryEnumerated interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetFaultParameterFaultExtendedParametersEntry
	// GetEnumeratedValue returns EnumeratedValue (property field)
	GetEnumeratedValue() BACnetApplicationTagEnumerated
	// IsBACnetFaultParameterFaultExtendedParametersEntryEnumerated is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetFaultParameterFaultExtendedParametersEntryEnumerated()
	// CreateBuilder creates a BACnetFaultParameterFaultExtendedParametersEntryEnumeratedBuilder
	CreateBACnetFaultParameterFaultExtendedParametersEntryEnumeratedBuilder() BACnetFaultParameterFaultExtendedParametersEntryEnumeratedBuilder
}

// _BACnetFaultParameterFaultExtendedParametersEntryEnumerated is the data-structure of this message
type _BACnetFaultParameterFaultExtendedParametersEntryEnumerated struct {
	BACnetFaultParameterFaultExtendedParametersEntryContract
	EnumeratedValue BACnetApplicationTagEnumerated
}

var _ BACnetFaultParameterFaultExtendedParametersEntryEnumerated = (*_BACnetFaultParameterFaultExtendedParametersEntryEnumerated)(nil)
var _ BACnetFaultParameterFaultExtendedParametersEntryRequirements = (*_BACnetFaultParameterFaultExtendedParametersEntryEnumerated)(nil)

// NewBACnetFaultParameterFaultExtendedParametersEntryEnumerated factory function for _BACnetFaultParameterFaultExtendedParametersEntryEnumerated
func NewBACnetFaultParameterFaultExtendedParametersEntryEnumerated(peekedTagHeader BACnetTagHeader, enumeratedValue BACnetApplicationTagEnumerated) *_BACnetFaultParameterFaultExtendedParametersEntryEnumerated {
	if enumeratedValue == nil {
		panic("enumeratedValue of type BACnetApplicationTagEnumerated for BACnetFaultParameterFaultExtendedParametersEntryEnumerated must not be nil")
	}
	_result := &_BACnetFaultParameterFaultExtendedParametersEntryEnumerated{
		BACnetFaultParameterFaultExtendedParametersEntryContract: NewBACnetFaultParameterFaultExtendedParametersEntry(peekedTagHeader),
		EnumeratedValue: enumeratedValue,
	}
	_result.BACnetFaultParameterFaultExtendedParametersEntryContract.(*_BACnetFaultParameterFaultExtendedParametersEntry)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetFaultParameterFaultExtendedParametersEntryEnumeratedBuilder is a builder for BACnetFaultParameterFaultExtendedParametersEntryEnumerated
type BACnetFaultParameterFaultExtendedParametersEntryEnumeratedBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(enumeratedValue BACnetApplicationTagEnumerated) BACnetFaultParameterFaultExtendedParametersEntryEnumeratedBuilder
	// WithEnumeratedValue adds EnumeratedValue (property field)
	WithEnumeratedValue(BACnetApplicationTagEnumerated) BACnetFaultParameterFaultExtendedParametersEntryEnumeratedBuilder
	// WithEnumeratedValueBuilder adds EnumeratedValue (property field) which is build by the builder
	WithEnumeratedValueBuilder(func(BACnetApplicationTagEnumeratedBuilder) BACnetApplicationTagEnumeratedBuilder) BACnetFaultParameterFaultExtendedParametersEntryEnumeratedBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetFaultParameterFaultExtendedParametersEntryBuilder
	// Build builds the BACnetFaultParameterFaultExtendedParametersEntryEnumerated or returns an error if something is wrong
	Build() (BACnetFaultParameterFaultExtendedParametersEntryEnumerated, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetFaultParameterFaultExtendedParametersEntryEnumerated
}

// NewBACnetFaultParameterFaultExtendedParametersEntryEnumeratedBuilder() creates a BACnetFaultParameterFaultExtendedParametersEntryEnumeratedBuilder
func NewBACnetFaultParameterFaultExtendedParametersEntryEnumeratedBuilder() BACnetFaultParameterFaultExtendedParametersEntryEnumeratedBuilder {
	return &_BACnetFaultParameterFaultExtendedParametersEntryEnumeratedBuilder{_BACnetFaultParameterFaultExtendedParametersEntryEnumerated: new(_BACnetFaultParameterFaultExtendedParametersEntryEnumerated)}
}

type _BACnetFaultParameterFaultExtendedParametersEntryEnumeratedBuilder struct {
	*_BACnetFaultParameterFaultExtendedParametersEntryEnumerated

	parentBuilder *_BACnetFaultParameterFaultExtendedParametersEntryBuilder

	err *utils.MultiError
}

var _ (BACnetFaultParameterFaultExtendedParametersEntryEnumeratedBuilder) = (*_BACnetFaultParameterFaultExtendedParametersEntryEnumeratedBuilder)(nil)

func (b *_BACnetFaultParameterFaultExtendedParametersEntryEnumeratedBuilder) setParent(contract BACnetFaultParameterFaultExtendedParametersEntryContract) {
	b.BACnetFaultParameterFaultExtendedParametersEntryContract = contract
	contract.(*_BACnetFaultParameterFaultExtendedParametersEntry)._SubType = b._BACnetFaultParameterFaultExtendedParametersEntryEnumerated
}

func (b *_BACnetFaultParameterFaultExtendedParametersEntryEnumeratedBuilder) WithMandatoryFields(enumeratedValue BACnetApplicationTagEnumerated) BACnetFaultParameterFaultExtendedParametersEntryEnumeratedBuilder {
	return b.WithEnumeratedValue(enumeratedValue)
}

func (b *_BACnetFaultParameterFaultExtendedParametersEntryEnumeratedBuilder) WithEnumeratedValue(enumeratedValue BACnetApplicationTagEnumerated) BACnetFaultParameterFaultExtendedParametersEntryEnumeratedBuilder {
	b.EnumeratedValue = enumeratedValue
	return b
}

func (b *_BACnetFaultParameterFaultExtendedParametersEntryEnumeratedBuilder) WithEnumeratedValueBuilder(builderSupplier func(BACnetApplicationTagEnumeratedBuilder) BACnetApplicationTagEnumeratedBuilder) BACnetFaultParameterFaultExtendedParametersEntryEnumeratedBuilder {
	builder := builderSupplier(b.EnumeratedValue.CreateBACnetApplicationTagEnumeratedBuilder())
	var err error
	b.EnumeratedValue, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "BACnetApplicationTagEnumeratedBuilder failed"))
	}
	return b
}

func (b *_BACnetFaultParameterFaultExtendedParametersEntryEnumeratedBuilder) Build() (BACnetFaultParameterFaultExtendedParametersEntryEnumerated, error) {
	if b.EnumeratedValue == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'enumeratedValue' not set"))
	}
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._BACnetFaultParameterFaultExtendedParametersEntryEnumerated.deepCopy(), nil
}

func (b *_BACnetFaultParameterFaultExtendedParametersEntryEnumeratedBuilder) MustBuild() BACnetFaultParameterFaultExtendedParametersEntryEnumerated {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetFaultParameterFaultExtendedParametersEntryEnumeratedBuilder) Done() BACnetFaultParameterFaultExtendedParametersEntryBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetFaultParameterFaultExtendedParametersEntryBuilder().(*_BACnetFaultParameterFaultExtendedParametersEntryBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetFaultParameterFaultExtendedParametersEntryEnumeratedBuilder) buildForBACnetFaultParameterFaultExtendedParametersEntry() (BACnetFaultParameterFaultExtendedParametersEntry, error) {
	return b.Build()
}

func (b *_BACnetFaultParameterFaultExtendedParametersEntryEnumeratedBuilder) DeepCopy() any {
	_copy := b.CreateBACnetFaultParameterFaultExtendedParametersEntryEnumeratedBuilder().(*_BACnetFaultParameterFaultExtendedParametersEntryEnumeratedBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateBACnetFaultParameterFaultExtendedParametersEntryEnumeratedBuilder creates a BACnetFaultParameterFaultExtendedParametersEntryEnumeratedBuilder
func (b *_BACnetFaultParameterFaultExtendedParametersEntryEnumerated) CreateBACnetFaultParameterFaultExtendedParametersEntryEnumeratedBuilder() BACnetFaultParameterFaultExtendedParametersEntryEnumeratedBuilder {
	if b == nil {
		return NewBACnetFaultParameterFaultExtendedParametersEntryEnumeratedBuilder()
	}
	return &_BACnetFaultParameterFaultExtendedParametersEntryEnumeratedBuilder{_BACnetFaultParameterFaultExtendedParametersEntryEnumerated: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetFaultParameterFaultExtendedParametersEntryEnumerated) GetParent() BACnetFaultParameterFaultExtendedParametersEntryContract {
	return m.BACnetFaultParameterFaultExtendedParametersEntryContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetFaultParameterFaultExtendedParametersEntryEnumerated) GetEnumeratedValue() BACnetApplicationTagEnumerated {
	return m.EnumeratedValue
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetFaultParameterFaultExtendedParametersEntryEnumerated(structType any) BACnetFaultParameterFaultExtendedParametersEntryEnumerated {
	if casted, ok := structType.(BACnetFaultParameterFaultExtendedParametersEntryEnumerated); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetFaultParameterFaultExtendedParametersEntryEnumerated); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetFaultParameterFaultExtendedParametersEntryEnumerated) GetTypeName() string {
	return "BACnetFaultParameterFaultExtendedParametersEntryEnumerated"
}

func (m *_BACnetFaultParameterFaultExtendedParametersEntryEnumerated) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetFaultParameterFaultExtendedParametersEntryContract.(*_BACnetFaultParameterFaultExtendedParametersEntry).getLengthInBits(ctx))

	// Simple field (enumeratedValue)
	lengthInBits += m.EnumeratedValue.GetLengthInBits(ctx)

	return lengthInBits
}

func (m *_BACnetFaultParameterFaultExtendedParametersEntryEnumerated) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetFaultParameterFaultExtendedParametersEntryEnumerated) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetFaultParameterFaultExtendedParametersEntry) (__bACnetFaultParameterFaultExtendedParametersEntryEnumerated BACnetFaultParameterFaultExtendedParametersEntryEnumerated, err error) {
	m.BACnetFaultParameterFaultExtendedParametersEntryContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetFaultParameterFaultExtendedParametersEntryEnumerated"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetFaultParameterFaultExtendedParametersEntryEnumerated")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	enumeratedValue, err := ReadSimpleField[BACnetApplicationTagEnumerated](ctx, "enumeratedValue", ReadComplex[BACnetApplicationTagEnumerated](BACnetApplicationTagParseWithBufferProducer[BACnetApplicationTagEnumerated](), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'enumeratedValue' field"))
	}
	m.EnumeratedValue = enumeratedValue

	if closeErr := readBuffer.CloseContext("BACnetFaultParameterFaultExtendedParametersEntryEnumerated"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetFaultParameterFaultExtendedParametersEntryEnumerated")
	}

	return m, nil
}

func (m *_BACnetFaultParameterFaultExtendedParametersEntryEnumerated) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetFaultParameterFaultExtendedParametersEntryEnumerated) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetFaultParameterFaultExtendedParametersEntryEnumerated"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetFaultParameterFaultExtendedParametersEntryEnumerated")
		}

		if err := WriteSimpleField[BACnetApplicationTagEnumerated](ctx, "enumeratedValue", m.GetEnumeratedValue(), WriteComplex[BACnetApplicationTagEnumerated](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'enumeratedValue' field")
		}

		if popErr := writeBuffer.PopContext("BACnetFaultParameterFaultExtendedParametersEntryEnumerated"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetFaultParameterFaultExtendedParametersEntryEnumerated")
		}
		return nil
	}
	return m.BACnetFaultParameterFaultExtendedParametersEntryContract.(*_BACnetFaultParameterFaultExtendedParametersEntry).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetFaultParameterFaultExtendedParametersEntryEnumerated) IsBACnetFaultParameterFaultExtendedParametersEntryEnumerated() {
}

func (m *_BACnetFaultParameterFaultExtendedParametersEntryEnumerated) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetFaultParameterFaultExtendedParametersEntryEnumerated) deepCopy() *_BACnetFaultParameterFaultExtendedParametersEntryEnumerated {
	if m == nil {
		return nil
	}
	_BACnetFaultParameterFaultExtendedParametersEntryEnumeratedCopy := &_BACnetFaultParameterFaultExtendedParametersEntryEnumerated{
		m.BACnetFaultParameterFaultExtendedParametersEntryContract.(*_BACnetFaultParameterFaultExtendedParametersEntry).deepCopy(),
		utils.DeepCopy[BACnetApplicationTagEnumerated](m.EnumeratedValue),
	}
	_BACnetFaultParameterFaultExtendedParametersEntryEnumeratedCopy.BACnetFaultParameterFaultExtendedParametersEntryContract.(*_BACnetFaultParameterFaultExtendedParametersEntry)._SubType = m
	return _BACnetFaultParameterFaultExtendedParametersEntryEnumeratedCopy
}

func (m *_BACnetFaultParameterFaultExtendedParametersEntryEnumerated) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
