/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetEventParameterChangeOfBitstringListOfBitstringValues is the corresponding interface of BACnetEventParameterChangeOfBitstringListOfBitstringValues
type BACnetEventParameterChangeOfBitstringListOfBitstringValues interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	// GetOpeningTag returns OpeningTag (property field)
	GetOpeningTag() BACnetOpeningTag
	// GetListOfBitstringValues returns ListOfBitstringValues (property field)
	GetListOfBitstringValues() []BACnetApplicationTagBitString
	// GetClosingTag returns ClosingTag (property field)
	GetClosingTag() BACnetClosingTag
	// IsBACnetEventParameterChangeOfBitstringListOfBitstringValues is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetEventParameterChangeOfBitstringListOfBitstringValues()
	// CreateBuilder creates a BACnetEventParameterChangeOfBitstringListOfBitstringValuesBuilder
	CreateBACnetEventParameterChangeOfBitstringListOfBitstringValuesBuilder() BACnetEventParameterChangeOfBitstringListOfBitstringValuesBuilder
}

// _BACnetEventParameterChangeOfBitstringListOfBitstringValues is the data-structure of this message
type _BACnetEventParameterChangeOfBitstringListOfBitstringValues struct {
	OpeningTag            BACnetOpeningTag
	ListOfBitstringValues []BACnetApplicationTagBitString
	ClosingTag            BACnetClosingTag

	// Arguments.
	TagNumber uint8
}

var _ BACnetEventParameterChangeOfBitstringListOfBitstringValues = (*_BACnetEventParameterChangeOfBitstringListOfBitstringValues)(nil)

// NewBACnetEventParameterChangeOfBitstringListOfBitstringValues factory function for _BACnetEventParameterChangeOfBitstringListOfBitstringValues
func NewBACnetEventParameterChangeOfBitstringListOfBitstringValues(openingTag BACnetOpeningTag, listOfBitstringValues []BACnetApplicationTagBitString, closingTag BACnetClosingTag, tagNumber uint8) *_BACnetEventParameterChangeOfBitstringListOfBitstringValues {
	if openingTag == nil {
		panic("openingTag of type BACnetOpeningTag for BACnetEventParameterChangeOfBitstringListOfBitstringValues must not be nil")
	}
	if closingTag == nil {
		panic("closingTag of type BACnetClosingTag for BACnetEventParameterChangeOfBitstringListOfBitstringValues must not be nil")
	}
	return &_BACnetEventParameterChangeOfBitstringListOfBitstringValues{OpeningTag: openingTag, ListOfBitstringValues: listOfBitstringValues, ClosingTag: closingTag, TagNumber: tagNumber}
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetEventParameterChangeOfBitstringListOfBitstringValuesBuilder is a builder for BACnetEventParameterChangeOfBitstringListOfBitstringValues
type BACnetEventParameterChangeOfBitstringListOfBitstringValuesBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(openingTag BACnetOpeningTag, listOfBitstringValues []BACnetApplicationTagBitString, closingTag BACnetClosingTag) BACnetEventParameterChangeOfBitstringListOfBitstringValuesBuilder
	// WithOpeningTag adds OpeningTag (property field)
	WithOpeningTag(BACnetOpeningTag) BACnetEventParameterChangeOfBitstringListOfBitstringValuesBuilder
	// WithOpeningTagBuilder adds OpeningTag (property field) which is build by the builder
	WithOpeningTagBuilder(func(BACnetOpeningTagBuilder) BACnetOpeningTagBuilder) BACnetEventParameterChangeOfBitstringListOfBitstringValuesBuilder
	// WithListOfBitstringValues adds ListOfBitstringValues (property field)
	WithListOfBitstringValues(...BACnetApplicationTagBitString) BACnetEventParameterChangeOfBitstringListOfBitstringValuesBuilder
	// WithClosingTag adds ClosingTag (property field)
	WithClosingTag(BACnetClosingTag) BACnetEventParameterChangeOfBitstringListOfBitstringValuesBuilder
	// WithClosingTagBuilder adds ClosingTag (property field) which is build by the builder
	WithClosingTagBuilder(func(BACnetClosingTagBuilder) BACnetClosingTagBuilder) BACnetEventParameterChangeOfBitstringListOfBitstringValuesBuilder
	// WithArgTagNumber sets a parser argument
	WithArgTagNumber(uint8) BACnetEventParameterChangeOfBitstringListOfBitstringValuesBuilder
	// Build builds the BACnetEventParameterChangeOfBitstringListOfBitstringValues or returns an error if something is wrong
	Build() (BACnetEventParameterChangeOfBitstringListOfBitstringValues, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetEventParameterChangeOfBitstringListOfBitstringValues
}

// NewBACnetEventParameterChangeOfBitstringListOfBitstringValuesBuilder() creates a BACnetEventParameterChangeOfBitstringListOfBitstringValuesBuilder
func NewBACnetEventParameterChangeOfBitstringListOfBitstringValuesBuilder() BACnetEventParameterChangeOfBitstringListOfBitstringValuesBuilder {
	return &_BACnetEventParameterChangeOfBitstringListOfBitstringValuesBuilder{_BACnetEventParameterChangeOfBitstringListOfBitstringValues: new(_BACnetEventParameterChangeOfBitstringListOfBitstringValues)}
}

type _BACnetEventParameterChangeOfBitstringListOfBitstringValuesBuilder struct {
	*_BACnetEventParameterChangeOfBitstringListOfBitstringValues

	err *utils.MultiError
}

var _ (BACnetEventParameterChangeOfBitstringListOfBitstringValuesBuilder) = (*_BACnetEventParameterChangeOfBitstringListOfBitstringValuesBuilder)(nil)

func (b *_BACnetEventParameterChangeOfBitstringListOfBitstringValuesBuilder) WithMandatoryFields(openingTag BACnetOpeningTag, listOfBitstringValues []BACnetApplicationTagBitString, closingTag BACnetClosingTag) BACnetEventParameterChangeOfBitstringListOfBitstringValuesBuilder {
	return b.WithOpeningTag(openingTag).WithListOfBitstringValues(listOfBitstringValues...).WithClosingTag(closingTag)
}

func (b *_BACnetEventParameterChangeOfBitstringListOfBitstringValuesBuilder) WithOpeningTag(openingTag BACnetOpeningTag) BACnetEventParameterChangeOfBitstringListOfBitstringValuesBuilder {
	b.OpeningTag = openingTag
	return b
}

func (b *_BACnetEventParameterChangeOfBitstringListOfBitstringValuesBuilder) WithOpeningTagBuilder(builderSupplier func(BACnetOpeningTagBuilder) BACnetOpeningTagBuilder) BACnetEventParameterChangeOfBitstringListOfBitstringValuesBuilder {
	builder := builderSupplier(b.OpeningTag.CreateBACnetOpeningTagBuilder())
	var err error
	b.OpeningTag, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "BACnetOpeningTagBuilder failed"))
	}
	return b
}

func (b *_BACnetEventParameterChangeOfBitstringListOfBitstringValuesBuilder) WithListOfBitstringValues(listOfBitstringValues ...BACnetApplicationTagBitString) BACnetEventParameterChangeOfBitstringListOfBitstringValuesBuilder {
	b.ListOfBitstringValues = listOfBitstringValues
	return b
}

func (b *_BACnetEventParameterChangeOfBitstringListOfBitstringValuesBuilder) WithClosingTag(closingTag BACnetClosingTag) BACnetEventParameterChangeOfBitstringListOfBitstringValuesBuilder {
	b.ClosingTag = closingTag
	return b
}

func (b *_BACnetEventParameterChangeOfBitstringListOfBitstringValuesBuilder) WithClosingTagBuilder(builderSupplier func(BACnetClosingTagBuilder) BACnetClosingTagBuilder) BACnetEventParameterChangeOfBitstringListOfBitstringValuesBuilder {
	builder := builderSupplier(b.ClosingTag.CreateBACnetClosingTagBuilder())
	var err error
	b.ClosingTag, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "BACnetClosingTagBuilder failed"))
	}
	return b
}

func (b *_BACnetEventParameterChangeOfBitstringListOfBitstringValuesBuilder) WithArgTagNumber(tagNumber uint8) BACnetEventParameterChangeOfBitstringListOfBitstringValuesBuilder {
	b.TagNumber = tagNumber
	return b
}

func (b *_BACnetEventParameterChangeOfBitstringListOfBitstringValuesBuilder) Build() (BACnetEventParameterChangeOfBitstringListOfBitstringValues, error) {
	if b.OpeningTag == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'openingTag' not set"))
	}
	if b.ClosingTag == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'closingTag' not set"))
	}
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._BACnetEventParameterChangeOfBitstringListOfBitstringValues.deepCopy(), nil
}

func (b *_BACnetEventParameterChangeOfBitstringListOfBitstringValuesBuilder) MustBuild() BACnetEventParameterChangeOfBitstringListOfBitstringValues {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetEventParameterChangeOfBitstringListOfBitstringValuesBuilder) DeepCopy() any {
	_copy := b.CreateBACnetEventParameterChangeOfBitstringListOfBitstringValuesBuilder().(*_BACnetEventParameterChangeOfBitstringListOfBitstringValuesBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateBACnetEventParameterChangeOfBitstringListOfBitstringValuesBuilder creates a BACnetEventParameterChangeOfBitstringListOfBitstringValuesBuilder
func (b *_BACnetEventParameterChangeOfBitstringListOfBitstringValues) CreateBACnetEventParameterChangeOfBitstringListOfBitstringValuesBuilder() BACnetEventParameterChangeOfBitstringListOfBitstringValuesBuilder {
	if b == nil {
		return NewBACnetEventParameterChangeOfBitstringListOfBitstringValuesBuilder()
	}
	return &_BACnetEventParameterChangeOfBitstringListOfBitstringValuesBuilder{_BACnetEventParameterChangeOfBitstringListOfBitstringValues: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetEventParameterChangeOfBitstringListOfBitstringValues) GetOpeningTag() BACnetOpeningTag {
	return m.OpeningTag
}

func (m *_BACnetEventParameterChangeOfBitstringListOfBitstringValues) GetListOfBitstringValues() []BACnetApplicationTagBitString {
	return m.ListOfBitstringValues
}

func (m *_BACnetEventParameterChangeOfBitstringListOfBitstringValues) GetClosingTag() BACnetClosingTag {
	return m.ClosingTag
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetEventParameterChangeOfBitstringListOfBitstringValues(structType any) BACnetEventParameterChangeOfBitstringListOfBitstringValues {
	if casted, ok := structType.(BACnetEventParameterChangeOfBitstringListOfBitstringValues); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetEventParameterChangeOfBitstringListOfBitstringValues); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetEventParameterChangeOfBitstringListOfBitstringValues) GetTypeName() string {
	return "BACnetEventParameterChangeOfBitstringListOfBitstringValues"
}

func (m *_BACnetEventParameterChangeOfBitstringListOfBitstringValues) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(0)

	// Simple field (openingTag)
	lengthInBits += m.OpeningTag.GetLengthInBits(ctx)

	// Array field
	if len(m.ListOfBitstringValues) > 0 {
		for _, element := range m.ListOfBitstringValues {
			lengthInBits += element.GetLengthInBits(ctx)
		}
	}

	// Simple field (closingTag)
	lengthInBits += m.ClosingTag.GetLengthInBits(ctx)

	return lengthInBits
}

func (m *_BACnetEventParameterChangeOfBitstringListOfBitstringValues) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func BACnetEventParameterChangeOfBitstringListOfBitstringValuesParse(ctx context.Context, theBytes []byte, tagNumber uint8) (BACnetEventParameterChangeOfBitstringListOfBitstringValues, error) {
	return BACnetEventParameterChangeOfBitstringListOfBitstringValuesParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes), tagNumber)
}

func BACnetEventParameterChangeOfBitstringListOfBitstringValuesParseWithBufferProducer(tagNumber uint8) func(ctx context.Context, readBuffer utils.ReadBuffer) (BACnetEventParameterChangeOfBitstringListOfBitstringValues, error) {
	return func(ctx context.Context, readBuffer utils.ReadBuffer) (BACnetEventParameterChangeOfBitstringListOfBitstringValues, error) {
		return BACnetEventParameterChangeOfBitstringListOfBitstringValuesParseWithBuffer(ctx, readBuffer, tagNumber)
	}
}

func BACnetEventParameterChangeOfBitstringListOfBitstringValuesParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer, tagNumber uint8) (BACnetEventParameterChangeOfBitstringListOfBitstringValues, error) {
	v, err := (&_BACnetEventParameterChangeOfBitstringListOfBitstringValues{TagNumber: tagNumber}).parse(ctx, readBuffer, tagNumber)
	if err != nil {
		return nil, err
	}
	return v, nil
}

func (m *_BACnetEventParameterChangeOfBitstringListOfBitstringValues) parse(ctx context.Context, readBuffer utils.ReadBuffer, tagNumber uint8) (__bACnetEventParameterChangeOfBitstringListOfBitstringValues BACnetEventParameterChangeOfBitstringListOfBitstringValues, err error) {
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetEventParameterChangeOfBitstringListOfBitstringValues"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetEventParameterChangeOfBitstringListOfBitstringValues")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	openingTag, err := ReadSimpleField[BACnetOpeningTag](ctx, "openingTag", ReadComplex[BACnetOpeningTag](BACnetOpeningTagParseWithBufferProducer((uint8)(tagNumber)), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'openingTag' field"))
	}
	m.OpeningTag = openingTag

	listOfBitstringValues, err := ReadTerminatedArrayField[BACnetApplicationTagBitString](ctx, "listOfBitstringValues", ReadComplex[BACnetApplicationTagBitString](BACnetApplicationTagParseWithBufferProducer[BACnetApplicationTagBitString](), readBuffer), IsBACnetConstructedDataClosingTag(ctx, readBuffer, false, tagNumber))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'listOfBitstringValues' field"))
	}
	m.ListOfBitstringValues = listOfBitstringValues

	closingTag, err := ReadSimpleField[BACnetClosingTag](ctx, "closingTag", ReadComplex[BACnetClosingTag](BACnetClosingTagParseWithBufferProducer((uint8)(tagNumber)), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'closingTag' field"))
	}
	m.ClosingTag = closingTag

	if closeErr := readBuffer.CloseContext("BACnetEventParameterChangeOfBitstringListOfBitstringValues"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetEventParameterChangeOfBitstringListOfBitstringValues")
	}

	return m, nil
}

func (m *_BACnetEventParameterChangeOfBitstringListOfBitstringValues) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetEventParameterChangeOfBitstringListOfBitstringValues) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pushErr := writeBuffer.PushContext("BACnetEventParameterChangeOfBitstringListOfBitstringValues"); pushErr != nil {
		return errors.Wrap(pushErr, "Error pushing for BACnetEventParameterChangeOfBitstringListOfBitstringValues")
	}

	if err := WriteSimpleField[BACnetOpeningTag](ctx, "openingTag", m.GetOpeningTag(), WriteComplex[BACnetOpeningTag](writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'openingTag' field")
	}

	if err := WriteComplexTypeArrayField(ctx, "listOfBitstringValues", m.GetListOfBitstringValues(), writeBuffer); err != nil {
		return errors.Wrap(err, "Error serializing 'listOfBitstringValues' field")
	}

	if err := WriteSimpleField[BACnetClosingTag](ctx, "closingTag", m.GetClosingTag(), WriteComplex[BACnetClosingTag](writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'closingTag' field")
	}

	if popErr := writeBuffer.PopContext("BACnetEventParameterChangeOfBitstringListOfBitstringValues"); popErr != nil {
		return errors.Wrap(popErr, "Error popping for BACnetEventParameterChangeOfBitstringListOfBitstringValues")
	}
	return nil
}

////
// Arguments Getter

func (m *_BACnetEventParameterChangeOfBitstringListOfBitstringValues) GetTagNumber() uint8 {
	return m.TagNumber
}

//
////

func (m *_BACnetEventParameterChangeOfBitstringListOfBitstringValues) IsBACnetEventParameterChangeOfBitstringListOfBitstringValues() {
}

func (m *_BACnetEventParameterChangeOfBitstringListOfBitstringValues) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetEventParameterChangeOfBitstringListOfBitstringValues) deepCopy() *_BACnetEventParameterChangeOfBitstringListOfBitstringValues {
	if m == nil {
		return nil
	}
	_BACnetEventParameterChangeOfBitstringListOfBitstringValuesCopy := &_BACnetEventParameterChangeOfBitstringListOfBitstringValues{
		utils.DeepCopy[BACnetOpeningTag](m.OpeningTag),
		utils.DeepCopySlice[BACnetApplicationTagBitString, BACnetApplicationTagBitString](m.ListOfBitstringValues),
		utils.DeepCopy[BACnetClosingTag](m.ClosingTag),
		m.TagNumber,
	}
	return _BACnetEventParameterChangeOfBitstringListOfBitstringValuesCopy
}

func (m *_BACnetEventParameterChangeOfBitstringListOfBitstringValues) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
