/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetEventParameterAccessEvent is the corresponding interface of BACnetEventParameterAccessEvent
type BACnetEventParameterAccessEvent interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetEventParameter
	// GetOpeningTag returns OpeningTag (property field)
	GetOpeningTag() BACnetOpeningTag
	// GetListOfAccessEvents returns ListOfAccessEvents (property field)
	GetListOfAccessEvents() BACnetEventParameterAccessEventListOfAccessEvents
	// GetAccessEventTimeReference returns AccessEventTimeReference (property field)
	GetAccessEventTimeReference() BACnetDeviceObjectPropertyReferenceEnclosed
	// GetClosingTag returns ClosingTag (property field)
	GetClosingTag() BACnetClosingTag
	// IsBACnetEventParameterAccessEvent is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetEventParameterAccessEvent()
	// CreateBuilder creates a BACnetEventParameterAccessEventBuilder
	CreateBACnetEventParameterAccessEventBuilder() BACnetEventParameterAccessEventBuilder
}

// _BACnetEventParameterAccessEvent is the data-structure of this message
type _BACnetEventParameterAccessEvent struct {
	BACnetEventParameterContract
	OpeningTag               BACnetOpeningTag
	ListOfAccessEvents       BACnetEventParameterAccessEventListOfAccessEvents
	AccessEventTimeReference BACnetDeviceObjectPropertyReferenceEnclosed
	ClosingTag               BACnetClosingTag
}

var _ BACnetEventParameterAccessEvent = (*_BACnetEventParameterAccessEvent)(nil)
var _ BACnetEventParameterRequirements = (*_BACnetEventParameterAccessEvent)(nil)

// NewBACnetEventParameterAccessEvent factory function for _BACnetEventParameterAccessEvent
func NewBACnetEventParameterAccessEvent(peekedTagHeader BACnetTagHeader, openingTag BACnetOpeningTag, listOfAccessEvents BACnetEventParameterAccessEventListOfAccessEvents, accessEventTimeReference BACnetDeviceObjectPropertyReferenceEnclosed, closingTag BACnetClosingTag) *_BACnetEventParameterAccessEvent {
	if openingTag == nil {
		panic("openingTag of type BACnetOpeningTag for BACnetEventParameterAccessEvent must not be nil")
	}
	if listOfAccessEvents == nil {
		panic("listOfAccessEvents of type BACnetEventParameterAccessEventListOfAccessEvents for BACnetEventParameterAccessEvent must not be nil")
	}
	if accessEventTimeReference == nil {
		panic("accessEventTimeReference of type BACnetDeviceObjectPropertyReferenceEnclosed for BACnetEventParameterAccessEvent must not be nil")
	}
	if closingTag == nil {
		panic("closingTag of type BACnetClosingTag for BACnetEventParameterAccessEvent must not be nil")
	}
	_result := &_BACnetEventParameterAccessEvent{
		BACnetEventParameterContract: NewBACnetEventParameter(peekedTagHeader),
		OpeningTag:                   openingTag,
		ListOfAccessEvents:           listOfAccessEvents,
		AccessEventTimeReference:     accessEventTimeReference,
		ClosingTag:                   closingTag,
	}
	_result.BACnetEventParameterContract.(*_BACnetEventParameter)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetEventParameterAccessEventBuilder is a builder for BACnetEventParameterAccessEvent
type BACnetEventParameterAccessEventBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(openingTag BACnetOpeningTag, listOfAccessEvents BACnetEventParameterAccessEventListOfAccessEvents, accessEventTimeReference BACnetDeviceObjectPropertyReferenceEnclosed, closingTag BACnetClosingTag) BACnetEventParameterAccessEventBuilder
	// WithOpeningTag adds OpeningTag (property field)
	WithOpeningTag(BACnetOpeningTag) BACnetEventParameterAccessEventBuilder
	// WithOpeningTagBuilder adds OpeningTag (property field) which is build by the builder
	WithOpeningTagBuilder(func(BACnetOpeningTagBuilder) BACnetOpeningTagBuilder) BACnetEventParameterAccessEventBuilder
	// WithListOfAccessEvents adds ListOfAccessEvents (property field)
	WithListOfAccessEvents(BACnetEventParameterAccessEventListOfAccessEvents) BACnetEventParameterAccessEventBuilder
	// WithListOfAccessEventsBuilder adds ListOfAccessEvents (property field) which is build by the builder
	WithListOfAccessEventsBuilder(func(BACnetEventParameterAccessEventListOfAccessEventsBuilder) BACnetEventParameterAccessEventListOfAccessEventsBuilder) BACnetEventParameterAccessEventBuilder
	// WithAccessEventTimeReference adds AccessEventTimeReference (property field)
	WithAccessEventTimeReference(BACnetDeviceObjectPropertyReferenceEnclosed) BACnetEventParameterAccessEventBuilder
	// WithAccessEventTimeReferenceBuilder adds AccessEventTimeReference (property field) which is build by the builder
	WithAccessEventTimeReferenceBuilder(func(BACnetDeviceObjectPropertyReferenceEnclosedBuilder) BACnetDeviceObjectPropertyReferenceEnclosedBuilder) BACnetEventParameterAccessEventBuilder
	// WithClosingTag adds ClosingTag (property field)
	WithClosingTag(BACnetClosingTag) BACnetEventParameterAccessEventBuilder
	// WithClosingTagBuilder adds ClosingTag (property field) which is build by the builder
	WithClosingTagBuilder(func(BACnetClosingTagBuilder) BACnetClosingTagBuilder) BACnetEventParameterAccessEventBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetEventParameterBuilder
	// Build builds the BACnetEventParameterAccessEvent or returns an error if something is wrong
	Build() (BACnetEventParameterAccessEvent, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetEventParameterAccessEvent
}

// NewBACnetEventParameterAccessEventBuilder() creates a BACnetEventParameterAccessEventBuilder
func NewBACnetEventParameterAccessEventBuilder() BACnetEventParameterAccessEventBuilder {
	return &_BACnetEventParameterAccessEventBuilder{_BACnetEventParameterAccessEvent: new(_BACnetEventParameterAccessEvent)}
}

type _BACnetEventParameterAccessEventBuilder struct {
	*_BACnetEventParameterAccessEvent

	parentBuilder *_BACnetEventParameterBuilder

	err *utils.MultiError
}

var _ (BACnetEventParameterAccessEventBuilder) = (*_BACnetEventParameterAccessEventBuilder)(nil)

func (b *_BACnetEventParameterAccessEventBuilder) setParent(contract BACnetEventParameterContract) {
	b.BACnetEventParameterContract = contract
	contract.(*_BACnetEventParameter)._SubType = b._BACnetEventParameterAccessEvent
}

func (b *_BACnetEventParameterAccessEventBuilder) WithMandatoryFields(openingTag BACnetOpeningTag, listOfAccessEvents BACnetEventParameterAccessEventListOfAccessEvents, accessEventTimeReference BACnetDeviceObjectPropertyReferenceEnclosed, closingTag BACnetClosingTag) BACnetEventParameterAccessEventBuilder {
	return b.WithOpeningTag(openingTag).WithListOfAccessEvents(listOfAccessEvents).WithAccessEventTimeReference(accessEventTimeReference).WithClosingTag(closingTag)
}

func (b *_BACnetEventParameterAccessEventBuilder) WithOpeningTag(openingTag BACnetOpeningTag) BACnetEventParameterAccessEventBuilder {
	b.OpeningTag = openingTag
	return b
}

func (b *_BACnetEventParameterAccessEventBuilder) WithOpeningTagBuilder(builderSupplier func(BACnetOpeningTagBuilder) BACnetOpeningTagBuilder) BACnetEventParameterAccessEventBuilder {
	builder := builderSupplier(b.OpeningTag.CreateBACnetOpeningTagBuilder())
	var err error
	b.OpeningTag, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "BACnetOpeningTagBuilder failed"))
	}
	return b
}

func (b *_BACnetEventParameterAccessEventBuilder) WithListOfAccessEvents(listOfAccessEvents BACnetEventParameterAccessEventListOfAccessEvents) BACnetEventParameterAccessEventBuilder {
	b.ListOfAccessEvents = listOfAccessEvents
	return b
}

func (b *_BACnetEventParameterAccessEventBuilder) WithListOfAccessEventsBuilder(builderSupplier func(BACnetEventParameterAccessEventListOfAccessEventsBuilder) BACnetEventParameterAccessEventListOfAccessEventsBuilder) BACnetEventParameterAccessEventBuilder {
	builder := builderSupplier(b.ListOfAccessEvents.CreateBACnetEventParameterAccessEventListOfAccessEventsBuilder())
	var err error
	b.ListOfAccessEvents, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "BACnetEventParameterAccessEventListOfAccessEventsBuilder failed"))
	}
	return b
}

func (b *_BACnetEventParameterAccessEventBuilder) WithAccessEventTimeReference(accessEventTimeReference BACnetDeviceObjectPropertyReferenceEnclosed) BACnetEventParameterAccessEventBuilder {
	b.AccessEventTimeReference = accessEventTimeReference
	return b
}

func (b *_BACnetEventParameterAccessEventBuilder) WithAccessEventTimeReferenceBuilder(builderSupplier func(BACnetDeviceObjectPropertyReferenceEnclosedBuilder) BACnetDeviceObjectPropertyReferenceEnclosedBuilder) BACnetEventParameterAccessEventBuilder {
	builder := builderSupplier(b.AccessEventTimeReference.CreateBACnetDeviceObjectPropertyReferenceEnclosedBuilder())
	var err error
	b.AccessEventTimeReference, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "BACnetDeviceObjectPropertyReferenceEnclosedBuilder failed"))
	}
	return b
}

func (b *_BACnetEventParameterAccessEventBuilder) WithClosingTag(closingTag BACnetClosingTag) BACnetEventParameterAccessEventBuilder {
	b.ClosingTag = closingTag
	return b
}

func (b *_BACnetEventParameterAccessEventBuilder) WithClosingTagBuilder(builderSupplier func(BACnetClosingTagBuilder) BACnetClosingTagBuilder) BACnetEventParameterAccessEventBuilder {
	builder := builderSupplier(b.ClosingTag.CreateBACnetClosingTagBuilder())
	var err error
	b.ClosingTag, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "BACnetClosingTagBuilder failed"))
	}
	return b
}

func (b *_BACnetEventParameterAccessEventBuilder) Build() (BACnetEventParameterAccessEvent, error) {
	if b.OpeningTag == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'openingTag' not set"))
	}
	if b.ListOfAccessEvents == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'listOfAccessEvents' not set"))
	}
	if b.AccessEventTimeReference == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'accessEventTimeReference' not set"))
	}
	if b.ClosingTag == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'closingTag' not set"))
	}
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._BACnetEventParameterAccessEvent.deepCopy(), nil
}

func (b *_BACnetEventParameterAccessEventBuilder) MustBuild() BACnetEventParameterAccessEvent {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetEventParameterAccessEventBuilder) Done() BACnetEventParameterBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetEventParameterBuilder().(*_BACnetEventParameterBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetEventParameterAccessEventBuilder) buildForBACnetEventParameter() (BACnetEventParameter, error) {
	return b.Build()
}

func (b *_BACnetEventParameterAccessEventBuilder) DeepCopy() any {
	_copy := b.CreateBACnetEventParameterAccessEventBuilder().(*_BACnetEventParameterAccessEventBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateBACnetEventParameterAccessEventBuilder creates a BACnetEventParameterAccessEventBuilder
func (b *_BACnetEventParameterAccessEvent) CreateBACnetEventParameterAccessEventBuilder() BACnetEventParameterAccessEventBuilder {
	if b == nil {
		return NewBACnetEventParameterAccessEventBuilder()
	}
	return &_BACnetEventParameterAccessEventBuilder{_BACnetEventParameterAccessEvent: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetEventParameterAccessEvent) GetParent() BACnetEventParameterContract {
	return m.BACnetEventParameterContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetEventParameterAccessEvent) GetOpeningTag() BACnetOpeningTag {
	return m.OpeningTag
}

func (m *_BACnetEventParameterAccessEvent) GetListOfAccessEvents() BACnetEventParameterAccessEventListOfAccessEvents {
	return m.ListOfAccessEvents
}

func (m *_BACnetEventParameterAccessEvent) GetAccessEventTimeReference() BACnetDeviceObjectPropertyReferenceEnclosed {
	return m.AccessEventTimeReference
}

func (m *_BACnetEventParameterAccessEvent) GetClosingTag() BACnetClosingTag {
	return m.ClosingTag
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetEventParameterAccessEvent(structType any) BACnetEventParameterAccessEvent {
	if casted, ok := structType.(BACnetEventParameterAccessEvent); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetEventParameterAccessEvent); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetEventParameterAccessEvent) GetTypeName() string {
	return "BACnetEventParameterAccessEvent"
}

func (m *_BACnetEventParameterAccessEvent) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetEventParameterContract.(*_BACnetEventParameter).getLengthInBits(ctx))

	// Simple field (openingTag)
	lengthInBits += m.OpeningTag.GetLengthInBits(ctx)

	// Simple field (listOfAccessEvents)
	lengthInBits += m.ListOfAccessEvents.GetLengthInBits(ctx)

	// Simple field (accessEventTimeReference)
	lengthInBits += m.AccessEventTimeReference.GetLengthInBits(ctx)

	// Simple field (closingTag)
	lengthInBits += m.ClosingTag.GetLengthInBits(ctx)

	return lengthInBits
}

func (m *_BACnetEventParameterAccessEvent) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetEventParameterAccessEvent) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetEventParameter) (__bACnetEventParameterAccessEvent BACnetEventParameterAccessEvent, err error) {
	m.BACnetEventParameterContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetEventParameterAccessEvent"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetEventParameterAccessEvent")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	openingTag, err := ReadSimpleField[BACnetOpeningTag](ctx, "openingTag", ReadComplex[BACnetOpeningTag](BACnetOpeningTagParseWithBufferProducer((uint8)(uint8(13))), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'openingTag' field"))
	}
	m.OpeningTag = openingTag

	listOfAccessEvents, err := ReadSimpleField[BACnetEventParameterAccessEventListOfAccessEvents](ctx, "listOfAccessEvents", ReadComplex[BACnetEventParameterAccessEventListOfAccessEvents](BACnetEventParameterAccessEventListOfAccessEventsParseWithBufferProducer((uint8)(uint8(0))), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'listOfAccessEvents' field"))
	}
	m.ListOfAccessEvents = listOfAccessEvents

	accessEventTimeReference, err := ReadSimpleField[BACnetDeviceObjectPropertyReferenceEnclosed](ctx, "accessEventTimeReference", ReadComplex[BACnetDeviceObjectPropertyReferenceEnclosed](BACnetDeviceObjectPropertyReferenceEnclosedParseWithBufferProducer((uint8)(uint8(1))), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'accessEventTimeReference' field"))
	}
	m.AccessEventTimeReference = accessEventTimeReference

	closingTag, err := ReadSimpleField[BACnetClosingTag](ctx, "closingTag", ReadComplex[BACnetClosingTag](BACnetClosingTagParseWithBufferProducer((uint8)(uint8(13))), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'closingTag' field"))
	}
	m.ClosingTag = closingTag

	if closeErr := readBuffer.CloseContext("BACnetEventParameterAccessEvent"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetEventParameterAccessEvent")
	}

	return m, nil
}

func (m *_BACnetEventParameterAccessEvent) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetEventParameterAccessEvent) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetEventParameterAccessEvent"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetEventParameterAccessEvent")
		}

		if err := WriteSimpleField[BACnetOpeningTag](ctx, "openingTag", m.GetOpeningTag(), WriteComplex[BACnetOpeningTag](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'openingTag' field")
		}

		if err := WriteSimpleField[BACnetEventParameterAccessEventListOfAccessEvents](ctx, "listOfAccessEvents", m.GetListOfAccessEvents(), WriteComplex[BACnetEventParameterAccessEventListOfAccessEvents](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'listOfAccessEvents' field")
		}

		if err := WriteSimpleField[BACnetDeviceObjectPropertyReferenceEnclosed](ctx, "accessEventTimeReference", m.GetAccessEventTimeReference(), WriteComplex[BACnetDeviceObjectPropertyReferenceEnclosed](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'accessEventTimeReference' field")
		}

		if err := WriteSimpleField[BACnetClosingTag](ctx, "closingTag", m.GetClosingTag(), WriteComplex[BACnetClosingTag](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'closingTag' field")
		}

		if popErr := writeBuffer.PopContext("BACnetEventParameterAccessEvent"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetEventParameterAccessEvent")
		}
		return nil
	}
	return m.BACnetEventParameterContract.(*_BACnetEventParameter).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetEventParameterAccessEvent) IsBACnetEventParameterAccessEvent() {}

func (m *_BACnetEventParameterAccessEvent) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetEventParameterAccessEvent) deepCopy() *_BACnetEventParameterAccessEvent {
	if m == nil {
		return nil
	}
	_BACnetEventParameterAccessEventCopy := &_BACnetEventParameterAccessEvent{
		m.BACnetEventParameterContract.(*_BACnetEventParameter).deepCopy(),
		utils.DeepCopy[BACnetOpeningTag](m.OpeningTag),
		utils.DeepCopy[BACnetEventParameterAccessEventListOfAccessEvents](m.ListOfAccessEvents),
		utils.DeepCopy[BACnetDeviceObjectPropertyReferenceEnclosed](m.AccessEventTimeReference),
		utils.DeepCopy[BACnetClosingTag](m.ClosingTag),
	}
	_BACnetEventParameterAccessEventCopy.BACnetEventParameterContract.(*_BACnetEventParameter)._SubType = m
	return _BACnetEventParameterAccessEventCopy
}

func (m *_BACnetEventParameterAccessEvent) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
