/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetEngineeringUnitsTagged is the corresponding interface of BACnetEngineeringUnitsTagged
type BACnetEngineeringUnitsTagged interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	// GetHeader returns Header (property field)
	GetHeader() BACnetTagHeader
	// GetValue returns Value (property field)
	GetValue() BACnetEngineeringUnits
	// GetProprietaryValue returns ProprietaryValue (property field)
	GetProprietaryValue() uint32
	// GetIsProprietary returns IsProprietary (virtual field)
	GetIsProprietary() bool
	// IsBACnetEngineeringUnitsTagged is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetEngineeringUnitsTagged()
	// CreateBuilder creates a BACnetEngineeringUnitsTaggedBuilder
	CreateBACnetEngineeringUnitsTaggedBuilder() BACnetEngineeringUnitsTaggedBuilder
}

// _BACnetEngineeringUnitsTagged is the data-structure of this message
type _BACnetEngineeringUnitsTagged struct {
	Header           BACnetTagHeader
	Value            BACnetEngineeringUnits
	ProprietaryValue uint32

	// Arguments.
	TagNumber uint8
	TagClass  TagClass
}

var _ BACnetEngineeringUnitsTagged = (*_BACnetEngineeringUnitsTagged)(nil)

// NewBACnetEngineeringUnitsTagged factory function for _BACnetEngineeringUnitsTagged
func NewBACnetEngineeringUnitsTagged(header BACnetTagHeader, value BACnetEngineeringUnits, proprietaryValue uint32, tagNumber uint8, tagClass TagClass) *_BACnetEngineeringUnitsTagged {
	if header == nil {
		panic("header of type BACnetTagHeader for BACnetEngineeringUnitsTagged must not be nil")
	}
	return &_BACnetEngineeringUnitsTagged{Header: header, Value: value, ProprietaryValue: proprietaryValue, TagNumber: tagNumber, TagClass: tagClass}
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetEngineeringUnitsTaggedBuilder is a builder for BACnetEngineeringUnitsTagged
type BACnetEngineeringUnitsTaggedBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(header BACnetTagHeader, value BACnetEngineeringUnits, proprietaryValue uint32) BACnetEngineeringUnitsTaggedBuilder
	// WithHeader adds Header (property field)
	WithHeader(BACnetTagHeader) BACnetEngineeringUnitsTaggedBuilder
	// WithHeaderBuilder adds Header (property field) which is build by the builder
	WithHeaderBuilder(func(BACnetTagHeaderBuilder) BACnetTagHeaderBuilder) BACnetEngineeringUnitsTaggedBuilder
	// WithValue adds Value (property field)
	WithValue(BACnetEngineeringUnits) BACnetEngineeringUnitsTaggedBuilder
	// WithProprietaryValue adds ProprietaryValue (property field)
	WithProprietaryValue(uint32) BACnetEngineeringUnitsTaggedBuilder
	// WithArgTagNumber sets a parser argument
	WithArgTagNumber(uint8) BACnetEngineeringUnitsTaggedBuilder
	// WithArgTagClass sets a parser argument
	WithArgTagClass(TagClass) BACnetEngineeringUnitsTaggedBuilder
	// Build builds the BACnetEngineeringUnitsTagged or returns an error if something is wrong
	Build() (BACnetEngineeringUnitsTagged, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetEngineeringUnitsTagged
}

// NewBACnetEngineeringUnitsTaggedBuilder() creates a BACnetEngineeringUnitsTaggedBuilder
func NewBACnetEngineeringUnitsTaggedBuilder() BACnetEngineeringUnitsTaggedBuilder {
	return &_BACnetEngineeringUnitsTaggedBuilder{_BACnetEngineeringUnitsTagged: new(_BACnetEngineeringUnitsTagged)}
}

type _BACnetEngineeringUnitsTaggedBuilder struct {
	*_BACnetEngineeringUnitsTagged

	err *utils.MultiError
}

var _ (BACnetEngineeringUnitsTaggedBuilder) = (*_BACnetEngineeringUnitsTaggedBuilder)(nil)

func (b *_BACnetEngineeringUnitsTaggedBuilder) WithMandatoryFields(header BACnetTagHeader, value BACnetEngineeringUnits, proprietaryValue uint32) BACnetEngineeringUnitsTaggedBuilder {
	return b.WithHeader(header).WithValue(value).WithProprietaryValue(proprietaryValue)
}

func (b *_BACnetEngineeringUnitsTaggedBuilder) WithHeader(header BACnetTagHeader) BACnetEngineeringUnitsTaggedBuilder {
	b.Header = header
	return b
}

func (b *_BACnetEngineeringUnitsTaggedBuilder) WithHeaderBuilder(builderSupplier func(BACnetTagHeaderBuilder) BACnetTagHeaderBuilder) BACnetEngineeringUnitsTaggedBuilder {
	builder := builderSupplier(b.Header.CreateBACnetTagHeaderBuilder())
	var err error
	b.Header, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "BACnetTagHeaderBuilder failed"))
	}
	return b
}

func (b *_BACnetEngineeringUnitsTaggedBuilder) WithValue(value BACnetEngineeringUnits) BACnetEngineeringUnitsTaggedBuilder {
	b.Value = value
	return b
}

func (b *_BACnetEngineeringUnitsTaggedBuilder) WithProprietaryValue(proprietaryValue uint32) BACnetEngineeringUnitsTaggedBuilder {
	b.ProprietaryValue = proprietaryValue
	return b
}

func (b *_BACnetEngineeringUnitsTaggedBuilder) WithArgTagNumber(tagNumber uint8) BACnetEngineeringUnitsTaggedBuilder {
	b.TagNumber = tagNumber
	return b
}
func (b *_BACnetEngineeringUnitsTaggedBuilder) WithArgTagClass(tagClass TagClass) BACnetEngineeringUnitsTaggedBuilder {
	b.TagClass = tagClass
	return b
}

func (b *_BACnetEngineeringUnitsTaggedBuilder) Build() (BACnetEngineeringUnitsTagged, error) {
	if b.Header == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'header' not set"))
	}
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._BACnetEngineeringUnitsTagged.deepCopy(), nil
}

func (b *_BACnetEngineeringUnitsTaggedBuilder) MustBuild() BACnetEngineeringUnitsTagged {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetEngineeringUnitsTaggedBuilder) DeepCopy() any {
	_copy := b.CreateBACnetEngineeringUnitsTaggedBuilder().(*_BACnetEngineeringUnitsTaggedBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateBACnetEngineeringUnitsTaggedBuilder creates a BACnetEngineeringUnitsTaggedBuilder
func (b *_BACnetEngineeringUnitsTagged) CreateBACnetEngineeringUnitsTaggedBuilder() BACnetEngineeringUnitsTaggedBuilder {
	if b == nil {
		return NewBACnetEngineeringUnitsTaggedBuilder()
	}
	return &_BACnetEngineeringUnitsTaggedBuilder{_BACnetEngineeringUnitsTagged: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetEngineeringUnitsTagged) GetHeader() BACnetTagHeader {
	return m.Header
}

func (m *_BACnetEngineeringUnitsTagged) GetValue() BACnetEngineeringUnits {
	return m.Value
}

func (m *_BACnetEngineeringUnitsTagged) GetProprietaryValue() uint32 {
	return m.ProprietaryValue
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for virtual fields.
///////////////////////

func (m *_BACnetEngineeringUnitsTagged) GetIsProprietary() bool {
	ctx := context.Background()
	_ = ctx
	return bool(bool((m.GetValue()) == (BACnetEngineeringUnits_VENDOR_PROPRIETARY_VALUE)))
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetEngineeringUnitsTagged(structType any) BACnetEngineeringUnitsTagged {
	if casted, ok := structType.(BACnetEngineeringUnitsTagged); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetEngineeringUnitsTagged); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetEngineeringUnitsTagged) GetTypeName() string {
	return "BACnetEngineeringUnitsTagged"
}

func (m *_BACnetEngineeringUnitsTagged) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(0)

	// Simple field (header)
	lengthInBits += m.Header.GetLengthInBits(ctx)

	// Manual Field (value)
	lengthInBits += uint16(utils.InlineIf(m.GetIsProprietary(), func() any { return int32(int32(0)) }, func() any { return int32((int32(m.GetHeader().GetActualLength()) * int32(int32(8)))) }).(int32))

	// A virtual field doesn't have any in- or output.

	// Manual Field (proprietaryValue)
	lengthInBits += uint16(utils.InlineIf(m.GetIsProprietary(), func() any { return int32((int32(m.GetHeader().GetActualLength()) * int32(int32(8)))) }, func() any { return int32(int32(0)) }).(int32))

	return lengthInBits
}

func (m *_BACnetEngineeringUnitsTagged) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func BACnetEngineeringUnitsTaggedParse(ctx context.Context, theBytes []byte, tagNumber uint8, tagClass TagClass) (BACnetEngineeringUnitsTagged, error) {
	return BACnetEngineeringUnitsTaggedParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes), tagNumber, tagClass)
}

func BACnetEngineeringUnitsTaggedParseWithBufferProducer(tagNumber uint8, tagClass TagClass) func(ctx context.Context, readBuffer utils.ReadBuffer) (BACnetEngineeringUnitsTagged, error) {
	return func(ctx context.Context, readBuffer utils.ReadBuffer) (BACnetEngineeringUnitsTagged, error) {
		return BACnetEngineeringUnitsTaggedParseWithBuffer(ctx, readBuffer, tagNumber, tagClass)
	}
}

func BACnetEngineeringUnitsTaggedParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer, tagNumber uint8, tagClass TagClass) (BACnetEngineeringUnitsTagged, error) {
	v, err := (&_BACnetEngineeringUnitsTagged{TagNumber: tagNumber, TagClass: tagClass}).parse(ctx, readBuffer, tagNumber, tagClass)
	if err != nil {
		return nil, err
	}
	return v, nil
}

func (m *_BACnetEngineeringUnitsTagged) parse(ctx context.Context, readBuffer utils.ReadBuffer, tagNumber uint8, tagClass TagClass) (__bACnetEngineeringUnitsTagged BACnetEngineeringUnitsTagged, err error) {
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetEngineeringUnitsTagged"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetEngineeringUnitsTagged")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	header, err := ReadSimpleField[BACnetTagHeader](ctx, "header", ReadComplex[BACnetTagHeader](BACnetTagHeaderParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'header' field"))
	}
	m.Header = header

	// Validation
	if !(bool((header.GetTagClass()) == (tagClass))) {
		return nil, errors.WithStack(utils.ParseValidationError{Message: "tag class doesn't match"})
	}

	// Validation
	if !(bool((bool((header.GetTagClass()) == (TagClass_APPLICATION_TAGS)))) || bool((bool((header.GetActualTagNumber()) == (tagNumber))))) {
		return nil, errors.WithStack(utils.ParseAssertError{Message: "tagnumber doesn't match"})
	}

	value, err := ReadManualField[BACnetEngineeringUnits](ctx, "value", readBuffer, EnsureType[BACnetEngineeringUnits](ReadEnumGeneric(ctx, readBuffer, header.GetActualLength(), BACnetEngineeringUnits_VENDOR_PROPRIETARY_VALUE)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'value' field"))
	}
	m.Value = value

	isProprietary, err := ReadVirtualField[bool](ctx, "isProprietary", (*bool)(nil), bool((value) == (BACnetEngineeringUnits_VENDOR_PROPRIETARY_VALUE)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'isProprietary' field"))
	}
	_ = isProprietary

	proprietaryValue, err := ReadManualField[uint32](ctx, "proprietaryValue", readBuffer, EnsureType[uint32](ReadProprietaryEnumGeneric(ctx, readBuffer, header.GetActualLength(), isProprietary)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'proprietaryValue' field"))
	}
	m.ProprietaryValue = proprietaryValue

	if closeErr := readBuffer.CloseContext("BACnetEngineeringUnitsTagged"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetEngineeringUnitsTagged")
	}

	return m, nil
}

func (m *_BACnetEngineeringUnitsTagged) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetEngineeringUnitsTagged) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pushErr := writeBuffer.PushContext("BACnetEngineeringUnitsTagged"); pushErr != nil {
		return errors.Wrap(pushErr, "Error pushing for BACnetEngineeringUnitsTagged")
	}

	if err := WriteSimpleField[BACnetTagHeader](ctx, "header", m.GetHeader(), WriteComplex[BACnetTagHeader](writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'header' field")
	}

	if err := WriteManualField[BACnetEngineeringUnits](ctx, "value", func(ctx context.Context) error { return WriteEnumGeneric(ctx, writeBuffer, m.GetValue()) }, writeBuffer); err != nil {
		return errors.Wrap(err, "Error serializing 'value' field")
	}
	// Virtual field
	isProprietary := m.GetIsProprietary()
	_ = isProprietary
	if _isProprietaryErr := writeBuffer.WriteVirtual(ctx, "isProprietary", m.GetIsProprietary()); _isProprietaryErr != nil {
		return errors.Wrap(_isProprietaryErr, "Error serializing 'isProprietary' field")
	}

	if err := WriteManualField[uint32](ctx, "proprietaryValue", func(ctx context.Context) error {
		return WriteProprietaryEnumGeneric(ctx, writeBuffer, m.GetProprietaryValue(), m.GetIsProprietary())
	}, writeBuffer); err != nil {
		return errors.Wrap(err, "Error serializing 'proprietaryValue' field")
	}

	if popErr := writeBuffer.PopContext("BACnetEngineeringUnitsTagged"); popErr != nil {
		return errors.Wrap(popErr, "Error popping for BACnetEngineeringUnitsTagged")
	}
	return nil
}

////
// Arguments Getter

func (m *_BACnetEngineeringUnitsTagged) GetTagNumber() uint8 {
	return m.TagNumber
}
func (m *_BACnetEngineeringUnitsTagged) GetTagClass() TagClass {
	return m.TagClass
}

//
////

func (m *_BACnetEngineeringUnitsTagged) IsBACnetEngineeringUnitsTagged() {}

func (m *_BACnetEngineeringUnitsTagged) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetEngineeringUnitsTagged) deepCopy() *_BACnetEngineeringUnitsTagged {
	if m == nil {
		return nil
	}
	_BACnetEngineeringUnitsTaggedCopy := &_BACnetEngineeringUnitsTagged{
		utils.DeepCopy[BACnetTagHeader](m.Header),
		m.Value,
		m.ProprietaryValue,
		m.TagNumber,
		m.TagClass,
	}
	return _BACnetEngineeringUnitsTaggedCopy
}

func (m *_BACnetEngineeringUnitsTagged) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
