/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetDoorValueTagged is the corresponding interface of BACnetDoorValueTagged
type BACnetDoorValueTagged interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	// GetHeader returns Header (property field)
	GetHeader() BACnetTagHeader
	// GetValue returns Value (property field)
	GetValue() BACnetDoorValue
	// IsBACnetDoorValueTagged is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetDoorValueTagged()
	// CreateBuilder creates a BACnetDoorValueTaggedBuilder
	CreateBACnetDoorValueTaggedBuilder() BACnetDoorValueTaggedBuilder
}

// _BACnetDoorValueTagged is the data-structure of this message
type _BACnetDoorValueTagged struct {
	Header BACnetTagHeader
	Value  BACnetDoorValue

	// Arguments.
	TagNumber uint8
	TagClass  TagClass
}

var _ BACnetDoorValueTagged = (*_BACnetDoorValueTagged)(nil)

// NewBACnetDoorValueTagged factory function for _BACnetDoorValueTagged
func NewBACnetDoorValueTagged(header BACnetTagHeader, value BACnetDoorValue, tagNumber uint8, tagClass TagClass) *_BACnetDoorValueTagged {
	if header == nil {
		panic("header of type BACnetTagHeader for BACnetDoorValueTagged must not be nil")
	}
	return &_BACnetDoorValueTagged{Header: header, Value: value, TagNumber: tagNumber, TagClass: tagClass}
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetDoorValueTaggedBuilder is a builder for BACnetDoorValueTagged
type BACnetDoorValueTaggedBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(header BACnetTagHeader, value BACnetDoorValue) BACnetDoorValueTaggedBuilder
	// WithHeader adds Header (property field)
	WithHeader(BACnetTagHeader) BACnetDoorValueTaggedBuilder
	// WithHeaderBuilder adds Header (property field) which is build by the builder
	WithHeaderBuilder(func(BACnetTagHeaderBuilder) BACnetTagHeaderBuilder) BACnetDoorValueTaggedBuilder
	// WithValue adds Value (property field)
	WithValue(BACnetDoorValue) BACnetDoorValueTaggedBuilder
	// WithArgTagNumber sets a parser argument
	WithArgTagNumber(uint8) BACnetDoorValueTaggedBuilder
	// WithArgTagClass sets a parser argument
	WithArgTagClass(TagClass) BACnetDoorValueTaggedBuilder
	// Build builds the BACnetDoorValueTagged or returns an error if something is wrong
	Build() (BACnetDoorValueTagged, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetDoorValueTagged
}

// NewBACnetDoorValueTaggedBuilder() creates a BACnetDoorValueTaggedBuilder
func NewBACnetDoorValueTaggedBuilder() BACnetDoorValueTaggedBuilder {
	return &_BACnetDoorValueTaggedBuilder{_BACnetDoorValueTagged: new(_BACnetDoorValueTagged)}
}

type _BACnetDoorValueTaggedBuilder struct {
	*_BACnetDoorValueTagged

	err *utils.MultiError
}

var _ (BACnetDoorValueTaggedBuilder) = (*_BACnetDoorValueTaggedBuilder)(nil)

func (b *_BACnetDoorValueTaggedBuilder) WithMandatoryFields(header BACnetTagHeader, value BACnetDoorValue) BACnetDoorValueTaggedBuilder {
	return b.WithHeader(header).WithValue(value)
}

func (b *_BACnetDoorValueTaggedBuilder) WithHeader(header BACnetTagHeader) BACnetDoorValueTaggedBuilder {
	b.Header = header
	return b
}

func (b *_BACnetDoorValueTaggedBuilder) WithHeaderBuilder(builderSupplier func(BACnetTagHeaderBuilder) BACnetTagHeaderBuilder) BACnetDoorValueTaggedBuilder {
	builder := builderSupplier(b.Header.CreateBACnetTagHeaderBuilder())
	var err error
	b.Header, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "BACnetTagHeaderBuilder failed"))
	}
	return b
}

func (b *_BACnetDoorValueTaggedBuilder) WithValue(value BACnetDoorValue) BACnetDoorValueTaggedBuilder {
	b.Value = value
	return b
}

func (b *_BACnetDoorValueTaggedBuilder) WithArgTagNumber(tagNumber uint8) BACnetDoorValueTaggedBuilder {
	b.TagNumber = tagNumber
	return b
}
func (b *_BACnetDoorValueTaggedBuilder) WithArgTagClass(tagClass TagClass) BACnetDoorValueTaggedBuilder {
	b.TagClass = tagClass
	return b
}

func (b *_BACnetDoorValueTaggedBuilder) Build() (BACnetDoorValueTagged, error) {
	if b.Header == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'header' not set"))
	}
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._BACnetDoorValueTagged.deepCopy(), nil
}

func (b *_BACnetDoorValueTaggedBuilder) MustBuild() BACnetDoorValueTagged {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetDoorValueTaggedBuilder) DeepCopy() any {
	_copy := b.CreateBACnetDoorValueTaggedBuilder().(*_BACnetDoorValueTaggedBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateBACnetDoorValueTaggedBuilder creates a BACnetDoorValueTaggedBuilder
func (b *_BACnetDoorValueTagged) CreateBACnetDoorValueTaggedBuilder() BACnetDoorValueTaggedBuilder {
	if b == nil {
		return NewBACnetDoorValueTaggedBuilder()
	}
	return &_BACnetDoorValueTaggedBuilder{_BACnetDoorValueTagged: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetDoorValueTagged) GetHeader() BACnetTagHeader {
	return m.Header
}

func (m *_BACnetDoorValueTagged) GetValue() BACnetDoorValue {
	return m.Value
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetDoorValueTagged(structType any) BACnetDoorValueTagged {
	if casted, ok := structType.(BACnetDoorValueTagged); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetDoorValueTagged); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetDoorValueTagged) GetTypeName() string {
	return "BACnetDoorValueTagged"
}

func (m *_BACnetDoorValueTagged) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(0)

	// Simple field (header)
	lengthInBits += m.Header.GetLengthInBits(ctx)

	// Manual Field (value)
	lengthInBits += uint16(int32(m.GetHeader().GetActualLength()) * int32(int32(8)))

	return lengthInBits
}

func (m *_BACnetDoorValueTagged) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func BACnetDoorValueTaggedParse(ctx context.Context, theBytes []byte, tagNumber uint8, tagClass TagClass) (BACnetDoorValueTagged, error) {
	return BACnetDoorValueTaggedParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes), tagNumber, tagClass)
}

func BACnetDoorValueTaggedParseWithBufferProducer(tagNumber uint8, tagClass TagClass) func(ctx context.Context, readBuffer utils.ReadBuffer) (BACnetDoorValueTagged, error) {
	return func(ctx context.Context, readBuffer utils.ReadBuffer) (BACnetDoorValueTagged, error) {
		return BACnetDoorValueTaggedParseWithBuffer(ctx, readBuffer, tagNumber, tagClass)
	}
}

func BACnetDoorValueTaggedParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer, tagNumber uint8, tagClass TagClass) (BACnetDoorValueTagged, error) {
	v, err := (&_BACnetDoorValueTagged{TagNumber: tagNumber, TagClass: tagClass}).parse(ctx, readBuffer, tagNumber, tagClass)
	if err != nil {
		return nil, err
	}
	return v, nil
}

func (m *_BACnetDoorValueTagged) parse(ctx context.Context, readBuffer utils.ReadBuffer, tagNumber uint8, tagClass TagClass) (__bACnetDoorValueTagged BACnetDoorValueTagged, err error) {
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetDoorValueTagged"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetDoorValueTagged")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	header, err := ReadSimpleField[BACnetTagHeader](ctx, "header", ReadComplex[BACnetTagHeader](BACnetTagHeaderParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'header' field"))
	}
	m.Header = header

	// Validation
	if !(bool((header.GetTagClass()) == (tagClass))) {
		return nil, errors.WithStack(utils.ParseValidationError{Message: "tag class doesn't match"})
	}

	// Validation
	if !(bool((bool((header.GetTagClass()) == (TagClass_APPLICATION_TAGS)))) || bool((bool((header.GetActualTagNumber()) == (tagNumber))))) {
		return nil, errors.WithStack(utils.ParseAssertError{Message: "tagnumber doesn't match"})
	}

	value, err := ReadManualField[BACnetDoorValue](ctx, "value", readBuffer, EnsureType[BACnetDoorValue](ReadEnumGenericFailing(ctx, readBuffer, header.GetActualLength(), BACnetDoorValue_LOCK)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'value' field"))
	}
	m.Value = value

	if closeErr := readBuffer.CloseContext("BACnetDoorValueTagged"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetDoorValueTagged")
	}

	return m, nil
}

func (m *_BACnetDoorValueTagged) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetDoorValueTagged) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pushErr := writeBuffer.PushContext("BACnetDoorValueTagged"); pushErr != nil {
		return errors.Wrap(pushErr, "Error pushing for BACnetDoorValueTagged")
	}

	if err := WriteSimpleField[BACnetTagHeader](ctx, "header", m.GetHeader(), WriteComplex[BACnetTagHeader](writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'header' field")
	}

	if err := WriteManualField[BACnetDoorValue](ctx, "value", func(ctx context.Context) error { return WriteEnumGeneric(ctx, writeBuffer, m.GetValue()) }, writeBuffer); err != nil {
		return errors.Wrap(err, "Error serializing 'value' field")
	}

	if popErr := writeBuffer.PopContext("BACnetDoorValueTagged"); popErr != nil {
		return errors.Wrap(popErr, "Error popping for BACnetDoorValueTagged")
	}
	return nil
}

////
// Arguments Getter

func (m *_BACnetDoorValueTagged) GetTagNumber() uint8 {
	return m.TagNumber
}
func (m *_BACnetDoorValueTagged) GetTagClass() TagClass {
	return m.TagClass
}

//
////

func (m *_BACnetDoorValueTagged) IsBACnetDoorValueTagged() {}

func (m *_BACnetDoorValueTagged) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetDoorValueTagged) deepCopy() *_BACnetDoorValueTagged {
	if m == nil {
		return nil
	}
	_BACnetDoorValueTaggedCopy := &_BACnetDoorValueTagged{
		utils.DeepCopy[BACnetTagHeader](m.Header),
		m.Value,
		m.TagNumber,
		m.TagClass,
	}
	return _BACnetDoorValueTaggedCopy
}

func (m *_BACnetDoorValueTagged) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
