/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetDeviceObjectReferenceEnclosed is the corresponding interface of BACnetDeviceObjectReferenceEnclosed
type BACnetDeviceObjectReferenceEnclosed interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	// GetOpeningTag returns OpeningTag (property field)
	GetOpeningTag() BACnetOpeningTag
	// GetObjectReference returns ObjectReference (property field)
	GetObjectReference() BACnetDeviceObjectReference
	// GetClosingTag returns ClosingTag (property field)
	GetClosingTag() BACnetClosingTag
	// IsBACnetDeviceObjectReferenceEnclosed is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetDeviceObjectReferenceEnclosed()
	// CreateBuilder creates a BACnetDeviceObjectReferenceEnclosedBuilder
	CreateBACnetDeviceObjectReferenceEnclosedBuilder() BACnetDeviceObjectReferenceEnclosedBuilder
}

// _BACnetDeviceObjectReferenceEnclosed is the data-structure of this message
type _BACnetDeviceObjectReferenceEnclosed struct {
	OpeningTag      BACnetOpeningTag
	ObjectReference BACnetDeviceObjectReference
	ClosingTag      BACnetClosingTag

	// Arguments.
	TagNumber uint8
}

var _ BACnetDeviceObjectReferenceEnclosed = (*_BACnetDeviceObjectReferenceEnclosed)(nil)

// NewBACnetDeviceObjectReferenceEnclosed factory function for _BACnetDeviceObjectReferenceEnclosed
func NewBACnetDeviceObjectReferenceEnclosed(openingTag BACnetOpeningTag, objectReference BACnetDeviceObjectReference, closingTag BACnetClosingTag, tagNumber uint8) *_BACnetDeviceObjectReferenceEnclosed {
	if openingTag == nil {
		panic("openingTag of type BACnetOpeningTag for BACnetDeviceObjectReferenceEnclosed must not be nil")
	}
	if objectReference == nil {
		panic("objectReference of type BACnetDeviceObjectReference for BACnetDeviceObjectReferenceEnclosed must not be nil")
	}
	if closingTag == nil {
		panic("closingTag of type BACnetClosingTag for BACnetDeviceObjectReferenceEnclosed must not be nil")
	}
	return &_BACnetDeviceObjectReferenceEnclosed{OpeningTag: openingTag, ObjectReference: objectReference, ClosingTag: closingTag, TagNumber: tagNumber}
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetDeviceObjectReferenceEnclosedBuilder is a builder for BACnetDeviceObjectReferenceEnclosed
type BACnetDeviceObjectReferenceEnclosedBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(openingTag BACnetOpeningTag, objectReference BACnetDeviceObjectReference, closingTag BACnetClosingTag) BACnetDeviceObjectReferenceEnclosedBuilder
	// WithOpeningTag adds OpeningTag (property field)
	WithOpeningTag(BACnetOpeningTag) BACnetDeviceObjectReferenceEnclosedBuilder
	// WithOpeningTagBuilder adds OpeningTag (property field) which is build by the builder
	WithOpeningTagBuilder(func(BACnetOpeningTagBuilder) BACnetOpeningTagBuilder) BACnetDeviceObjectReferenceEnclosedBuilder
	// WithObjectReference adds ObjectReference (property field)
	WithObjectReference(BACnetDeviceObjectReference) BACnetDeviceObjectReferenceEnclosedBuilder
	// WithObjectReferenceBuilder adds ObjectReference (property field) which is build by the builder
	WithObjectReferenceBuilder(func(BACnetDeviceObjectReferenceBuilder) BACnetDeviceObjectReferenceBuilder) BACnetDeviceObjectReferenceEnclosedBuilder
	// WithClosingTag adds ClosingTag (property field)
	WithClosingTag(BACnetClosingTag) BACnetDeviceObjectReferenceEnclosedBuilder
	// WithClosingTagBuilder adds ClosingTag (property field) which is build by the builder
	WithClosingTagBuilder(func(BACnetClosingTagBuilder) BACnetClosingTagBuilder) BACnetDeviceObjectReferenceEnclosedBuilder
	// WithArgTagNumber sets a parser argument
	WithArgTagNumber(uint8) BACnetDeviceObjectReferenceEnclosedBuilder
	// Build builds the BACnetDeviceObjectReferenceEnclosed or returns an error if something is wrong
	Build() (BACnetDeviceObjectReferenceEnclosed, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetDeviceObjectReferenceEnclosed
}

// NewBACnetDeviceObjectReferenceEnclosedBuilder() creates a BACnetDeviceObjectReferenceEnclosedBuilder
func NewBACnetDeviceObjectReferenceEnclosedBuilder() BACnetDeviceObjectReferenceEnclosedBuilder {
	return &_BACnetDeviceObjectReferenceEnclosedBuilder{_BACnetDeviceObjectReferenceEnclosed: new(_BACnetDeviceObjectReferenceEnclosed)}
}

type _BACnetDeviceObjectReferenceEnclosedBuilder struct {
	*_BACnetDeviceObjectReferenceEnclosed

	err *utils.MultiError
}

var _ (BACnetDeviceObjectReferenceEnclosedBuilder) = (*_BACnetDeviceObjectReferenceEnclosedBuilder)(nil)

func (b *_BACnetDeviceObjectReferenceEnclosedBuilder) WithMandatoryFields(openingTag BACnetOpeningTag, objectReference BACnetDeviceObjectReference, closingTag BACnetClosingTag) BACnetDeviceObjectReferenceEnclosedBuilder {
	return b.WithOpeningTag(openingTag).WithObjectReference(objectReference).WithClosingTag(closingTag)
}

func (b *_BACnetDeviceObjectReferenceEnclosedBuilder) WithOpeningTag(openingTag BACnetOpeningTag) BACnetDeviceObjectReferenceEnclosedBuilder {
	b.OpeningTag = openingTag
	return b
}

func (b *_BACnetDeviceObjectReferenceEnclosedBuilder) WithOpeningTagBuilder(builderSupplier func(BACnetOpeningTagBuilder) BACnetOpeningTagBuilder) BACnetDeviceObjectReferenceEnclosedBuilder {
	builder := builderSupplier(b.OpeningTag.CreateBACnetOpeningTagBuilder())
	var err error
	b.OpeningTag, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "BACnetOpeningTagBuilder failed"))
	}
	return b
}

func (b *_BACnetDeviceObjectReferenceEnclosedBuilder) WithObjectReference(objectReference BACnetDeviceObjectReference) BACnetDeviceObjectReferenceEnclosedBuilder {
	b.ObjectReference = objectReference
	return b
}

func (b *_BACnetDeviceObjectReferenceEnclosedBuilder) WithObjectReferenceBuilder(builderSupplier func(BACnetDeviceObjectReferenceBuilder) BACnetDeviceObjectReferenceBuilder) BACnetDeviceObjectReferenceEnclosedBuilder {
	builder := builderSupplier(b.ObjectReference.CreateBACnetDeviceObjectReferenceBuilder())
	var err error
	b.ObjectReference, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "BACnetDeviceObjectReferenceBuilder failed"))
	}
	return b
}

func (b *_BACnetDeviceObjectReferenceEnclosedBuilder) WithClosingTag(closingTag BACnetClosingTag) BACnetDeviceObjectReferenceEnclosedBuilder {
	b.ClosingTag = closingTag
	return b
}

func (b *_BACnetDeviceObjectReferenceEnclosedBuilder) WithClosingTagBuilder(builderSupplier func(BACnetClosingTagBuilder) BACnetClosingTagBuilder) BACnetDeviceObjectReferenceEnclosedBuilder {
	builder := builderSupplier(b.ClosingTag.CreateBACnetClosingTagBuilder())
	var err error
	b.ClosingTag, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "BACnetClosingTagBuilder failed"))
	}
	return b
}

func (b *_BACnetDeviceObjectReferenceEnclosedBuilder) WithArgTagNumber(tagNumber uint8) BACnetDeviceObjectReferenceEnclosedBuilder {
	b.TagNumber = tagNumber
	return b
}

func (b *_BACnetDeviceObjectReferenceEnclosedBuilder) Build() (BACnetDeviceObjectReferenceEnclosed, error) {
	if b.OpeningTag == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'openingTag' not set"))
	}
	if b.ObjectReference == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'objectReference' not set"))
	}
	if b.ClosingTag == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'closingTag' not set"))
	}
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._BACnetDeviceObjectReferenceEnclosed.deepCopy(), nil
}

func (b *_BACnetDeviceObjectReferenceEnclosedBuilder) MustBuild() BACnetDeviceObjectReferenceEnclosed {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetDeviceObjectReferenceEnclosedBuilder) DeepCopy() any {
	_copy := b.CreateBACnetDeviceObjectReferenceEnclosedBuilder().(*_BACnetDeviceObjectReferenceEnclosedBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateBACnetDeviceObjectReferenceEnclosedBuilder creates a BACnetDeviceObjectReferenceEnclosedBuilder
func (b *_BACnetDeviceObjectReferenceEnclosed) CreateBACnetDeviceObjectReferenceEnclosedBuilder() BACnetDeviceObjectReferenceEnclosedBuilder {
	if b == nil {
		return NewBACnetDeviceObjectReferenceEnclosedBuilder()
	}
	return &_BACnetDeviceObjectReferenceEnclosedBuilder{_BACnetDeviceObjectReferenceEnclosed: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetDeviceObjectReferenceEnclosed) GetOpeningTag() BACnetOpeningTag {
	return m.OpeningTag
}

func (m *_BACnetDeviceObjectReferenceEnclosed) GetObjectReference() BACnetDeviceObjectReference {
	return m.ObjectReference
}

func (m *_BACnetDeviceObjectReferenceEnclosed) GetClosingTag() BACnetClosingTag {
	return m.ClosingTag
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetDeviceObjectReferenceEnclosed(structType any) BACnetDeviceObjectReferenceEnclosed {
	if casted, ok := structType.(BACnetDeviceObjectReferenceEnclosed); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetDeviceObjectReferenceEnclosed); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetDeviceObjectReferenceEnclosed) GetTypeName() string {
	return "BACnetDeviceObjectReferenceEnclosed"
}

func (m *_BACnetDeviceObjectReferenceEnclosed) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(0)

	// Simple field (openingTag)
	lengthInBits += m.OpeningTag.GetLengthInBits(ctx)

	// Simple field (objectReference)
	lengthInBits += m.ObjectReference.GetLengthInBits(ctx)

	// Simple field (closingTag)
	lengthInBits += m.ClosingTag.GetLengthInBits(ctx)

	return lengthInBits
}

func (m *_BACnetDeviceObjectReferenceEnclosed) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func BACnetDeviceObjectReferenceEnclosedParse(ctx context.Context, theBytes []byte, tagNumber uint8) (BACnetDeviceObjectReferenceEnclosed, error) {
	return BACnetDeviceObjectReferenceEnclosedParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes), tagNumber)
}

func BACnetDeviceObjectReferenceEnclosedParseWithBufferProducer(tagNumber uint8) func(ctx context.Context, readBuffer utils.ReadBuffer) (BACnetDeviceObjectReferenceEnclosed, error) {
	return func(ctx context.Context, readBuffer utils.ReadBuffer) (BACnetDeviceObjectReferenceEnclosed, error) {
		return BACnetDeviceObjectReferenceEnclosedParseWithBuffer(ctx, readBuffer, tagNumber)
	}
}

func BACnetDeviceObjectReferenceEnclosedParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer, tagNumber uint8) (BACnetDeviceObjectReferenceEnclosed, error) {
	v, err := (&_BACnetDeviceObjectReferenceEnclosed{TagNumber: tagNumber}).parse(ctx, readBuffer, tagNumber)
	if err != nil {
		return nil, err
	}
	return v, nil
}

func (m *_BACnetDeviceObjectReferenceEnclosed) parse(ctx context.Context, readBuffer utils.ReadBuffer, tagNumber uint8) (__bACnetDeviceObjectReferenceEnclosed BACnetDeviceObjectReferenceEnclosed, err error) {
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetDeviceObjectReferenceEnclosed"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetDeviceObjectReferenceEnclosed")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	openingTag, err := ReadSimpleField[BACnetOpeningTag](ctx, "openingTag", ReadComplex[BACnetOpeningTag](BACnetOpeningTagParseWithBufferProducer((uint8)(tagNumber)), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'openingTag' field"))
	}
	m.OpeningTag = openingTag

	objectReference, err := ReadSimpleField[BACnetDeviceObjectReference](ctx, "objectReference", ReadComplex[BACnetDeviceObjectReference](BACnetDeviceObjectReferenceParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'objectReference' field"))
	}
	m.ObjectReference = objectReference

	closingTag, err := ReadSimpleField[BACnetClosingTag](ctx, "closingTag", ReadComplex[BACnetClosingTag](BACnetClosingTagParseWithBufferProducer((uint8)(tagNumber)), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'closingTag' field"))
	}
	m.ClosingTag = closingTag

	if closeErr := readBuffer.CloseContext("BACnetDeviceObjectReferenceEnclosed"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetDeviceObjectReferenceEnclosed")
	}

	return m, nil
}

func (m *_BACnetDeviceObjectReferenceEnclosed) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetDeviceObjectReferenceEnclosed) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pushErr := writeBuffer.PushContext("BACnetDeviceObjectReferenceEnclosed"); pushErr != nil {
		return errors.Wrap(pushErr, "Error pushing for BACnetDeviceObjectReferenceEnclosed")
	}

	if err := WriteSimpleField[BACnetOpeningTag](ctx, "openingTag", m.GetOpeningTag(), WriteComplex[BACnetOpeningTag](writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'openingTag' field")
	}

	if err := WriteSimpleField[BACnetDeviceObjectReference](ctx, "objectReference", m.GetObjectReference(), WriteComplex[BACnetDeviceObjectReference](writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'objectReference' field")
	}

	if err := WriteSimpleField[BACnetClosingTag](ctx, "closingTag", m.GetClosingTag(), WriteComplex[BACnetClosingTag](writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'closingTag' field")
	}

	if popErr := writeBuffer.PopContext("BACnetDeviceObjectReferenceEnclosed"); popErr != nil {
		return errors.Wrap(popErr, "Error popping for BACnetDeviceObjectReferenceEnclosed")
	}
	return nil
}

////
// Arguments Getter

func (m *_BACnetDeviceObjectReferenceEnclosed) GetTagNumber() uint8 {
	return m.TagNumber
}

//
////

func (m *_BACnetDeviceObjectReferenceEnclosed) IsBACnetDeviceObjectReferenceEnclosed() {}

func (m *_BACnetDeviceObjectReferenceEnclosed) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetDeviceObjectReferenceEnclosed) deepCopy() *_BACnetDeviceObjectReferenceEnclosed {
	if m == nil {
		return nil
	}
	_BACnetDeviceObjectReferenceEnclosedCopy := &_BACnetDeviceObjectReferenceEnclosed{
		utils.DeepCopy[BACnetOpeningTag](m.OpeningTag),
		utils.DeepCopy[BACnetDeviceObjectReference](m.ObjectReference),
		utils.DeepCopy[BACnetClosingTag](m.ClosingTag),
		m.TagNumber,
	}
	return _BACnetDeviceObjectReferenceEnclosedCopy
}

func (m *_BACnetDeviceObjectReferenceEnclosed) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
