/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetDeviceObjectPropertyReferenceEnclosed is the corresponding interface of BACnetDeviceObjectPropertyReferenceEnclosed
type BACnetDeviceObjectPropertyReferenceEnclosed interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	// GetOpeningTag returns OpeningTag (property field)
	GetOpeningTag() BACnetOpeningTag
	// GetValue returns Value (property field)
	GetValue() BACnetDeviceObjectPropertyReference
	// GetClosingTag returns ClosingTag (property field)
	GetClosingTag() BACnetClosingTag
	// IsBACnetDeviceObjectPropertyReferenceEnclosed is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetDeviceObjectPropertyReferenceEnclosed()
	// CreateBuilder creates a BACnetDeviceObjectPropertyReferenceEnclosedBuilder
	CreateBACnetDeviceObjectPropertyReferenceEnclosedBuilder() BACnetDeviceObjectPropertyReferenceEnclosedBuilder
}

// _BACnetDeviceObjectPropertyReferenceEnclosed is the data-structure of this message
type _BACnetDeviceObjectPropertyReferenceEnclosed struct {
	OpeningTag BACnetOpeningTag
	Value      BACnetDeviceObjectPropertyReference
	ClosingTag BACnetClosingTag

	// Arguments.
	TagNumber uint8
}

var _ BACnetDeviceObjectPropertyReferenceEnclosed = (*_BACnetDeviceObjectPropertyReferenceEnclosed)(nil)

// NewBACnetDeviceObjectPropertyReferenceEnclosed factory function for _BACnetDeviceObjectPropertyReferenceEnclosed
func NewBACnetDeviceObjectPropertyReferenceEnclosed(openingTag BACnetOpeningTag, value BACnetDeviceObjectPropertyReference, closingTag BACnetClosingTag, tagNumber uint8) *_BACnetDeviceObjectPropertyReferenceEnclosed {
	if openingTag == nil {
		panic("openingTag of type BACnetOpeningTag for BACnetDeviceObjectPropertyReferenceEnclosed must not be nil")
	}
	if value == nil {
		panic("value of type BACnetDeviceObjectPropertyReference for BACnetDeviceObjectPropertyReferenceEnclosed must not be nil")
	}
	if closingTag == nil {
		panic("closingTag of type BACnetClosingTag for BACnetDeviceObjectPropertyReferenceEnclosed must not be nil")
	}
	return &_BACnetDeviceObjectPropertyReferenceEnclosed{OpeningTag: openingTag, Value: value, ClosingTag: closingTag, TagNumber: tagNumber}
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetDeviceObjectPropertyReferenceEnclosedBuilder is a builder for BACnetDeviceObjectPropertyReferenceEnclosed
type BACnetDeviceObjectPropertyReferenceEnclosedBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(openingTag BACnetOpeningTag, value BACnetDeviceObjectPropertyReference, closingTag BACnetClosingTag) BACnetDeviceObjectPropertyReferenceEnclosedBuilder
	// WithOpeningTag adds OpeningTag (property field)
	WithOpeningTag(BACnetOpeningTag) BACnetDeviceObjectPropertyReferenceEnclosedBuilder
	// WithOpeningTagBuilder adds OpeningTag (property field) which is build by the builder
	WithOpeningTagBuilder(func(BACnetOpeningTagBuilder) BACnetOpeningTagBuilder) BACnetDeviceObjectPropertyReferenceEnclosedBuilder
	// WithValue adds Value (property field)
	WithValue(BACnetDeviceObjectPropertyReference) BACnetDeviceObjectPropertyReferenceEnclosedBuilder
	// WithValueBuilder adds Value (property field) which is build by the builder
	WithValueBuilder(func(BACnetDeviceObjectPropertyReferenceBuilder) BACnetDeviceObjectPropertyReferenceBuilder) BACnetDeviceObjectPropertyReferenceEnclosedBuilder
	// WithClosingTag adds ClosingTag (property field)
	WithClosingTag(BACnetClosingTag) BACnetDeviceObjectPropertyReferenceEnclosedBuilder
	// WithClosingTagBuilder adds ClosingTag (property field) which is build by the builder
	WithClosingTagBuilder(func(BACnetClosingTagBuilder) BACnetClosingTagBuilder) BACnetDeviceObjectPropertyReferenceEnclosedBuilder
	// WithArgTagNumber sets a parser argument
	WithArgTagNumber(uint8) BACnetDeviceObjectPropertyReferenceEnclosedBuilder
	// Build builds the BACnetDeviceObjectPropertyReferenceEnclosed or returns an error if something is wrong
	Build() (BACnetDeviceObjectPropertyReferenceEnclosed, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetDeviceObjectPropertyReferenceEnclosed
}

// NewBACnetDeviceObjectPropertyReferenceEnclosedBuilder() creates a BACnetDeviceObjectPropertyReferenceEnclosedBuilder
func NewBACnetDeviceObjectPropertyReferenceEnclosedBuilder() BACnetDeviceObjectPropertyReferenceEnclosedBuilder {
	return &_BACnetDeviceObjectPropertyReferenceEnclosedBuilder{_BACnetDeviceObjectPropertyReferenceEnclosed: new(_BACnetDeviceObjectPropertyReferenceEnclosed)}
}

type _BACnetDeviceObjectPropertyReferenceEnclosedBuilder struct {
	*_BACnetDeviceObjectPropertyReferenceEnclosed

	err *utils.MultiError
}

var _ (BACnetDeviceObjectPropertyReferenceEnclosedBuilder) = (*_BACnetDeviceObjectPropertyReferenceEnclosedBuilder)(nil)

func (b *_BACnetDeviceObjectPropertyReferenceEnclosedBuilder) WithMandatoryFields(openingTag BACnetOpeningTag, value BACnetDeviceObjectPropertyReference, closingTag BACnetClosingTag) BACnetDeviceObjectPropertyReferenceEnclosedBuilder {
	return b.WithOpeningTag(openingTag).WithValue(value).WithClosingTag(closingTag)
}

func (b *_BACnetDeviceObjectPropertyReferenceEnclosedBuilder) WithOpeningTag(openingTag BACnetOpeningTag) BACnetDeviceObjectPropertyReferenceEnclosedBuilder {
	b.OpeningTag = openingTag
	return b
}

func (b *_BACnetDeviceObjectPropertyReferenceEnclosedBuilder) WithOpeningTagBuilder(builderSupplier func(BACnetOpeningTagBuilder) BACnetOpeningTagBuilder) BACnetDeviceObjectPropertyReferenceEnclosedBuilder {
	builder := builderSupplier(b.OpeningTag.CreateBACnetOpeningTagBuilder())
	var err error
	b.OpeningTag, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "BACnetOpeningTagBuilder failed"))
	}
	return b
}

func (b *_BACnetDeviceObjectPropertyReferenceEnclosedBuilder) WithValue(value BACnetDeviceObjectPropertyReference) BACnetDeviceObjectPropertyReferenceEnclosedBuilder {
	b.Value = value
	return b
}

func (b *_BACnetDeviceObjectPropertyReferenceEnclosedBuilder) WithValueBuilder(builderSupplier func(BACnetDeviceObjectPropertyReferenceBuilder) BACnetDeviceObjectPropertyReferenceBuilder) BACnetDeviceObjectPropertyReferenceEnclosedBuilder {
	builder := builderSupplier(b.Value.CreateBACnetDeviceObjectPropertyReferenceBuilder())
	var err error
	b.Value, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "BACnetDeviceObjectPropertyReferenceBuilder failed"))
	}
	return b
}

func (b *_BACnetDeviceObjectPropertyReferenceEnclosedBuilder) WithClosingTag(closingTag BACnetClosingTag) BACnetDeviceObjectPropertyReferenceEnclosedBuilder {
	b.ClosingTag = closingTag
	return b
}

func (b *_BACnetDeviceObjectPropertyReferenceEnclosedBuilder) WithClosingTagBuilder(builderSupplier func(BACnetClosingTagBuilder) BACnetClosingTagBuilder) BACnetDeviceObjectPropertyReferenceEnclosedBuilder {
	builder := builderSupplier(b.ClosingTag.CreateBACnetClosingTagBuilder())
	var err error
	b.ClosingTag, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "BACnetClosingTagBuilder failed"))
	}
	return b
}

func (b *_BACnetDeviceObjectPropertyReferenceEnclosedBuilder) WithArgTagNumber(tagNumber uint8) BACnetDeviceObjectPropertyReferenceEnclosedBuilder {
	b.TagNumber = tagNumber
	return b
}

func (b *_BACnetDeviceObjectPropertyReferenceEnclosedBuilder) Build() (BACnetDeviceObjectPropertyReferenceEnclosed, error) {
	if b.OpeningTag == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'openingTag' not set"))
	}
	if b.Value == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'value' not set"))
	}
	if b.ClosingTag == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'closingTag' not set"))
	}
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._BACnetDeviceObjectPropertyReferenceEnclosed.deepCopy(), nil
}

func (b *_BACnetDeviceObjectPropertyReferenceEnclosedBuilder) MustBuild() BACnetDeviceObjectPropertyReferenceEnclosed {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetDeviceObjectPropertyReferenceEnclosedBuilder) DeepCopy() any {
	_copy := b.CreateBACnetDeviceObjectPropertyReferenceEnclosedBuilder().(*_BACnetDeviceObjectPropertyReferenceEnclosedBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateBACnetDeviceObjectPropertyReferenceEnclosedBuilder creates a BACnetDeviceObjectPropertyReferenceEnclosedBuilder
func (b *_BACnetDeviceObjectPropertyReferenceEnclosed) CreateBACnetDeviceObjectPropertyReferenceEnclosedBuilder() BACnetDeviceObjectPropertyReferenceEnclosedBuilder {
	if b == nil {
		return NewBACnetDeviceObjectPropertyReferenceEnclosedBuilder()
	}
	return &_BACnetDeviceObjectPropertyReferenceEnclosedBuilder{_BACnetDeviceObjectPropertyReferenceEnclosed: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetDeviceObjectPropertyReferenceEnclosed) GetOpeningTag() BACnetOpeningTag {
	return m.OpeningTag
}

func (m *_BACnetDeviceObjectPropertyReferenceEnclosed) GetValue() BACnetDeviceObjectPropertyReference {
	return m.Value
}

func (m *_BACnetDeviceObjectPropertyReferenceEnclosed) GetClosingTag() BACnetClosingTag {
	return m.ClosingTag
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetDeviceObjectPropertyReferenceEnclosed(structType any) BACnetDeviceObjectPropertyReferenceEnclosed {
	if casted, ok := structType.(BACnetDeviceObjectPropertyReferenceEnclosed); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetDeviceObjectPropertyReferenceEnclosed); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetDeviceObjectPropertyReferenceEnclosed) GetTypeName() string {
	return "BACnetDeviceObjectPropertyReferenceEnclosed"
}

func (m *_BACnetDeviceObjectPropertyReferenceEnclosed) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(0)

	// Simple field (openingTag)
	lengthInBits += m.OpeningTag.GetLengthInBits(ctx)

	// Simple field (value)
	lengthInBits += m.Value.GetLengthInBits(ctx)

	// Simple field (closingTag)
	lengthInBits += m.ClosingTag.GetLengthInBits(ctx)

	return lengthInBits
}

func (m *_BACnetDeviceObjectPropertyReferenceEnclosed) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func BACnetDeviceObjectPropertyReferenceEnclosedParse(ctx context.Context, theBytes []byte, tagNumber uint8) (BACnetDeviceObjectPropertyReferenceEnclosed, error) {
	return BACnetDeviceObjectPropertyReferenceEnclosedParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes), tagNumber)
}

func BACnetDeviceObjectPropertyReferenceEnclosedParseWithBufferProducer(tagNumber uint8) func(ctx context.Context, readBuffer utils.ReadBuffer) (BACnetDeviceObjectPropertyReferenceEnclosed, error) {
	return func(ctx context.Context, readBuffer utils.ReadBuffer) (BACnetDeviceObjectPropertyReferenceEnclosed, error) {
		return BACnetDeviceObjectPropertyReferenceEnclosedParseWithBuffer(ctx, readBuffer, tagNumber)
	}
}

func BACnetDeviceObjectPropertyReferenceEnclosedParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer, tagNumber uint8) (BACnetDeviceObjectPropertyReferenceEnclosed, error) {
	v, err := (&_BACnetDeviceObjectPropertyReferenceEnclosed{TagNumber: tagNumber}).parse(ctx, readBuffer, tagNumber)
	if err != nil {
		return nil, err
	}
	return v, nil
}

func (m *_BACnetDeviceObjectPropertyReferenceEnclosed) parse(ctx context.Context, readBuffer utils.ReadBuffer, tagNumber uint8) (__bACnetDeviceObjectPropertyReferenceEnclosed BACnetDeviceObjectPropertyReferenceEnclosed, err error) {
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetDeviceObjectPropertyReferenceEnclosed"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetDeviceObjectPropertyReferenceEnclosed")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	openingTag, err := ReadSimpleField[BACnetOpeningTag](ctx, "openingTag", ReadComplex[BACnetOpeningTag](BACnetOpeningTagParseWithBufferProducer((uint8)(tagNumber)), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'openingTag' field"))
	}
	m.OpeningTag = openingTag

	value, err := ReadSimpleField[BACnetDeviceObjectPropertyReference](ctx, "value", ReadComplex[BACnetDeviceObjectPropertyReference](BACnetDeviceObjectPropertyReferenceParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'value' field"))
	}
	m.Value = value

	closingTag, err := ReadSimpleField[BACnetClosingTag](ctx, "closingTag", ReadComplex[BACnetClosingTag](BACnetClosingTagParseWithBufferProducer((uint8)(tagNumber)), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'closingTag' field"))
	}
	m.ClosingTag = closingTag

	if closeErr := readBuffer.CloseContext("BACnetDeviceObjectPropertyReferenceEnclosed"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetDeviceObjectPropertyReferenceEnclosed")
	}

	return m, nil
}

func (m *_BACnetDeviceObjectPropertyReferenceEnclosed) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetDeviceObjectPropertyReferenceEnclosed) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pushErr := writeBuffer.PushContext("BACnetDeviceObjectPropertyReferenceEnclosed"); pushErr != nil {
		return errors.Wrap(pushErr, "Error pushing for BACnetDeviceObjectPropertyReferenceEnclosed")
	}

	if err := WriteSimpleField[BACnetOpeningTag](ctx, "openingTag", m.GetOpeningTag(), WriteComplex[BACnetOpeningTag](writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'openingTag' field")
	}

	if err := WriteSimpleField[BACnetDeviceObjectPropertyReference](ctx, "value", m.GetValue(), WriteComplex[BACnetDeviceObjectPropertyReference](writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'value' field")
	}

	if err := WriteSimpleField[BACnetClosingTag](ctx, "closingTag", m.GetClosingTag(), WriteComplex[BACnetClosingTag](writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'closingTag' field")
	}

	if popErr := writeBuffer.PopContext("BACnetDeviceObjectPropertyReferenceEnclosed"); popErr != nil {
		return errors.Wrap(popErr, "Error popping for BACnetDeviceObjectPropertyReferenceEnclosed")
	}
	return nil
}

////
// Arguments Getter

func (m *_BACnetDeviceObjectPropertyReferenceEnclosed) GetTagNumber() uint8 {
	return m.TagNumber
}

//
////

func (m *_BACnetDeviceObjectPropertyReferenceEnclosed) IsBACnetDeviceObjectPropertyReferenceEnclosed() {
}

func (m *_BACnetDeviceObjectPropertyReferenceEnclosed) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetDeviceObjectPropertyReferenceEnclosed) deepCopy() *_BACnetDeviceObjectPropertyReferenceEnclosed {
	if m == nil {
		return nil
	}
	_BACnetDeviceObjectPropertyReferenceEnclosedCopy := &_BACnetDeviceObjectPropertyReferenceEnclosed{
		utils.DeepCopy[BACnetOpeningTag](m.OpeningTag),
		utils.DeepCopy[BACnetDeviceObjectPropertyReference](m.Value),
		utils.DeepCopy[BACnetClosingTag](m.ClosingTag),
		m.TagNumber,
	}
	return _BACnetDeviceObjectPropertyReferenceEnclosedCopy
}

func (m *_BACnetDeviceObjectPropertyReferenceEnclosed) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
