/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetDateTimeEnclosed is the corresponding interface of BACnetDateTimeEnclosed
type BACnetDateTimeEnclosed interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	// GetOpeningTag returns OpeningTag (property field)
	GetOpeningTag() BACnetOpeningTag
	// GetDateTimeValue returns DateTimeValue (property field)
	GetDateTimeValue() BACnetDateTime
	// GetClosingTag returns ClosingTag (property field)
	GetClosingTag() BACnetClosingTag
	// IsBACnetDateTimeEnclosed is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetDateTimeEnclosed()
	// CreateBuilder creates a BACnetDateTimeEnclosedBuilder
	CreateBACnetDateTimeEnclosedBuilder() BACnetDateTimeEnclosedBuilder
}

// _BACnetDateTimeEnclosed is the data-structure of this message
type _BACnetDateTimeEnclosed struct {
	OpeningTag    BACnetOpeningTag
	DateTimeValue BACnetDateTime
	ClosingTag    BACnetClosingTag

	// Arguments.
	TagNumber uint8
}

var _ BACnetDateTimeEnclosed = (*_BACnetDateTimeEnclosed)(nil)

// NewBACnetDateTimeEnclosed factory function for _BACnetDateTimeEnclosed
func NewBACnetDateTimeEnclosed(openingTag BACnetOpeningTag, dateTimeValue BACnetDateTime, closingTag BACnetClosingTag, tagNumber uint8) *_BACnetDateTimeEnclosed {
	if openingTag == nil {
		panic("openingTag of type BACnetOpeningTag for BACnetDateTimeEnclosed must not be nil")
	}
	if dateTimeValue == nil {
		panic("dateTimeValue of type BACnetDateTime for BACnetDateTimeEnclosed must not be nil")
	}
	if closingTag == nil {
		panic("closingTag of type BACnetClosingTag for BACnetDateTimeEnclosed must not be nil")
	}
	return &_BACnetDateTimeEnclosed{OpeningTag: openingTag, DateTimeValue: dateTimeValue, ClosingTag: closingTag, TagNumber: tagNumber}
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetDateTimeEnclosedBuilder is a builder for BACnetDateTimeEnclosed
type BACnetDateTimeEnclosedBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(openingTag BACnetOpeningTag, dateTimeValue BACnetDateTime, closingTag BACnetClosingTag) BACnetDateTimeEnclosedBuilder
	// WithOpeningTag adds OpeningTag (property field)
	WithOpeningTag(BACnetOpeningTag) BACnetDateTimeEnclosedBuilder
	// WithOpeningTagBuilder adds OpeningTag (property field) which is build by the builder
	WithOpeningTagBuilder(func(BACnetOpeningTagBuilder) BACnetOpeningTagBuilder) BACnetDateTimeEnclosedBuilder
	// WithDateTimeValue adds DateTimeValue (property field)
	WithDateTimeValue(BACnetDateTime) BACnetDateTimeEnclosedBuilder
	// WithDateTimeValueBuilder adds DateTimeValue (property field) which is build by the builder
	WithDateTimeValueBuilder(func(BACnetDateTimeBuilder) BACnetDateTimeBuilder) BACnetDateTimeEnclosedBuilder
	// WithClosingTag adds ClosingTag (property field)
	WithClosingTag(BACnetClosingTag) BACnetDateTimeEnclosedBuilder
	// WithClosingTagBuilder adds ClosingTag (property field) which is build by the builder
	WithClosingTagBuilder(func(BACnetClosingTagBuilder) BACnetClosingTagBuilder) BACnetDateTimeEnclosedBuilder
	// WithArgTagNumber sets a parser argument
	WithArgTagNumber(uint8) BACnetDateTimeEnclosedBuilder
	// Build builds the BACnetDateTimeEnclosed or returns an error if something is wrong
	Build() (BACnetDateTimeEnclosed, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetDateTimeEnclosed
}

// NewBACnetDateTimeEnclosedBuilder() creates a BACnetDateTimeEnclosedBuilder
func NewBACnetDateTimeEnclosedBuilder() BACnetDateTimeEnclosedBuilder {
	return &_BACnetDateTimeEnclosedBuilder{_BACnetDateTimeEnclosed: new(_BACnetDateTimeEnclosed)}
}

type _BACnetDateTimeEnclosedBuilder struct {
	*_BACnetDateTimeEnclosed

	err *utils.MultiError
}

var _ (BACnetDateTimeEnclosedBuilder) = (*_BACnetDateTimeEnclosedBuilder)(nil)

func (b *_BACnetDateTimeEnclosedBuilder) WithMandatoryFields(openingTag BACnetOpeningTag, dateTimeValue BACnetDateTime, closingTag BACnetClosingTag) BACnetDateTimeEnclosedBuilder {
	return b.WithOpeningTag(openingTag).WithDateTimeValue(dateTimeValue).WithClosingTag(closingTag)
}

func (b *_BACnetDateTimeEnclosedBuilder) WithOpeningTag(openingTag BACnetOpeningTag) BACnetDateTimeEnclosedBuilder {
	b.OpeningTag = openingTag
	return b
}

func (b *_BACnetDateTimeEnclosedBuilder) WithOpeningTagBuilder(builderSupplier func(BACnetOpeningTagBuilder) BACnetOpeningTagBuilder) BACnetDateTimeEnclosedBuilder {
	builder := builderSupplier(b.OpeningTag.CreateBACnetOpeningTagBuilder())
	var err error
	b.OpeningTag, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "BACnetOpeningTagBuilder failed"))
	}
	return b
}

func (b *_BACnetDateTimeEnclosedBuilder) WithDateTimeValue(dateTimeValue BACnetDateTime) BACnetDateTimeEnclosedBuilder {
	b.DateTimeValue = dateTimeValue
	return b
}

func (b *_BACnetDateTimeEnclosedBuilder) WithDateTimeValueBuilder(builderSupplier func(BACnetDateTimeBuilder) BACnetDateTimeBuilder) BACnetDateTimeEnclosedBuilder {
	builder := builderSupplier(b.DateTimeValue.CreateBACnetDateTimeBuilder())
	var err error
	b.DateTimeValue, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "BACnetDateTimeBuilder failed"))
	}
	return b
}

func (b *_BACnetDateTimeEnclosedBuilder) WithClosingTag(closingTag BACnetClosingTag) BACnetDateTimeEnclosedBuilder {
	b.ClosingTag = closingTag
	return b
}

func (b *_BACnetDateTimeEnclosedBuilder) WithClosingTagBuilder(builderSupplier func(BACnetClosingTagBuilder) BACnetClosingTagBuilder) BACnetDateTimeEnclosedBuilder {
	builder := builderSupplier(b.ClosingTag.CreateBACnetClosingTagBuilder())
	var err error
	b.ClosingTag, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "BACnetClosingTagBuilder failed"))
	}
	return b
}

func (b *_BACnetDateTimeEnclosedBuilder) WithArgTagNumber(tagNumber uint8) BACnetDateTimeEnclosedBuilder {
	b.TagNumber = tagNumber
	return b
}

func (b *_BACnetDateTimeEnclosedBuilder) Build() (BACnetDateTimeEnclosed, error) {
	if b.OpeningTag == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'openingTag' not set"))
	}
	if b.DateTimeValue == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'dateTimeValue' not set"))
	}
	if b.ClosingTag == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'closingTag' not set"))
	}
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._BACnetDateTimeEnclosed.deepCopy(), nil
}

func (b *_BACnetDateTimeEnclosedBuilder) MustBuild() BACnetDateTimeEnclosed {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetDateTimeEnclosedBuilder) DeepCopy() any {
	_copy := b.CreateBACnetDateTimeEnclosedBuilder().(*_BACnetDateTimeEnclosedBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateBACnetDateTimeEnclosedBuilder creates a BACnetDateTimeEnclosedBuilder
func (b *_BACnetDateTimeEnclosed) CreateBACnetDateTimeEnclosedBuilder() BACnetDateTimeEnclosedBuilder {
	if b == nil {
		return NewBACnetDateTimeEnclosedBuilder()
	}
	return &_BACnetDateTimeEnclosedBuilder{_BACnetDateTimeEnclosed: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetDateTimeEnclosed) GetOpeningTag() BACnetOpeningTag {
	return m.OpeningTag
}

func (m *_BACnetDateTimeEnclosed) GetDateTimeValue() BACnetDateTime {
	return m.DateTimeValue
}

func (m *_BACnetDateTimeEnclosed) GetClosingTag() BACnetClosingTag {
	return m.ClosingTag
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetDateTimeEnclosed(structType any) BACnetDateTimeEnclosed {
	if casted, ok := structType.(BACnetDateTimeEnclosed); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetDateTimeEnclosed); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetDateTimeEnclosed) GetTypeName() string {
	return "BACnetDateTimeEnclosed"
}

func (m *_BACnetDateTimeEnclosed) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(0)

	// Simple field (openingTag)
	lengthInBits += m.OpeningTag.GetLengthInBits(ctx)

	// Simple field (dateTimeValue)
	lengthInBits += m.DateTimeValue.GetLengthInBits(ctx)

	// Simple field (closingTag)
	lengthInBits += m.ClosingTag.GetLengthInBits(ctx)

	return lengthInBits
}

func (m *_BACnetDateTimeEnclosed) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func BACnetDateTimeEnclosedParse(ctx context.Context, theBytes []byte, tagNumber uint8) (BACnetDateTimeEnclosed, error) {
	return BACnetDateTimeEnclosedParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes), tagNumber)
}

func BACnetDateTimeEnclosedParseWithBufferProducer(tagNumber uint8) func(ctx context.Context, readBuffer utils.ReadBuffer) (BACnetDateTimeEnclosed, error) {
	return func(ctx context.Context, readBuffer utils.ReadBuffer) (BACnetDateTimeEnclosed, error) {
		return BACnetDateTimeEnclosedParseWithBuffer(ctx, readBuffer, tagNumber)
	}
}

func BACnetDateTimeEnclosedParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer, tagNumber uint8) (BACnetDateTimeEnclosed, error) {
	v, err := (&_BACnetDateTimeEnclosed{TagNumber: tagNumber}).parse(ctx, readBuffer, tagNumber)
	if err != nil {
		return nil, err
	}
	return v, nil
}

func (m *_BACnetDateTimeEnclosed) parse(ctx context.Context, readBuffer utils.ReadBuffer, tagNumber uint8) (__bACnetDateTimeEnclosed BACnetDateTimeEnclosed, err error) {
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetDateTimeEnclosed"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetDateTimeEnclosed")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	openingTag, err := ReadSimpleField[BACnetOpeningTag](ctx, "openingTag", ReadComplex[BACnetOpeningTag](BACnetOpeningTagParseWithBufferProducer((uint8)(tagNumber)), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'openingTag' field"))
	}
	m.OpeningTag = openingTag

	dateTimeValue, err := ReadSimpleField[BACnetDateTime](ctx, "dateTimeValue", ReadComplex[BACnetDateTime](BACnetDateTimeParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'dateTimeValue' field"))
	}
	m.DateTimeValue = dateTimeValue

	closingTag, err := ReadSimpleField[BACnetClosingTag](ctx, "closingTag", ReadComplex[BACnetClosingTag](BACnetClosingTagParseWithBufferProducer((uint8)(tagNumber)), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'closingTag' field"))
	}
	m.ClosingTag = closingTag

	if closeErr := readBuffer.CloseContext("BACnetDateTimeEnclosed"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetDateTimeEnclosed")
	}

	return m, nil
}

func (m *_BACnetDateTimeEnclosed) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetDateTimeEnclosed) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pushErr := writeBuffer.PushContext("BACnetDateTimeEnclosed"); pushErr != nil {
		return errors.Wrap(pushErr, "Error pushing for BACnetDateTimeEnclosed")
	}

	if err := WriteSimpleField[BACnetOpeningTag](ctx, "openingTag", m.GetOpeningTag(), WriteComplex[BACnetOpeningTag](writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'openingTag' field")
	}

	if err := WriteSimpleField[BACnetDateTime](ctx, "dateTimeValue", m.GetDateTimeValue(), WriteComplex[BACnetDateTime](writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'dateTimeValue' field")
	}

	if err := WriteSimpleField[BACnetClosingTag](ctx, "closingTag", m.GetClosingTag(), WriteComplex[BACnetClosingTag](writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'closingTag' field")
	}

	if popErr := writeBuffer.PopContext("BACnetDateTimeEnclosed"); popErr != nil {
		return errors.Wrap(popErr, "Error popping for BACnetDateTimeEnclosed")
	}
	return nil
}

////
// Arguments Getter

func (m *_BACnetDateTimeEnclosed) GetTagNumber() uint8 {
	return m.TagNumber
}

//
////

func (m *_BACnetDateTimeEnclosed) IsBACnetDateTimeEnclosed() {}

func (m *_BACnetDateTimeEnclosed) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetDateTimeEnclosed) deepCopy() *_BACnetDateTimeEnclosed {
	if m == nil {
		return nil
	}
	_BACnetDateTimeEnclosedCopy := &_BACnetDateTimeEnclosed{
		utils.DeepCopy[BACnetOpeningTag](m.OpeningTag),
		utils.DeepCopy[BACnetDateTime](m.DateTimeValue),
		utils.DeepCopy[BACnetClosingTag](m.ClosingTag),
		m.TagNumber,
	}
	return _BACnetDateTimeEnclosedCopy
}

func (m *_BACnetDateTimeEnclosed) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
