/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetConstructedDataVarianceValue is the corresponding interface of BACnetConstructedDataVarianceValue
type BACnetConstructedDataVarianceValue interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetConstructedData
	// GetVarianceValue returns VarianceValue (property field)
	GetVarianceValue() BACnetApplicationTagReal
	// GetActualValue returns ActualValue (virtual field)
	GetActualValue() BACnetApplicationTagReal
	// IsBACnetConstructedDataVarianceValue is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetConstructedDataVarianceValue()
	// CreateBuilder creates a BACnetConstructedDataVarianceValueBuilder
	CreateBACnetConstructedDataVarianceValueBuilder() BACnetConstructedDataVarianceValueBuilder
}

// _BACnetConstructedDataVarianceValue is the data-structure of this message
type _BACnetConstructedDataVarianceValue struct {
	BACnetConstructedDataContract
	VarianceValue BACnetApplicationTagReal
}

var _ BACnetConstructedDataVarianceValue = (*_BACnetConstructedDataVarianceValue)(nil)
var _ BACnetConstructedDataRequirements = (*_BACnetConstructedDataVarianceValue)(nil)

// NewBACnetConstructedDataVarianceValue factory function for _BACnetConstructedDataVarianceValue
func NewBACnetConstructedDataVarianceValue(openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag, varianceValue BACnetApplicationTagReal, tagNumber uint8, arrayIndexArgument BACnetTagPayloadUnsignedInteger) *_BACnetConstructedDataVarianceValue {
	if varianceValue == nil {
		panic("varianceValue of type BACnetApplicationTagReal for BACnetConstructedDataVarianceValue must not be nil")
	}
	_result := &_BACnetConstructedDataVarianceValue{
		BACnetConstructedDataContract: NewBACnetConstructedData(openingTag, peekedTagHeader, closingTag, tagNumber, arrayIndexArgument),
		VarianceValue:                 varianceValue,
	}
	_result.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetConstructedDataVarianceValueBuilder is a builder for BACnetConstructedDataVarianceValue
type BACnetConstructedDataVarianceValueBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(varianceValue BACnetApplicationTagReal) BACnetConstructedDataVarianceValueBuilder
	// WithVarianceValue adds VarianceValue (property field)
	WithVarianceValue(BACnetApplicationTagReal) BACnetConstructedDataVarianceValueBuilder
	// WithVarianceValueBuilder adds VarianceValue (property field) which is build by the builder
	WithVarianceValueBuilder(func(BACnetApplicationTagRealBuilder) BACnetApplicationTagRealBuilder) BACnetConstructedDataVarianceValueBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetConstructedDataBuilder
	// Build builds the BACnetConstructedDataVarianceValue or returns an error if something is wrong
	Build() (BACnetConstructedDataVarianceValue, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetConstructedDataVarianceValue
}

// NewBACnetConstructedDataVarianceValueBuilder() creates a BACnetConstructedDataVarianceValueBuilder
func NewBACnetConstructedDataVarianceValueBuilder() BACnetConstructedDataVarianceValueBuilder {
	return &_BACnetConstructedDataVarianceValueBuilder{_BACnetConstructedDataVarianceValue: new(_BACnetConstructedDataVarianceValue)}
}

type _BACnetConstructedDataVarianceValueBuilder struct {
	*_BACnetConstructedDataVarianceValue

	parentBuilder *_BACnetConstructedDataBuilder

	err *utils.MultiError
}

var _ (BACnetConstructedDataVarianceValueBuilder) = (*_BACnetConstructedDataVarianceValueBuilder)(nil)

func (b *_BACnetConstructedDataVarianceValueBuilder) setParent(contract BACnetConstructedDataContract) {
	b.BACnetConstructedDataContract = contract
	contract.(*_BACnetConstructedData)._SubType = b._BACnetConstructedDataVarianceValue
}

func (b *_BACnetConstructedDataVarianceValueBuilder) WithMandatoryFields(varianceValue BACnetApplicationTagReal) BACnetConstructedDataVarianceValueBuilder {
	return b.WithVarianceValue(varianceValue)
}

func (b *_BACnetConstructedDataVarianceValueBuilder) WithVarianceValue(varianceValue BACnetApplicationTagReal) BACnetConstructedDataVarianceValueBuilder {
	b.VarianceValue = varianceValue
	return b
}

func (b *_BACnetConstructedDataVarianceValueBuilder) WithVarianceValueBuilder(builderSupplier func(BACnetApplicationTagRealBuilder) BACnetApplicationTagRealBuilder) BACnetConstructedDataVarianceValueBuilder {
	builder := builderSupplier(b.VarianceValue.CreateBACnetApplicationTagRealBuilder())
	var err error
	b.VarianceValue, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "BACnetApplicationTagRealBuilder failed"))
	}
	return b
}

func (b *_BACnetConstructedDataVarianceValueBuilder) Build() (BACnetConstructedDataVarianceValue, error) {
	if b.VarianceValue == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'varianceValue' not set"))
	}
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._BACnetConstructedDataVarianceValue.deepCopy(), nil
}

func (b *_BACnetConstructedDataVarianceValueBuilder) MustBuild() BACnetConstructedDataVarianceValue {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetConstructedDataVarianceValueBuilder) Done() BACnetConstructedDataBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetConstructedDataBuilder().(*_BACnetConstructedDataBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetConstructedDataVarianceValueBuilder) buildForBACnetConstructedData() (BACnetConstructedData, error) {
	return b.Build()
}

func (b *_BACnetConstructedDataVarianceValueBuilder) DeepCopy() any {
	_copy := b.CreateBACnetConstructedDataVarianceValueBuilder().(*_BACnetConstructedDataVarianceValueBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateBACnetConstructedDataVarianceValueBuilder creates a BACnetConstructedDataVarianceValueBuilder
func (b *_BACnetConstructedDataVarianceValue) CreateBACnetConstructedDataVarianceValueBuilder() BACnetConstructedDataVarianceValueBuilder {
	if b == nil {
		return NewBACnetConstructedDataVarianceValueBuilder()
	}
	return &_BACnetConstructedDataVarianceValueBuilder{_BACnetConstructedDataVarianceValue: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_BACnetConstructedDataVarianceValue) GetObjectTypeArgument() BACnetObjectType {
	return 0
}

func (m *_BACnetConstructedDataVarianceValue) GetPropertyIdentifierArgument() BACnetPropertyIdentifier {
	return BACnetPropertyIdentifier_VARIANCE_VALUE
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetConstructedDataVarianceValue) GetParent() BACnetConstructedDataContract {
	return m.BACnetConstructedDataContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetConstructedDataVarianceValue) GetVarianceValue() BACnetApplicationTagReal {
	return m.VarianceValue
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for virtual fields.
///////////////////////

func (m *_BACnetConstructedDataVarianceValue) GetActualValue() BACnetApplicationTagReal {
	ctx := context.Background()
	_ = ctx
	return CastBACnetApplicationTagReal(m.GetVarianceValue())
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetConstructedDataVarianceValue(structType any) BACnetConstructedDataVarianceValue {
	if casted, ok := structType.(BACnetConstructedDataVarianceValue); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetConstructedDataVarianceValue); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetConstructedDataVarianceValue) GetTypeName() string {
	return "BACnetConstructedDataVarianceValue"
}

func (m *_BACnetConstructedDataVarianceValue) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetConstructedDataContract.(*_BACnetConstructedData).getLengthInBits(ctx))

	// Simple field (varianceValue)
	lengthInBits += m.VarianceValue.GetLengthInBits(ctx)

	// A virtual field doesn't have any in- or output.

	return lengthInBits
}

func (m *_BACnetConstructedDataVarianceValue) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetConstructedDataVarianceValue) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetConstructedData, tagNumber uint8, objectTypeArgument BACnetObjectType, propertyIdentifierArgument BACnetPropertyIdentifier, arrayIndexArgument BACnetTagPayloadUnsignedInteger) (__bACnetConstructedDataVarianceValue BACnetConstructedDataVarianceValue, err error) {
	m.BACnetConstructedDataContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetConstructedDataVarianceValue"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetConstructedDataVarianceValue")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	varianceValue, err := ReadSimpleField[BACnetApplicationTagReal](ctx, "varianceValue", ReadComplex[BACnetApplicationTagReal](BACnetApplicationTagParseWithBufferProducer[BACnetApplicationTagReal](), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'varianceValue' field"))
	}
	m.VarianceValue = varianceValue

	actualValue, err := ReadVirtualField[BACnetApplicationTagReal](ctx, "actualValue", (*BACnetApplicationTagReal)(nil), varianceValue)
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'actualValue' field"))
	}
	_ = actualValue

	if closeErr := readBuffer.CloseContext("BACnetConstructedDataVarianceValue"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetConstructedDataVarianceValue")
	}

	return m, nil
}

func (m *_BACnetConstructedDataVarianceValue) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetConstructedDataVarianceValue) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetConstructedDataVarianceValue"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetConstructedDataVarianceValue")
		}

		if err := WriteSimpleField[BACnetApplicationTagReal](ctx, "varianceValue", m.GetVarianceValue(), WriteComplex[BACnetApplicationTagReal](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'varianceValue' field")
		}
		// Virtual field
		actualValue := m.GetActualValue()
		_ = actualValue
		if _actualValueErr := writeBuffer.WriteVirtual(ctx, "actualValue", m.GetActualValue()); _actualValueErr != nil {
			return errors.Wrap(_actualValueErr, "Error serializing 'actualValue' field")
		}

		if popErr := writeBuffer.PopContext("BACnetConstructedDataVarianceValue"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetConstructedDataVarianceValue")
		}
		return nil
	}
	return m.BACnetConstructedDataContract.(*_BACnetConstructedData).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetConstructedDataVarianceValue) IsBACnetConstructedDataVarianceValue() {}

func (m *_BACnetConstructedDataVarianceValue) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetConstructedDataVarianceValue) deepCopy() *_BACnetConstructedDataVarianceValue {
	if m == nil {
		return nil
	}
	_BACnetConstructedDataVarianceValueCopy := &_BACnetConstructedDataVarianceValue{
		m.BACnetConstructedDataContract.(*_BACnetConstructedData).deepCopy(),
		utils.DeepCopy[BACnetApplicationTagReal](m.VarianceValue),
	}
	_BACnetConstructedDataVarianceValueCopy.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = m
	return _BACnetConstructedDataVarianceValueCopy
}

func (m *_BACnetConstructedDataVarianceValue) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
