/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetConstructedDataValueSet is the corresponding interface of BACnetConstructedDataValueSet
type BACnetConstructedDataValueSet interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetConstructedData
	// GetValueSet returns ValueSet (property field)
	GetValueSet() BACnetApplicationTagUnsignedInteger
	// GetActualValue returns ActualValue (virtual field)
	GetActualValue() BACnetApplicationTagUnsignedInteger
	// IsBACnetConstructedDataValueSet is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetConstructedDataValueSet()
	// CreateBuilder creates a BACnetConstructedDataValueSetBuilder
	CreateBACnetConstructedDataValueSetBuilder() BACnetConstructedDataValueSetBuilder
}

// _BACnetConstructedDataValueSet is the data-structure of this message
type _BACnetConstructedDataValueSet struct {
	BACnetConstructedDataContract
	ValueSet BACnetApplicationTagUnsignedInteger
}

var _ BACnetConstructedDataValueSet = (*_BACnetConstructedDataValueSet)(nil)
var _ BACnetConstructedDataRequirements = (*_BACnetConstructedDataValueSet)(nil)

// NewBACnetConstructedDataValueSet factory function for _BACnetConstructedDataValueSet
func NewBACnetConstructedDataValueSet(openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag, valueSet BACnetApplicationTagUnsignedInteger, tagNumber uint8, arrayIndexArgument BACnetTagPayloadUnsignedInteger) *_BACnetConstructedDataValueSet {
	if valueSet == nil {
		panic("valueSet of type BACnetApplicationTagUnsignedInteger for BACnetConstructedDataValueSet must not be nil")
	}
	_result := &_BACnetConstructedDataValueSet{
		BACnetConstructedDataContract: NewBACnetConstructedData(openingTag, peekedTagHeader, closingTag, tagNumber, arrayIndexArgument),
		ValueSet:                      valueSet,
	}
	_result.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetConstructedDataValueSetBuilder is a builder for BACnetConstructedDataValueSet
type BACnetConstructedDataValueSetBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(valueSet BACnetApplicationTagUnsignedInteger) BACnetConstructedDataValueSetBuilder
	// WithValueSet adds ValueSet (property field)
	WithValueSet(BACnetApplicationTagUnsignedInteger) BACnetConstructedDataValueSetBuilder
	// WithValueSetBuilder adds ValueSet (property field) which is build by the builder
	WithValueSetBuilder(func(BACnetApplicationTagUnsignedIntegerBuilder) BACnetApplicationTagUnsignedIntegerBuilder) BACnetConstructedDataValueSetBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetConstructedDataBuilder
	// Build builds the BACnetConstructedDataValueSet or returns an error if something is wrong
	Build() (BACnetConstructedDataValueSet, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetConstructedDataValueSet
}

// NewBACnetConstructedDataValueSetBuilder() creates a BACnetConstructedDataValueSetBuilder
func NewBACnetConstructedDataValueSetBuilder() BACnetConstructedDataValueSetBuilder {
	return &_BACnetConstructedDataValueSetBuilder{_BACnetConstructedDataValueSet: new(_BACnetConstructedDataValueSet)}
}

type _BACnetConstructedDataValueSetBuilder struct {
	*_BACnetConstructedDataValueSet

	parentBuilder *_BACnetConstructedDataBuilder

	err *utils.MultiError
}

var _ (BACnetConstructedDataValueSetBuilder) = (*_BACnetConstructedDataValueSetBuilder)(nil)

func (b *_BACnetConstructedDataValueSetBuilder) setParent(contract BACnetConstructedDataContract) {
	b.BACnetConstructedDataContract = contract
	contract.(*_BACnetConstructedData)._SubType = b._BACnetConstructedDataValueSet
}

func (b *_BACnetConstructedDataValueSetBuilder) WithMandatoryFields(valueSet BACnetApplicationTagUnsignedInteger) BACnetConstructedDataValueSetBuilder {
	return b.WithValueSet(valueSet)
}

func (b *_BACnetConstructedDataValueSetBuilder) WithValueSet(valueSet BACnetApplicationTagUnsignedInteger) BACnetConstructedDataValueSetBuilder {
	b.ValueSet = valueSet
	return b
}

func (b *_BACnetConstructedDataValueSetBuilder) WithValueSetBuilder(builderSupplier func(BACnetApplicationTagUnsignedIntegerBuilder) BACnetApplicationTagUnsignedIntegerBuilder) BACnetConstructedDataValueSetBuilder {
	builder := builderSupplier(b.ValueSet.CreateBACnetApplicationTagUnsignedIntegerBuilder())
	var err error
	b.ValueSet, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "BACnetApplicationTagUnsignedIntegerBuilder failed"))
	}
	return b
}

func (b *_BACnetConstructedDataValueSetBuilder) Build() (BACnetConstructedDataValueSet, error) {
	if b.ValueSet == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'valueSet' not set"))
	}
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._BACnetConstructedDataValueSet.deepCopy(), nil
}

func (b *_BACnetConstructedDataValueSetBuilder) MustBuild() BACnetConstructedDataValueSet {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetConstructedDataValueSetBuilder) Done() BACnetConstructedDataBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetConstructedDataBuilder().(*_BACnetConstructedDataBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetConstructedDataValueSetBuilder) buildForBACnetConstructedData() (BACnetConstructedData, error) {
	return b.Build()
}

func (b *_BACnetConstructedDataValueSetBuilder) DeepCopy() any {
	_copy := b.CreateBACnetConstructedDataValueSetBuilder().(*_BACnetConstructedDataValueSetBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateBACnetConstructedDataValueSetBuilder creates a BACnetConstructedDataValueSetBuilder
func (b *_BACnetConstructedDataValueSet) CreateBACnetConstructedDataValueSetBuilder() BACnetConstructedDataValueSetBuilder {
	if b == nil {
		return NewBACnetConstructedDataValueSetBuilder()
	}
	return &_BACnetConstructedDataValueSetBuilder{_BACnetConstructedDataValueSet: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_BACnetConstructedDataValueSet) GetObjectTypeArgument() BACnetObjectType {
	return 0
}

func (m *_BACnetConstructedDataValueSet) GetPropertyIdentifierArgument() BACnetPropertyIdentifier {
	return BACnetPropertyIdentifier_VALUE_SET
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetConstructedDataValueSet) GetParent() BACnetConstructedDataContract {
	return m.BACnetConstructedDataContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetConstructedDataValueSet) GetValueSet() BACnetApplicationTagUnsignedInteger {
	return m.ValueSet
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for virtual fields.
///////////////////////

func (m *_BACnetConstructedDataValueSet) GetActualValue() BACnetApplicationTagUnsignedInteger {
	ctx := context.Background()
	_ = ctx
	return CastBACnetApplicationTagUnsignedInteger(m.GetValueSet())
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetConstructedDataValueSet(structType any) BACnetConstructedDataValueSet {
	if casted, ok := structType.(BACnetConstructedDataValueSet); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetConstructedDataValueSet); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetConstructedDataValueSet) GetTypeName() string {
	return "BACnetConstructedDataValueSet"
}

func (m *_BACnetConstructedDataValueSet) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetConstructedDataContract.(*_BACnetConstructedData).getLengthInBits(ctx))

	// Simple field (valueSet)
	lengthInBits += m.ValueSet.GetLengthInBits(ctx)

	// A virtual field doesn't have any in- or output.

	return lengthInBits
}

func (m *_BACnetConstructedDataValueSet) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetConstructedDataValueSet) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetConstructedData, tagNumber uint8, objectTypeArgument BACnetObjectType, propertyIdentifierArgument BACnetPropertyIdentifier, arrayIndexArgument BACnetTagPayloadUnsignedInteger) (__bACnetConstructedDataValueSet BACnetConstructedDataValueSet, err error) {
	m.BACnetConstructedDataContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetConstructedDataValueSet"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetConstructedDataValueSet")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	valueSet, err := ReadSimpleField[BACnetApplicationTagUnsignedInteger](ctx, "valueSet", ReadComplex[BACnetApplicationTagUnsignedInteger](BACnetApplicationTagParseWithBufferProducer[BACnetApplicationTagUnsignedInteger](), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'valueSet' field"))
	}
	m.ValueSet = valueSet

	actualValue, err := ReadVirtualField[BACnetApplicationTagUnsignedInteger](ctx, "actualValue", (*BACnetApplicationTagUnsignedInteger)(nil), valueSet)
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'actualValue' field"))
	}
	_ = actualValue

	if closeErr := readBuffer.CloseContext("BACnetConstructedDataValueSet"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetConstructedDataValueSet")
	}

	return m, nil
}

func (m *_BACnetConstructedDataValueSet) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetConstructedDataValueSet) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetConstructedDataValueSet"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetConstructedDataValueSet")
		}

		if err := WriteSimpleField[BACnetApplicationTagUnsignedInteger](ctx, "valueSet", m.GetValueSet(), WriteComplex[BACnetApplicationTagUnsignedInteger](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'valueSet' field")
		}
		// Virtual field
		actualValue := m.GetActualValue()
		_ = actualValue
		if _actualValueErr := writeBuffer.WriteVirtual(ctx, "actualValue", m.GetActualValue()); _actualValueErr != nil {
			return errors.Wrap(_actualValueErr, "Error serializing 'actualValue' field")
		}

		if popErr := writeBuffer.PopContext("BACnetConstructedDataValueSet"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetConstructedDataValueSet")
		}
		return nil
	}
	return m.BACnetConstructedDataContract.(*_BACnetConstructedData).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetConstructedDataValueSet) IsBACnetConstructedDataValueSet() {}

func (m *_BACnetConstructedDataValueSet) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetConstructedDataValueSet) deepCopy() *_BACnetConstructedDataValueSet {
	if m == nil {
		return nil
	}
	_BACnetConstructedDataValueSetCopy := &_BACnetConstructedDataValueSet{
		m.BACnetConstructedDataContract.(*_BACnetConstructedData).deepCopy(),
		utils.DeepCopy[BACnetApplicationTagUnsignedInteger](m.ValueSet),
	}
	_BACnetConstructedDataValueSetCopy.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = m
	return _BACnetConstructedDataValueSetCopy
}

func (m *_BACnetConstructedDataValueSet) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
