/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetConstructedDataTimerRunning is the corresponding interface of BACnetConstructedDataTimerRunning
type BACnetConstructedDataTimerRunning interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetConstructedData
	// GetTimerRunning returns TimerRunning (property field)
	GetTimerRunning() BACnetApplicationTagBoolean
	// GetActualValue returns ActualValue (virtual field)
	GetActualValue() BACnetApplicationTagBoolean
	// IsBACnetConstructedDataTimerRunning is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetConstructedDataTimerRunning()
	// CreateBuilder creates a BACnetConstructedDataTimerRunningBuilder
	CreateBACnetConstructedDataTimerRunningBuilder() BACnetConstructedDataTimerRunningBuilder
}

// _BACnetConstructedDataTimerRunning is the data-structure of this message
type _BACnetConstructedDataTimerRunning struct {
	BACnetConstructedDataContract
	TimerRunning BACnetApplicationTagBoolean
}

var _ BACnetConstructedDataTimerRunning = (*_BACnetConstructedDataTimerRunning)(nil)
var _ BACnetConstructedDataRequirements = (*_BACnetConstructedDataTimerRunning)(nil)

// NewBACnetConstructedDataTimerRunning factory function for _BACnetConstructedDataTimerRunning
func NewBACnetConstructedDataTimerRunning(openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag, timerRunning BACnetApplicationTagBoolean, tagNumber uint8, arrayIndexArgument BACnetTagPayloadUnsignedInteger) *_BACnetConstructedDataTimerRunning {
	if timerRunning == nil {
		panic("timerRunning of type BACnetApplicationTagBoolean for BACnetConstructedDataTimerRunning must not be nil")
	}
	_result := &_BACnetConstructedDataTimerRunning{
		BACnetConstructedDataContract: NewBACnetConstructedData(openingTag, peekedTagHeader, closingTag, tagNumber, arrayIndexArgument),
		TimerRunning:                  timerRunning,
	}
	_result.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetConstructedDataTimerRunningBuilder is a builder for BACnetConstructedDataTimerRunning
type BACnetConstructedDataTimerRunningBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(timerRunning BACnetApplicationTagBoolean) BACnetConstructedDataTimerRunningBuilder
	// WithTimerRunning adds TimerRunning (property field)
	WithTimerRunning(BACnetApplicationTagBoolean) BACnetConstructedDataTimerRunningBuilder
	// WithTimerRunningBuilder adds TimerRunning (property field) which is build by the builder
	WithTimerRunningBuilder(func(BACnetApplicationTagBooleanBuilder) BACnetApplicationTagBooleanBuilder) BACnetConstructedDataTimerRunningBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetConstructedDataBuilder
	// Build builds the BACnetConstructedDataTimerRunning or returns an error if something is wrong
	Build() (BACnetConstructedDataTimerRunning, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetConstructedDataTimerRunning
}

// NewBACnetConstructedDataTimerRunningBuilder() creates a BACnetConstructedDataTimerRunningBuilder
func NewBACnetConstructedDataTimerRunningBuilder() BACnetConstructedDataTimerRunningBuilder {
	return &_BACnetConstructedDataTimerRunningBuilder{_BACnetConstructedDataTimerRunning: new(_BACnetConstructedDataTimerRunning)}
}

type _BACnetConstructedDataTimerRunningBuilder struct {
	*_BACnetConstructedDataTimerRunning

	parentBuilder *_BACnetConstructedDataBuilder

	err *utils.MultiError
}

var _ (BACnetConstructedDataTimerRunningBuilder) = (*_BACnetConstructedDataTimerRunningBuilder)(nil)

func (b *_BACnetConstructedDataTimerRunningBuilder) setParent(contract BACnetConstructedDataContract) {
	b.BACnetConstructedDataContract = contract
	contract.(*_BACnetConstructedData)._SubType = b._BACnetConstructedDataTimerRunning
}

func (b *_BACnetConstructedDataTimerRunningBuilder) WithMandatoryFields(timerRunning BACnetApplicationTagBoolean) BACnetConstructedDataTimerRunningBuilder {
	return b.WithTimerRunning(timerRunning)
}

func (b *_BACnetConstructedDataTimerRunningBuilder) WithTimerRunning(timerRunning BACnetApplicationTagBoolean) BACnetConstructedDataTimerRunningBuilder {
	b.TimerRunning = timerRunning
	return b
}

func (b *_BACnetConstructedDataTimerRunningBuilder) WithTimerRunningBuilder(builderSupplier func(BACnetApplicationTagBooleanBuilder) BACnetApplicationTagBooleanBuilder) BACnetConstructedDataTimerRunningBuilder {
	builder := builderSupplier(b.TimerRunning.CreateBACnetApplicationTagBooleanBuilder())
	var err error
	b.TimerRunning, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "BACnetApplicationTagBooleanBuilder failed"))
	}
	return b
}

func (b *_BACnetConstructedDataTimerRunningBuilder) Build() (BACnetConstructedDataTimerRunning, error) {
	if b.TimerRunning == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'timerRunning' not set"))
	}
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._BACnetConstructedDataTimerRunning.deepCopy(), nil
}

func (b *_BACnetConstructedDataTimerRunningBuilder) MustBuild() BACnetConstructedDataTimerRunning {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetConstructedDataTimerRunningBuilder) Done() BACnetConstructedDataBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetConstructedDataBuilder().(*_BACnetConstructedDataBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetConstructedDataTimerRunningBuilder) buildForBACnetConstructedData() (BACnetConstructedData, error) {
	return b.Build()
}

func (b *_BACnetConstructedDataTimerRunningBuilder) DeepCopy() any {
	_copy := b.CreateBACnetConstructedDataTimerRunningBuilder().(*_BACnetConstructedDataTimerRunningBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateBACnetConstructedDataTimerRunningBuilder creates a BACnetConstructedDataTimerRunningBuilder
func (b *_BACnetConstructedDataTimerRunning) CreateBACnetConstructedDataTimerRunningBuilder() BACnetConstructedDataTimerRunningBuilder {
	if b == nil {
		return NewBACnetConstructedDataTimerRunningBuilder()
	}
	return &_BACnetConstructedDataTimerRunningBuilder{_BACnetConstructedDataTimerRunning: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_BACnetConstructedDataTimerRunning) GetObjectTypeArgument() BACnetObjectType {
	return 0
}

func (m *_BACnetConstructedDataTimerRunning) GetPropertyIdentifierArgument() BACnetPropertyIdentifier {
	return BACnetPropertyIdentifier_TIMER_RUNNING
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetConstructedDataTimerRunning) GetParent() BACnetConstructedDataContract {
	return m.BACnetConstructedDataContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetConstructedDataTimerRunning) GetTimerRunning() BACnetApplicationTagBoolean {
	return m.TimerRunning
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for virtual fields.
///////////////////////

func (m *_BACnetConstructedDataTimerRunning) GetActualValue() BACnetApplicationTagBoolean {
	ctx := context.Background()
	_ = ctx
	return CastBACnetApplicationTagBoolean(m.GetTimerRunning())
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetConstructedDataTimerRunning(structType any) BACnetConstructedDataTimerRunning {
	if casted, ok := structType.(BACnetConstructedDataTimerRunning); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetConstructedDataTimerRunning); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetConstructedDataTimerRunning) GetTypeName() string {
	return "BACnetConstructedDataTimerRunning"
}

func (m *_BACnetConstructedDataTimerRunning) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetConstructedDataContract.(*_BACnetConstructedData).getLengthInBits(ctx))

	// Simple field (timerRunning)
	lengthInBits += m.TimerRunning.GetLengthInBits(ctx)

	// A virtual field doesn't have any in- or output.

	return lengthInBits
}

func (m *_BACnetConstructedDataTimerRunning) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetConstructedDataTimerRunning) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetConstructedData, tagNumber uint8, objectTypeArgument BACnetObjectType, propertyIdentifierArgument BACnetPropertyIdentifier, arrayIndexArgument BACnetTagPayloadUnsignedInteger) (__bACnetConstructedDataTimerRunning BACnetConstructedDataTimerRunning, err error) {
	m.BACnetConstructedDataContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetConstructedDataTimerRunning"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetConstructedDataTimerRunning")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	timerRunning, err := ReadSimpleField[BACnetApplicationTagBoolean](ctx, "timerRunning", ReadComplex[BACnetApplicationTagBoolean](BACnetApplicationTagParseWithBufferProducer[BACnetApplicationTagBoolean](), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'timerRunning' field"))
	}
	m.TimerRunning = timerRunning

	actualValue, err := ReadVirtualField[BACnetApplicationTagBoolean](ctx, "actualValue", (*BACnetApplicationTagBoolean)(nil), timerRunning)
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'actualValue' field"))
	}
	_ = actualValue

	if closeErr := readBuffer.CloseContext("BACnetConstructedDataTimerRunning"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetConstructedDataTimerRunning")
	}

	return m, nil
}

func (m *_BACnetConstructedDataTimerRunning) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetConstructedDataTimerRunning) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetConstructedDataTimerRunning"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetConstructedDataTimerRunning")
		}

		if err := WriteSimpleField[BACnetApplicationTagBoolean](ctx, "timerRunning", m.GetTimerRunning(), WriteComplex[BACnetApplicationTagBoolean](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'timerRunning' field")
		}
		// Virtual field
		actualValue := m.GetActualValue()
		_ = actualValue
		if _actualValueErr := writeBuffer.WriteVirtual(ctx, "actualValue", m.GetActualValue()); _actualValueErr != nil {
			return errors.Wrap(_actualValueErr, "Error serializing 'actualValue' field")
		}

		if popErr := writeBuffer.PopContext("BACnetConstructedDataTimerRunning"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetConstructedDataTimerRunning")
		}
		return nil
	}
	return m.BACnetConstructedDataContract.(*_BACnetConstructedData).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetConstructedDataTimerRunning) IsBACnetConstructedDataTimerRunning() {}

func (m *_BACnetConstructedDataTimerRunning) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetConstructedDataTimerRunning) deepCopy() *_BACnetConstructedDataTimerRunning {
	if m == nil {
		return nil
	}
	_BACnetConstructedDataTimerRunningCopy := &_BACnetConstructedDataTimerRunning{
		m.BACnetConstructedDataContract.(*_BACnetConstructedData).deepCopy(),
		utils.DeepCopy[BACnetApplicationTagBoolean](m.TimerRunning),
	}
	_BACnetConstructedDataTimerRunningCopy.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = m
	return _BACnetConstructedDataTimerRunningCopy
}

func (m *_BACnetConstructedDataTimerRunning) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
