/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetConstructedDataSlaveAddressBinding is the corresponding interface of BACnetConstructedDataSlaveAddressBinding
type BACnetConstructedDataSlaveAddressBinding interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetConstructedData
	// GetSlaveAddressBinding returns SlaveAddressBinding (property field)
	GetSlaveAddressBinding() []BACnetAddressBinding
	// IsBACnetConstructedDataSlaveAddressBinding is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetConstructedDataSlaveAddressBinding()
	// CreateBuilder creates a BACnetConstructedDataSlaveAddressBindingBuilder
	CreateBACnetConstructedDataSlaveAddressBindingBuilder() BACnetConstructedDataSlaveAddressBindingBuilder
}

// _BACnetConstructedDataSlaveAddressBinding is the data-structure of this message
type _BACnetConstructedDataSlaveAddressBinding struct {
	BACnetConstructedDataContract
	SlaveAddressBinding []BACnetAddressBinding
}

var _ BACnetConstructedDataSlaveAddressBinding = (*_BACnetConstructedDataSlaveAddressBinding)(nil)
var _ BACnetConstructedDataRequirements = (*_BACnetConstructedDataSlaveAddressBinding)(nil)

// NewBACnetConstructedDataSlaveAddressBinding factory function for _BACnetConstructedDataSlaveAddressBinding
func NewBACnetConstructedDataSlaveAddressBinding(openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag, slaveAddressBinding []BACnetAddressBinding, tagNumber uint8, arrayIndexArgument BACnetTagPayloadUnsignedInteger) *_BACnetConstructedDataSlaveAddressBinding {
	_result := &_BACnetConstructedDataSlaveAddressBinding{
		BACnetConstructedDataContract: NewBACnetConstructedData(openingTag, peekedTagHeader, closingTag, tagNumber, arrayIndexArgument),
		SlaveAddressBinding:           slaveAddressBinding,
	}
	_result.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetConstructedDataSlaveAddressBindingBuilder is a builder for BACnetConstructedDataSlaveAddressBinding
type BACnetConstructedDataSlaveAddressBindingBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(slaveAddressBinding []BACnetAddressBinding) BACnetConstructedDataSlaveAddressBindingBuilder
	// WithSlaveAddressBinding adds SlaveAddressBinding (property field)
	WithSlaveAddressBinding(...BACnetAddressBinding) BACnetConstructedDataSlaveAddressBindingBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetConstructedDataBuilder
	// Build builds the BACnetConstructedDataSlaveAddressBinding or returns an error if something is wrong
	Build() (BACnetConstructedDataSlaveAddressBinding, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetConstructedDataSlaveAddressBinding
}

// NewBACnetConstructedDataSlaveAddressBindingBuilder() creates a BACnetConstructedDataSlaveAddressBindingBuilder
func NewBACnetConstructedDataSlaveAddressBindingBuilder() BACnetConstructedDataSlaveAddressBindingBuilder {
	return &_BACnetConstructedDataSlaveAddressBindingBuilder{_BACnetConstructedDataSlaveAddressBinding: new(_BACnetConstructedDataSlaveAddressBinding)}
}

type _BACnetConstructedDataSlaveAddressBindingBuilder struct {
	*_BACnetConstructedDataSlaveAddressBinding

	parentBuilder *_BACnetConstructedDataBuilder

	err *utils.MultiError
}

var _ (BACnetConstructedDataSlaveAddressBindingBuilder) = (*_BACnetConstructedDataSlaveAddressBindingBuilder)(nil)

func (b *_BACnetConstructedDataSlaveAddressBindingBuilder) setParent(contract BACnetConstructedDataContract) {
	b.BACnetConstructedDataContract = contract
	contract.(*_BACnetConstructedData)._SubType = b._BACnetConstructedDataSlaveAddressBinding
}

func (b *_BACnetConstructedDataSlaveAddressBindingBuilder) WithMandatoryFields(slaveAddressBinding []BACnetAddressBinding) BACnetConstructedDataSlaveAddressBindingBuilder {
	return b.WithSlaveAddressBinding(slaveAddressBinding...)
}

func (b *_BACnetConstructedDataSlaveAddressBindingBuilder) WithSlaveAddressBinding(slaveAddressBinding ...BACnetAddressBinding) BACnetConstructedDataSlaveAddressBindingBuilder {
	b.SlaveAddressBinding = slaveAddressBinding
	return b
}

func (b *_BACnetConstructedDataSlaveAddressBindingBuilder) Build() (BACnetConstructedDataSlaveAddressBinding, error) {
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._BACnetConstructedDataSlaveAddressBinding.deepCopy(), nil
}

func (b *_BACnetConstructedDataSlaveAddressBindingBuilder) MustBuild() BACnetConstructedDataSlaveAddressBinding {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetConstructedDataSlaveAddressBindingBuilder) Done() BACnetConstructedDataBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetConstructedDataBuilder().(*_BACnetConstructedDataBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetConstructedDataSlaveAddressBindingBuilder) buildForBACnetConstructedData() (BACnetConstructedData, error) {
	return b.Build()
}

func (b *_BACnetConstructedDataSlaveAddressBindingBuilder) DeepCopy() any {
	_copy := b.CreateBACnetConstructedDataSlaveAddressBindingBuilder().(*_BACnetConstructedDataSlaveAddressBindingBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateBACnetConstructedDataSlaveAddressBindingBuilder creates a BACnetConstructedDataSlaveAddressBindingBuilder
func (b *_BACnetConstructedDataSlaveAddressBinding) CreateBACnetConstructedDataSlaveAddressBindingBuilder() BACnetConstructedDataSlaveAddressBindingBuilder {
	if b == nil {
		return NewBACnetConstructedDataSlaveAddressBindingBuilder()
	}
	return &_BACnetConstructedDataSlaveAddressBindingBuilder{_BACnetConstructedDataSlaveAddressBinding: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_BACnetConstructedDataSlaveAddressBinding) GetObjectTypeArgument() BACnetObjectType {
	return 0
}

func (m *_BACnetConstructedDataSlaveAddressBinding) GetPropertyIdentifierArgument() BACnetPropertyIdentifier {
	return BACnetPropertyIdentifier_SLAVE_ADDRESS_BINDING
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetConstructedDataSlaveAddressBinding) GetParent() BACnetConstructedDataContract {
	return m.BACnetConstructedDataContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetConstructedDataSlaveAddressBinding) GetSlaveAddressBinding() []BACnetAddressBinding {
	return m.SlaveAddressBinding
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetConstructedDataSlaveAddressBinding(structType any) BACnetConstructedDataSlaveAddressBinding {
	if casted, ok := structType.(BACnetConstructedDataSlaveAddressBinding); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetConstructedDataSlaveAddressBinding); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetConstructedDataSlaveAddressBinding) GetTypeName() string {
	return "BACnetConstructedDataSlaveAddressBinding"
}

func (m *_BACnetConstructedDataSlaveAddressBinding) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetConstructedDataContract.(*_BACnetConstructedData).getLengthInBits(ctx))

	// Array field
	if len(m.SlaveAddressBinding) > 0 {
		for _, element := range m.SlaveAddressBinding {
			lengthInBits += element.GetLengthInBits(ctx)
		}
	}

	return lengthInBits
}

func (m *_BACnetConstructedDataSlaveAddressBinding) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetConstructedDataSlaveAddressBinding) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetConstructedData, tagNumber uint8, objectTypeArgument BACnetObjectType, propertyIdentifierArgument BACnetPropertyIdentifier, arrayIndexArgument BACnetTagPayloadUnsignedInteger) (__bACnetConstructedDataSlaveAddressBinding BACnetConstructedDataSlaveAddressBinding, err error) {
	m.BACnetConstructedDataContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetConstructedDataSlaveAddressBinding"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetConstructedDataSlaveAddressBinding")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	slaveAddressBinding, err := ReadTerminatedArrayField[BACnetAddressBinding](ctx, "slaveAddressBinding", ReadComplex[BACnetAddressBinding](BACnetAddressBindingParseWithBuffer, readBuffer), IsBACnetConstructedDataClosingTag(ctx, readBuffer, false, tagNumber))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'slaveAddressBinding' field"))
	}
	m.SlaveAddressBinding = slaveAddressBinding

	if closeErr := readBuffer.CloseContext("BACnetConstructedDataSlaveAddressBinding"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetConstructedDataSlaveAddressBinding")
	}

	return m, nil
}

func (m *_BACnetConstructedDataSlaveAddressBinding) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetConstructedDataSlaveAddressBinding) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetConstructedDataSlaveAddressBinding"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetConstructedDataSlaveAddressBinding")
		}

		if err := WriteComplexTypeArrayField(ctx, "slaveAddressBinding", m.GetSlaveAddressBinding(), writeBuffer); err != nil {
			return errors.Wrap(err, "Error serializing 'slaveAddressBinding' field")
		}

		if popErr := writeBuffer.PopContext("BACnetConstructedDataSlaveAddressBinding"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetConstructedDataSlaveAddressBinding")
		}
		return nil
	}
	return m.BACnetConstructedDataContract.(*_BACnetConstructedData).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetConstructedDataSlaveAddressBinding) IsBACnetConstructedDataSlaveAddressBinding() {}

func (m *_BACnetConstructedDataSlaveAddressBinding) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetConstructedDataSlaveAddressBinding) deepCopy() *_BACnetConstructedDataSlaveAddressBinding {
	if m == nil {
		return nil
	}
	_BACnetConstructedDataSlaveAddressBindingCopy := &_BACnetConstructedDataSlaveAddressBinding{
		m.BACnetConstructedDataContract.(*_BACnetConstructedData).deepCopy(),
		utils.DeepCopySlice[BACnetAddressBinding, BACnetAddressBinding](m.SlaveAddressBinding),
	}
	_BACnetConstructedDataSlaveAddressBindingCopy.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = m
	return _BACnetConstructedDataSlaveAddressBindingCopy
}

func (m *_BACnetConstructedDataSlaveAddressBinding) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
