/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetConstructedDataShedLevelDescriptions is the corresponding interface of BACnetConstructedDataShedLevelDescriptions
type BACnetConstructedDataShedLevelDescriptions interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetConstructedData
	// GetNumberOfDataElements returns NumberOfDataElements (property field)
	GetNumberOfDataElements() BACnetApplicationTagUnsignedInteger
	// GetShedLevelDescriptions returns ShedLevelDescriptions (property field)
	GetShedLevelDescriptions() []BACnetApplicationTagCharacterString
	// GetZero returns Zero (virtual field)
	GetZero() uint64
	// IsBACnetConstructedDataShedLevelDescriptions is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetConstructedDataShedLevelDescriptions()
	// CreateBuilder creates a BACnetConstructedDataShedLevelDescriptionsBuilder
	CreateBACnetConstructedDataShedLevelDescriptionsBuilder() BACnetConstructedDataShedLevelDescriptionsBuilder
}

// _BACnetConstructedDataShedLevelDescriptions is the data-structure of this message
type _BACnetConstructedDataShedLevelDescriptions struct {
	BACnetConstructedDataContract
	NumberOfDataElements  BACnetApplicationTagUnsignedInteger
	ShedLevelDescriptions []BACnetApplicationTagCharacterString
}

var _ BACnetConstructedDataShedLevelDescriptions = (*_BACnetConstructedDataShedLevelDescriptions)(nil)
var _ BACnetConstructedDataRequirements = (*_BACnetConstructedDataShedLevelDescriptions)(nil)

// NewBACnetConstructedDataShedLevelDescriptions factory function for _BACnetConstructedDataShedLevelDescriptions
func NewBACnetConstructedDataShedLevelDescriptions(openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag, numberOfDataElements BACnetApplicationTagUnsignedInteger, shedLevelDescriptions []BACnetApplicationTagCharacterString, tagNumber uint8, arrayIndexArgument BACnetTagPayloadUnsignedInteger) *_BACnetConstructedDataShedLevelDescriptions {
	_result := &_BACnetConstructedDataShedLevelDescriptions{
		BACnetConstructedDataContract: NewBACnetConstructedData(openingTag, peekedTagHeader, closingTag, tagNumber, arrayIndexArgument),
		NumberOfDataElements:          numberOfDataElements,
		ShedLevelDescriptions:         shedLevelDescriptions,
	}
	_result.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetConstructedDataShedLevelDescriptionsBuilder is a builder for BACnetConstructedDataShedLevelDescriptions
type BACnetConstructedDataShedLevelDescriptionsBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(shedLevelDescriptions []BACnetApplicationTagCharacterString) BACnetConstructedDataShedLevelDescriptionsBuilder
	// WithNumberOfDataElements adds NumberOfDataElements (property field)
	WithOptionalNumberOfDataElements(BACnetApplicationTagUnsignedInteger) BACnetConstructedDataShedLevelDescriptionsBuilder
	// WithOptionalNumberOfDataElementsBuilder adds NumberOfDataElements (property field) which is build by the builder
	WithOptionalNumberOfDataElementsBuilder(func(BACnetApplicationTagUnsignedIntegerBuilder) BACnetApplicationTagUnsignedIntegerBuilder) BACnetConstructedDataShedLevelDescriptionsBuilder
	// WithShedLevelDescriptions adds ShedLevelDescriptions (property field)
	WithShedLevelDescriptions(...BACnetApplicationTagCharacterString) BACnetConstructedDataShedLevelDescriptionsBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetConstructedDataBuilder
	// Build builds the BACnetConstructedDataShedLevelDescriptions or returns an error if something is wrong
	Build() (BACnetConstructedDataShedLevelDescriptions, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetConstructedDataShedLevelDescriptions
}

// NewBACnetConstructedDataShedLevelDescriptionsBuilder() creates a BACnetConstructedDataShedLevelDescriptionsBuilder
func NewBACnetConstructedDataShedLevelDescriptionsBuilder() BACnetConstructedDataShedLevelDescriptionsBuilder {
	return &_BACnetConstructedDataShedLevelDescriptionsBuilder{_BACnetConstructedDataShedLevelDescriptions: new(_BACnetConstructedDataShedLevelDescriptions)}
}

type _BACnetConstructedDataShedLevelDescriptionsBuilder struct {
	*_BACnetConstructedDataShedLevelDescriptions

	parentBuilder *_BACnetConstructedDataBuilder

	err *utils.MultiError
}

var _ (BACnetConstructedDataShedLevelDescriptionsBuilder) = (*_BACnetConstructedDataShedLevelDescriptionsBuilder)(nil)

func (b *_BACnetConstructedDataShedLevelDescriptionsBuilder) setParent(contract BACnetConstructedDataContract) {
	b.BACnetConstructedDataContract = contract
	contract.(*_BACnetConstructedData)._SubType = b._BACnetConstructedDataShedLevelDescriptions
}

func (b *_BACnetConstructedDataShedLevelDescriptionsBuilder) WithMandatoryFields(shedLevelDescriptions []BACnetApplicationTagCharacterString) BACnetConstructedDataShedLevelDescriptionsBuilder {
	return b.WithShedLevelDescriptions(shedLevelDescriptions...)
}

func (b *_BACnetConstructedDataShedLevelDescriptionsBuilder) WithOptionalNumberOfDataElements(numberOfDataElements BACnetApplicationTagUnsignedInteger) BACnetConstructedDataShedLevelDescriptionsBuilder {
	b.NumberOfDataElements = numberOfDataElements
	return b
}

func (b *_BACnetConstructedDataShedLevelDescriptionsBuilder) WithOptionalNumberOfDataElementsBuilder(builderSupplier func(BACnetApplicationTagUnsignedIntegerBuilder) BACnetApplicationTagUnsignedIntegerBuilder) BACnetConstructedDataShedLevelDescriptionsBuilder {
	builder := builderSupplier(b.NumberOfDataElements.CreateBACnetApplicationTagUnsignedIntegerBuilder())
	var err error
	b.NumberOfDataElements, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "BACnetApplicationTagUnsignedIntegerBuilder failed"))
	}
	return b
}

func (b *_BACnetConstructedDataShedLevelDescriptionsBuilder) WithShedLevelDescriptions(shedLevelDescriptions ...BACnetApplicationTagCharacterString) BACnetConstructedDataShedLevelDescriptionsBuilder {
	b.ShedLevelDescriptions = shedLevelDescriptions
	return b
}

func (b *_BACnetConstructedDataShedLevelDescriptionsBuilder) Build() (BACnetConstructedDataShedLevelDescriptions, error) {
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._BACnetConstructedDataShedLevelDescriptions.deepCopy(), nil
}

func (b *_BACnetConstructedDataShedLevelDescriptionsBuilder) MustBuild() BACnetConstructedDataShedLevelDescriptions {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetConstructedDataShedLevelDescriptionsBuilder) Done() BACnetConstructedDataBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetConstructedDataBuilder().(*_BACnetConstructedDataBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetConstructedDataShedLevelDescriptionsBuilder) buildForBACnetConstructedData() (BACnetConstructedData, error) {
	return b.Build()
}

func (b *_BACnetConstructedDataShedLevelDescriptionsBuilder) DeepCopy() any {
	_copy := b.CreateBACnetConstructedDataShedLevelDescriptionsBuilder().(*_BACnetConstructedDataShedLevelDescriptionsBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateBACnetConstructedDataShedLevelDescriptionsBuilder creates a BACnetConstructedDataShedLevelDescriptionsBuilder
func (b *_BACnetConstructedDataShedLevelDescriptions) CreateBACnetConstructedDataShedLevelDescriptionsBuilder() BACnetConstructedDataShedLevelDescriptionsBuilder {
	if b == nil {
		return NewBACnetConstructedDataShedLevelDescriptionsBuilder()
	}
	return &_BACnetConstructedDataShedLevelDescriptionsBuilder{_BACnetConstructedDataShedLevelDescriptions: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_BACnetConstructedDataShedLevelDescriptions) GetObjectTypeArgument() BACnetObjectType {
	return 0
}

func (m *_BACnetConstructedDataShedLevelDescriptions) GetPropertyIdentifierArgument() BACnetPropertyIdentifier {
	return BACnetPropertyIdentifier_SHED_LEVEL_DESCRIPTIONS
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetConstructedDataShedLevelDescriptions) GetParent() BACnetConstructedDataContract {
	return m.BACnetConstructedDataContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetConstructedDataShedLevelDescriptions) GetNumberOfDataElements() BACnetApplicationTagUnsignedInteger {
	return m.NumberOfDataElements
}

func (m *_BACnetConstructedDataShedLevelDescriptions) GetShedLevelDescriptions() []BACnetApplicationTagCharacterString {
	return m.ShedLevelDescriptions
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for virtual fields.
///////////////////////

func (m *_BACnetConstructedDataShedLevelDescriptions) GetZero() uint64 {
	ctx := context.Background()
	_ = ctx
	numberOfDataElements := m.GetNumberOfDataElements()
	_ = numberOfDataElements
	return uint64(uint64(0))
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetConstructedDataShedLevelDescriptions(structType any) BACnetConstructedDataShedLevelDescriptions {
	if casted, ok := structType.(BACnetConstructedDataShedLevelDescriptions); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetConstructedDataShedLevelDescriptions); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetConstructedDataShedLevelDescriptions) GetTypeName() string {
	return "BACnetConstructedDataShedLevelDescriptions"
}

func (m *_BACnetConstructedDataShedLevelDescriptions) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetConstructedDataContract.(*_BACnetConstructedData).getLengthInBits(ctx))

	// A virtual field doesn't have any in- or output.

	// Optional Field (numberOfDataElements)
	if m.NumberOfDataElements != nil {
		lengthInBits += m.NumberOfDataElements.GetLengthInBits(ctx)
	}

	// Array field
	if len(m.ShedLevelDescriptions) > 0 {
		for _, element := range m.ShedLevelDescriptions {
			lengthInBits += element.GetLengthInBits(ctx)
		}
	}

	return lengthInBits
}

func (m *_BACnetConstructedDataShedLevelDescriptions) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetConstructedDataShedLevelDescriptions) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetConstructedData, tagNumber uint8, objectTypeArgument BACnetObjectType, propertyIdentifierArgument BACnetPropertyIdentifier, arrayIndexArgument BACnetTagPayloadUnsignedInteger) (__bACnetConstructedDataShedLevelDescriptions BACnetConstructedDataShedLevelDescriptions, err error) {
	m.BACnetConstructedDataContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetConstructedDataShedLevelDescriptions"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetConstructedDataShedLevelDescriptions")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	zero, err := ReadVirtualField[uint64](ctx, "zero", (*uint64)(nil), uint64(0))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'zero' field"))
	}
	_ = zero

	var numberOfDataElements BACnetApplicationTagUnsignedInteger
	_numberOfDataElements, err := ReadOptionalField[BACnetApplicationTagUnsignedInteger](ctx, "numberOfDataElements", ReadComplex[BACnetApplicationTagUnsignedInteger](BACnetApplicationTagParseWithBufferProducer[BACnetApplicationTagUnsignedInteger](), readBuffer), bool(bool((arrayIndexArgument) != (nil))) && bool(bool((arrayIndexArgument.GetActualValue()) == (zero))))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'numberOfDataElements' field"))
	}
	if _numberOfDataElements != nil {
		numberOfDataElements = *_numberOfDataElements
		m.NumberOfDataElements = numberOfDataElements
	}

	shedLevelDescriptions, err := ReadTerminatedArrayField[BACnetApplicationTagCharacterString](ctx, "shedLevelDescriptions", ReadComplex[BACnetApplicationTagCharacterString](BACnetApplicationTagParseWithBufferProducer[BACnetApplicationTagCharacterString](), readBuffer), IsBACnetConstructedDataClosingTag(ctx, readBuffer, false, tagNumber))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'shedLevelDescriptions' field"))
	}
	m.ShedLevelDescriptions = shedLevelDescriptions

	if closeErr := readBuffer.CloseContext("BACnetConstructedDataShedLevelDescriptions"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetConstructedDataShedLevelDescriptions")
	}

	return m, nil
}

func (m *_BACnetConstructedDataShedLevelDescriptions) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetConstructedDataShedLevelDescriptions) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetConstructedDataShedLevelDescriptions"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetConstructedDataShedLevelDescriptions")
		}
		// Virtual field
		zero := m.GetZero()
		_ = zero
		if _zeroErr := writeBuffer.WriteVirtual(ctx, "zero", m.GetZero()); _zeroErr != nil {
			return errors.Wrap(_zeroErr, "Error serializing 'zero' field")
		}

		if err := WriteOptionalField[BACnetApplicationTagUnsignedInteger](ctx, "numberOfDataElements", GetRef(m.GetNumberOfDataElements()), WriteComplex[BACnetApplicationTagUnsignedInteger](writeBuffer), true); err != nil {
			return errors.Wrap(err, "Error serializing 'numberOfDataElements' field")
		}

		if err := WriteComplexTypeArrayField(ctx, "shedLevelDescriptions", m.GetShedLevelDescriptions(), writeBuffer); err != nil {
			return errors.Wrap(err, "Error serializing 'shedLevelDescriptions' field")
		}

		if popErr := writeBuffer.PopContext("BACnetConstructedDataShedLevelDescriptions"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetConstructedDataShedLevelDescriptions")
		}
		return nil
	}
	return m.BACnetConstructedDataContract.(*_BACnetConstructedData).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetConstructedDataShedLevelDescriptions) IsBACnetConstructedDataShedLevelDescriptions() {
}

func (m *_BACnetConstructedDataShedLevelDescriptions) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetConstructedDataShedLevelDescriptions) deepCopy() *_BACnetConstructedDataShedLevelDescriptions {
	if m == nil {
		return nil
	}
	_BACnetConstructedDataShedLevelDescriptionsCopy := &_BACnetConstructedDataShedLevelDescriptions{
		m.BACnetConstructedDataContract.(*_BACnetConstructedData).deepCopy(),
		utils.DeepCopy[BACnetApplicationTagUnsignedInteger](m.NumberOfDataElements),
		utils.DeepCopySlice[BACnetApplicationTagCharacterString, BACnetApplicationTagCharacterString](m.ShedLevelDescriptions),
	}
	_BACnetConstructedDataShedLevelDescriptionsCopy.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = m
	return _BACnetConstructedDataShedLevelDescriptionsCopy
}

func (m *_BACnetConstructedDataShedLevelDescriptions) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
