/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetConstructedDataSetpoint is the corresponding interface of BACnetConstructedDataSetpoint
type BACnetConstructedDataSetpoint interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetConstructedData
	// GetSetpoint returns Setpoint (property field)
	GetSetpoint() BACnetApplicationTagReal
	// GetActualValue returns ActualValue (virtual field)
	GetActualValue() BACnetApplicationTagReal
	// IsBACnetConstructedDataSetpoint is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetConstructedDataSetpoint()
	// CreateBuilder creates a BACnetConstructedDataSetpointBuilder
	CreateBACnetConstructedDataSetpointBuilder() BACnetConstructedDataSetpointBuilder
}

// _BACnetConstructedDataSetpoint is the data-structure of this message
type _BACnetConstructedDataSetpoint struct {
	BACnetConstructedDataContract
	Setpoint BACnetApplicationTagReal
}

var _ BACnetConstructedDataSetpoint = (*_BACnetConstructedDataSetpoint)(nil)
var _ BACnetConstructedDataRequirements = (*_BACnetConstructedDataSetpoint)(nil)

// NewBACnetConstructedDataSetpoint factory function for _BACnetConstructedDataSetpoint
func NewBACnetConstructedDataSetpoint(openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag, setpoint BACnetApplicationTagReal, tagNumber uint8, arrayIndexArgument BACnetTagPayloadUnsignedInteger) *_BACnetConstructedDataSetpoint {
	if setpoint == nil {
		panic("setpoint of type BACnetApplicationTagReal for BACnetConstructedDataSetpoint must not be nil")
	}
	_result := &_BACnetConstructedDataSetpoint{
		BACnetConstructedDataContract: NewBACnetConstructedData(openingTag, peekedTagHeader, closingTag, tagNumber, arrayIndexArgument),
		Setpoint:                      setpoint,
	}
	_result.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetConstructedDataSetpointBuilder is a builder for BACnetConstructedDataSetpoint
type BACnetConstructedDataSetpointBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(setpoint BACnetApplicationTagReal) BACnetConstructedDataSetpointBuilder
	// WithSetpoint adds Setpoint (property field)
	WithSetpoint(BACnetApplicationTagReal) BACnetConstructedDataSetpointBuilder
	// WithSetpointBuilder adds Setpoint (property field) which is build by the builder
	WithSetpointBuilder(func(BACnetApplicationTagRealBuilder) BACnetApplicationTagRealBuilder) BACnetConstructedDataSetpointBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetConstructedDataBuilder
	// Build builds the BACnetConstructedDataSetpoint or returns an error if something is wrong
	Build() (BACnetConstructedDataSetpoint, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetConstructedDataSetpoint
}

// NewBACnetConstructedDataSetpointBuilder() creates a BACnetConstructedDataSetpointBuilder
func NewBACnetConstructedDataSetpointBuilder() BACnetConstructedDataSetpointBuilder {
	return &_BACnetConstructedDataSetpointBuilder{_BACnetConstructedDataSetpoint: new(_BACnetConstructedDataSetpoint)}
}

type _BACnetConstructedDataSetpointBuilder struct {
	*_BACnetConstructedDataSetpoint

	parentBuilder *_BACnetConstructedDataBuilder

	err *utils.MultiError
}

var _ (BACnetConstructedDataSetpointBuilder) = (*_BACnetConstructedDataSetpointBuilder)(nil)

func (b *_BACnetConstructedDataSetpointBuilder) setParent(contract BACnetConstructedDataContract) {
	b.BACnetConstructedDataContract = contract
	contract.(*_BACnetConstructedData)._SubType = b._BACnetConstructedDataSetpoint
}

func (b *_BACnetConstructedDataSetpointBuilder) WithMandatoryFields(setpoint BACnetApplicationTagReal) BACnetConstructedDataSetpointBuilder {
	return b.WithSetpoint(setpoint)
}

func (b *_BACnetConstructedDataSetpointBuilder) WithSetpoint(setpoint BACnetApplicationTagReal) BACnetConstructedDataSetpointBuilder {
	b.Setpoint = setpoint
	return b
}

func (b *_BACnetConstructedDataSetpointBuilder) WithSetpointBuilder(builderSupplier func(BACnetApplicationTagRealBuilder) BACnetApplicationTagRealBuilder) BACnetConstructedDataSetpointBuilder {
	builder := builderSupplier(b.Setpoint.CreateBACnetApplicationTagRealBuilder())
	var err error
	b.Setpoint, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "BACnetApplicationTagRealBuilder failed"))
	}
	return b
}

func (b *_BACnetConstructedDataSetpointBuilder) Build() (BACnetConstructedDataSetpoint, error) {
	if b.Setpoint == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'setpoint' not set"))
	}
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._BACnetConstructedDataSetpoint.deepCopy(), nil
}

func (b *_BACnetConstructedDataSetpointBuilder) MustBuild() BACnetConstructedDataSetpoint {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetConstructedDataSetpointBuilder) Done() BACnetConstructedDataBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetConstructedDataBuilder().(*_BACnetConstructedDataBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetConstructedDataSetpointBuilder) buildForBACnetConstructedData() (BACnetConstructedData, error) {
	return b.Build()
}

func (b *_BACnetConstructedDataSetpointBuilder) DeepCopy() any {
	_copy := b.CreateBACnetConstructedDataSetpointBuilder().(*_BACnetConstructedDataSetpointBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateBACnetConstructedDataSetpointBuilder creates a BACnetConstructedDataSetpointBuilder
func (b *_BACnetConstructedDataSetpoint) CreateBACnetConstructedDataSetpointBuilder() BACnetConstructedDataSetpointBuilder {
	if b == nil {
		return NewBACnetConstructedDataSetpointBuilder()
	}
	return &_BACnetConstructedDataSetpointBuilder{_BACnetConstructedDataSetpoint: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_BACnetConstructedDataSetpoint) GetObjectTypeArgument() BACnetObjectType {
	return 0
}

func (m *_BACnetConstructedDataSetpoint) GetPropertyIdentifierArgument() BACnetPropertyIdentifier {
	return BACnetPropertyIdentifier_SETPOINT
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetConstructedDataSetpoint) GetParent() BACnetConstructedDataContract {
	return m.BACnetConstructedDataContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetConstructedDataSetpoint) GetSetpoint() BACnetApplicationTagReal {
	return m.Setpoint
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for virtual fields.
///////////////////////

func (m *_BACnetConstructedDataSetpoint) GetActualValue() BACnetApplicationTagReal {
	ctx := context.Background()
	_ = ctx
	return CastBACnetApplicationTagReal(m.GetSetpoint())
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetConstructedDataSetpoint(structType any) BACnetConstructedDataSetpoint {
	if casted, ok := structType.(BACnetConstructedDataSetpoint); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetConstructedDataSetpoint); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetConstructedDataSetpoint) GetTypeName() string {
	return "BACnetConstructedDataSetpoint"
}

func (m *_BACnetConstructedDataSetpoint) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetConstructedDataContract.(*_BACnetConstructedData).getLengthInBits(ctx))

	// Simple field (setpoint)
	lengthInBits += m.Setpoint.GetLengthInBits(ctx)

	// A virtual field doesn't have any in- or output.

	return lengthInBits
}

func (m *_BACnetConstructedDataSetpoint) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetConstructedDataSetpoint) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetConstructedData, tagNumber uint8, objectTypeArgument BACnetObjectType, propertyIdentifierArgument BACnetPropertyIdentifier, arrayIndexArgument BACnetTagPayloadUnsignedInteger) (__bACnetConstructedDataSetpoint BACnetConstructedDataSetpoint, err error) {
	m.BACnetConstructedDataContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetConstructedDataSetpoint"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetConstructedDataSetpoint")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	setpoint, err := ReadSimpleField[BACnetApplicationTagReal](ctx, "setpoint", ReadComplex[BACnetApplicationTagReal](BACnetApplicationTagParseWithBufferProducer[BACnetApplicationTagReal](), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'setpoint' field"))
	}
	m.Setpoint = setpoint

	actualValue, err := ReadVirtualField[BACnetApplicationTagReal](ctx, "actualValue", (*BACnetApplicationTagReal)(nil), setpoint)
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'actualValue' field"))
	}
	_ = actualValue

	if closeErr := readBuffer.CloseContext("BACnetConstructedDataSetpoint"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetConstructedDataSetpoint")
	}

	return m, nil
}

func (m *_BACnetConstructedDataSetpoint) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetConstructedDataSetpoint) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetConstructedDataSetpoint"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetConstructedDataSetpoint")
		}

		if err := WriteSimpleField[BACnetApplicationTagReal](ctx, "setpoint", m.GetSetpoint(), WriteComplex[BACnetApplicationTagReal](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'setpoint' field")
		}
		// Virtual field
		actualValue := m.GetActualValue()
		_ = actualValue
		if _actualValueErr := writeBuffer.WriteVirtual(ctx, "actualValue", m.GetActualValue()); _actualValueErr != nil {
			return errors.Wrap(_actualValueErr, "Error serializing 'actualValue' field")
		}

		if popErr := writeBuffer.PopContext("BACnetConstructedDataSetpoint"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetConstructedDataSetpoint")
		}
		return nil
	}
	return m.BACnetConstructedDataContract.(*_BACnetConstructedData).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetConstructedDataSetpoint) IsBACnetConstructedDataSetpoint() {}

func (m *_BACnetConstructedDataSetpoint) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetConstructedDataSetpoint) deepCopy() *_BACnetConstructedDataSetpoint {
	if m == nil {
		return nil
	}
	_BACnetConstructedDataSetpointCopy := &_BACnetConstructedDataSetpoint{
		m.BACnetConstructedDataContract.(*_BACnetConstructedData).deepCopy(),
		utils.DeepCopy[BACnetApplicationTagReal](m.Setpoint),
	}
	_BACnetConstructedDataSetpointCopy.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = m
	return _BACnetConstructedDataSetpointCopy
}

func (m *_BACnetConstructedDataSetpoint) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
