/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetConstructedDataSecurityPDUTimeout is the corresponding interface of BACnetConstructedDataSecurityPDUTimeout
type BACnetConstructedDataSecurityPDUTimeout interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetConstructedData
	// GetSecurityPduTimeout returns SecurityPduTimeout (property field)
	GetSecurityPduTimeout() BACnetApplicationTagUnsignedInteger
	// GetActualValue returns ActualValue (virtual field)
	GetActualValue() BACnetApplicationTagUnsignedInteger
	// IsBACnetConstructedDataSecurityPDUTimeout is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetConstructedDataSecurityPDUTimeout()
	// CreateBuilder creates a BACnetConstructedDataSecurityPDUTimeoutBuilder
	CreateBACnetConstructedDataSecurityPDUTimeoutBuilder() BACnetConstructedDataSecurityPDUTimeoutBuilder
}

// _BACnetConstructedDataSecurityPDUTimeout is the data-structure of this message
type _BACnetConstructedDataSecurityPDUTimeout struct {
	BACnetConstructedDataContract
	SecurityPduTimeout BACnetApplicationTagUnsignedInteger
}

var _ BACnetConstructedDataSecurityPDUTimeout = (*_BACnetConstructedDataSecurityPDUTimeout)(nil)
var _ BACnetConstructedDataRequirements = (*_BACnetConstructedDataSecurityPDUTimeout)(nil)

// NewBACnetConstructedDataSecurityPDUTimeout factory function for _BACnetConstructedDataSecurityPDUTimeout
func NewBACnetConstructedDataSecurityPDUTimeout(openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag, securityPduTimeout BACnetApplicationTagUnsignedInteger, tagNumber uint8, arrayIndexArgument BACnetTagPayloadUnsignedInteger) *_BACnetConstructedDataSecurityPDUTimeout {
	if securityPduTimeout == nil {
		panic("securityPduTimeout of type BACnetApplicationTagUnsignedInteger for BACnetConstructedDataSecurityPDUTimeout must not be nil")
	}
	_result := &_BACnetConstructedDataSecurityPDUTimeout{
		BACnetConstructedDataContract: NewBACnetConstructedData(openingTag, peekedTagHeader, closingTag, tagNumber, arrayIndexArgument),
		SecurityPduTimeout:            securityPduTimeout,
	}
	_result.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetConstructedDataSecurityPDUTimeoutBuilder is a builder for BACnetConstructedDataSecurityPDUTimeout
type BACnetConstructedDataSecurityPDUTimeoutBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(securityPduTimeout BACnetApplicationTagUnsignedInteger) BACnetConstructedDataSecurityPDUTimeoutBuilder
	// WithSecurityPduTimeout adds SecurityPduTimeout (property field)
	WithSecurityPduTimeout(BACnetApplicationTagUnsignedInteger) BACnetConstructedDataSecurityPDUTimeoutBuilder
	// WithSecurityPduTimeoutBuilder adds SecurityPduTimeout (property field) which is build by the builder
	WithSecurityPduTimeoutBuilder(func(BACnetApplicationTagUnsignedIntegerBuilder) BACnetApplicationTagUnsignedIntegerBuilder) BACnetConstructedDataSecurityPDUTimeoutBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetConstructedDataBuilder
	// Build builds the BACnetConstructedDataSecurityPDUTimeout or returns an error if something is wrong
	Build() (BACnetConstructedDataSecurityPDUTimeout, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetConstructedDataSecurityPDUTimeout
}

// NewBACnetConstructedDataSecurityPDUTimeoutBuilder() creates a BACnetConstructedDataSecurityPDUTimeoutBuilder
func NewBACnetConstructedDataSecurityPDUTimeoutBuilder() BACnetConstructedDataSecurityPDUTimeoutBuilder {
	return &_BACnetConstructedDataSecurityPDUTimeoutBuilder{_BACnetConstructedDataSecurityPDUTimeout: new(_BACnetConstructedDataSecurityPDUTimeout)}
}

type _BACnetConstructedDataSecurityPDUTimeoutBuilder struct {
	*_BACnetConstructedDataSecurityPDUTimeout

	parentBuilder *_BACnetConstructedDataBuilder

	err *utils.MultiError
}

var _ (BACnetConstructedDataSecurityPDUTimeoutBuilder) = (*_BACnetConstructedDataSecurityPDUTimeoutBuilder)(nil)

func (b *_BACnetConstructedDataSecurityPDUTimeoutBuilder) setParent(contract BACnetConstructedDataContract) {
	b.BACnetConstructedDataContract = contract
	contract.(*_BACnetConstructedData)._SubType = b._BACnetConstructedDataSecurityPDUTimeout
}

func (b *_BACnetConstructedDataSecurityPDUTimeoutBuilder) WithMandatoryFields(securityPduTimeout BACnetApplicationTagUnsignedInteger) BACnetConstructedDataSecurityPDUTimeoutBuilder {
	return b.WithSecurityPduTimeout(securityPduTimeout)
}

func (b *_BACnetConstructedDataSecurityPDUTimeoutBuilder) WithSecurityPduTimeout(securityPduTimeout BACnetApplicationTagUnsignedInteger) BACnetConstructedDataSecurityPDUTimeoutBuilder {
	b.SecurityPduTimeout = securityPduTimeout
	return b
}

func (b *_BACnetConstructedDataSecurityPDUTimeoutBuilder) WithSecurityPduTimeoutBuilder(builderSupplier func(BACnetApplicationTagUnsignedIntegerBuilder) BACnetApplicationTagUnsignedIntegerBuilder) BACnetConstructedDataSecurityPDUTimeoutBuilder {
	builder := builderSupplier(b.SecurityPduTimeout.CreateBACnetApplicationTagUnsignedIntegerBuilder())
	var err error
	b.SecurityPduTimeout, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "BACnetApplicationTagUnsignedIntegerBuilder failed"))
	}
	return b
}

func (b *_BACnetConstructedDataSecurityPDUTimeoutBuilder) Build() (BACnetConstructedDataSecurityPDUTimeout, error) {
	if b.SecurityPduTimeout == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'securityPduTimeout' not set"))
	}
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._BACnetConstructedDataSecurityPDUTimeout.deepCopy(), nil
}

func (b *_BACnetConstructedDataSecurityPDUTimeoutBuilder) MustBuild() BACnetConstructedDataSecurityPDUTimeout {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetConstructedDataSecurityPDUTimeoutBuilder) Done() BACnetConstructedDataBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetConstructedDataBuilder().(*_BACnetConstructedDataBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetConstructedDataSecurityPDUTimeoutBuilder) buildForBACnetConstructedData() (BACnetConstructedData, error) {
	return b.Build()
}

func (b *_BACnetConstructedDataSecurityPDUTimeoutBuilder) DeepCopy() any {
	_copy := b.CreateBACnetConstructedDataSecurityPDUTimeoutBuilder().(*_BACnetConstructedDataSecurityPDUTimeoutBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateBACnetConstructedDataSecurityPDUTimeoutBuilder creates a BACnetConstructedDataSecurityPDUTimeoutBuilder
func (b *_BACnetConstructedDataSecurityPDUTimeout) CreateBACnetConstructedDataSecurityPDUTimeoutBuilder() BACnetConstructedDataSecurityPDUTimeoutBuilder {
	if b == nil {
		return NewBACnetConstructedDataSecurityPDUTimeoutBuilder()
	}
	return &_BACnetConstructedDataSecurityPDUTimeoutBuilder{_BACnetConstructedDataSecurityPDUTimeout: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_BACnetConstructedDataSecurityPDUTimeout) GetObjectTypeArgument() BACnetObjectType {
	return 0
}

func (m *_BACnetConstructedDataSecurityPDUTimeout) GetPropertyIdentifierArgument() BACnetPropertyIdentifier {
	return BACnetPropertyIdentifier_SECURITY_PDU_TIMEOUT
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetConstructedDataSecurityPDUTimeout) GetParent() BACnetConstructedDataContract {
	return m.BACnetConstructedDataContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetConstructedDataSecurityPDUTimeout) GetSecurityPduTimeout() BACnetApplicationTagUnsignedInteger {
	return m.SecurityPduTimeout
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for virtual fields.
///////////////////////

func (m *_BACnetConstructedDataSecurityPDUTimeout) GetActualValue() BACnetApplicationTagUnsignedInteger {
	ctx := context.Background()
	_ = ctx
	return CastBACnetApplicationTagUnsignedInteger(m.GetSecurityPduTimeout())
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetConstructedDataSecurityPDUTimeout(structType any) BACnetConstructedDataSecurityPDUTimeout {
	if casted, ok := structType.(BACnetConstructedDataSecurityPDUTimeout); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetConstructedDataSecurityPDUTimeout); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetConstructedDataSecurityPDUTimeout) GetTypeName() string {
	return "BACnetConstructedDataSecurityPDUTimeout"
}

func (m *_BACnetConstructedDataSecurityPDUTimeout) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetConstructedDataContract.(*_BACnetConstructedData).getLengthInBits(ctx))

	// Simple field (securityPduTimeout)
	lengthInBits += m.SecurityPduTimeout.GetLengthInBits(ctx)

	// A virtual field doesn't have any in- or output.

	return lengthInBits
}

func (m *_BACnetConstructedDataSecurityPDUTimeout) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetConstructedDataSecurityPDUTimeout) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetConstructedData, tagNumber uint8, objectTypeArgument BACnetObjectType, propertyIdentifierArgument BACnetPropertyIdentifier, arrayIndexArgument BACnetTagPayloadUnsignedInteger) (__bACnetConstructedDataSecurityPDUTimeout BACnetConstructedDataSecurityPDUTimeout, err error) {
	m.BACnetConstructedDataContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetConstructedDataSecurityPDUTimeout"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetConstructedDataSecurityPDUTimeout")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	securityPduTimeout, err := ReadSimpleField[BACnetApplicationTagUnsignedInteger](ctx, "securityPduTimeout", ReadComplex[BACnetApplicationTagUnsignedInteger](BACnetApplicationTagParseWithBufferProducer[BACnetApplicationTagUnsignedInteger](), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'securityPduTimeout' field"))
	}
	m.SecurityPduTimeout = securityPduTimeout

	actualValue, err := ReadVirtualField[BACnetApplicationTagUnsignedInteger](ctx, "actualValue", (*BACnetApplicationTagUnsignedInteger)(nil), securityPduTimeout)
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'actualValue' field"))
	}
	_ = actualValue

	if closeErr := readBuffer.CloseContext("BACnetConstructedDataSecurityPDUTimeout"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetConstructedDataSecurityPDUTimeout")
	}

	return m, nil
}

func (m *_BACnetConstructedDataSecurityPDUTimeout) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetConstructedDataSecurityPDUTimeout) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetConstructedDataSecurityPDUTimeout"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetConstructedDataSecurityPDUTimeout")
		}

		if err := WriteSimpleField[BACnetApplicationTagUnsignedInteger](ctx, "securityPduTimeout", m.GetSecurityPduTimeout(), WriteComplex[BACnetApplicationTagUnsignedInteger](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'securityPduTimeout' field")
		}
		// Virtual field
		actualValue := m.GetActualValue()
		_ = actualValue
		if _actualValueErr := writeBuffer.WriteVirtual(ctx, "actualValue", m.GetActualValue()); _actualValueErr != nil {
			return errors.Wrap(_actualValueErr, "Error serializing 'actualValue' field")
		}

		if popErr := writeBuffer.PopContext("BACnetConstructedDataSecurityPDUTimeout"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetConstructedDataSecurityPDUTimeout")
		}
		return nil
	}
	return m.BACnetConstructedDataContract.(*_BACnetConstructedData).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetConstructedDataSecurityPDUTimeout) IsBACnetConstructedDataSecurityPDUTimeout() {}

func (m *_BACnetConstructedDataSecurityPDUTimeout) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetConstructedDataSecurityPDUTimeout) deepCopy() *_BACnetConstructedDataSecurityPDUTimeout {
	if m == nil {
		return nil
	}
	_BACnetConstructedDataSecurityPDUTimeoutCopy := &_BACnetConstructedDataSecurityPDUTimeout{
		m.BACnetConstructedDataContract.(*_BACnetConstructedData).deepCopy(),
		utils.DeepCopy[BACnetApplicationTagUnsignedInteger](m.SecurityPduTimeout),
	}
	_BACnetConstructedDataSecurityPDUTimeoutCopy.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = m
	return _BACnetConstructedDataSecurityPDUTimeoutCopy
}

func (m *_BACnetConstructedDataSecurityPDUTimeout) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
