/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetConstructedDataProgramLocation is the corresponding interface of BACnetConstructedDataProgramLocation
type BACnetConstructedDataProgramLocation interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetConstructedData
	// GetProgramLocation returns ProgramLocation (property field)
	GetProgramLocation() BACnetApplicationTagCharacterString
	// GetActualValue returns ActualValue (virtual field)
	GetActualValue() BACnetApplicationTagCharacterString
	// IsBACnetConstructedDataProgramLocation is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetConstructedDataProgramLocation()
	// CreateBuilder creates a BACnetConstructedDataProgramLocationBuilder
	CreateBACnetConstructedDataProgramLocationBuilder() BACnetConstructedDataProgramLocationBuilder
}

// _BACnetConstructedDataProgramLocation is the data-structure of this message
type _BACnetConstructedDataProgramLocation struct {
	BACnetConstructedDataContract
	ProgramLocation BACnetApplicationTagCharacterString
}

var _ BACnetConstructedDataProgramLocation = (*_BACnetConstructedDataProgramLocation)(nil)
var _ BACnetConstructedDataRequirements = (*_BACnetConstructedDataProgramLocation)(nil)

// NewBACnetConstructedDataProgramLocation factory function for _BACnetConstructedDataProgramLocation
func NewBACnetConstructedDataProgramLocation(openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag, programLocation BACnetApplicationTagCharacterString, tagNumber uint8, arrayIndexArgument BACnetTagPayloadUnsignedInteger) *_BACnetConstructedDataProgramLocation {
	if programLocation == nil {
		panic("programLocation of type BACnetApplicationTagCharacterString for BACnetConstructedDataProgramLocation must not be nil")
	}
	_result := &_BACnetConstructedDataProgramLocation{
		BACnetConstructedDataContract: NewBACnetConstructedData(openingTag, peekedTagHeader, closingTag, tagNumber, arrayIndexArgument),
		ProgramLocation:               programLocation,
	}
	_result.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetConstructedDataProgramLocationBuilder is a builder for BACnetConstructedDataProgramLocation
type BACnetConstructedDataProgramLocationBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(programLocation BACnetApplicationTagCharacterString) BACnetConstructedDataProgramLocationBuilder
	// WithProgramLocation adds ProgramLocation (property field)
	WithProgramLocation(BACnetApplicationTagCharacterString) BACnetConstructedDataProgramLocationBuilder
	// WithProgramLocationBuilder adds ProgramLocation (property field) which is build by the builder
	WithProgramLocationBuilder(func(BACnetApplicationTagCharacterStringBuilder) BACnetApplicationTagCharacterStringBuilder) BACnetConstructedDataProgramLocationBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetConstructedDataBuilder
	// Build builds the BACnetConstructedDataProgramLocation or returns an error if something is wrong
	Build() (BACnetConstructedDataProgramLocation, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetConstructedDataProgramLocation
}

// NewBACnetConstructedDataProgramLocationBuilder() creates a BACnetConstructedDataProgramLocationBuilder
func NewBACnetConstructedDataProgramLocationBuilder() BACnetConstructedDataProgramLocationBuilder {
	return &_BACnetConstructedDataProgramLocationBuilder{_BACnetConstructedDataProgramLocation: new(_BACnetConstructedDataProgramLocation)}
}

type _BACnetConstructedDataProgramLocationBuilder struct {
	*_BACnetConstructedDataProgramLocation

	parentBuilder *_BACnetConstructedDataBuilder

	err *utils.MultiError
}

var _ (BACnetConstructedDataProgramLocationBuilder) = (*_BACnetConstructedDataProgramLocationBuilder)(nil)

func (b *_BACnetConstructedDataProgramLocationBuilder) setParent(contract BACnetConstructedDataContract) {
	b.BACnetConstructedDataContract = contract
	contract.(*_BACnetConstructedData)._SubType = b._BACnetConstructedDataProgramLocation
}

func (b *_BACnetConstructedDataProgramLocationBuilder) WithMandatoryFields(programLocation BACnetApplicationTagCharacterString) BACnetConstructedDataProgramLocationBuilder {
	return b.WithProgramLocation(programLocation)
}

func (b *_BACnetConstructedDataProgramLocationBuilder) WithProgramLocation(programLocation BACnetApplicationTagCharacterString) BACnetConstructedDataProgramLocationBuilder {
	b.ProgramLocation = programLocation
	return b
}

func (b *_BACnetConstructedDataProgramLocationBuilder) WithProgramLocationBuilder(builderSupplier func(BACnetApplicationTagCharacterStringBuilder) BACnetApplicationTagCharacterStringBuilder) BACnetConstructedDataProgramLocationBuilder {
	builder := builderSupplier(b.ProgramLocation.CreateBACnetApplicationTagCharacterStringBuilder())
	var err error
	b.ProgramLocation, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "BACnetApplicationTagCharacterStringBuilder failed"))
	}
	return b
}

func (b *_BACnetConstructedDataProgramLocationBuilder) Build() (BACnetConstructedDataProgramLocation, error) {
	if b.ProgramLocation == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'programLocation' not set"))
	}
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._BACnetConstructedDataProgramLocation.deepCopy(), nil
}

func (b *_BACnetConstructedDataProgramLocationBuilder) MustBuild() BACnetConstructedDataProgramLocation {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetConstructedDataProgramLocationBuilder) Done() BACnetConstructedDataBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetConstructedDataBuilder().(*_BACnetConstructedDataBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetConstructedDataProgramLocationBuilder) buildForBACnetConstructedData() (BACnetConstructedData, error) {
	return b.Build()
}

func (b *_BACnetConstructedDataProgramLocationBuilder) DeepCopy() any {
	_copy := b.CreateBACnetConstructedDataProgramLocationBuilder().(*_BACnetConstructedDataProgramLocationBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateBACnetConstructedDataProgramLocationBuilder creates a BACnetConstructedDataProgramLocationBuilder
func (b *_BACnetConstructedDataProgramLocation) CreateBACnetConstructedDataProgramLocationBuilder() BACnetConstructedDataProgramLocationBuilder {
	if b == nil {
		return NewBACnetConstructedDataProgramLocationBuilder()
	}
	return &_BACnetConstructedDataProgramLocationBuilder{_BACnetConstructedDataProgramLocation: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_BACnetConstructedDataProgramLocation) GetObjectTypeArgument() BACnetObjectType {
	return 0
}

func (m *_BACnetConstructedDataProgramLocation) GetPropertyIdentifierArgument() BACnetPropertyIdentifier {
	return BACnetPropertyIdentifier_PROGRAM_LOCATION
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetConstructedDataProgramLocation) GetParent() BACnetConstructedDataContract {
	return m.BACnetConstructedDataContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetConstructedDataProgramLocation) GetProgramLocation() BACnetApplicationTagCharacterString {
	return m.ProgramLocation
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for virtual fields.
///////////////////////

func (m *_BACnetConstructedDataProgramLocation) GetActualValue() BACnetApplicationTagCharacterString {
	ctx := context.Background()
	_ = ctx
	return CastBACnetApplicationTagCharacterString(m.GetProgramLocation())
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetConstructedDataProgramLocation(structType any) BACnetConstructedDataProgramLocation {
	if casted, ok := structType.(BACnetConstructedDataProgramLocation); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetConstructedDataProgramLocation); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetConstructedDataProgramLocation) GetTypeName() string {
	return "BACnetConstructedDataProgramLocation"
}

func (m *_BACnetConstructedDataProgramLocation) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetConstructedDataContract.(*_BACnetConstructedData).getLengthInBits(ctx))

	// Simple field (programLocation)
	lengthInBits += m.ProgramLocation.GetLengthInBits(ctx)

	// A virtual field doesn't have any in- or output.

	return lengthInBits
}

func (m *_BACnetConstructedDataProgramLocation) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetConstructedDataProgramLocation) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetConstructedData, tagNumber uint8, objectTypeArgument BACnetObjectType, propertyIdentifierArgument BACnetPropertyIdentifier, arrayIndexArgument BACnetTagPayloadUnsignedInteger) (__bACnetConstructedDataProgramLocation BACnetConstructedDataProgramLocation, err error) {
	m.BACnetConstructedDataContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetConstructedDataProgramLocation"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetConstructedDataProgramLocation")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	programLocation, err := ReadSimpleField[BACnetApplicationTagCharacterString](ctx, "programLocation", ReadComplex[BACnetApplicationTagCharacterString](BACnetApplicationTagParseWithBufferProducer[BACnetApplicationTagCharacterString](), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'programLocation' field"))
	}
	m.ProgramLocation = programLocation

	actualValue, err := ReadVirtualField[BACnetApplicationTagCharacterString](ctx, "actualValue", (*BACnetApplicationTagCharacterString)(nil), programLocation)
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'actualValue' field"))
	}
	_ = actualValue

	if closeErr := readBuffer.CloseContext("BACnetConstructedDataProgramLocation"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetConstructedDataProgramLocation")
	}

	return m, nil
}

func (m *_BACnetConstructedDataProgramLocation) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetConstructedDataProgramLocation) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetConstructedDataProgramLocation"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetConstructedDataProgramLocation")
		}

		if err := WriteSimpleField[BACnetApplicationTagCharacterString](ctx, "programLocation", m.GetProgramLocation(), WriteComplex[BACnetApplicationTagCharacterString](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'programLocation' field")
		}
		// Virtual field
		actualValue := m.GetActualValue()
		_ = actualValue
		if _actualValueErr := writeBuffer.WriteVirtual(ctx, "actualValue", m.GetActualValue()); _actualValueErr != nil {
			return errors.Wrap(_actualValueErr, "Error serializing 'actualValue' field")
		}

		if popErr := writeBuffer.PopContext("BACnetConstructedDataProgramLocation"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetConstructedDataProgramLocation")
		}
		return nil
	}
	return m.BACnetConstructedDataContract.(*_BACnetConstructedData).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetConstructedDataProgramLocation) IsBACnetConstructedDataProgramLocation() {}

func (m *_BACnetConstructedDataProgramLocation) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetConstructedDataProgramLocation) deepCopy() *_BACnetConstructedDataProgramLocation {
	if m == nil {
		return nil
	}
	_BACnetConstructedDataProgramLocationCopy := &_BACnetConstructedDataProgramLocation{
		m.BACnetConstructedDataContract.(*_BACnetConstructedData).deepCopy(),
		utils.DeepCopy[BACnetApplicationTagCharacterString](m.ProgramLocation),
	}
	_BACnetConstructedDataProgramLocationCopy.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = m
	return _BACnetConstructedDataProgramLocationCopy
}

func (m *_BACnetConstructedDataProgramLocation) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
