/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetConstructedDataPower is the corresponding interface of BACnetConstructedDataPower
type BACnetConstructedDataPower interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetConstructedData
	// GetPower returns Power (property field)
	GetPower() BACnetApplicationTagReal
	// GetActualValue returns ActualValue (virtual field)
	GetActualValue() BACnetApplicationTagReal
	// IsBACnetConstructedDataPower is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetConstructedDataPower()
	// CreateBuilder creates a BACnetConstructedDataPowerBuilder
	CreateBACnetConstructedDataPowerBuilder() BACnetConstructedDataPowerBuilder
}

// _BACnetConstructedDataPower is the data-structure of this message
type _BACnetConstructedDataPower struct {
	BACnetConstructedDataContract
	Power BACnetApplicationTagReal
}

var _ BACnetConstructedDataPower = (*_BACnetConstructedDataPower)(nil)
var _ BACnetConstructedDataRequirements = (*_BACnetConstructedDataPower)(nil)

// NewBACnetConstructedDataPower factory function for _BACnetConstructedDataPower
func NewBACnetConstructedDataPower(openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag, power BACnetApplicationTagReal, tagNumber uint8, arrayIndexArgument BACnetTagPayloadUnsignedInteger) *_BACnetConstructedDataPower {
	if power == nil {
		panic("power of type BACnetApplicationTagReal for BACnetConstructedDataPower must not be nil")
	}
	_result := &_BACnetConstructedDataPower{
		BACnetConstructedDataContract: NewBACnetConstructedData(openingTag, peekedTagHeader, closingTag, tagNumber, arrayIndexArgument),
		Power:                         power,
	}
	_result.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetConstructedDataPowerBuilder is a builder for BACnetConstructedDataPower
type BACnetConstructedDataPowerBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(power BACnetApplicationTagReal) BACnetConstructedDataPowerBuilder
	// WithPower adds Power (property field)
	WithPower(BACnetApplicationTagReal) BACnetConstructedDataPowerBuilder
	// WithPowerBuilder adds Power (property field) which is build by the builder
	WithPowerBuilder(func(BACnetApplicationTagRealBuilder) BACnetApplicationTagRealBuilder) BACnetConstructedDataPowerBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetConstructedDataBuilder
	// Build builds the BACnetConstructedDataPower or returns an error if something is wrong
	Build() (BACnetConstructedDataPower, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetConstructedDataPower
}

// NewBACnetConstructedDataPowerBuilder() creates a BACnetConstructedDataPowerBuilder
func NewBACnetConstructedDataPowerBuilder() BACnetConstructedDataPowerBuilder {
	return &_BACnetConstructedDataPowerBuilder{_BACnetConstructedDataPower: new(_BACnetConstructedDataPower)}
}

type _BACnetConstructedDataPowerBuilder struct {
	*_BACnetConstructedDataPower

	parentBuilder *_BACnetConstructedDataBuilder

	err *utils.MultiError
}

var _ (BACnetConstructedDataPowerBuilder) = (*_BACnetConstructedDataPowerBuilder)(nil)

func (b *_BACnetConstructedDataPowerBuilder) setParent(contract BACnetConstructedDataContract) {
	b.BACnetConstructedDataContract = contract
	contract.(*_BACnetConstructedData)._SubType = b._BACnetConstructedDataPower
}

func (b *_BACnetConstructedDataPowerBuilder) WithMandatoryFields(power BACnetApplicationTagReal) BACnetConstructedDataPowerBuilder {
	return b.WithPower(power)
}

func (b *_BACnetConstructedDataPowerBuilder) WithPower(power BACnetApplicationTagReal) BACnetConstructedDataPowerBuilder {
	b.Power = power
	return b
}

func (b *_BACnetConstructedDataPowerBuilder) WithPowerBuilder(builderSupplier func(BACnetApplicationTagRealBuilder) BACnetApplicationTagRealBuilder) BACnetConstructedDataPowerBuilder {
	builder := builderSupplier(b.Power.CreateBACnetApplicationTagRealBuilder())
	var err error
	b.Power, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "BACnetApplicationTagRealBuilder failed"))
	}
	return b
}

func (b *_BACnetConstructedDataPowerBuilder) Build() (BACnetConstructedDataPower, error) {
	if b.Power == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'power' not set"))
	}
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._BACnetConstructedDataPower.deepCopy(), nil
}

func (b *_BACnetConstructedDataPowerBuilder) MustBuild() BACnetConstructedDataPower {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetConstructedDataPowerBuilder) Done() BACnetConstructedDataBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetConstructedDataBuilder().(*_BACnetConstructedDataBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetConstructedDataPowerBuilder) buildForBACnetConstructedData() (BACnetConstructedData, error) {
	return b.Build()
}

func (b *_BACnetConstructedDataPowerBuilder) DeepCopy() any {
	_copy := b.CreateBACnetConstructedDataPowerBuilder().(*_BACnetConstructedDataPowerBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateBACnetConstructedDataPowerBuilder creates a BACnetConstructedDataPowerBuilder
func (b *_BACnetConstructedDataPower) CreateBACnetConstructedDataPowerBuilder() BACnetConstructedDataPowerBuilder {
	if b == nil {
		return NewBACnetConstructedDataPowerBuilder()
	}
	return &_BACnetConstructedDataPowerBuilder{_BACnetConstructedDataPower: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_BACnetConstructedDataPower) GetObjectTypeArgument() BACnetObjectType {
	return 0
}

func (m *_BACnetConstructedDataPower) GetPropertyIdentifierArgument() BACnetPropertyIdentifier {
	return BACnetPropertyIdentifier_POWER
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetConstructedDataPower) GetParent() BACnetConstructedDataContract {
	return m.BACnetConstructedDataContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetConstructedDataPower) GetPower() BACnetApplicationTagReal {
	return m.Power
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for virtual fields.
///////////////////////

func (m *_BACnetConstructedDataPower) GetActualValue() BACnetApplicationTagReal {
	ctx := context.Background()
	_ = ctx
	return CastBACnetApplicationTagReal(m.GetPower())
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetConstructedDataPower(structType any) BACnetConstructedDataPower {
	if casted, ok := structType.(BACnetConstructedDataPower); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetConstructedDataPower); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetConstructedDataPower) GetTypeName() string {
	return "BACnetConstructedDataPower"
}

func (m *_BACnetConstructedDataPower) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetConstructedDataContract.(*_BACnetConstructedData).getLengthInBits(ctx))

	// Simple field (power)
	lengthInBits += m.Power.GetLengthInBits(ctx)

	// A virtual field doesn't have any in- or output.

	return lengthInBits
}

func (m *_BACnetConstructedDataPower) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetConstructedDataPower) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetConstructedData, tagNumber uint8, objectTypeArgument BACnetObjectType, propertyIdentifierArgument BACnetPropertyIdentifier, arrayIndexArgument BACnetTagPayloadUnsignedInteger) (__bACnetConstructedDataPower BACnetConstructedDataPower, err error) {
	m.BACnetConstructedDataContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetConstructedDataPower"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetConstructedDataPower")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	power, err := ReadSimpleField[BACnetApplicationTagReal](ctx, "power", ReadComplex[BACnetApplicationTagReal](BACnetApplicationTagParseWithBufferProducer[BACnetApplicationTagReal](), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'power' field"))
	}
	m.Power = power

	actualValue, err := ReadVirtualField[BACnetApplicationTagReal](ctx, "actualValue", (*BACnetApplicationTagReal)(nil), power)
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'actualValue' field"))
	}
	_ = actualValue

	if closeErr := readBuffer.CloseContext("BACnetConstructedDataPower"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetConstructedDataPower")
	}

	return m, nil
}

func (m *_BACnetConstructedDataPower) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetConstructedDataPower) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetConstructedDataPower"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetConstructedDataPower")
		}

		if err := WriteSimpleField[BACnetApplicationTagReal](ctx, "power", m.GetPower(), WriteComplex[BACnetApplicationTagReal](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'power' field")
		}
		// Virtual field
		actualValue := m.GetActualValue()
		_ = actualValue
		if _actualValueErr := writeBuffer.WriteVirtual(ctx, "actualValue", m.GetActualValue()); _actualValueErr != nil {
			return errors.Wrap(_actualValueErr, "Error serializing 'actualValue' field")
		}

		if popErr := writeBuffer.PopContext("BACnetConstructedDataPower"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetConstructedDataPower")
		}
		return nil
	}
	return m.BACnetConstructedDataContract.(*_BACnetConstructedData).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetConstructedDataPower) IsBACnetConstructedDataPower() {}

func (m *_BACnetConstructedDataPower) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetConstructedDataPower) deepCopy() *_BACnetConstructedDataPower {
	if m == nil {
		return nil
	}
	_BACnetConstructedDataPowerCopy := &_BACnetConstructedDataPower{
		m.BACnetConstructedDataContract.(*_BACnetConstructedData).deepCopy(),
		utils.DeepCopy[BACnetApplicationTagReal](m.Power),
	}
	_BACnetConstructedDataPowerCopy.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = m
	return _BACnetConstructedDataPowerCopy
}

func (m *_BACnetConstructedDataPower) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
