/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetConstructedDataObjectType is the corresponding interface of BACnetConstructedDataObjectType
type BACnetConstructedDataObjectType interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetConstructedData
	// GetObjectType returns ObjectType (property field)
	GetObjectType() BACnetObjectTypeTagged
	// GetActualValue returns ActualValue (virtual field)
	GetActualValue() BACnetObjectTypeTagged
	// IsBACnetConstructedDataObjectType is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetConstructedDataObjectType()
	// CreateBuilder creates a BACnetConstructedDataObjectTypeBuilder
	CreateBACnetConstructedDataObjectTypeBuilder() BACnetConstructedDataObjectTypeBuilder
}

// _BACnetConstructedDataObjectType is the data-structure of this message
type _BACnetConstructedDataObjectType struct {
	BACnetConstructedDataContract
	ObjectType BACnetObjectTypeTagged
}

var _ BACnetConstructedDataObjectType = (*_BACnetConstructedDataObjectType)(nil)
var _ BACnetConstructedDataRequirements = (*_BACnetConstructedDataObjectType)(nil)

// NewBACnetConstructedDataObjectType factory function for _BACnetConstructedDataObjectType
func NewBACnetConstructedDataObjectType(openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag, objectType BACnetObjectTypeTagged, tagNumber uint8, arrayIndexArgument BACnetTagPayloadUnsignedInteger) *_BACnetConstructedDataObjectType {
	if objectType == nil {
		panic("objectType of type BACnetObjectTypeTagged for BACnetConstructedDataObjectType must not be nil")
	}
	_result := &_BACnetConstructedDataObjectType{
		BACnetConstructedDataContract: NewBACnetConstructedData(openingTag, peekedTagHeader, closingTag, tagNumber, arrayIndexArgument),
		ObjectType:                    objectType,
	}
	_result.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetConstructedDataObjectTypeBuilder is a builder for BACnetConstructedDataObjectType
type BACnetConstructedDataObjectTypeBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(objectType BACnetObjectTypeTagged) BACnetConstructedDataObjectTypeBuilder
	// WithObjectType adds ObjectType (property field)
	WithObjectType(BACnetObjectTypeTagged) BACnetConstructedDataObjectTypeBuilder
	// WithObjectTypeBuilder adds ObjectType (property field) which is build by the builder
	WithObjectTypeBuilder(func(BACnetObjectTypeTaggedBuilder) BACnetObjectTypeTaggedBuilder) BACnetConstructedDataObjectTypeBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetConstructedDataBuilder
	// Build builds the BACnetConstructedDataObjectType or returns an error if something is wrong
	Build() (BACnetConstructedDataObjectType, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetConstructedDataObjectType
}

// NewBACnetConstructedDataObjectTypeBuilder() creates a BACnetConstructedDataObjectTypeBuilder
func NewBACnetConstructedDataObjectTypeBuilder() BACnetConstructedDataObjectTypeBuilder {
	return &_BACnetConstructedDataObjectTypeBuilder{_BACnetConstructedDataObjectType: new(_BACnetConstructedDataObjectType)}
}

type _BACnetConstructedDataObjectTypeBuilder struct {
	*_BACnetConstructedDataObjectType

	parentBuilder *_BACnetConstructedDataBuilder

	err *utils.MultiError
}

var _ (BACnetConstructedDataObjectTypeBuilder) = (*_BACnetConstructedDataObjectTypeBuilder)(nil)

func (b *_BACnetConstructedDataObjectTypeBuilder) setParent(contract BACnetConstructedDataContract) {
	b.BACnetConstructedDataContract = contract
	contract.(*_BACnetConstructedData)._SubType = b._BACnetConstructedDataObjectType
}

func (b *_BACnetConstructedDataObjectTypeBuilder) WithMandatoryFields(objectType BACnetObjectTypeTagged) BACnetConstructedDataObjectTypeBuilder {
	return b.WithObjectType(objectType)
}

func (b *_BACnetConstructedDataObjectTypeBuilder) WithObjectType(objectType BACnetObjectTypeTagged) BACnetConstructedDataObjectTypeBuilder {
	b.ObjectType = objectType
	return b
}

func (b *_BACnetConstructedDataObjectTypeBuilder) WithObjectTypeBuilder(builderSupplier func(BACnetObjectTypeTaggedBuilder) BACnetObjectTypeTaggedBuilder) BACnetConstructedDataObjectTypeBuilder {
	builder := builderSupplier(b.ObjectType.CreateBACnetObjectTypeTaggedBuilder())
	var err error
	b.ObjectType, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "BACnetObjectTypeTaggedBuilder failed"))
	}
	return b
}

func (b *_BACnetConstructedDataObjectTypeBuilder) Build() (BACnetConstructedDataObjectType, error) {
	if b.ObjectType == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'objectType' not set"))
	}
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._BACnetConstructedDataObjectType.deepCopy(), nil
}

func (b *_BACnetConstructedDataObjectTypeBuilder) MustBuild() BACnetConstructedDataObjectType {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetConstructedDataObjectTypeBuilder) Done() BACnetConstructedDataBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetConstructedDataBuilder().(*_BACnetConstructedDataBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetConstructedDataObjectTypeBuilder) buildForBACnetConstructedData() (BACnetConstructedData, error) {
	return b.Build()
}

func (b *_BACnetConstructedDataObjectTypeBuilder) DeepCopy() any {
	_copy := b.CreateBACnetConstructedDataObjectTypeBuilder().(*_BACnetConstructedDataObjectTypeBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateBACnetConstructedDataObjectTypeBuilder creates a BACnetConstructedDataObjectTypeBuilder
func (b *_BACnetConstructedDataObjectType) CreateBACnetConstructedDataObjectTypeBuilder() BACnetConstructedDataObjectTypeBuilder {
	if b == nil {
		return NewBACnetConstructedDataObjectTypeBuilder()
	}
	return &_BACnetConstructedDataObjectTypeBuilder{_BACnetConstructedDataObjectType: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_BACnetConstructedDataObjectType) GetObjectTypeArgument() BACnetObjectType {
	return 0
}

func (m *_BACnetConstructedDataObjectType) GetPropertyIdentifierArgument() BACnetPropertyIdentifier {
	return BACnetPropertyIdentifier_OBJECT_TYPE
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetConstructedDataObjectType) GetParent() BACnetConstructedDataContract {
	return m.BACnetConstructedDataContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetConstructedDataObjectType) GetObjectType() BACnetObjectTypeTagged {
	return m.ObjectType
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for virtual fields.
///////////////////////

func (m *_BACnetConstructedDataObjectType) GetActualValue() BACnetObjectTypeTagged {
	ctx := context.Background()
	_ = ctx
	return CastBACnetObjectTypeTagged(m.GetObjectType())
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetConstructedDataObjectType(structType any) BACnetConstructedDataObjectType {
	if casted, ok := structType.(BACnetConstructedDataObjectType); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetConstructedDataObjectType); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetConstructedDataObjectType) GetTypeName() string {
	return "BACnetConstructedDataObjectType"
}

func (m *_BACnetConstructedDataObjectType) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetConstructedDataContract.(*_BACnetConstructedData).getLengthInBits(ctx))

	// Simple field (objectType)
	lengthInBits += m.ObjectType.GetLengthInBits(ctx)

	// A virtual field doesn't have any in- or output.

	return lengthInBits
}

func (m *_BACnetConstructedDataObjectType) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetConstructedDataObjectType) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetConstructedData, tagNumber uint8, objectTypeArgument BACnetObjectType, propertyIdentifierArgument BACnetPropertyIdentifier, arrayIndexArgument BACnetTagPayloadUnsignedInteger) (__bACnetConstructedDataObjectType BACnetConstructedDataObjectType, err error) {
	m.BACnetConstructedDataContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetConstructedDataObjectType"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetConstructedDataObjectType")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	objectType, err := ReadSimpleField[BACnetObjectTypeTagged](ctx, "objectType", ReadComplex[BACnetObjectTypeTagged](BACnetObjectTypeTaggedParseWithBufferProducer((uint8)(uint8(0)), (TagClass)(TagClass_APPLICATION_TAGS)), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'objectType' field"))
	}
	m.ObjectType = objectType

	actualValue, err := ReadVirtualField[BACnetObjectTypeTagged](ctx, "actualValue", (*BACnetObjectTypeTagged)(nil), objectType)
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'actualValue' field"))
	}
	_ = actualValue

	if closeErr := readBuffer.CloseContext("BACnetConstructedDataObjectType"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetConstructedDataObjectType")
	}

	return m, nil
}

func (m *_BACnetConstructedDataObjectType) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetConstructedDataObjectType) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetConstructedDataObjectType"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetConstructedDataObjectType")
		}

		if err := WriteSimpleField[BACnetObjectTypeTagged](ctx, "objectType", m.GetObjectType(), WriteComplex[BACnetObjectTypeTagged](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'objectType' field")
		}
		// Virtual field
		actualValue := m.GetActualValue()
		_ = actualValue
		if _actualValueErr := writeBuffer.WriteVirtual(ctx, "actualValue", m.GetActualValue()); _actualValueErr != nil {
			return errors.Wrap(_actualValueErr, "Error serializing 'actualValue' field")
		}

		if popErr := writeBuffer.PopContext("BACnetConstructedDataObjectType"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetConstructedDataObjectType")
		}
		return nil
	}
	return m.BACnetConstructedDataContract.(*_BACnetConstructedData).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetConstructedDataObjectType) IsBACnetConstructedDataObjectType() {}

func (m *_BACnetConstructedDataObjectType) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetConstructedDataObjectType) deepCopy() *_BACnetConstructedDataObjectType {
	if m == nil {
		return nil
	}
	_BACnetConstructedDataObjectTypeCopy := &_BACnetConstructedDataObjectType{
		m.BACnetConstructedDataContract.(*_BACnetConstructedData).deepCopy(),
		utils.DeepCopy[BACnetObjectTypeTagged](m.ObjectType),
	}
	_BACnetConstructedDataObjectTypeCopy.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = m
	return _BACnetConstructedDataObjectTypeCopy
}

func (m *_BACnetConstructedDataObjectType) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
