/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetConstructedDataObjectPropertyReference is the corresponding interface of BACnetConstructedDataObjectPropertyReference
type BACnetConstructedDataObjectPropertyReference interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetConstructedData
	// GetPropertyReference returns PropertyReference (property field)
	GetPropertyReference() BACnetDeviceObjectPropertyReference
	// GetActualValue returns ActualValue (virtual field)
	GetActualValue() BACnetDeviceObjectPropertyReference
	// IsBACnetConstructedDataObjectPropertyReference is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetConstructedDataObjectPropertyReference()
	// CreateBuilder creates a BACnetConstructedDataObjectPropertyReferenceBuilder
	CreateBACnetConstructedDataObjectPropertyReferenceBuilder() BACnetConstructedDataObjectPropertyReferenceBuilder
}

// _BACnetConstructedDataObjectPropertyReference is the data-structure of this message
type _BACnetConstructedDataObjectPropertyReference struct {
	BACnetConstructedDataContract
	PropertyReference BACnetDeviceObjectPropertyReference
}

var _ BACnetConstructedDataObjectPropertyReference = (*_BACnetConstructedDataObjectPropertyReference)(nil)
var _ BACnetConstructedDataRequirements = (*_BACnetConstructedDataObjectPropertyReference)(nil)

// NewBACnetConstructedDataObjectPropertyReference factory function for _BACnetConstructedDataObjectPropertyReference
func NewBACnetConstructedDataObjectPropertyReference(openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag, propertyReference BACnetDeviceObjectPropertyReference, tagNumber uint8, arrayIndexArgument BACnetTagPayloadUnsignedInteger) *_BACnetConstructedDataObjectPropertyReference {
	if propertyReference == nil {
		panic("propertyReference of type BACnetDeviceObjectPropertyReference for BACnetConstructedDataObjectPropertyReference must not be nil")
	}
	_result := &_BACnetConstructedDataObjectPropertyReference{
		BACnetConstructedDataContract: NewBACnetConstructedData(openingTag, peekedTagHeader, closingTag, tagNumber, arrayIndexArgument),
		PropertyReference:             propertyReference,
	}
	_result.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetConstructedDataObjectPropertyReferenceBuilder is a builder for BACnetConstructedDataObjectPropertyReference
type BACnetConstructedDataObjectPropertyReferenceBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(propertyReference BACnetDeviceObjectPropertyReference) BACnetConstructedDataObjectPropertyReferenceBuilder
	// WithPropertyReference adds PropertyReference (property field)
	WithPropertyReference(BACnetDeviceObjectPropertyReference) BACnetConstructedDataObjectPropertyReferenceBuilder
	// WithPropertyReferenceBuilder adds PropertyReference (property field) which is build by the builder
	WithPropertyReferenceBuilder(func(BACnetDeviceObjectPropertyReferenceBuilder) BACnetDeviceObjectPropertyReferenceBuilder) BACnetConstructedDataObjectPropertyReferenceBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetConstructedDataBuilder
	// Build builds the BACnetConstructedDataObjectPropertyReference or returns an error if something is wrong
	Build() (BACnetConstructedDataObjectPropertyReference, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetConstructedDataObjectPropertyReference
}

// NewBACnetConstructedDataObjectPropertyReferenceBuilder() creates a BACnetConstructedDataObjectPropertyReferenceBuilder
func NewBACnetConstructedDataObjectPropertyReferenceBuilder() BACnetConstructedDataObjectPropertyReferenceBuilder {
	return &_BACnetConstructedDataObjectPropertyReferenceBuilder{_BACnetConstructedDataObjectPropertyReference: new(_BACnetConstructedDataObjectPropertyReference)}
}

type _BACnetConstructedDataObjectPropertyReferenceBuilder struct {
	*_BACnetConstructedDataObjectPropertyReference

	parentBuilder *_BACnetConstructedDataBuilder

	err *utils.MultiError
}

var _ (BACnetConstructedDataObjectPropertyReferenceBuilder) = (*_BACnetConstructedDataObjectPropertyReferenceBuilder)(nil)

func (b *_BACnetConstructedDataObjectPropertyReferenceBuilder) setParent(contract BACnetConstructedDataContract) {
	b.BACnetConstructedDataContract = contract
	contract.(*_BACnetConstructedData)._SubType = b._BACnetConstructedDataObjectPropertyReference
}

func (b *_BACnetConstructedDataObjectPropertyReferenceBuilder) WithMandatoryFields(propertyReference BACnetDeviceObjectPropertyReference) BACnetConstructedDataObjectPropertyReferenceBuilder {
	return b.WithPropertyReference(propertyReference)
}

func (b *_BACnetConstructedDataObjectPropertyReferenceBuilder) WithPropertyReference(propertyReference BACnetDeviceObjectPropertyReference) BACnetConstructedDataObjectPropertyReferenceBuilder {
	b.PropertyReference = propertyReference
	return b
}

func (b *_BACnetConstructedDataObjectPropertyReferenceBuilder) WithPropertyReferenceBuilder(builderSupplier func(BACnetDeviceObjectPropertyReferenceBuilder) BACnetDeviceObjectPropertyReferenceBuilder) BACnetConstructedDataObjectPropertyReferenceBuilder {
	builder := builderSupplier(b.PropertyReference.CreateBACnetDeviceObjectPropertyReferenceBuilder())
	var err error
	b.PropertyReference, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "BACnetDeviceObjectPropertyReferenceBuilder failed"))
	}
	return b
}

func (b *_BACnetConstructedDataObjectPropertyReferenceBuilder) Build() (BACnetConstructedDataObjectPropertyReference, error) {
	if b.PropertyReference == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'propertyReference' not set"))
	}
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._BACnetConstructedDataObjectPropertyReference.deepCopy(), nil
}

func (b *_BACnetConstructedDataObjectPropertyReferenceBuilder) MustBuild() BACnetConstructedDataObjectPropertyReference {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetConstructedDataObjectPropertyReferenceBuilder) Done() BACnetConstructedDataBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetConstructedDataBuilder().(*_BACnetConstructedDataBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetConstructedDataObjectPropertyReferenceBuilder) buildForBACnetConstructedData() (BACnetConstructedData, error) {
	return b.Build()
}

func (b *_BACnetConstructedDataObjectPropertyReferenceBuilder) DeepCopy() any {
	_copy := b.CreateBACnetConstructedDataObjectPropertyReferenceBuilder().(*_BACnetConstructedDataObjectPropertyReferenceBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateBACnetConstructedDataObjectPropertyReferenceBuilder creates a BACnetConstructedDataObjectPropertyReferenceBuilder
func (b *_BACnetConstructedDataObjectPropertyReference) CreateBACnetConstructedDataObjectPropertyReferenceBuilder() BACnetConstructedDataObjectPropertyReferenceBuilder {
	if b == nil {
		return NewBACnetConstructedDataObjectPropertyReferenceBuilder()
	}
	return &_BACnetConstructedDataObjectPropertyReferenceBuilder{_BACnetConstructedDataObjectPropertyReference: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_BACnetConstructedDataObjectPropertyReference) GetObjectTypeArgument() BACnetObjectType {
	return 0
}

func (m *_BACnetConstructedDataObjectPropertyReference) GetPropertyIdentifierArgument() BACnetPropertyIdentifier {
	return BACnetPropertyIdentifier_OBJECT_PROPERTY_REFERENCE
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetConstructedDataObjectPropertyReference) GetParent() BACnetConstructedDataContract {
	return m.BACnetConstructedDataContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetConstructedDataObjectPropertyReference) GetPropertyReference() BACnetDeviceObjectPropertyReference {
	return m.PropertyReference
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for virtual fields.
///////////////////////

func (m *_BACnetConstructedDataObjectPropertyReference) GetActualValue() BACnetDeviceObjectPropertyReference {
	ctx := context.Background()
	_ = ctx
	return CastBACnetDeviceObjectPropertyReference(m.GetPropertyReference())
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetConstructedDataObjectPropertyReference(structType any) BACnetConstructedDataObjectPropertyReference {
	if casted, ok := structType.(BACnetConstructedDataObjectPropertyReference); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetConstructedDataObjectPropertyReference); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetConstructedDataObjectPropertyReference) GetTypeName() string {
	return "BACnetConstructedDataObjectPropertyReference"
}

func (m *_BACnetConstructedDataObjectPropertyReference) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetConstructedDataContract.(*_BACnetConstructedData).getLengthInBits(ctx))

	// Simple field (propertyReference)
	lengthInBits += m.PropertyReference.GetLengthInBits(ctx)

	// A virtual field doesn't have any in- or output.

	return lengthInBits
}

func (m *_BACnetConstructedDataObjectPropertyReference) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetConstructedDataObjectPropertyReference) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetConstructedData, tagNumber uint8, objectTypeArgument BACnetObjectType, propertyIdentifierArgument BACnetPropertyIdentifier, arrayIndexArgument BACnetTagPayloadUnsignedInteger) (__bACnetConstructedDataObjectPropertyReference BACnetConstructedDataObjectPropertyReference, err error) {
	m.BACnetConstructedDataContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetConstructedDataObjectPropertyReference"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetConstructedDataObjectPropertyReference")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	propertyReference, err := ReadSimpleField[BACnetDeviceObjectPropertyReference](ctx, "propertyReference", ReadComplex[BACnetDeviceObjectPropertyReference](BACnetDeviceObjectPropertyReferenceParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'propertyReference' field"))
	}
	m.PropertyReference = propertyReference

	actualValue, err := ReadVirtualField[BACnetDeviceObjectPropertyReference](ctx, "actualValue", (*BACnetDeviceObjectPropertyReference)(nil), propertyReference)
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'actualValue' field"))
	}
	_ = actualValue

	if closeErr := readBuffer.CloseContext("BACnetConstructedDataObjectPropertyReference"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetConstructedDataObjectPropertyReference")
	}

	return m, nil
}

func (m *_BACnetConstructedDataObjectPropertyReference) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetConstructedDataObjectPropertyReference) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetConstructedDataObjectPropertyReference"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetConstructedDataObjectPropertyReference")
		}

		if err := WriteSimpleField[BACnetDeviceObjectPropertyReference](ctx, "propertyReference", m.GetPropertyReference(), WriteComplex[BACnetDeviceObjectPropertyReference](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'propertyReference' field")
		}
		// Virtual field
		actualValue := m.GetActualValue()
		_ = actualValue
		if _actualValueErr := writeBuffer.WriteVirtual(ctx, "actualValue", m.GetActualValue()); _actualValueErr != nil {
			return errors.Wrap(_actualValueErr, "Error serializing 'actualValue' field")
		}

		if popErr := writeBuffer.PopContext("BACnetConstructedDataObjectPropertyReference"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetConstructedDataObjectPropertyReference")
		}
		return nil
	}
	return m.BACnetConstructedDataContract.(*_BACnetConstructedData).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetConstructedDataObjectPropertyReference) IsBACnetConstructedDataObjectPropertyReference() {
}

func (m *_BACnetConstructedDataObjectPropertyReference) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetConstructedDataObjectPropertyReference) deepCopy() *_BACnetConstructedDataObjectPropertyReference {
	if m == nil {
		return nil
	}
	_BACnetConstructedDataObjectPropertyReferenceCopy := &_BACnetConstructedDataObjectPropertyReference{
		m.BACnetConstructedDataContract.(*_BACnetConstructedData).deepCopy(),
		utils.DeepCopy[BACnetDeviceObjectPropertyReference](m.PropertyReference),
	}
	_BACnetConstructedDataObjectPropertyReferenceCopy.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = m
	return _BACnetConstructedDataObjectPropertyReferenceCopy
}

func (m *_BACnetConstructedDataObjectPropertyReference) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
