/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetConstructedDataNotificationClass is the corresponding interface of BACnetConstructedDataNotificationClass
type BACnetConstructedDataNotificationClass interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetConstructedData
	// GetNotificationClass returns NotificationClass (property field)
	GetNotificationClass() BACnetApplicationTagUnsignedInteger
	// GetActualValue returns ActualValue (virtual field)
	GetActualValue() BACnetApplicationTagUnsignedInteger
	// IsBACnetConstructedDataNotificationClass is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetConstructedDataNotificationClass()
	// CreateBuilder creates a BACnetConstructedDataNotificationClassBuilder
	CreateBACnetConstructedDataNotificationClassBuilder() BACnetConstructedDataNotificationClassBuilder
}

// _BACnetConstructedDataNotificationClass is the data-structure of this message
type _BACnetConstructedDataNotificationClass struct {
	BACnetConstructedDataContract
	NotificationClass BACnetApplicationTagUnsignedInteger
}

var _ BACnetConstructedDataNotificationClass = (*_BACnetConstructedDataNotificationClass)(nil)
var _ BACnetConstructedDataRequirements = (*_BACnetConstructedDataNotificationClass)(nil)

// NewBACnetConstructedDataNotificationClass factory function for _BACnetConstructedDataNotificationClass
func NewBACnetConstructedDataNotificationClass(openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag, notificationClass BACnetApplicationTagUnsignedInteger, tagNumber uint8, arrayIndexArgument BACnetTagPayloadUnsignedInteger) *_BACnetConstructedDataNotificationClass {
	if notificationClass == nil {
		panic("notificationClass of type BACnetApplicationTagUnsignedInteger for BACnetConstructedDataNotificationClass must not be nil")
	}
	_result := &_BACnetConstructedDataNotificationClass{
		BACnetConstructedDataContract: NewBACnetConstructedData(openingTag, peekedTagHeader, closingTag, tagNumber, arrayIndexArgument),
		NotificationClass:             notificationClass,
	}
	_result.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetConstructedDataNotificationClassBuilder is a builder for BACnetConstructedDataNotificationClass
type BACnetConstructedDataNotificationClassBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(notificationClass BACnetApplicationTagUnsignedInteger) BACnetConstructedDataNotificationClassBuilder
	// WithNotificationClass adds NotificationClass (property field)
	WithNotificationClass(BACnetApplicationTagUnsignedInteger) BACnetConstructedDataNotificationClassBuilder
	// WithNotificationClassBuilder adds NotificationClass (property field) which is build by the builder
	WithNotificationClassBuilder(func(BACnetApplicationTagUnsignedIntegerBuilder) BACnetApplicationTagUnsignedIntegerBuilder) BACnetConstructedDataNotificationClassBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetConstructedDataBuilder
	// Build builds the BACnetConstructedDataNotificationClass or returns an error if something is wrong
	Build() (BACnetConstructedDataNotificationClass, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetConstructedDataNotificationClass
}

// NewBACnetConstructedDataNotificationClassBuilder() creates a BACnetConstructedDataNotificationClassBuilder
func NewBACnetConstructedDataNotificationClassBuilder() BACnetConstructedDataNotificationClassBuilder {
	return &_BACnetConstructedDataNotificationClassBuilder{_BACnetConstructedDataNotificationClass: new(_BACnetConstructedDataNotificationClass)}
}

type _BACnetConstructedDataNotificationClassBuilder struct {
	*_BACnetConstructedDataNotificationClass

	parentBuilder *_BACnetConstructedDataBuilder

	err *utils.MultiError
}

var _ (BACnetConstructedDataNotificationClassBuilder) = (*_BACnetConstructedDataNotificationClassBuilder)(nil)

func (b *_BACnetConstructedDataNotificationClassBuilder) setParent(contract BACnetConstructedDataContract) {
	b.BACnetConstructedDataContract = contract
	contract.(*_BACnetConstructedData)._SubType = b._BACnetConstructedDataNotificationClass
}

func (b *_BACnetConstructedDataNotificationClassBuilder) WithMandatoryFields(notificationClass BACnetApplicationTagUnsignedInteger) BACnetConstructedDataNotificationClassBuilder {
	return b.WithNotificationClass(notificationClass)
}

func (b *_BACnetConstructedDataNotificationClassBuilder) WithNotificationClass(notificationClass BACnetApplicationTagUnsignedInteger) BACnetConstructedDataNotificationClassBuilder {
	b.NotificationClass = notificationClass
	return b
}

func (b *_BACnetConstructedDataNotificationClassBuilder) WithNotificationClassBuilder(builderSupplier func(BACnetApplicationTagUnsignedIntegerBuilder) BACnetApplicationTagUnsignedIntegerBuilder) BACnetConstructedDataNotificationClassBuilder {
	builder := builderSupplier(b.NotificationClass.CreateBACnetApplicationTagUnsignedIntegerBuilder())
	var err error
	b.NotificationClass, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "BACnetApplicationTagUnsignedIntegerBuilder failed"))
	}
	return b
}

func (b *_BACnetConstructedDataNotificationClassBuilder) Build() (BACnetConstructedDataNotificationClass, error) {
	if b.NotificationClass == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'notificationClass' not set"))
	}
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._BACnetConstructedDataNotificationClass.deepCopy(), nil
}

func (b *_BACnetConstructedDataNotificationClassBuilder) MustBuild() BACnetConstructedDataNotificationClass {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetConstructedDataNotificationClassBuilder) Done() BACnetConstructedDataBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetConstructedDataBuilder().(*_BACnetConstructedDataBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetConstructedDataNotificationClassBuilder) buildForBACnetConstructedData() (BACnetConstructedData, error) {
	return b.Build()
}

func (b *_BACnetConstructedDataNotificationClassBuilder) DeepCopy() any {
	_copy := b.CreateBACnetConstructedDataNotificationClassBuilder().(*_BACnetConstructedDataNotificationClassBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateBACnetConstructedDataNotificationClassBuilder creates a BACnetConstructedDataNotificationClassBuilder
func (b *_BACnetConstructedDataNotificationClass) CreateBACnetConstructedDataNotificationClassBuilder() BACnetConstructedDataNotificationClassBuilder {
	if b == nil {
		return NewBACnetConstructedDataNotificationClassBuilder()
	}
	return &_BACnetConstructedDataNotificationClassBuilder{_BACnetConstructedDataNotificationClass: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_BACnetConstructedDataNotificationClass) GetObjectTypeArgument() BACnetObjectType {
	return 0
}

func (m *_BACnetConstructedDataNotificationClass) GetPropertyIdentifierArgument() BACnetPropertyIdentifier {
	return BACnetPropertyIdentifier_NOTIFICATION_CLASS
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetConstructedDataNotificationClass) GetParent() BACnetConstructedDataContract {
	return m.BACnetConstructedDataContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetConstructedDataNotificationClass) GetNotificationClass() BACnetApplicationTagUnsignedInteger {
	return m.NotificationClass
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for virtual fields.
///////////////////////

func (m *_BACnetConstructedDataNotificationClass) GetActualValue() BACnetApplicationTagUnsignedInteger {
	ctx := context.Background()
	_ = ctx
	return CastBACnetApplicationTagUnsignedInteger(m.GetNotificationClass())
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetConstructedDataNotificationClass(structType any) BACnetConstructedDataNotificationClass {
	if casted, ok := structType.(BACnetConstructedDataNotificationClass); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetConstructedDataNotificationClass); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetConstructedDataNotificationClass) GetTypeName() string {
	return "BACnetConstructedDataNotificationClass"
}

func (m *_BACnetConstructedDataNotificationClass) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetConstructedDataContract.(*_BACnetConstructedData).getLengthInBits(ctx))

	// Simple field (notificationClass)
	lengthInBits += m.NotificationClass.GetLengthInBits(ctx)

	// A virtual field doesn't have any in- or output.

	return lengthInBits
}

func (m *_BACnetConstructedDataNotificationClass) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetConstructedDataNotificationClass) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetConstructedData, tagNumber uint8, objectTypeArgument BACnetObjectType, propertyIdentifierArgument BACnetPropertyIdentifier, arrayIndexArgument BACnetTagPayloadUnsignedInteger) (__bACnetConstructedDataNotificationClass BACnetConstructedDataNotificationClass, err error) {
	m.BACnetConstructedDataContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetConstructedDataNotificationClass"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetConstructedDataNotificationClass")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	notificationClass, err := ReadSimpleField[BACnetApplicationTagUnsignedInteger](ctx, "notificationClass", ReadComplex[BACnetApplicationTagUnsignedInteger](BACnetApplicationTagParseWithBufferProducer[BACnetApplicationTagUnsignedInteger](), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'notificationClass' field"))
	}
	m.NotificationClass = notificationClass

	actualValue, err := ReadVirtualField[BACnetApplicationTagUnsignedInteger](ctx, "actualValue", (*BACnetApplicationTagUnsignedInteger)(nil), notificationClass)
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'actualValue' field"))
	}
	_ = actualValue

	if closeErr := readBuffer.CloseContext("BACnetConstructedDataNotificationClass"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetConstructedDataNotificationClass")
	}

	return m, nil
}

func (m *_BACnetConstructedDataNotificationClass) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetConstructedDataNotificationClass) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetConstructedDataNotificationClass"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetConstructedDataNotificationClass")
		}

		if err := WriteSimpleField[BACnetApplicationTagUnsignedInteger](ctx, "notificationClass", m.GetNotificationClass(), WriteComplex[BACnetApplicationTagUnsignedInteger](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'notificationClass' field")
		}
		// Virtual field
		actualValue := m.GetActualValue()
		_ = actualValue
		if _actualValueErr := writeBuffer.WriteVirtual(ctx, "actualValue", m.GetActualValue()); _actualValueErr != nil {
			return errors.Wrap(_actualValueErr, "Error serializing 'actualValue' field")
		}

		if popErr := writeBuffer.PopContext("BACnetConstructedDataNotificationClass"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetConstructedDataNotificationClass")
		}
		return nil
	}
	return m.BACnetConstructedDataContract.(*_BACnetConstructedData).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetConstructedDataNotificationClass) IsBACnetConstructedDataNotificationClass() {}

func (m *_BACnetConstructedDataNotificationClass) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetConstructedDataNotificationClass) deepCopy() *_BACnetConstructedDataNotificationClass {
	if m == nil {
		return nil
	}
	_BACnetConstructedDataNotificationClassCopy := &_BACnetConstructedDataNotificationClass{
		m.BACnetConstructedDataContract.(*_BACnetConstructedData).deepCopy(),
		utils.DeepCopy[BACnetApplicationTagUnsignedInteger](m.NotificationClass),
	}
	_BACnetConstructedDataNotificationClassCopy.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = m
	return _BACnetConstructedDataNotificationClassCopy
}

func (m *_BACnetConstructedDataNotificationClass) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
