/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetConstructedDataNetworkSecurityAll is the corresponding interface of BACnetConstructedDataNetworkSecurityAll
type BACnetConstructedDataNetworkSecurityAll interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetConstructedData
	// IsBACnetConstructedDataNetworkSecurityAll is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetConstructedDataNetworkSecurityAll()
	// CreateBuilder creates a BACnetConstructedDataNetworkSecurityAllBuilder
	CreateBACnetConstructedDataNetworkSecurityAllBuilder() BACnetConstructedDataNetworkSecurityAllBuilder
}

// _BACnetConstructedDataNetworkSecurityAll is the data-structure of this message
type _BACnetConstructedDataNetworkSecurityAll struct {
	BACnetConstructedDataContract
}

var _ BACnetConstructedDataNetworkSecurityAll = (*_BACnetConstructedDataNetworkSecurityAll)(nil)
var _ BACnetConstructedDataRequirements = (*_BACnetConstructedDataNetworkSecurityAll)(nil)

// NewBACnetConstructedDataNetworkSecurityAll factory function for _BACnetConstructedDataNetworkSecurityAll
func NewBACnetConstructedDataNetworkSecurityAll(openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag, tagNumber uint8, arrayIndexArgument BACnetTagPayloadUnsignedInteger) *_BACnetConstructedDataNetworkSecurityAll {
	_result := &_BACnetConstructedDataNetworkSecurityAll{
		BACnetConstructedDataContract: NewBACnetConstructedData(openingTag, peekedTagHeader, closingTag, tagNumber, arrayIndexArgument),
	}
	_result.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetConstructedDataNetworkSecurityAllBuilder is a builder for BACnetConstructedDataNetworkSecurityAll
type BACnetConstructedDataNetworkSecurityAllBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields() BACnetConstructedDataNetworkSecurityAllBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetConstructedDataBuilder
	// Build builds the BACnetConstructedDataNetworkSecurityAll or returns an error if something is wrong
	Build() (BACnetConstructedDataNetworkSecurityAll, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetConstructedDataNetworkSecurityAll
}

// NewBACnetConstructedDataNetworkSecurityAllBuilder() creates a BACnetConstructedDataNetworkSecurityAllBuilder
func NewBACnetConstructedDataNetworkSecurityAllBuilder() BACnetConstructedDataNetworkSecurityAllBuilder {
	return &_BACnetConstructedDataNetworkSecurityAllBuilder{_BACnetConstructedDataNetworkSecurityAll: new(_BACnetConstructedDataNetworkSecurityAll)}
}

type _BACnetConstructedDataNetworkSecurityAllBuilder struct {
	*_BACnetConstructedDataNetworkSecurityAll

	parentBuilder *_BACnetConstructedDataBuilder

	err *utils.MultiError
}

var _ (BACnetConstructedDataNetworkSecurityAllBuilder) = (*_BACnetConstructedDataNetworkSecurityAllBuilder)(nil)

func (b *_BACnetConstructedDataNetworkSecurityAllBuilder) setParent(contract BACnetConstructedDataContract) {
	b.BACnetConstructedDataContract = contract
	contract.(*_BACnetConstructedData)._SubType = b._BACnetConstructedDataNetworkSecurityAll
}

func (b *_BACnetConstructedDataNetworkSecurityAllBuilder) WithMandatoryFields() BACnetConstructedDataNetworkSecurityAllBuilder {
	return b
}

func (b *_BACnetConstructedDataNetworkSecurityAllBuilder) Build() (BACnetConstructedDataNetworkSecurityAll, error) {
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._BACnetConstructedDataNetworkSecurityAll.deepCopy(), nil
}

func (b *_BACnetConstructedDataNetworkSecurityAllBuilder) MustBuild() BACnetConstructedDataNetworkSecurityAll {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetConstructedDataNetworkSecurityAllBuilder) Done() BACnetConstructedDataBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetConstructedDataBuilder().(*_BACnetConstructedDataBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetConstructedDataNetworkSecurityAllBuilder) buildForBACnetConstructedData() (BACnetConstructedData, error) {
	return b.Build()
}

func (b *_BACnetConstructedDataNetworkSecurityAllBuilder) DeepCopy() any {
	_copy := b.CreateBACnetConstructedDataNetworkSecurityAllBuilder().(*_BACnetConstructedDataNetworkSecurityAllBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateBACnetConstructedDataNetworkSecurityAllBuilder creates a BACnetConstructedDataNetworkSecurityAllBuilder
func (b *_BACnetConstructedDataNetworkSecurityAll) CreateBACnetConstructedDataNetworkSecurityAllBuilder() BACnetConstructedDataNetworkSecurityAllBuilder {
	if b == nil {
		return NewBACnetConstructedDataNetworkSecurityAllBuilder()
	}
	return &_BACnetConstructedDataNetworkSecurityAllBuilder{_BACnetConstructedDataNetworkSecurityAll: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_BACnetConstructedDataNetworkSecurityAll) GetObjectTypeArgument() BACnetObjectType {
	return BACnetObjectType_NETWORK_SECURITY
}

func (m *_BACnetConstructedDataNetworkSecurityAll) GetPropertyIdentifierArgument() BACnetPropertyIdentifier {
	return BACnetPropertyIdentifier_ALL
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetConstructedDataNetworkSecurityAll) GetParent() BACnetConstructedDataContract {
	return m.BACnetConstructedDataContract
}

// Deprecated: use the interface for direct cast
func CastBACnetConstructedDataNetworkSecurityAll(structType any) BACnetConstructedDataNetworkSecurityAll {
	if casted, ok := structType.(BACnetConstructedDataNetworkSecurityAll); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetConstructedDataNetworkSecurityAll); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetConstructedDataNetworkSecurityAll) GetTypeName() string {
	return "BACnetConstructedDataNetworkSecurityAll"
}

func (m *_BACnetConstructedDataNetworkSecurityAll) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetConstructedDataContract.(*_BACnetConstructedData).getLengthInBits(ctx))

	return lengthInBits
}

func (m *_BACnetConstructedDataNetworkSecurityAll) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetConstructedDataNetworkSecurityAll) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetConstructedData, tagNumber uint8, objectTypeArgument BACnetObjectType, propertyIdentifierArgument BACnetPropertyIdentifier, arrayIndexArgument BACnetTagPayloadUnsignedInteger) (__bACnetConstructedDataNetworkSecurityAll BACnetConstructedDataNetworkSecurityAll, err error) {
	m.BACnetConstructedDataContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetConstructedDataNetworkSecurityAll"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetConstructedDataNetworkSecurityAll")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	// Validation
	if !(bool((1) == (2))) {
		return nil, errors.WithStack(utils.ParseValidationError{Message: "All should never occur in context of constructed data. If it does please report"})
	}

	if closeErr := readBuffer.CloseContext("BACnetConstructedDataNetworkSecurityAll"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetConstructedDataNetworkSecurityAll")
	}

	return m, nil
}

func (m *_BACnetConstructedDataNetworkSecurityAll) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetConstructedDataNetworkSecurityAll) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetConstructedDataNetworkSecurityAll"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetConstructedDataNetworkSecurityAll")
		}

		if popErr := writeBuffer.PopContext("BACnetConstructedDataNetworkSecurityAll"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetConstructedDataNetworkSecurityAll")
		}
		return nil
	}
	return m.BACnetConstructedDataContract.(*_BACnetConstructedData).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetConstructedDataNetworkSecurityAll) IsBACnetConstructedDataNetworkSecurityAll() {}

func (m *_BACnetConstructedDataNetworkSecurityAll) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetConstructedDataNetworkSecurityAll) deepCopy() *_BACnetConstructedDataNetworkSecurityAll {
	if m == nil {
		return nil
	}
	_BACnetConstructedDataNetworkSecurityAllCopy := &_BACnetConstructedDataNetworkSecurityAll{
		m.BACnetConstructedDataContract.(*_BACnetConstructedData).deepCopy(),
	}
	_BACnetConstructedDataNetworkSecurityAllCopy.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = m
	return _BACnetConstructedDataNetworkSecurityAllCopy
}

func (m *_BACnetConstructedDataNetworkSecurityAll) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
