/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetConstructedDataNetworkPortAll is the corresponding interface of BACnetConstructedDataNetworkPortAll
type BACnetConstructedDataNetworkPortAll interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetConstructedData
	// IsBACnetConstructedDataNetworkPortAll is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetConstructedDataNetworkPortAll()
	// CreateBuilder creates a BACnetConstructedDataNetworkPortAllBuilder
	CreateBACnetConstructedDataNetworkPortAllBuilder() BACnetConstructedDataNetworkPortAllBuilder
}

// _BACnetConstructedDataNetworkPortAll is the data-structure of this message
type _BACnetConstructedDataNetworkPortAll struct {
	BACnetConstructedDataContract
}

var _ BACnetConstructedDataNetworkPortAll = (*_BACnetConstructedDataNetworkPortAll)(nil)
var _ BACnetConstructedDataRequirements = (*_BACnetConstructedDataNetworkPortAll)(nil)

// NewBACnetConstructedDataNetworkPortAll factory function for _BACnetConstructedDataNetworkPortAll
func NewBACnetConstructedDataNetworkPortAll(openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag, tagNumber uint8, arrayIndexArgument BACnetTagPayloadUnsignedInteger) *_BACnetConstructedDataNetworkPortAll {
	_result := &_BACnetConstructedDataNetworkPortAll{
		BACnetConstructedDataContract: NewBACnetConstructedData(openingTag, peekedTagHeader, closingTag, tagNumber, arrayIndexArgument),
	}
	_result.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetConstructedDataNetworkPortAllBuilder is a builder for BACnetConstructedDataNetworkPortAll
type BACnetConstructedDataNetworkPortAllBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields() BACnetConstructedDataNetworkPortAllBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetConstructedDataBuilder
	// Build builds the BACnetConstructedDataNetworkPortAll or returns an error if something is wrong
	Build() (BACnetConstructedDataNetworkPortAll, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetConstructedDataNetworkPortAll
}

// NewBACnetConstructedDataNetworkPortAllBuilder() creates a BACnetConstructedDataNetworkPortAllBuilder
func NewBACnetConstructedDataNetworkPortAllBuilder() BACnetConstructedDataNetworkPortAllBuilder {
	return &_BACnetConstructedDataNetworkPortAllBuilder{_BACnetConstructedDataNetworkPortAll: new(_BACnetConstructedDataNetworkPortAll)}
}

type _BACnetConstructedDataNetworkPortAllBuilder struct {
	*_BACnetConstructedDataNetworkPortAll

	parentBuilder *_BACnetConstructedDataBuilder

	err *utils.MultiError
}

var _ (BACnetConstructedDataNetworkPortAllBuilder) = (*_BACnetConstructedDataNetworkPortAllBuilder)(nil)

func (b *_BACnetConstructedDataNetworkPortAllBuilder) setParent(contract BACnetConstructedDataContract) {
	b.BACnetConstructedDataContract = contract
	contract.(*_BACnetConstructedData)._SubType = b._BACnetConstructedDataNetworkPortAll
}

func (b *_BACnetConstructedDataNetworkPortAllBuilder) WithMandatoryFields() BACnetConstructedDataNetworkPortAllBuilder {
	return b
}

func (b *_BACnetConstructedDataNetworkPortAllBuilder) Build() (BACnetConstructedDataNetworkPortAll, error) {
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._BACnetConstructedDataNetworkPortAll.deepCopy(), nil
}

func (b *_BACnetConstructedDataNetworkPortAllBuilder) MustBuild() BACnetConstructedDataNetworkPortAll {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetConstructedDataNetworkPortAllBuilder) Done() BACnetConstructedDataBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetConstructedDataBuilder().(*_BACnetConstructedDataBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetConstructedDataNetworkPortAllBuilder) buildForBACnetConstructedData() (BACnetConstructedData, error) {
	return b.Build()
}

func (b *_BACnetConstructedDataNetworkPortAllBuilder) DeepCopy() any {
	_copy := b.CreateBACnetConstructedDataNetworkPortAllBuilder().(*_BACnetConstructedDataNetworkPortAllBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateBACnetConstructedDataNetworkPortAllBuilder creates a BACnetConstructedDataNetworkPortAllBuilder
func (b *_BACnetConstructedDataNetworkPortAll) CreateBACnetConstructedDataNetworkPortAllBuilder() BACnetConstructedDataNetworkPortAllBuilder {
	if b == nil {
		return NewBACnetConstructedDataNetworkPortAllBuilder()
	}
	return &_BACnetConstructedDataNetworkPortAllBuilder{_BACnetConstructedDataNetworkPortAll: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_BACnetConstructedDataNetworkPortAll) GetObjectTypeArgument() BACnetObjectType {
	return BACnetObjectType_NETWORK_PORT
}

func (m *_BACnetConstructedDataNetworkPortAll) GetPropertyIdentifierArgument() BACnetPropertyIdentifier {
	return BACnetPropertyIdentifier_ALL
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetConstructedDataNetworkPortAll) GetParent() BACnetConstructedDataContract {
	return m.BACnetConstructedDataContract
}

// Deprecated: use the interface for direct cast
func CastBACnetConstructedDataNetworkPortAll(structType any) BACnetConstructedDataNetworkPortAll {
	if casted, ok := structType.(BACnetConstructedDataNetworkPortAll); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetConstructedDataNetworkPortAll); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetConstructedDataNetworkPortAll) GetTypeName() string {
	return "BACnetConstructedDataNetworkPortAll"
}

func (m *_BACnetConstructedDataNetworkPortAll) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetConstructedDataContract.(*_BACnetConstructedData).getLengthInBits(ctx))

	return lengthInBits
}

func (m *_BACnetConstructedDataNetworkPortAll) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetConstructedDataNetworkPortAll) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetConstructedData, tagNumber uint8, objectTypeArgument BACnetObjectType, propertyIdentifierArgument BACnetPropertyIdentifier, arrayIndexArgument BACnetTagPayloadUnsignedInteger) (__bACnetConstructedDataNetworkPortAll BACnetConstructedDataNetworkPortAll, err error) {
	m.BACnetConstructedDataContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetConstructedDataNetworkPortAll"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetConstructedDataNetworkPortAll")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	// Validation
	if !(bool((1) == (2))) {
		return nil, errors.WithStack(utils.ParseValidationError{Message: "All should never occur in context of constructed data. If it does please report"})
	}

	if closeErr := readBuffer.CloseContext("BACnetConstructedDataNetworkPortAll"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetConstructedDataNetworkPortAll")
	}

	return m, nil
}

func (m *_BACnetConstructedDataNetworkPortAll) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetConstructedDataNetworkPortAll) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetConstructedDataNetworkPortAll"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetConstructedDataNetworkPortAll")
		}

		if popErr := writeBuffer.PopContext("BACnetConstructedDataNetworkPortAll"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetConstructedDataNetworkPortAll")
		}
		return nil
	}
	return m.BACnetConstructedDataContract.(*_BACnetConstructedData).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetConstructedDataNetworkPortAll) IsBACnetConstructedDataNetworkPortAll() {}

func (m *_BACnetConstructedDataNetworkPortAll) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetConstructedDataNetworkPortAll) deepCopy() *_BACnetConstructedDataNetworkPortAll {
	if m == nil {
		return nil
	}
	_BACnetConstructedDataNetworkPortAllCopy := &_BACnetConstructedDataNetworkPortAll{
		m.BACnetConstructedDataContract.(*_BACnetConstructedData).deepCopy(),
	}
	_BACnetConstructedDataNetworkPortAllCopy.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = m
	return _BACnetConstructedDataNetworkPortAllCopy
}

func (m *_BACnetConstructedDataNetworkPortAll) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
