/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetConstructedDataMaxFailedAttempts is the corresponding interface of BACnetConstructedDataMaxFailedAttempts
type BACnetConstructedDataMaxFailedAttempts interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetConstructedData
	// GetMaxFailedAttempts returns MaxFailedAttempts (property field)
	GetMaxFailedAttempts() BACnetApplicationTagUnsignedInteger
	// GetActualValue returns ActualValue (virtual field)
	GetActualValue() BACnetApplicationTagUnsignedInteger
	// IsBACnetConstructedDataMaxFailedAttempts is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetConstructedDataMaxFailedAttempts()
	// CreateBuilder creates a BACnetConstructedDataMaxFailedAttemptsBuilder
	CreateBACnetConstructedDataMaxFailedAttemptsBuilder() BACnetConstructedDataMaxFailedAttemptsBuilder
}

// _BACnetConstructedDataMaxFailedAttempts is the data-structure of this message
type _BACnetConstructedDataMaxFailedAttempts struct {
	BACnetConstructedDataContract
	MaxFailedAttempts BACnetApplicationTagUnsignedInteger
}

var _ BACnetConstructedDataMaxFailedAttempts = (*_BACnetConstructedDataMaxFailedAttempts)(nil)
var _ BACnetConstructedDataRequirements = (*_BACnetConstructedDataMaxFailedAttempts)(nil)

// NewBACnetConstructedDataMaxFailedAttempts factory function for _BACnetConstructedDataMaxFailedAttempts
func NewBACnetConstructedDataMaxFailedAttempts(openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag, maxFailedAttempts BACnetApplicationTagUnsignedInteger, tagNumber uint8, arrayIndexArgument BACnetTagPayloadUnsignedInteger) *_BACnetConstructedDataMaxFailedAttempts {
	if maxFailedAttempts == nil {
		panic("maxFailedAttempts of type BACnetApplicationTagUnsignedInteger for BACnetConstructedDataMaxFailedAttempts must not be nil")
	}
	_result := &_BACnetConstructedDataMaxFailedAttempts{
		BACnetConstructedDataContract: NewBACnetConstructedData(openingTag, peekedTagHeader, closingTag, tagNumber, arrayIndexArgument),
		MaxFailedAttempts:             maxFailedAttempts,
	}
	_result.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetConstructedDataMaxFailedAttemptsBuilder is a builder for BACnetConstructedDataMaxFailedAttempts
type BACnetConstructedDataMaxFailedAttemptsBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(maxFailedAttempts BACnetApplicationTagUnsignedInteger) BACnetConstructedDataMaxFailedAttemptsBuilder
	// WithMaxFailedAttempts adds MaxFailedAttempts (property field)
	WithMaxFailedAttempts(BACnetApplicationTagUnsignedInteger) BACnetConstructedDataMaxFailedAttemptsBuilder
	// WithMaxFailedAttemptsBuilder adds MaxFailedAttempts (property field) which is build by the builder
	WithMaxFailedAttemptsBuilder(func(BACnetApplicationTagUnsignedIntegerBuilder) BACnetApplicationTagUnsignedIntegerBuilder) BACnetConstructedDataMaxFailedAttemptsBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetConstructedDataBuilder
	// Build builds the BACnetConstructedDataMaxFailedAttempts or returns an error if something is wrong
	Build() (BACnetConstructedDataMaxFailedAttempts, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetConstructedDataMaxFailedAttempts
}

// NewBACnetConstructedDataMaxFailedAttemptsBuilder() creates a BACnetConstructedDataMaxFailedAttemptsBuilder
func NewBACnetConstructedDataMaxFailedAttemptsBuilder() BACnetConstructedDataMaxFailedAttemptsBuilder {
	return &_BACnetConstructedDataMaxFailedAttemptsBuilder{_BACnetConstructedDataMaxFailedAttempts: new(_BACnetConstructedDataMaxFailedAttempts)}
}

type _BACnetConstructedDataMaxFailedAttemptsBuilder struct {
	*_BACnetConstructedDataMaxFailedAttempts

	parentBuilder *_BACnetConstructedDataBuilder

	err *utils.MultiError
}

var _ (BACnetConstructedDataMaxFailedAttemptsBuilder) = (*_BACnetConstructedDataMaxFailedAttemptsBuilder)(nil)

func (b *_BACnetConstructedDataMaxFailedAttemptsBuilder) setParent(contract BACnetConstructedDataContract) {
	b.BACnetConstructedDataContract = contract
	contract.(*_BACnetConstructedData)._SubType = b._BACnetConstructedDataMaxFailedAttempts
}

func (b *_BACnetConstructedDataMaxFailedAttemptsBuilder) WithMandatoryFields(maxFailedAttempts BACnetApplicationTagUnsignedInteger) BACnetConstructedDataMaxFailedAttemptsBuilder {
	return b.WithMaxFailedAttempts(maxFailedAttempts)
}

func (b *_BACnetConstructedDataMaxFailedAttemptsBuilder) WithMaxFailedAttempts(maxFailedAttempts BACnetApplicationTagUnsignedInteger) BACnetConstructedDataMaxFailedAttemptsBuilder {
	b.MaxFailedAttempts = maxFailedAttempts
	return b
}

func (b *_BACnetConstructedDataMaxFailedAttemptsBuilder) WithMaxFailedAttemptsBuilder(builderSupplier func(BACnetApplicationTagUnsignedIntegerBuilder) BACnetApplicationTagUnsignedIntegerBuilder) BACnetConstructedDataMaxFailedAttemptsBuilder {
	builder := builderSupplier(b.MaxFailedAttempts.CreateBACnetApplicationTagUnsignedIntegerBuilder())
	var err error
	b.MaxFailedAttempts, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "BACnetApplicationTagUnsignedIntegerBuilder failed"))
	}
	return b
}

func (b *_BACnetConstructedDataMaxFailedAttemptsBuilder) Build() (BACnetConstructedDataMaxFailedAttempts, error) {
	if b.MaxFailedAttempts == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'maxFailedAttempts' not set"))
	}
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._BACnetConstructedDataMaxFailedAttempts.deepCopy(), nil
}

func (b *_BACnetConstructedDataMaxFailedAttemptsBuilder) MustBuild() BACnetConstructedDataMaxFailedAttempts {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetConstructedDataMaxFailedAttemptsBuilder) Done() BACnetConstructedDataBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetConstructedDataBuilder().(*_BACnetConstructedDataBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetConstructedDataMaxFailedAttemptsBuilder) buildForBACnetConstructedData() (BACnetConstructedData, error) {
	return b.Build()
}

func (b *_BACnetConstructedDataMaxFailedAttemptsBuilder) DeepCopy() any {
	_copy := b.CreateBACnetConstructedDataMaxFailedAttemptsBuilder().(*_BACnetConstructedDataMaxFailedAttemptsBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateBACnetConstructedDataMaxFailedAttemptsBuilder creates a BACnetConstructedDataMaxFailedAttemptsBuilder
func (b *_BACnetConstructedDataMaxFailedAttempts) CreateBACnetConstructedDataMaxFailedAttemptsBuilder() BACnetConstructedDataMaxFailedAttemptsBuilder {
	if b == nil {
		return NewBACnetConstructedDataMaxFailedAttemptsBuilder()
	}
	return &_BACnetConstructedDataMaxFailedAttemptsBuilder{_BACnetConstructedDataMaxFailedAttempts: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_BACnetConstructedDataMaxFailedAttempts) GetObjectTypeArgument() BACnetObjectType {
	return 0
}

func (m *_BACnetConstructedDataMaxFailedAttempts) GetPropertyIdentifierArgument() BACnetPropertyIdentifier {
	return BACnetPropertyIdentifier_MAX_FAILED_ATTEMPTS
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetConstructedDataMaxFailedAttempts) GetParent() BACnetConstructedDataContract {
	return m.BACnetConstructedDataContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetConstructedDataMaxFailedAttempts) GetMaxFailedAttempts() BACnetApplicationTagUnsignedInteger {
	return m.MaxFailedAttempts
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for virtual fields.
///////////////////////

func (m *_BACnetConstructedDataMaxFailedAttempts) GetActualValue() BACnetApplicationTagUnsignedInteger {
	ctx := context.Background()
	_ = ctx
	return CastBACnetApplicationTagUnsignedInteger(m.GetMaxFailedAttempts())
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetConstructedDataMaxFailedAttempts(structType any) BACnetConstructedDataMaxFailedAttempts {
	if casted, ok := structType.(BACnetConstructedDataMaxFailedAttempts); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetConstructedDataMaxFailedAttempts); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetConstructedDataMaxFailedAttempts) GetTypeName() string {
	return "BACnetConstructedDataMaxFailedAttempts"
}

func (m *_BACnetConstructedDataMaxFailedAttempts) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetConstructedDataContract.(*_BACnetConstructedData).getLengthInBits(ctx))

	// Simple field (maxFailedAttempts)
	lengthInBits += m.MaxFailedAttempts.GetLengthInBits(ctx)

	// A virtual field doesn't have any in- or output.

	return lengthInBits
}

func (m *_BACnetConstructedDataMaxFailedAttempts) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetConstructedDataMaxFailedAttempts) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetConstructedData, tagNumber uint8, objectTypeArgument BACnetObjectType, propertyIdentifierArgument BACnetPropertyIdentifier, arrayIndexArgument BACnetTagPayloadUnsignedInteger) (__bACnetConstructedDataMaxFailedAttempts BACnetConstructedDataMaxFailedAttempts, err error) {
	m.BACnetConstructedDataContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetConstructedDataMaxFailedAttempts"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetConstructedDataMaxFailedAttempts")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	maxFailedAttempts, err := ReadSimpleField[BACnetApplicationTagUnsignedInteger](ctx, "maxFailedAttempts", ReadComplex[BACnetApplicationTagUnsignedInteger](BACnetApplicationTagParseWithBufferProducer[BACnetApplicationTagUnsignedInteger](), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'maxFailedAttempts' field"))
	}
	m.MaxFailedAttempts = maxFailedAttempts

	actualValue, err := ReadVirtualField[BACnetApplicationTagUnsignedInteger](ctx, "actualValue", (*BACnetApplicationTagUnsignedInteger)(nil), maxFailedAttempts)
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'actualValue' field"))
	}
	_ = actualValue

	if closeErr := readBuffer.CloseContext("BACnetConstructedDataMaxFailedAttempts"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetConstructedDataMaxFailedAttempts")
	}

	return m, nil
}

func (m *_BACnetConstructedDataMaxFailedAttempts) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetConstructedDataMaxFailedAttempts) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetConstructedDataMaxFailedAttempts"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetConstructedDataMaxFailedAttempts")
		}

		if err := WriteSimpleField[BACnetApplicationTagUnsignedInteger](ctx, "maxFailedAttempts", m.GetMaxFailedAttempts(), WriteComplex[BACnetApplicationTagUnsignedInteger](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'maxFailedAttempts' field")
		}
		// Virtual field
		actualValue := m.GetActualValue()
		_ = actualValue
		if _actualValueErr := writeBuffer.WriteVirtual(ctx, "actualValue", m.GetActualValue()); _actualValueErr != nil {
			return errors.Wrap(_actualValueErr, "Error serializing 'actualValue' field")
		}

		if popErr := writeBuffer.PopContext("BACnetConstructedDataMaxFailedAttempts"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetConstructedDataMaxFailedAttempts")
		}
		return nil
	}
	return m.BACnetConstructedDataContract.(*_BACnetConstructedData).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetConstructedDataMaxFailedAttempts) IsBACnetConstructedDataMaxFailedAttempts() {}

func (m *_BACnetConstructedDataMaxFailedAttempts) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetConstructedDataMaxFailedAttempts) deepCopy() *_BACnetConstructedDataMaxFailedAttempts {
	if m == nil {
		return nil
	}
	_BACnetConstructedDataMaxFailedAttemptsCopy := &_BACnetConstructedDataMaxFailedAttempts{
		m.BACnetConstructedDataContract.(*_BACnetConstructedData).deepCopy(),
		utils.DeepCopy[BACnetApplicationTagUnsignedInteger](m.MaxFailedAttempts),
	}
	_BACnetConstructedDataMaxFailedAttemptsCopy.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = m
	return _BACnetConstructedDataMaxFailedAttemptsCopy
}

func (m *_BACnetConstructedDataMaxFailedAttempts) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
