/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetConstructedDataMakingCarCall is the corresponding interface of BACnetConstructedDataMakingCarCall
type BACnetConstructedDataMakingCarCall interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetConstructedData
	// GetNumberOfDataElements returns NumberOfDataElements (property field)
	GetNumberOfDataElements() BACnetApplicationTagUnsignedInteger
	// GetMakingCarCall returns MakingCarCall (property field)
	GetMakingCarCall() []BACnetApplicationTagUnsignedInteger
	// GetZero returns Zero (virtual field)
	GetZero() uint64
	// IsBACnetConstructedDataMakingCarCall is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetConstructedDataMakingCarCall()
	// CreateBuilder creates a BACnetConstructedDataMakingCarCallBuilder
	CreateBACnetConstructedDataMakingCarCallBuilder() BACnetConstructedDataMakingCarCallBuilder
}

// _BACnetConstructedDataMakingCarCall is the data-structure of this message
type _BACnetConstructedDataMakingCarCall struct {
	BACnetConstructedDataContract
	NumberOfDataElements BACnetApplicationTagUnsignedInteger
	MakingCarCall        []BACnetApplicationTagUnsignedInteger
}

var _ BACnetConstructedDataMakingCarCall = (*_BACnetConstructedDataMakingCarCall)(nil)
var _ BACnetConstructedDataRequirements = (*_BACnetConstructedDataMakingCarCall)(nil)

// NewBACnetConstructedDataMakingCarCall factory function for _BACnetConstructedDataMakingCarCall
func NewBACnetConstructedDataMakingCarCall(openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag, numberOfDataElements BACnetApplicationTagUnsignedInteger, makingCarCall []BACnetApplicationTagUnsignedInteger, tagNumber uint8, arrayIndexArgument BACnetTagPayloadUnsignedInteger) *_BACnetConstructedDataMakingCarCall {
	_result := &_BACnetConstructedDataMakingCarCall{
		BACnetConstructedDataContract: NewBACnetConstructedData(openingTag, peekedTagHeader, closingTag, tagNumber, arrayIndexArgument),
		NumberOfDataElements:          numberOfDataElements,
		MakingCarCall:                 makingCarCall,
	}
	_result.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetConstructedDataMakingCarCallBuilder is a builder for BACnetConstructedDataMakingCarCall
type BACnetConstructedDataMakingCarCallBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(makingCarCall []BACnetApplicationTagUnsignedInteger) BACnetConstructedDataMakingCarCallBuilder
	// WithNumberOfDataElements adds NumberOfDataElements (property field)
	WithOptionalNumberOfDataElements(BACnetApplicationTagUnsignedInteger) BACnetConstructedDataMakingCarCallBuilder
	// WithOptionalNumberOfDataElementsBuilder adds NumberOfDataElements (property field) which is build by the builder
	WithOptionalNumberOfDataElementsBuilder(func(BACnetApplicationTagUnsignedIntegerBuilder) BACnetApplicationTagUnsignedIntegerBuilder) BACnetConstructedDataMakingCarCallBuilder
	// WithMakingCarCall adds MakingCarCall (property field)
	WithMakingCarCall(...BACnetApplicationTagUnsignedInteger) BACnetConstructedDataMakingCarCallBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetConstructedDataBuilder
	// Build builds the BACnetConstructedDataMakingCarCall or returns an error if something is wrong
	Build() (BACnetConstructedDataMakingCarCall, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetConstructedDataMakingCarCall
}

// NewBACnetConstructedDataMakingCarCallBuilder() creates a BACnetConstructedDataMakingCarCallBuilder
func NewBACnetConstructedDataMakingCarCallBuilder() BACnetConstructedDataMakingCarCallBuilder {
	return &_BACnetConstructedDataMakingCarCallBuilder{_BACnetConstructedDataMakingCarCall: new(_BACnetConstructedDataMakingCarCall)}
}

type _BACnetConstructedDataMakingCarCallBuilder struct {
	*_BACnetConstructedDataMakingCarCall

	parentBuilder *_BACnetConstructedDataBuilder

	err *utils.MultiError
}

var _ (BACnetConstructedDataMakingCarCallBuilder) = (*_BACnetConstructedDataMakingCarCallBuilder)(nil)

func (b *_BACnetConstructedDataMakingCarCallBuilder) setParent(contract BACnetConstructedDataContract) {
	b.BACnetConstructedDataContract = contract
	contract.(*_BACnetConstructedData)._SubType = b._BACnetConstructedDataMakingCarCall
}

func (b *_BACnetConstructedDataMakingCarCallBuilder) WithMandatoryFields(makingCarCall []BACnetApplicationTagUnsignedInteger) BACnetConstructedDataMakingCarCallBuilder {
	return b.WithMakingCarCall(makingCarCall...)
}

func (b *_BACnetConstructedDataMakingCarCallBuilder) WithOptionalNumberOfDataElements(numberOfDataElements BACnetApplicationTagUnsignedInteger) BACnetConstructedDataMakingCarCallBuilder {
	b.NumberOfDataElements = numberOfDataElements
	return b
}

func (b *_BACnetConstructedDataMakingCarCallBuilder) WithOptionalNumberOfDataElementsBuilder(builderSupplier func(BACnetApplicationTagUnsignedIntegerBuilder) BACnetApplicationTagUnsignedIntegerBuilder) BACnetConstructedDataMakingCarCallBuilder {
	builder := builderSupplier(b.NumberOfDataElements.CreateBACnetApplicationTagUnsignedIntegerBuilder())
	var err error
	b.NumberOfDataElements, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "BACnetApplicationTagUnsignedIntegerBuilder failed"))
	}
	return b
}

func (b *_BACnetConstructedDataMakingCarCallBuilder) WithMakingCarCall(makingCarCall ...BACnetApplicationTagUnsignedInteger) BACnetConstructedDataMakingCarCallBuilder {
	b.MakingCarCall = makingCarCall
	return b
}

func (b *_BACnetConstructedDataMakingCarCallBuilder) Build() (BACnetConstructedDataMakingCarCall, error) {
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._BACnetConstructedDataMakingCarCall.deepCopy(), nil
}

func (b *_BACnetConstructedDataMakingCarCallBuilder) MustBuild() BACnetConstructedDataMakingCarCall {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetConstructedDataMakingCarCallBuilder) Done() BACnetConstructedDataBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetConstructedDataBuilder().(*_BACnetConstructedDataBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetConstructedDataMakingCarCallBuilder) buildForBACnetConstructedData() (BACnetConstructedData, error) {
	return b.Build()
}

func (b *_BACnetConstructedDataMakingCarCallBuilder) DeepCopy() any {
	_copy := b.CreateBACnetConstructedDataMakingCarCallBuilder().(*_BACnetConstructedDataMakingCarCallBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateBACnetConstructedDataMakingCarCallBuilder creates a BACnetConstructedDataMakingCarCallBuilder
func (b *_BACnetConstructedDataMakingCarCall) CreateBACnetConstructedDataMakingCarCallBuilder() BACnetConstructedDataMakingCarCallBuilder {
	if b == nil {
		return NewBACnetConstructedDataMakingCarCallBuilder()
	}
	return &_BACnetConstructedDataMakingCarCallBuilder{_BACnetConstructedDataMakingCarCall: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_BACnetConstructedDataMakingCarCall) GetObjectTypeArgument() BACnetObjectType {
	return 0
}

func (m *_BACnetConstructedDataMakingCarCall) GetPropertyIdentifierArgument() BACnetPropertyIdentifier {
	return BACnetPropertyIdentifier_MAKING_CAR_CALL
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetConstructedDataMakingCarCall) GetParent() BACnetConstructedDataContract {
	return m.BACnetConstructedDataContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetConstructedDataMakingCarCall) GetNumberOfDataElements() BACnetApplicationTagUnsignedInteger {
	return m.NumberOfDataElements
}

func (m *_BACnetConstructedDataMakingCarCall) GetMakingCarCall() []BACnetApplicationTagUnsignedInteger {
	return m.MakingCarCall
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for virtual fields.
///////////////////////

func (m *_BACnetConstructedDataMakingCarCall) GetZero() uint64 {
	ctx := context.Background()
	_ = ctx
	numberOfDataElements := m.GetNumberOfDataElements()
	_ = numberOfDataElements
	return uint64(uint64(0))
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetConstructedDataMakingCarCall(structType any) BACnetConstructedDataMakingCarCall {
	if casted, ok := structType.(BACnetConstructedDataMakingCarCall); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetConstructedDataMakingCarCall); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetConstructedDataMakingCarCall) GetTypeName() string {
	return "BACnetConstructedDataMakingCarCall"
}

func (m *_BACnetConstructedDataMakingCarCall) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetConstructedDataContract.(*_BACnetConstructedData).getLengthInBits(ctx))

	// A virtual field doesn't have any in- or output.

	// Optional Field (numberOfDataElements)
	if m.NumberOfDataElements != nil {
		lengthInBits += m.NumberOfDataElements.GetLengthInBits(ctx)
	}

	// Array field
	if len(m.MakingCarCall) > 0 {
		for _, element := range m.MakingCarCall {
			lengthInBits += element.GetLengthInBits(ctx)
		}
	}

	return lengthInBits
}

func (m *_BACnetConstructedDataMakingCarCall) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetConstructedDataMakingCarCall) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetConstructedData, tagNumber uint8, objectTypeArgument BACnetObjectType, propertyIdentifierArgument BACnetPropertyIdentifier, arrayIndexArgument BACnetTagPayloadUnsignedInteger) (__bACnetConstructedDataMakingCarCall BACnetConstructedDataMakingCarCall, err error) {
	m.BACnetConstructedDataContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetConstructedDataMakingCarCall"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetConstructedDataMakingCarCall")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	zero, err := ReadVirtualField[uint64](ctx, "zero", (*uint64)(nil), uint64(0))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'zero' field"))
	}
	_ = zero

	var numberOfDataElements BACnetApplicationTagUnsignedInteger
	_numberOfDataElements, err := ReadOptionalField[BACnetApplicationTagUnsignedInteger](ctx, "numberOfDataElements", ReadComplex[BACnetApplicationTagUnsignedInteger](BACnetApplicationTagParseWithBufferProducer[BACnetApplicationTagUnsignedInteger](), readBuffer), bool(bool((arrayIndexArgument) != (nil))) && bool(bool((arrayIndexArgument.GetActualValue()) == (zero))))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'numberOfDataElements' field"))
	}
	if _numberOfDataElements != nil {
		numberOfDataElements = *_numberOfDataElements
		m.NumberOfDataElements = numberOfDataElements
	}

	makingCarCall, err := ReadTerminatedArrayField[BACnetApplicationTagUnsignedInteger](ctx, "makingCarCall", ReadComplex[BACnetApplicationTagUnsignedInteger](BACnetApplicationTagParseWithBufferProducer[BACnetApplicationTagUnsignedInteger](), readBuffer), IsBACnetConstructedDataClosingTag(ctx, readBuffer, false, tagNumber))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'makingCarCall' field"))
	}
	m.MakingCarCall = makingCarCall

	if closeErr := readBuffer.CloseContext("BACnetConstructedDataMakingCarCall"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetConstructedDataMakingCarCall")
	}

	return m, nil
}

func (m *_BACnetConstructedDataMakingCarCall) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetConstructedDataMakingCarCall) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetConstructedDataMakingCarCall"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetConstructedDataMakingCarCall")
		}
		// Virtual field
		zero := m.GetZero()
		_ = zero
		if _zeroErr := writeBuffer.WriteVirtual(ctx, "zero", m.GetZero()); _zeroErr != nil {
			return errors.Wrap(_zeroErr, "Error serializing 'zero' field")
		}

		if err := WriteOptionalField[BACnetApplicationTagUnsignedInteger](ctx, "numberOfDataElements", GetRef(m.GetNumberOfDataElements()), WriteComplex[BACnetApplicationTagUnsignedInteger](writeBuffer), true); err != nil {
			return errors.Wrap(err, "Error serializing 'numberOfDataElements' field")
		}

		if err := WriteComplexTypeArrayField(ctx, "makingCarCall", m.GetMakingCarCall(), writeBuffer); err != nil {
			return errors.Wrap(err, "Error serializing 'makingCarCall' field")
		}

		if popErr := writeBuffer.PopContext("BACnetConstructedDataMakingCarCall"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetConstructedDataMakingCarCall")
		}
		return nil
	}
	return m.BACnetConstructedDataContract.(*_BACnetConstructedData).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetConstructedDataMakingCarCall) IsBACnetConstructedDataMakingCarCall() {}

func (m *_BACnetConstructedDataMakingCarCall) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetConstructedDataMakingCarCall) deepCopy() *_BACnetConstructedDataMakingCarCall {
	if m == nil {
		return nil
	}
	_BACnetConstructedDataMakingCarCallCopy := &_BACnetConstructedDataMakingCarCall{
		m.BACnetConstructedDataContract.(*_BACnetConstructedData).deepCopy(),
		utils.DeepCopy[BACnetApplicationTagUnsignedInteger](m.NumberOfDataElements),
		utils.DeepCopySlice[BACnetApplicationTagUnsignedInteger, BACnetApplicationTagUnsignedInteger](m.MakingCarCall),
	}
	_BACnetConstructedDataMakingCarCallCopy.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = m
	return _BACnetConstructedDataMakingCarCallCopy
}

func (m *_BACnetConstructedDataMakingCarCall) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
