/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetConstructedDataLoggingRecord is the corresponding interface of BACnetConstructedDataLoggingRecord
type BACnetConstructedDataLoggingRecord interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetConstructedData
	// GetLoggingRecord returns LoggingRecord (property field)
	GetLoggingRecord() BACnetAccumulatorRecord
	// GetActualValue returns ActualValue (virtual field)
	GetActualValue() BACnetAccumulatorRecord
	// IsBACnetConstructedDataLoggingRecord is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetConstructedDataLoggingRecord()
	// CreateBuilder creates a BACnetConstructedDataLoggingRecordBuilder
	CreateBACnetConstructedDataLoggingRecordBuilder() BACnetConstructedDataLoggingRecordBuilder
}

// _BACnetConstructedDataLoggingRecord is the data-structure of this message
type _BACnetConstructedDataLoggingRecord struct {
	BACnetConstructedDataContract
	LoggingRecord BACnetAccumulatorRecord
}

var _ BACnetConstructedDataLoggingRecord = (*_BACnetConstructedDataLoggingRecord)(nil)
var _ BACnetConstructedDataRequirements = (*_BACnetConstructedDataLoggingRecord)(nil)

// NewBACnetConstructedDataLoggingRecord factory function for _BACnetConstructedDataLoggingRecord
func NewBACnetConstructedDataLoggingRecord(openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag, loggingRecord BACnetAccumulatorRecord, tagNumber uint8, arrayIndexArgument BACnetTagPayloadUnsignedInteger) *_BACnetConstructedDataLoggingRecord {
	if loggingRecord == nil {
		panic("loggingRecord of type BACnetAccumulatorRecord for BACnetConstructedDataLoggingRecord must not be nil")
	}
	_result := &_BACnetConstructedDataLoggingRecord{
		BACnetConstructedDataContract: NewBACnetConstructedData(openingTag, peekedTagHeader, closingTag, tagNumber, arrayIndexArgument),
		LoggingRecord:                 loggingRecord,
	}
	_result.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetConstructedDataLoggingRecordBuilder is a builder for BACnetConstructedDataLoggingRecord
type BACnetConstructedDataLoggingRecordBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(loggingRecord BACnetAccumulatorRecord) BACnetConstructedDataLoggingRecordBuilder
	// WithLoggingRecord adds LoggingRecord (property field)
	WithLoggingRecord(BACnetAccumulatorRecord) BACnetConstructedDataLoggingRecordBuilder
	// WithLoggingRecordBuilder adds LoggingRecord (property field) which is build by the builder
	WithLoggingRecordBuilder(func(BACnetAccumulatorRecordBuilder) BACnetAccumulatorRecordBuilder) BACnetConstructedDataLoggingRecordBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetConstructedDataBuilder
	// Build builds the BACnetConstructedDataLoggingRecord or returns an error if something is wrong
	Build() (BACnetConstructedDataLoggingRecord, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetConstructedDataLoggingRecord
}

// NewBACnetConstructedDataLoggingRecordBuilder() creates a BACnetConstructedDataLoggingRecordBuilder
func NewBACnetConstructedDataLoggingRecordBuilder() BACnetConstructedDataLoggingRecordBuilder {
	return &_BACnetConstructedDataLoggingRecordBuilder{_BACnetConstructedDataLoggingRecord: new(_BACnetConstructedDataLoggingRecord)}
}

type _BACnetConstructedDataLoggingRecordBuilder struct {
	*_BACnetConstructedDataLoggingRecord

	parentBuilder *_BACnetConstructedDataBuilder

	err *utils.MultiError
}

var _ (BACnetConstructedDataLoggingRecordBuilder) = (*_BACnetConstructedDataLoggingRecordBuilder)(nil)

func (b *_BACnetConstructedDataLoggingRecordBuilder) setParent(contract BACnetConstructedDataContract) {
	b.BACnetConstructedDataContract = contract
	contract.(*_BACnetConstructedData)._SubType = b._BACnetConstructedDataLoggingRecord
}

func (b *_BACnetConstructedDataLoggingRecordBuilder) WithMandatoryFields(loggingRecord BACnetAccumulatorRecord) BACnetConstructedDataLoggingRecordBuilder {
	return b.WithLoggingRecord(loggingRecord)
}

func (b *_BACnetConstructedDataLoggingRecordBuilder) WithLoggingRecord(loggingRecord BACnetAccumulatorRecord) BACnetConstructedDataLoggingRecordBuilder {
	b.LoggingRecord = loggingRecord
	return b
}

func (b *_BACnetConstructedDataLoggingRecordBuilder) WithLoggingRecordBuilder(builderSupplier func(BACnetAccumulatorRecordBuilder) BACnetAccumulatorRecordBuilder) BACnetConstructedDataLoggingRecordBuilder {
	builder := builderSupplier(b.LoggingRecord.CreateBACnetAccumulatorRecordBuilder())
	var err error
	b.LoggingRecord, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "BACnetAccumulatorRecordBuilder failed"))
	}
	return b
}

func (b *_BACnetConstructedDataLoggingRecordBuilder) Build() (BACnetConstructedDataLoggingRecord, error) {
	if b.LoggingRecord == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'loggingRecord' not set"))
	}
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._BACnetConstructedDataLoggingRecord.deepCopy(), nil
}

func (b *_BACnetConstructedDataLoggingRecordBuilder) MustBuild() BACnetConstructedDataLoggingRecord {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetConstructedDataLoggingRecordBuilder) Done() BACnetConstructedDataBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetConstructedDataBuilder().(*_BACnetConstructedDataBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetConstructedDataLoggingRecordBuilder) buildForBACnetConstructedData() (BACnetConstructedData, error) {
	return b.Build()
}

func (b *_BACnetConstructedDataLoggingRecordBuilder) DeepCopy() any {
	_copy := b.CreateBACnetConstructedDataLoggingRecordBuilder().(*_BACnetConstructedDataLoggingRecordBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateBACnetConstructedDataLoggingRecordBuilder creates a BACnetConstructedDataLoggingRecordBuilder
func (b *_BACnetConstructedDataLoggingRecord) CreateBACnetConstructedDataLoggingRecordBuilder() BACnetConstructedDataLoggingRecordBuilder {
	if b == nil {
		return NewBACnetConstructedDataLoggingRecordBuilder()
	}
	return &_BACnetConstructedDataLoggingRecordBuilder{_BACnetConstructedDataLoggingRecord: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_BACnetConstructedDataLoggingRecord) GetObjectTypeArgument() BACnetObjectType {
	return 0
}

func (m *_BACnetConstructedDataLoggingRecord) GetPropertyIdentifierArgument() BACnetPropertyIdentifier {
	return BACnetPropertyIdentifier_LOGGING_RECORD
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetConstructedDataLoggingRecord) GetParent() BACnetConstructedDataContract {
	return m.BACnetConstructedDataContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetConstructedDataLoggingRecord) GetLoggingRecord() BACnetAccumulatorRecord {
	return m.LoggingRecord
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for virtual fields.
///////////////////////

func (m *_BACnetConstructedDataLoggingRecord) GetActualValue() BACnetAccumulatorRecord {
	ctx := context.Background()
	_ = ctx
	return CastBACnetAccumulatorRecord(m.GetLoggingRecord())
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetConstructedDataLoggingRecord(structType any) BACnetConstructedDataLoggingRecord {
	if casted, ok := structType.(BACnetConstructedDataLoggingRecord); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetConstructedDataLoggingRecord); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetConstructedDataLoggingRecord) GetTypeName() string {
	return "BACnetConstructedDataLoggingRecord"
}

func (m *_BACnetConstructedDataLoggingRecord) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetConstructedDataContract.(*_BACnetConstructedData).getLengthInBits(ctx))

	// Simple field (loggingRecord)
	lengthInBits += m.LoggingRecord.GetLengthInBits(ctx)

	// A virtual field doesn't have any in- or output.

	return lengthInBits
}

func (m *_BACnetConstructedDataLoggingRecord) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetConstructedDataLoggingRecord) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetConstructedData, tagNumber uint8, objectTypeArgument BACnetObjectType, propertyIdentifierArgument BACnetPropertyIdentifier, arrayIndexArgument BACnetTagPayloadUnsignedInteger) (__bACnetConstructedDataLoggingRecord BACnetConstructedDataLoggingRecord, err error) {
	m.BACnetConstructedDataContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetConstructedDataLoggingRecord"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetConstructedDataLoggingRecord")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	loggingRecord, err := ReadSimpleField[BACnetAccumulatorRecord](ctx, "loggingRecord", ReadComplex[BACnetAccumulatorRecord](BACnetAccumulatorRecordParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'loggingRecord' field"))
	}
	m.LoggingRecord = loggingRecord

	actualValue, err := ReadVirtualField[BACnetAccumulatorRecord](ctx, "actualValue", (*BACnetAccumulatorRecord)(nil), loggingRecord)
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'actualValue' field"))
	}
	_ = actualValue

	if closeErr := readBuffer.CloseContext("BACnetConstructedDataLoggingRecord"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetConstructedDataLoggingRecord")
	}

	return m, nil
}

func (m *_BACnetConstructedDataLoggingRecord) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetConstructedDataLoggingRecord) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetConstructedDataLoggingRecord"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetConstructedDataLoggingRecord")
		}

		if err := WriteSimpleField[BACnetAccumulatorRecord](ctx, "loggingRecord", m.GetLoggingRecord(), WriteComplex[BACnetAccumulatorRecord](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'loggingRecord' field")
		}
		// Virtual field
		actualValue := m.GetActualValue()
		_ = actualValue
		if _actualValueErr := writeBuffer.WriteVirtual(ctx, "actualValue", m.GetActualValue()); _actualValueErr != nil {
			return errors.Wrap(_actualValueErr, "Error serializing 'actualValue' field")
		}

		if popErr := writeBuffer.PopContext("BACnetConstructedDataLoggingRecord"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetConstructedDataLoggingRecord")
		}
		return nil
	}
	return m.BACnetConstructedDataContract.(*_BACnetConstructedData).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetConstructedDataLoggingRecord) IsBACnetConstructedDataLoggingRecord() {}

func (m *_BACnetConstructedDataLoggingRecord) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetConstructedDataLoggingRecord) deepCopy() *_BACnetConstructedDataLoggingRecord {
	if m == nil {
		return nil
	}
	_BACnetConstructedDataLoggingRecordCopy := &_BACnetConstructedDataLoggingRecord{
		m.BACnetConstructedDataContract.(*_BACnetConstructedData).deepCopy(),
		utils.DeepCopy[BACnetAccumulatorRecord](m.LoggingRecord),
	}
	_BACnetConstructedDataLoggingRecordCopy.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = m
	return _BACnetConstructedDataLoggingRecordCopy
}

func (m *_BACnetConstructedDataLoggingRecord) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
