/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetConstructedDataLastNotifyRecord is the corresponding interface of BACnetConstructedDataLastNotifyRecord
type BACnetConstructedDataLastNotifyRecord interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetConstructedData
	// GetLastNotifyRecord returns LastNotifyRecord (property field)
	GetLastNotifyRecord() BACnetApplicationTagUnsignedInteger
	// GetActualValue returns ActualValue (virtual field)
	GetActualValue() BACnetApplicationTagUnsignedInteger
	// IsBACnetConstructedDataLastNotifyRecord is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetConstructedDataLastNotifyRecord()
	// CreateBuilder creates a BACnetConstructedDataLastNotifyRecordBuilder
	CreateBACnetConstructedDataLastNotifyRecordBuilder() BACnetConstructedDataLastNotifyRecordBuilder
}

// _BACnetConstructedDataLastNotifyRecord is the data-structure of this message
type _BACnetConstructedDataLastNotifyRecord struct {
	BACnetConstructedDataContract
	LastNotifyRecord BACnetApplicationTagUnsignedInteger
}

var _ BACnetConstructedDataLastNotifyRecord = (*_BACnetConstructedDataLastNotifyRecord)(nil)
var _ BACnetConstructedDataRequirements = (*_BACnetConstructedDataLastNotifyRecord)(nil)

// NewBACnetConstructedDataLastNotifyRecord factory function for _BACnetConstructedDataLastNotifyRecord
func NewBACnetConstructedDataLastNotifyRecord(openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag, lastNotifyRecord BACnetApplicationTagUnsignedInteger, tagNumber uint8, arrayIndexArgument BACnetTagPayloadUnsignedInteger) *_BACnetConstructedDataLastNotifyRecord {
	if lastNotifyRecord == nil {
		panic("lastNotifyRecord of type BACnetApplicationTagUnsignedInteger for BACnetConstructedDataLastNotifyRecord must not be nil")
	}
	_result := &_BACnetConstructedDataLastNotifyRecord{
		BACnetConstructedDataContract: NewBACnetConstructedData(openingTag, peekedTagHeader, closingTag, tagNumber, arrayIndexArgument),
		LastNotifyRecord:              lastNotifyRecord,
	}
	_result.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetConstructedDataLastNotifyRecordBuilder is a builder for BACnetConstructedDataLastNotifyRecord
type BACnetConstructedDataLastNotifyRecordBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(lastNotifyRecord BACnetApplicationTagUnsignedInteger) BACnetConstructedDataLastNotifyRecordBuilder
	// WithLastNotifyRecord adds LastNotifyRecord (property field)
	WithLastNotifyRecord(BACnetApplicationTagUnsignedInteger) BACnetConstructedDataLastNotifyRecordBuilder
	// WithLastNotifyRecordBuilder adds LastNotifyRecord (property field) which is build by the builder
	WithLastNotifyRecordBuilder(func(BACnetApplicationTagUnsignedIntegerBuilder) BACnetApplicationTagUnsignedIntegerBuilder) BACnetConstructedDataLastNotifyRecordBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetConstructedDataBuilder
	// Build builds the BACnetConstructedDataLastNotifyRecord or returns an error if something is wrong
	Build() (BACnetConstructedDataLastNotifyRecord, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetConstructedDataLastNotifyRecord
}

// NewBACnetConstructedDataLastNotifyRecordBuilder() creates a BACnetConstructedDataLastNotifyRecordBuilder
func NewBACnetConstructedDataLastNotifyRecordBuilder() BACnetConstructedDataLastNotifyRecordBuilder {
	return &_BACnetConstructedDataLastNotifyRecordBuilder{_BACnetConstructedDataLastNotifyRecord: new(_BACnetConstructedDataLastNotifyRecord)}
}

type _BACnetConstructedDataLastNotifyRecordBuilder struct {
	*_BACnetConstructedDataLastNotifyRecord

	parentBuilder *_BACnetConstructedDataBuilder

	err *utils.MultiError
}

var _ (BACnetConstructedDataLastNotifyRecordBuilder) = (*_BACnetConstructedDataLastNotifyRecordBuilder)(nil)

func (b *_BACnetConstructedDataLastNotifyRecordBuilder) setParent(contract BACnetConstructedDataContract) {
	b.BACnetConstructedDataContract = contract
	contract.(*_BACnetConstructedData)._SubType = b._BACnetConstructedDataLastNotifyRecord
}

func (b *_BACnetConstructedDataLastNotifyRecordBuilder) WithMandatoryFields(lastNotifyRecord BACnetApplicationTagUnsignedInteger) BACnetConstructedDataLastNotifyRecordBuilder {
	return b.WithLastNotifyRecord(lastNotifyRecord)
}

func (b *_BACnetConstructedDataLastNotifyRecordBuilder) WithLastNotifyRecord(lastNotifyRecord BACnetApplicationTagUnsignedInteger) BACnetConstructedDataLastNotifyRecordBuilder {
	b.LastNotifyRecord = lastNotifyRecord
	return b
}

func (b *_BACnetConstructedDataLastNotifyRecordBuilder) WithLastNotifyRecordBuilder(builderSupplier func(BACnetApplicationTagUnsignedIntegerBuilder) BACnetApplicationTagUnsignedIntegerBuilder) BACnetConstructedDataLastNotifyRecordBuilder {
	builder := builderSupplier(b.LastNotifyRecord.CreateBACnetApplicationTagUnsignedIntegerBuilder())
	var err error
	b.LastNotifyRecord, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "BACnetApplicationTagUnsignedIntegerBuilder failed"))
	}
	return b
}

func (b *_BACnetConstructedDataLastNotifyRecordBuilder) Build() (BACnetConstructedDataLastNotifyRecord, error) {
	if b.LastNotifyRecord == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'lastNotifyRecord' not set"))
	}
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._BACnetConstructedDataLastNotifyRecord.deepCopy(), nil
}

func (b *_BACnetConstructedDataLastNotifyRecordBuilder) MustBuild() BACnetConstructedDataLastNotifyRecord {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetConstructedDataLastNotifyRecordBuilder) Done() BACnetConstructedDataBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetConstructedDataBuilder().(*_BACnetConstructedDataBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetConstructedDataLastNotifyRecordBuilder) buildForBACnetConstructedData() (BACnetConstructedData, error) {
	return b.Build()
}

func (b *_BACnetConstructedDataLastNotifyRecordBuilder) DeepCopy() any {
	_copy := b.CreateBACnetConstructedDataLastNotifyRecordBuilder().(*_BACnetConstructedDataLastNotifyRecordBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateBACnetConstructedDataLastNotifyRecordBuilder creates a BACnetConstructedDataLastNotifyRecordBuilder
func (b *_BACnetConstructedDataLastNotifyRecord) CreateBACnetConstructedDataLastNotifyRecordBuilder() BACnetConstructedDataLastNotifyRecordBuilder {
	if b == nil {
		return NewBACnetConstructedDataLastNotifyRecordBuilder()
	}
	return &_BACnetConstructedDataLastNotifyRecordBuilder{_BACnetConstructedDataLastNotifyRecord: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_BACnetConstructedDataLastNotifyRecord) GetObjectTypeArgument() BACnetObjectType {
	return 0
}

func (m *_BACnetConstructedDataLastNotifyRecord) GetPropertyIdentifierArgument() BACnetPropertyIdentifier {
	return BACnetPropertyIdentifier_LAST_NOTIFY_RECORD
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetConstructedDataLastNotifyRecord) GetParent() BACnetConstructedDataContract {
	return m.BACnetConstructedDataContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetConstructedDataLastNotifyRecord) GetLastNotifyRecord() BACnetApplicationTagUnsignedInteger {
	return m.LastNotifyRecord
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for virtual fields.
///////////////////////

func (m *_BACnetConstructedDataLastNotifyRecord) GetActualValue() BACnetApplicationTagUnsignedInteger {
	ctx := context.Background()
	_ = ctx
	return CastBACnetApplicationTagUnsignedInteger(m.GetLastNotifyRecord())
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetConstructedDataLastNotifyRecord(structType any) BACnetConstructedDataLastNotifyRecord {
	if casted, ok := structType.(BACnetConstructedDataLastNotifyRecord); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetConstructedDataLastNotifyRecord); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetConstructedDataLastNotifyRecord) GetTypeName() string {
	return "BACnetConstructedDataLastNotifyRecord"
}

func (m *_BACnetConstructedDataLastNotifyRecord) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetConstructedDataContract.(*_BACnetConstructedData).getLengthInBits(ctx))

	// Simple field (lastNotifyRecord)
	lengthInBits += m.LastNotifyRecord.GetLengthInBits(ctx)

	// A virtual field doesn't have any in- or output.

	return lengthInBits
}

func (m *_BACnetConstructedDataLastNotifyRecord) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetConstructedDataLastNotifyRecord) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetConstructedData, tagNumber uint8, objectTypeArgument BACnetObjectType, propertyIdentifierArgument BACnetPropertyIdentifier, arrayIndexArgument BACnetTagPayloadUnsignedInteger) (__bACnetConstructedDataLastNotifyRecord BACnetConstructedDataLastNotifyRecord, err error) {
	m.BACnetConstructedDataContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetConstructedDataLastNotifyRecord"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetConstructedDataLastNotifyRecord")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	lastNotifyRecord, err := ReadSimpleField[BACnetApplicationTagUnsignedInteger](ctx, "lastNotifyRecord", ReadComplex[BACnetApplicationTagUnsignedInteger](BACnetApplicationTagParseWithBufferProducer[BACnetApplicationTagUnsignedInteger](), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'lastNotifyRecord' field"))
	}
	m.LastNotifyRecord = lastNotifyRecord

	actualValue, err := ReadVirtualField[BACnetApplicationTagUnsignedInteger](ctx, "actualValue", (*BACnetApplicationTagUnsignedInteger)(nil), lastNotifyRecord)
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'actualValue' field"))
	}
	_ = actualValue

	if closeErr := readBuffer.CloseContext("BACnetConstructedDataLastNotifyRecord"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetConstructedDataLastNotifyRecord")
	}

	return m, nil
}

func (m *_BACnetConstructedDataLastNotifyRecord) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetConstructedDataLastNotifyRecord) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetConstructedDataLastNotifyRecord"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetConstructedDataLastNotifyRecord")
		}

		if err := WriteSimpleField[BACnetApplicationTagUnsignedInteger](ctx, "lastNotifyRecord", m.GetLastNotifyRecord(), WriteComplex[BACnetApplicationTagUnsignedInteger](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'lastNotifyRecord' field")
		}
		// Virtual field
		actualValue := m.GetActualValue()
		_ = actualValue
		if _actualValueErr := writeBuffer.WriteVirtual(ctx, "actualValue", m.GetActualValue()); _actualValueErr != nil {
			return errors.Wrap(_actualValueErr, "Error serializing 'actualValue' field")
		}

		if popErr := writeBuffer.PopContext("BACnetConstructedDataLastNotifyRecord"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetConstructedDataLastNotifyRecord")
		}
		return nil
	}
	return m.BACnetConstructedDataContract.(*_BACnetConstructedData).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetConstructedDataLastNotifyRecord) IsBACnetConstructedDataLastNotifyRecord() {}

func (m *_BACnetConstructedDataLastNotifyRecord) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetConstructedDataLastNotifyRecord) deepCopy() *_BACnetConstructedDataLastNotifyRecord {
	if m == nil {
		return nil
	}
	_BACnetConstructedDataLastNotifyRecordCopy := &_BACnetConstructedDataLastNotifyRecord{
		m.BACnetConstructedDataContract.(*_BACnetConstructedData).deepCopy(),
		utils.DeepCopy[BACnetApplicationTagUnsignedInteger](m.LastNotifyRecord),
	}
	_BACnetConstructedDataLastNotifyRecordCopy.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = m
	return _BACnetConstructedDataLastNotifyRecordCopy
}

func (m *_BACnetConstructedDataLastNotifyRecord) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
