/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetConstructedDataKeySets is the corresponding interface of BACnetConstructedDataKeySets
type BACnetConstructedDataKeySets interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetConstructedData
	// GetNumberOfDataElements returns NumberOfDataElements (property field)
	GetNumberOfDataElements() BACnetApplicationTagUnsignedInteger
	// GetKeySets returns KeySets (property field)
	GetKeySets() []BACnetSecurityKeySet
	// GetZero returns Zero (virtual field)
	GetZero() uint64
	// IsBACnetConstructedDataKeySets is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetConstructedDataKeySets()
	// CreateBuilder creates a BACnetConstructedDataKeySetsBuilder
	CreateBACnetConstructedDataKeySetsBuilder() BACnetConstructedDataKeySetsBuilder
}

// _BACnetConstructedDataKeySets is the data-structure of this message
type _BACnetConstructedDataKeySets struct {
	BACnetConstructedDataContract
	NumberOfDataElements BACnetApplicationTagUnsignedInteger
	KeySets              []BACnetSecurityKeySet
}

var _ BACnetConstructedDataKeySets = (*_BACnetConstructedDataKeySets)(nil)
var _ BACnetConstructedDataRequirements = (*_BACnetConstructedDataKeySets)(nil)

// NewBACnetConstructedDataKeySets factory function for _BACnetConstructedDataKeySets
func NewBACnetConstructedDataKeySets(openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag, numberOfDataElements BACnetApplicationTagUnsignedInteger, keySets []BACnetSecurityKeySet, tagNumber uint8, arrayIndexArgument BACnetTagPayloadUnsignedInteger) *_BACnetConstructedDataKeySets {
	_result := &_BACnetConstructedDataKeySets{
		BACnetConstructedDataContract: NewBACnetConstructedData(openingTag, peekedTagHeader, closingTag, tagNumber, arrayIndexArgument),
		NumberOfDataElements:          numberOfDataElements,
		KeySets:                       keySets,
	}
	_result.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetConstructedDataKeySetsBuilder is a builder for BACnetConstructedDataKeySets
type BACnetConstructedDataKeySetsBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(keySets []BACnetSecurityKeySet) BACnetConstructedDataKeySetsBuilder
	// WithNumberOfDataElements adds NumberOfDataElements (property field)
	WithOptionalNumberOfDataElements(BACnetApplicationTagUnsignedInteger) BACnetConstructedDataKeySetsBuilder
	// WithOptionalNumberOfDataElementsBuilder adds NumberOfDataElements (property field) which is build by the builder
	WithOptionalNumberOfDataElementsBuilder(func(BACnetApplicationTagUnsignedIntegerBuilder) BACnetApplicationTagUnsignedIntegerBuilder) BACnetConstructedDataKeySetsBuilder
	// WithKeySets adds KeySets (property field)
	WithKeySets(...BACnetSecurityKeySet) BACnetConstructedDataKeySetsBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetConstructedDataBuilder
	// Build builds the BACnetConstructedDataKeySets or returns an error if something is wrong
	Build() (BACnetConstructedDataKeySets, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetConstructedDataKeySets
}

// NewBACnetConstructedDataKeySetsBuilder() creates a BACnetConstructedDataKeySetsBuilder
func NewBACnetConstructedDataKeySetsBuilder() BACnetConstructedDataKeySetsBuilder {
	return &_BACnetConstructedDataKeySetsBuilder{_BACnetConstructedDataKeySets: new(_BACnetConstructedDataKeySets)}
}

type _BACnetConstructedDataKeySetsBuilder struct {
	*_BACnetConstructedDataKeySets

	parentBuilder *_BACnetConstructedDataBuilder

	err *utils.MultiError
}

var _ (BACnetConstructedDataKeySetsBuilder) = (*_BACnetConstructedDataKeySetsBuilder)(nil)

func (b *_BACnetConstructedDataKeySetsBuilder) setParent(contract BACnetConstructedDataContract) {
	b.BACnetConstructedDataContract = contract
	contract.(*_BACnetConstructedData)._SubType = b._BACnetConstructedDataKeySets
}

func (b *_BACnetConstructedDataKeySetsBuilder) WithMandatoryFields(keySets []BACnetSecurityKeySet) BACnetConstructedDataKeySetsBuilder {
	return b.WithKeySets(keySets...)
}

func (b *_BACnetConstructedDataKeySetsBuilder) WithOptionalNumberOfDataElements(numberOfDataElements BACnetApplicationTagUnsignedInteger) BACnetConstructedDataKeySetsBuilder {
	b.NumberOfDataElements = numberOfDataElements
	return b
}

func (b *_BACnetConstructedDataKeySetsBuilder) WithOptionalNumberOfDataElementsBuilder(builderSupplier func(BACnetApplicationTagUnsignedIntegerBuilder) BACnetApplicationTagUnsignedIntegerBuilder) BACnetConstructedDataKeySetsBuilder {
	builder := builderSupplier(b.NumberOfDataElements.CreateBACnetApplicationTagUnsignedIntegerBuilder())
	var err error
	b.NumberOfDataElements, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "BACnetApplicationTagUnsignedIntegerBuilder failed"))
	}
	return b
}

func (b *_BACnetConstructedDataKeySetsBuilder) WithKeySets(keySets ...BACnetSecurityKeySet) BACnetConstructedDataKeySetsBuilder {
	b.KeySets = keySets
	return b
}

func (b *_BACnetConstructedDataKeySetsBuilder) Build() (BACnetConstructedDataKeySets, error) {
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._BACnetConstructedDataKeySets.deepCopy(), nil
}

func (b *_BACnetConstructedDataKeySetsBuilder) MustBuild() BACnetConstructedDataKeySets {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetConstructedDataKeySetsBuilder) Done() BACnetConstructedDataBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetConstructedDataBuilder().(*_BACnetConstructedDataBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetConstructedDataKeySetsBuilder) buildForBACnetConstructedData() (BACnetConstructedData, error) {
	return b.Build()
}

func (b *_BACnetConstructedDataKeySetsBuilder) DeepCopy() any {
	_copy := b.CreateBACnetConstructedDataKeySetsBuilder().(*_BACnetConstructedDataKeySetsBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateBACnetConstructedDataKeySetsBuilder creates a BACnetConstructedDataKeySetsBuilder
func (b *_BACnetConstructedDataKeySets) CreateBACnetConstructedDataKeySetsBuilder() BACnetConstructedDataKeySetsBuilder {
	if b == nil {
		return NewBACnetConstructedDataKeySetsBuilder()
	}
	return &_BACnetConstructedDataKeySetsBuilder{_BACnetConstructedDataKeySets: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_BACnetConstructedDataKeySets) GetObjectTypeArgument() BACnetObjectType {
	return 0
}

func (m *_BACnetConstructedDataKeySets) GetPropertyIdentifierArgument() BACnetPropertyIdentifier {
	return BACnetPropertyIdentifier_KEY_SETS
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetConstructedDataKeySets) GetParent() BACnetConstructedDataContract {
	return m.BACnetConstructedDataContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetConstructedDataKeySets) GetNumberOfDataElements() BACnetApplicationTagUnsignedInteger {
	return m.NumberOfDataElements
}

func (m *_BACnetConstructedDataKeySets) GetKeySets() []BACnetSecurityKeySet {
	return m.KeySets
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for virtual fields.
///////////////////////

func (m *_BACnetConstructedDataKeySets) GetZero() uint64 {
	ctx := context.Background()
	_ = ctx
	numberOfDataElements := m.GetNumberOfDataElements()
	_ = numberOfDataElements
	return uint64(uint64(0))
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetConstructedDataKeySets(structType any) BACnetConstructedDataKeySets {
	if casted, ok := structType.(BACnetConstructedDataKeySets); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetConstructedDataKeySets); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetConstructedDataKeySets) GetTypeName() string {
	return "BACnetConstructedDataKeySets"
}

func (m *_BACnetConstructedDataKeySets) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetConstructedDataContract.(*_BACnetConstructedData).getLengthInBits(ctx))

	// A virtual field doesn't have any in- or output.

	// Optional Field (numberOfDataElements)
	if m.NumberOfDataElements != nil {
		lengthInBits += m.NumberOfDataElements.GetLengthInBits(ctx)
	}

	// Array field
	if len(m.KeySets) > 0 {
		for _, element := range m.KeySets {
			lengthInBits += element.GetLengthInBits(ctx)
		}
	}

	return lengthInBits
}

func (m *_BACnetConstructedDataKeySets) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetConstructedDataKeySets) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetConstructedData, tagNumber uint8, objectTypeArgument BACnetObjectType, propertyIdentifierArgument BACnetPropertyIdentifier, arrayIndexArgument BACnetTagPayloadUnsignedInteger) (__bACnetConstructedDataKeySets BACnetConstructedDataKeySets, err error) {
	m.BACnetConstructedDataContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetConstructedDataKeySets"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetConstructedDataKeySets")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	zero, err := ReadVirtualField[uint64](ctx, "zero", (*uint64)(nil), uint64(0))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'zero' field"))
	}
	_ = zero

	var numberOfDataElements BACnetApplicationTagUnsignedInteger
	_numberOfDataElements, err := ReadOptionalField[BACnetApplicationTagUnsignedInteger](ctx, "numberOfDataElements", ReadComplex[BACnetApplicationTagUnsignedInteger](BACnetApplicationTagParseWithBufferProducer[BACnetApplicationTagUnsignedInteger](), readBuffer), bool(bool((arrayIndexArgument) != (nil))) && bool(bool((arrayIndexArgument.GetActualValue()) == (zero))))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'numberOfDataElements' field"))
	}
	if _numberOfDataElements != nil {
		numberOfDataElements = *_numberOfDataElements
		m.NumberOfDataElements = numberOfDataElements
	}

	keySets, err := ReadTerminatedArrayField[BACnetSecurityKeySet](ctx, "keySets", ReadComplex[BACnetSecurityKeySet](BACnetSecurityKeySetParseWithBuffer, readBuffer), IsBACnetConstructedDataClosingTag(ctx, readBuffer, false, tagNumber))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'keySets' field"))
	}
	m.KeySets = keySets

	// Validation
	if !(bool(bool((arrayIndexArgument) != (nil))) || bool(bool((len(keySets)) == (2)))) {
		return nil, errors.WithStack(utils.ParseValidationError{Message: "keySets should have exactly 2 values"})
	}

	if closeErr := readBuffer.CloseContext("BACnetConstructedDataKeySets"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetConstructedDataKeySets")
	}

	return m, nil
}

func (m *_BACnetConstructedDataKeySets) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetConstructedDataKeySets) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetConstructedDataKeySets"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetConstructedDataKeySets")
		}
		// Virtual field
		zero := m.GetZero()
		_ = zero
		if _zeroErr := writeBuffer.WriteVirtual(ctx, "zero", m.GetZero()); _zeroErr != nil {
			return errors.Wrap(_zeroErr, "Error serializing 'zero' field")
		}

		if err := WriteOptionalField[BACnetApplicationTagUnsignedInteger](ctx, "numberOfDataElements", GetRef(m.GetNumberOfDataElements()), WriteComplex[BACnetApplicationTagUnsignedInteger](writeBuffer), true); err != nil {
			return errors.Wrap(err, "Error serializing 'numberOfDataElements' field")
		}

		if err := WriteComplexTypeArrayField(ctx, "keySets", m.GetKeySets(), writeBuffer); err != nil {
			return errors.Wrap(err, "Error serializing 'keySets' field")
		}

		if popErr := writeBuffer.PopContext("BACnetConstructedDataKeySets"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetConstructedDataKeySets")
		}
		return nil
	}
	return m.BACnetConstructedDataContract.(*_BACnetConstructedData).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetConstructedDataKeySets) IsBACnetConstructedDataKeySets() {}

func (m *_BACnetConstructedDataKeySets) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetConstructedDataKeySets) deepCopy() *_BACnetConstructedDataKeySets {
	if m == nil {
		return nil
	}
	_BACnetConstructedDataKeySetsCopy := &_BACnetConstructedDataKeySets{
		m.BACnetConstructedDataContract.(*_BACnetConstructedData).deepCopy(),
		utils.DeepCopy[BACnetApplicationTagUnsignedInteger](m.NumberOfDataElements),
		utils.DeepCopySlice[BACnetSecurityKeySet, BACnetSecurityKeySet](m.KeySets),
	}
	_BACnetConstructedDataKeySetsCopy.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = m
	return _BACnetConstructedDataKeySetsCopy
}

func (m *_BACnetConstructedDataKeySets) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
