/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetConstructedDataInstallationID is the corresponding interface of BACnetConstructedDataInstallationID
type BACnetConstructedDataInstallationID interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetConstructedData
	// GetInstallationId returns InstallationId (property field)
	GetInstallationId() BACnetApplicationTagUnsignedInteger
	// GetActualValue returns ActualValue (virtual field)
	GetActualValue() BACnetApplicationTagUnsignedInteger
	// IsBACnetConstructedDataInstallationID is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetConstructedDataInstallationID()
	// CreateBuilder creates a BACnetConstructedDataInstallationIDBuilder
	CreateBACnetConstructedDataInstallationIDBuilder() BACnetConstructedDataInstallationIDBuilder
}

// _BACnetConstructedDataInstallationID is the data-structure of this message
type _BACnetConstructedDataInstallationID struct {
	BACnetConstructedDataContract
	InstallationId BACnetApplicationTagUnsignedInteger
}

var _ BACnetConstructedDataInstallationID = (*_BACnetConstructedDataInstallationID)(nil)
var _ BACnetConstructedDataRequirements = (*_BACnetConstructedDataInstallationID)(nil)

// NewBACnetConstructedDataInstallationID factory function for _BACnetConstructedDataInstallationID
func NewBACnetConstructedDataInstallationID(openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag, installationId BACnetApplicationTagUnsignedInteger, tagNumber uint8, arrayIndexArgument BACnetTagPayloadUnsignedInteger) *_BACnetConstructedDataInstallationID {
	if installationId == nil {
		panic("installationId of type BACnetApplicationTagUnsignedInteger for BACnetConstructedDataInstallationID must not be nil")
	}
	_result := &_BACnetConstructedDataInstallationID{
		BACnetConstructedDataContract: NewBACnetConstructedData(openingTag, peekedTagHeader, closingTag, tagNumber, arrayIndexArgument),
		InstallationId:                installationId,
	}
	_result.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetConstructedDataInstallationIDBuilder is a builder for BACnetConstructedDataInstallationID
type BACnetConstructedDataInstallationIDBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(installationId BACnetApplicationTagUnsignedInteger) BACnetConstructedDataInstallationIDBuilder
	// WithInstallationId adds InstallationId (property field)
	WithInstallationId(BACnetApplicationTagUnsignedInteger) BACnetConstructedDataInstallationIDBuilder
	// WithInstallationIdBuilder adds InstallationId (property field) which is build by the builder
	WithInstallationIdBuilder(func(BACnetApplicationTagUnsignedIntegerBuilder) BACnetApplicationTagUnsignedIntegerBuilder) BACnetConstructedDataInstallationIDBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetConstructedDataBuilder
	// Build builds the BACnetConstructedDataInstallationID or returns an error if something is wrong
	Build() (BACnetConstructedDataInstallationID, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetConstructedDataInstallationID
}

// NewBACnetConstructedDataInstallationIDBuilder() creates a BACnetConstructedDataInstallationIDBuilder
func NewBACnetConstructedDataInstallationIDBuilder() BACnetConstructedDataInstallationIDBuilder {
	return &_BACnetConstructedDataInstallationIDBuilder{_BACnetConstructedDataInstallationID: new(_BACnetConstructedDataInstallationID)}
}

type _BACnetConstructedDataInstallationIDBuilder struct {
	*_BACnetConstructedDataInstallationID

	parentBuilder *_BACnetConstructedDataBuilder

	err *utils.MultiError
}

var _ (BACnetConstructedDataInstallationIDBuilder) = (*_BACnetConstructedDataInstallationIDBuilder)(nil)

func (b *_BACnetConstructedDataInstallationIDBuilder) setParent(contract BACnetConstructedDataContract) {
	b.BACnetConstructedDataContract = contract
	contract.(*_BACnetConstructedData)._SubType = b._BACnetConstructedDataInstallationID
}

func (b *_BACnetConstructedDataInstallationIDBuilder) WithMandatoryFields(installationId BACnetApplicationTagUnsignedInteger) BACnetConstructedDataInstallationIDBuilder {
	return b.WithInstallationId(installationId)
}

func (b *_BACnetConstructedDataInstallationIDBuilder) WithInstallationId(installationId BACnetApplicationTagUnsignedInteger) BACnetConstructedDataInstallationIDBuilder {
	b.InstallationId = installationId
	return b
}

func (b *_BACnetConstructedDataInstallationIDBuilder) WithInstallationIdBuilder(builderSupplier func(BACnetApplicationTagUnsignedIntegerBuilder) BACnetApplicationTagUnsignedIntegerBuilder) BACnetConstructedDataInstallationIDBuilder {
	builder := builderSupplier(b.InstallationId.CreateBACnetApplicationTagUnsignedIntegerBuilder())
	var err error
	b.InstallationId, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "BACnetApplicationTagUnsignedIntegerBuilder failed"))
	}
	return b
}

func (b *_BACnetConstructedDataInstallationIDBuilder) Build() (BACnetConstructedDataInstallationID, error) {
	if b.InstallationId == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'installationId' not set"))
	}
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._BACnetConstructedDataInstallationID.deepCopy(), nil
}

func (b *_BACnetConstructedDataInstallationIDBuilder) MustBuild() BACnetConstructedDataInstallationID {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetConstructedDataInstallationIDBuilder) Done() BACnetConstructedDataBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetConstructedDataBuilder().(*_BACnetConstructedDataBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetConstructedDataInstallationIDBuilder) buildForBACnetConstructedData() (BACnetConstructedData, error) {
	return b.Build()
}

func (b *_BACnetConstructedDataInstallationIDBuilder) DeepCopy() any {
	_copy := b.CreateBACnetConstructedDataInstallationIDBuilder().(*_BACnetConstructedDataInstallationIDBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateBACnetConstructedDataInstallationIDBuilder creates a BACnetConstructedDataInstallationIDBuilder
func (b *_BACnetConstructedDataInstallationID) CreateBACnetConstructedDataInstallationIDBuilder() BACnetConstructedDataInstallationIDBuilder {
	if b == nil {
		return NewBACnetConstructedDataInstallationIDBuilder()
	}
	return &_BACnetConstructedDataInstallationIDBuilder{_BACnetConstructedDataInstallationID: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_BACnetConstructedDataInstallationID) GetObjectTypeArgument() BACnetObjectType {
	return 0
}

func (m *_BACnetConstructedDataInstallationID) GetPropertyIdentifierArgument() BACnetPropertyIdentifier {
	return BACnetPropertyIdentifier_INSTALLATION_ID
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetConstructedDataInstallationID) GetParent() BACnetConstructedDataContract {
	return m.BACnetConstructedDataContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetConstructedDataInstallationID) GetInstallationId() BACnetApplicationTagUnsignedInteger {
	return m.InstallationId
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for virtual fields.
///////////////////////

func (m *_BACnetConstructedDataInstallationID) GetActualValue() BACnetApplicationTagUnsignedInteger {
	ctx := context.Background()
	_ = ctx
	return CastBACnetApplicationTagUnsignedInteger(m.GetInstallationId())
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetConstructedDataInstallationID(structType any) BACnetConstructedDataInstallationID {
	if casted, ok := structType.(BACnetConstructedDataInstallationID); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetConstructedDataInstallationID); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetConstructedDataInstallationID) GetTypeName() string {
	return "BACnetConstructedDataInstallationID"
}

func (m *_BACnetConstructedDataInstallationID) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetConstructedDataContract.(*_BACnetConstructedData).getLengthInBits(ctx))

	// Simple field (installationId)
	lengthInBits += m.InstallationId.GetLengthInBits(ctx)

	// A virtual field doesn't have any in- or output.

	return lengthInBits
}

func (m *_BACnetConstructedDataInstallationID) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetConstructedDataInstallationID) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetConstructedData, tagNumber uint8, objectTypeArgument BACnetObjectType, propertyIdentifierArgument BACnetPropertyIdentifier, arrayIndexArgument BACnetTagPayloadUnsignedInteger) (__bACnetConstructedDataInstallationID BACnetConstructedDataInstallationID, err error) {
	m.BACnetConstructedDataContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetConstructedDataInstallationID"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetConstructedDataInstallationID")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	installationId, err := ReadSimpleField[BACnetApplicationTagUnsignedInteger](ctx, "installationId", ReadComplex[BACnetApplicationTagUnsignedInteger](BACnetApplicationTagParseWithBufferProducer[BACnetApplicationTagUnsignedInteger](), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'installationId' field"))
	}
	m.InstallationId = installationId

	actualValue, err := ReadVirtualField[BACnetApplicationTagUnsignedInteger](ctx, "actualValue", (*BACnetApplicationTagUnsignedInteger)(nil), installationId)
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'actualValue' field"))
	}
	_ = actualValue

	if closeErr := readBuffer.CloseContext("BACnetConstructedDataInstallationID"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetConstructedDataInstallationID")
	}

	return m, nil
}

func (m *_BACnetConstructedDataInstallationID) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetConstructedDataInstallationID) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetConstructedDataInstallationID"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetConstructedDataInstallationID")
		}

		if err := WriteSimpleField[BACnetApplicationTagUnsignedInteger](ctx, "installationId", m.GetInstallationId(), WriteComplex[BACnetApplicationTagUnsignedInteger](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'installationId' field")
		}
		// Virtual field
		actualValue := m.GetActualValue()
		_ = actualValue
		if _actualValueErr := writeBuffer.WriteVirtual(ctx, "actualValue", m.GetActualValue()); _actualValueErr != nil {
			return errors.Wrap(_actualValueErr, "Error serializing 'actualValue' field")
		}

		if popErr := writeBuffer.PopContext("BACnetConstructedDataInstallationID"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetConstructedDataInstallationID")
		}
		return nil
	}
	return m.BACnetConstructedDataContract.(*_BACnetConstructedData).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetConstructedDataInstallationID) IsBACnetConstructedDataInstallationID() {}

func (m *_BACnetConstructedDataInstallationID) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetConstructedDataInstallationID) deepCopy() *_BACnetConstructedDataInstallationID {
	if m == nil {
		return nil
	}
	_BACnetConstructedDataInstallationIDCopy := &_BACnetConstructedDataInstallationID{
		m.BACnetConstructedDataContract.(*_BACnetConstructedData).deepCopy(),
		utils.DeepCopy[BACnetApplicationTagUnsignedInteger](m.InstallationId),
	}
	_BACnetConstructedDataInstallationIDCopy.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = m
	return _BACnetConstructedDataInstallationIDCopy
}

func (m *_BACnetConstructedDataInstallationID) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
