/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetConstructedDataIPDefaultGateway is the corresponding interface of BACnetConstructedDataIPDefaultGateway
type BACnetConstructedDataIPDefaultGateway interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetConstructedData
	// GetIpDefaultGateway returns IpDefaultGateway (property field)
	GetIpDefaultGateway() BACnetApplicationTagOctetString
	// GetActualValue returns ActualValue (virtual field)
	GetActualValue() BACnetApplicationTagOctetString
	// IsBACnetConstructedDataIPDefaultGateway is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetConstructedDataIPDefaultGateway()
	// CreateBuilder creates a BACnetConstructedDataIPDefaultGatewayBuilder
	CreateBACnetConstructedDataIPDefaultGatewayBuilder() BACnetConstructedDataIPDefaultGatewayBuilder
}

// _BACnetConstructedDataIPDefaultGateway is the data-structure of this message
type _BACnetConstructedDataIPDefaultGateway struct {
	BACnetConstructedDataContract
	IpDefaultGateway BACnetApplicationTagOctetString
}

var _ BACnetConstructedDataIPDefaultGateway = (*_BACnetConstructedDataIPDefaultGateway)(nil)
var _ BACnetConstructedDataRequirements = (*_BACnetConstructedDataIPDefaultGateway)(nil)

// NewBACnetConstructedDataIPDefaultGateway factory function for _BACnetConstructedDataIPDefaultGateway
func NewBACnetConstructedDataIPDefaultGateway(openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag, ipDefaultGateway BACnetApplicationTagOctetString, tagNumber uint8, arrayIndexArgument BACnetTagPayloadUnsignedInteger) *_BACnetConstructedDataIPDefaultGateway {
	if ipDefaultGateway == nil {
		panic("ipDefaultGateway of type BACnetApplicationTagOctetString for BACnetConstructedDataIPDefaultGateway must not be nil")
	}
	_result := &_BACnetConstructedDataIPDefaultGateway{
		BACnetConstructedDataContract: NewBACnetConstructedData(openingTag, peekedTagHeader, closingTag, tagNumber, arrayIndexArgument),
		IpDefaultGateway:              ipDefaultGateway,
	}
	_result.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetConstructedDataIPDefaultGatewayBuilder is a builder for BACnetConstructedDataIPDefaultGateway
type BACnetConstructedDataIPDefaultGatewayBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(ipDefaultGateway BACnetApplicationTagOctetString) BACnetConstructedDataIPDefaultGatewayBuilder
	// WithIpDefaultGateway adds IpDefaultGateway (property field)
	WithIpDefaultGateway(BACnetApplicationTagOctetString) BACnetConstructedDataIPDefaultGatewayBuilder
	// WithIpDefaultGatewayBuilder adds IpDefaultGateway (property field) which is build by the builder
	WithIpDefaultGatewayBuilder(func(BACnetApplicationTagOctetStringBuilder) BACnetApplicationTagOctetStringBuilder) BACnetConstructedDataIPDefaultGatewayBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetConstructedDataBuilder
	// Build builds the BACnetConstructedDataIPDefaultGateway or returns an error if something is wrong
	Build() (BACnetConstructedDataIPDefaultGateway, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetConstructedDataIPDefaultGateway
}

// NewBACnetConstructedDataIPDefaultGatewayBuilder() creates a BACnetConstructedDataIPDefaultGatewayBuilder
func NewBACnetConstructedDataIPDefaultGatewayBuilder() BACnetConstructedDataIPDefaultGatewayBuilder {
	return &_BACnetConstructedDataIPDefaultGatewayBuilder{_BACnetConstructedDataIPDefaultGateway: new(_BACnetConstructedDataIPDefaultGateway)}
}

type _BACnetConstructedDataIPDefaultGatewayBuilder struct {
	*_BACnetConstructedDataIPDefaultGateway

	parentBuilder *_BACnetConstructedDataBuilder

	err *utils.MultiError
}

var _ (BACnetConstructedDataIPDefaultGatewayBuilder) = (*_BACnetConstructedDataIPDefaultGatewayBuilder)(nil)

func (b *_BACnetConstructedDataIPDefaultGatewayBuilder) setParent(contract BACnetConstructedDataContract) {
	b.BACnetConstructedDataContract = contract
	contract.(*_BACnetConstructedData)._SubType = b._BACnetConstructedDataIPDefaultGateway
}

func (b *_BACnetConstructedDataIPDefaultGatewayBuilder) WithMandatoryFields(ipDefaultGateway BACnetApplicationTagOctetString) BACnetConstructedDataIPDefaultGatewayBuilder {
	return b.WithIpDefaultGateway(ipDefaultGateway)
}

func (b *_BACnetConstructedDataIPDefaultGatewayBuilder) WithIpDefaultGateway(ipDefaultGateway BACnetApplicationTagOctetString) BACnetConstructedDataIPDefaultGatewayBuilder {
	b.IpDefaultGateway = ipDefaultGateway
	return b
}

func (b *_BACnetConstructedDataIPDefaultGatewayBuilder) WithIpDefaultGatewayBuilder(builderSupplier func(BACnetApplicationTagOctetStringBuilder) BACnetApplicationTagOctetStringBuilder) BACnetConstructedDataIPDefaultGatewayBuilder {
	builder := builderSupplier(b.IpDefaultGateway.CreateBACnetApplicationTagOctetStringBuilder())
	var err error
	b.IpDefaultGateway, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "BACnetApplicationTagOctetStringBuilder failed"))
	}
	return b
}

func (b *_BACnetConstructedDataIPDefaultGatewayBuilder) Build() (BACnetConstructedDataIPDefaultGateway, error) {
	if b.IpDefaultGateway == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'ipDefaultGateway' not set"))
	}
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._BACnetConstructedDataIPDefaultGateway.deepCopy(), nil
}

func (b *_BACnetConstructedDataIPDefaultGatewayBuilder) MustBuild() BACnetConstructedDataIPDefaultGateway {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetConstructedDataIPDefaultGatewayBuilder) Done() BACnetConstructedDataBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetConstructedDataBuilder().(*_BACnetConstructedDataBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetConstructedDataIPDefaultGatewayBuilder) buildForBACnetConstructedData() (BACnetConstructedData, error) {
	return b.Build()
}

func (b *_BACnetConstructedDataIPDefaultGatewayBuilder) DeepCopy() any {
	_copy := b.CreateBACnetConstructedDataIPDefaultGatewayBuilder().(*_BACnetConstructedDataIPDefaultGatewayBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateBACnetConstructedDataIPDefaultGatewayBuilder creates a BACnetConstructedDataIPDefaultGatewayBuilder
func (b *_BACnetConstructedDataIPDefaultGateway) CreateBACnetConstructedDataIPDefaultGatewayBuilder() BACnetConstructedDataIPDefaultGatewayBuilder {
	if b == nil {
		return NewBACnetConstructedDataIPDefaultGatewayBuilder()
	}
	return &_BACnetConstructedDataIPDefaultGatewayBuilder{_BACnetConstructedDataIPDefaultGateway: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_BACnetConstructedDataIPDefaultGateway) GetObjectTypeArgument() BACnetObjectType {
	return 0
}

func (m *_BACnetConstructedDataIPDefaultGateway) GetPropertyIdentifierArgument() BACnetPropertyIdentifier {
	return BACnetPropertyIdentifier_IP_DEFAULT_GATEWAY
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetConstructedDataIPDefaultGateway) GetParent() BACnetConstructedDataContract {
	return m.BACnetConstructedDataContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetConstructedDataIPDefaultGateway) GetIpDefaultGateway() BACnetApplicationTagOctetString {
	return m.IpDefaultGateway
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for virtual fields.
///////////////////////

func (m *_BACnetConstructedDataIPDefaultGateway) GetActualValue() BACnetApplicationTagOctetString {
	ctx := context.Background()
	_ = ctx
	return CastBACnetApplicationTagOctetString(m.GetIpDefaultGateway())
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetConstructedDataIPDefaultGateway(structType any) BACnetConstructedDataIPDefaultGateway {
	if casted, ok := structType.(BACnetConstructedDataIPDefaultGateway); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetConstructedDataIPDefaultGateway); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetConstructedDataIPDefaultGateway) GetTypeName() string {
	return "BACnetConstructedDataIPDefaultGateway"
}

func (m *_BACnetConstructedDataIPDefaultGateway) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetConstructedDataContract.(*_BACnetConstructedData).getLengthInBits(ctx))

	// Simple field (ipDefaultGateway)
	lengthInBits += m.IpDefaultGateway.GetLengthInBits(ctx)

	// A virtual field doesn't have any in- or output.

	return lengthInBits
}

func (m *_BACnetConstructedDataIPDefaultGateway) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetConstructedDataIPDefaultGateway) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetConstructedData, tagNumber uint8, objectTypeArgument BACnetObjectType, propertyIdentifierArgument BACnetPropertyIdentifier, arrayIndexArgument BACnetTagPayloadUnsignedInteger) (__bACnetConstructedDataIPDefaultGateway BACnetConstructedDataIPDefaultGateway, err error) {
	m.BACnetConstructedDataContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetConstructedDataIPDefaultGateway"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetConstructedDataIPDefaultGateway")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	ipDefaultGateway, err := ReadSimpleField[BACnetApplicationTagOctetString](ctx, "ipDefaultGateway", ReadComplex[BACnetApplicationTagOctetString](BACnetApplicationTagParseWithBufferProducer[BACnetApplicationTagOctetString](), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'ipDefaultGateway' field"))
	}
	m.IpDefaultGateway = ipDefaultGateway

	actualValue, err := ReadVirtualField[BACnetApplicationTagOctetString](ctx, "actualValue", (*BACnetApplicationTagOctetString)(nil), ipDefaultGateway)
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'actualValue' field"))
	}
	_ = actualValue

	if closeErr := readBuffer.CloseContext("BACnetConstructedDataIPDefaultGateway"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetConstructedDataIPDefaultGateway")
	}

	return m, nil
}

func (m *_BACnetConstructedDataIPDefaultGateway) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetConstructedDataIPDefaultGateway) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetConstructedDataIPDefaultGateway"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetConstructedDataIPDefaultGateway")
		}

		if err := WriteSimpleField[BACnetApplicationTagOctetString](ctx, "ipDefaultGateway", m.GetIpDefaultGateway(), WriteComplex[BACnetApplicationTagOctetString](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'ipDefaultGateway' field")
		}
		// Virtual field
		actualValue := m.GetActualValue()
		_ = actualValue
		if _actualValueErr := writeBuffer.WriteVirtual(ctx, "actualValue", m.GetActualValue()); _actualValueErr != nil {
			return errors.Wrap(_actualValueErr, "Error serializing 'actualValue' field")
		}

		if popErr := writeBuffer.PopContext("BACnetConstructedDataIPDefaultGateway"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetConstructedDataIPDefaultGateway")
		}
		return nil
	}
	return m.BACnetConstructedDataContract.(*_BACnetConstructedData).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetConstructedDataIPDefaultGateway) IsBACnetConstructedDataIPDefaultGateway() {}

func (m *_BACnetConstructedDataIPDefaultGateway) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetConstructedDataIPDefaultGateway) deepCopy() *_BACnetConstructedDataIPDefaultGateway {
	if m == nil {
		return nil
	}
	_BACnetConstructedDataIPDefaultGatewayCopy := &_BACnetConstructedDataIPDefaultGateway{
		m.BACnetConstructedDataContract.(*_BACnetConstructedData).deepCopy(),
		utils.DeepCopy[BACnetApplicationTagOctetString](m.IpDefaultGateway),
	}
	_BACnetConstructedDataIPDefaultGatewayCopy.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = m
	return _BACnetConstructedDataIPDefaultGatewayCopy
}

func (m *_BACnetConstructedDataIPDefaultGateway) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
