/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetConstructedDataExpirationTime is the corresponding interface of BACnetConstructedDataExpirationTime
type BACnetConstructedDataExpirationTime interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetConstructedData
	// GetExpirationTime returns ExpirationTime (property field)
	GetExpirationTime() BACnetDateTime
	// GetActualValue returns ActualValue (virtual field)
	GetActualValue() BACnetDateTime
	// IsBACnetConstructedDataExpirationTime is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetConstructedDataExpirationTime()
	// CreateBuilder creates a BACnetConstructedDataExpirationTimeBuilder
	CreateBACnetConstructedDataExpirationTimeBuilder() BACnetConstructedDataExpirationTimeBuilder
}

// _BACnetConstructedDataExpirationTime is the data-structure of this message
type _BACnetConstructedDataExpirationTime struct {
	BACnetConstructedDataContract
	ExpirationTime BACnetDateTime
}

var _ BACnetConstructedDataExpirationTime = (*_BACnetConstructedDataExpirationTime)(nil)
var _ BACnetConstructedDataRequirements = (*_BACnetConstructedDataExpirationTime)(nil)

// NewBACnetConstructedDataExpirationTime factory function for _BACnetConstructedDataExpirationTime
func NewBACnetConstructedDataExpirationTime(openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag, expirationTime BACnetDateTime, tagNumber uint8, arrayIndexArgument BACnetTagPayloadUnsignedInteger) *_BACnetConstructedDataExpirationTime {
	if expirationTime == nil {
		panic("expirationTime of type BACnetDateTime for BACnetConstructedDataExpirationTime must not be nil")
	}
	_result := &_BACnetConstructedDataExpirationTime{
		BACnetConstructedDataContract: NewBACnetConstructedData(openingTag, peekedTagHeader, closingTag, tagNumber, arrayIndexArgument),
		ExpirationTime:                expirationTime,
	}
	_result.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetConstructedDataExpirationTimeBuilder is a builder for BACnetConstructedDataExpirationTime
type BACnetConstructedDataExpirationTimeBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(expirationTime BACnetDateTime) BACnetConstructedDataExpirationTimeBuilder
	// WithExpirationTime adds ExpirationTime (property field)
	WithExpirationTime(BACnetDateTime) BACnetConstructedDataExpirationTimeBuilder
	// WithExpirationTimeBuilder adds ExpirationTime (property field) which is build by the builder
	WithExpirationTimeBuilder(func(BACnetDateTimeBuilder) BACnetDateTimeBuilder) BACnetConstructedDataExpirationTimeBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetConstructedDataBuilder
	// Build builds the BACnetConstructedDataExpirationTime or returns an error if something is wrong
	Build() (BACnetConstructedDataExpirationTime, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetConstructedDataExpirationTime
}

// NewBACnetConstructedDataExpirationTimeBuilder() creates a BACnetConstructedDataExpirationTimeBuilder
func NewBACnetConstructedDataExpirationTimeBuilder() BACnetConstructedDataExpirationTimeBuilder {
	return &_BACnetConstructedDataExpirationTimeBuilder{_BACnetConstructedDataExpirationTime: new(_BACnetConstructedDataExpirationTime)}
}

type _BACnetConstructedDataExpirationTimeBuilder struct {
	*_BACnetConstructedDataExpirationTime

	parentBuilder *_BACnetConstructedDataBuilder

	err *utils.MultiError
}

var _ (BACnetConstructedDataExpirationTimeBuilder) = (*_BACnetConstructedDataExpirationTimeBuilder)(nil)

func (b *_BACnetConstructedDataExpirationTimeBuilder) setParent(contract BACnetConstructedDataContract) {
	b.BACnetConstructedDataContract = contract
	contract.(*_BACnetConstructedData)._SubType = b._BACnetConstructedDataExpirationTime
}

func (b *_BACnetConstructedDataExpirationTimeBuilder) WithMandatoryFields(expirationTime BACnetDateTime) BACnetConstructedDataExpirationTimeBuilder {
	return b.WithExpirationTime(expirationTime)
}

func (b *_BACnetConstructedDataExpirationTimeBuilder) WithExpirationTime(expirationTime BACnetDateTime) BACnetConstructedDataExpirationTimeBuilder {
	b.ExpirationTime = expirationTime
	return b
}

func (b *_BACnetConstructedDataExpirationTimeBuilder) WithExpirationTimeBuilder(builderSupplier func(BACnetDateTimeBuilder) BACnetDateTimeBuilder) BACnetConstructedDataExpirationTimeBuilder {
	builder := builderSupplier(b.ExpirationTime.CreateBACnetDateTimeBuilder())
	var err error
	b.ExpirationTime, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "BACnetDateTimeBuilder failed"))
	}
	return b
}

func (b *_BACnetConstructedDataExpirationTimeBuilder) Build() (BACnetConstructedDataExpirationTime, error) {
	if b.ExpirationTime == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'expirationTime' not set"))
	}
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._BACnetConstructedDataExpirationTime.deepCopy(), nil
}

func (b *_BACnetConstructedDataExpirationTimeBuilder) MustBuild() BACnetConstructedDataExpirationTime {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetConstructedDataExpirationTimeBuilder) Done() BACnetConstructedDataBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetConstructedDataBuilder().(*_BACnetConstructedDataBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetConstructedDataExpirationTimeBuilder) buildForBACnetConstructedData() (BACnetConstructedData, error) {
	return b.Build()
}

func (b *_BACnetConstructedDataExpirationTimeBuilder) DeepCopy() any {
	_copy := b.CreateBACnetConstructedDataExpirationTimeBuilder().(*_BACnetConstructedDataExpirationTimeBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateBACnetConstructedDataExpirationTimeBuilder creates a BACnetConstructedDataExpirationTimeBuilder
func (b *_BACnetConstructedDataExpirationTime) CreateBACnetConstructedDataExpirationTimeBuilder() BACnetConstructedDataExpirationTimeBuilder {
	if b == nil {
		return NewBACnetConstructedDataExpirationTimeBuilder()
	}
	return &_BACnetConstructedDataExpirationTimeBuilder{_BACnetConstructedDataExpirationTime: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_BACnetConstructedDataExpirationTime) GetObjectTypeArgument() BACnetObjectType {
	return 0
}

func (m *_BACnetConstructedDataExpirationTime) GetPropertyIdentifierArgument() BACnetPropertyIdentifier {
	return BACnetPropertyIdentifier_EXPIRATION_TIME
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetConstructedDataExpirationTime) GetParent() BACnetConstructedDataContract {
	return m.BACnetConstructedDataContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetConstructedDataExpirationTime) GetExpirationTime() BACnetDateTime {
	return m.ExpirationTime
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for virtual fields.
///////////////////////

func (m *_BACnetConstructedDataExpirationTime) GetActualValue() BACnetDateTime {
	ctx := context.Background()
	_ = ctx
	return CastBACnetDateTime(m.GetExpirationTime())
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetConstructedDataExpirationTime(structType any) BACnetConstructedDataExpirationTime {
	if casted, ok := structType.(BACnetConstructedDataExpirationTime); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetConstructedDataExpirationTime); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetConstructedDataExpirationTime) GetTypeName() string {
	return "BACnetConstructedDataExpirationTime"
}

func (m *_BACnetConstructedDataExpirationTime) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetConstructedDataContract.(*_BACnetConstructedData).getLengthInBits(ctx))

	// Simple field (expirationTime)
	lengthInBits += m.ExpirationTime.GetLengthInBits(ctx)

	// A virtual field doesn't have any in- or output.

	return lengthInBits
}

func (m *_BACnetConstructedDataExpirationTime) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetConstructedDataExpirationTime) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetConstructedData, tagNumber uint8, objectTypeArgument BACnetObjectType, propertyIdentifierArgument BACnetPropertyIdentifier, arrayIndexArgument BACnetTagPayloadUnsignedInteger) (__bACnetConstructedDataExpirationTime BACnetConstructedDataExpirationTime, err error) {
	m.BACnetConstructedDataContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetConstructedDataExpirationTime"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetConstructedDataExpirationTime")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	expirationTime, err := ReadSimpleField[BACnetDateTime](ctx, "expirationTime", ReadComplex[BACnetDateTime](BACnetDateTimeParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'expirationTime' field"))
	}
	m.ExpirationTime = expirationTime

	actualValue, err := ReadVirtualField[BACnetDateTime](ctx, "actualValue", (*BACnetDateTime)(nil), expirationTime)
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'actualValue' field"))
	}
	_ = actualValue

	if closeErr := readBuffer.CloseContext("BACnetConstructedDataExpirationTime"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetConstructedDataExpirationTime")
	}

	return m, nil
}

func (m *_BACnetConstructedDataExpirationTime) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetConstructedDataExpirationTime) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetConstructedDataExpirationTime"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetConstructedDataExpirationTime")
		}

		if err := WriteSimpleField[BACnetDateTime](ctx, "expirationTime", m.GetExpirationTime(), WriteComplex[BACnetDateTime](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'expirationTime' field")
		}
		// Virtual field
		actualValue := m.GetActualValue()
		_ = actualValue
		if _actualValueErr := writeBuffer.WriteVirtual(ctx, "actualValue", m.GetActualValue()); _actualValueErr != nil {
			return errors.Wrap(_actualValueErr, "Error serializing 'actualValue' field")
		}

		if popErr := writeBuffer.PopContext("BACnetConstructedDataExpirationTime"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetConstructedDataExpirationTime")
		}
		return nil
	}
	return m.BACnetConstructedDataContract.(*_BACnetConstructedData).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetConstructedDataExpirationTime) IsBACnetConstructedDataExpirationTime() {}

func (m *_BACnetConstructedDataExpirationTime) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetConstructedDataExpirationTime) deepCopy() *_BACnetConstructedDataExpirationTime {
	if m == nil {
		return nil
	}
	_BACnetConstructedDataExpirationTimeCopy := &_BACnetConstructedDataExpirationTime{
		m.BACnetConstructedDataContract.(*_BACnetConstructedData).deepCopy(),
		utils.DeepCopy[BACnetDateTime](m.ExpirationTime),
	}
	_BACnetConstructedDataExpirationTimeCopy.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = m
	return _BACnetConstructedDataExpirationTimeCopy
}

func (m *_BACnetConstructedDataExpirationTime) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
