/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetConstructedDataEventMessageTextsConfig is the corresponding interface of BACnetConstructedDataEventMessageTextsConfig
type BACnetConstructedDataEventMessageTextsConfig interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetConstructedData
	// GetNumberOfDataElements returns NumberOfDataElements (property field)
	GetNumberOfDataElements() BACnetApplicationTagUnsignedInteger
	// GetEventMessageTextsConfig returns EventMessageTextsConfig (property field)
	GetEventMessageTextsConfig() []BACnetOptionalCharacterString
	// GetZero returns Zero (virtual field)
	GetZero() uint64
	// GetToOffnormalTextConfig returns ToOffnormalTextConfig (virtual field)
	GetToOffnormalTextConfig() BACnetOptionalCharacterString
	// GetToFaultTextConfig returns ToFaultTextConfig (virtual field)
	GetToFaultTextConfig() BACnetOptionalCharacterString
	// GetToNormalTextConfig returns ToNormalTextConfig (virtual field)
	GetToNormalTextConfig() BACnetOptionalCharacterString
	// IsBACnetConstructedDataEventMessageTextsConfig is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetConstructedDataEventMessageTextsConfig()
	// CreateBuilder creates a BACnetConstructedDataEventMessageTextsConfigBuilder
	CreateBACnetConstructedDataEventMessageTextsConfigBuilder() BACnetConstructedDataEventMessageTextsConfigBuilder
}

// _BACnetConstructedDataEventMessageTextsConfig is the data-structure of this message
type _BACnetConstructedDataEventMessageTextsConfig struct {
	BACnetConstructedDataContract
	NumberOfDataElements    BACnetApplicationTagUnsignedInteger
	EventMessageTextsConfig []BACnetOptionalCharacterString
}

var _ BACnetConstructedDataEventMessageTextsConfig = (*_BACnetConstructedDataEventMessageTextsConfig)(nil)
var _ BACnetConstructedDataRequirements = (*_BACnetConstructedDataEventMessageTextsConfig)(nil)

// NewBACnetConstructedDataEventMessageTextsConfig factory function for _BACnetConstructedDataEventMessageTextsConfig
func NewBACnetConstructedDataEventMessageTextsConfig(openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag, numberOfDataElements BACnetApplicationTagUnsignedInteger, eventMessageTextsConfig []BACnetOptionalCharacterString, tagNumber uint8, arrayIndexArgument BACnetTagPayloadUnsignedInteger) *_BACnetConstructedDataEventMessageTextsConfig {
	_result := &_BACnetConstructedDataEventMessageTextsConfig{
		BACnetConstructedDataContract: NewBACnetConstructedData(openingTag, peekedTagHeader, closingTag, tagNumber, arrayIndexArgument),
		NumberOfDataElements:          numberOfDataElements,
		EventMessageTextsConfig:       eventMessageTextsConfig,
	}
	_result.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetConstructedDataEventMessageTextsConfigBuilder is a builder for BACnetConstructedDataEventMessageTextsConfig
type BACnetConstructedDataEventMessageTextsConfigBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(eventMessageTextsConfig []BACnetOptionalCharacterString) BACnetConstructedDataEventMessageTextsConfigBuilder
	// WithNumberOfDataElements adds NumberOfDataElements (property field)
	WithOptionalNumberOfDataElements(BACnetApplicationTagUnsignedInteger) BACnetConstructedDataEventMessageTextsConfigBuilder
	// WithOptionalNumberOfDataElementsBuilder adds NumberOfDataElements (property field) which is build by the builder
	WithOptionalNumberOfDataElementsBuilder(func(BACnetApplicationTagUnsignedIntegerBuilder) BACnetApplicationTagUnsignedIntegerBuilder) BACnetConstructedDataEventMessageTextsConfigBuilder
	// WithEventMessageTextsConfig adds EventMessageTextsConfig (property field)
	WithEventMessageTextsConfig(...BACnetOptionalCharacterString) BACnetConstructedDataEventMessageTextsConfigBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetConstructedDataBuilder
	// Build builds the BACnetConstructedDataEventMessageTextsConfig or returns an error if something is wrong
	Build() (BACnetConstructedDataEventMessageTextsConfig, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetConstructedDataEventMessageTextsConfig
}

// NewBACnetConstructedDataEventMessageTextsConfigBuilder() creates a BACnetConstructedDataEventMessageTextsConfigBuilder
func NewBACnetConstructedDataEventMessageTextsConfigBuilder() BACnetConstructedDataEventMessageTextsConfigBuilder {
	return &_BACnetConstructedDataEventMessageTextsConfigBuilder{_BACnetConstructedDataEventMessageTextsConfig: new(_BACnetConstructedDataEventMessageTextsConfig)}
}

type _BACnetConstructedDataEventMessageTextsConfigBuilder struct {
	*_BACnetConstructedDataEventMessageTextsConfig

	parentBuilder *_BACnetConstructedDataBuilder

	err *utils.MultiError
}

var _ (BACnetConstructedDataEventMessageTextsConfigBuilder) = (*_BACnetConstructedDataEventMessageTextsConfigBuilder)(nil)

func (b *_BACnetConstructedDataEventMessageTextsConfigBuilder) setParent(contract BACnetConstructedDataContract) {
	b.BACnetConstructedDataContract = contract
	contract.(*_BACnetConstructedData)._SubType = b._BACnetConstructedDataEventMessageTextsConfig
}

func (b *_BACnetConstructedDataEventMessageTextsConfigBuilder) WithMandatoryFields(eventMessageTextsConfig []BACnetOptionalCharacterString) BACnetConstructedDataEventMessageTextsConfigBuilder {
	return b.WithEventMessageTextsConfig(eventMessageTextsConfig...)
}

func (b *_BACnetConstructedDataEventMessageTextsConfigBuilder) WithOptionalNumberOfDataElements(numberOfDataElements BACnetApplicationTagUnsignedInteger) BACnetConstructedDataEventMessageTextsConfigBuilder {
	b.NumberOfDataElements = numberOfDataElements
	return b
}

func (b *_BACnetConstructedDataEventMessageTextsConfigBuilder) WithOptionalNumberOfDataElementsBuilder(builderSupplier func(BACnetApplicationTagUnsignedIntegerBuilder) BACnetApplicationTagUnsignedIntegerBuilder) BACnetConstructedDataEventMessageTextsConfigBuilder {
	builder := builderSupplier(b.NumberOfDataElements.CreateBACnetApplicationTagUnsignedIntegerBuilder())
	var err error
	b.NumberOfDataElements, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "BACnetApplicationTagUnsignedIntegerBuilder failed"))
	}
	return b
}

func (b *_BACnetConstructedDataEventMessageTextsConfigBuilder) WithEventMessageTextsConfig(eventMessageTextsConfig ...BACnetOptionalCharacterString) BACnetConstructedDataEventMessageTextsConfigBuilder {
	b.EventMessageTextsConfig = eventMessageTextsConfig
	return b
}

func (b *_BACnetConstructedDataEventMessageTextsConfigBuilder) Build() (BACnetConstructedDataEventMessageTextsConfig, error) {
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._BACnetConstructedDataEventMessageTextsConfig.deepCopy(), nil
}

func (b *_BACnetConstructedDataEventMessageTextsConfigBuilder) MustBuild() BACnetConstructedDataEventMessageTextsConfig {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetConstructedDataEventMessageTextsConfigBuilder) Done() BACnetConstructedDataBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetConstructedDataBuilder().(*_BACnetConstructedDataBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetConstructedDataEventMessageTextsConfigBuilder) buildForBACnetConstructedData() (BACnetConstructedData, error) {
	return b.Build()
}

func (b *_BACnetConstructedDataEventMessageTextsConfigBuilder) DeepCopy() any {
	_copy := b.CreateBACnetConstructedDataEventMessageTextsConfigBuilder().(*_BACnetConstructedDataEventMessageTextsConfigBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateBACnetConstructedDataEventMessageTextsConfigBuilder creates a BACnetConstructedDataEventMessageTextsConfigBuilder
func (b *_BACnetConstructedDataEventMessageTextsConfig) CreateBACnetConstructedDataEventMessageTextsConfigBuilder() BACnetConstructedDataEventMessageTextsConfigBuilder {
	if b == nil {
		return NewBACnetConstructedDataEventMessageTextsConfigBuilder()
	}
	return &_BACnetConstructedDataEventMessageTextsConfigBuilder{_BACnetConstructedDataEventMessageTextsConfig: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_BACnetConstructedDataEventMessageTextsConfig) GetObjectTypeArgument() BACnetObjectType {
	return 0
}

func (m *_BACnetConstructedDataEventMessageTextsConfig) GetPropertyIdentifierArgument() BACnetPropertyIdentifier {
	return BACnetPropertyIdentifier_EVENT_MESSAGE_TEXTS_CONFIG
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetConstructedDataEventMessageTextsConfig) GetParent() BACnetConstructedDataContract {
	return m.BACnetConstructedDataContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetConstructedDataEventMessageTextsConfig) GetNumberOfDataElements() BACnetApplicationTagUnsignedInteger {
	return m.NumberOfDataElements
}

func (m *_BACnetConstructedDataEventMessageTextsConfig) GetEventMessageTextsConfig() []BACnetOptionalCharacterString {
	return m.EventMessageTextsConfig
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for virtual fields.
///////////////////////

func (m *_BACnetConstructedDataEventMessageTextsConfig) GetZero() uint64 {
	ctx := context.Background()
	_ = ctx
	numberOfDataElements := m.GetNumberOfDataElements()
	_ = numberOfDataElements
	return uint64(uint64(0))
}

func (m *_BACnetConstructedDataEventMessageTextsConfig) GetToOffnormalTextConfig() BACnetOptionalCharacterString {
	ctx := context.Background()
	_ = ctx
	numberOfDataElements := m.GetNumberOfDataElements()
	_ = numberOfDataElements
	return CastBACnetOptionalCharacterString(CastBACnetOptionalCharacterString(utils.InlineIf(bool((len(m.GetEventMessageTextsConfig())) == (3)), func() any { return CastBACnetOptionalCharacterString(m.GetEventMessageTextsConfig()[0]) }, func() any { return CastBACnetOptionalCharacterString(nil) })))
}

func (m *_BACnetConstructedDataEventMessageTextsConfig) GetToFaultTextConfig() BACnetOptionalCharacterString {
	ctx := context.Background()
	_ = ctx
	numberOfDataElements := m.GetNumberOfDataElements()
	_ = numberOfDataElements
	return CastBACnetOptionalCharacterString(CastBACnetOptionalCharacterString(utils.InlineIf(bool((len(m.GetEventMessageTextsConfig())) == (3)), func() any { return CastBACnetOptionalCharacterString(m.GetEventMessageTextsConfig()[1]) }, func() any { return CastBACnetOptionalCharacterString(nil) })))
}

func (m *_BACnetConstructedDataEventMessageTextsConfig) GetToNormalTextConfig() BACnetOptionalCharacterString {
	ctx := context.Background()
	_ = ctx
	numberOfDataElements := m.GetNumberOfDataElements()
	_ = numberOfDataElements
	return CastBACnetOptionalCharacterString(CastBACnetOptionalCharacterString(utils.InlineIf(bool((len(m.GetEventMessageTextsConfig())) == (3)), func() any { return CastBACnetOptionalCharacterString(m.GetEventMessageTextsConfig()[2]) }, func() any { return CastBACnetOptionalCharacterString(nil) })))
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetConstructedDataEventMessageTextsConfig(structType any) BACnetConstructedDataEventMessageTextsConfig {
	if casted, ok := structType.(BACnetConstructedDataEventMessageTextsConfig); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetConstructedDataEventMessageTextsConfig); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetConstructedDataEventMessageTextsConfig) GetTypeName() string {
	return "BACnetConstructedDataEventMessageTextsConfig"
}

func (m *_BACnetConstructedDataEventMessageTextsConfig) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetConstructedDataContract.(*_BACnetConstructedData).getLengthInBits(ctx))

	// A virtual field doesn't have any in- or output.

	// Optional Field (numberOfDataElements)
	if m.NumberOfDataElements != nil {
		lengthInBits += m.NumberOfDataElements.GetLengthInBits(ctx)
	}

	// Array field
	if len(m.EventMessageTextsConfig) > 0 {
		for _, element := range m.EventMessageTextsConfig {
			lengthInBits += element.GetLengthInBits(ctx)
		}
	}

	// A virtual field doesn't have any in- or output.

	// A virtual field doesn't have any in- or output.

	// A virtual field doesn't have any in- or output.

	return lengthInBits
}

func (m *_BACnetConstructedDataEventMessageTextsConfig) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetConstructedDataEventMessageTextsConfig) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetConstructedData, tagNumber uint8, objectTypeArgument BACnetObjectType, propertyIdentifierArgument BACnetPropertyIdentifier, arrayIndexArgument BACnetTagPayloadUnsignedInteger) (__bACnetConstructedDataEventMessageTextsConfig BACnetConstructedDataEventMessageTextsConfig, err error) {
	m.BACnetConstructedDataContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetConstructedDataEventMessageTextsConfig"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetConstructedDataEventMessageTextsConfig")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	zero, err := ReadVirtualField[uint64](ctx, "zero", (*uint64)(nil), uint64(0))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'zero' field"))
	}
	_ = zero

	var numberOfDataElements BACnetApplicationTagUnsignedInteger
	_numberOfDataElements, err := ReadOptionalField[BACnetApplicationTagUnsignedInteger](ctx, "numberOfDataElements", ReadComplex[BACnetApplicationTagUnsignedInteger](BACnetApplicationTagParseWithBufferProducer[BACnetApplicationTagUnsignedInteger](), readBuffer), bool(bool((arrayIndexArgument) != (nil))) && bool(bool((arrayIndexArgument.GetActualValue()) == (zero))))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'numberOfDataElements' field"))
	}
	if _numberOfDataElements != nil {
		numberOfDataElements = *_numberOfDataElements
		m.NumberOfDataElements = numberOfDataElements
	}

	eventMessageTextsConfig, err := ReadTerminatedArrayField[BACnetOptionalCharacterString](ctx, "eventMessageTextsConfig", ReadComplex[BACnetOptionalCharacterString](BACnetOptionalCharacterStringParseWithBuffer, readBuffer), IsBACnetConstructedDataClosingTag(ctx, readBuffer, false, tagNumber))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'eventMessageTextsConfig' field"))
	}
	m.EventMessageTextsConfig = eventMessageTextsConfig

	toOffnormalTextConfig, err := ReadVirtualField[BACnetOptionalCharacterString](ctx, "toOffnormalTextConfig", (*BACnetOptionalCharacterString)(nil), CastBACnetOptionalCharacterString(utils.InlineIf(bool((len(eventMessageTextsConfig)) == (3)), func() any { return CastBACnetOptionalCharacterString(eventMessageTextsConfig[0]) }, func() any { return CastBACnetOptionalCharacterString(nil) })))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'toOffnormalTextConfig' field"))
	}
	_ = toOffnormalTextConfig

	toFaultTextConfig, err := ReadVirtualField[BACnetOptionalCharacterString](ctx, "toFaultTextConfig", (*BACnetOptionalCharacterString)(nil), CastBACnetOptionalCharacterString(utils.InlineIf(bool((len(eventMessageTextsConfig)) == (3)), func() any { return CastBACnetOptionalCharacterString(eventMessageTextsConfig[1]) }, func() any { return CastBACnetOptionalCharacterString(nil) })))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'toFaultTextConfig' field"))
	}
	_ = toFaultTextConfig

	toNormalTextConfig, err := ReadVirtualField[BACnetOptionalCharacterString](ctx, "toNormalTextConfig", (*BACnetOptionalCharacterString)(nil), CastBACnetOptionalCharacterString(utils.InlineIf(bool((len(eventMessageTextsConfig)) == (3)), func() any { return CastBACnetOptionalCharacterString(eventMessageTextsConfig[2]) }, func() any { return CastBACnetOptionalCharacterString(nil) })))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'toNormalTextConfig' field"))
	}
	_ = toNormalTextConfig

	// Validation
	if !(bool(bool((arrayIndexArgument) != (nil))) || bool(bool((len(eventMessageTextsConfig)) == (3)))) {
		return nil, errors.WithStack(utils.ParseValidationError{Message: "eventMessageTextsConfig should have exactly 3 values"})
	}

	if closeErr := readBuffer.CloseContext("BACnetConstructedDataEventMessageTextsConfig"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetConstructedDataEventMessageTextsConfig")
	}

	return m, nil
}

func (m *_BACnetConstructedDataEventMessageTextsConfig) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetConstructedDataEventMessageTextsConfig) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetConstructedDataEventMessageTextsConfig"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetConstructedDataEventMessageTextsConfig")
		}
		// Virtual field
		zero := m.GetZero()
		_ = zero
		if _zeroErr := writeBuffer.WriteVirtual(ctx, "zero", m.GetZero()); _zeroErr != nil {
			return errors.Wrap(_zeroErr, "Error serializing 'zero' field")
		}

		if err := WriteOptionalField[BACnetApplicationTagUnsignedInteger](ctx, "numberOfDataElements", GetRef(m.GetNumberOfDataElements()), WriteComplex[BACnetApplicationTagUnsignedInteger](writeBuffer), true); err != nil {
			return errors.Wrap(err, "Error serializing 'numberOfDataElements' field")
		}

		if err := WriteComplexTypeArrayField(ctx, "eventMessageTextsConfig", m.GetEventMessageTextsConfig(), writeBuffer); err != nil {
			return errors.Wrap(err, "Error serializing 'eventMessageTextsConfig' field")
		}
		// Virtual field
		toOffnormalTextConfig := m.GetToOffnormalTextConfig()
		_ = toOffnormalTextConfig
		if _toOffnormalTextConfigErr := writeBuffer.WriteVirtual(ctx, "toOffnormalTextConfig", m.GetToOffnormalTextConfig()); _toOffnormalTextConfigErr != nil {
			return errors.Wrap(_toOffnormalTextConfigErr, "Error serializing 'toOffnormalTextConfig' field")
		}
		// Virtual field
		toFaultTextConfig := m.GetToFaultTextConfig()
		_ = toFaultTextConfig
		if _toFaultTextConfigErr := writeBuffer.WriteVirtual(ctx, "toFaultTextConfig", m.GetToFaultTextConfig()); _toFaultTextConfigErr != nil {
			return errors.Wrap(_toFaultTextConfigErr, "Error serializing 'toFaultTextConfig' field")
		}
		// Virtual field
		toNormalTextConfig := m.GetToNormalTextConfig()
		_ = toNormalTextConfig
		if _toNormalTextConfigErr := writeBuffer.WriteVirtual(ctx, "toNormalTextConfig", m.GetToNormalTextConfig()); _toNormalTextConfigErr != nil {
			return errors.Wrap(_toNormalTextConfigErr, "Error serializing 'toNormalTextConfig' field")
		}

		if popErr := writeBuffer.PopContext("BACnetConstructedDataEventMessageTextsConfig"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetConstructedDataEventMessageTextsConfig")
		}
		return nil
	}
	return m.BACnetConstructedDataContract.(*_BACnetConstructedData).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetConstructedDataEventMessageTextsConfig) IsBACnetConstructedDataEventMessageTextsConfig() {
}

func (m *_BACnetConstructedDataEventMessageTextsConfig) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetConstructedDataEventMessageTextsConfig) deepCopy() *_BACnetConstructedDataEventMessageTextsConfig {
	if m == nil {
		return nil
	}
	_BACnetConstructedDataEventMessageTextsConfigCopy := &_BACnetConstructedDataEventMessageTextsConfig{
		m.BACnetConstructedDataContract.(*_BACnetConstructedData).deepCopy(),
		utils.DeepCopy[BACnetApplicationTagUnsignedInteger](m.NumberOfDataElements),
		utils.DeepCopySlice[BACnetOptionalCharacterString, BACnetOptionalCharacterString](m.EventMessageTextsConfig),
	}
	_BACnetConstructedDataEventMessageTextsConfigCopy.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = m
	return _BACnetConstructedDataEventMessageTextsConfigCopy
}

func (m *_BACnetConstructedDataEventMessageTextsConfig) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
