/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetConstructedDataEventAlgorithmInhibit is the corresponding interface of BACnetConstructedDataEventAlgorithmInhibit
type BACnetConstructedDataEventAlgorithmInhibit interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetConstructedData
	// GetEventAlgorithmInhibit returns EventAlgorithmInhibit (property field)
	GetEventAlgorithmInhibit() BACnetApplicationTagBoolean
	// GetActualValue returns ActualValue (virtual field)
	GetActualValue() BACnetApplicationTagBoolean
	// IsBACnetConstructedDataEventAlgorithmInhibit is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetConstructedDataEventAlgorithmInhibit()
	// CreateBuilder creates a BACnetConstructedDataEventAlgorithmInhibitBuilder
	CreateBACnetConstructedDataEventAlgorithmInhibitBuilder() BACnetConstructedDataEventAlgorithmInhibitBuilder
}

// _BACnetConstructedDataEventAlgorithmInhibit is the data-structure of this message
type _BACnetConstructedDataEventAlgorithmInhibit struct {
	BACnetConstructedDataContract
	EventAlgorithmInhibit BACnetApplicationTagBoolean
}

var _ BACnetConstructedDataEventAlgorithmInhibit = (*_BACnetConstructedDataEventAlgorithmInhibit)(nil)
var _ BACnetConstructedDataRequirements = (*_BACnetConstructedDataEventAlgorithmInhibit)(nil)

// NewBACnetConstructedDataEventAlgorithmInhibit factory function for _BACnetConstructedDataEventAlgorithmInhibit
func NewBACnetConstructedDataEventAlgorithmInhibit(openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag, eventAlgorithmInhibit BACnetApplicationTagBoolean, tagNumber uint8, arrayIndexArgument BACnetTagPayloadUnsignedInteger) *_BACnetConstructedDataEventAlgorithmInhibit {
	if eventAlgorithmInhibit == nil {
		panic("eventAlgorithmInhibit of type BACnetApplicationTagBoolean for BACnetConstructedDataEventAlgorithmInhibit must not be nil")
	}
	_result := &_BACnetConstructedDataEventAlgorithmInhibit{
		BACnetConstructedDataContract: NewBACnetConstructedData(openingTag, peekedTagHeader, closingTag, tagNumber, arrayIndexArgument),
		EventAlgorithmInhibit:         eventAlgorithmInhibit,
	}
	_result.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetConstructedDataEventAlgorithmInhibitBuilder is a builder for BACnetConstructedDataEventAlgorithmInhibit
type BACnetConstructedDataEventAlgorithmInhibitBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(eventAlgorithmInhibit BACnetApplicationTagBoolean) BACnetConstructedDataEventAlgorithmInhibitBuilder
	// WithEventAlgorithmInhibit adds EventAlgorithmInhibit (property field)
	WithEventAlgorithmInhibit(BACnetApplicationTagBoolean) BACnetConstructedDataEventAlgorithmInhibitBuilder
	// WithEventAlgorithmInhibitBuilder adds EventAlgorithmInhibit (property field) which is build by the builder
	WithEventAlgorithmInhibitBuilder(func(BACnetApplicationTagBooleanBuilder) BACnetApplicationTagBooleanBuilder) BACnetConstructedDataEventAlgorithmInhibitBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetConstructedDataBuilder
	// Build builds the BACnetConstructedDataEventAlgorithmInhibit or returns an error if something is wrong
	Build() (BACnetConstructedDataEventAlgorithmInhibit, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetConstructedDataEventAlgorithmInhibit
}

// NewBACnetConstructedDataEventAlgorithmInhibitBuilder() creates a BACnetConstructedDataEventAlgorithmInhibitBuilder
func NewBACnetConstructedDataEventAlgorithmInhibitBuilder() BACnetConstructedDataEventAlgorithmInhibitBuilder {
	return &_BACnetConstructedDataEventAlgorithmInhibitBuilder{_BACnetConstructedDataEventAlgorithmInhibit: new(_BACnetConstructedDataEventAlgorithmInhibit)}
}

type _BACnetConstructedDataEventAlgorithmInhibitBuilder struct {
	*_BACnetConstructedDataEventAlgorithmInhibit

	parentBuilder *_BACnetConstructedDataBuilder

	err *utils.MultiError
}

var _ (BACnetConstructedDataEventAlgorithmInhibitBuilder) = (*_BACnetConstructedDataEventAlgorithmInhibitBuilder)(nil)

func (b *_BACnetConstructedDataEventAlgorithmInhibitBuilder) setParent(contract BACnetConstructedDataContract) {
	b.BACnetConstructedDataContract = contract
	contract.(*_BACnetConstructedData)._SubType = b._BACnetConstructedDataEventAlgorithmInhibit
}

func (b *_BACnetConstructedDataEventAlgorithmInhibitBuilder) WithMandatoryFields(eventAlgorithmInhibit BACnetApplicationTagBoolean) BACnetConstructedDataEventAlgorithmInhibitBuilder {
	return b.WithEventAlgorithmInhibit(eventAlgorithmInhibit)
}

func (b *_BACnetConstructedDataEventAlgorithmInhibitBuilder) WithEventAlgorithmInhibit(eventAlgorithmInhibit BACnetApplicationTagBoolean) BACnetConstructedDataEventAlgorithmInhibitBuilder {
	b.EventAlgorithmInhibit = eventAlgorithmInhibit
	return b
}

func (b *_BACnetConstructedDataEventAlgorithmInhibitBuilder) WithEventAlgorithmInhibitBuilder(builderSupplier func(BACnetApplicationTagBooleanBuilder) BACnetApplicationTagBooleanBuilder) BACnetConstructedDataEventAlgorithmInhibitBuilder {
	builder := builderSupplier(b.EventAlgorithmInhibit.CreateBACnetApplicationTagBooleanBuilder())
	var err error
	b.EventAlgorithmInhibit, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "BACnetApplicationTagBooleanBuilder failed"))
	}
	return b
}

func (b *_BACnetConstructedDataEventAlgorithmInhibitBuilder) Build() (BACnetConstructedDataEventAlgorithmInhibit, error) {
	if b.EventAlgorithmInhibit == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'eventAlgorithmInhibit' not set"))
	}
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._BACnetConstructedDataEventAlgorithmInhibit.deepCopy(), nil
}

func (b *_BACnetConstructedDataEventAlgorithmInhibitBuilder) MustBuild() BACnetConstructedDataEventAlgorithmInhibit {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetConstructedDataEventAlgorithmInhibitBuilder) Done() BACnetConstructedDataBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetConstructedDataBuilder().(*_BACnetConstructedDataBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetConstructedDataEventAlgorithmInhibitBuilder) buildForBACnetConstructedData() (BACnetConstructedData, error) {
	return b.Build()
}

func (b *_BACnetConstructedDataEventAlgorithmInhibitBuilder) DeepCopy() any {
	_copy := b.CreateBACnetConstructedDataEventAlgorithmInhibitBuilder().(*_BACnetConstructedDataEventAlgorithmInhibitBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateBACnetConstructedDataEventAlgorithmInhibitBuilder creates a BACnetConstructedDataEventAlgorithmInhibitBuilder
func (b *_BACnetConstructedDataEventAlgorithmInhibit) CreateBACnetConstructedDataEventAlgorithmInhibitBuilder() BACnetConstructedDataEventAlgorithmInhibitBuilder {
	if b == nil {
		return NewBACnetConstructedDataEventAlgorithmInhibitBuilder()
	}
	return &_BACnetConstructedDataEventAlgorithmInhibitBuilder{_BACnetConstructedDataEventAlgorithmInhibit: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_BACnetConstructedDataEventAlgorithmInhibit) GetObjectTypeArgument() BACnetObjectType {
	return 0
}

func (m *_BACnetConstructedDataEventAlgorithmInhibit) GetPropertyIdentifierArgument() BACnetPropertyIdentifier {
	return BACnetPropertyIdentifier_EVENT_ALGORITHM_INHIBIT
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetConstructedDataEventAlgorithmInhibit) GetParent() BACnetConstructedDataContract {
	return m.BACnetConstructedDataContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetConstructedDataEventAlgorithmInhibit) GetEventAlgorithmInhibit() BACnetApplicationTagBoolean {
	return m.EventAlgorithmInhibit
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for virtual fields.
///////////////////////

func (m *_BACnetConstructedDataEventAlgorithmInhibit) GetActualValue() BACnetApplicationTagBoolean {
	ctx := context.Background()
	_ = ctx
	return CastBACnetApplicationTagBoolean(m.GetEventAlgorithmInhibit())
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetConstructedDataEventAlgorithmInhibit(structType any) BACnetConstructedDataEventAlgorithmInhibit {
	if casted, ok := structType.(BACnetConstructedDataEventAlgorithmInhibit); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetConstructedDataEventAlgorithmInhibit); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetConstructedDataEventAlgorithmInhibit) GetTypeName() string {
	return "BACnetConstructedDataEventAlgorithmInhibit"
}

func (m *_BACnetConstructedDataEventAlgorithmInhibit) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetConstructedDataContract.(*_BACnetConstructedData).getLengthInBits(ctx))

	// Simple field (eventAlgorithmInhibit)
	lengthInBits += m.EventAlgorithmInhibit.GetLengthInBits(ctx)

	// A virtual field doesn't have any in- or output.

	return lengthInBits
}

func (m *_BACnetConstructedDataEventAlgorithmInhibit) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetConstructedDataEventAlgorithmInhibit) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetConstructedData, tagNumber uint8, objectTypeArgument BACnetObjectType, propertyIdentifierArgument BACnetPropertyIdentifier, arrayIndexArgument BACnetTagPayloadUnsignedInteger) (__bACnetConstructedDataEventAlgorithmInhibit BACnetConstructedDataEventAlgorithmInhibit, err error) {
	m.BACnetConstructedDataContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetConstructedDataEventAlgorithmInhibit"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetConstructedDataEventAlgorithmInhibit")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	eventAlgorithmInhibit, err := ReadSimpleField[BACnetApplicationTagBoolean](ctx, "eventAlgorithmInhibit", ReadComplex[BACnetApplicationTagBoolean](BACnetApplicationTagParseWithBufferProducer[BACnetApplicationTagBoolean](), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'eventAlgorithmInhibit' field"))
	}
	m.EventAlgorithmInhibit = eventAlgorithmInhibit

	actualValue, err := ReadVirtualField[BACnetApplicationTagBoolean](ctx, "actualValue", (*BACnetApplicationTagBoolean)(nil), eventAlgorithmInhibit)
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'actualValue' field"))
	}
	_ = actualValue

	if closeErr := readBuffer.CloseContext("BACnetConstructedDataEventAlgorithmInhibit"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetConstructedDataEventAlgorithmInhibit")
	}

	return m, nil
}

func (m *_BACnetConstructedDataEventAlgorithmInhibit) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetConstructedDataEventAlgorithmInhibit) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetConstructedDataEventAlgorithmInhibit"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetConstructedDataEventAlgorithmInhibit")
		}

		if err := WriteSimpleField[BACnetApplicationTagBoolean](ctx, "eventAlgorithmInhibit", m.GetEventAlgorithmInhibit(), WriteComplex[BACnetApplicationTagBoolean](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'eventAlgorithmInhibit' field")
		}
		// Virtual field
		actualValue := m.GetActualValue()
		_ = actualValue
		if _actualValueErr := writeBuffer.WriteVirtual(ctx, "actualValue", m.GetActualValue()); _actualValueErr != nil {
			return errors.Wrap(_actualValueErr, "Error serializing 'actualValue' field")
		}

		if popErr := writeBuffer.PopContext("BACnetConstructedDataEventAlgorithmInhibit"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetConstructedDataEventAlgorithmInhibit")
		}
		return nil
	}
	return m.BACnetConstructedDataContract.(*_BACnetConstructedData).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetConstructedDataEventAlgorithmInhibit) IsBACnetConstructedDataEventAlgorithmInhibit() {
}

func (m *_BACnetConstructedDataEventAlgorithmInhibit) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetConstructedDataEventAlgorithmInhibit) deepCopy() *_BACnetConstructedDataEventAlgorithmInhibit {
	if m == nil {
		return nil
	}
	_BACnetConstructedDataEventAlgorithmInhibitCopy := &_BACnetConstructedDataEventAlgorithmInhibit{
		m.BACnetConstructedDataContract.(*_BACnetConstructedData).deepCopy(),
		utils.DeepCopy[BACnetApplicationTagBoolean](m.EventAlgorithmInhibit),
	}
	_BACnetConstructedDataEventAlgorithmInhibitCopy.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = m
	return _BACnetConstructedDataEventAlgorithmInhibitCopy
}

func (m *_BACnetConstructedDataEventAlgorithmInhibit) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
