/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetConstructedDataDefaultFadeTime is the corresponding interface of BACnetConstructedDataDefaultFadeTime
type BACnetConstructedDataDefaultFadeTime interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetConstructedData
	// GetDefaultFadeTime returns DefaultFadeTime (property field)
	GetDefaultFadeTime() BACnetApplicationTagUnsignedInteger
	// GetActualValue returns ActualValue (virtual field)
	GetActualValue() BACnetApplicationTagUnsignedInteger
	// IsBACnetConstructedDataDefaultFadeTime is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetConstructedDataDefaultFadeTime()
	// CreateBuilder creates a BACnetConstructedDataDefaultFadeTimeBuilder
	CreateBACnetConstructedDataDefaultFadeTimeBuilder() BACnetConstructedDataDefaultFadeTimeBuilder
}

// _BACnetConstructedDataDefaultFadeTime is the data-structure of this message
type _BACnetConstructedDataDefaultFadeTime struct {
	BACnetConstructedDataContract
	DefaultFadeTime BACnetApplicationTagUnsignedInteger
}

var _ BACnetConstructedDataDefaultFadeTime = (*_BACnetConstructedDataDefaultFadeTime)(nil)
var _ BACnetConstructedDataRequirements = (*_BACnetConstructedDataDefaultFadeTime)(nil)

// NewBACnetConstructedDataDefaultFadeTime factory function for _BACnetConstructedDataDefaultFadeTime
func NewBACnetConstructedDataDefaultFadeTime(openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag, defaultFadeTime BACnetApplicationTagUnsignedInteger, tagNumber uint8, arrayIndexArgument BACnetTagPayloadUnsignedInteger) *_BACnetConstructedDataDefaultFadeTime {
	if defaultFadeTime == nil {
		panic("defaultFadeTime of type BACnetApplicationTagUnsignedInteger for BACnetConstructedDataDefaultFadeTime must not be nil")
	}
	_result := &_BACnetConstructedDataDefaultFadeTime{
		BACnetConstructedDataContract: NewBACnetConstructedData(openingTag, peekedTagHeader, closingTag, tagNumber, arrayIndexArgument),
		DefaultFadeTime:               defaultFadeTime,
	}
	_result.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetConstructedDataDefaultFadeTimeBuilder is a builder for BACnetConstructedDataDefaultFadeTime
type BACnetConstructedDataDefaultFadeTimeBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(defaultFadeTime BACnetApplicationTagUnsignedInteger) BACnetConstructedDataDefaultFadeTimeBuilder
	// WithDefaultFadeTime adds DefaultFadeTime (property field)
	WithDefaultFadeTime(BACnetApplicationTagUnsignedInteger) BACnetConstructedDataDefaultFadeTimeBuilder
	// WithDefaultFadeTimeBuilder adds DefaultFadeTime (property field) which is build by the builder
	WithDefaultFadeTimeBuilder(func(BACnetApplicationTagUnsignedIntegerBuilder) BACnetApplicationTagUnsignedIntegerBuilder) BACnetConstructedDataDefaultFadeTimeBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetConstructedDataBuilder
	// Build builds the BACnetConstructedDataDefaultFadeTime or returns an error if something is wrong
	Build() (BACnetConstructedDataDefaultFadeTime, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetConstructedDataDefaultFadeTime
}

// NewBACnetConstructedDataDefaultFadeTimeBuilder() creates a BACnetConstructedDataDefaultFadeTimeBuilder
func NewBACnetConstructedDataDefaultFadeTimeBuilder() BACnetConstructedDataDefaultFadeTimeBuilder {
	return &_BACnetConstructedDataDefaultFadeTimeBuilder{_BACnetConstructedDataDefaultFadeTime: new(_BACnetConstructedDataDefaultFadeTime)}
}

type _BACnetConstructedDataDefaultFadeTimeBuilder struct {
	*_BACnetConstructedDataDefaultFadeTime

	parentBuilder *_BACnetConstructedDataBuilder

	err *utils.MultiError
}

var _ (BACnetConstructedDataDefaultFadeTimeBuilder) = (*_BACnetConstructedDataDefaultFadeTimeBuilder)(nil)

func (b *_BACnetConstructedDataDefaultFadeTimeBuilder) setParent(contract BACnetConstructedDataContract) {
	b.BACnetConstructedDataContract = contract
	contract.(*_BACnetConstructedData)._SubType = b._BACnetConstructedDataDefaultFadeTime
}

func (b *_BACnetConstructedDataDefaultFadeTimeBuilder) WithMandatoryFields(defaultFadeTime BACnetApplicationTagUnsignedInteger) BACnetConstructedDataDefaultFadeTimeBuilder {
	return b.WithDefaultFadeTime(defaultFadeTime)
}

func (b *_BACnetConstructedDataDefaultFadeTimeBuilder) WithDefaultFadeTime(defaultFadeTime BACnetApplicationTagUnsignedInteger) BACnetConstructedDataDefaultFadeTimeBuilder {
	b.DefaultFadeTime = defaultFadeTime
	return b
}

func (b *_BACnetConstructedDataDefaultFadeTimeBuilder) WithDefaultFadeTimeBuilder(builderSupplier func(BACnetApplicationTagUnsignedIntegerBuilder) BACnetApplicationTagUnsignedIntegerBuilder) BACnetConstructedDataDefaultFadeTimeBuilder {
	builder := builderSupplier(b.DefaultFadeTime.CreateBACnetApplicationTagUnsignedIntegerBuilder())
	var err error
	b.DefaultFadeTime, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "BACnetApplicationTagUnsignedIntegerBuilder failed"))
	}
	return b
}

func (b *_BACnetConstructedDataDefaultFadeTimeBuilder) Build() (BACnetConstructedDataDefaultFadeTime, error) {
	if b.DefaultFadeTime == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'defaultFadeTime' not set"))
	}
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._BACnetConstructedDataDefaultFadeTime.deepCopy(), nil
}

func (b *_BACnetConstructedDataDefaultFadeTimeBuilder) MustBuild() BACnetConstructedDataDefaultFadeTime {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetConstructedDataDefaultFadeTimeBuilder) Done() BACnetConstructedDataBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetConstructedDataBuilder().(*_BACnetConstructedDataBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetConstructedDataDefaultFadeTimeBuilder) buildForBACnetConstructedData() (BACnetConstructedData, error) {
	return b.Build()
}

func (b *_BACnetConstructedDataDefaultFadeTimeBuilder) DeepCopy() any {
	_copy := b.CreateBACnetConstructedDataDefaultFadeTimeBuilder().(*_BACnetConstructedDataDefaultFadeTimeBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateBACnetConstructedDataDefaultFadeTimeBuilder creates a BACnetConstructedDataDefaultFadeTimeBuilder
func (b *_BACnetConstructedDataDefaultFadeTime) CreateBACnetConstructedDataDefaultFadeTimeBuilder() BACnetConstructedDataDefaultFadeTimeBuilder {
	if b == nil {
		return NewBACnetConstructedDataDefaultFadeTimeBuilder()
	}
	return &_BACnetConstructedDataDefaultFadeTimeBuilder{_BACnetConstructedDataDefaultFadeTime: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_BACnetConstructedDataDefaultFadeTime) GetObjectTypeArgument() BACnetObjectType {
	return 0
}

func (m *_BACnetConstructedDataDefaultFadeTime) GetPropertyIdentifierArgument() BACnetPropertyIdentifier {
	return BACnetPropertyIdentifier_DEFAULT_FADE_TIME
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetConstructedDataDefaultFadeTime) GetParent() BACnetConstructedDataContract {
	return m.BACnetConstructedDataContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetConstructedDataDefaultFadeTime) GetDefaultFadeTime() BACnetApplicationTagUnsignedInteger {
	return m.DefaultFadeTime
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for virtual fields.
///////////////////////

func (m *_BACnetConstructedDataDefaultFadeTime) GetActualValue() BACnetApplicationTagUnsignedInteger {
	ctx := context.Background()
	_ = ctx
	return CastBACnetApplicationTagUnsignedInteger(m.GetDefaultFadeTime())
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetConstructedDataDefaultFadeTime(structType any) BACnetConstructedDataDefaultFadeTime {
	if casted, ok := structType.(BACnetConstructedDataDefaultFadeTime); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetConstructedDataDefaultFadeTime); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetConstructedDataDefaultFadeTime) GetTypeName() string {
	return "BACnetConstructedDataDefaultFadeTime"
}

func (m *_BACnetConstructedDataDefaultFadeTime) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetConstructedDataContract.(*_BACnetConstructedData).getLengthInBits(ctx))

	// Simple field (defaultFadeTime)
	lengthInBits += m.DefaultFadeTime.GetLengthInBits(ctx)

	// A virtual field doesn't have any in- or output.

	return lengthInBits
}

func (m *_BACnetConstructedDataDefaultFadeTime) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetConstructedDataDefaultFadeTime) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetConstructedData, tagNumber uint8, objectTypeArgument BACnetObjectType, propertyIdentifierArgument BACnetPropertyIdentifier, arrayIndexArgument BACnetTagPayloadUnsignedInteger) (__bACnetConstructedDataDefaultFadeTime BACnetConstructedDataDefaultFadeTime, err error) {
	m.BACnetConstructedDataContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetConstructedDataDefaultFadeTime"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetConstructedDataDefaultFadeTime")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	defaultFadeTime, err := ReadSimpleField[BACnetApplicationTagUnsignedInteger](ctx, "defaultFadeTime", ReadComplex[BACnetApplicationTagUnsignedInteger](BACnetApplicationTagParseWithBufferProducer[BACnetApplicationTagUnsignedInteger](), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'defaultFadeTime' field"))
	}
	m.DefaultFadeTime = defaultFadeTime

	actualValue, err := ReadVirtualField[BACnetApplicationTagUnsignedInteger](ctx, "actualValue", (*BACnetApplicationTagUnsignedInteger)(nil), defaultFadeTime)
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'actualValue' field"))
	}
	_ = actualValue

	if closeErr := readBuffer.CloseContext("BACnetConstructedDataDefaultFadeTime"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetConstructedDataDefaultFadeTime")
	}

	return m, nil
}

func (m *_BACnetConstructedDataDefaultFadeTime) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetConstructedDataDefaultFadeTime) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetConstructedDataDefaultFadeTime"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetConstructedDataDefaultFadeTime")
		}

		if err := WriteSimpleField[BACnetApplicationTagUnsignedInteger](ctx, "defaultFadeTime", m.GetDefaultFadeTime(), WriteComplex[BACnetApplicationTagUnsignedInteger](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'defaultFadeTime' field")
		}
		// Virtual field
		actualValue := m.GetActualValue()
		_ = actualValue
		if _actualValueErr := writeBuffer.WriteVirtual(ctx, "actualValue", m.GetActualValue()); _actualValueErr != nil {
			return errors.Wrap(_actualValueErr, "Error serializing 'actualValue' field")
		}

		if popErr := writeBuffer.PopContext("BACnetConstructedDataDefaultFadeTime"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetConstructedDataDefaultFadeTime")
		}
		return nil
	}
	return m.BACnetConstructedDataContract.(*_BACnetConstructedData).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetConstructedDataDefaultFadeTime) IsBACnetConstructedDataDefaultFadeTime() {}

func (m *_BACnetConstructedDataDefaultFadeTime) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetConstructedDataDefaultFadeTime) deepCopy() *_BACnetConstructedDataDefaultFadeTime {
	if m == nil {
		return nil
	}
	_BACnetConstructedDataDefaultFadeTimeCopy := &_BACnetConstructedDataDefaultFadeTime{
		m.BACnetConstructedDataContract.(*_BACnetConstructedData).deepCopy(),
		utils.DeepCopy[BACnetApplicationTagUnsignedInteger](m.DefaultFadeTime),
	}
	_BACnetConstructedDataDefaultFadeTimeCopy.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = m
	return _BACnetConstructedDataDefaultFadeTimeCopy
}

func (m *_BACnetConstructedDataDefaultFadeTime) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
