/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetConstructedDataCountChangeTime is the corresponding interface of BACnetConstructedDataCountChangeTime
type BACnetConstructedDataCountChangeTime interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetConstructedData
	// GetCountChangeTime returns CountChangeTime (property field)
	GetCountChangeTime() BACnetDateTime
	// GetActualValue returns ActualValue (virtual field)
	GetActualValue() BACnetDateTime
	// IsBACnetConstructedDataCountChangeTime is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetConstructedDataCountChangeTime()
	// CreateBuilder creates a BACnetConstructedDataCountChangeTimeBuilder
	CreateBACnetConstructedDataCountChangeTimeBuilder() BACnetConstructedDataCountChangeTimeBuilder
}

// _BACnetConstructedDataCountChangeTime is the data-structure of this message
type _BACnetConstructedDataCountChangeTime struct {
	BACnetConstructedDataContract
	CountChangeTime BACnetDateTime
}

var _ BACnetConstructedDataCountChangeTime = (*_BACnetConstructedDataCountChangeTime)(nil)
var _ BACnetConstructedDataRequirements = (*_BACnetConstructedDataCountChangeTime)(nil)

// NewBACnetConstructedDataCountChangeTime factory function for _BACnetConstructedDataCountChangeTime
func NewBACnetConstructedDataCountChangeTime(openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag, countChangeTime BACnetDateTime, tagNumber uint8, arrayIndexArgument BACnetTagPayloadUnsignedInteger) *_BACnetConstructedDataCountChangeTime {
	if countChangeTime == nil {
		panic("countChangeTime of type BACnetDateTime for BACnetConstructedDataCountChangeTime must not be nil")
	}
	_result := &_BACnetConstructedDataCountChangeTime{
		BACnetConstructedDataContract: NewBACnetConstructedData(openingTag, peekedTagHeader, closingTag, tagNumber, arrayIndexArgument),
		CountChangeTime:               countChangeTime,
	}
	_result.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetConstructedDataCountChangeTimeBuilder is a builder for BACnetConstructedDataCountChangeTime
type BACnetConstructedDataCountChangeTimeBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(countChangeTime BACnetDateTime) BACnetConstructedDataCountChangeTimeBuilder
	// WithCountChangeTime adds CountChangeTime (property field)
	WithCountChangeTime(BACnetDateTime) BACnetConstructedDataCountChangeTimeBuilder
	// WithCountChangeTimeBuilder adds CountChangeTime (property field) which is build by the builder
	WithCountChangeTimeBuilder(func(BACnetDateTimeBuilder) BACnetDateTimeBuilder) BACnetConstructedDataCountChangeTimeBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetConstructedDataBuilder
	// Build builds the BACnetConstructedDataCountChangeTime or returns an error if something is wrong
	Build() (BACnetConstructedDataCountChangeTime, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetConstructedDataCountChangeTime
}

// NewBACnetConstructedDataCountChangeTimeBuilder() creates a BACnetConstructedDataCountChangeTimeBuilder
func NewBACnetConstructedDataCountChangeTimeBuilder() BACnetConstructedDataCountChangeTimeBuilder {
	return &_BACnetConstructedDataCountChangeTimeBuilder{_BACnetConstructedDataCountChangeTime: new(_BACnetConstructedDataCountChangeTime)}
}

type _BACnetConstructedDataCountChangeTimeBuilder struct {
	*_BACnetConstructedDataCountChangeTime

	parentBuilder *_BACnetConstructedDataBuilder

	err *utils.MultiError
}

var _ (BACnetConstructedDataCountChangeTimeBuilder) = (*_BACnetConstructedDataCountChangeTimeBuilder)(nil)

func (b *_BACnetConstructedDataCountChangeTimeBuilder) setParent(contract BACnetConstructedDataContract) {
	b.BACnetConstructedDataContract = contract
	contract.(*_BACnetConstructedData)._SubType = b._BACnetConstructedDataCountChangeTime
}

func (b *_BACnetConstructedDataCountChangeTimeBuilder) WithMandatoryFields(countChangeTime BACnetDateTime) BACnetConstructedDataCountChangeTimeBuilder {
	return b.WithCountChangeTime(countChangeTime)
}

func (b *_BACnetConstructedDataCountChangeTimeBuilder) WithCountChangeTime(countChangeTime BACnetDateTime) BACnetConstructedDataCountChangeTimeBuilder {
	b.CountChangeTime = countChangeTime
	return b
}

func (b *_BACnetConstructedDataCountChangeTimeBuilder) WithCountChangeTimeBuilder(builderSupplier func(BACnetDateTimeBuilder) BACnetDateTimeBuilder) BACnetConstructedDataCountChangeTimeBuilder {
	builder := builderSupplier(b.CountChangeTime.CreateBACnetDateTimeBuilder())
	var err error
	b.CountChangeTime, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "BACnetDateTimeBuilder failed"))
	}
	return b
}

func (b *_BACnetConstructedDataCountChangeTimeBuilder) Build() (BACnetConstructedDataCountChangeTime, error) {
	if b.CountChangeTime == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'countChangeTime' not set"))
	}
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._BACnetConstructedDataCountChangeTime.deepCopy(), nil
}

func (b *_BACnetConstructedDataCountChangeTimeBuilder) MustBuild() BACnetConstructedDataCountChangeTime {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetConstructedDataCountChangeTimeBuilder) Done() BACnetConstructedDataBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetConstructedDataBuilder().(*_BACnetConstructedDataBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetConstructedDataCountChangeTimeBuilder) buildForBACnetConstructedData() (BACnetConstructedData, error) {
	return b.Build()
}

func (b *_BACnetConstructedDataCountChangeTimeBuilder) DeepCopy() any {
	_copy := b.CreateBACnetConstructedDataCountChangeTimeBuilder().(*_BACnetConstructedDataCountChangeTimeBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateBACnetConstructedDataCountChangeTimeBuilder creates a BACnetConstructedDataCountChangeTimeBuilder
func (b *_BACnetConstructedDataCountChangeTime) CreateBACnetConstructedDataCountChangeTimeBuilder() BACnetConstructedDataCountChangeTimeBuilder {
	if b == nil {
		return NewBACnetConstructedDataCountChangeTimeBuilder()
	}
	return &_BACnetConstructedDataCountChangeTimeBuilder{_BACnetConstructedDataCountChangeTime: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_BACnetConstructedDataCountChangeTime) GetObjectTypeArgument() BACnetObjectType {
	return 0
}

func (m *_BACnetConstructedDataCountChangeTime) GetPropertyIdentifierArgument() BACnetPropertyIdentifier {
	return BACnetPropertyIdentifier_COUNT_CHANGE_TIME
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetConstructedDataCountChangeTime) GetParent() BACnetConstructedDataContract {
	return m.BACnetConstructedDataContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetConstructedDataCountChangeTime) GetCountChangeTime() BACnetDateTime {
	return m.CountChangeTime
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for virtual fields.
///////////////////////

func (m *_BACnetConstructedDataCountChangeTime) GetActualValue() BACnetDateTime {
	ctx := context.Background()
	_ = ctx
	return CastBACnetDateTime(m.GetCountChangeTime())
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetConstructedDataCountChangeTime(structType any) BACnetConstructedDataCountChangeTime {
	if casted, ok := structType.(BACnetConstructedDataCountChangeTime); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetConstructedDataCountChangeTime); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetConstructedDataCountChangeTime) GetTypeName() string {
	return "BACnetConstructedDataCountChangeTime"
}

func (m *_BACnetConstructedDataCountChangeTime) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetConstructedDataContract.(*_BACnetConstructedData).getLengthInBits(ctx))

	// Simple field (countChangeTime)
	lengthInBits += m.CountChangeTime.GetLengthInBits(ctx)

	// A virtual field doesn't have any in- or output.

	return lengthInBits
}

func (m *_BACnetConstructedDataCountChangeTime) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetConstructedDataCountChangeTime) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetConstructedData, tagNumber uint8, objectTypeArgument BACnetObjectType, propertyIdentifierArgument BACnetPropertyIdentifier, arrayIndexArgument BACnetTagPayloadUnsignedInteger) (__bACnetConstructedDataCountChangeTime BACnetConstructedDataCountChangeTime, err error) {
	m.BACnetConstructedDataContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetConstructedDataCountChangeTime"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetConstructedDataCountChangeTime")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	countChangeTime, err := ReadSimpleField[BACnetDateTime](ctx, "countChangeTime", ReadComplex[BACnetDateTime](BACnetDateTimeParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'countChangeTime' field"))
	}
	m.CountChangeTime = countChangeTime

	actualValue, err := ReadVirtualField[BACnetDateTime](ctx, "actualValue", (*BACnetDateTime)(nil), countChangeTime)
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'actualValue' field"))
	}
	_ = actualValue

	if closeErr := readBuffer.CloseContext("BACnetConstructedDataCountChangeTime"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetConstructedDataCountChangeTime")
	}

	return m, nil
}

func (m *_BACnetConstructedDataCountChangeTime) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetConstructedDataCountChangeTime) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetConstructedDataCountChangeTime"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetConstructedDataCountChangeTime")
		}

		if err := WriteSimpleField[BACnetDateTime](ctx, "countChangeTime", m.GetCountChangeTime(), WriteComplex[BACnetDateTime](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'countChangeTime' field")
		}
		// Virtual field
		actualValue := m.GetActualValue()
		_ = actualValue
		if _actualValueErr := writeBuffer.WriteVirtual(ctx, "actualValue", m.GetActualValue()); _actualValueErr != nil {
			return errors.Wrap(_actualValueErr, "Error serializing 'actualValue' field")
		}

		if popErr := writeBuffer.PopContext("BACnetConstructedDataCountChangeTime"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetConstructedDataCountChangeTime")
		}
		return nil
	}
	return m.BACnetConstructedDataContract.(*_BACnetConstructedData).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetConstructedDataCountChangeTime) IsBACnetConstructedDataCountChangeTime() {}

func (m *_BACnetConstructedDataCountChangeTime) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetConstructedDataCountChangeTime) deepCopy() *_BACnetConstructedDataCountChangeTime {
	if m == nil {
		return nil
	}
	_BACnetConstructedDataCountChangeTimeCopy := &_BACnetConstructedDataCountChangeTime{
		m.BACnetConstructedDataContract.(*_BACnetConstructedData).deepCopy(),
		utils.DeepCopy[BACnetDateTime](m.CountChangeTime),
	}
	_BACnetConstructedDataCountChangeTimeCopy.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = m
	return _BACnetConstructedDataCountChangeTimeCopy
}

func (m *_BACnetConstructedDataCountChangeTime) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
