/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetConstructedDataChannelAll is the corresponding interface of BACnetConstructedDataChannelAll
type BACnetConstructedDataChannelAll interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetConstructedData
	// IsBACnetConstructedDataChannelAll is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetConstructedDataChannelAll()
	// CreateBuilder creates a BACnetConstructedDataChannelAllBuilder
	CreateBACnetConstructedDataChannelAllBuilder() BACnetConstructedDataChannelAllBuilder
}

// _BACnetConstructedDataChannelAll is the data-structure of this message
type _BACnetConstructedDataChannelAll struct {
	BACnetConstructedDataContract
}

var _ BACnetConstructedDataChannelAll = (*_BACnetConstructedDataChannelAll)(nil)
var _ BACnetConstructedDataRequirements = (*_BACnetConstructedDataChannelAll)(nil)

// NewBACnetConstructedDataChannelAll factory function for _BACnetConstructedDataChannelAll
func NewBACnetConstructedDataChannelAll(openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag, tagNumber uint8, arrayIndexArgument BACnetTagPayloadUnsignedInteger) *_BACnetConstructedDataChannelAll {
	_result := &_BACnetConstructedDataChannelAll{
		BACnetConstructedDataContract: NewBACnetConstructedData(openingTag, peekedTagHeader, closingTag, tagNumber, arrayIndexArgument),
	}
	_result.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetConstructedDataChannelAllBuilder is a builder for BACnetConstructedDataChannelAll
type BACnetConstructedDataChannelAllBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields() BACnetConstructedDataChannelAllBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetConstructedDataBuilder
	// Build builds the BACnetConstructedDataChannelAll or returns an error if something is wrong
	Build() (BACnetConstructedDataChannelAll, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetConstructedDataChannelAll
}

// NewBACnetConstructedDataChannelAllBuilder() creates a BACnetConstructedDataChannelAllBuilder
func NewBACnetConstructedDataChannelAllBuilder() BACnetConstructedDataChannelAllBuilder {
	return &_BACnetConstructedDataChannelAllBuilder{_BACnetConstructedDataChannelAll: new(_BACnetConstructedDataChannelAll)}
}

type _BACnetConstructedDataChannelAllBuilder struct {
	*_BACnetConstructedDataChannelAll

	parentBuilder *_BACnetConstructedDataBuilder

	err *utils.MultiError
}

var _ (BACnetConstructedDataChannelAllBuilder) = (*_BACnetConstructedDataChannelAllBuilder)(nil)

func (b *_BACnetConstructedDataChannelAllBuilder) setParent(contract BACnetConstructedDataContract) {
	b.BACnetConstructedDataContract = contract
	contract.(*_BACnetConstructedData)._SubType = b._BACnetConstructedDataChannelAll
}

func (b *_BACnetConstructedDataChannelAllBuilder) WithMandatoryFields() BACnetConstructedDataChannelAllBuilder {
	return b
}

func (b *_BACnetConstructedDataChannelAllBuilder) Build() (BACnetConstructedDataChannelAll, error) {
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._BACnetConstructedDataChannelAll.deepCopy(), nil
}

func (b *_BACnetConstructedDataChannelAllBuilder) MustBuild() BACnetConstructedDataChannelAll {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetConstructedDataChannelAllBuilder) Done() BACnetConstructedDataBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetConstructedDataBuilder().(*_BACnetConstructedDataBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetConstructedDataChannelAllBuilder) buildForBACnetConstructedData() (BACnetConstructedData, error) {
	return b.Build()
}

func (b *_BACnetConstructedDataChannelAllBuilder) DeepCopy() any {
	_copy := b.CreateBACnetConstructedDataChannelAllBuilder().(*_BACnetConstructedDataChannelAllBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateBACnetConstructedDataChannelAllBuilder creates a BACnetConstructedDataChannelAllBuilder
func (b *_BACnetConstructedDataChannelAll) CreateBACnetConstructedDataChannelAllBuilder() BACnetConstructedDataChannelAllBuilder {
	if b == nil {
		return NewBACnetConstructedDataChannelAllBuilder()
	}
	return &_BACnetConstructedDataChannelAllBuilder{_BACnetConstructedDataChannelAll: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_BACnetConstructedDataChannelAll) GetObjectTypeArgument() BACnetObjectType {
	return BACnetObjectType_CHANNEL
}

func (m *_BACnetConstructedDataChannelAll) GetPropertyIdentifierArgument() BACnetPropertyIdentifier {
	return BACnetPropertyIdentifier_ALL
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetConstructedDataChannelAll) GetParent() BACnetConstructedDataContract {
	return m.BACnetConstructedDataContract
}

// Deprecated: use the interface for direct cast
func CastBACnetConstructedDataChannelAll(structType any) BACnetConstructedDataChannelAll {
	if casted, ok := structType.(BACnetConstructedDataChannelAll); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetConstructedDataChannelAll); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetConstructedDataChannelAll) GetTypeName() string {
	return "BACnetConstructedDataChannelAll"
}

func (m *_BACnetConstructedDataChannelAll) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetConstructedDataContract.(*_BACnetConstructedData).getLengthInBits(ctx))

	return lengthInBits
}

func (m *_BACnetConstructedDataChannelAll) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetConstructedDataChannelAll) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetConstructedData, tagNumber uint8, objectTypeArgument BACnetObjectType, propertyIdentifierArgument BACnetPropertyIdentifier, arrayIndexArgument BACnetTagPayloadUnsignedInteger) (__bACnetConstructedDataChannelAll BACnetConstructedDataChannelAll, err error) {
	m.BACnetConstructedDataContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetConstructedDataChannelAll"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetConstructedDataChannelAll")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	// Validation
	if !(bool((1) == (2))) {
		return nil, errors.WithStack(utils.ParseValidationError{Message: "All should never occur in context of constructed data. If it does please report"})
	}

	if closeErr := readBuffer.CloseContext("BACnetConstructedDataChannelAll"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetConstructedDataChannelAll")
	}

	return m, nil
}

func (m *_BACnetConstructedDataChannelAll) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetConstructedDataChannelAll) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetConstructedDataChannelAll"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetConstructedDataChannelAll")
		}

		if popErr := writeBuffer.PopContext("BACnetConstructedDataChannelAll"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetConstructedDataChannelAll")
		}
		return nil
	}
	return m.BACnetConstructedDataContract.(*_BACnetConstructedData).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetConstructedDataChannelAll) IsBACnetConstructedDataChannelAll() {}

func (m *_BACnetConstructedDataChannelAll) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetConstructedDataChannelAll) deepCopy() *_BACnetConstructedDataChannelAll {
	if m == nil {
		return nil
	}
	_BACnetConstructedDataChannelAllCopy := &_BACnetConstructedDataChannelAll{
		m.BACnetConstructedDataContract.(*_BACnetConstructedData).deepCopy(),
	}
	_BACnetConstructedDataChannelAllCopy.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = m
	return _BACnetConstructedDataChannelAllCopy
}

func (m *_BACnetConstructedDataChannelAll) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
