/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetConstructedDataCarLoad is the corresponding interface of BACnetConstructedDataCarLoad
type BACnetConstructedDataCarLoad interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetConstructedData
	// GetCarLoad returns CarLoad (property field)
	GetCarLoad() BACnetApplicationTagReal
	// GetActualValue returns ActualValue (virtual field)
	GetActualValue() BACnetApplicationTagReal
	// IsBACnetConstructedDataCarLoad is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetConstructedDataCarLoad()
	// CreateBuilder creates a BACnetConstructedDataCarLoadBuilder
	CreateBACnetConstructedDataCarLoadBuilder() BACnetConstructedDataCarLoadBuilder
}

// _BACnetConstructedDataCarLoad is the data-structure of this message
type _BACnetConstructedDataCarLoad struct {
	BACnetConstructedDataContract
	CarLoad BACnetApplicationTagReal
}

var _ BACnetConstructedDataCarLoad = (*_BACnetConstructedDataCarLoad)(nil)
var _ BACnetConstructedDataRequirements = (*_BACnetConstructedDataCarLoad)(nil)

// NewBACnetConstructedDataCarLoad factory function for _BACnetConstructedDataCarLoad
func NewBACnetConstructedDataCarLoad(openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag, carLoad BACnetApplicationTagReal, tagNumber uint8, arrayIndexArgument BACnetTagPayloadUnsignedInteger) *_BACnetConstructedDataCarLoad {
	if carLoad == nil {
		panic("carLoad of type BACnetApplicationTagReal for BACnetConstructedDataCarLoad must not be nil")
	}
	_result := &_BACnetConstructedDataCarLoad{
		BACnetConstructedDataContract: NewBACnetConstructedData(openingTag, peekedTagHeader, closingTag, tagNumber, arrayIndexArgument),
		CarLoad:                       carLoad,
	}
	_result.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetConstructedDataCarLoadBuilder is a builder for BACnetConstructedDataCarLoad
type BACnetConstructedDataCarLoadBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(carLoad BACnetApplicationTagReal) BACnetConstructedDataCarLoadBuilder
	// WithCarLoad adds CarLoad (property field)
	WithCarLoad(BACnetApplicationTagReal) BACnetConstructedDataCarLoadBuilder
	// WithCarLoadBuilder adds CarLoad (property field) which is build by the builder
	WithCarLoadBuilder(func(BACnetApplicationTagRealBuilder) BACnetApplicationTagRealBuilder) BACnetConstructedDataCarLoadBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetConstructedDataBuilder
	// Build builds the BACnetConstructedDataCarLoad or returns an error if something is wrong
	Build() (BACnetConstructedDataCarLoad, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetConstructedDataCarLoad
}

// NewBACnetConstructedDataCarLoadBuilder() creates a BACnetConstructedDataCarLoadBuilder
func NewBACnetConstructedDataCarLoadBuilder() BACnetConstructedDataCarLoadBuilder {
	return &_BACnetConstructedDataCarLoadBuilder{_BACnetConstructedDataCarLoad: new(_BACnetConstructedDataCarLoad)}
}

type _BACnetConstructedDataCarLoadBuilder struct {
	*_BACnetConstructedDataCarLoad

	parentBuilder *_BACnetConstructedDataBuilder

	err *utils.MultiError
}

var _ (BACnetConstructedDataCarLoadBuilder) = (*_BACnetConstructedDataCarLoadBuilder)(nil)

func (b *_BACnetConstructedDataCarLoadBuilder) setParent(contract BACnetConstructedDataContract) {
	b.BACnetConstructedDataContract = contract
	contract.(*_BACnetConstructedData)._SubType = b._BACnetConstructedDataCarLoad
}

func (b *_BACnetConstructedDataCarLoadBuilder) WithMandatoryFields(carLoad BACnetApplicationTagReal) BACnetConstructedDataCarLoadBuilder {
	return b.WithCarLoad(carLoad)
}

func (b *_BACnetConstructedDataCarLoadBuilder) WithCarLoad(carLoad BACnetApplicationTagReal) BACnetConstructedDataCarLoadBuilder {
	b.CarLoad = carLoad
	return b
}

func (b *_BACnetConstructedDataCarLoadBuilder) WithCarLoadBuilder(builderSupplier func(BACnetApplicationTagRealBuilder) BACnetApplicationTagRealBuilder) BACnetConstructedDataCarLoadBuilder {
	builder := builderSupplier(b.CarLoad.CreateBACnetApplicationTagRealBuilder())
	var err error
	b.CarLoad, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "BACnetApplicationTagRealBuilder failed"))
	}
	return b
}

func (b *_BACnetConstructedDataCarLoadBuilder) Build() (BACnetConstructedDataCarLoad, error) {
	if b.CarLoad == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'carLoad' not set"))
	}
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._BACnetConstructedDataCarLoad.deepCopy(), nil
}

func (b *_BACnetConstructedDataCarLoadBuilder) MustBuild() BACnetConstructedDataCarLoad {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetConstructedDataCarLoadBuilder) Done() BACnetConstructedDataBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetConstructedDataBuilder().(*_BACnetConstructedDataBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetConstructedDataCarLoadBuilder) buildForBACnetConstructedData() (BACnetConstructedData, error) {
	return b.Build()
}

func (b *_BACnetConstructedDataCarLoadBuilder) DeepCopy() any {
	_copy := b.CreateBACnetConstructedDataCarLoadBuilder().(*_BACnetConstructedDataCarLoadBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateBACnetConstructedDataCarLoadBuilder creates a BACnetConstructedDataCarLoadBuilder
func (b *_BACnetConstructedDataCarLoad) CreateBACnetConstructedDataCarLoadBuilder() BACnetConstructedDataCarLoadBuilder {
	if b == nil {
		return NewBACnetConstructedDataCarLoadBuilder()
	}
	return &_BACnetConstructedDataCarLoadBuilder{_BACnetConstructedDataCarLoad: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_BACnetConstructedDataCarLoad) GetObjectTypeArgument() BACnetObjectType {
	return 0
}

func (m *_BACnetConstructedDataCarLoad) GetPropertyIdentifierArgument() BACnetPropertyIdentifier {
	return BACnetPropertyIdentifier_CAR_LOAD
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetConstructedDataCarLoad) GetParent() BACnetConstructedDataContract {
	return m.BACnetConstructedDataContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetConstructedDataCarLoad) GetCarLoad() BACnetApplicationTagReal {
	return m.CarLoad
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for virtual fields.
///////////////////////

func (m *_BACnetConstructedDataCarLoad) GetActualValue() BACnetApplicationTagReal {
	ctx := context.Background()
	_ = ctx
	return CastBACnetApplicationTagReal(m.GetCarLoad())
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetConstructedDataCarLoad(structType any) BACnetConstructedDataCarLoad {
	if casted, ok := structType.(BACnetConstructedDataCarLoad); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetConstructedDataCarLoad); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetConstructedDataCarLoad) GetTypeName() string {
	return "BACnetConstructedDataCarLoad"
}

func (m *_BACnetConstructedDataCarLoad) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetConstructedDataContract.(*_BACnetConstructedData).getLengthInBits(ctx))

	// Simple field (carLoad)
	lengthInBits += m.CarLoad.GetLengthInBits(ctx)

	// A virtual field doesn't have any in- or output.

	return lengthInBits
}

func (m *_BACnetConstructedDataCarLoad) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetConstructedDataCarLoad) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetConstructedData, tagNumber uint8, objectTypeArgument BACnetObjectType, propertyIdentifierArgument BACnetPropertyIdentifier, arrayIndexArgument BACnetTagPayloadUnsignedInteger) (__bACnetConstructedDataCarLoad BACnetConstructedDataCarLoad, err error) {
	m.BACnetConstructedDataContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetConstructedDataCarLoad"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetConstructedDataCarLoad")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	carLoad, err := ReadSimpleField[BACnetApplicationTagReal](ctx, "carLoad", ReadComplex[BACnetApplicationTagReal](BACnetApplicationTagParseWithBufferProducer[BACnetApplicationTagReal](), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'carLoad' field"))
	}
	m.CarLoad = carLoad

	actualValue, err := ReadVirtualField[BACnetApplicationTagReal](ctx, "actualValue", (*BACnetApplicationTagReal)(nil), carLoad)
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'actualValue' field"))
	}
	_ = actualValue

	if closeErr := readBuffer.CloseContext("BACnetConstructedDataCarLoad"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetConstructedDataCarLoad")
	}

	return m, nil
}

func (m *_BACnetConstructedDataCarLoad) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetConstructedDataCarLoad) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetConstructedDataCarLoad"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetConstructedDataCarLoad")
		}

		if err := WriteSimpleField[BACnetApplicationTagReal](ctx, "carLoad", m.GetCarLoad(), WriteComplex[BACnetApplicationTagReal](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'carLoad' field")
		}
		// Virtual field
		actualValue := m.GetActualValue()
		_ = actualValue
		if _actualValueErr := writeBuffer.WriteVirtual(ctx, "actualValue", m.GetActualValue()); _actualValueErr != nil {
			return errors.Wrap(_actualValueErr, "Error serializing 'actualValue' field")
		}

		if popErr := writeBuffer.PopContext("BACnetConstructedDataCarLoad"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetConstructedDataCarLoad")
		}
		return nil
	}
	return m.BACnetConstructedDataContract.(*_BACnetConstructedData).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetConstructedDataCarLoad) IsBACnetConstructedDataCarLoad() {}

func (m *_BACnetConstructedDataCarLoad) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetConstructedDataCarLoad) deepCopy() *_BACnetConstructedDataCarLoad {
	if m == nil {
		return nil
	}
	_BACnetConstructedDataCarLoadCopy := &_BACnetConstructedDataCarLoad{
		m.BACnetConstructedDataContract.(*_BACnetConstructedData).deepCopy(),
		utils.DeepCopy[BACnetApplicationTagReal](m.CarLoad),
	}
	_BACnetConstructedDataCarLoadCopy.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = m
	return _BACnetConstructedDataCarLoadCopy
}

func (m *_BACnetConstructedDataCarLoad) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
