/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetConstructedDataBackupAndRestoreState is the corresponding interface of BACnetConstructedDataBackupAndRestoreState
type BACnetConstructedDataBackupAndRestoreState interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetConstructedData
	// GetBackupAndRestoreState returns BackupAndRestoreState (property field)
	GetBackupAndRestoreState() BACnetBackupStateTagged
	// GetActualValue returns ActualValue (virtual field)
	GetActualValue() BACnetBackupStateTagged
	// IsBACnetConstructedDataBackupAndRestoreState is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetConstructedDataBackupAndRestoreState()
	// CreateBuilder creates a BACnetConstructedDataBackupAndRestoreStateBuilder
	CreateBACnetConstructedDataBackupAndRestoreStateBuilder() BACnetConstructedDataBackupAndRestoreStateBuilder
}

// _BACnetConstructedDataBackupAndRestoreState is the data-structure of this message
type _BACnetConstructedDataBackupAndRestoreState struct {
	BACnetConstructedDataContract
	BackupAndRestoreState BACnetBackupStateTagged
}

var _ BACnetConstructedDataBackupAndRestoreState = (*_BACnetConstructedDataBackupAndRestoreState)(nil)
var _ BACnetConstructedDataRequirements = (*_BACnetConstructedDataBackupAndRestoreState)(nil)

// NewBACnetConstructedDataBackupAndRestoreState factory function for _BACnetConstructedDataBackupAndRestoreState
func NewBACnetConstructedDataBackupAndRestoreState(openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag, backupAndRestoreState BACnetBackupStateTagged, tagNumber uint8, arrayIndexArgument BACnetTagPayloadUnsignedInteger) *_BACnetConstructedDataBackupAndRestoreState {
	if backupAndRestoreState == nil {
		panic("backupAndRestoreState of type BACnetBackupStateTagged for BACnetConstructedDataBackupAndRestoreState must not be nil")
	}
	_result := &_BACnetConstructedDataBackupAndRestoreState{
		BACnetConstructedDataContract: NewBACnetConstructedData(openingTag, peekedTagHeader, closingTag, tagNumber, arrayIndexArgument),
		BackupAndRestoreState:         backupAndRestoreState,
	}
	_result.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetConstructedDataBackupAndRestoreStateBuilder is a builder for BACnetConstructedDataBackupAndRestoreState
type BACnetConstructedDataBackupAndRestoreStateBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(backupAndRestoreState BACnetBackupStateTagged) BACnetConstructedDataBackupAndRestoreStateBuilder
	// WithBackupAndRestoreState adds BackupAndRestoreState (property field)
	WithBackupAndRestoreState(BACnetBackupStateTagged) BACnetConstructedDataBackupAndRestoreStateBuilder
	// WithBackupAndRestoreStateBuilder adds BackupAndRestoreState (property field) which is build by the builder
	WithBackupAndRestoreStateBuilder(func(BACnetBackupStateTaggedBuilder) BACnetBackupStateTaggedBuilder) BACnetConstructedDataBackupAndRestoreStateBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetConstructedDataBuilder
	// Build builds the BACnetConstructedDataBackupAndRestoreState or returns an error if something is wrong
	Build() (BACnetConstructedDataBackupAndRestoreState, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetConstructedDataBackupAndRestoreState
}

// NewBACnetConstructedDataBackupAndRestoreStateBuilder() creates a BACnetConstructedDataBackupAndRestoreStateBuilder
func NewBACnetConstructedDataBackupAndRestoreStateBuilder() BACnetConstructedDataBackupAndRestoreStateBuilder {
	return &_BACnetConstructedDataBackupAndRestoreStateBuilder{_BACnetConstructedDataBackupAndRestoreState: new(_BACnetConstructedDataBackupAndRestoreState)}
}

type _BACnetConstructedDataBackupAndRestoreStateBuilder struct {
	*_BACnetConstructedDataBackupAndRestoreState

	parentBuilder *_BACnetConstructedDataBuilder

	err *utils.MultiError
}

var _ (BACnetConstructedDataBackupAndRestoreStateBuilder) = (*_BACnetConstructedDataBackupAndRestoreStateBuilder)(nil)

func (b *_BACnetConstructedDataBackupAndRestoreStateBuilder) setParent(contract BACnetConstructedDataContract) {
	b.BACnetConstructedDataContract = contract
	contract.(*_BACnetConstructedData)._SubType = b._BACnetConstructedDataBackupAndRestoreState
}

func (b *_BACnetConstructedDataBackupAndRestoreStateBuilder) WithMandatoryFields(backupAndRestoreState BACnetBackupStateTagged) BACnetConstructedDataBackupAndRestoreStateBuilder {
	return b.WithBackupAndRestoreState(backupAndRestoreState)
}

func (b *_BACnetConstructedDataBackupAndRestoreStateBuilder) WithBackupAndRestoreState(backupAndRestoreState BACnetBackupStateTagged) BACnetConstructedDataBackupAndRestoreStateBuilder {
	b.BackupAndRestoreState = backupAndRestoreState
	return b
}

func (b *_BACnetConstructedDataBackupAndRestoreStateBuilder) WithBackupAndRestoreStateBuilder(builderSupplier func(BACnetBackupStateTaggedBuilder) BACnetBackupStateTaggedBuilder) BACnetConstructedDataBackupAndRestoreStateBuilder {
	builder := builderSupplier(b.BackupAndRestoreState.CreateBACnetBackupStateTaggedBuilder())
	var err error
	b.BackupAndRestoreState, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "BACnetBackupStateTaggedBuilder failed"))
	}
	return b
}

func (b *_BACnetConstructedDataBackupAndRestoreStateBuilder) Build() (BACnetConstructedDataBackupAndRestoreState, error) {
	if b.BackupAndRestoreState == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'backupAndRestoreState' not set"))
	}
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._BACnetConstructedDataBackupAndRestoreState.deepCopy(), nil
}

func (b *_BACnetConstructedDataBackupAndRestoreStateBuilder) MustBuild() BACnetConstructedDataBackupAndRestoreState {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetConstructedDataBackupAndRestoreStateBuilder) Done() BACnetConstructedDataBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetConstructedDataBuilder().(*_BACnetConstructedDataBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetConstructedDataBackupAndRestoreStateBuilder) buildForBACnetConstructedData() (BACnetConstructedData, error) {
	return b.Build()
}

func (b *_BACnetConstructedDataBackupAndRestoreStateBuilder) DeepCopy() any {
	_copy := b.CreateBACnetConstructedDataBackupAndRestoreStateBuilder().(*_BACnetConstructedDataBackupAndRestoreStateBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateBACnetConstructedDataBackupAndRestoreStateBuilder creates a BACnetConstructedDataBackupAndRestoreStateBuilder
func (b *_BACnetConstructedDataBackupAndRestoreState) CreateBACnetConstructedDataBackupAndRestoreStateBuilder() BACnetConstructedDataBackupAndRestoreStateBuilder {
	if b == nil {
		return NewBACnetConstructedDataBackupAndRestoreStateBuilder()
	}
	return &_BACnetConstructedDataBackupAndRestoreStateBuilder{_BACnetConstructedDataBackupAndRestoreState: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_BACnetConstructedDataBackupAndRestoreState) GetObjectTypeArgument() BACnetObjectType {
	return 0
}

func (m *_BACnetConstructedDataBackupAndRestoreState) GetPropertyIdentifierArgument() BACnetPropertyIdentifier {
	return BACnetPropertyIdentifier_BACKUP_AND_RESTORE_STATE
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetConstructedDataBackupAndRestoreState) GetParent() BACnetConstructedDataContract {
	return m.BACnetConstructedDataContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetConstructedDataBackupAndRestoreState) GetBackupAndRestoreState() BACnetBackupStateTagged {
	return m.BackupAndRestoreState
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for virtual fields.
///////////////////////

func (m *_BACnetConstructedDataBackupAndRestoreState) GetActualValue() BACnetBackupStateTagged {
	ctx := context.Background()
	_ = ctx
	return CastBACnetBackupStateTagged(m.GetBackupAndRestoreState())
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetConstructedDataBackupAndRestoreState(structType any) BACnetConstructedDataBackupAndRestoreState {
	if casted, ok := structType.(BACnetConstructedDataBackupAndRestoreState); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetConstructedDataBackupAndRestoreState); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetConstructedDataBackupAndRestoreState) GetTypeName() string {
	return "BACnetConstructedDataBackupAndRestoreState"
}

func (m *_BACnetConstructedDataBackupAndRestoreState) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetConstructedDataContract.(*_BACnetConstructedData).getLengthInBits(ctx))

	// Simple field (backupAndRestoreState)
	lengthInBits += m.BackupAndRestoreState.GetLengthInBits(ctx)

	// A virtual field doesn't have any in- or output.

	return lengthInBits
}

func (m *_BACnetConstructedDataBackupAndRestoreState) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetConstructedDataBackupAndRestoreState) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetConstructedData, tagNumber uint8, objectTypeArgument BACnetObjectType, propertyIdentifierArgument BACnetPropertyIdentifier, arrayIndexArgument BACnetTagPayloadUnsignedInteger) (__bACnetConstructedDataBackupAndRestoreState BACnetConstructedDataBackupAndRestoreState, err error) {
	m.BACnetConstructedDataContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetConstructedDataBackupAndRestoreState"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetConstructedDataBackupAndRestoreState")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	backupAndRestoreState, err := ReadSimpleField[BACnetBackupStateTagged](ctx, "backupAndRestoreState", ReadComplex[BACnetBackupStateTagged](BACnetBackupStateTaggedParseWithBufferProducer((uint8)(uint8(0)), (TagClass)(TagClass_APPLICATION_TAGS)), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'backupAndRestoreState' field"))
	}
	m.BackupAndRestoreState = backupAndRestoreState

	actualValue, err := ReadVirtualField[BACnetBackupStateTagged](ctx, "actualValue", (*BACnetBackupStateTagged)(nil), backupAndRestoreState)
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'actualValue' field"))
	}
	_ = actualValue

	if closeErr := readBuffer.CloseContext("BACnetConstructedDataBackupAndRestoreState"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetConstructedDataBackupAndRestoreState")
	}

	return m, nil
}

func (m *_BACnetConstructedDataBackupAndRestoreState) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetConstructedDataBackupAndRestoreState) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetConstructedDataBackupAndRestoreState"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetConstructedDataBackupAndRestoreState")
		}

		if err := WriteSimpleField[BACnetBackupStateTagged](ctx, "backupAndRestoreState", m.GetBackupAndRestoreState(), WriteComplex[BACnetBackupStateTagged](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'backupAndRestoreState' field")
		}
		// Virtual field
		actualValue := m.GetActualValue()
		_ = actualValue
		if _actualValueErr := writeBuffer.WriteVirtual(ctx, "actualValue", m.GetActualValue()); _actualValueErr != nil {
			return errors.Wrap(_actualValueErr, "Error serializing 'actualValue' field")
		}

		if popErr := writeBuffer.PopContext("BACnetConstructedDataBackupAndRestoreState"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetConstructedDataBackupAndRestoreState")
		}
		return nil
	}
	return m.BACnetConstructedDataContract.(*_BACnetConstructedData).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetConstructedDataBackupAndRestoreState) IsBACnetConstructedDataBackupAndRestoreState() {
}

func (m *_BACnetConstructedDataBackupAndRestoreState) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetConstructedDataBackupAndRestoreState) deepCopy() *_BACnetConstructedDataBackupAndRestoreState {
	if m == nil {
		return nil
	}
	_BACnetConstructedDataBackupAndRestoreStateCopy := &_BACnetConstructedDataBackupAndRestoreState{
		m.BACnetConstructedDataContract.(*_BACnetConstructedData).deepCopy(),
		utils.DeepCopy[BACnetBackupStateTagged](m.BackupAndRestoreState),
	}
	_BACnetConstructedDataBackupAndRestoreStateCopy.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = m
	return _BACnetConstructedDataBackupAndRestoreStateCopy
}

func (m *_BACnetConstructedDataBackupAndRestoreState) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
