/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetConstructedDataAutoSlaveDiscovery is the corresponding interface of BACnetConstructedDataAutoSlaveDiscovery
type BACnetConstructedDataAutoSlaveDiscovery interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetConstructedData
	// GetAutoSlaveDiscovery returns AutoSlaveDiscovery (property field)
	GetAutoSlaveDiscovery() BACnetApplicationTagBoolean
	// GetActualValue returns ActualValue (virtual field)
	GetActualValue() BACnetApplicationTagBoolean
	// IsBACnetConstructedDataAutoSlaveDiscovery is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetConstructedDataAutoSlaveDiscovery()
	// CreateBuilder creates a BACnetConstructedDataAutoSlaveDiscoveryBuilder
	CreateBACnetConstructedDataAutoSlaveDiscoveryBuilder() BACnetConstructedDataAutoSlaveDiscoveryBuilder
}

// _BACnetConstructedDataAutoSlaveDiscovery is the data-structure of this message
type _BACnetConstructedDataAutoSlaveDiscovery struct {
	BACnetConstructedDataContract
	AutoSlaveDiscovery BACnetApplicationTagBoolean
}

var _ BACnetConstructedDataAutoSlaveDiscovery = (*_BACnetConstructedDataAutoSlaveDiscovery)(nil)
var _ BACnetConstructedDataRequirements = (*_BACnetConstructedDataAutoSlaveDiscovery)(nil)

// NewBACnetConstructedDataAutoSlaveDiscovery factory function for _BACnetConstructedDataAutoSlaveDiscovery
func NewBACnetConstructedDataAutoSlaveDiscovery(openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag, autoSlaveDiscovery BACnetApplicationTagBoolean, tagNumber uint8, arrayIndexArgument BACnetTagPayloadUnsignedInteger) *_BACnetConstructedDataAutoSlaveDiscovery {
	if autoSlaveDiscovery == nil {
		panic("autoSlaveDiscovery of type BACnetApplicationTagBoolean for BACnetConstructedDataAutoSlaveDiscovery must not be nil")
	}
	_result := &_BACnetConstructedDataAutoSlaveDiscovery{
		BACnetConstructedDataContract: NewBACnetConstructedData(openingTag, peekedTagHeader, closingTag, tagNumber, arrayIndexArgument),
		AutoSlaveDiscovery:            autoSlaveDiscovery,
	}
	_result.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetConstructedDataAutoSlaveDiscoveryBuilder is a builder for BACnetConstructedDataAutoSlaveDiscovery
type BACnetConstructedDataAutoSlaveDiscoveryBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(autoSlaveDiscovery BACnetApplicationTagBoolean) BACnetConstructedDataAutoSlaveDiscoveryBuilder
	// WithAutoSlaveDiscovery adds AutoSlaveDiscovery (property field)
	WithAutoSlaveDiscovery(BACnetApplicationTagBoolean) BACnetConstructedDataAutoSlaveDiscoveryBuilder
	// WithAutoSlaveDiscoveryBuilder adds AutoSlaveDiscovery (property field) which is build by the builder
	WithAutoSlaveDiscoveryBuilder(func(BACnetApplicationTagBooleanBuilder) BACnetApplicationTagBooleanBuilder) BACnetConstructedDataAutoSlaveDiscoveryBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetConstructedDataBuilder
	// Build builds the BACnetConstructedDataAutoSlaveDiscovery or returns an error if something is wrong
	Build() (BACnetConstructedDataAutoSlaveDiscovery, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetConstructedDataAutoSlaveDiscovery
}

// NewBACnetConstructedDataAutoSlaveDiscoveryBuilder() creates a BACnetConstructedDataAutoSlaveDiscoveryBuilder
func NewBACnetConstructedDataAutoSlaveDiscoveryBuilder() BACnetConstructedDataAutoSlaveDiscoveryBuilder {
	return &_BACnetConstructedDataAutoSlaveDiscoveryBuilder{_BACnetConstructedDataAutoSlaveDiscovery: new(_BACnetConstructedDataAutoSlaveDiscovery)}
}

type _BACnetConstructedDataAutoSlaveDiscoveryBuilder struct {
	*_BACnetConstructedDataAutoSlaveDiscovery

	parentBuilder *_BACnetConstructedDataBuilder

	err *utils.MultiError
}

var _ (BACnetConstructedDataAutoSlaveDiscoveryBuilder) = (*_BACnetConstructedDataAutoSlaveDiscoveryBuilder)(nil)

func (b *_BACnetConstructedDataAutoSlaveDiscoveryBuilder) setParent(contract BACnetConstructedDataContract) {
	b.BACnetConstructedDataContract = contract
	contract.(*_BACnetConstructedData)._SubType = b._BACnetConstructedDataAutoSlaveDiscovery
}

func (b *_BACnetConstructedDataAutoSlaveDiscoveryBuilder) WithMandatoryFields(autoSlaveDiscovery BACnetApplicationTagBoolean) BACnetConstructedDataAutoSlaveDiscoveryBuilder {
	return b.WithAutoSlaveDiscovery(autoSlaveDiscovery)
}

func (b *_BACnetConstructedDataAutoSlaveDiscoveryBuilder) WithAutoSlaveDiscovery(autoSlaveDiscovery BACnetApplicationTagBoolean) BACnetConstructedDataAutoSlaveDiscoveryBuilder {
	b.AutoSlaveDiscovery = autoSlaveDiscovery
	return b
}

func (b *_BACnetConstructedDataAutoSlaveDiscoveryBuilder) WithAutoSlaveDiscoveryBuilder(builderSupplier func(BACnetApplicationTagBooleanBuilder) BACnetApplicationTagBooleanBuilder) BACnetConstructedDataAutoSlaveDiscoveryBuilder {
	builder := builderSupplier(b.AutoSlaveDiscovery.CreateBACnetApplicationTagBooleanBuilder())
	var err error
	b.AutoSlaveDiscovery, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "BACnetApplicationTagBooleanBuilder failed"))
	}
	return b
}

func (b *_BACnetConstructedDataAutoSlaveDiscoveryBuilder) Build() (BACnetConstructedDataAutoSlaveDiscovery, error) {
	if b.AutoSlaveDiscovery == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'autoSlaveDiscovery' not set"))
	}
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._BACnetConstructedDataAutoSlaveDiscovery.deepCopy(), nil
}

func (b *_BACnetConstructedDataAutoSlaveDiscoveryBuilder) MustBuild() BACnetConstructedDataAutoSlaveDiscovery {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetConstructedDataAutoSlaveDiscoveryBuilder) Done() BACnetConstructedDataBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetConstructedDataBuilder().(*_BACnetConstructedDataBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetConstructedDataAutoSlaveDiscoveryBuilder) buildForBACnetConstructedData() (BACnetConstructedData, error) {
	return b.Build()
}

func (b *_BACnetConstructedDataAutoSlaveDiscoveryBuilder) DeepCopy() any {
	_copy := b.CreateBACnetConstructedDataAutoSlaveDiscoveryBuilder().(*_BACnetConstructedDataAutoSlaveDiscoveryBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateBACnetConstructedDataAutoSlaveDiscoveryBuilder creates a BACnetConstructedDataAutoSlaveDiscoveryBuilder
func (b *_BACnetConstructedDataAutoSlaveDiscovery) CreateBACnetConstructedDataAutoSlaveDiscoveryBuilder() BACnetConstructedDataAutoSlaveDiscoveryBuilder {
	if b == nil {
		return NewBACnetConstructedDataAutoSlaveDiscoveryBuilder()
	}
	return &_BACnetConstructedDataAutoSlaveDiscoveryBuilder{_BACnetConstructedDataAutoSlaveDiscovery: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_BACnetConstructedDataAutoSlaveDiscovery) GetObjectTypeArgument() BACnetObjectType {
	return 0
}

func (m *_BACnetConstructedDataAutoSlaveDiscovery) GetPropertyIdentifierArgument() BACnetPropertyIdentifier {
	return BACnetPropertyIdentifier_AUTO_SLAVE_DISCOVERY
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetConstructedDataAutoSlaveDiscovery) GetParent() BACnetConstructedDataContract {
	return m.BACnetConstructedDataContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetConstructedDataAutoSlaveDiscovery) GetAutoSlaveDiscovery() BACnetApplicationTagBoolean {
	return m.AutoSlaveDiscovery
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for virtual fields.
///////////////////////

func (m *_BACnetConstructedDataAutoSlaveDiscovery) GetActualValue() BACnetApplicationTagBoolean {
	ctx := context.Background()
	_ = ctx
	return CastBACnetApplicationTagBoolean(m.GetAutoSlaveDiscovery())
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetConstructedDataAutoSlaveDiscovery(structType any) BACnetConstructedDataAutoSlaveDiscovery {
	if casted, ok := structType.(BACnetConstructedDataAutoSlaveDiscovery); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetConstructedDataAutoSlaveDiscovery); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetConstructedDataAutoSlaveDiscovery) GetTypeName() string {
	return "BACnetConstructedDataAutoSlaveDiscovery"
}

func (m *_BACnetConstructedDataAutoSlaveDiscovery) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetConstructedDataContract.(*_BACnetConstructedData).getLengthInBits(ctx))

	// Simple field (autoSlaveDiscovery)
	lengthInBits += m.AutoSlaveDiscovery.GetLengthInBits(ctx)

	// A virtual field doesn't have any in- or output.

	return lengthInBits
}

func (m *_BACnetConstructedDataAutoSlaveDiscovery) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetConstructedDataAutoSlaveDiscovery) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetConstructedData, tagNumber uint8, objectTypeArgument BACnetObjectType, propertyIdentifierArgument BACnetPropertyIdentifier, arrayIndexArgument BACnetTagPayloadUnsignedInteger) (__bACnetConstructedDataAutoSlaveDiscovery BACnetConstructedDataAutoSlaveDiscovery, err error) {
	m.BACnetConstructedDataContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetConstructedDataAutoSlaveDiscovery"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetConstructedDataAutoSlaveDiscovery")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	autoSlaveDiscovery, err := ReadSimpleField[BACnetApplicationTagBoolean](ctx, "autoSlaveDiscovery", ReadComplex[BACnetApplicationTagBoolean](BACnetApplicationTagParseWithBufferProducer[BACnetApplicationTagBoolean](), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'autoSlaveDiscovery' field"))
	}
	m.AutoSlaveDiscovery = autoSlaveDiscovery

	actualValue, err := ReadVirtualField[BACnetApplicationTagBoolean](ctx, "actualValue", (*BACnetApplicationTagBoolean)(nil), autoSlaveDiscovery)
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'actualValue' field"))
	}
	_ = actualValue

	if closeErr := readBuffer.CloseContext("BACnetConstructedDataAutoSlaveDiscovery"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetConstructedDataAutoSlaveDiscovery")
	}

	return m, nil
}

func (m *_BACnetConstructedDataAutoSlaveDiscovery) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetConstructedDataAutoSlaveDiscovery) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetConstructedDataAutoSlaveDiscovery"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetConstructedDataAutoSlaveDiscovery")
		}

		if err := WriteSimpleField[BACnetApplicationTagBoolean](ctx, "autoSlaveDiscovery", m.GetAutoSlaveDiscovery(), WriteComplex[BACnetApplicationTagBoolean](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'autoSlaveDiscovery' field")
		}
		// Virtual field
		actualValue := m.GetActualValue()
		_ = actualValue
		if _actualValueErr := writeBuffer.WriteVirtual(ctx, "actualValue", m.GetActualValue()); _actualValueErr != nil {
			return errors.Wrap(_actualValueErr, "Error serializing 'actualValue' field")
		}

		if popErr := writeBuffer.PopContext("BACnetConstructedDataAutoSlaveDiscovery"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetConstructedDataAutoSlaveDiscovery")
		}
		return nil
	}
	return m.BACnetConstructedDataContract.(*_BACnetConstructedData).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetConstructedDataAutoSlaveDiscovery) IsBACnetConstructedDataAutoSlaveDiscovery() {}

func (m *_BACnetConstructedDataAutoSlaveDiscovery) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetConstructedDataAutoSlaveDiscovery) deepCopy() *_BACnetConstructedDataAutoSlaveDiscovery {
	if m == nil {
		return nil
	}
	_BACnetConstructedDataAutoSlaveDiscoveryCopy := &_BACnetConstructedDataAutoSlaveDiscovery{
		m.BACnetConstructedDataContract.(*_BACnetConstructedData).deepCopy(),
		utils.DeepCopy[BACnetApplicationTagBoolean](m.AutoSlaveDiscovery),
	}
	_BACnetConstructedDataAutoSlaveDiscoveryCopy.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = m
	return _BACnetConstructedDataAutoSlaveDiscoveryCopy
}

func (m *_BACnetConstructedDataAutoSlaveDiscovery) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
