/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetConstructedDataActivationTime is the corresponding interface of BACnetConstructedDataActivationTime
type BACnetConstructedDataActivationTime interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetConstructedData
	// GetActivationTime returns ActivationTime (property field)
	GetActivationTime() BACnetDateTime
	// GetActualValue returns ActualValue (virtual field)
	GetActualValue() BACnetDateTime
	// IsBACnetConstructedDataActivationTime is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetConstructedDataActivationTime()
	// CreateBuilder creates a BACnetConstructedDataActivationTimeBuilder
	CreateBACnetConstructedDataActivationTimeBuilder() BACnetConstructedDataActivationTimeBuilder
}

// _BACnetConstructedDataActivationTime is the data-structure of this message
type _BACnetConstructedDataActivationTime struct {
	BACnetConstructedDataContract
	ActivationTime BACnetDateTime
}

var _ BACnetConstructedDataActivationTime = (*_BACnetConstructedDataActivationTime)(nil)
var _ BACnetConstructedDataRequirements = (*_BACnetConstructedDataActivationTime)(nil)

// NewBACnetConstructedDataActivationTime factory function for _BACnetConstructedDataActivationTime
func NewBACnetConstructedDataActivationTime(openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag, activationTime BACnetDateTime, tagNumber uint8, arrayIndexArgument BACnetTagPayloadUnsignedInteger) *_BACnetConstructedDataActivationTime {
	if activationTime == nil {
		panic("activationTime of type BACnetDateTime for BACnetConstructedDataActivationTime must not be nil")
	}
	_result := &_BACnetConstructedDataActivationTime{
		BACnetConstructedDataContract: NewBACnetConstructedData(openingTag, peekedTagHeader, closingTag, tagNumber, arrayIndexArgument),
		ActivationTime:                activationTime,
	}
	_result.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetConstructedDataActivationTimeBuilder is a builder for BACnetConstructedDataActivationTime
type BACnetConstructedDataActivationTimeBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(activationTime BACnetDateTime) BACnetConstructedDataActivationTimeBuilder
	// WithActivationTime adds ActivationTime (property field)
	WithActivationTime(BACnetDateTime) BACnetConstructedDataActivationTimeBuilder
	// WithActivationTimeBuilder adds ActivationTime (property field) which is build by the builder
	WithActivationTimeBuilder(func(BACnetDateTimeBuilder) BACnetDateTimeBuilder) BACnetConstructedDataActivationTimeBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetConstructedDataBuilder
	// Build builds the BACnetConstructedDataActivationTime or returns an error if something is wrong
	Build() (BACnetConstructedDataActivationTime, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetConstructedDataActivationTime
}

// NewBACnetConstructedDataActivationTimeBuilder() creates a BACnetConstructedDataActivationTimeBuilder
func NewBACnetConstructedDataActivationTimeBuilder() BACnetConstructedDataActivationTimeBuilder {
	return &_BACnetConstructedDataActivationTimeBuilder{_BACnetConstructedDataActivationTime: new(_BACnetConstructedDataActivationTime)}
}

type _BACnetConstructedDataActivationTimeBuilder struct {
	*_BACnetConstructedDataActivationTime

	parentBuilder *_BACnetConstructedDataBuilder

	err *utils.MultiError
}

var _ (BACnetConstructedDataActivationTimeBuilder) = (*_BACnetConstructedDataActivationTimeBuilder)(nil)

func (b *_BACnetConstructedDataActivationTimeBuilder) setParent(contract BACnetConstructedDataContract) {
	b.BACnetConstructedDataContract = contract
	contract.(*_BACnetConstructedData)._SubType = b._BACnetConstructedDataActivationTime
}

func (b *_BACnetConstructedDataActivationTimeBuilder) WithMandatoryFields(activationTime BACnetDateTime) BACnetConstructedDataActivationTimeBuilder {
	return b.WithActivationTime(activationTime)
}

func (b *_BACnetConstructedDataActivationTimeBuilder) WithActivationTime(activationTime BACnetDateTime) BACnetConstructedDataActivationTimeBuilder {
	b.ActivationTime = activationTime
	return b
}

func (b *_BACnetConstructedDataActivationTimeBuilder) WithActivationTimeBuilder(builderSupplier func(BACnetDateTimeBuilder) BACnetDateTimeBuilder) BACnetConstructedDataActivationTimeBuilder {
	builder := builderSupplier(b.ActivationTime.CreateBACnetDateTimeBuilder())
	var err error
	b.ActivationTime, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "BACnetDateTimeBuilder failed"))
	}
	return b
}

func (b *_BACnetConstructedDataActivationTimeBuilder) Build() (BACnetConstructedDataActivationTime, error) {
	if b.ActivationTime == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'activationTime' not set"))
	}
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._BACnetConstructedDataActivationTime.deepCopy(), nil
}

func (b *_BACnetConstructedDataActivationTimeBuilder) MustBuild() BACnetConstructedDataActivationTime {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetConstructedDataActivationTimeBuilder) Done() BACnetConstructedDataBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetConstructedDataBuilder().(*_BACnetConstructedDataBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetConstructedDataActivationTimeBuilder) buildForBACnetConstructedData() (BACnetConstructedData, error) {
	return b.Build()
}

func (b *_BACnetConstructedDataActivationTimeBuilder) DeepCopy() any {
	_copy := b.CreateBACnetConstructedDataActivationTimeBuilder().(*_BACnetConstructedDataActivationTimeBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateBACnetConstructedDataActivationTimeBuilder creates a BACnetConstructedDataActivationTimeBuilder
func (b *_BACnetConstructedDataActivationTime) CreateBACnetConstructedDataActivationTimeBuilder() BACnetConstructedDataActivationTimeBuilder {
	if b == nil {
		return NewBACnetConstructedDataActivationTimeBuilder()
	}
	return &_BACnetConstructedDataActivationTimeBuilder{_BACnetConstructedDataActivationTime: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_BACnetConstructedDataActivationTime) GetObjectTypeArgument() BACnetObjectType {
	return 0
}

func (m *_BACnetConstructedDataActivationTime) GetPropertyIdentifierArgument() BACnetPropertyIdentifier {
	return BACnetPropertyIdentifier_ACTIVATION_TIME
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetConstructedDataActivationTime) GetParent() BACnetConstructedDataContract {
	return m.BACnetConstructedDataContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetConstructedDataActivationTime) GetActivationTime() BACnetDateTime {
	return m.ActivationTime
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for virtual fields.
///////////////////////

func (m *_BACnetConstructedDataActivationTime) GetActualValue() BACnetDateTime {
	ctx := context.Background()
	_ = ctx
	return CastBACnetDateTime(m.GetActivationTime())
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetConstructedDataActivationTime(structType any) BACnetConstructedDataActivationTime {
	if casted, ok := structType.(BACnetConstructedDataActivationTime); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetConstructedDataActivationTime); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetConstructedDataActivationTime) GetTypeName() string {
	return "BACnetConstructedDataActivationTime"
}

func (m *_BACnetConstructedDataActivationTime) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetConstructedDataContract.(*_BACnetConstructedData).getLengthInBits(ctx))

	// Simple field (activationTime)
	lengthInBits += m.ActivationTime.GetLengthInBits(ctx)

	// A virtual field doesn't have any in- or output.

	return lengthInBits
}

func (m *_BACnetConstructedDataActivationTime) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetConstructedDataActivationTime) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetConstructedData, tagNumber uint8, objectTypeArgument BACnetObjectType, propertyIdentifierArgument BACnetPropertyIdentifier, arrayIndexArgument BACnetTagPayloadUnsignedInteger) (__bACnetConstructedDataActivationTime BACnetConstructedDataActivationTime, err error) {
	m.BACnetConstructedDataContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetConstructedDataActivationTime"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetConstructedDataActivationTime")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	activationTime, err := ReadSimpleField[BACnetDateTime](ctx, "activationTime", ReadComplex[BACnetDateTime](BACnetDateTimeParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'activationTime' field"))
	}
	m.ActivationTime = activationTime

	actualValue, err := ReadVirtualField[BACnetDateTime](ctx, "actualValue", (*BACnetDateTime)(nil), activationTime)
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'actualValue' field"))
	}
	_ = actualValue

	if closeErr := readBuffer.CloseContext("BACnetConstructedDataActivationTime"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetConstructedDataActivationTime")
	}

	return m, nil
}

func (m *_BACnetConstructedDataActivationTime) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetConstructedDataActivationTime) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetConstructedDataActivationTime"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetConstructedDataActivationTime")
		}

		if err := WriteSimpleField[BACnetDateTime](ctx, "activationTime", m.GetActivationTime(), WriteComplex[BACnetDateTime](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'activationTime' field")
		}
		// Virtual field
		actualValue := m.GetActualValue()
		_ = actualValue
		if _actualValueErr := writeBuffer.WriteVirtual(ctx, "actualValue", m.GetActualValue()); _actualValueErr != nil {
			return errors.Wrap(_actualValueErr, "Error serializing 'actualValue' field")
		}

		if popErr := writeBuffer.PopContext("BACnetConstructedDataActivationTime"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetConstructedDataActivationTime")
		}
		return nil
	}
	return m.BACnetConstructedDataContract.(*_BACnetConstructedData).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetConstructedDataActivationTime) IsBACnetConstructedDataActivationTime() {}

func (m *_BACnetConstructedDataActivationTime) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetConstructedDataActivationTime) deepCopy() *_BACnetConstructedDataActivationTime {
	if m == nil {
		return nil
	}
	_BACnetConstructedDataActivationTimeCopy := &_BACnetConstructedDataActivationTime{
		m.BACnetConstructedDataContract.(*_BACnetConstructedData).deepCopy(),
		utils.DeepCopy[BACnetDateTime](m.ActivationTime),
	}
	_BACnetConstructedDataActivationTimeCopy.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = m
	return _BACnetConstructedDataActivationTimeCopy
}

func (m *_BACnetConstructedDataActivationTime) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
