/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetConstructedDataAccessTransactionEvents is the corresponding interface of BACnetConstructedDataAccessTransactionEvents
type BACnetConstructedDataAccessTransactionEvents interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetConstructedData
	// GetAccessTransactionEvents returns AccessTransactionEvents (property field)
	GetAccessTransactionEvents() []BACnetAccessEventTagged
	// IsBACnetConstructedDataAccessTransactionEvents is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetConstructedDataAccessTransactionEvents()
	// CreateBuilder creates a BACnetConstructedDataAccessTransactionEventsBuilder
	CreateBACnetConstructedDataAccessTransactionEventsBuilder() BACnetConstructedDataAccessTransactionEventsBuilder
}

// _BACnetConstructedDataAccessTransactionEvents is the data-structure of this message
type _BACnetConstructedDataAccessTransactionEvents struct {
	BACnetConstructedDataContract
	AccessTransactionEvents []BACnetAccessEventTagged
}

var _ BACnetConstructedDataAccessTransactionEvents = (*_BACnetConstructedDataAccessTransactionEvents)(nil)
var _ BACnetConstructedDataRequirements = (*_BACnetConstructedDataAccessTransactionEvents)(nil)

// NewBACnetConstructedDataAccessTransactionEvents factory function for _BACnetConstructedDataAccessTransactionEvents
func NewBACnetConstructedDataAccessTransactionEvents(openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag, accessTransactionEvents []BACnetAccessEventTagged, tagNumber uint8, arrayIndexArgument BACnetTagPayloadUnsignedInteger) *_BACnetConstructedDataAccessTransactionEvents {
	_result := &_BACnetConstructedDataAccessTransactionEvents{
		BACnetConstructedDataContract: NewBACnetConstructedData(openingTag, peekedTagHeader, closingTag, tagNumber, arrayIndexArgument),
		AccessTransactionEvents:       accessTransactionEvents,
	}
	_result.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetConstructedDataAccessTransactionEventsBuilder is a builder for BACnetConstructedDataAccessTransactionEvents
type BACnetConstructedDataAccessTransactionEventsBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(accessTransactionEvents []BACnetAccessEventTagged) BACnetConstructedDataAccessTransactionEventsBuilder
	// WithAccessTransactionEvents adds AccessTransactionEvents (property field)
	WithAccessTransactionEvents(...BACnetAccessEventTagged) BACnetConstructedDataAccessTransactionEventsBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetConstructedDataBuilder
	// Build builds the BACnetConstructedDataAccessTransactionEvents or returns an error if something is wrong
	Build() (BACnetConstructedDataAccessTransactionEvents, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetConstructedDataAccessTransactionEvents
}

// NewBACnetConstructedDataAccessTransactionEventsBuilder() creates a BACnetConstructedDataAccessTransactionEventsBuilder
func NewBACnetConstructedDataAccessTransactionEventsBuilder() BACnetConstructedDataAccessTransactionEventsBuilder {
	return &_BACnetConstructedDataAccessTransactionEventsBuilder{_BACnetConstructedDataAccessTransactionEvents: new(_BACnetConstructedDataAccessTransactionEvents)}
}

type _BACnetConstructedDataAccessTransactionEventsBuilder struct {
	*_BACnetConstructedDataAccessTransactionEvents

	parentBuilder *_BACnetConstructedDataBuilder

	err *utils.MultiError
}

var _ (BACnetConstructedDataAccessTransactionEventsBuilder) = (*_BACnetConstructedDataAccessTransactionEventsBuilder)(nil)

func (b *_BACnetConstructedDataAccessTransactionEventsBuilder) setParent(contract BACnetConstructedDataContract) {
	b.BACnetConstructedDataContract = contract
	contract.(*_BACnetConstructedData)._SubType = b._BACnetConstructedDataAccessTransactionEvents
}

func (b *_BACnetConstructedDataAccessTransactionEventsBuilder) WithMandatoryFields(accessTransactionEvents []BACnetAccessEventTagged) BACnetConstructedDataAccessTransactionEventsBuilder {
	return b.WithAccessTransactionEvents(accessTransactionEvents...)
}

func (b *_BACnetConstructedDataAccessTransactionEventsBuilder) WithAccessTransactionEvents(accessTransactionEvents ...BACnetAccessEventTagged) BACnetConstructedDataAccessTransactionEventsBuilder {
	b.AccessTransactionEvents = accessTransactionEvents
	return b
}

func (b *_BACnetConstructedDataAccessTransactionEventsBuilder) Build() (BACnetConstructedDataAccessTransactionEvents, error) {
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._BACnetConstructedDataAccessTransactionEvents.deepCopy(), nil
}

func (b *_BACnetConstructedDataAccessTransactionEventsBuilder) MustBuild() BACnetConstructedDataAccessTransactionEvents {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetConstructedDataAccessTransactionEventsBuilder) Done() BACnetConstructedDataBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetConstructedDataBuilder().(*_BACnetConstructedDataBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetConstructedDataAccessTransactionEventsBuilder) buildForBACnetConstructedData() (BACnetConstructedData, error) {
	return b.Build()
}

func (b *_BACnetConstructedDataAccessTransactionEventsBuilder) DeepCopy() any {
	_copy := b.CreateBACnetConstructedDataAccessTransactionEventsBuilder().(*_BACnetConstructedDataAccessTransactionEventsBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateBACnetConstructedDataAccessTransactionEventsBuilder creates a BACnetConstructedDataAccessTransactionEventsBuilder
func (b *_BACnetConstructedDataAccessTransactionEvents) CreateBACnetConstructedDataAccessTransactionEventsBuilder() BACnetConstructedDataAccessTransactionEventsBuilder {
	if b == nil {
		return NewBACnetConstructedDataAccessTransactionEventsBuilder()
	}
	return &_BACnetConstructedDataAccessTransactionEventsBuilder{_BACnetConstructedDataAccessTransactionEvents: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_BACnetConstructedDataAccessTransactionEvents) GetObjectTypeArgument() BACnetObjectType {
	return 0
}

func (m *_BACnetConstructedDataAccessTransactionEvents) GetPropertyIdentifierArgument() BACnetPropertyIdentifier {
	return BACnetPropertyIdentifier_ACCESS_TRANSACTION_EVENTS
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetConstructedDataAccessTransactionEvents) GetParent() BACnetConstructedDataContract {
	return m.BACnetConstructedDataContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetConstructedDataAccessTransactionEvents) GetAccessTransactionEvents() []BACnetAccessEventTagged {
	return m.AccessTransactionEvents
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetConstructedDataAccessTransactionEvents(structType any) BACnetConstructedDataAccessTransactionEvents {
	if casted, ok := structType.(BACnetConstructedDataAccessTransactionEvents); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetConstructedDataAccessTransactionEvents); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetConstructedDataAccessTransactionEvents) GetTypeName() string {
	return "BACnetConstructedDataAccessTransactionEvents"
}

func (m *_BACnetConstructedDataAccessTransactionEvents) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetConstructedDataContract.(*_BACnetConstructedData).getLengthInBits(ctx))

	// Array field
	if len(m.AccessTransactionEvents) > 0 {
		for _, element := range m.AccessTransactionEvents {
			lengthInBits += element.GetLengthInBits(ctx)
		}
	}

	return lengthInBits
}

func (m *_BACnetConstructedDataAccessTransactionEvents) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetConstructedDataAccessTransactionEvents) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetConstructedData, tagNumber uint8, objectTypeArgument BACnetObjectType, propertyIdentifierArgument BACnetPropertyIdentifier, arrayIndexArgument BACnetTagPayloadUnsignedInteger) (__bACnetConstructedDataAccessTransactionEvents BACnetConstructedDataAccessTransactionEvents, err error) {
	m.BACnetConstructedDataContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetConstructedDataAccessTransactionEvents"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetConstructedDataAccessTransactionEvents")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	accessTransactionEvents, err := ReadTerminatedArrayField[BACnetAccessEventTagged](ctx, "accessTransactionEvents", ReadComplex[BACnetAccessEventTagged](BACnetAccessEventTaggedParseWithBufferProducer((uint8)(uint8(0)), (TagClass)(TagClass_APPLICATION_TAGS)), readBuffer), IsBACnetConstructedDataClosingTag(ctx, readBuffer, false, tagNumber))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'accessTransactionEvents' field"))
	}
	m.AccessTransactionEvents = accessTransactionEvents

	if closeErr := readBuffer.CloseContext("BACnetConstructedDataAccessTransactionEvents"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetConstructedDataAccessTransactionEvents")
	}

	return m, nil
}

func (m *_BACnetConstructedDataAccessTransactionEvents) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetConstructedDataAccessTransactionEvents) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetConstructedDataAccessTransactionEvents"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetConstructedDataAccessTransactionEvents")
		}

		if err := WriteComplexTypeArrayField(ctx, "accessTransactionEvents", m.GetAccessTransactionEvents(), writeBuffer); err != nil {
			return errors.Wrap(err, "Error serializing 'accessTransactionEvents' field")
		}

		if popErr := writeBuffer.PopContext("BACnetConstructedDataAccessTransactionEvents"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetConstructedDataAccessTransactionEvents")
		}
		return nil
	}
	return m.BACnetConstructedDataContract.(*_BACnetConstructedData).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetConstructedDataAccessTransactionEvents) IsBACnetConstructedDataAccessTransactionEvents() {
}

func (m *_BACnetConstructedDataAccessTransactionEvents) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetConstructedDataAccessTransactionEvents) deepCopy() *_BACnetConstructedDataAccessTransactionEvents {
	if m == nil {
		return nil
	}
	_BACnetConstructedDataAccessTransactionEventsCopy := &_BACnetConstructedDataAccessTransactionEvents{
		m.BACnetConstructedDataContract.(*_BACnetConstructedData).deepCopy(),
		utils.DeepCopySlice[BACnetAccessEventTagged, BACnetAccessEventTagged](m.AccessTransactionEvents),
	}
	_BACnetConstructedDataAccessTransactionEventsCopy.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = m
	return _BACnetConstructedDataAccessTransactionEventsCopy
}

func (m *_BACnetConstructedDataAccessTransactionEvents) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
