/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetConstructedData is the corresponding interface of BACnetConstructedData
type BACnetConstructedData interface {
	BACnetConstructedDataContract
	BACnetConstructedDataRequirements
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	// IsBACnetConstructedData is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetConstructedData()
	// CreateBuilder creates a BACnetConstructedDataBuilder
	CreateBACnetConstructedDataBuilder() BACnetConstructedDataBuilder
}

// BACnetConstructedDataContract provides a set of functions which can be overwritten by a sub struct
type BACnetConstructedDataContract interface {
	// GetOpeningTag returns OpeningTag (property field)
	GetOpeningTag() BACnetOpeningTag
	// GetPeekedTagHeader returns PeekedTagHeader (property field)
	GetPeekedTagHeader() BACnetTagHeader
	// GetClosingTag returns ClosingTag (property field)
	GetClosingTag() BACnetClosingTag
	// GetPeekedTagNumber returns PeekedTagNumber (virtual field)
	GetPeekedTagNumber() uint8
	// GetTagNumber() returns a parser argument
	GetTagNumber() uint8
	// GetArrayIndexArgument() returns a parser argument
	GetArrayIndexArgument() BACnetTagPayloadUnsignedInteger
	// IsBACnetConstructedData is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetConstructedData()
	// CreateBuilder creates a BACnetConstructedDataBuilder
	CreateBACnetConstructedDataBuilder() BACnetConstructedDataBuilder
}

// BACnetConstructedDataRequirements provides a set of functions which need to be implemented by a sub struct
type BACnetConstructedDataRequirements interface {
	GetLengthInBits(ctx context.Context) uint16
	GetLengthInBytes(ctx context.Context) uint16
	// GetObjectTypeArgument returns ObjectTypeArgument (discriminator field)
	GetObjectTypeArgument() BACnetObjectType
	// GetPeekedTagNumber returns PeekedTagNumber (discriminator field)
	GetPeekedTagNumber() uint8
	// GetPropertyIdentifierArgument returns PropertyIdentifierArgument (discriminator field)
	GetPropertyIdentifierArgument() BACnetPropertyIdentifier
}

// _BACnetConstructedData is the data-structure of this message
type _BACnetConstructedData struct {
	_SubType interface {
		BACnetConstructedDataContract
		BACnetConstructedDataRequirements
	}
	OpeningTag      BACnetOpeningTag
	PeekedTagHeader BACnetTagHeader
	ClosingTag      BACnetClosingTag

	// Arguments.
	TagNumber          uint8
	ArrayIndexArgument BACnetTagPayloadUnsignedInteger
}

var _ BACnetConstructedDataContract = (*_BACnetConstructedData)(nil)

// NewBACnetConstructedData factory function for _BACnetConstructedData
func NewBACnetConstructedData(openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag, tagNumber uint8, arrayIndexArgument BACnetTagPayloadUnsignedInteger) *_BACnetConstructedData {
	if openingTag == nil {
		panic("openingTag of type BACnetOpeningTag for BACnetConstructedData must not be nil")
	}
	if peekedTagHeader == nil {
		panic("peekedTagHeader of type BACnetTagHeader for BACnetConstructedData must not be nil")
	}
	if closingTag == nil {
		panic("closingTag of type BACnetClosingTag for BACnetConstructedData must not be nil")
	}
	return &_BACnetConstructedData{OpeningTag: openingTag, PeekedTagHeader: peekedTagHeader, ClosingTag: closingTag, TagNumber: tagNumber, ArrayIndexArgument: arrayIndexArgument}
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetConstructedDataBuilder is a builder for BACnetConstructedData
type BACnetConstructedDataBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag) BACnetConstructedDataBuilder
	// WithOpeningTag adds OpeningTag (property field)
	WithOpeningTag(BACnetOpeningTag) BACnetConstructedDataBuilder
	// WithOpeningTagBuilder adds OpeningTag (property field) which is build by the builder
	WithOpeningTagBuilder(func(BACnetOpeningTagBuilder) BACnetOpeningTagBuilder) BACnetConstructedDataBuilder
	// WithPeekedTagHeader adds PeekedTagHeader (property field)
	WithPeekedTagHeader(BACnetTagHeader) BACnetConstructedDataBuilder
	// WithPeekedTagHeaderBuilder adds PeekedTagHeader (property field) which is build by the builder
	WithPeekedTagHeaderBuilder(func(BACnetTagHeaderBuilder) BACnetTagHeaderBuilder) BACnetConstructedDataBuilder
	// WithClosingTag adds ClosingTag (property field)
	WithClosingTag(BACnetClosingTag) BACnetConstructedDataBuilder
	// WithClosingTagBuilder adds ClosingTag (property field) which is build by the builder
	WithClosingTagBuilder(func(BACnetClosingTagBuilder) BACnetClosingTagBuilder) BACnetConstructedDataBuilder
	// WithArgTagNumber sets a parser argument
	WithArgTagNumber(uint8) BACnetConstructedDataBuilder
	// WithArgArrayIndexArgument sets a parser argument
	WithArgArrayIndexArgument(BACnetTagPayloadUnsignedInteger) BACnetConstructedDataBuilder
	// AsBACnetConstructedDataAbsenteeLimit converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataAbsenteeLimit() BACnetConstructedDataAbsenteeLimitBuilder
	// AsBACnetConstructedDataAcceptedModes converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataAcceptedModes() BACnetConstructedDataAcceptedModesBuilder
	// AsBACnetConstructedDataAccessAlarmEvents converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataAccessAlarmEvents() BACnetConstructedDataAccessAlarmEventsBuilder
	// AsBACnetConstructedDataAccessDoors converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataAccessDoors() BACnetConstructedDataAccessDoorsBuilder
	// AsBACnetConstructedDataAccessEvent converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataAccessEvent() BACnetConstructedDataAccessEventBuilder
	// AsBACnetConstructedDataAccessEventAuthenticationFactor converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataAccessEventAuthenticationFactor() BACnetConstructedDataAccessEventAuthenticationFactorBuilder
	// AsBACnetConstructedDataAccessEventCredential converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataAccessEventCredential() BACnetConstructedDataAccessEventCredentialBuilder
	// AsBACnetConstructedDataAccessEventTag converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataAccessEventTag() BACnetConstructedDataAccessEventTagBuilder
	// AsBACnetConstructedDataAccessEventTime converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataAccessEventTime() BACnetConstructedDataAccessEventTimeBuilder
	// AsBACnetConstructedDataAccessTransactionEvents converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataAccessTransactionEvents() BACnetConstructedDataAccessTransactionEventsBuilder
	// AsBACnetConstructedDataAccompaniment converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataAccompaniment() BACnetConstructedDataAccompanimentBuilder
	// AsBACnetConstructedDataAccompanimentTime converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataAccompanimentTime() BACnetConstructedDataAccompanimentTimeBuilder
	// AsBACnetConstructedDataAckRequired converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataAckRequired() BACnetConstructedDataAckRequiredBuilder
	// AsBACnetConstructedDataAckedTransitions converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataAckedTransitions() BACnetConstructedDataAckedTransitionsBuilder
	// AsBACnetConstructedDataLoopAction converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataLoopAction() BACnetConstructedDataLoopActionBuilder
	// AsBACnetConstructedDataCommandAction converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataCommandAction() BACnetConstructedDataCommandActionBuilder
	// AsBACnetConstructedDataAction converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataAction() BACnetConstructedDataActionBuilder
	// AsBACnetConstructedDataActionText converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataActionText() BACnetConstructedDataActionTextBuilder
	// AsBACnetConstructedDataActivationTime converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataActivationTime() BACnetConstructedDataActivationTimeBuilder
	// AsBACnetConstructedDataActiveAuthenticationPolicy converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataActiveAuthenticationPolicy() BACnetConstructedDataActiveAuthenticationPolicyBuilder
	// AsBACnetConstructedDataActiveCOVMultipleSubscriptions converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataActiveCOVMultipleSubscriptions() BACnetConstructedDataActiveCOVMultipleSubscriptionsBuilder
	// AsBACnetConstructedDataActiveCOVSubscriptions converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataActiveCOVSubscriptions() BACnetConstructedDataActiveCOVSubscriptionsBuilder
	// AsBACnetConstructedDataActiveText converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataActiveText() BACnetConstructedDataActiveTextBuilder
	// AsBACnetConstructedDataActiveVTSessions converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataActiveVTSessions() BACnetConstructedDataActiveVTSessionsBuilder
	// AsBACnetConstructedDataActualShedLevel converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataActualShedLevel() BACnetConstructedDataActualShedLevelBuilder
	// AsBACnetConstructedDataAccessZoneAdjustValue converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataAccessZoneAdjustValue() BACnetConstructedDataAccessZoneAdjustValueBuilder
	// AsBACnetConstructedDataPulseConverterAdjustValue converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataPulseConverterAdjustValue() BACnetConstructedDataPulseConverterAdjustValueBuilder
	// AsBACnetConstructedDataAdjustValue converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataAdjustValue() BACnetConstructedDataAdjustValueBuilder
	// AsBACnetConstructedDataAlarmValue converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataAlarmValue() BACnetConstructedDataAlarmValueBuilder
	// AsBACnetConstructedDataAccessDoorAlarmValues converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataAccessDoorAlarmValues() BACnetConstructedDataAccessDoorAlarmValuesBuilder
	// AsBACnetConstructedDataAccessZoneAlarmValues converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataAccessZoneAlarmValues() BACnetConstructedDataAccessZoneAlarmValuesBuilder
	// AsBACnetConstructedDataBitStringValueAlarmValues converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataBitStringValueAlarmValues() BACnetConstructedDataBitStringValueAlarmValuesBuilder
	// AsBACnetConstructedDataCharacterStringValueAlarmValues converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataCharacterStringValueAlarmValues() BACnetConstructedDataCharacterStringValueAlarmValuesBuilder
	// AsBACnetConstructedDataLifeSafetyPointAlarmValues converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataLifeSafetyPointAlarmValues() BACnetConstructedDataLifeSafetyPointAlarmValuesBuilder
	// AsBACnetConstructedDataLifeSafetyZoneAlarmValues converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataLifeSafetyZoneAlarmValues() BACnetConstructedDataLifeSafetyZoneAlarmValuesBuilder
	// AsBACnetConstructedDataMultiStateInputAlarmValues converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataMultiStateInputAlarmValues() BACnetConstructedDataMultiStateInputAlarmValuesBuilder
	// AsBACnetConstructedDataMultiStateValueAlarmValues converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataMultiStateValueAlarmValues() BACnetConstructedDataMultiStateValueAlarmValuesBuilder
	// AsBACnetConstructedDataTimerAlarmValues converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataTimerAlarmValues() BACnetConstructedDataTimerAlarmValuesBuilder
	// AsBACnetConstructedDataAlarmValues converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataAlarmValues() BACnetConstructedDataAlarmValuesBuilder
	// AsBACnetConstructedDataAlignIntervals converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataAlignIntervals() BACnetConstructedDataAlignIntervalsBuilder
	// AsBACnetConstructedDataAccessCredentialAll converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataAccessCredentialAll() BACnetConstructedDataAccessCredentialAllBuilder
	// AsBACnetConstructedDataAccessDoorAll converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataAccessDoorAll() BACnetConstructedDataAccessDoorAllBuilder
	// AsBACnetConstructedDataAccessPointAll converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataAccessPointAll() BACnetConstructedDataAccessPointAllBuilder
	// AsBACnetConstructedDataAccessRightsAll converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataAccessRightsAll() BACnetConstructedDataAccessRightsAllBuilder
	// AsBACnetConstructedDataAccessUserAll converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataAccessUserAll() BACnetConstructedDataAccessUserAllBuilder
	// AsBACnetConstructedDataAccessZoneAll converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataAccessZoneAll() BACnetConstructedDataAccessZoneAllBuilder
	// AsBACnetConstructedDataAccumulatorAll converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataAccumulatorAll() BACnetConstructedDataAccumulatorAllBuilder
	// AsBACnetConstructedDataAlertEnrollmentAll converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataAlertEnrollmentAll() BACnetConstructedDataAlertEnrollmentAllBuilder
	// AsBACnetConstructedDataAnalogInputAll converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataAnalogInputAll() BACnetConstructedDataAnalogInputAllBuilder
	// AsBACnetConstructedDataAnalogOutputAll converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataAnalogOutputAll() BACnetConstructedDataAnalogOutputAllBuilder
	// AsBACnetConstructedDataAnalogValueAll converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataAnalogValueAll() BACnetConstructedDataAnalogValueAllBuilder
	// AsBACnetConstructedDataAveragingAll converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataAveragingAll() BACnetConstructedDataAveragingAllBuilder
	// AsBACnetConstructedDataBinaryInputAll converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataBinaryInputAll() BACnetConstructedDataBinaryInputAllBuilder
	// AsBACnetConstructedDataBinaryLightingOutputAll converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataBinaryLightingOutputAll() BACnetConstructedDataBinaryLightingOutputAllBuilder
	// AsBACnetConstructedDataBinaryOutputAll converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataBinaryOutputAll() BACnetConstructedDataBinaryOutputAllBuilder
	// AsBACnetConstructedDataBinaryValueAll converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataBinaryValueAll() BACnetConstructedDataBinaryValueAllBuilder
	// AsBACnetConstructedDataBitstringValueAll converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataBitstringValueAll() BACnetConstructedDataBitstringValueAllBuilder
	// AsBACnetConstructedDataCalendarAll converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataCalendarAll() BACnetConstructedDataCalendarAllBuilder
	// AsBACnetConstructedDataChannelAll converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataChannelAll() BACnetConstructedDataChannelAllBuilder
	// AsBACnetConstructedDataCharacterstringValueAll converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataCharacterstringValueAll() BACnetConstructedDataCharacterstringValueAllBuilder
	// AsBACnetConstructedDataCommandAll converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataCommandAll() BACnetConstructedDataCommandAllBuilder
	// AsBACnetConstructedDataCredentialDataInputAll converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataCredentialDataInputAll() BACnetConstructedDataCredentialDataInputAllBuilder
	// AsBACnetConstructedDataDatepatternValueAll converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataDatepatternValueAll() BACnetConstructedDataDatepatternValueAllBuilder
	// AsBACnetConstructedDataDateValueAll converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataDateValueAll() BACnetConstructedDataDateValueAllBuilder
	// AsBACnetConstructedDataDatetimepatternValueAll converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataDatetimepatternValueAll() BACnetConstructedDataDatetimepatternValueAllBuilder
	// AsBACnetConstructedDataDatetimeValueAll converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataDatetimeValueAll() BACnetConstructedDataDatetimeValueAllBuilder
	// AsBACnetConstructedDataDeviceAll converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataDeviceAll() BACnetConstructedDataDeviceAllBuilder
	// AsBACnetConstructedDataElevatorGroupAll converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataElevatorGroupAll() BACnetConstructedDataElevatorGroupAllBuilder
	// AsBACnetConstructedDataEscalatorAll converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataEscalatorAll() BACnetConstructedDataEscalatorAllBuilder
	// AsBACnetConstructedDataEventEnrollmentAll converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataEventEnrollmentAll() BACnetConstructedDataEventEnrollmentAllBuilder
	// AsBACnetConstructedDataEventLogAll converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataEventLogAll() BACnetConstructedDataEventLogAllBuilder
	// AsBACnetConstructedDataFileAll converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataFileAll() BACnetConstructedDataFileAllBuilder
	// AsBACnetConstructedDataGlobalGroupAll converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataGlobalGroupAll() BACnetConstructedDataGlobalGroupAllBuilder
	// AsBACnetConstructedDataGroupAll converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataGroupAll() BACnetConstructedDataGroupAllBuilder
	// AsBACnetConstructedDataIntegerValueAll converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataIntegerValueAll() BACnetConstructedDataIntegerValueAllBuilder
	// AsBACnetConstructedDataLargeAnalogValueAll converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataLargeAnalogValueAll() BACnetConstructedDataLargeAnalogValueAllBuilder
	// AsBACnetConstructedDataLifeSafetyPointAll converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataLifeSafetyPointAll() BACnetConstructedDataLifeSafetyPointAllBuilder
	// AsBACnetConstructedDataLifeSafetyZoneAll converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataLifeSafetyZoneAll() BACnetConstructedDataLifeSafetyZoneAllBuilder
	// AsBACnetConstructedDataLiftAll converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataLiftAll() BACnetConstructedDataLiftAllBuilder
	// AsBACnetConstructedDataLightingOutputAll converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataLightingOutputAll() BACnetConstructedDataLightingOutputAllBuilder
	// AsBACnetConstructedDataLoadControlAll converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataLoadControlAll() BACnetConstructedDataLoadControlAllBuilder
	// AsBACnetConstructedDataLoopAll converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataLoopAll() BACnetConstructedDataLoopAllBuilder
	// AsBACnetConstructedDataMultiStateInputAll converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataMultiStateInputAll() BACnetConstructedDataMultiStateInputAllBuilder
	// AsBACnetConstructedDataMultiStateOutputAll converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataMultiStateOutputAll() BACnetConstructedDataMultiStateOutputAllBuilder
	// AsBACnetConstructedDataMultiStateValueAll converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataMultiStateValueAll() BACnetConstructedDataMultiStateValueAllBuilder
	// AsBACnetConstructedDataNetworkPortAll converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataNetworkPortAll() BACnetConstructedDataNetworkPortAllBuilder
	// AsBACnetConstructedDataNetworkSecurityAll converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataNetworkSecurityAll() BACnetConstructedDataNetworkSecurityAllBuilder
	// AsBACnetConstructedDataNotificationClassAll converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataNotificationClassAll() BACnetConstructedDataNotificationClassAllBuilder
	// AsBACnetConstructedDataNotificationForwarderAll converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataNotificationForwarderAll() BACnetConstructedDataNotificationForwarderAllBuilder
	// AsBACnetConstructedDataOctetstringValueAll converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataOctetstringValueAll() BACnetConstructedDataOctetstringValueAllBuilder
	// AsBACnetConstructedDataPositiveIntegerValueAll converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataPositiveIntegerValueAll() BACnetConstructedDataPositiveIntegerValueAllBuilder
	// AsBACnetConstructedDataProgramAll converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataProgramAll() BACnetConstructedDataProgramAllBuilder
	// AsBACnetConstructedDataPulseConverterAll converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataPulseConverterAll() BACnetConstructedDataPulseConverterAllBuilder
	// AsBACnetConstructedDataScheduleAll converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataScheduleAll() BACnetConstructedDataScheduleAllBuilder
	// AsBACnetConstructedDataStructuredViewAll converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataStructuredViewAll() BACnetConstructedDataStructuredViewAllBuilder
	// AsBACnetConstructedDataTimepatternValueAll converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataTimepatternValueAll() BACnetConstructedDataTimepatternValueAllBuilder
	// AsBACnetConstructedDataTimeValueAll converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataTimeValueAll() BACnetConstructedDataTimeValueAllBuilder
	// AsBACnetConstructedDataTimerAll converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataTimerAll() BACnetConstructedDataTimerAllBuilder
	// AsBACnetConstructedDataTrendLogAll converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataTrendLogAll() BACnetConstructedDataTrendLogAllBuilder
	// AsBACnetConstructedDataTrendLogMultipleAll converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataTrendLogMultipleAll() BACnetConstructedDataTrendLogMultipleAllBuilder
	// AsBACnetConstructedDataAllWritesSuccessful converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataAllWritesSuccessful() BACnetConstructedDataAllWritesSuccessfulBuilder
	// AsBACnetConstructedDataAllowGroupDelayInhibit converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataAllowGroupDelayInhibit() BACnetConstructedDataAllowGroupDelayInhibitBuilder
	// AsBACnetConstructedDataAPDULength converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataAPDULength() BACnetConstructedDataAPDULengthBuilder
	// AsBACnetConstructedDataAPDUSegmentTimeout converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataAPDUSegmentTimeout() BACnetConstructedDataAPDUSegmentTimeoutBuilder
	// AsBACnetConstructedDataAPDUTimeout converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataAPDUTimeout() BACnetConstructedDataAPDUTimeoutBuilder
	// AsBACnetConstructedDataApplicationSoftwareVersion converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataApplicationSoftwareVersion() BACnetConstructedDataApplicationSoftwareVersionBuilder
	// AsBACnetConstructedDataArchive converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataArchive() BACnetConstructedDataArchiveBuilder
	// AsBACnetConstructedDataAssignedAccessRights converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataAssignedAccessRights() BACnetConstructedDataAssignedAccessRightsBuilder
	// AsBACnetConstructedDataAssignedLandingCalls converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataAssignedLandingCalls() BACnetConstructedDataAssignedLandingCallsBuilder
	// AsBACnetConstructedDataAttemptedSamples converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataAttemptedSamples() BACnetConstructedDataAttemptedSamplesBuilder
	// AsBACnetConstructedDataAuthenticationFactors converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataAuthenticationFactors() BACnetConstructedDataAuthenticationFactorsBuilder
	// AsBACnetConstructedDataAuthenticationPolicyList converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataAuthenticationPolicyList() BACnetConstructedDataAuthenticationPolicyListBuilder
	// AsBACnetConstructedDataAuthenticationPolicyNames converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataAuthenticationPolicyNames() BACnetConstructedDataAuthenticationPolicyNamesBuilder
	// AsBACnetConstructedDataAuthenticationStatus converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataAuthenticationStatus() BACnetConstructedDataAuthenticationStatusBuilder
	// AsBACnetConstructedDataAuthorizationExemptions converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataAuthorizationExemptions() BACnetConstructedDataAuthorizationExemptionsBuilder
	// AsBACnetConstructedDataAuthorizationMode converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataAuthorizationMode() BACnetConstructedDataAuthorizationModeBuilder
	// AsBACnetConstructedDataAutoSlaveDiscovery converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataAutoSlaveDiscovery() BACnetConstructedDataAutoSlaveDiscoveryBuilder
	// AsBACnetConstructedDataAverageValue converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataAverageValue() BACnetConstructedDataAverageValueBuilder
	// AsBACnetConstructedDataBackupAndRestoreState converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataBackupAndRestoreState() BACnetConstructedDataBackupAndRestoreStateBuilder
	// AsBACnetConstructedDataBackupFailureTimeout converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataBackupFailureTimeout() BACnetConstructedDataBackupFailureTimeoutBuilder
	// AsBACnetConstructedDataBackupPreparationTime converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataBackupPreparationTime() BACnetConstructedDataBackupPreparationTimeBuilder
	// AsBACnetConstructedDataBACnetIPGlobalAddress converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataBACnetIPGlobalAddress() BACnetConstructedDataBACnetIPGlobalAddressBuilder
	// AsBACnetConstructedDataBACnetIPMode converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataBACnetIPMode() BACnetConstructedDataBACnetIPModeBuilder
	// AsBACnetConstructedDataBACnetIPMulticastAddress converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataBACnetIPMulticastAddress() BACnetConstructedDataBACnetIPMulticastAddressBuilder
	// AsBACnetConstructedDataBACnetIPNATTraversal converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataBACnetIPNATTraversal() BACnetConstructedDataBACnetIPNATTraversalBuilder
	// AsBACnetConstructedDataBACnetIPUDPPort converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataBACnetIPUDPPort() BACnetConstructedDataBACnetIPUDPPortBuilder
	// AsBACnetConstructedDataBACnetIPv6Mode converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataBACnetIPv6Mode() BACnetConstructedDataBACnetIPv6ModeBuilder
	// AsBACnetConstructedDataBACnetIPv6UDPPort converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataBACnetIPv6UDPPort() BACnetConstructedDataBACnetIPv6UDPPortBuilder
	// AsBACnetConstructedDataBACnetIPv6MulticastAddress converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataBACnetIPv6MulticastAddress() BACnetConstructedDataBACnetIPv6MulticastAddressBuilder
	// AsBACnetConstructedDataBaseDeviceSecurityPolicy converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataBaseDeviceSecurityPolicy() BACnetConstructedDataBaseDeviceSecurityPolicyBuilder
	// AsBACnetConstructedDataBBMDAcceptFDRegistrations converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataBBMDAcceptFDRegistrations() BACnetConstructedDataBBMDAcceptFDRegistrationsBuilder
	// AsBACnetConstructedDataBBMDBroadcastDistributionTable converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataBBMDBroadcastDistributionTable() BACnetConstructedDataBBMDBroadcastDistributionTableBuilder
	// AsBACnetConstructedDataBBMDForeignDeviceTable converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataBBMDForeignDeviceTable() BACnetConstructedDataBBMDForeignDeviceTableBuilder
	// AsBACnetConstructedDataBelongsTo converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataBelongsTo() BACnetConstructedDataBelongsToBuilder
	// AsBACnetConstructedDataBias converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataBias() BACnetConstructedDataBiasBuilder
	// AsBACnetConstructedDataBitMask converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataBitMask() BACnetConstructedDataBitMaskBuilder
	// AsBACnetConstructedDataBitText converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataBitText() BACnetConstructedDataBitTextBuilder
	// AsBACnetConstructedDataBlinkWarnEnable converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataBlinkWarnEnable() BACnetConstructedDataBlinkWarnEnableBuilder
	// AsBACnetConstructedDataBufferSize converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataBufferSize() BACnetConstructedDataBufferSizeBuilder
	// AsBACnetConstructedDataCarAssignedDirection converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataCarAssignedDirection() BACnetConstructedDataCarAssignedDirectionBuilder
	// AsBACnetConstructedDataCarDoorCommand converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataCarDoorCommand() BACnetConstructedDataCarDoorCommandBuilder
	// AsBACnetConstructedDataCarDoorStatus converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataCarDoorStatus() BACnetConstructedDataCarDoorStatusBuilder
	// AsBACnetConstructedDataCarDoorText converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataCarDoorText() BACnetConstructedDataCarDoorTextBuilder
	// AsBACnetConstructedDataCarDoorZone converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataCarDoorZone() BACnetConstructedDataCarDoorZoneBuilder
	// AsBACnetConstructedDataCarDriveStatus converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataCarDriveStatus() BACnetConstructedDataCarDriveStatusBuilder
	// AsBACnetConstructedDataCarLoad converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataCarLoad() BACnetConstructedDataCarLoadBuilder
	// AsBACnetConstructedDataCarLoadUnits converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataCarLoadUnits() BACnetConstructedDataCarLoadUnitsBuilder
	// AsBACnetConstructedDataCarMode converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataCarMode() BACnetConstructedDataCarModeBuilder
	// AsBACnetConstructedDataCarMovingDirection converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataCarMovingDirection() BACnetConstructedDataCarMovingDirectionBuilder
	// AsBACnetConstructedDataCarPosition converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataCarPosition() BACnetConstructedDataCarPositionBuilder
	// AsBACnetConstructedDataChangeOfStateCount converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataChangeOfStateCount() BACnetConstructedDataChangeOfStateCountBuilder
	// AsBACnetConstructedDataChangeOfStateTime converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataChangeOfStateTime() BACnetConstructedDataChangeOfStateTimeBuilder
	// AsBACnetConstructedDataChangesPending converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataChangesPending() BACnetConstructedDataChangesPendingBuilder
	// AsBACnetConstructedDataChannelNumber converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataChannelNumber() BACnetConstructedDataChannelNumberBuilder
	// AsBACnetConstructedDataClientCOVIncrement converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataClientCOVIncrement() BACnetConstructedDataClientCOVIncrementBuilder
	// AsBACnetConstructedDataCommand converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataCommand() BACnetConstructedDataCommandBuilder
	// AsBACnetConstructedDataCommandTimeArray converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataCommandTimeArray() BACnetConstructedDataCommandTimeArrayBuilder
	// AsBACnetConstructedDataConfigurationFiles converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataConfigurationFiles() BACnetConstructedDataConfigurationFilesBuilder
	// AsBACnetConstructedDataControlGroups converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataControlGroups() BACnetConstructedDataControlGroupsBuilder
	// AsBACnetConstructedDataControlledVariableReference converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataControlledVariableReference() BACnetConstructedDataControlledVariableReferenceBuilder
	// AsBACnetConstructedDataControlledVariableUnits converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataControlledVariableUnits() BACnetConstructedDataControlledVariableUnitsBuilder
	// AsBACnetConstructedDataControlledVariableValue converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataControlledVariableValue() BACnetConstructedDataControlledVariableValueBuilder
	// AsBACnetConstructedDataCount converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataCount() BACnetConstructedDataCountBuilder
	// AsBACnetConstructedDataCountBeforeChange converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataCountBeforeChange() BACnetConstructedDataCountBeforeChangeBuilder
	// AsBACnetConstructedDataCountChangeTime converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataCountChangeTime() BACnetConstructedDataCountChangeTimeBuilder
	// AsBACnetConstructedDataIntegerValueCOVIncrement converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataIntegerValueCOVIncrement() BACnetConstructedDataIntegerValueCOVIncrementBuilder
	// AsBACnetConstructedDataLargeAnalogValueCOVIncrement converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataLargeAnalogValueCOVIncrement() BACnetConstructedDataLargeAnalogValueCOVIncrementBuilder
	// AsBACnetConstructedDataPositiveIntegerValueCOVIncrement converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataPositiveIntegerValueCOVIncrement() BACnetConstructedDataPositiveIntegerValueCOVIncrementBuilder
	// AsBACnetConstructedDataCOVIncrement converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataCOVIncrement() BACnetConstructedDataCOVIncrementBuilder
	// AsBACnetConstructedDataCOVPeriod converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataCOVPeriod() BACnetConstructedDataCOVPeriodBuilder
	// AsBACnetConstructedDataCOVResubscriptionInterval converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataCOVResubscriptionInterval() BACnetConstructedDataCOVResubscriptionIntervalBuilder
	// AsBACnetConstructedDataCOVUPeriod converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataCOVUPeriod() BACnetConstructedDataCOVUPeriodBuilder
	// AsBACnetConstructedDataCOVURecipients converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataCOVURecipients() BACnetConstructedDataCOVURecipientsBuilder
	// AsBACnetConstructedDataCredentialDisable converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataCredentialDisable() BACnetConstructedDataCredentialDisableBuilder
	// AsBACnetConstructedDataCredentialStatus converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataCredentialStatus() BACnetConstructedDataCredentialStatusBuilder
	// AsBACnetConstructedDataCredentials converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataCredentials() BACnetConstructedDataCredentialsBuilder
	// AsBACnetConstructedDataCredentialsInZone converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataCredentialsInZone() BACnetConstructedDataCredentialsInZoneBuilder
	// AsBACnetConstructedDataCurrentCommandPriority converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataCurrentCommandPriority() BACnetConstructedDataCurrentCommandPriorityBuilder
	// AsBACnetConstructedDataDatabaseRevision converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataDatabaseRevision() BACnetConstructedDataDatabaseRevisionBuilder
	// AsBACnetConstructedDataDateList converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataDateList() BACnetConstructedDataDateListBuilder
	// AsBACnetConstructedDataDaylightSavingsStatus converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataDaylightSavingsStatus() BACnetConstructedDataDaylightSavingsStatusBuilder
	// AsBACnetConstructedDataDaysRemaining converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataDaysRemaining() BACnetConstructedDataDaysRemainingBuilder
	// AsBACnetConstructedDataIntegerValueDeadband converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataIntegerValueDeadband() BACnetConstructedDataIntegerValueDeadbandBuilder
	// AsBACnetConstructedDataLargeAnalogValueDeadband converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataLargeAnalogValueDeadband() BACnetConstructedDataLargeAnalogValueDeadbandBuilder
	// AsBACnetConstructedDataPositiveIntegerValueDeadband converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataPositiveIntegerValueDeadband() BACnetConstructedDataPositiveIntegerValueDeadbandBuilder
	// AsBACnetConstructedDataDeadband converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataDeadband() BACnetConstructedDataDeadbandBuilder
	// AsBACnetConstructedDataDefaultFadeTime converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataDefaultFadeTime() BACnetConstructedDataDefaultFadeTimeBuilder
	// AsBACnetConstructedDataDefaultRampRate converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataDefaultRampRate() BACnetConstructedDataDefaultRampRateBuilder
	// AsBACnetConstructedDataDefaultStepIncrement converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataDefaultStepIncrement() BACnetConstructedDataDefaultStepIncrementBuilder
	// AsBACnetConstructedDataDefaultSubordinateRelationship converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataDefaultSubordinateRelationship() BACnetConstructedDataDefaultSubordinateRelationshipBuilder
	// AsBACnetConstructedDataDefaultTimeout converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataDefaultTimeout() BACnetConstructedDataDefaultTimeoutBuilder
	// AsBACnetConstructedDataDeployedProfileLocation converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataDeployedProfileLocation() BACnetConstructedDataDeployedProfileLocationBuilder
	// AsBACnetConstructedDataDerivativeConstant converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataDerivativeConstant() BACnetConstructedDataDerivativeConstantBuilder
	// AsBACnetConstructedDataDerivativeConstantUnits converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataDerivativeConstantUnits() BACnetConstructedDataDerivativeConstantUnitsBuilder
	// AsBACnetConstructedDataDescription converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataDescription() BACnetConstructedDataDescriptionBuilder
	// AsBACnetConstructedDataDescriptionOfHalt converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataDescriptionOfHalt() BACnetConstructedDataDescriptionOfHaltBuilder
	// AsBACnetConstructedDataDeviceAddressBinding converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataDeviceAddressBinding() BACnetConstructedDataDeviceAddressBindingBuilder
	// AsBACnetConstructedDataDeviceType converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataDeviceType() BACnetConstructedDataDeviceTypeBuilder
	// AsBACnetConstructedDataDirectReading converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataDirectReading() BACnetConstructedDataDirectReadingBuilder
	// AsBACnetConstructedDataDistributionKeyRevision converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataDistributionKeyRevision() BACnetConstructedDataDistributionKeyRevisionBuilder
	// AsBACnetConstructedDataDoNotHide converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataDoNotHide() BACnetConstructedDataDoNotHideBuilder
	// AsBACnetConstructedDataDoorAlarmState converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataDoorAlarmState() BACnetConstructedDataDoorAlarmStateBuilder
	// AsBACnetConstructedDataDoorExtendedPulseTime converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataDoorExtendedPulseTime() BACnetConstructedDataDoorExtendedPulseTimeBuilder
	// AsBACnetConstructedDataDoorMembers converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataDoorMembers() BACnetConstructedDataDoorMembersBuilder
	// AsBACnetConstructedDataDoorOpenTooLongTime converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataDoorOpenTooLongTime() BACnetConstructedDataDoorOpenTooLongTimeBuilder
	// AsBACnetConstructedDataDoorPulseTime converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataDoorPulseTime() BACnetConstructedDataDoorPulseTimeBuilder
	// AsBACnetConstructedDataDoorStatus converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataDoorStatus() BACnetConstructedDataDoorStatusBuilder
	// AsBACnetConstructedDataDoorUnlockDelayTime converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataDoorUnlockDelayTime() BACnetConstructedDataDoorUnlockDelayTimeBuilder
	// AsBACnetConstructedDataDutyWindow converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataDutyWindow() BACnetConstructedDataDutyWindowBuilder
	// AsBACnetConstructedDataEffectivePeriod converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataEffectivePeriod() BACnetConstructedDataEffectivePeriodBuilder
	// AsBACnetConstructedDataEgressActive converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataEgressActive() BACnetConstructedDataEgressActiveBuilder
	// AsBACnetConstructedDataEgressTime converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataEgressTime() BACnetConstructedDataEgressTimeBuilder
	// AsBACnetConstructedDataElapsedActiveTime converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataElapsedActiveTime() BACnetConstructedDataElapsedActiveTimeBuilder
	// AsBACnetConstructedDataElevatorGroup converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataElevatorGroup() BACnetConstructedDataElevatorGroupBuilder
	// AsBACnetConstructedDataEnable converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataEnable() BACnetConstructedDataEnableBuilder
	// AsBACnetConstructedDataEnergyMeter converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataEnergyMeter() BACnetConstructedDataEnergyMeterBuilder
	// AsBACnetConstructedDataEnergyMeterRef converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataEnergyMeterRef() BACnetConstructedDataEnergyMeterRefBuilder
	// AsBACnetConstructedDataEntryPoints converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataEntryPoints() BACnetConstructedDataEntryPointsBuilder
	// AsBACnetConstructedDataErrorLimit converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataErrorLimit() BACnetConstructedDataErrorLimitBuilder
	// AsBACnetConstructedDataEscalatorMode converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataEscalatorMode() BACnetConstructedDataEscalatorModeBuilder
	// AsBACnetConstructedDataEventAlgorithmInhibit converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataEventAlgorithmInhibit() BACnetConstructedDataEventAlgorithmInhibitBuilder
	// AsBACnetConstructedDataEventAlgorithmInhibitRef converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataEventAlgorithmInhibitRef() BACnetConstructedDataEventAlgorithmInhibitRefBuilder
	// AsBACnetConstructedDataEventDetectionEnable converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataEventDetectionEnable() BACnetConstructedDataEventDetectionEnableBuilder
	// AsBACnetConstructedDataEventEnable converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataEventEnable() BACnetConstructedDataEventEnableBuilder
	// AsBACnetConstructedDataEventMessageTexts converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataEventMessageTexts() BACnetConstructedDataEventMessageTextsBuilder
	// AsBACnetConstructedDataEventMessageTextsConfig converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataEventMessageTextsConfig() BACnetConstructedDataEventMessageTextsConfigBuilder
	// AsBACnetConstructedDataEventParameters converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataEventParameters() BACnetConstructedDataEventParametersBuilder
	// AsBACnetConstructedDataEventState converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataEventState() BACnetConstructedDataEventStateBuilder
	// AsBACnetConstructedDataEventTimeStamps converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataEventTimeStamps() BACnetConstructedDataEventTimeStampsBuilder
	// AsBACnetConstructedDataEventType converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataEventType() BACnetConstructedDataEventTypeBuilder
	// AsBACnetConstructedDataExceptionSchedule converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataExceptionSchedule() BACnetConstructedDataExceptionScheduleBuilder
	// AsBACnetConstructedDataExecutionDelay converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataExecutionDelay() BACnetConstructedDataExecutionDelayBuilder
	// AsBACnetConstructedDataExitPoints converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataExitPoints() BACnetConstructedDataExitPointsBuilder
	// AsBACnetConstructedDataExpectedShedLevel converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataExpectedShedLevel() BACnetConstructedDataExpectedShedLevelBuilder
	// AsBACnetConstructedDataExpirationTime converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataExpirationTime() BACnetConstructedDataExpirationTimeBuilder
	// AsBACnetConstructedDataExtendedTimeEnable converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataExtendedTimeEnable() BACnetConstructedDataExtendedTimeEnableBuilder
	// AsBACnetConstructedDataFailedAttemptEvents converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataFailedAttemptEvents() BACnetConstructedDataFailedAttemptEventsBuilder
	// AsBACnetConstructedDataFailedAttempts converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataFailedAttempts() BACnetConstructedDataFailedAttemptsBuilder
	// AsBACnetConstructedDataFailedAttemptsTime converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataFailedAttemptsTime() BACnetConstructedDataFailedAttemptsTimeBuilder
	// AsBACnetConstructedDataAccumulatorFaultHighLimit converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataAccumulatorFaultHighLimit() BACnetConstructedDataAccumulatorFaultHighLimitBuilder
	// AsBACnetConstructedDataAnalogInputFaultHighLimit converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataAnalogInputFaultHighLimit() BACnetConstructedDataAnalogInputFaultHighLimitBuilder
	// AsBACnetConstructedDataAnalogValueFaultHighLimit converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataAnalogValueFaultHighLimit() BACnetConstructedDataAnalogValueFaultHighLimitBuilder
	// AsBACnetConstructedDataIntegerValueFaultHighLimit converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataIntegerValueFaultHighLimit() BACnetConstructedDataIntegerValueFaultHighLimitBuilder
	// AsBACnetConstructedDataLargeAnalogValueFaultHighLimit converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataLargeAnalogValueFaultHighLimit() BACnetConstructedDataLargeAnalogValueFaultHighLimitBuilder
	// AsBACnetConstructedDataPositiveIntegerValueFaultHighLimit converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataPositiveIntegerValueFaultHighLimit() BACnetConstructedDataPositiveIntegerValueFaultHighLimitBuilder
	// AsBACnetConstructedDataFaultHighLimit converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataFaultHighLimit() BACnetConstructedDataFaultHighLimitBuilder
	// AsBACnetConstructedDataAccumulatorFaultLowLimit converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataAccumulatorFaultLowLimit() BACnetConstructedDataAccumulatorFaultLowLimitBuilder
	// AsBACnetConstructedDataAnalogInputFaultLowLimit converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataAnalogInputFaultLowLimit() BACnetConstructedDataAnalogInputFaultLowLimitBuilder
	// AsBACnetConstructedDataAnalogValueFaultLowLimit converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataAnalogValueFaultLowLimit() BACnetConstructedDataAnalogValueFaultLowLimitBuilder
	// AsBACnetConstructedDataLargeAnalogValueFaultLowLimit converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataLargeAnalogValueFaultLowLimit() BACnetConstructedDataLargeAnalogValueFaultLowLimitBuilder
	// AsBACnetConstructedDataIntegerValueFaultLowLimit converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataIntegerValueFaultLowLimit() BACnetConstructedDataIntegerValueFaultLowLimitBuilder
	// AsBACnetConstructedDataPositiveIntegerValueFaultLowLimit converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataPositiveIntegerValueFaultLowLimit() BACnetConstructedDataPositiveIntegerValueFaultLowLimitBuilder
	// AsBACnetConstructedDataFaultLowLimit converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataFaultLowLimit() BACnetConstructedDataFaultLowLimitBuilder
	// AsBACnetConstructedDataFaultParameters converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataFaultParameters() BACnetConstructedDataFaultParametersBuilder
	// AsBACnetConstructedDataEscalatorFaultSignals converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataEscalatorFaultSignals() BACnetConstructedDataEscalatorFaultSignalsBuilder
	// AsBACnetConstructedDataLiftFaultSignals converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataLiftFaultSignals() BACnetConstructedDataLiftFaultSignalsBuilder
	// AsBACnetConstructedDataFaultSignals converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataFaultSignals() BACnetConstructedDataFaultSignalsBuilder
	// AsBACnetConstructedDataFaultType converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataFaultType() BACnetConstructedDataFaultTypeBuilder
	// AsBACnetConstructedDataAccessDoorFaultValues converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataAccessDoorFaultValues() BACnetConstructedDataAccessDoorFaultValuesBuilder
	// AsBACnetConstructedDataCharacterStringValueFaultValues converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataCharacterStringValueFaultValues() BACnetConstructedDataCharacterStringValueFaultValuesBuilder
	// AsBACnetConstructedDataLifeSafetyPointFaultValues converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataLifeSafetyPointFaultValues() BACnetConstructedDataLifeSafetyPointFaultValuesBuilder
	// AsBACnetConstructedDataLifeSafetyZoneFaultValues converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataLifeSafetyZoneFaultValues() BACnetConstructedDataLifeSafetyZoneFaultValuesBuilder
	// AsBACnetConstructedDataMultiStateInputFaultValues converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataMultiStateInputFaultValues() BACnetConstructedDataMultiStateInputFaultValuesBuilder
	// AsBACnetConstructedDataMultiStateValueFaultValues converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataMultiStateValueFaultValues() BACnetConstructedDataMultiStateValueFaultValuesBuilder
	// AsBACnetConstructedDataFaultValues converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataFaultValues() BACnetConstructedDataFaultValuesBuilder
	// AsBACnetConstructedDataFDBBMDAddress converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataFDBBMDAddress() BACnetConstructedDataFDBBMDAddressBuilder
	// AsBACnetConstructedDataFDSubscriptionLifetime converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataFDSubscriptionLifetime() BACnetConstructedDataFDSubscriptionLifetimeBuilder
	// AsBACnetConstructedDataBinaryLightingOutputFeedbackValue converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataBinaryLightingOutputFeedbackValue() BACnetConstructedDataBinaryLightingOutputFeedbackValueBuilder
	// AsBACnetConstructedDataBinaryOutputFeedbackValue converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataBinaryOutputFeedbackValue() BACnetConstructedDataBinaryOutputFeedbackValueBuilder
	// AsBACnetConstructedDataLightingOutputFeedbackValue converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataLightingOutputFeedbackValue() BACnetConstructedDataLightingOutputFeedbackValueBuilder
	// AsBACnetConstructedDataMultiStateOutputFeedbackValue converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataMultiStateOutputFeedbackValue() BACnetConstructedDataMultiStateOutputFeedbackValueBuilder
	// AsBACnetConstructedDataFileAccessMethod converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataFileAccessMethod() BACnetConstructedDataFileAccessMethodBuilder
	// AsBACnetConstructedDataFileSize converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataFileSize() BACnetConstructedDataFileSizeBuilder
	// AsBACnetConstructedDataFileType converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataFileType() BACnetConstructedDataFileTypeBuilder
	// AsBACnetConstructedDataFirmwareRevision converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataFirmwareRevision() BACnetConstructedDataFirmwareRevisionBuilder
	// AsBACnetConstructedDataFloorText converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataFloorText() BACnetConstructedDataFloorTextBuilder
	// AsBACnetConstructedDataFullDutyBaseline converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataFullDutyBaseline() BACnetConstructedDataFullDutyBaselineBuilder
	// AsBACnetConstructedDataGlobalIdentifier converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataGlobalIdentifier() BACnetConstructedDataGlobalIdentifierBuilder
	// AsBACnetConstructedDataGroupID converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataGroupID() BACnetConstructedDataGroupIDBuilder
	// AsBACnetConstructedDataGroupMemberNames converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataGroupMemberNames() BACnetConstructedDataGroupMemberNamesBuilder
	// AsBACnetConstructedDataGlobalGroupGroupMembers converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataGlobalGroupGroupMembers() BACnetConstructedDataGlobalGroupGroupMembersBuilder
	// AsBACnetConstructedDataElevatorGroupGroupMembers converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataElevatorGroupGroupMembers() BACnetConstructedDataElevatorGroupGroupMembersBuilder
	// AsBACnetConstructedDataGroupMembers converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataGroupMembers() BACnetConstructedDataGroupMembersBuilder
	// AsBACnetConstructedDataGroupMode converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataGroupMode() BACnetConstructedDataGroupModeBuilder
	// AsBACnetConstructedDataAccumulatorHighLimit converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataAccumulatorHighLimit() BACnetConstructedDataAccumulatorHighLimitBuilder
	// AsBACnetConstructedDataLargeAnalogValueHighLimit converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataLargeAnalogValueHighLimit() BACnetConstructedDataLargeAnalogValueHighLimitBuilder
	// AsBACnetConstructedDataIntegerValueHighLimit converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataIntegerValueHighLimit() BACnetConstructedDataIntegerValueHighLimitBuilder
	// AsBACnetConstructedDataPositiveIntegerValueHighLimit converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataPositiveIntegerValueHighLimit() BACnetConstructedDataPositiveIntegerValueHighLimitBuilder
	// AsBACnetConstructedDataHighLimit converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataHighLimit() BACnetConstructedDataHighLimitBuilder
	// AsBACnetConstructedDataHigherDeck converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataHigherDeck() BACnetConstructedDataHigherDeckBuilder
	// AsBACnetConstructedDataInProcess converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataInProcess() BACnetConstructedDataInProcessBuilder
	// AsBACnetConstructedDataInProgress converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataInProgress() BACnetConstructedDataInProgressBuilder
	// AsBACnetConstructedDataInactiveText converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataInactiveText() BACnetConstructedDataInactiveTextBuilder
	// AsBACnetConstructedDataInitialTimeout converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataInitialTimeout() BACnetConstructedDataInitialTimeoutBuilder
	// AsBACnetConstructedDataInputReference converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataInputReference() BACnetConstructedDataInputReferenceBuilder
	// AsBACnetConstructedDataInstallationID converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataInstallationID() BACnetConstructedDataInstallationIDBuilder
	// AsBACnetConstructedDataInstanceOf converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataInstanceOf() BACnetConstructedDataInstanceOfBuilder
	// AsBACnetConstructedDataInstantaneousPower converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataInstantaneousPower() BACnetConstructedDataInstantaneousPowerBuilder
	// AsBACnetConstructedDataIntegralConstant converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataIntegralConstant() BACnetConstructedDataIntegralConstantBuilder
	// AsBACnetConstructedDataIntegralConstantUnits converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataIntegralConstantUnits() BACnetConstructedDataIntegralConstantUnitsBuilder
	// AsBACnetConstructedDataAnalogInputInterfaceValue converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataAnalogInputInterfaceValue() BACnetConstructedDataAnalogInputInterfaceValueBuilder
	// AsBACnetConstructedDataAnalogOutputInterfaceValue converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataAnalogOutputInterfaceValue() BACnetConstructedDataAnalogOutputInterfaceValueBuilder
	// AsBACnetConstructedDataBinaryInputInterfaceValue converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataBinaryInputInterfaceValue() BACnetConstructedDataBinaryInputInterfaceValueBuilder
	// AsBACnetConstructedDataBinaryOutputInterfaceValue converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataBinaryOutputInterfaceValue() BACnetConstructedDataBinaryOutputInterfaceValueBuilder
	// AsBACnetConstructedDataMultiStateInputInterfaceValue converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataMultiStateInputInterfaceValue() BACnetConstructedDataMultiStateInputInterfaceValueBuilder
	// AsBACnetConstructedDataMultiStateOutputInterfaceValue converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataMultiStateOutputInterfaceValue() BACnetConstructedDataMultiStateOutputInterfaceValueBuilder
	// AsBACnetConstructedDataIntervalOffset converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataIntervalOffset() BACnetConstructedDataIntervalOffsetBuilder
	// AsBACnetConstructedDataIPAddress converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataIPAddress() BACnetConstructedDataIPAddressBuilder
	// AsBACnetConstructedDataIPDefaultGateway converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataIPDefaultGateway() BACnetConstructedDataIPDefaultGatewayBuilder
	// AsBACnetConstructedDataIPDHCPEnable converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataIPDHCPEnable() BACnetConstructedDataIPDHCPEnableBuilder
	// AsBACnetConstructedDataIPDHCPLeaseTime converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataIPDHCPLeaseTime() BACnetConstructedDataIPDHCPLeaseTimeBuilder
	// AsBACnetConstructedDataIPDHCPLeaseTimeRemaining converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataIPDHCPLeaseTimeRemaining() BACnetConstructedDataIPDHCPLeaseTimeRemainingBuilder
	// AsBACnetConstructedDataIPDHCPServer converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataIPDHCPServer() BACnetConstructedDataIPDHCPServerBuilder
	// AsBACnetConstructedDataIPDNSServer converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataIPDNSServer() BACnetConstructedDataIPDNSServerBuilder
	// AsBACnetConstructedDataIPSubnetMask converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataIPSubnetMask() BACnetConstructedDataIPSubnetMaskBuilder
	// AsBACnetConstructedDataIPv6Address converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataIPv6Address() BACnetConstructedDataIPv6AddressBuilder
	// AsBACnetConstructedDataIPv6AutoAddressingEnable converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataIPv6AutoAddressingEnable() BACnetConstructedDataIPv6AutoAddressingEnableBuilder
	// AsBACnetConstructedDataIPv6DefaultGateway converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataIPv6DefaultGateway() BACnetConstructedDataIPv6DefaultGatewayBuilder
	// AsBACnetConstructedDataIPv6DHCPLeaseTime converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataIPv6DHCPLeaseTime() BACnetConstructedDataIPv6DHCPLeaseTimeBuilder
	// AsBACnetConstructedDataIPv6DHCPLeaseTimeRemaining converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataIPv6DHCPLeaseTimeRemaining() BACnetConstructedDataIPv6DHCPLeaseTimeRemainingBuilder
	// AsBACnetConstructedDataIPv6DHCPServer converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataIPv6DHCPServer() BACnetConstructedDataIPv6DHCPServerBuilder
	// AsBACnetConstructedDataIPv6DNSServer converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataIPv6DNSServer() BACnetConstructedDataIPv6DNSServerBuilder
	// AsBACnetConstructedDataIPv6PrefixLength converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataIPv6PrefixLength() BACnetConstructedDataIPv6PrefixLengthBuilder
	// AsBACnetConstructedDataIPv6ZoneIndex converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataIPv6ZoneIndex() BACnetConstructedDataIPv6ZoneIndexBuilder
	// AsBACnetConstructedDataIsUTC converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataIsUTC() BACnetConstructedDataIsUTCBuilder
	// AsBACnetConstructedDataKeySets converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataKeySets() BACnetConstructedDataKeySetsBuilder
	// AsBACnetConstructedDataLandingCallControl converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataLandingCallControl() BACnetConstructedDataLandingCallControlBuilder
	// AsBACnetConstructedDataLandingCalls converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataLandingCalls() BACnetConstructedDataLandingCallsBuilder
	// AsBACnetConstructedDataLandingDoorStatus converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataLandingDoorStatus() BACnetConstructedDataLandingDoorStatusBuilder
	// AsBACnetConstructedDataLastAccessEvent converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataLastAccessEvent() BACnetConstructedDataLastAccessEventBuilder
	// AsBACnetConstructedDataLastAccessPoint converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataLastAccessPoint() BACnetConstructedDataLastAccessPointBuilder
	// AsBACnetConstructedDataLastCommandTime converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataLastCommandTime() BACnetConstructedDataLastCommandTimeBuilder
	// AsBACnetConstructedDataLastCredentialAdded converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataLastCredentialAdded() BACnetConstructedDataLastCredentialAddedBuilder
	// AsBACnetConstructedDataLastCredentialAddedTime converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataLastCredentialAddedTime() BACnetConstructedDataLastCredentialAddedTimeBuilder
	// AsBACnetConstructedDataLastCredentialRemoved converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataLastCredentialRemoved() BACnetConstructedDataLastCredentialRemovedBuilder
	// AsBACnetConstructedDataLastCredentialRemovedTime converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataLastCredentialRemovedTime() BACnetConstructedDataLastCredentialRemovedTimeBuilder
	// AsBACnetConstructedDataLastKeyServer converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataLastKeyServer() BACnetConstructedDataLastKeyServerBuilder
	// AsBACnetConstructedDataLastNotifyRecord converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataLastNotifyRecord() BACnetConstructedDataLastNotifyRecordBuilder
	// AsBACnetConstructedDataLastPriority converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataLastPriority() BACnetConstructedDataLastPriorityBuilder
	// AsBACnetConstructedDataLastRestartReason converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataLastRestartReason() BACnetConstructedDataLastRestartReasonBuilder
	// AsBACnetConstructedDataLastRestoreTime converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataLastRestoreTime() BACnetConstructedDataLastRestoreTimeBuilder
	// AsBACnetConstructedDataLastStateChange converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataLastStateChange() BACnetConstructedDataLastStateChangeBuilder
	// AsBACnetConstructedDataLastUseTime converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataLastUseTime() BACnetConstructedDataLastUseTimeBuilder
	// AsBACnetConstructedDataLifeSafetyAlarmValues converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataLifeSafetyAlarmValues() BACnetConstructedDataLifeSafetyAlarmValuesBuilder
	// AsBACnetConstructedDataLightingCommand converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataLightingCommand() BACnetConstructedDataLightingCommandBuilder
	// AsBACnetConstructedDataLightingCommandDefaultPriority converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataLightingCommandDefaultPriority() BACnetConstructedDataLightingCommandDefaultPriorityBuilder
	// AsBACnetConstructedDataLimitEnable converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataLimitEnable() BACnetConstructedDataLimitEnableBuilder
	// AsBACnetConstructedDataLimitMonitoringInterval converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataLimitMonitoringInterval() BACnetConstructedDataLimitMonitoringIntervalBuilder
	// AsBACnetConstructedDataLinkSpeed converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataLinkSpeed() BACnetConstructedDataLinkSpeedBuilder
	// AsBACnetConstructedDataLinkSpeedAutonegotiate converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataLinkSpeedAutonegotiate() BACnetConstructedDataLinkSpeedAutonegotiateBuilder
	// AsBACnetConstructedDataLinkSpeeds converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataLinkSpeeds() BACnetConstructedDataLinkSpeedsBuilder
	// AsBACnetConstructedDataListOfGroupMembers converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataListOfGroupMembers() BACnetConstructedDataListOfGroupMembersBuilder
	// AsBACnetConstructedDataChannelListOfObjectPropertyReferences converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataChannelListOfObjectPropertyReferences() BACnetConstructedDataChannelListOfObjectPropertyReferencesBuilder
	// AsBACnetConstructedDataListOfObjectPropertyReferences converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataListOfObjectPropertyReferences() BACnetConstructedDataListOfObjectPropertyReferencesBuilder
	// AsBACnetConstructedDataLocalDate converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataLocalDate() BACnetConstructedDataLocalDateBuilder
	// AsBACnetConstructedDataLocalForwardingOnly converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataLocalForwardingOnly() BACnetConstructedDataLocalForwardingOnlyBuilder
	// AsBACnetConstructedDataLocalTime converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataLocalTime() BACnetConstructedDataLocalTimeBuilder
	// AsBACnetConstructedDataLocation converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataLocation() BACnetConstructedDataLocationBuilder
	// AsBACnetConstructedDataLockStatus converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataLockStatus() BACnetConstructedDataLockStatusBuilder
	// AsBACnetConstructedDataLockout converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataLockout() BACnetConstructedDataLockoutBuilder
	// AsBACnetConstructedDataLockoutRelinquishTime converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataLockoutRelinquishTime() BACnetConstructedDataLockoutRelinquishTimeBuilder
	// AsBACnetConstructedDataEventLogLogBuffer converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataEventLogLogBuffer() BACnetConstructedDataEventLogLogBufferBuilder
	// AsBACnetConstructedDataTrendLogLogBuffer converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataTrendLogLogBuffer() BACnetConstructedDataTrendLogLogBufferBuilder
	// AsBACnetConstructedDataTrendLogMultipleLogBuffer converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataTrendLogMultipleLogBuffer() BACnetConstructedDataTrendLogMultipleLogBufferBuilder
	// AsBACnetConstructedDataLogBuffer converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataLogBuffer() BACnetConstructedDataLogBufferBuilder
	// AsBACnetConstructedDataTrendLogLogDeviceObjectProperty converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataTrendLogLogDeviceObjectProperty() BACnetConstructedDataTrendLogLogDeviceObjectPropertyBuilder
	// AsBACnetConstructedDataTrendLogMultipleLogDeviceObjectProperty converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataTrendLogMultipleLogDeviceObjectProperty() BACnetConstructedDataTrendLogMultipleLogDeviceObjectPropertyBuilder
	// AsBACnetConstructedDataLogDeviceObjectProperty converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataLogDeviceObjectProperty() BACnetConstructedDataLogDeviceObjectPropertyBuilder
	// AsBACnetConstructedDataLogInterval converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataLogInterval() BACnetConstructedDataLogIntervalBuilder
	// AsBACnetConstructedDataLoggingObject converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataLoggingObject() BACnetConstructedDataLoggingObjectBuilder
	// AsBACnetConstructedDataLoggingRecord converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataLoggingRecord() BACnetConstructedDataLoggingRecordBuilder
	// AsBACnetConstructedDataLoggingType converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataLoggingType() BACnetConstructedDataLoggingTypeBuilder
	// AsBACnetConstructedDataLowDiffLimit converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataLowDiffLimit() BACnetConstructedDataLowDiffLimitBuilder
	// AsBACnetConstructedDataAccumulatorLowLimit converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataAccumulatorLowLimit() BACnetConstructedDataAccumulatorLowLimitBuilder
	// AsBACnetConstructedDataLargeAnalogValueLowLimit converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataLargeAnalogValueLowLimit() BACnetConstructedDataLargeAnalogValueLowLimitBuilder
	// AsBACnetConstructedDataIntegerValueLowLimit converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataIntegerValueLowLimit() BACnetConstructedDataIntegerValueLowLimitBuilder
	// AsBACnetConstructedDataPositiveIntegerValueLowLimit converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataPositiveIntegerValueLowLimit() BACnetConstructedDataPositiveIntegerValueLowLimitBuilder
	// AsBACnetConstructedDataLowLimit converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataLowLimit() BACnetConstructedDataLowLimitBuilder
	// AsBACnetConstructedDataLowerDeck converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataLowerDeck() BACnetConstructedDataLowerDeckBuilder
	// AsBACnetConstructedDataMACAddress converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataMACAddress() BACnetConstructedDataMACAddressBuilder
	// AsBACnetConstructedDataMachineRoomID converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataMachineRoomID() BACnetConstructedDataMachineRoomIDBuilder
	// AsBACnetConstructedDataLifeSafetyZoneMaintenanceRequired converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataLifeSafetyZoneMaintenanceRequired() BACnetConstructedDataLifeSafetyZoneMaintenanceRequiredBuilder
	// AsBACnetConstructedDataMaintenanceRequired converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataMaintenanceRequired() BACnetConstructedDataMaintenanceRequiredBuilder
	// AsBACnetConstructedDataMakingCarCall converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataMakingCarCall() BACnetConstructedDataMakingCarCallBuilder
	// AsBACnetConstructedDataManipulatedVariableReference converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataManipulatedVariableReference() BACnetConstructedDataManipulatedVariableReferenceBuilder
	// AsBACnetConstructedDataManualSlaveAddressBinding converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataManualSlaveAddressBinding() BACnetConstructedDataManualSlaveAddressBindingBuilder
	// AsBACnetConstructedDataMaskedAlarmValues converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataMaskedAlarmValues() BACnetConstructedDataMaskedAlarmValuesBuilder
	// AsBACnetConstructedDataMaxActualValue converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataMaxActualValue() BACnetConstructedDataMaxActualValueBuilder
	// AsBACnetConstructedDataMaxAPDULengthAccepted converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataMaxAPDULengthAccepted() BACnetConstructedDataMaxAPDULengthAcceptedBuilder
	// AsBACnetConstructedDataMaxFailedAttempts converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataMaxFailedAttempts() BACnetConstructedDataMaxFailedAttemptsBuilder
	// AsBACnetConstructedDataDeviceMaxInfoFrames converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataDeviceMaxInfoFrames() BACnetConstructedDataDeviceMaxInfoFramesBuilder
	// AsBACnetConstructedDataNetworkPortMaxInfoFrames converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataNetworkPortMaxInfoFrames() BACnetConstructedDataNetworkPortMaxInfoFramesBuilder
	// AsBACnetConstructedDataMaxInfoFrames converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataMaxInfoFrames() BACnetConstructedDataMaxInfoFramesBuilder
	// AsBACnetConstructedDataDeviceMaxMaster converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataDeviceMaxMaster() BACnetConstructedDataDeviceMaxMasterBuilder
	// AsBACnetConstructedDataNetworkPortMaxMaster converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataNetworkPortMaxMaster() BACnetConstructedDataNetworkPortMaxMasterBuilder
	// AsBACnetConstructedDataMaxMaster converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataMaxMaster() BACnetConstructedDataMaxMasterBuilder
	// AsBACnetConstructedDataAccumulatorMaxPresValue converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataAccumulatorMaxPresValue() BACnetConstructedDataAccumulatorMaxPresValueBuilder
	// AsBACnetConstructedDataAnalogInputMaxPresValue converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataAnalogInputMaxPresValue() BACnetConstructedDataAnalogInputMaxPresValueBuilder
	// AsBACnetConstructedDataAnalogOutputMaxPresValue converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataAnalogOutputMaxPresValue() BACnetConstructedDataAnalogOutputMaxPresValueBuilder
	// AsBACnetConstructedDataAnalogValueMaxPresValue converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataAnalogValueMaxPresValue() BACnetConstructedDataAnalogValueMaxPresValueBuilder
	// AsBACnetConstructedDataLargeAnalogValueMaxPresValue converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataLargeAnalogValueMaxPresValue() BACnetConstructedDataLargeAnalogValueMaxPresValueBuilder
	// AsBACnetConstructedDataIntegerValueMaxPresValue converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataIntegerValueMaxPresValue() BACnetConstructedDataIntegerValueMaxPresValueBuilder
	// AsBACnetConstructedDataPositiveIntegerValueMaxPresValue converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataPositiveIntegerValueMaxPresValue() BACnetConstructedDataPositiveIntegerValueMaxPresValueBuilder
	// AsBACnetConstructedDataTimerMaxPresValue converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataTimerMaxPresValue() BACnetConstructedDataTimerMaxPresValueBuilder
	// AsBACnetConstructedDataMaxPresValue converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataMaxPresValue() BACnetConstructedDataMaxPresValueBuilder
	// AsBACnetConstructedDataMaxSegmentsAccepted converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataMaxSegmentsAccepted() BACnetConstructedDataMaxSegmentsAcceptedBuilder
	// AsBACnetConstructedDataMaximumOutput converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataMaximumOutput() BACnetConstructedDataMaximumOutputBuilder
	// AsBACnetConstructedDataMaximumValue converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataMaximumValue() BACnetConstructedDataMaximumValueBuilder
	// AsBACnetConstructedDataMaximumValueTimestamp converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataMaximumValueTimestamp() BACnetConstructedDataMaximumValueTimestampBuilder
	// AsBACnetConstructedDataMemberOf converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataMemberOf() BACnetConstructedDataMemberOfBuilder
	// AsBACnetConstructedDataMemberStatusFlags converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataMemberStatusFlags() BACnetConstructedDataMemberStatusFlagsBuilder
	// AsBACnetConstructedDataMembers converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataMembers() BACnetConstructedDataMembersBuilder
	// AsBACnetConstructedDataMinActualValue converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataMinActualValue() BACnetConstructedDataMinActualValueBuilder
	// AsBACnetConstructedDataAccumulatorMinPresValue converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataAccumulatorMinPresValue() BACnetConstructedDataAccumulatorMinPresValueBuilder
	// AsBACnetConstructedDataIntegerValueMinPresValue converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataIntegerValueMinPresValue() BACnetConstructedDataIntegerValueMinPresValueBuilder
	// AsBACnetConstructedDataPositiveIntegerValueMinPresValue converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataPositiveIntegerValueMinPresValue() BACnetConstructedDataPositiveIntegerValueMinPresValueBuilder
	// AsBACnetConstructedDataLargeAnalogValueMinPresValue converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataLargeAnalogValueMinPresValue() BACnetConstructedDataLargeAnalogValueMinPresValueBuilder
	// AsBACnetConstructedDataTimerMinPresValue converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataTimerMinPresValue() BACnetConstructedDataTimerMinPresValueBuilder
	// AsBACnetConstructedDataMinPresValue converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataMinPresValue() BACnetConstructedDataMinPresValueBuilder
	// AsBACnetConstructedDataMinimumOffTime converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataMinimumOffTime() BACnetConstructedDataMinimumOffTimeBuilder
	// AsBACnetConstructedDataMinimumOnTime converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataMinimumOnTime() BACnetConstructedDataMinimumOnTimeBuilder
	// AsBACnetConstructedDataMinimumOutput converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataMinimumOutput() BACnetConstructedDataMinimumOutputBuilder
	// AsBACnetConstructedDataMinimumValue converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataMinimumValue() BACnetConstructedDataMinimumValueBuilder
	// AsBACnetConstructedDataMinimumValueTimestamp converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataMinimumValueTimestamp() BACnetConstructedDataMinimumValueTimestampBuilder
	// AsBACnetConstructedDataMode converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataMode() BACnetConstructedDataModeBuilder
	// AsBACnetConstructedDataModelName converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataModelName() BACnetConstructedDataModelNameBuilder
	// AsBACnetConstructedDataModificationDate converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataModificationDate() BACnetConstructedDataModificationDateBuilder
	// AsBACnetConstructedDataMusterPoint converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataMusterPoint() BACnetConstructedDataMusterPointBuilder
	// AsBACnetConstructedDataNegativeAccessRules converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataNegativeAccessRules() BACnetConstructedDataNegativeAccessRulesBuilder
	// AsBACnetConstructedDataNetworkAccessSecurityPolicies converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataNetworkAccessSecurityPolicies() BACnetConstructedDataNetworkAccessSecurityPoliciesBuilder
	// AsBACnetConstructedDataNetworkInterfaceName converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataNetworkInterfaceName() BACnetConstructedDataNetworkInterfaceNameBuilder
	// AsBACnetConstructedDataNetworkNumber converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataNetworkNumber() BACnetConstructedDataNetworkNumberBuilder
	// AsBACnetConstructedDataNetworkNumberQuality converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataNetworkNumberQuality() BACnetConstructedDataNetworkNumberQualityBuilder
	// AsBACnetConstructedDataNetworkType converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataNetworkType() BACnetConstructedDataNetworkTypeBuilder
	// AsBACnetConstructedDataNextStoppingFloor converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataNextStoppingFloor() BACnetConstructedDataNextStoppingFloorBuilder
	// AsBACnetConstructedDataNodeSubtype converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataNodeSubtype() BACnetConstructedDataNodeSubtypeBuilder
	// AsBACnetConstructedDataNodeType converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataNodeType() BACnetConstructedDataNodeTypeBuilder
	// AsBACnetConstructedDataNotificationClass converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataNotificationClass() BACnetConstructedDataNotificationClassBuilder
	// AsBACnetConstructedDataNotificationThreshold converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataNotificationThreshold() BACnetConstructedDataNotificationThresholdBuilder
	// AsBACnetConstructedDataNotifyType converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataNotifyType() BACnetConstructedDataNotifyTypeBuilder
	// AsBACnetConstructedDataNumberOfAPDURetries converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataNumberOfAPDURetries() BACnetConstructedDataNumberOfAPDURetriesBuilder
	// AsBACnetConstructedDataNumberOfAuthenticationPolicies converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataNumberOfAuthenticationPolicies() BACnetConstructedDataNumberOfAuthenticationPoliciesBuilder
	// AsBACnetConstructedDataNumberOfStates converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataNumberOfStates() BACnetConstructedDataNumberOfStatesBuilder
	// AsBACnetConstructedDataObjectIdentifier converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataObjectIdentifier() BACnetConstructedDataObjectIdentifierBuilder
	// AsBACnetConstructedDataObjectList converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataObjectList() BACnetConstructedDataObjectListBuilder
	// AsBACnetConstructedDataObjectName converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataObjectName() BACnetConstructedDataObjectNameBuilder
	// AsBACnetConstructedDataObjectPropertyReference converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataObjectPropertyReference() BACnetConstructedDataObjectPropertyReferenceBuilder
	// AsBACnetConstructedDataObjectType converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataObjectType() BACnetConstructedDataObjectTypeBuilder
	// AsBACnetConstructedDataOccupancyCount converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataOccupancyCount() BACnetConstructedDataOccupancyCountBuilder
	// AsBACnetConstructedDataOccupancyCountAdjust converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataOccupancyCountAdjust() BACnetConstructedDataOccupancyCountAdjustBuilder
	// AsBACnetConstructedDataOccupancyCountEnable converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataOccupancyCountEnable() BACnetConstructedDataOccupancyCountEnableBuilder
	// AsBACnetConstructedDataOccupancyLowerLimit converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataOccupancyLowerLimit() BACnetConstructedDataOccupancyLowerLimitBuilder
	// AsBACnetConstructedDataOccupancyLowerLimitEnforced converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataOccupancyLowerLimitEnforced() BACnetConstructedDataOccupancyLowerLimitEnforcedBuilder
	// AsBACnetConstructedDataOccupancyState converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataOccupancyState() BACnetConstructedDataOccupancyStateBuilder
	// AsBACnetConstructedDataOccupancyUpperLimit converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataOccupancyUpperLimit() BACnetConstructedDataOccupancyUpperLimitBuilder
	// AsBACnetConstructedDataOccupancyUpperLimitEnforced converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataOccupancyUpperLimitEnforced() BACnetConstructedDataOccupancyUpperLimitEnforcedBuilder
	// AsBACnetConstructedDataOperationDirection converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataOperationDirection() BACnetConstructedDataOperationDirectionBuilder
	// AsBACnetConstructedDataOperationExpected converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataOperationExpected() BACnetConstructedDataOperationExpectedBuilder
	// AsBACnetConstructedDataOptional converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataOptional() BACnetConstructedDataOptionalBuilder
	// AsBACnetConstructedDataOutOfService converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataOutOfService() BACnetConstructedDataOutOfServiceBuilder
	// AsBACnetConstructedDataOutputUnits converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataOutputUnits() BACnetConstructedDataOutputUnitsBuilder
	// AsBACnetConstructedDataPacketReorderTime converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataPacketReorderTime() BACnetConstructedDataPacketReorderTimeBuilder
	// AsBACnetConstructedDataPassbackMode converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataPassbackMode() BACnetConstructedDataPassbackModeBuilder
	// AsBACnetConstructedDataPassbackTimeout converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataPassbackTimeout() BACnetConstructedDataPassbackTimeoutBuilder
	// AsBACnetConstructedDataPassengerAlarm converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataPassengerAlarm() BACnetConstructedDataPassengerAlarmBuilder
	// AsBACnetConstructedDataPolarity converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataPolarity() BACnetConstructedDataPolarityBuilder
	// AsBACnetConstructedDataPortFilter converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataPortFilter() BACnetConstructedDataPortFilterBuilder
	// AsBACnetConstructedDataPositiveAccessRules converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataPositiveAccessRules() BACnetConstructedDataPositiveAccessRulesBuilder
	// AsBACnetConstructedDataPower converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataPower() BACnetConstructedDataPowerBuilder
	// AsBACnetConstructedDataPowerMode converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataPowerMode() BACnetConstructedDataPowerModeBuilder
	// AsBACnetConstructedDataPrescale converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataPrescale() BACnetConstructedDataPrescaleBuilder
	// AsBACnetConstructedDataAccessDoorPresentValue converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataAccessDoorPresentValue() BACnetConstructedDataAccessDoorPresentValueBuilder
	// AsBACnetConstructedDataAlertEnrollmentPresentValue converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataAlertEnrollmentPresentValue() BACnetConstructedDataAlertEnrollmentPresentValueBuilder
	// AsBACnetConstructedDataAnalogInputPresentValue converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataAnalogInputPresentValue() BACnetConstructedDataAnalogInputPresentValueBuilder
	// AsBACnetConstructedDataAnalogOutputPresentValue converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataAnalogOutputPresentValue() BACnetConstructedDataAnalogOutputPresentValueBuilder
	// AsBACnetConstructedDataAnalogValuePresentValue converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataAnalogValuePresentValue() BACnetConstructedDataAnalogValuePresentValueBuilder
	// AsBACnetConstructedDataBinaryInputPresentValue converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataBinaryInputPresentValue() BACnetConstructedDataBinaryInputPresentValueBuilder
	// AsBACnetConstructedDataBinaryOutputPresentValue converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataBinaryOutputPresentValue() BACnetConstructedDataBinaryOutputPresentValueBuilder
	// AsBACnetConstructedDataBinaryValuePresentValue converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataBinaryValuePresentValue() BACnetConstructedDataBinaryValuePresentValueBuilder
	// AsBACnetConstructedDataBinaryLightingOutputPresentValue converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataBinaryLightingOutputPresentValue() BACnetConstructedDataBinaryLightingOutputPresentValueBuilder
	// AsBACnetConstructedDataBitStringValuePresentValue converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataBitStringValuePresentValue() BACnetConstructedDataBitStringValuePresentValueBuilder
	// AsBACnetConstructedDataCalendarPresentValue converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataCalendarPresentValue() BACnetConstructedDataCalendarPresentValueBuilder
	// AsBACnetConstructedDataChannelPresentValue converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataChannelPresentValue() BACnetConstructedDataChannelPresentValueBuilder
	// AsBACnetConstructedDataCharacterStringValuePresentValue converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataCharacterStringValuePresentValue() BACnetConstructedDataCharacterStringValuePresentValueBuilder
	// AsBACnetConstructedDataCredentialDataInputPresentValue converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataCredentialDataInputPresentValue() BACnetConstructedDataCredentialDataInputPresentValueBuilder
	// AsBACnetConstructedDataDateValuePresentValue converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataDateValuePresentValue() BACnetConstructedDataDateValuePresentValueBuilder
	// AsBACnetConstructedDataDatePatternValuePresentValue converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataDatePatternValuePresentValue() BACnetConstructedDataDatePatternValuePresentValueBuilder
	// AsBACnetConstructedDataDateTimeValuePresentValue converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataDateTimeValuePresentValue() BACnetConstructedDataDateTimeValuePresentValueBuilder
	// AsBACnetConstructedDataDateTimePatternValuePresentValue converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataDateTimePatternValuePresentValue() BACnetConstructedDataDateTimePatternValuePresentValueBuilder
	// AsBACnetConstructedDataIntegerValuePresentValue converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataIntegerValuePresentValue() BACnetConstructedDataIntegerValuePresentValueBuilder
	// AsBACnetConstructedDataLargeAnalogValuePresentValue converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataLargeAnalogValuePresentValue() BACnetConstructedDataLargeAnalogValuePresentValueBuilder
	// AsBACnetConstructedDataLightingOutputPresentValue converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataLightingOutputPresentValue() BACnetConstructedDataLightingOutputPresentValueBuilder
	// AsBACnetConstructedDataLifeSafetyPointPresentValue converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataLifeSafetyPointPresentValue() BACnetConstructedDataLifeSafetyPointPresentValueBuilder
	// AsBACnetConstructedDataLifeSafetyZonePresentValue converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataLifeSafetyZonePresentValue() BACnetConstructedDataLifeSafetyZonePresentValueBuilder
	// AsBACnetConstructedDataLoadControlPresentValue converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataLoadControlPresentValue() BACnetConstructedDataLoadControlPresentValueBuilder
	// AsBACnetConstructedDataLoopPresentValue converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataLoopPresentValue() BACnetConstructedDataLoopPresentValueBuilder
	// AsBACnetConstructedDataPulseConverterPresentValue converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataPulseConverterPresentValue() BACnetConstructedDataPulseConverterPresentValueBuilder
	// AsBACnetConstructedDataGroupPresentValue converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataGroupPresentValue() BACnetConstructedDataGroupPresentValueBuilder
	// AsBACnetConstructedDataGlobalGroupPresentValue converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataGlobalGroupPresentValue() BACnetConstructedDataGlobalGroupPresentValueBuilder
	// AsBACnetConstructedDataOctetStringValuePresentValue converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataOctetStringValuePresentValue() BACnetConstructedDataOctetStringValuePresentValueBuilder
	// AsBACnetConstructedDataSchedulePresentValue converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataSchedulePresentValue() BACnetConstructedDataSchedulePresentValueBuilder
	// AsBACnetConstructedDataTimeValuePresentValue converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataTimeValuePresentValue() BACnetConstructedDataTimeValuePresentValueBuilder
	// AsBACnetConstructedDataTimePatternValuePresentValue converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataTimePatternValuePresentValue() BACnetConstructedDataTimePatternValuePresentValueBuilder
	// AsBACnetConstructedDataPresentValue converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataPresentValue() BACnetConstructedDataPresentValueBuilder
	// AsBACnetConstructedDataPriority converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataPriority() BACnetConstructedDataPriorityBuilder
	// AsBACnetConstructedDataPriorityArray converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataPriorityArray() BACnetConstructedDataPriorityArrayBuilder
	// AsBACnetConstructedDataPriorityForWriting converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataPriorityForWriting() BACnetConstructedDataPriorityForWritingBuilder
	// AsBACnetConstructedDataProcessIdentifier converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataProcessIdentifier() BACnetConstructedDataProcessIdentifierBuilder
	// AsBACnetConstructedDataProcessIdentifierFilter converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataProcessIdentifierFilter() BACnetConstructedDataProcessIdentifierFilterBuilder
	// AsBACnetConstructedDataProfileLocation converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataProfileLocation() BACnetConstructedDataProfileLocationBuilder
	// AsBACnetConstructedDataProfileName converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataProfileName() BACnetConstructedDataProfileNameBuilder
	// AsBACnetConstructedDataProgramChange converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataProgramChange() BACnetConstructedDataProgramChangeBuilder
	// AsBACnetConstructedDataProgramLocation converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataProgramLocation() BACnetConstructedDataProgramLocationBuilder
	// AsBACnetConstructedDataProgramState converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataProgramState() BACnetConstructedDataProgramStateBuilder
	// AsBACnetConstructedDataPropertyList converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataPropertyList() BACnetConstructedDataPropertyListBuilder
	// AsBACnetConstructedDataProportionalConstant converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataProportionalConstant() BACnetConstructedDataProportionalConstantBuilder
	// AsBACnetConstructedDataProportionalConstantUnits converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataProportionalConstantUnits() BACnetConstructedDataProportionalConstantUnitsBuilder
	// AsBACnetConstructedDataProtocolLevel converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataProtocolLevel() BACnetConstructedDataProtocolLevelBuilder
	// AsBACnetConstructedDataProtocolObjectTypesSupported converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataProtocolObjectTypesSupported() BACnetConstructedDataProtocolObjectTypesSupportedBuilder
	// AsBACnetConstructedDataProtocolRevision converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataProtocolRevision() BACnetConstructedDataProtocolRevisionBuilder
	// AsBACnetConstructedDataProtocolServicesSupported converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataProtocolServicesSupported() BACnetConstructedDataProtocolServicesSupportedBuilder
	// AsBACnetConstructedDataProtocolVersion converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataProtocolVersion() BACnetConstructedDataProtocolVersionBuilder
	// AsBACnetConstructedDataPulseRate converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataPulseRate() BACnetConstructedDataPulseRateBuilder
	// AsBACnetConstructedDataReadOnly converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataReadOnly() BACnetConstructedDataReadOnlyBuilder
	// AsBACnetConstructedDataReasonForDisable converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataReasonForDisable() BACnetConstructedDataReasonForDisableBuilder
	// AsBACnetConstructedDataReasonForHalt converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataReasonForHalt() BACnetConstructedDataReasonForHaltBuilder
	// AsBACnetConstructedDataRecipientList converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataRecipientList() BACnetConstructedDataRecipientListBuilder
	// AsBACnetConstructedDataFileRecordCount converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataFileRecordCount() BACnetConstructedDataFileRecordCountBuilder
	// AsBACnetConstructedDataRecordCount converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataRecordCount() BACnetConstructedDataRecordCountBuilder
	// AsBACnetConstructedDataRecordsSinceNotification converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataRecordsSinceNotification() BACnetConstructedDataRecordsSinceNotificationBuilder
	// AsBACnetConstructedDataReferencePort converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataReferencePort() BACnetConstructedDataReferencePortBuilder
	// AsBACnetConstructedDataRegisteredCarCall converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataRegisteredCarCall() BACnetConstructedDataRegisteredCarCallBuilder
	// AsBACnetConstructedDataReliability converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataReliability() BACnetConstructedDataReliabilityBuilder
	// AsBACnetConstructedDataReliabilityEvaluationInhibit converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataReliabilityEvaluationInhibit() BACnetConstructedDataReliabilityEvaluationInhibitBuilder
	// AsBACnetConstructedDataAccessDoorRelinquishDefault converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataAccessDoorRelinquishDefault() BACnetConstructedDataAccessDoorRelinquishDefaultBuilder
	// AsBACnetConstructedDataAnalogOutputRelinquishDefault converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataAnalogOutputRelinquishDefault() BACnetConstructedDataAnalogOutputRelinquishDefaultBuilder
	// AsBACnetConstructedDataAnalogValueRelinquishDefault converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataAnalogValueRelinquishDefault() BACnetConstructedDataAnalogValueRelinquishDefaultBuilder
	// AsBACnetConstructedDataBinaryOutputRelinquishDefault converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataBinaryOutputRelinquishDefault() BACnetConstructedDataBinaryOutputRelinquishDefaultBuilder
	// AsBACnetConstructedDataBinaryValueRelinquishDefault converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataBinaryValueRelinquishDefault() BACnetConstructedDataBinaryValueRelinquishDefaultBuilder
	// AsBACnetConstructedDataBinaryLightingOutputRelinquishDefault converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataBinaryLightingOutputRelinquishDefault() BACnetConstructedDataBinaryLightingOutputRelinquishDefaultBuilder
	// AsBACnetConstructedDataBitStringValueRelinquishDefault converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataBitStringValueRelinquishDefault() BACnetConstructedDataBitStringValueRelinquishDefaultBuilder
	// AsBACnetConstructedDataCharacterStringValueRelinquishDefault converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataCharacterStringValueRelinquishDefault() BACnetConstructedDataCharacterStringValueRelinquishDefaultBuilder
	// AsBACnetConstructedDataDateValueRelinquishDefault converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataDateValueRelinquishDefault() BACnetConstructedDataDateValueRelinquishDefaultBuilder
	// AsBACnetConstructedDataDatePatternValueRelinquishDefault converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataDatePatternValueRelinquishDefault() BACnetConstructedDataDatePatternValueRelinquishDefaultBuilder
	// AsBACnetConstructedDataDateTimeValueRelinquishDefault converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataDateTimeValueRelinquishDefault() BACnetConstructedDataDateTimeValueRelinquishDefaultBuilder
	// AsBACnetConstructedDataDateTimePatternValueRelinquishDefault converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataDateTimePatternValueRelinquishDefault() BACnetConstructedDataDateTimePatternValueRelinquishDefaultBuilder
	// AsBACnetConstructedDataLargeAnalogValueRelinquishDefault converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataLargeAnalogValueRelinquishDefault() BACnetConstructedDataLargeAnalogValueRelinquishDefaultBuilder
	// AsBACnetConstructedDataLightingOutputRelinquishDefault converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataLightingOutputRelinquishDefault() BACnetConstructedDataLightingOutputRelinquishDefaultBuilder
	// AsBACnetConstructedDataTimePatternValueRelinquishDefault converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataTimePatternValueRelinquishDefault() BACnetConstructedDataTimePatternValueRelinquishDefaultBuilder
	// AsBACnetConstructedDataTimeValueRelinquishDefault converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataTimeValueRelinquishDefault() BACnetConstructedDataTimeValueRelinquishDefaultBuilder
	// AsBACnetConstructedDataIntegerValueRelinquishDefault converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataIntegerValueRelinquishDefault() BACnetConstructedDataIntegerValueRelinquishDefaultBuilder
	// AsBACnetConstructedDataOctetStringValueRelinquishDefault converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataOctetStringValueRelinquishDefault() BACnetConstructedDataOctetStringValueRelinquishDefaultBuilder
	// AsBACnetConstructedDataPositiveIntegerValueRelinquishDefault converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataPositiveIntegerValueRelinquishDefault() BACnetConstructedDataPositiveIntegerValueRelinquishDefaultBuilder
	// AsBACnetConstructedDataMultiStateOutputRelinquishDefault converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataMultiStateOutputRelinquishDefault() BACnetConstructedDataMultiStateOutputRelinquishDefaultBuilder
	// AsBACnetConstructedDataMultiStateValueRelinquishDefault converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataMultiStateValueRelinquishDefault() BACnetConstructedDataMultiStateValueRelinquishDefaultBuilder
	// AsBACnetConstructedDataRelinquishDefault converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataRelinquishDefault() BACnetConstructedDataRelinquishDefaultBuilder
	// AsBACnetConstructedDataRepresents converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataRepresents() BACnetConstructedDataRepresentsBuilder
	// AsBACnetConstructedDataRequestedShedLevel converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataRequestedShedLevel() BACnetConstructedDataRequestedShedLevelBuilder
	// AsBACnetConstructedDataRequestedUpdateInterval converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataRequestedUpdateInterval() BACnetConstructedDataRequestedUpdateIntervalBuilder
	// AsBACnetConstructedDataRequired converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataRequired() BACnetConstructedDataRequiredBuilder
	// AsBACnetConstructedDataLargeAnalogValueResolution converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataLargeAnalogValueResolution() BACnetConstructedDataLargeAnalogValueResolutionBuilder
	// AsBACnetConstructedDataIntegerValueResolution converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataIntegerValueResolution() BACnetConstructedDataIntegerValueResolutionBuilder
	// AsBACnetConstructedDataPositiveIntegerValueResolution converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataPositiveIntegerValueResolution() BACnetConstructedDataPositiveIntegerValueResolutionBuilder
	// AsBACnetConstructedDataTimerResolution converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataTimerResolution() BACnetConstructedDataTimerResolutionBuilder
	// AsBACnetConstructedDataResolution converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataResolution() BACnetConstructedDataResolutionBuilder
	// AsBACnetConstructedDataRestartNotificationRecipients converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataRestartNotificationRecipients() BACnetConstructedDataRestartNotificationRecipientsBuilder
	// AsBACnetConstructedDataRestoreCompletionTime converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataRestoreCompletionTime() BACnetConstructedDataRestoreCompletionTimeBuilder
	// AsBACnetConstructedDataRestorePreparationTime converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataRestorePreparationTime() BACnetConstructedDataRestorePreparationTimeBuilder
	// AsBACnetConstructedDataRoutingTable converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataRoutingTable() BACnetConstructedDataRoutingTableBuilder
	// AsBACnetConstructedDataScale converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataScale() BACnetConstructedDataScaleBuilder
	// AsBACnetConstructedDataScaleFactor converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataScaleFactor() BACnetConstructedDataScaleFactorBuilder
	// AsBACnetConstructedDataScheduleDefault converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataScheduleDefault() BACnetConstructedDataScheduleDefaultBuilder
	// AsBACnetConstructedDataSecuredStatus converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataSecuredStatus() BACnetConstructedDataSecuredStatusBuilder
	// AsBACnetConstructedDataSecurityPDUTimeout converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataSecurityPDUTimeout() BACnetConstructedDataSecurityPDUTimeoutBuilder
	// AsBACnetConstructedDataSecurityTimeWindow converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataSecurityTimeWindow() BACnetConstructedDataSecurityTimeWindowBuilder
	// AsBACnetConstructedDataSegmentationSupported converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataSegmentationSupported() BACnetConstructedDataSegmentationSupportedBuilder
	// AsBACnetConstructedDataSerialNumber converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataSerialNumber() BACnetConstructedDataSerialNumberBuilder
	// AsBACnetConstructedDataSetpoint converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataSetpoint() BACnetConstructedDataSetpointBuilder
	// AsBACnetConstructedDataSetpointReference converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataSetpointReference() BACnetConstructedDataSetpointReferenceBuilder
	// AsBACnetConstructedDataSetting converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataSetting() BACnetConstructedDataSettingBuilder
	// AsBACnetConstructedDataShedDuration converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataShedDuration() BACnetConstructedDataShedDurationBuilder
	// AsBACnetConstructedDataShedLevelDescriptions converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataShedLevelDescriptions() BACnetConstructedDataShedLevelDescriptionsBuilder
	// AsBACnetConstructedDataShedLevels converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataShedLevels() BACnetConstructedDataShedLevelsBuilder
	// AsBACnetConstructedDataSilenced converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataSilenced() BACnetConstructedDataSilencedBuilder
	// AsBACnetConstructedDataSlaveAddressBinding converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataSlaveAddressBinding() BACnetConstructedDataSlaveAddressBindingBuilder
	// AsBACnetConstructedDataSlaveProxyEnable converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataSlaveProxyEnable() BACnetConstructedDataSlaveProxyEnableBuilder
	// AsBACnetConstructedDataStartTime converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataStartTime() BACnetConstructedDataStartTimeBuilder
	// AsBACnetConstructedDataStateChangeValues converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataStateChangeValues() BACnetConstructedDataStateChangeValuesBuilder
	// AsBACnetConstructedDataStateDescription converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataStateDescription() BACnetConstructedDataStateDescriptionBuilder
	// AsBACnetConstructedDataStateText converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataStateText() BACnetConstructedDataStateTextBuilder
	// AsBACnetConstructedDataStatusFlags converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataStatusFlags() BACnetConstructedDataStatusFlagsBuilder
	// AsBACnetConstructedDataStopTime converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataStopTime() BACnetConstructedDataStopTimeBuilder
	// AsBACnetConstructedDataStopWhenFull converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataStopWhenFull() BACnetConstructedDataStopWhenFullBuilder
	// AsBACnetConstructedDataStrikeCount converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataStrikeCount() BACnetConstructedDataStrikeCountBuilder
	// AsBACnetConstructedDataStructuredObjectList converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataStructuredObjectList() BACnetConstructedDataStructuredObjectListBuilder
	// AsBACnetConstructedDataSubordinateAnnotations converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataSubordinateAnnotations() BACnetConstructedDataSubordinateAnnotationsBuilder
	// AsBACnetConstructedDataSubordinateList converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataSubordinateList() BACnetConstructedDataSubordinateListBuilder
	// AsBACnetConstructedDataSubordinateNodeTypes converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataSubordinateNodeTypes() BACnetConstructedDataSubordinateNodeTypesBuilder
	// AsBACnetConstructedDataSubordinateRelationships converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataSubordinateRelationships() BACnetConstructedDataSubordinateRelationshipsBuilder
	// AsBACnetConstructedDataSubordinateTags converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataSubordinateTags() BACnetConstructedDataSubordinateTagsBuilder
	// AsBACnetConstructedDataSubscribedRecipients converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataSubscribedRecipients() BACnetConstructedDataSubscribedRecipientsBuilder
	// AsBACnetConstructedDataSupportedFormatClasses converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataSupportedFormatClasses() BACnetConstructedDataSupportedFormatClassesBuilder
	// AsBACnetConstructedDataSupportedFormats converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataSupportedFormats() BACnetConstructedDataSupportedFormatsBuilder
	// AsBACnetConstructedDataSupportedSecurityAlgorithms converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataSupportedSecurityAlgorithms() BACnetConstructedDataSupportedSecurityAlgorithmsBuilder
	// AsBACnetConstructedDataSystemStatus converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataSystemStatus() BACnetConstructedDataSystemStatusBuilder
	// AsBACnetConstructedDataTags converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataTags() BACnetConstructedDataTagsBuilder
	// AsBACnetConstructedDataThreatAuthority converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataThreatAuthority() BACnetConstructedDataThreatAuthorityBuilder
	// AsBACnetConstructedDataThreatLevel converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataThreatLevel() BACnetConstructedDataThreatLevelBuilder
	// AsBACnetConstructedDataTimeDelay converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataTimeDelay() BACnetConstructedDataTimeDelayBuilder
	// AsBACnetConstructedDataTimeDelayNormal converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataTimeDelayNormal() BACnetConstructedDataTimeDelayNormalBuilder
	// AsBACnetConstructedDataTimeOfActiveTimeReset converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataTimeOfActiveTimeReset() BACnetConstructedDataTimeOfActiveTimeResetBuilder
	// AsBACnetConstructedDataTimeOfDeviceRestart converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataTimeOfDeviceRestart() BACnetConstructedDataTimeOfDeviceRestartBuilder
	// AsBACnetConstructedDataTimeOfStateCountReset converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataTimeOfStateCountReset() BACnetConstructedDataTimeOfStateCountResetBuilder
	// AsBACnetConstructedDataTimeOfStrikeCountReset converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataTimeOfStrikeCountReset() BACnetConstructedDataTimeOfStrikeCountResetBuilder
	// AsBACnetConstructedDataTimeSynchronizationInterval converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataTimeSynchronizationInterval() BACnetConstructedDataTimeSynchronizationIntervalBuilder
	// AsBACnetConstructedDataTimeSynchronizationRecipients converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataTimeSynchronizationRecipients() BACnetConstructedDataTimeSynchronizationRecipientsBuilder
	// AsBACnetConstructedDataTimerRunning converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataTimerRunning() BACnetConstructedDataTimerRunningBuilder
	// AsBACnetConstructedDataTimerState converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataTimerState() BACnetConstructedDataTimerStateBuilder
	// AsBACnetConstructedDataTotalRecordCount converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataTotalRecordCount() BACnetConstructedDataTotalRecordCountBuilder
	// AsBACnetConstructedDataTraceFlag converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataTraceFlag() BACnetConstructedDataTraceFlagBuilder
	// AsBACnetConstructedDataLightingOutputTrackingValue converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataLightingOutputTrackingValue() BACnetConstructedDataLightingOutputTrackingValueBuilder
	// AsBACnetConstructedDataTrackingValue converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataTrackingValue() BACnetConstructedDataTrackingValueBuilder
	// AsBACnetConstructedDataTransactionNotificationClass converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataTransactionNotificationClass() BACnetConstructedDataTransactionNotificationClassBuilder
	// AsBACnetConstructedDataTransition converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataTransition() BACnetConstructedDataTransitionBuilder
	// AsBACnetConstructedDataTrigger converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataTrigger() BACnetConstructedDataTriggerBuilder
	// AsBACnetConstructedDataUnits converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataUnits() BACnetConstructedDataUnitsBuilder
	// AsBACnetConstructedDataUpdateInterval converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataUpdateInterval() BACnetConstructedDataUpdateIntervalBuilder
	// AsBACnetConstructedDataUpdateKeySetTimeout converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataUpdateKeySetTimeout() BACnetConstructedDataUpdateKeySetTimeoutBuilder
	// AsBACnetConstructedDataCredentialDataInputUpdateTime converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataCredentialDataInputUpdateTime() BACnetConstructedDataCredentialDataInputUpdateTimeBuilder
	// AsBACnetConstructedDataUpdateTime converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataUpdateTime() BACnetConstructedDataUpdateTimeBuilder
	// AsBACnetConstructedDataUserExternalIdentifier converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataUserExternalIdentifier() BACnetConstructedDataUserExternalIdentifierBuilder
	// AsBACnetConstructedDataUserInformationReference converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataUserInformationReference() BACnetConstructedDataUserInformationReferenceBuilder
	// AsBACnetConstructedDataUserName converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataUserName() BACnetConstructedDataUserNameBuilder
	// AsBACnetConstructedDataUserType converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataUserType() BACnetConstructedDataUserTypeBuilder
	// AsBACnetConstructedDataUsesRemaining converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataUsesRemaining() BACnetConstructedDataUsesRemainingBuilder
	// AsBACnetConstructedDataUTCOffset converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataUTCOffset() BACnetConstructedDataUTCOffsetBuilder
	// AsBACnetConstructedDataUTCTimeSynchronizationRecipients converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataUTCTimeSynchronizationRecipients() BACnetConstructedDataUTCTimeSynchronizationRecipientsBuilder
	// AsBACnetConstructedDataValidSamples converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataValidSamples() BACnetConstructedDataValidSamplesBuilder
	// AsBACnetConstructedDataValueBeforeChange converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataValueBeforeChange() BACnetConstructedDataValueBeforeChangeBuilder
	// AsBACnetConstructedDataValueChangeTime converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataValueChangeTime() BACnetConstructedDataValueChangeTimeBuilder
	// AsBACnetConstructedDataValueSet converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataValueSet() BACnetConstructedDataValueSetBuilder
	// AsBACnetConstructedDataValueSource converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataValueSource() BACnetConstructedDataValueSourceBuilder
	// AsBACnetConstructedDataValueSourceArray converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataValueSourceArray() BACnetConstructedDataValueSourceArrayBuilder
	// AsBACnetConstructedDataVarianceValue converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataVarianceValue() BACnetConstructedDataVarianceValueBuilder
	// AsBACnetConstructedDataVendorIdentifier converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataVendorIdentifier() BACnetConstructedDataVendorIdentifierBuilder
	// AsBACnetConstructedDataVendorName converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataVendorName() BACnetConstructedDataVendorNameBuilder
	// AsBACnetConstructedDataVerificationTime converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataVerificationTime() BACnetConstructedDataVerificationTimeBuilder
	// AsBACnetConstructedDataVirtualMACAddressTable converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataVirtualMACAddressTable() BACnetConstructedDataVirtualMACAddressTableBuilder
	// AsBACnetConstructedDataVTClassesSupported converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataVTClassesSupported() BACnetConstructedDataVTClassesSupportedBuilder
	// AsBACnetConstructedDataWeeklySchedule converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataWeeklySchedule() BACnetConstructedDataWeeklyScheduleBuilder
	// AsBACnetConstructedDataWindowInterval converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataWindowInterval() BACnetConstructedDataWindowIntervalBuilder
	// AsBACnetConstructedDataWindowSamples converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataWindowSamples() BACnetConstructedDataWindowSamplesBuilder
	// AsBACnetConstructedDataWriteStatus converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataWriteStatus() BACnetConstructedDataWriteStatusBuilder
	// AsBACnetConstructedDataZoneFrom converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataZoneFrom() BACnetConstructedDataZoneFromBuilder
	// AsBACnetConstructedDataZoneMembers converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataZoneMembers() BACnetConstructedDataZoneMembersBuilder
	// AsBACnetConstructedDataZoneTo converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataZoneTo() BACnetConstructedDataZoneToBuilder
	// AsBACnetConstructedDataUnspecified converts this build to a subType of BACnetConstructedData. It is always possible to return to current builder using Done()
	AsBACnetConstructedDataUnspecified() BACnetConstructedDataUnspecifiedBuilder
	// Build builds the BACnetConstructedData or returns an error if something is wrong
	PartialBuild() (BACnetConstructedDataContract, error)
	// MustBuild does the same as Build but panics on error
	PartialMustBuild() BACnetConstructedDataContract
	// Build builds the BACnetConstructedData or returns an error if something is wrong
	Build() (BACnetConstructedData, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetConstructedData
}

// NewBACnetConstructedDataBuilder() creates a BACnetConstructedDataBuilder
func NewBACnetConstructedDataBuilder() BACnetConstructedDataBuilder {
	return &_BACnetConstructedDataBuilder{_BACnetConstructedData: new(_BACnetConstructedData)}
}

type _BACnetConstructedDataChildBuilder interface {
	utils.Copyable
	setParent(BACnetConstructedDataContract)
	buildForBACnetConstructedData() (BACnetConstructedData, error)
}

type _BACnetConstructedDataBuilder struct {
	*_BACnetConstructedData

	childBuilder _BACnetConstructedDataChildBuilder

	err *utils.MultiError
}

var _ (BACnetConstructedDataBuilder) = (*_BACnetConstructedDataBuilder)(nil)

func (b *_BACnetConstructedDataBuilder) WithMandatoryFields(openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag) BACnetConstructedDataBuilder {
	return b.WithOpeningTag(openingTag).WithPeekedTagHeader(peekedTagHeader).WithClosingTag(closingTag)
}

func (b *_BACnetConstructedDataBuilder) WithOpeningTag(openingTag BACnetOpeningTag) BACnetConstructedDataBuilder {
	b.OpeningTag = openingTag
	return b
}

func (b *_BACnetConstructedDataBuilder) WithOpeningTagBuilder(builderSupplier func(BACnetOpeningTagBuilder) BACnetOpeningTagBuilder) BACnetConstructedDataBuilder {
	builder := builderSupplier(b.OpeningTag.CreateBACnetOpeningTagBuilder())
	var err error
	b.OpeningTag, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "BACnetOpeningTagBuilder failed"))
	}
	return b
}

func (b *_BACnetConstructedDataBuilder) WithPeekedTagHeader(peekedTagHeader BACnetTagHeader) BACnetConstructedDataBuilder {
	b.PeekedTagHeader = peekedTagHeader
	return b
}

func (b *_BACnetConstructedDataBuilder) WithPeekedTagHeaderBuilder(builderSupplier func(BACnetTagHeaderBuilder) BACnetTagHeaderBuilder) BACnetConstructedDataBuilder {
	builder := builderSupplier(b.PeekedTagHeader.CreateBACnetTagHeaderBuilder())
	var err error
	b.PeekedTagHeader, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "BACnetTagHeaderBuilder failed"))
	}
	return b
}

func (b *_BACnetConstructedDataBuilder) WithClosingTag(closingTag BACnetClosingTag) BACnetConstructedDataBuilder {
	b.ClosingTag = closingTag
	return b
}

func (b *_BACnetConstructedDataBuilder) WithClosingTagBuilder(builderSupplier func(BACnetClosingTagBuilder) BACnetClosingTagBuilder) BACnetConstructedDataBuilder {
	builder := builderSupplier(b.ClosingTag.CreateBACnetClosingTagBuilder())
	var err error
	b.ClosingTag, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "BACnetClosingTagBuilder failed"))
	}
	return b
}

func (b *_BACnetConstructedDataBuilder) WithArgTagNumber(tagNumber uint8) BACnetConstructedDataBuilder {
	b.TagNumber = tagNumber
	return b
}
func (b *_BACnetConstructedDataBuilder) WithArgArrayIndexArgument(arrayIndexArgument BACnetTagPayloadUnsignedInteger) BACnetConstructedDataBuilder {
	b.ArrayIndexArgument = arrayIndexArgument
	return b
}

func (b *_BACnetConstructedDataBuilder) PartialBuild() (BACnetConstructedDataContract, error) {
	if b.OpeningTag == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'openingTag' not set"))
	}
	if b.PeekedTagHeader == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'peekedTagHeader' not set"))
	}
	if b.ClosingTag == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'closingTag' not set"))
	}
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._BACnetConstructedData.deepCopy(), nil
}

func (b *_BACnetConstructedDataBuilder) PartialMustBuild() BACnetConstructedDataContract {
	build, err := b.PartialBuild()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataAbsenteeLimit() BACnetConstructedDataAbsenteeLimitBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataAbsenteeLimitBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataAbsenteeLimitBuilder().(*_BACnetConstructedDataAbsenteeLimitBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataAcceptedModes() BACnetConstructedDataAcceptedModesBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataAcceptedModesBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataAcceptedModesBuilder().(*_BACnetConstructedDataAcceptedModesBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataAccessAlarmEvents() BACnetConstructedDataAccessAlarmEventsBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataAccessAlarmEventsBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataAccessAlarmEventsBuilder().(*_BACnetConstructedDataAccessAlarmEventsBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataAccessDoors() BACnetConstructedDataAccessDoorsBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataAccessDoorsBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataAccessDoorsBuilder().(*_BACnetConstructedDataAccessDoorsBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataAccessEvent() BACnetConstructedDataAccessEventBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataAccessEventBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataAccessEventBuilder().(*_BACnetConstructedDataAccessEventBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataAccessEventAuthenticationFactor() BACnetConstructedDataAccessEventAuthenticationFactorBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataAccessEventAuthenticationFactorBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataAccessEventAuthenticationFactorBuilder().(*_BACnetConstructedDataAccessEventAuthenticationFactorBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataAccessEventCredential() BACnetConstructedDataAccessEventCredentialBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataAccessEventCredentialBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataAccessEventCredentialBuilder().(*_BACnetConstructedDataAccessEventCredentialBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataAccessEventTag() BACnetConstructedDataAccessEventTagBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataAccessEventTagBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataAccessEventTagBuilder().(*_BACnetConstructedDataAccessEventTagBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataAccessEventTime() BACnetConstructedDataAccessEventTimeBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataAccessEventTimeBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataAccessEventTimeBuilder().(*_BACnetConstructedDataAccessEventTimeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataAccessTransactionEvents() BACnetConstructedDataAccessTransactionEventsBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataAccessTransactionEventsBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataAccessTransactionEventsBuilder().(*_BACnetConstructedDataAccessTransactionEventsBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataAccompaniment() BACnetConstructedDataAccompanimentBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataAccompanimentBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataAccompanimentBuilder().(*_BACnetConstructedDataAccompanimentBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataAccompanimentTime() BACnetConstructedDataAccompanimentTimeBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataAccompanimentTimeBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataAccompanimentTimeBuilder().(*_BACnetConstructedDataAccompanimentTimeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataAckRequired() BACnetConstructedDataAckRequiredBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataAckRequiredBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataAckRequiredBuilder().(*_BACnetConstructedDataAckRequiredBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataAckedTransitions() BACnetConstructedDataAckedTransitionsBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataAckedTransitionsBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataAckedTransitionsBuilder().(*_BACnetConstructedDataAckedTransitionsBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataLoopAction() BACnetConstructedDataLoopActionBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataLoopActionBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataLoopActionBuilder().(*_BACnetConstructedDataLoopActionBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataCommandAction() BACnetConstructedDataCommandActionBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataCommandActionBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataCommandActionBuilder().(*_BACnetConstructedDataCommandActionBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataAction() BACnetConstructedDataActionBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataActionBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataActionBuilder().(*_BACnetConstructedDataActionBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataActionText() BACnetConstructedDataActionTextBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataActionTextBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataActionTextBuilder().(*_BACnetConstructedDataActionTextBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataActivationTime() BACnetConstructedDataActivationTimeBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataActivationTimeBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataActivationTimeBuilder().(*_BACnetConstructedDataActivationTimeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataActiveAuthenticationPolicy() BACnetConstructedDataActiveAuthenticationPolicyBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataActiveAuthenticationPolicyBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataActiveAuthenticationPolicyBuilder().(*_BACnetConstructedDataActiveAuthenticationPolicyBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataActiveCOVMultipleSubscriptions() BACnetConstructedDataActiveCOVMultipleSubscriptionsBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataActiveCOVMultipleSubscriptionsBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataActiveCOVMultipleSubscriptionsBuilder().(*_BACnetConstructedDataActiveCOVMultipleSubscriptionsBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataActiveCOVSubscriptions() BACnetConstructedDataActiveCOVSubscriptionsBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataActiveCOVSubscriptionsBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataActiveCOVSubscriptionsBuilder().(*_BACnetConstructedDataActiveCOVSubscriptionsBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataActiveText() BACnetConstructedDataActiveTextBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataActiveTextBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataActiveTextBuilder().(*_BACnetConstructedDataActiveTextBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataActiveVTSessions() BACnetConstructedDataActiveVTSessionsBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataActiveVTSessionsBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataActiveVTSessionsBuilder().(*_BACnetConstructedDataActiveVTSessionsBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataActualShedLevel() BACnetConstructedDataActualShedLevelBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataActualShedLevelBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataActualShedLevelBuilder().(*_BACnetConstructedDataActualShedLevelBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataAccessZoneAdjustValue() BACnetConstructedDataAccessZoneAdjustValueBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataAccessZoneAdjustValueBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataAccessZoneAdjustValueBuilder().(*_BACnetConstructedDataAccessZoneAdjustValueBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataPulseConverterAdjustValue() BACnetConstructedDataPulseConverterAdjustValueBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataPulseConverterAdjustValueBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataPulseConverterAdjustValueBuilder().(*_BACnetConstructedDataPulseConverterAdjustValueBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataAdjustValue() BACnetConstructedDataAdjustValueBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataAdjustValueBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataAdjustValueBuilder().(*_BACnetConstructedDataAdjustValueBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataAlarmValue() BACnetConstructedDataAlarmValueBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataAlarmValueBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataAlarmValueBuilder().(*_BACnetConstructedDataAlarmValueBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataAccessDoorAlarmValues() BACnetConstructedDataAccessDoorAlarmValuesBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataAccessDoorAlarmValuesBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataAccessDoorAlarmValuesBuilder().(*_BACnetConstructedDataAccessDoorAlarmValuesBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataAccessZoneAlarmValues() BACnetConstructedDataAccessZoneAlarmValuesBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataAccessZoneAlarmValuesBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataAccessZoneAlarmValuesBuilder().(*_BACnetConstructedDataAccessZoneAlarmValuesBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataBitStringValueAlarmValues() BACnetConstructedDataBitStringValueAlarmValuesBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataBitStringValueAlarmValuesBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataBitStringValueAlarmValuesBuilder().(*_BACnetConstructedDataBitStringValueAlarmValuesBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataCharacterStringValueAlarmValues() BACnetConstructedDataCharacterStringValueAlarmValuesBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataCharacterStringValueAlarmValuesBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataCharacterStringValueAlarmValuesBuilder().(*_BACnetConstructedDataCharacterStringValueAlarmValuesBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataLifeSafetyPointAlarmValues() BACnetConstructedDataLifeSafetyPointAlarmValuesBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataLifeSafetyPointAlarmValuesBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataLifeSafetyPointAlarmValuesBuilder().(*_BACnetConstructedDataLifeSafetyPointAlarmValuesBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataLifeSafetyZoneAlarmValues() BACnetConstructedDataLifeSafetyZoneAlarmValuesBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataLifeSafetyZoneAlarmValuesBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataLifeSafetyZoneAlarmValuesBuilder().(*_BACnetConstructedDataLifeSafetyZoneAlarmValuesBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataMultiStateInputAlarmValues() BACnetConstructedDataMultiStateInputAlarmValuesBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataMultiStateInputAlarmValuesBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataMultiStateInputAlarmValuesBuilder().(*_BACnetConstructedDataMultiStateInputAlarmValuesBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataMultiStateValueAlarmValues() BACnetConstructedDataMultiStateValueAlarmValuesBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataMultiStateValueAlarmValuesBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataMultiStateValueAlarmValuesBuilder().(*_BACnetConstructedDataMultiStateValueAlarmValuesBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataTimerAlarmValues() BACnetConstructedDataTimerAlarmValuesBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataTimerAlarmValuesBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataTimerAlarmValuesBuilder().(*_BACnetConstructedDataTimerAlarmValuesBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataAlarmValues() BACnetConstructedDataAlarmValuesBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataAlarmValuesBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataAlarmValuesBuilder().(*_BACnetConstructedDataAlarmValuesBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataAlignIntervals() BACnetConstructedDataAlignIntervalsBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataAlignIntervalsBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataAlignIntervalsBuilder().(*_BACnetConstructedDataAlignIntervalsBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataAccessCredentialAll() BACnetConstructedDataAccessCredentialAllBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataAccessCredentialAllBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataAccessCredentialAllBuilder().(*_BACnetConstructedDataAccessCredentialAllBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataAccessDoorAll() BACnetConstructedDataAccessDoorAllBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataAccessDoorAllBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataAccessDoorAllBuilder().(*_BACnetConstructedDataAccessDoorAllBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataAccessPointAll() BACnetConstructedDataAccessPointAllBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataAccessPointAllBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataAccessPointAllBuilder().(*_BACnetConstructedDataAccessPointAllBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataAccessRightsAll() BACnetConstructedDataAccessRightsAllBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataAccessRightsAllBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataAccessRightsAllBuilder().(*_BACnetConstructedDataAccessRightsAllBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataAccessUserAll() BACnetConstructedDataAccessUserAllBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataAccessUserAllBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataAccessUserAllBuilder().(*_BACnetConstructedDataAccessUserAllBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataAccessZoneAll() BACnetConstructedDataAccessZoneAllBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataAccessZoneAllBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataAccessZoneAllBuilder().(*_BACnetConstructedDataAccessZoneAllBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataAccumulatorAll() BACnetConstructedDataAccumulatorAllBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataAccumulatorAllBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataAccumulatorAllBuilder().(*_BACnetConstructedDataAccumulatorAllBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataAlertEnrollmentAll() BACnetConstructedDataAlertEnrollmentAllBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataAlertEnrollmentAllBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataAlertEnrollmentAllBuilder().(*_BACnetConstructedDataAlertEnrollmentAllBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataAnalogInputAll() BACnetConstructedDataAnalogInputAllBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataAnalogInputAllBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataAnalogInputAllBuilder().(*_BACnetConstructedDataAnalogInputAllBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataAnalogOutputAll() BACnetConstructedDataAnalogOutputAllBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataAnalogOutputAllBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataAnalogOutputAllBuilder().(*_BACnetConstructedDataAnalogOutputAllBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataAnalogValueAll() BACnetConstructedDataAnalogValueAllBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataAnalogValueAllBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataAnalogValueAllBuilder().(*_BACnetConstructedDataAnalogValueAllBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataAveragingAll() BACnetConstructedDataAveragingAllBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataAveragingAllBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataAveragingAllBuilder().(*_BACnetConstructedDataAveragingAllBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataBinaryInputAll() BACnetConstructedDataBinaryInputAllBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataBinaryInputAllBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataBinaryInputAllBuilder().(*_BACnetConstructedDataBinaryInputAllBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataBinaryLightingOutputAll() BACnetConstructedDataBinaryLightingOutputAllBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataBinaryLightingOutputAllBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataBinaryLightingOutputAllBuilder().(*_BACnetConstructedDataBinaryLightingOutputAllBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataBinaryOutputAll() BACnetConstructedDataBinaryOutputAllBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataBinaryOutputAllBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataBinaryOutputAllBuilder().(*_BACnetConstructedDataBinaryOutputAllBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataBinaryValueAll() BACnetConstructedDataBinaryValueAllBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataBinaryValueAllBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataBinaryValueAllBuilder().(*_BACnetConstructedDataBinaryValueAllBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataBitstringValueAll() BACnetConstructedDataBitstringValueAllBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataBitstringValueAllBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataBitstringValueAllBuilder().(*_BACnetConstructedDataBitstringValueAllBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataCalendarAll() BACnetConstructedDataCalendarAllBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataCalendarAllBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataCalendarAllBuilder().(*_BACnetConstructedDataCalendarAllBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataChannelAll() BACnetConstructedDataChannelAllBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataChannelAllBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataChannelAllBuilder().(*_BACnetConstructedDataChannelAllBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataCharacterstringValueAll() BACnetConstructedDataCharacterstringValueAllBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataCharacterstringValueAllBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataCharacterstringValueAllBuilder().(*_BACnetConstructedDataCharacterstringValueAllBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataCommandAll() BACnetConstructedDataCommandAllBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataCommandAllBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataCommandAllBuilder().(*_BACnetConstructedDataCommandAllBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataCredentialDataInputAll() BACnetConstructedDataCredentialDataInputAllBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataCredentialDataInputAllBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataCredentialDataInputAllBuilder().(*_BACnetConstructedDataCredentialDataInputAllBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataDatepatternValueAll() BACnetConstructedDataDatepatternValueAllBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataDatepatternValueAllBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataDatepatternValueAllBuilder().(*_BACnetConstructedDataDatepatternValueAllBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataDateValueAll() BACnetConstructedDataDateValueAllBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataDateValueAllBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataDateValueAllBuilder().(*_BACnetConstructedDataDateValueAllBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataDatetimepatternValueAll() BACnetConstructedDataDatetimepatternValueAllBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataDatetimepatternValueAllBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataDatetimepatternValueAllBuilder().(*_BACnetConstructedDataDatetimepatternValueAllBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataDatetimeValueAll() BACnetConstructedDataDatetimeValueAllBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataDatetimeValueAllBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataDatetimeValueAllBuilder().(*_BACnetConstructedDataDatetimeValueAllBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataDeviceAll() BACnetConstructedDataDeviceAllBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataDeviceAllBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataDeviceAllBuilder().(*_BACnetConstructedDataDeviceAllBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataElevatorGroupAll() BACnetConstructedDataElevatorGroupAllBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataElevatorGroupAllBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataElevatorGroupAllBuilder().(*_BACnetConstructedDataElevatorGroupAllBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataEscalatorAll() BACnetConstructedDataEscalatorAllBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataEscalatorAllBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataEscalatorAllBuilder().(*_BACnetConstructedDataEscalatorAllBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataEventEnrollmentAll() BACnetConstructedDataEventEnrollmentAllBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataEventEnrollmentAllBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataEventEnrollmentAllBuilder().(*_BACnetConstructedDataEventEnrollmentAllBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataEventLogAll() BACnetConstructedDataEventLogAllBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataEventLogAllBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataEventLogAllBuilder().(*_BACnetConstructedDataEventLogAllBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataFileAll() BACnetConstructedDataFileAllBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataFileAllBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataFileAllBuilder().(*_BACnetConstructedDataFileAllBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataGlobalGroupAll() BACnetConstructedDataGlobalGroupAllBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataGlobalGroupAllBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataGlobalGroupAllBuilder().(*_BACnetConstructedDataGlobalGroupAllBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataGroupAll() BACnetConstructedDataGroupAllBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataGroupAllBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataGroupAllBuilder().(*_BACnetConstructedDataGroupAllBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataIntegerValueAll() BACnetConstructedDataIntegerValueAllBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataIntegerValueAllBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataIntegerValueAllBuilder().(*_BACnetConstructedDataIntegerValueAllBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataLargeAnalogValueAll() BACnetConstructedDataLargeAnalogValueAllBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataLargeAnalogValueAllBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataLargeAnalogValueAllBuilder().(*_BACnetConstructedDataLargeAnalogValueAllBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataLifeSafetyPointAll() BACnetConstructedDataLifeSafetyPointAllBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataLifeSafetyPointAllBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataLifeSafetyPointAllBuilder().(*_BACnetConstructedDataLifeSafetyPointAllBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataLifeSafetyZoneAll() BACnetConstructedDataLifeSafetyZoneAllBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataLifeSafetyZoneAllBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataLifeSafetyZoneAllBuilder().(*_BACnetConstructedDataLifeSafetyZoneAllBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataLiftAll() BACnetConstructedDataLiftAllBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataLiftAllBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataLiftAllBuilder().(*_BACnetConstructedDataLiftAllBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataLightingOutputAll() BACnetConstructedDataLightingOutputAllBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataLightingOutputAllBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataLightingOutputAllBuilder().(*_BACnetConstructedDataLightingOutputAllBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataLoadControlAll() BACnetConstructedDataLoadControlAllBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataLoadControlAllBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataLoadControlAllBuilder().(*_BACnetConstructedDataLoadControlAllBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataLoopAll() BACnetConstructedDataLoopAllBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataLoopAllBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataLoopAllBuilder().(*_BACnetConstructedDataLoopAllBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataMultiStateInputAll() BACnetConstructedDataMultiStateInputAllBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataMultiStateInputAllBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataMultiStateInputAllBuilder().(*_BACnetConstructedDataMultiStateInputAllBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataMultiStateOutputAll() BACnetConstructedDataMultiStateOutputAllBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataMultiStateOutputAllBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataMultiStateOutputAllBuilder().(*_BACnetConstructedDataMultiStateOutputAllBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataMultiStateValueAll() BACnetConstructedDataMultiStateValueAllBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataMultiStateValueAllBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataMultiStateValueAllBuilder().(*_BACnetConstructedDataMultiStateValueAllBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataNetworkPortAll() BACnetConstructedDataNetworkPortAllBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataNetworkPortAllBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataNetworkPortAllBuilder().(*_BACnetConstructedDataNetworkPortAllBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataNetworkSecurityAll() BACnetConstructedDataNetworkSecurityAllBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataNetworkSecurityAllBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataNetworkSecurityAllBuilder().(*_BACnetConstructedDataNetworkSecurityAllBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataNotificationClassAll() BACnetConstructedDataNotificationClassAllBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataNotificationClassAllBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataNotificationClassAllBuilder().(*_BACnetConstructedDataNotificationClassAllBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataNotificationForwarderAll() BACnetConstructedDataNotificationForwarderAllBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataNotificationForwarderAllBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataNotificationForwarderAllBuilder().(*_BACnetConstructedDataNotificationForwarderAllBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataOctetstringValueAll() BACnetConstructedDataOctetstringValueAllBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataOctetstringValueAllBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataOctetstringValueAllBuilder().(*_BACnetConstructedDataOctetstringValueAllBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataPositiveIntegerValueAll() BACnetConstructedDataPositiveIntegerValueAllBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataPositiveIntegerValueAllBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataPositiveIntegerValueAllBuilder().(*_BACnetConstructedDataPositiveIntegerValueAllBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataProgramAll() BACnetConstructedDataProgramAllBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataProgramAllBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataProgramAllBuilder().(*_BACnetConstructedDataProgramAllBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataPulseConverterAll() BACnetConstructedDataPulseConverterAllBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataPulseConverterAllBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataPulseConverterAllBuilder().(*_BACnetConstructedDataPulseConverterAllBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataScheduleAll() BACnetConstructedDataScheduleAllBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataScheduleAllBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataScheduleAllBuilder().(*_BACnetConstructedDataScheduleAllBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataStructuredViewAll() BACnetConstructedDataStructuredViewAllBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataStructuredViewAllBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataStructuredViewAllBuilder().(*_BACnetConstructedDataStructuredViewAllBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataTimepatternValueAll() BACnetConstructedDataTimepatternValueAllBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataTimepatternValueAllBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataTimepatternValueAllBuilder().(*_BACnetConstructedDataTimepatternValueAllBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataTimeValueAll() BACnetConstructedDataTimeValueAllBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataTimeValueAllBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataTimeValueAllBuilder().(*_BACnetConstructedDataTimeValueAllBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataTimerAll() BACnetConstructedDataTimerAllBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataTimerAllBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataTimerAllBuilder().(*_BACnetConstructedDataTimerAllBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataTrendLogAll() BACnetConstructedDataTrendLogAllBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataTrendLogAllBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataTrendLogAllBuilder().(*_BACnetConstructedDataTrendLogAllBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataTrendLogMultipleAll() BACnetConstructedDataTrendLogMultipleAllBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataTrendLogMultipleAllBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataTrendLogMultipleAllBuilder().(*_BACnetConstructedDataTrendLogMultipleAllBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataAllWritesSuccessful() BACnetConstructedDataAllWritesSuccessfulBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataAllWritesSuccessfulBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataAllWritesSuccessfulBuilder().(*_BACnetConstructedDataAllWritesSuccessfulBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataAllowGroupDelayInhibit() BACnetConstructedDataAllowGroupDelayInhibitBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataAllowGroupDelayInhibitBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataAllowGroupDelayInhibitBuilder().(*_BACnetConstructedDataAllowGroupDelayInhibitBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataAPDULength() BACnetConstructedDataAPDULengthBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataAPDULengthBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataAPDULengthBuilder().(*_BACnetConstructedDataAPDULengthBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataAPDUSegmentTimeout() BACnetConstructedDataAPDUSegmentTimeoutBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataAPDUSegmentTimeoutBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataAPDUSegmentTimeoutBuilder().(*_BACnetConstructedDataAPDUSegmentTimeoutBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataAPDUTimeout() BACnetConstructedDataAPDUTimeoutBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataAPDUTimeoutBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataAPDUTimeoutBuilder().(*_BACnetConstructedDataAPDUTimeoutBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataApplicationSoftwareVersion() BACnetConstructedDataApplicationSoftwareVersionBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataApplicationSoftwareVersionBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataApplicationSoftwareVersionBuilder().(*_BACnetConstructedDataApplicationSoftwareVersionBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataArchive() BACnetConstructedDataArchiveBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataArchiveBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataArchiveBuilder().(*_BACnetConstructedDataArchiveBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataAssignedAccessRights() BACnetConstructedDataAssignedAccessRightsBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataAssignedAccessRightsBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataAssignedAccessRightsBuilder().(*_BACnetConstructedDataAssignedAccessRightsBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataAssignedLandingCalls() BACnetConstructedDataAssignedLandingCallsBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataAssignedLandingCallsBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataAssignedLandingCallsBuilder().(*_BACnetConstructedDataAssignedLandingCallsBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataAttemptedSamples() BACnetConstructedDataAttemptedSamplesBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataAttemptedSamplesBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataAttemptedSamplesBuilder().(*_BACnetConstructedDataAttemptedSamplesBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataAuthenticationFactors() BACnetConstructedDataAuthenticationFactorsBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataAuthenticationFactorsBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataAuthenticationFactorsBuilder().(*_BACnetConstructedDataAuthenticationFactorsBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataAuthenticationPolicyList() BACnetConstructedDataAuthenticationPolicyListBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataAuthenticationPolicyListBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataAuthenticationPolicyListBuilder().(*_BACnetConstructedDataAuthenticationPolicyListBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataAuthenticationPolicyNames() BACnetConstructedDataAuthenticationPolicyNamesBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataAuthenticationPolicyNamesBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataAuthenticationPolicyNamesBuilder().(*_BACnetConstructedDataAuthenticationPolicyNamesBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataAuthenticationStatus() BACnetConstructedDataAuthenticationStatusBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataAuthenticationStatusBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataAuthenticationStatusBuilder().(*_BACnetConstructedDataAuthenticationStatusBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataAuthorizationExemptions() BACnetConstructedDataAuthorizationExemptionsBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataAuthorizationExemptionsBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataAuthorizationExemptionsBuilder().(*_BACnetConstructedDataAuthorizationExemptionsBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataAuthorizationMode() BACnetConstructedDataAuthorizationModeBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataAuthorizationModeBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataAuthorizationModeBuilder().(*_BACnetConstructedDataAuthorizationModeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataAutoSlaveDiscovery() BACnetConstructedDataAutoSlaveDiscoveryBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataAutoSlaveDiscoveryBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataAutoSlaveDiscoveryBuilder().(*_BACnetConstructedDataAutoSlaveDiscoveryBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataAverageValue() BACnetConstructedDataAverageValueBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataAverageValueBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataAverageValueBuilder().(*_BACnetConstructedDataAverageValueBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataBackupAndRestoreState() BACnetConstructedDataBackupAndRestoreStateBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataBackupAndRestoreStateBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataBackupAndRestoreStateBuilder().(*_BACnetConstructedDataBackupAndRestoreStateBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataBackupFailureTimeout() BACnetConstructedDataBackupFailureTimeoutBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataBackupFailureTimeoutBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataBackupFailureTimeoutBuilder().(*_BACnetConstructedDataBackupFailureTimeoutBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataBackupPreparationTime() BACnetConstructedDataBackupPreparationTimeBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataBackupPreparationTimeBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataBackupPreparationTimeBuilder().(*_BACnetConstructedDataBackupPreparationTimeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataBACnetIPGlobalAddress() BACnetConstructedDataBACnetIPGlobalAddressBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataBACnetIPGlobalAddressBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataBACnetIPGlobalAddressBuilder().(*_BACnetConstructedDataBACnetIPGlobalAddressBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataBACnetIPMode() BACnetConstructedDataBACnetIPModeBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataBACnetIPModeBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataBACnetIPModeBuilder().(*_BACnetConstructedDataBACnetIPModeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataBACnetIPMulticastAddress() BACnetConstructedDataBACnetIPMulticastAddressBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataBACnetIPMulticastAddressBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataBACnetIPMulticastAddressBuilder().(*_BACnetConstructedDataBACnetIPMulticastAddressBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataBACnetIPNATTraversal() BACnetConstructedDataBACnetIPNATTraversalBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataBACnetIPNATTraversalBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataBACnetIPNATTraversalBuilder().(*_BACnetConstructedDataBACnetIPNATTraversalBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataBACnetIPUDPPort() BACnetConstructedDataBACnetIPUDPPortBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataBACnetIPUDPPortBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataBACnetIPUDPPortBuilder().(*_BACnetConstructedDataBACnetIPUDPPortBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataBACnetIPv6Mode() BACnetConstructedDataBACnetIPv6ModeBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataBACnetIPv6ModeBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataBACnetIPv6ModeBuilder().(*_BACnetConstructedDataBACnetIPv6ModeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataBACnetIPv6UDPPort() BACnetConstructedDataBACnetIPv6UDPPortBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataBACnetIPv6UDPPortBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataBACnetIPv6UDPPortBuilder().(*_BACnetConstructedDataBACnetIPv6UDPPortBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataBACnetIPv6MulticastAddress() BACnetConstructedDataBACnetIPv6MulticastAddressBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataBACnetIPv6MulticastAddressBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataBACnetIPv6MulticastAddressBuilder().(*_BACnetConstructedDataBACnetIPv6MulticastAddressBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataBaseDeviceSecurityPolicy() BACnetConstructedDataBaseDeviceSecurityPolicyBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataBaseDeviceSecurityPolicyBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataBaseDeviceSecurityPolicyBuilder().(*_BACnetConstructedDataBaseDeviceSecurityPolicyBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataBBMDAcceptFDRegistrations() BACnetConstructedDataBBMDAcceptFDRegistrationsBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataBBMDAcceptFDRegistrationsBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataBBMDAcceptFDRegistrationsBuilder().(*_BACnetConstructedDataBBMDAcceptFDRegistrationsBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataBBMDBroadcastDistributionTable() BACnetConstructedDataBBMDBroadcastDistributionTableBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataBBMDBroadcastDistributionTableBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataBBMDBroadcastDistributionTableBuilder().(*_BACnetConstructedDataBBMDBroadcastDistributionTableBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataBBMDForeignDeviceTable() BACnetConstructedDataBBMDForeignDeviceTableBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataBBMDForeignDeviceTableBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataBBMDForeignDeviceTableBuilder().(*_BACnetConstructedDataBBMDForeignDeviceTableBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataBelongsTo() BACnetConstructedDataBelongsToBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataBelongsToBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataBelongsToBuilder().(*_BACnetConstructedDataBelongsToBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataBias() BACnetConstructedDataBiasBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataBiasBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataBiasBuilder().(*_BACnetConstructedDataBiasBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataBitMask() BACnetConstructedDataBitMaskBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataBitMaskBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataBitMaskBuilder().(*_BACnetConstructedDataBitMaskBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataBitText() BACnetConstructedDataBitTextBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataBitTextBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataBitTextBuilder().(*_BACnetConstructedDataBitTextBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataBlinkWarnEnable() BACnetConstructedDataBlinkWarnEnableBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataBlinkWarnEnableBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataBlinkWarnEnableBuilder().(*_BACnetConstructedDataBlinkWarnEnableBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataBufferSize() BACnetConstructedDataBufferSizeBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataBufferSizeBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataBufferSizeBuilder().(*_BACnetConstructedDataBufferSizeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataCarAssignedDirection() BACnetConstructedDataCarAssignedDirectionBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataCarAssignedDirectionBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataCarAssignedDirectionBuilder().(*_BACnetConstructedDataCarAssignedDirectionBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataCarDoorCommand() BACnetConstructedDataCarDoorCommandBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataCarDoorCommandBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataCarDoorCommandBuilder().(*_BACnetConstructedDataCarDoorCommandBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataCarDoorStatus() BACnetConstructedDataCarDoorStatusBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataCarDoorStatusBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataCarDoorStatusBuilder().(*_BACnetConstructedDataCarDoorStatusBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataCarDoorText() BACnetConstructedDataCarDoorTextBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataCarDoorTextBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataCarDoorTextBuilder().(*_BACnetConstructedDataCarDoorTextBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataCarDoorZone() BACnetConstructedDataCarDoorZoneBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataCarDoorZoneBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataCarDoorZoneBuilder().(*_BACnetConstructedDataCarDoorZoneBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataCarDriveStatus() BACnetConstructedDataCarDriveStatusBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataCarDriveStatusBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataCarDriveStatusBuilder().(*_BACnetConstructedDataCarDriveStatusBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataCarLoad() BACnetConstructedDataCarLoadBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataCarLoadBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataCarLoadBuilder().(*_BACnetConstructedDataCarLoadBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataCarLoadUnits() BACnetConstructedDataCarLoadUnitsBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataCarLoadUnitsBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataCarLoadUnitsBuilder().(*_BACnetConstructedDataCarLoadUnitsBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataCarMode() BACnetConstructedDataCarModeBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataCarModeBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataCarModeBuilder().(*_BACnetConstructedDataCarModeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataCarMovingDirection() BACnetConstructedDataCarMovingDirectionBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataCarMovingDirectionBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataCarMovingDirectionBuilder().(*_BACnetConstructedDataCarMovingDirectionBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataCarPosition() BACnetConstructedDataCarPositionBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataCarPositionBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataCarPositionBuilder().(*_BACnetConstructedDataCarPositionBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataChangeOfStateCount() BACnetConstructedDataChangeOfStateCountBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataChangeOfStateCountBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataChangeOfStateCountBuilder().(*_BACnetConstructedDataChangeOfStateCountBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataChangeOfStateTime() BACnetConstructedDataChangeOfStateTimeBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataChangeOfStateTimeBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataChangeOfStateTimeBuilder().(*_BACnetConstructedDataChangeOfStateTimeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataChangesPending() BACnetConstructedDataChangesPendingBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataChangesPendingBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataChangesPendingBuilder().(*_BACnetConstructedDataChangesPendingBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataChannelNumber() BACnetConstructedDataChannelNumberBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataChannelNumberBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataChannelNumberBuilder().(*_BACnetConstructedDataChannelNumberBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataClientCOVIncrement() BACnetConstructedDataClientCOVIncrementBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataClientCOVIncrementBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataClientCOVIncrementBuilder().(*_BACnetConstructedDataClientCOVIncrementBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataCommand() BACnetConstructedDataCommandBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataCommandBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataCommandBuilder().(*_BACnetConstructedDataCommandBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataCommandTimeArray() BACnetConstructedDataCommandTimeArrayBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataCommandTimeArrayBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataCommandTimeArrayBuilder().(*_BACnetConstructedDataCommandTimeArrayBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataConfigurationFiles() BACnetConstructedDataConfigurationFilesBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataConfigurationFilesBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataConfigurationFilesBuilder().(*_BACnetConstructedDataConfigurationFilesBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataControlGroups() BACnetConstructedDataControlGroupsBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataControlGroupsBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataControlGroupsBuilder().(*_BACnetConstructedDataControlGroupsBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataControlledVariableReference() BACnetConstructedDataControlledVariableReferenceBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataControlledVariableReferenceBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataControlledVariableReferenceBuilder().(*_BACnetConstructedDataControlledVariableReferenceBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataControlledVariableUnits() BACnetConstructedDataControlledVariableUnitsBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataControlledVariableUnitsBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataControlledVariableUnitsBuilder().(*_BACnetConstructedDataControlledVariableUnitsBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataControlledVariableValue() BACnetConstructedDataControlledVariableValueBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataControlledVariableValueBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataControlledVariableValueBuilder().(*_BACnetConstructedDataControlledVariableValueBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataCount() BACnetConstructedDataCountBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataCountBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataCountBuilder().(*_BACnetConstructedDataCountBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataCountBeforeChange() BACnetConstructedDataCountBeforeChangeBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataCountBeforeChangeBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataCountBeforeChangeBuilder().(*_BACnetConstructedDataCountBeforeChangeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataCountChangeTime() BACnetConstructedDataCountChangeTimeBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataCountChangeTimeBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataCountChangeTimeBuilder().(*_BACnetConstructedDataCountChangeTimeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataIntegerValueCOVIncrement() BACnetConstructedDataIntegerValueCOVIncrementBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataIntegerValueCOVIncrementBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataIntegerValueCOVIncrementBuilder().(*_BACnetConstructedDataIntegerValueCOVIncrementBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataLargeAnalogValueCOVIncrement() BACnetConstructedDataLargeAnalogValueCOVIncrementBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataLargeAnalogValueCOVIncrementBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataLargeAnalogValueCOVIncrementBuilder().(*_BACnetConstructedDataLargeAnalogValueCOVIncrementBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataPositiveIntegerValueCOVIncrement() BACnetConstructedDataPositiveIntegerValueCOVIncrementBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataPositiveIntegerValueCOVIncrementBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataPositiveIntegerValueCOVIncrementBuilder().(*_BACnetConstructedDataPositiveIntegerValueCOVIncrementBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataCOVIncrement() BACnetConstructedDataCOVIncrementBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataCOVIncrementBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataCOVIncrementBuilder().(*_BACnetConstructedDataCOVIncrementBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataCOVPeriod() BACnetConstructedDataCOVPeriodBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataCOVPeriodBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataCOVPeriodBuilder().(*_BACnetConstructedDataCOVPeriodBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataCOVResubscriptionInterval() BACnetConstructedDataCOVResubscriptionIntervalBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataCOVResubscriptionIntervalBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataCOVResubscriptionIntervalBuilder().(*_BACnetConstructedDataCOVResubscriptionIntervalBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataCOVUPeriod() BACnetConstructedDataCOVUPeriodBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataCOVUPeriodBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataCOVUPeriodBuilder().(*_BACnetConstructedDataCOVUPeriodBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataCOVURecipients() BACnetConstructedDataCOVURecipientsBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataCOVURecipientsBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataCOVURecipientsBuilder().(*_BACnetConstructedDataCOVURecipientsBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataCredentialDisable() BACnetConstructedDataCredentialDisableBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataCredentialDisableBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataCredentialDisableBuilder().(*_BACnetConstructedDataCredentialDisableBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataCredentialStatus() BACnetConstructedDataCredentialStatusBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataCredentialStatusBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataCredentialStatusBuilder().(*_BACnetConstructedDataCredentialStatusBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataCredentials() BACnetConstructedDataCredentialsBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataCredentialsBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataCredentialsBuilder().(*_BACnetConstructedDataCredentialsBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataCredentialsInZone() BACnetConstructedDataCredentialsInZoneBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataCredentialsInZoneBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataCredentialsInZoneBuilder().(*_BACnetConstructedDataCredentialsInZoneBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataCurrentCommandPriority() BACnetConstructedDataCurrentCommandPriorityBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataCurrentCommandPriorityBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataCurrentCommandPriorityBuilder().(*_BACnetConstructedDataCurrentCommandPriorityBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataDatabaseRevision() BACnetConstructedDataDatabaseRevisionBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataDatabaseRevisionBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataDatabaseRevisionBuilder().(*_BACnetConstructedDataDatabaseRevisionBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataDateList() BACnetConstructedDataDateListBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataDateListBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataDateListBuilder().(*_BACnetConstructedDataDateListBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataDaylightSavingsStatus() BACnetConstructedDataDaylightSavingsStatusBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataDaylightSavingsStatusBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataDaylightSavingsStatusBuilder().(*_BACnetConstructedDataDaylightSavingsStatusBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataDaysRemaining() BACnetConstructedDataDaysRemainingBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataDaysRemainingBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataDaysRemainingBuilder().(*_BACnetConstructedDataDaysRemainingBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataIntegerValueDeadband() BACnetConstructedDataIntegerValueDeadbandBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataIntegerValueDeadbandBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataIntegerValueDeadbandBuilder().(*_BACnetConstructedDataIntegerValueDeadbandBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataLargeAnalogValueDeadband() BACnetConstructedDataLargeAnalogValueDeadbandBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataLargeAnalogValueDeadbandBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataLargeAnalogValueDeadbandBuilder().(*_BACnetConstructedDataLargeAnalogValueDeadbandBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataPositiveIntegerValueDeadband() BACnetConstructedDataPositiveIntegerValueDeadbandBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataPositiveIntegerValueDeadbandBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataPositiveIntegerValueDeadbandBuilder().(*_BACnetConstructedDataPositiveIntegerValueDeadbandBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataDeadband() BACnetConstructedDataDeadbandBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataDeadbandBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataDeadbandBuilder().(*_BACnetConstructedDataDeadbandBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataDefaultFadeTime() BACnetConstructedDataDefaultFadeTimeBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataDefaultFadeTimeBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataDefaultFadeTimeBuilder().(*_BACnetConstructedDataDefaultFadeTimeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataDefaultRampRate() BACnetConstructedDataDefaultRampRateBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataDefaultRampRateBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataDefaultRampRateBuilder().(*_BACnetConstructedDataDefaultRampRateBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataDefaultStepIncrement() BACnetConstructedDataDefaultStepIncrementBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataDefaultStepIncrementBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataDefaultStepIncrementBuilder().(*_BACnetConstructedDataDefaultStepIncrementBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataDefaultSubordinateRelationship() BACnetConstructedDataDefaultSubordinateRelationshipBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataDefaultSubordinateRelationshipBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataDefaultSubordinateRelationshipBuilder().(*_BACnetConstructedDataDefaultSubordinateRelationshipBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataDefaultTimeout() BACnetConstructedDataDefaultTimeoutBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataDefaultTimeoutBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataDefaultTimeoutBuilder().(*_BACnetConstructedDataDefaultTimeoutBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataDeployedProfileLocation() BACnetConstructedDataDeployedProfileLocationBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataDeployedProfileLocationBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataDeployedProfileLocationBuilder().(*_BACnetConstructedDataDeployedProfileLocationBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataDerivativeConstant() BACnetConstructedDataDerivativeConstantBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataDerivativeConstantBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataDerivativeConstantBuilder().(*_BACnetConstructedDataDerivativeConstantBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataDerivativeConstantUnits() BACnetConstructedDataDerivativeConstantUnitsBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataDerivativeConstantUnitsBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataDerivativeConstantUnitsBuilder().(*_BACnetConstructedDataDerivativeConstantUnitsBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataDescription() BACnetConstructedDataDescriptionBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataDescriptionBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataDescriptionBuilder().(*_BACnetConstructedDataDescriptionBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataDescriptionOfHalt() BACnetConstructedDataDescriptionOfHaltBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataDescriptionOfHaltBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataDescriptionOfHaltBuilder().(*_BACnetConstructedDataDescriptionOfHaltBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataDeviceAddressBinding() BACnetConstructedDataDeviceAddressBindingBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataDeviceAddressBindingBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataDeviceAddressBindingBuilder().(*_BACnetConstructedDataDeviceAddressBindingBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataDeviceType() BACnetConstructedDataDeviceTypeBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataDeviceTypeBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataDeviceTypeBuilder().(*_BACnetConstructedDataDeviceTypeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataDirectReading() BACnetConstructedDataDirectReadingBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataDirectReadingBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataDirectReadingBuilder().(*_BACnetConstructedDataDirectReadingBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataDistributionKeyRevision() BACnetConstructedDataDistributionKeyRevisionBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataDistributionKeyRevisionBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataDistributionKeyRevisionBuilder().(*_BACnetConstructedDataDistributionKeyRevisionBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataDoNotHide() BACnetConstructedDataDoNotHideBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataDoNotHideBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataDoNotHideBuilder().(*_BACnetConstructedDataDoNotHideBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataDoorAlarmState() BACnetConstructedDataDoorAlarmStateBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataDoorAlarmStateBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataDoorAlarmStateBuilder().(*_BACnetConstructedDataDoorAlarmStateBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataDoorExtendedPulseTime() BACnetConstructedDataDoorExtendedPulseTimeBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataDoorExtendedPulseTimeBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataDoorExtendedPulseTimeBuilder().(*_BACnetConstructedDataDoorExtendedPulseTimeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataDoorMembers() BACnetConstructedDataDoorMembersBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataDoorMembersBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataDoorMembersBuilder().(*_BACnetConstructedDataDoorMembersBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataDoorOpenTooLongTime() BACnetConstructedDataDoorOpenTooLongTimeBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataDoorOpenTooLongTimeBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataDoorOpenTooLongTimeBuilder().(*_BACnetConstructedDataDoorOpenTooLongTimeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataDoorPulseTime() BACnetConstructedDataDoorPulseTimeBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataDoorPulseTimeBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataDoorPulseTimeBuilder().(*_BACnetConstructedDataDoorPulseTimeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataDoorStatus() BACnetConstructedDataDoorStatusBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataDoorStatusBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataDoorStatusBuilder().(*_BACnetConstructedDataDoorStatusBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataDoorUnlockDelayTime() BACnetConstructedDataDoorUnlockDelayTimeBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataDoorUnlockDelayTimeBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataDoorUnlockDelayTimeBuilder().(*_BACnetConstructedDataDoorUnlockDelayTimeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataDutyWindow() BACnetConstructedDataDutyWindowBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataDutyWindowBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataDutyWindowBuilder().(*_BACnetConstructedDataDutyWindowBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataEffectivePeriod() BACnetConstructedDataEffectivePeriodBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataEffectivePeriodBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataEffectivePeriodBuilder().(*_BACnetConstructedDataEffectivePeriodBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataEgressActive() BACnetConstructedDataEgressActiveBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataEgressActiveBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataEgressActiveBuilder().(*_BACnetConstructedDataEgressActiveBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataEgressTime() BACnetConstructedDataEgressTimeBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataEgressTimeBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataEgressTimeBuilder().(*_BACnetConstructedDataEgressTimeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataElapsedActiveTime() BACnetConstructedDataElapsedActiveTimeBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataElapsedActiveTimeBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataElapsedActiveTimeBuilder().(*_BACnetConstructedDataElapsedActiveTimeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataElevatorGroup() BACnetConstructedDataElevatorGroupBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataElevatorGroupBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataElevatorGroupBuilder().(*_BACnetConstructedDataElevatorGroupBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataEnable() BACnetConstructedDataEnableBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataEnableBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataEnableBuilder().(*_BACnetConstructedDataEnableBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataEnergyMeter() BACnetConstructedDataEnergyMeterBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataEnergyMeterBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataEnergyMeterBuilder().(*_BACnetConstructedDataEnergyMeterBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataEnergyMeterRef() BACnetConstructedDataEnergyMeterRefBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataEnergyMeterRefBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataEnergyMeterRefBuilder().(*_BACnetConstructedDataEnergyMeterRefBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataEntryPoints() BACnetConstructedDataEntryPointsBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataEntryPointsBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataEntryPointsBuilder().(*_BACnetConstructedDataEntryPointsBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataErrorLimit() BACnetConstructedDataErrorLimitBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataErrorLimitBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataErrorLimitBuilder().(*_BACnetConstructedDataErrorLimitBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataEscalatorMode() BACnetConstructedDataEscalatorModeBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataEscalatorModeBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataEscalatorModeBuilder().(*_BACnetConstructedDataEscalatorModeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataEventAlgorithmInhibit() BACnetConstructedDataEventAlgorithmInhibitBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataEventAlgorithmInhibitBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataEventAlgorithmInhibitBuilder().(*_BACnetConstructedDataEventAlgorithmInhibitBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataEventAlgorithmInhibitRef() BACnetConstructedDataEventAlgorithmInhibitRefBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataEventAlgorithmInhibitRefBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataEventAlgorithmInhibitRefBuilder().(*_BACnetConstructedDataEventAlgorithmInhibitRefBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataEventDetectionEnable() BACnetConstructedDataEventDetectionEnableBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataEventDetectionEnableBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataEventDetectionEnableBuilder().(*_BACnetConstructedDataEventDetectionEnableBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataEventEnable() BACnetConstructedDataEventEnableBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataEventEnableBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataEventEnableBuilder().(*_BACnetConstructedDataEventEnableBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataEventMessageTexts() BACnetConstructedDataEventMessageTextsBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataEventMessageTextsBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataEventMessageTextsBuilder().(*_BACnetConstructedDataEventMessageTextsBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataEventMessageTextsConfig() BACnetConstructedDataEventMessageTextsConfigBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataEventMessageTextsConfigBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataEventMessageTextsConfigBuilder().(*_BACnetConstructedDataEventMessageTextsConfigBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataEventParameters() BACnetConstructedDataEventParametersBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataEventParametersBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataEventParametersBuilder().(*_BACnetConstructedDataEventParametersBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataEventState() BACnetConstructedDataEventStateBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataEventStateBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataEventStateBuilder().(*_BACnetConstructedDataEventStateBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataEventTimeStamps() BACnetConstructedDataEventTimeStampsBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataEventTimeStampsBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataEventTimeStampsBuilder().(*_BACnetConstructedDataEventTimeStampsBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataEventType() BACnetConstructedDataEventTypeBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataEventTypeBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataEventTypeBuilder().(*_BACnetConstructedDataEventTypeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataExceptionSchedule() BACnetConstructedDataExceptionScheduleBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataExceptionScheduleBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataExceptionScheduleBuilder().(*_BACnetConstructedDataExceptionScheduleBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataExecutionDelay() BACnetConstructedDataExecutionDelayBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataExecutionDelayBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataExecutionDelayBuilder().(*_BACnetConstructedDataExecutionDelayBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataExitPoints() BACnetConstructedDataExitPointsBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataExitPointsBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataExitPointsBuilder().(*_BACnetConstructedDataExitPointsBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataExpectedShedLevel() BACnetConstructedDataExpectedShedLevelBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataExpectedShedLevelBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataExpectedShedLevelBuilder().(*_BACnetConstructedDataExpectedShedLevelBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataExpirationTime() BACnetConstructedDataExpirationTimeBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataExpirationTimeBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataExpirationTimeBuilder().(*_BACnetConstructedDataExpirationTimeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataExtendedTimeEnable() BACnetConstructedDataExtendedTimeEnableBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataExtendedTimeEnableBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataExtendedTimeEnableBuilder().(*_BACnetConstructedDataExtendedTimeEnableBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataFailedAttemptEvents() BACnetConstructedDataFailedAttemptEventsBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataFailedAttemptEventsBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataFailedAttemptEventsBuilder().(*_BACnetConstructedDataFailedAttemptEventsBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataFailedAttempts() BACnetConstructedDataFailedAttemptsBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataFailedAttemptsBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataFailedAttemptsBuilder().(*_BACnetConstructedDataFailedAttemptsBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataFailedAttemptsTime() BACnetConstructedDataFailedAttemptsTimeBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataFailedAttemptsTimeBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataFailedAttemptsTimeBuilder().(*_BACnetConstructedDataFailedAttemptsTimeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataAccumulatorFaultHighLimit() BACnetConstructedDataAccumulatorFaultHighLimitBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataAccumulatorFaultHighLimitBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataAccumulatorFaultHighLimitBuilder().(*_BACnetConstructedDataAccumulatorFaultHighLimitBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataAnalogInputFaultHighLimit() BACnetConstructedDataAnalogInputFaultHighLimitBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataAnalogInputFaultHighLimitBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataAnalogInputFaultHighLimitBuilder().(*_BACnetConstructedDataAnalogInputFaultHighLimitBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataAnalogValueFaultHighLimit() BACnetConstructedDataAnalogValueFaultHighLimitBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataAnalogValueFaultHighLimitBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataAnalogValueFaultHighLimitBuilder().(*_BACnetConstructedDataAnalogValueFaultHighLimitBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataIntegerValueFaultHighLimit() BACnetConstructedDataIntegerValueFaultHighLimitBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataIntegerValueFaultHighLimitBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataIntegerValueFaultHighLimitBuilder().(*_BACnetConstructedDataIntegerValueFaultHighLimitBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataLargeAnalogValueFaultHighLimit() BACnetConstructedDataLargeAnalogValueFaultHighLimitBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataLargeAnalogValueFaultHighLimitBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataLargeAnalogValueFaultHighLimitBuilder().(*_BACnetConstructedDataLargeAnalogValueFaultHighLimitBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataPositiveIntegerValueFaultHighLimit() BACnetConstructedDataPositiveIntegerValueFaultHighLimitBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataPositiveIntegerValueFaultHighLimitBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataPositiveIntegerValueFaultHighLimitBuilder().(*_BACnetConstructedDataPositiveIntegerValueFaultHighLimitBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataFaultHighLimit() BACnetConstructedDataFaultHighLimitBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataFaultHighLimitBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataFaultHighLimitBuilder().(*_BACnetConstructedDataFaultHighLimitBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataAccumulatorFaultLowLimit() BACnetConstructedDataAccumulatorFaultLowLimitBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataAccumulatorFaultLowLimitBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataAccumulatorFaultLowLimitBuilder().(*_BACnetConstructedDataAccumulatorFaultLowLimitBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataAnalogInputFaultLowLimit() BACnetConstructedDataAnalogInputFaultLowLimitBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataAnalogInputFaultLowLimitBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataAnalogInputFaultLowLimitBuilder().(*_BACnetConstructedDataAnalogInputFaultLowLimitBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataAnalogValueFaultLowLimit() BACnetConstructedDataAnalogValueFaultLowLimitBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataAnalogValueFaultLowLimitBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataAnalogValueFaultLowLimitBuilder().(*_BACnetConstructedDataAnalogValueFaultLowLimitBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataLargeAnalogValueFaultLowLimit() BACnetConstructedDataLargeAnalogValueFaultLowLimitBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataLargeAnalogValueFaultLowLimitBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataLargeAnalogValueFaultLowLimitBuilder().(*_BACnetConstructedDataLargeAnalogValueFaultLowLimitBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataIntegerValueFaultLowLimit() BACnetConstructedDataIntegerValueFaultLowLimitBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataIntegerValueFaultLowLimitBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataIntegerValueFaultLowLimitBuilder().(*_BACnetConstructedDataIntegerValueFaultLowLimitBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataPositiveIntegerValueFaultLowLimit() BACnetConstructedDataPositiveIntegerValueFaultLowLimitBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataPositiveIntegerValueFaultLowLimitBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataPositiveIntegerValueFaultLowLimitBuilder().(*_BACnetConstructedDataPositiveIntegerValueFaultLowLimitBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataFaultLowLimit() BACnetConstructedDataFaultLowLimitBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataFaultLowLimitBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataFaultLowLimitBuilder().(*_BACnetConstructedDataFaultLowLimitBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataFaultParameters() BACnetConstructedDataFaultParametersBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataFaultParametersBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataFaultParametersBuilder().(*_BACnetConstructedDataFaultParametersBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataEscalatorFaultSignals() BACnetConstructedDataEscalatorFaultSignalsBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataEscalatorFaultSignalsBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataEscalatorFaultSignalsBuilder().(*_BACnetConstructedDataEscalatorFaultSignalsBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataLiftFaultSignals() BACnetConstructedDataLiftFaultSignalsBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataLiftFaultSignalsBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataLiftFaultSignalsBuilder().(*_BACnetConstructedDataLiftFaultSignalsBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataFaultSignals() BACnetConstructedDataFaultSignalsBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataFaultSignalsBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataFaultSignalsBuilder().(*_BACnetConstructedDataFaultSignalsBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataFaultType() BACnetConstructedDataFaultTypeBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataFaultTypeBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataFaultTypeBuilder().(*_BACnetConstructedDataFaultTypeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataAccessDoorFaultValues() BACnetConstructedDataAccessDoorFaultValuesBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataAccessDoorFaultValuesBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataAccessDoorFaultValuesBuilder().(*_BACnetConstructedDataAccessDoorFaultValuesBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataCharacterStringValueFaultValues() BACnetConstructedDataCharacterStringValueFaultValuesBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataCharacterStringValueFaultValuesBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataCharacterStringValueFaultValuesBuilder().(*_BACnetConstructedDataCharacterStringValueFaultValuesBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataLifeSafetyPointFaultValues() BACnetConstructedDataLifeSafetyPointFaultValuesBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataLifeSafetyPointFaultValuesBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataLifeSafetyPointFaultValuesBuilder().(*_BACnetConstructedDataLifeSafetyPointFaultValuesBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataLifeSafetyZoneFaultValues() BACnetConstructedDataLifeSafetyZoneFaultValuesBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataLifeSafetyZoneFaultValuesBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataLifeSafetyZoneFaultValuesBuilder().(*_BACnetConstructedDataLifeSafetyZoneFaultValuesBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataMultiStateInputFaultValues() BACnetConstructedDataMultiStateInputFaultValuesBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataMultiStateInputFaultValuesBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataMultiStateInputFaultValuesBuilder().(*_BACnetConstructedDataMultiStateInputFaultValuesBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataMultiStateValueFaultValues() BACnetConstructedDataMultiStateValueFaultValuesBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataMultiStateValueFaultValuesBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataMultiStateValueFaultValuesBuilder().(*_BACnetConstructedDataMultiStateValueFaultValuesBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataFaultValues() BACnetConstructedDataFaultValuesBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataFaultValuesBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataFaultValuesBuilder().(*_BACnetConstructedDataFaultValuesBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataFDBBMDAddress() BACnetConstructedDataFDBBMDAddressBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataFDBBMDAddressBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataFDBBMDAddressBuilder().(*_BACnetConstructedDataFDBBMDAddressBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataFDSubscriptionLifetime() BACnetConstructedDataFDSubscriptionLifetimeBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataFDSubscriptionLifetimeBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataFDSubscriptionLifetimeBuilder().(*_BACnetConstructedDataFDSubscriptionLifetimeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataBinaryLightingOutputFeedbackValue() BACnetConstructedDataBinaryLightingOutputFeedbackValueBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataBinaryLightingOutputFeedbackValueBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataBinaryLightingOutputFeedbackValueBuilder().(*_BACnetConstructedDataBinaryLightingOutputFeedbackValueBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataBinaryOutputFeedbackValue() BACnetConstructedDataBinaryOutputFeedbackValueBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataBinaryOutputFeedbackValueBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataBinaryOutputFeedbackValueBuilder().(*_BACnetConstructedDataBinaryOutputFeedbackValueBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataLightingOutputFeedbackValue() BACnetConstructedDataLightingOutputFeedbackValueBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataLightingOutputFeedbackValueBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataLightingOutputFeedbackValueBuilder().(*_BACnetConstructedDataLightingOutputFeedbackValueBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataMultiStateOutputFeedbackValue() BACnetConstructedDataMultiStateOutputFeedbackValueBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataMultiStateOutputFeedbackValueBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataMultiStateOutputFeedbackValueBuilder().(*_BACnetConstructedDataMultiStateOutputFeedbackValueBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataFileAccessMethod() BACnetConstructedDataFileAccessMethodBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataFileAccessMethodBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataFileAccessMethodBuilder().(*_BACnetConstructedDataFileAccessMethodBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataFileSize() BACnetConstructedDataFileSizeBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataFileSizeBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataFileSizeBuilder().(*_BACnetConstructedDataFileSizeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataFileType() BACnetConstructedDataFileTypeBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataFileTypeBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataFileTypeBuilder().(*_BACnetConstructedDataFileTypeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataFirmwareRevision() BACnetConstructedDataFirmwareRevisionBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataFirmwareRevisionBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataFirmwareRevisionBuilder().(*_BACnetConstructedDataFirmwareRevisionBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataFloorText() BACnetConstructedDataFloorTextBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataFloorTextBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataFloorTextBuilder().(*_BACnetConstructedDataFloorTextBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataFullDutyBaseline() BACnetConstructedDataFullDutyBaselineBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataFullDutyBaselineBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataFullDutyBaselineBuilder().(*_BACnetConstructedDataFullDutyBaselineBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataGlobalIdentifier() BACnetConstructedDataGlobalIdentifierBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataGlobalIdentifierBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataGlobalIdentifierBuilder().(*_BACnetConstructedDataGlobalIdentifierBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataGroupID() BACnetConstructedDataGroupIDBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataGroupIDBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataGroupIDBuilder().(*_BACnetConstructedDataGroupIDBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataGroupMemberNames() BACnetConstructedDataGroupMemberNamesBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataGroupMemberNamesBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataGroupMemberNamesBuilder().(*_BACnetConstructedDataGroupMemberNamesBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataGlobalGroupGroupMembers() BACnetConstructedDataGlobalGroupGroupMembersBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataGlobalGroupGroupMembersBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataGlobalGroupGroupMembersBuilder().(*_BACnetConstructedDataGlobalGroupGroupMembersBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataElevatorGroupGroupMembers() BACnetConstructedDataElevatorGroupGroupMembersBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataElevatorGroupGroupMembersBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataElevatorGroupGroupMembersBuilder().(*_BACnetConstructedDataElevatorGroupGroupMembersBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataGroupMembers() BACnetConstructedDataGroupMembersBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataGroupMembersBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataGroupMembersBuilder().(*_BACnetConstructedDataGroupMembersBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataGroupMode() BACnetConstructedDataGroupModeBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataGroupModeBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataGroupModeBuilder().(*_BACnetConstructedDataGroupModeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataAccumulatorHighLimit() BACnetConstructedDataAccumulatorHighLimitBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataAccumulatorHighLimitBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataAccumulatorHighLimitBuilder().(*_BACnetConstructedDataAccumulatorHighLimitBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataLargeAnalogValueHighLimit() BACnetConstructedDataLargeAnalogValueHighLimitBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataLargeAnalogValueHighLimitBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataLargeAnalogValueHighLimitBuilder().(*_BACnetConstructedDataLargeAnalogValueHighLimitBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataIntegerValueHighLimit() BACnetConstructedDataIntegerValueHighLimitBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataIntegerValueHighLimitBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataIntegerValueHighLimitBuilder().(*_BACnetConstructedDataIntegerValueHighLimitBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataPositiveIntegerValueHighLimit() BACnetConstructedDataPositiveIntegerValueHighLimitBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataPositiveIntegerValueHighLimitBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataPositiveIntegerValueHighLimitBuilder().(*_BACnetConstructedDataPositiveIntegerValueHighLimitBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataHighLimit() BACnetConstructedDataHighLimitBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataHighLimitBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataHighLimitBuilder().(*_BACnetConstructedDataHighLimitBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataHigherDeck() BACnetConstructedDataHigherDeckBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataHigherDeckBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataHigherDeckBuilder().(*_BACnetConstructedDataHigherDeckBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataInProcess() BACnetConstructedDataInProcessBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataInProcessBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataInProcessBuilder().(*_BACnetConstructedDataInProcessBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataInProgress() BACnetConstructedDataInProgressBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataInProgressBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataInProgressBuilder().(*_BACnetConstructedDataInProgressBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataInactiveText() BACnetConstructedDataInactiveTextBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataInactiveTextBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataInactiveTextBuilder().(*_BACnetConstructedDataInactiveTextBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataInitialTimeout() BACnetConstructedDataInitialTimeoutBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataInitialTimeoutBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataInitialTimeoutBuilder().(*_BACnetConstructedDataInitialTimeoutBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataInputReference() BACnetConstructedDataInputReferenceBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataInputReferenceBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataInputReferenceBuilder().(*_BACnetConstructedDataInputReferenceBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataInstallationID() BACnetConstructedDataInstallationIDBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataInstallationIDBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataInstallationIDBuilder().(*_BACnetConstructedDataInstallationIDBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataInstanceOf() BACnetConstructedDataInstanceOfBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataInstanceOfBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataInstanceOfBuilder().(*_BACnetConstructedDataInstanceOfBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataInstantaneousPower() BACnetConstructedDataInstantaneousPowerBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataInstantaneousPowerBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataInstantaneousPowerBuilder().(*_BACnetConstructedDataInstantaneousPowerBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataIntegralConstant() BACnetConstructedDataIntegralConstantBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataIntegralConstantBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataIntegralConstantBuilder().(*_BACnetConstructedDataIntegralConstantBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataIntegralConstantUnits() BACnetConstructedDataIntegralConstantUnitsBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataIntegralConstantUnitsBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataIntegralConstantUnitsBuilder().(*_BACnetConstructedDataIntegralConstantUnitsBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataAnalogInputInterfaceValue() BACnetConstructedDataAnalogInputInterfaceValueBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataAnalogInputInterfaceValueBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataAnalogInputInterfaceValueBuilder().(*_BACnetConstructedDataAnalogInputInterfaceValueBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataAnalogOutputInterfaceValue() BACnetConstructedDataAnalogOutputInterfaceValueBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataAnalogOutputInterfaceValueBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataAnalogOutputInterfaceValueBuilder().(*_BACnetConstructedDataAnalogOutputInterfaceValueBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataBinaryInputInterfaceValue() BACnetConstructedDataBinaryInputInterfaceValueBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataBinaryInputInterfaceValueBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataBinaryInputInterfaceValueBuilder().(*_BACnetConstructedDataBinaryInputInterfaceValueBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataBinaryOutputInterfaceValue() BACnetConstructedDataBinaryOutputInterfaceValueBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataBinaryOutputInterfaceValueBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataBinaryOutputInterfaceValueBuilder().(*_BACnetConstructedDataBinaryOutputInterfaceValueBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataMultiStateInputInterfaceValue() BACnetConstructedDataMultiStateInputInterfaceValueBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataMultiStateInputInterfaceValueBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataMultiStateInputInterfaceValueBuilder().(*_BACnetConstructedDataMultiStateInputInterfaceValueBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataMultiStateOutputInterfaceValue() BACnetConstructedDataMultiStateOutputInterfaceValueBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataMultiStateOutputInterfaceValueBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataMultiStateOutputInterfaceValueBuilder().(*_BACnetConstructedDataMultiStateOutputInterfaceValueBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataIntervalOffset() BACnetConstructedDataIntervalOffsetBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataIntervalOffsetBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataIntervalOffsetBuilder().(*_BACnetConstructedDataIntervalOffsetBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataIPAddress() BACnetConstructedDataIPAddressBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataIPAddressBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataIPAddressBuilder().(*_BACnetConstructedDataIPAddressBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataIPDefaultGateway() BACnetConstructedDataIPDefaultGatewayBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataIPDefaultGatewayBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataIPDefaultGatewayBuilder().(*_BACnetConstructedDataIPDefaultGatewayBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataIPDHCPEnable() BACnetConstructedDataIPDHCPEnableBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataIPDHCPEnableBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataIPDHCPEnableBuilder().(*_BACnetConstructedDataIPDHCPEnableBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataIPDHCPLeaseTime() BACnetConstructedDataIPDHCPLeaseTimeBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataIPDHCPLeaseTimeBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataIPDHCPLeaseTimeBuilder().(*_BACnetConstructedDataIPDHCPLeaseTimeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataIPDHCPLeaseTimeRemaining() BACnetConstructedDataIPDHCPLeaseTimeRemainingBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataIPDHCPLeaseTimeRemainingBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataIPDHCPLeaseTimeRemainingBuilder().(*_BACnetConstructedDataIPDHCPLeaseTimeRemainingBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataIPDHCPServer() BACnetConstructedDataIPDHCPServerBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataIPDHCPServerBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataIPDHCPServerBuilder().(*_BACnetConstructedDataIPDHCPServerBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataIPDNSServer() BACnetConstructedDataIPDNSServerBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataIPDNSServerBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataIPDNSServerBuilder().(*_BACnetConstructedDataIPDNSServerBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataIPSubnetMask() BACnetConstructedDataIPSubnetMaskBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataIPSubnetMaskBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataIPSubnetMaskBuilder().(*_BACnetConstructedDataIPSubnetMaskBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataIPv6Address() BACnetConstructedDataIPv6AddressBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataIPv6AddressBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataIPv6AddressBuilder().(*_BACnetConstructedDataIPv6AddressBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataIPv6AutoAddressingEnable() BACnetConstructedDataIPv6AutoAddressingEnableBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataIPv6AutoAddressingEnableBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataIPv6AutoAddressingEnableBuilder().(*_BACnetConstructedDataIPv6AutoAddressingEnableBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataIPv6DefaultGateway() BACnetConstructedDataIPv6DefaultGatewayBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataIPv6DefaultGatewayBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataIPv6DefaultGatewayBuilder().(*_BACnetConstructedDataIPv6DefaultGatewayBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataIPv6DHCPLeaseTime() BACnetConstructedDataIPv6DHCPLeaseTimeBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataIPv6DHCPLeaseTimeBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataIPv6DHCPLeaseTimeBuilder().(*_BACnetConstructedDataIPv6DHCPLeaseTimeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataIPv6DHCPLeaseTimeRemaining() BACnetConstructedDataIPv6DHCPLeaseTimeRemainingBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataIPv6DHCPLeaseTimeRemainingBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataIPv6DHCPLeaseTimeRemainingBuilder().(*_BACnetConstructedDataIPv6DHCPLeaseTimeRemainingBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataIPv6DHCPServer() BACnetConstructedDataIPv6DHCPServerBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataIPv6DHCPServerBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataIPv6DHCPServerBuilder().(*_BACnetConstructedDataIPv6DHCPServerBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataIPv6DNSServer() BACnetConstructedDataIPv6DNSServerBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataIPv6DNSServerBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataIPv6DNSServerBuilder().(*_BACnetConstructedDataIPv6DNSServerBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataIPv6PrefixLength() BACnetConstructedDataIPv6PrefixLengthBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataIPv6PrefixLengthBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataIPv6PrefixLengthBuilder().(*_BACnetConstructedDataIPv6PrefixLengthBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataIPv6ZoneIndex() BACnetConstructedDataIPv6ZoneIndexBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataIPv6ZoneIndexBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataIPv6ZoneIndexBuilder().(*_BACnetConstructedDataIPv6ZoneIndexBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataIsUTC() BACnetConstructedDataIsUTCBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataIsUTCBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataIsUTCBuilder().(*_BACnetConstructedDataIsUTCBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataKeySets() BACnetConstructedDataKeySetsBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataKeySetsBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataKeySetsBuilder().(*_BACnetConstructedDataKeySetsBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataLandingCallControl() BACnetConstructedDataLandingCallControlBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataLandingCallControlBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataLandingCallControlBuilder().(*_BACnetConstructedDataLandingCallControlBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataLandingCalls() BACnetConstructedDataLandingCallsBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataLandingCallsBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataLandingCallsBuilder().(*_BACnetConstructedDataLandingCallsBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataLandingDoorStatus() BACnetConstructedDataLandingDoorStatusBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataLandingDoorStatusBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataLandingDoorStatusBuilder().(*_BACnetConstructedDataLandingDoorStatusBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataLastAccessEvent() BACnetConstructedDataLastAccessEventBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataLastAccessEventBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataLastAccessEventBuilder().(*_BACnetConstructedDataLastAccessEventBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataLastAccessPoint() BACnetConstructedDataLastAccessPointBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataLastAccessPointBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataLastAccessPointBuilder().(*_BACnetConstructedDataLastAccessPointBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataLastCommandTime() BACnetConstructedDataLastCommandTimeBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataLastCommandTimeBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataLastCommandTimeBuilder().(*_BACnetConstructedDataLastCommandTimeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataLastCredentialAdded() BACnetConstructedDataLastCredentialAddedBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataLastCredentialAddedBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataLastCredentialAddedBuilder().(*_BACnetConstructedDataLastCredentialAddedBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataLastCredentialAddedTime() BACnetConstructedDataLastCredentialAddedTimeBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataLastCredentialAddedTimeBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataLastCredentialAddedTimeBuilder().(*_BACnetConstructedDataLastCredentialAddedTimeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataLastCredentialRemoved() BACnetConstructedDataLastCredentialRemovedBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataLastCredentialRemovedBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataLastCredentialRemovedBuilder().(*_BACnetConstructedDataLastCredentialRemovedBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataLastCredentialRemovedTime() BACnetConstructedDataLastCredentialRemovedTimeBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataLastCredentialRemovedTimeBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataLastCredentialRemovedTimeBuilder().(*_BACnetConstructedDataLastCredentialRemovedTimeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataLastKeyServer() BACnetConstructedDataLastKeyServerBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataLastKeyServerBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataLastKeyServerBuilder().(*_BACnetConstructedDataLastKeyServerBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataLastNotifyRecord() BACnetConstructedDataLastNotifyRecordBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataLastNotifyRecordBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataLastNotifyRecordBuilder().(*_BACnetConstructedDataLastNotifyRecordBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataLastPriority() BACnetConstructedDataLastPriorityBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataLastPriorityBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataLastPriorityBuilder().(*_BACnetConstructedDataLastPriorityBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataLastRestartReason() BACnetConstructedDataLastRestartReasonBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataLastRestartReasonBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataLastRestartReasonBuilder().(*_BACnetConstructedDataLastRestartReasonBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataLastRestoreTime() BACnetConstructedDataLastRestoreTimeBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataLastRestoreTimeBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataLastRestoreTimeBuilder().(*_BACnetConstructedDataLastRestoreTimeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataLastStateChange() BACnetConstructedDataLastStateChangeBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataLastStateChangeBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataLastStateChangeBuilder().(*_BACnetConstructedDataLastStateChangeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataLastUseTime() BACnetConstructedDataLastUseTimeBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataLastUseTimeBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataLastUseTimeBuilder().(*_BACnetConstructedDataLastUseTimeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataLifeSafetyAlarmValues() BACnetConstructedDataLifeSafetyAlarmValuesBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataLifeSafetyAlarmValuesBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataLifeSafetyAlarmValuesBuilder().(*_BACnetConstructedDataLifeSafetyAlarmValuesBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataLightingCommand() BACnetConstructedDataLightingCommandBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataLightingCommandBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataLightingCommandBuilder().(*_BACnetConstructedDataLightingCommandBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataLightingCommandDefaultPriority() BACnetConstructedDataLightingCommandDefaultPriorityBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataLightingCommandDefaultPriorityBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataLightingCommandDefaultPriorityBuilder().(*_BACnetConstructedDataLightingCommandDefaultPriorityBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataLimitEnable() BACnetConstructedDataLimitEnableBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataLimitEnableBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataLimitEnableBuilder().(*_BACnetConstructedDataLimitEnableBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataLimitMonitoringInterval() BACnetConstructedDataLimitMonitoringIntervalBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataLimitMonitoringIntervalBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataLimitMonitoringIntervalBuilder().(*_BACnetConstructedDataLimitMonitoringIntervalBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataLinkSpeed() BACnetConstructedDataLinkSpeedBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataLinkSpeedBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataLinkSpeedBuilder().(*_BACnetConstructedDataLinkSpeedBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataLinkSpeedAutonegotiate() BACnetConstructedDataLinkSpeedAutonegotiateBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataLinkSpeedAutonegotiateBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataLinkSpeedAutonegotiateBuilder().(*_BACnetConstructedDataLinkSpeedAutonegotiateBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataLinkSpeeds() BACnetConstructedDataLinkSpeedsBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataLinkSpeedsBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataLinkSpeedsBuilder().(*_BACnetConstructedDataLinkSpeedsBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataListOfGroupMembers() BACnetConstructedDataListOfGroupMembersBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataListOfGroupMembersBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataListOfGroupMembersBuilder().(*_BACnetConstructedDataListOfGroupMembersBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataChannelListOfObjectPropertyReferences() BACnetConstructedDataChannelListOfObjectPropertyReferencesBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataChannelListOfObjectPropertyReferencesBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataChannelListOfObjectPropertyReferencesBuilder().(*_BACnetConstructedDataChannelListOfObjectPropertyReferencesBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataListOfObjectPropertyReferences() BACnetConstructedDataListOfObjectPropertyReferencesBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataListOfObjectPropertyReferencesBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataListOfObjectPropertyReferencesBuilder().(*_BACnetConstructedDataListOfObjectPropertyReferencesBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataLocalDate() BACnetConstructedDataLocalDateBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataLocalDateBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataLocalDateBuilder().(*_BACnetConstructedDataLocalDateBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataLocalForwardingOnly() BACnetConstructedDataLocalForwardingOnlyBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataLocalForwardingOnlyBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataLocalForwardingOnlyBuilder().(*_BACnetConstructedDataLocalForwardingOnlyBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataLocalTime() BACnetConstructedDataLocalTimeBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataLocalTimeBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataLocalTimeBuilder().(*_BACnetConstructedDataLocalTimeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataLocation() BACnetConstructedDataLocationBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataLocationBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataLocationBuilder().(*_BACnetConstructedDataLocationBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataLockStatus() BACnetConstructedDataLockStatusBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataLockStatusBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataLockStatusBuilder().(*_BACnetConstructedDataLockStatusBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataLockout() BACnetConstructedDataLockoutBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataLockoutBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataLockoutBuilder().(*_BACnetConstructedDataLockoutBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataLockoutRelinquishTime() BACnetConstructedDataLockoutRelinquishTimeBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataLockoutRelinquishTimeBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataLockoutRelinquishTimeBuilder().(*_BACnetConstructedDataLockoutRelinquishTimeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataEventLogLogBuffer() BACnetConstructedDataEventLogLogBufferBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataEventLogLogBufferBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataEventLogLogBufferBuilder().(*_BACnetConstructedDataEventLogLogBufferBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataTrendLogLogBuffer() BACnetConstructedDataTrendLogLogBufferBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataTrendLogLogBufferBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataTrendLogLogBufferBuilder().(*_BACnetConstructedDataTrendLogLogBufferBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataTrendLogMultipleLogBuffer() BACnetConstructedDataTrendLogMultipleLogBufferBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataTrendLogMultipleLogBufferBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataTrendLogMultipleLogBufferBuilder().(*_BACnetConstructedDataTrendLogMultipleLogBufferBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataLogBuffer() BACnetConstructedDataLogBufferBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataLogBufferBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataLogBufferBuilder().(*_BACnetConstructedDataLogBufferBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataTrendLogLogDeviceObjectProperty() BACnetConstructedDataTrendLogLogDeviceObjectPropertyBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataTrendLogLogDeviceObjectPropertyBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataTrendLogLogDeviceObjectPropertyBuilder().(*_BACnetConstructedDataTrendLogLogDeviceObjectPropertyBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataTrendLogMultipleLogDeviceObjectProperty() BACnetConstructedDataTrendLogMultipleLogDeviceObjectPropertyBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataTrendLogMultipleLogDeviceObjectPropertyBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataTrendLogMultipleLogDeviceObjectPropertyBuilder().(*_BACnetConstructedDataTrendLogMultipleLogDeviceObjectPropertyBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataLogDeviceObjectProperty() BACnetConstructedDataLogDeviceObjectPropertyBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataLogDeviceObjectPropertyBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataLogDeviceObjectPropertyBuilder().(*_BACnetConstructedDataLogDeviceObjectPropertyBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataLogInterval() BACnetConstructedDataLogIntervalBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataLogIntervalBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataLogIntervalBuilder().(*_BACnetConstructedDataLogIntervalBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataLoggingObject() BACnetConstructedDataLoggingObjectBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataLoggingObjectBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataLoggingObjectBuilder().(*_BACnetConstructedDataLoggingObjectBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataLoggingRecord() BACnetConstructedDataLoggingRecordBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataLoggingRecordBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataLoggingRecordBuilder().(*_BACnetConstructedDataLoggingRecordBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataLoggingType() BACnetConstructedDataLoggingTypeBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataLoggingTypeBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataLoggingTypeBuilder().(*_BACnetConstructedDataLoggingTypeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataLowDiffLimit() BACnetConstructedDataLowDiffLimitBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataLowDiffLimitBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataLowDiffLimitBuilder().(*_BACnetConstructedDataLowDiffLimitBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataAccumulatorLowLimit() BACnetConstructedDataAccumulatorLowLimitBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataAccumulatorLowLimitBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataAccumulatorLowLimitBuilder().(*_BACnetConstructedDataAccumulatorLowLimitBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataLargeAnalogValueLowLimit() BACnetConstructedDataLargeAnalogValueLowLimitBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataLargeAnalogValueLowLimitBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataLargeAnalogValueLowLimitBuilder().(*_BACnetConstructedDataLargeAnalogValueLowLimitBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataIntegerValueLowLimit() BACnetConstructedDataIntegerValueLowLimitBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataIntegerValueLowLimitBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataIntegerValueLowLimitBuilder().(*_BACnetConstructedDataIntegerValueLowLimitBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataPositiveIntegerValueLowLimit() BACnetConstructedDataPositiveIntegerValueLowLimitBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataPositiveIntegerValueLowLimitBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataPositiveIntegerValueLowLimitBuilder().(*_BACnetConstructedDataPositiveIntegerValueLowLimitBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataLowLimit() BACnetConstructedDataLowLimitBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataLowLimitBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataLowLimitBuilder().(*_BACnetConstructedDataLowLimitBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataLowerDeck() BACnetConstructedDataLowerDeckBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataLowerDeckBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataLowerDeckBuilder().(*_BACnetConstructedDataLowerDeckBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataMACAddress() BACnetConstructedDataMACAddressBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataMACAddressBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataMACAddressBuilder().(*_BACnetConstructedDataMACAddressBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataMachineRoomID() BACnetConstructedDataMachineRoomIDBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataMachineRoomIDBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataMachineRoomIDBuilder().(*_BACnetConstructedDataMachineRoomIDBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataLifeSafetyZoneMaintenanceRequired() BACnetConstructedDataLifeSafetyZoneMaintenanceRequiredBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataLifeSafetyZoneMaintenanceRequiredBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataLifeSafetyZoneMaintenanceRequiredBuilder().(*_BACnetConstructedDataLifeSafetyZoneMaintenanceRequiredBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataMaintenanceRequired() BACnetConstructedDataMaintenanceRequiredBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataMaintenanceRequiredBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataMaintenanceRequiredBuilder().(*_BACnetConstructedDataMaintenanceRequiredBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataMakingCarCall() BACnetConstructedDataMakingCarCallBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataMakingCarCallBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataMakingCarCallBuilder().(*_BACnetConstructedDataMakingCarCallBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataManipulatedVariableReference() BACnetConstructedDataManipulatedVariableReferenceBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataManipulatedVariableReferenceBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataManipulatedVariableReferenceBuilder().(*_BACnetConstructedDataManipulatedVariableReferenceBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataManualSlaveAddressBinding() BACnetConstructedDataManualSlaveAddressBindingBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataManualSlaveAddressBindingBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataManualSlaveAddressBindingBuilder().(*_BACnetConstructedDataManualSlaveAddressBindingBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataMaskedAlarmValues() BACnetConstructedDataMaskedAlarmValuesBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataMaskedAlarmValuesBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataMaskedAlarmValuesBuilder().(*_BACnetConstructedDataMaskedAlarmValuesBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataMaxActualValue() BACnetConstructedDataMaxActualValueBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataMaxActualValueBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataMaxActualValueBuilder().(*_BACnetConstructedDataMaxActualValueBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataMaxAPDULengthAccepted() BACnetConstructedDataMaxAPDULengthAcceptedBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataMaxAPDULengthAcceptedBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataMaxAPDULengthAcceptedBuilder().(*_BACnetConstructedDataMaxAPDULengthAcceptedBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataMaxFailedAttempts() BACnetConstructedDataMaxFailedAttemptsBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataMaxFailedAttemptsBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataMaxFailedAttemptsBuilder().(*_BACnetConstructedDataMaxFailedAttemptsBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataDeviceMaxInfoFrames() BACnetConstructedDataDeviceMaxInfoFramesBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataDeviceMaxInfoFramesBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataDeviceMaxInfoFramesBuilder().(*_BACnetConstructedDataDeviceMaxInfoFramesBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataNetworkPortMaxInfoFrames() BACnetConstructedDataNetworkPortMaxInfoFramesBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataNetworkPortMaxInfoFramesBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataNetworkPortMaxInfoFramesBuilder().(*_BACnetConstructedDataNetworkPortMaxInfoFramesBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataMaxInfoFrames() BACnetConstructedDataMaxInfoFramesBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataMaxInfoFramesBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataMaxInfoFramesBuilder().(*_BACnetConstructedDataMaxInfoFramesBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataDeviceMaxMaster() BACnetConstructedDataDeviceMaxMasterBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataDeviceMaxMasterBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataDeviceMaxMasterBuilder().(*_BACnetConstructedDataDeviceMaxMasterBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataNetworkPortMaxMaster() BACnetConstructedDataNetworkPortMaxMasterBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataNetworkPortMaxMasterBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataNetworkPortMaxMasterBuilder().(*_BACnetConstructedDataNetworkPortMaxMasterBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataMaxMaster() BACnetConstructedDataMaxMasterBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataMaxMasterBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataMaxMasterBuilder().(*_BACnetConstructedDataMaxMasterBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataAccumulatorMaxPresValue() BACnetConstructedDataAccumulatorMaxPresValueBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataAccumulatorMaxPresValueBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataAccumulatorMaxPresValueBuilder().(*_BACnetConstructedDataAccumulatorMaxPresValueBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataAnalogInputMaxPresValue() BACnetConstructedDataAnalogInputMaxPresValueBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataAnalogInputMaxPresValueBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataAnalogInputMaxPresValueBuilder().(*_BACnetConstructedDataAnalogInputMaxPresValueBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataAnalogOutputMaxPresValue() BACnetConstructedDataAnalogOutputMaxPresValueBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataAnalogOutputMaxPresValueBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataAnalogOutputMaxPresValueBuilder().(*_BACnetConstructedDataAnalogOutputMaxPresValueBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataAnalogValueMaxPresValue() BACnetConstructedDataAnalogValueMaxPresValueBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataAnalogValueMaxPresValueBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataAnalogValueMaxPresValueBuilder().(*_BACnetConstructedDataAnalogValueMaxPresValueBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataLargeAnalogValueMaxPresValue() BACnetConstructedDataLargeAnalogValueMaxPresValueBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataLargeAnalogValueMaxPresValueBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataLargeAnalogValueMaxPresValueBuilder().(*_BACnetConstructedDataLargeAnalogValueMaxPresValueBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataIntegerValueMaxPresValue() BACnetConstructedDataIntegerValueMaxPresValueBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataIntegerValueMaxPresValueBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataIntegerValueMaxPresValueBuilder().(*_BACnetConstructedDataIntegerValueMaxPresValueBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataPositiveIntegerValueMaxPresValue() BACnetConstructedDataPositiveIntegerValueMaxPresValueBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataPositiveIntegerValueMaxPresValueBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataPositiveIntegerValueMaxPresValueBuilder().(*_BACnetConstructedDataPositiveIntegerValueMaxPresValueBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataTimerMaxPresValue() BACnetConstructedDataTimerMaxPresValueBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataTimerMaxPresValueBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataTimerMaxPresValueBuilder().(*_BACnetConstructedDataTimerMaxPresValueBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataMaxPresValue() BACnetConstructedDataMaxPresValueBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataMaxPresValueBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataMaxPresValueBuilder().(*_BACnetConstructedDataMaxPresValueBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataMaxSegmentsAccepted() BACnetConstructedDataMaxSegmentsAcceptedBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataMaxSegmentsAcceptedBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataMaxSegmentsAcceptedBuilder().(*_BACnetConstructedDataMaxSegmentsAcceptedBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataMaximumOutput() BACnetConstructedDataMaximumOutputBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataMaximumOutputBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataMaximumOutputBuilder().(*_BACnetConstructedDataMaximumOutputBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataMaximumValue() BACnetConstructedDataMaximumValueBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataMaximumValueBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataMaximumValueBuilder().(*_BACnetConstructedDataMaximumValueBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataMaximumValueTimestamp() BACnetConstructedDataMaximumValueTimestampBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataMaximumValueTimestampBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataMaximumValueTimestampBuilder().(*_BACnetConstructedDataMaximumValueTimestampBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataMemberOf() BACnetConstructedDataMemberOfBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataMemberOfBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataMemberOfBuilder().(*_BACnetConstructedDataMemberOfBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataMemberStatusFlags() BACnetConstructedDataMemberStatusFlagsBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataMemberStatusFlagsBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataMemberStatusFlagsBuilder().(*_BACnetConstructedDataMemberStatusFlagsBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataMembers() BACnetConstructedDataMembersBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataMembersBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataMembersBuilder().(*_BACnetConstructedDataMembersBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataMinActualValue() BACnetConstructedDataMinActualValueBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataMinActualValueBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataMinActualValueBuilder().(*_BACnetConstructedDataMinActualValueBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataAccumulatorMinPresValue() BACnetConstructedDataAccumulatorMinPresValueBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataAccumulatorMinPresValueBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataAccumulatorMinPresValueBuilder().(*_BACnetConstructedDataAccumulatorMinPresValueBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataIntegerValueMinPresValue() BACnetConstructedDataIntegerValueMinPresValueBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataIntegerValueMinPresValueBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataIntegerValueMinPresValueBuilder().(*_BACnetConstructedDataIntegerValueMinPresValueBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataPositiveIntegerValueMinPresValue() BACnetConstructedDataPositiveIntegerValueMinPresValueBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataPositiveIntegerValueMinPresValueBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataPositiveIntegerValueMinPresValueBuilder().(*_BACnetConstructedDataPositiveIntegerValueMinPresValueBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataLargeAnalogValueMinPresValue() BACnetConstructedDataLargeAnalogValueMinPresValueBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataLargeAnalogValueMinPresValueBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataLargeAnalogValueMinPresValueBuilder().(*_BACnetConstructedDataLargeAnalogValueMinPresValueBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataTimerMinPresValue() BACnetConstructedDataTimerMinPresValueBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataTimerMinPresValueBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataTimerMinPresValueBuilder().(*_BACnetConstructedDataTimerMinPresValueBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataMinPresValue() BACnetConstructedDataMinPresValueBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataMinPresValueBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataMinPresValueBuilder().(*_BACnetConstructedDataMinPresValueBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataMinimumOffTime() BACnetConstructedDataMinimumOffTimeBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataMinimumOffTimeBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataMinimumOffTimeBuilder().(*_BACnetConstructedDataMinimumOffTimeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataMinimumOnTime() BACnetConstructedDataMinimumOnTimeBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataMinimumOnTimeBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataMinimumOnTimeBuilder().(*_BACnetConstructedDataMinimumOnTimeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataMinimumOutput() BACnetConstructedDataMinimumOutputBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataMinimumOutputBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataMinimumOutputBuilder().(*_BACnetConstructedDataMinimumOutputBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataMinimumValue() BACnetConstructedDataMinimumValueBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataMinimumValueBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataMinimumValueBuilder().(*_BACnetConstructedDataMinimumValueBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataMinimumValueTimestamp() BACnetConstructedDataMinimumValueTimestampBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataMinimumValueTimestampBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataMinimumValueTimestampBuilder().(*_BACnetConstructedDataMinimumValueTimestampBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataMode() BACnetConstructedDataModeBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataModeBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataModeBuilder().(*_BACnetConstructedDataModeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataModelName() BACnetConstructedDataModelNameBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataModelNameBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataModelNameBuilder().(*_BACnetConstructedDataModelNameBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataModificationDate() BACnetConstructedDataModificationDateBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataModificationDateBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataModificationDateBuilder().(*_BACnetConstructedDataModificationDateBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataMusterPoint() BACnetConstructedDataMusterPointBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataMusterPointBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataMusterPointBuilder().(*_BACnetConstructedDataMusterPointBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataNegativeAccessRules() BACnetConstructedDataNegativeAccessRulesBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataNegativeAccessRulesBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataNegativeAccessRulesBuilder().(*_BACnetConstructedDataNegativeAccessRulesBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataNetworkAccessSecurityPolicies() BACnetConstructedDataNetworkAccessSecurityPoliciesBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataNetworkAccessSecurityPoliciesBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataNetworkAccessSecurityPoliciesBuilder().(*_BACnetConstructedDataNetworkAccessSecurityPoliciesBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataNetworkInterfaceName() BACnetConstructedDataNetworkInterfaceNameBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataNetworkInterfaceNameBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataNetworkInterfaceNameBuilder().(*_BACnetConstructedDataNetworkInterfaceNameBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataNetworkNumber() BACnetConstructedDataNetworkNumberBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataNetworkNumberBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataNetworkNumberBuilder().(*_BACnetConstructedDataNetworkNumberBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataNetworkNumberQuality() BACnetConstructedDataNetworkNumberQualityBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataNetworkNumberQualityBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataNetworkNumberQualityBuilder().(*_BACnetConstructedDataNetworkNumberQualityBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataNetworkType() BACnetConstructedDataNetworkTypeBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataNetworkTypeBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataNetworkTypeBuilder().(*_BACnetConstructedDataNetworkTypeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataNextStoppingFloor() BACnetConstructedDataNextStoppingFloorBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataNextStoppingFloorBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataNextStoppingFloorBuilder().(*_BACnetConstructedDataNextStoppingFloorBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataNodeSubtype() BACnetConstructedDataNodeSubtypeBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataNodeSubtypeBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataNodeSubtypeBuilder().(*_BACnetConstructedDataNodeSubtypeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataNodeType() BACnetConstructedDataNodeTypeBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataNodeTypeBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataNodeTypeBuilder().(*_BACnetConstructedDataNodeTypeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataNotificationClass() BACnetConstructedDataNotificationClassBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataNotificationClassBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataNotificationClassBuilder().(*_BACnetConstructedDataNotificationClassBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataNotificationThreshold() BACnetConstructedDataNotificationThresholdBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataNotificationThresholdBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataNotificationThresholdBuilder().(*_BACnetConstructedDataNotificationThresholdBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataNotifyType() BACnetConstructedDataNotifyTypeBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataNotifyTypeBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataNotifyTypeBuilder().(*_BACnetConstructedDataNotifyTypeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataNumberOfAPDURetries() BACnetConstructedDataNumberOfAPDURetriesBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataNumberOfAPDURetriesBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataNumberOfAPDURetriesBuilder().(*_BACnetConstructedDataNumberOfAPDURetriesBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataNumberOfAuthenticationPolicies() BACnetConstructedDataNumberOfAuthenticationPoliciesBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataNumberOfAuthenticationPoliciesBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataNumberOfAuthenticationPoliciesBuilder().(*_BACnetConstructedDataNumberOfAuthenticationPoliciesBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataNumberOfStates() BACnetConstructedDataNumberOfStatesBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataNumberOfStatesBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataNumberOfStatesBuilder().(*_BACnetConstructedDataNumberOfStatesBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataObjectIdentifier() BACnetConstructedDataObjectIdentifierBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataObjectIdentifierBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataObjectIdentifierBuilder().(*_BACnetConstructedDataObjectIdentifierBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataObjectList() BACnetConstructedDataObjectListBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataObjectListBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataObjectListBuilder().(*_BACnetConstructedDataObjectListBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataObjectName() BACnetConstructedDataObjectNameBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataObjectNameBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataObjectNameBuilder().(*_BACnetConstructedDataObjectNameBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataObjectPropertyReference() BACnetConstructedDataObjectPropertyReferenceBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataObjectPropertyReferenceBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataObjectPropertyReferenceBuilder().(*_BACnetConstructedDataObjectPropertyReferenceBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataObjectType() BACnetConstructedDataObjectTypeBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataObjectTypeBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataObjectTypeBuilder().(*_BACnetConstructedDataObjectTypeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataOccupancyCount() BACnetConstructedDataOccupancyCountBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataOccupancyCountBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataOccupancyCountBuilder().(*_BACnetConstructedDataOccupancyCountBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataOccupancyCountAdjust() BACnetConstructedDataOccupancyCountAdjustBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataOccupancyCountAdjustBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataOccupancyCountAdjustBuilder().(*_BACnetConstructedDataOccupancyCountAdjustBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataOccupancyCountEnable() BACnetConstructedDataOccupancyCountEnableBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataOccupancyCountEnableBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataOccupancyCountEnableBuilder().(*_BACnetConstructedDataOccupancyCountEnableBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataOccupancyLowerLimit() BACnetConstructedDataOccupancyLowerLimitBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataOccupancyLowerLimitBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataOccupancyLowerLimitBuilder().(*_BACnetConstructedDataOccupancyLowerLimitBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataOccupancyLowerLimitEnforced() BACnetConstructedDataOccupancyLowerLimitEnforcedBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataOccupancyLowerLimitEnforcedBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataOccupancyLowerLimitEnforcedBuilder().(*_BACnetConstructedDataOccupancyLowerLimitEnforcedBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataOccupancyState() BACnetConstructedDataOccupancyStateBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataOccupancyStateBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataOccupancyStateBuilder().(*_BACnetConstructedDataOccupancyStateBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataOccupancyUpperLimit() BACnetConstructedDataOccupancyUpperLimitBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataOccupancyUpperLimitBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataOccupancyUpperLimitBuilder().(*_BACnetConstructedDataOccupancyUpperLimitBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataOccupancyUpperLimitEnforced() BACnetConstructedDataOccupancyUpperLimitEnforcedBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataOccupancyUpperLimitEnforcedBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataOccupancyUpperLimitEnforcedBuilder().(*_BACnetConstructedDataOccupancyUpperLimitEnforcedBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataOperationDirection() BACnetConstructedDataOperationDirectionBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataOperationDirectionBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataOperationDirectionBuilder().(*_BACnetConstructedDataOperationDirectionBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataOperationExpected() BACnetConstructedDataOperationExpectedBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataOperationExpectedBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataOperationExpectedBuilder().(*_BACnetConstructedDataOperationExpectedBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataOptional() BACnetConstructedDataOptionalBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataOptionalBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataOptionalBuilder().(*_BACnetConstructedDataOptionalBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataOutOfService() BACnetConstructedDataOutOfServiceBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataOutOfServiceBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataOutOfServiceBuilder().(*_BACnetConstructedDataOutOfServiceBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataOutputUnits() BACnetConstructedDataOutputUnitsBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataOutputUnitsBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataOutputUnitsBuilder().(*_BACnetConstructedDataOutputUnitsBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataPacketReorderTime() BACnetConstructedDataPacketReorderTimeBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataPacketReorderTimeBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataPacketReorderTimeBuilder().(*_BACnetConstructedDataPacketReorderTimeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataPassbackMode() BACnetConstructedDataPassbackModeBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataPassbackModeBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataPassbackModeBuilder().(*_BACnetConstructedDataPassbackModeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataPassbackTimeout() BACnetConstructedDataPassbackTimeoutBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataPassbackTimeoutBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataPassbackTimeoutBuilder().(*_BACnetConstructedDataPassbackTimeoutBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataPassengerAlarm() BACnetConstructedDataPassengerAlarmBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataPassengerAlarmBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataPassengerAlarmBuilder().(*_BACnetConstructedDataPassengerAlarmBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataPolarity() BACnetConstructedDataPolarityBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataPolarityBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataPolarityBuilder().(*_BACnetConstructedDataPolarityBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataPortFilter() BACnetConstructedDataPortFilterBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataPortFilterBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataPortFilterBuilder().(*_BACnetConstructedDataPortFilterBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataPositiveAccessRules() BACnetConstructedDataPositiveAccessRulesBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataPositiveAccessRulesBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataPositiveAccessRulesBuilder().(*_BACnetConstructedDataPositiveAccessRulesBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataPower() BACnetConstructedDataPowerBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataPowerBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataPowerBuilder().(*_BACnetConstructedDataPowerBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataPowerMode() BACnetConstructedDataPowerModeBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataPowerModeBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataPowerModeBuilder().(*_BACnetConstructedDataPowerModeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataPrescale() BACnetConstructedDataPrescaleBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataPrescaleBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataPrescaleBuilder().(*_BACnetConstructedDataPrescaleBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataAccessDoorPresentValue() BACnetConstructedDataAccessDoorPresentValueBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataAccessDoorPresentValueBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataAccessDoorPresentValueBuilder().(*_BACnetConstructedDataAccessDoorPresentValueBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataAlertEnrollmentPresentValue() BACnetConstructedDataAlertEnrollmentPresentValueBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataAlertEnrollmentPresentValueBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataAlertEnrollmentPresentValueBuilder().(*_BACnetConstructedDataAlertEnrollmentPresentValueBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataAnalogInputPresentValue() BACnetConstructedDataAnalogInputPresentValueBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataAnalogInputPresentValueBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataAnalogInputPresentValueBuilder().(*_BACnetConstructedDataAnalogInputPresentValueBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataAnalogOutputPresentValue() BACnetConstructedDataAnalogOutputPresentValueBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataAnalogOutputPresentValueBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataAnalogOutputPresentValueBuilder().(*_BACnetConstructedDataAnalogOutputPresentValueBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataAnalogValuePresentValue() BACnetConstructedDataAnalogValuePresentValueBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataAnalogValuePresentValueBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataAnalogValuePresentValueBuilder().(*_BACnetConstructedDataAnalogValuePresentValueBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataBinaryInputPresentValue() BACnetConstructedDataBinaryInputPresentValueBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataBinaryInputPresentValueBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataBinaryInputPresentValueBuilder().(*_BACnetConstructedDataBinaryInputPresentValueBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataBinaryOutputPresentValue() BACnetConstructedDataBinaryOutputPresentValueBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataBinaryOutputPresentValueBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataBinaryOutputPresentValueBuilder().(*_BACnetConstructedDataBinaryOutputPresentValueBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataBinaryValuePresentValue() BACnetConstructedDataBinaryValuePresentValueBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataBinaryValuePresentValueBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataBinaryValuePresentValueBuilder().(*_BACnetConstructedDataBinaryValuePresentValueBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataBinaryLightingOutputPresentValue() BACnetConstructedDataBinaryLightingOutputPresentValueBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataBinaryLightingOutputPresentValueBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataBinaryLightingOutputPresentValueBuilder().(*_BACnetConstructedDataBinaryLightingOutputPresentValueBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataBitStringValuePresentValue() BACnetConstructedDataBitStringValuePresentValueBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataBitStringValuePresentValueBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataBitStringValuePresentValueBuilder().(*_BACnetConstructedDataBitStringValuePresentValueBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataCalendarPresentValue() BACnetConstructedDataCalendarPresentValueBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataCalendarPresentValueBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataCalendarPresentValueBuilder().(*_BACnetConstructedDataCalendarPresentValueBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataChannelPresentValue() BACnetConstructedDataChannelPresentValueBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataChannelPresentValueBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataChannelPresentValueBuilder().(*_BACnetConstructedDataChannelPresentValueBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataCharacterStringValuePresentValue() BACnetConstructedDataCharacterStringValuePresentValueBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataCharacterStringValuePresentValueBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataCharacterStringValuePresentValueBuilder().(*_BACnetConstructedDataCharacterStringValuePresentValueBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataCredentialDataInputPresentValue() BACnetConstructedDataCredentialDataInputPresentValueBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataCredentialDataInputPresentValueBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataCredentialDataInputPresentValueBuilder().(*_BACnetConstructedDataCredentialDataInputPresentValueBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataDateValuePresentValue() BACnetConstructedDataDateValuePresentValueBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataDateValuePresentValueBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataDateValuePresentValueBuilder().(*_BACnetConstructedDataDateValuePresentValueBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataDatePatternValuePresentValue() BACnetConstructedDataDatePatternValuePresentValueBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataDatePatternValuePresentValueBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataDatePatternValuePresentValueBuilder().(*_BACnetConstructedDataDatePatternValuePresentValueBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataDateTimeValuePresentValue() BACnetConstructedDataDateTimeValuePresentValueBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataDateTimeValuePresentValueBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataDateTimeValuePresentValueBuilder().(*_BACnetConstructedDataDateTimeValuePresentValueBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataDateTimePatternValuePresentValue() BACnetConstructedDataDateTimePatternValuePresentValueBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataDateTimePatternValuePresentValueBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataDateTimePatternValuePresentValueBuilder().(*_BACnetConstructedDataDateTimePatternValuePresentValueBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataIntegerValuePresentValue() BACnetConstructedDataIntegerValuePresentValueBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataIntegerValuePresentValueBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataIntegerValuePresentValueBuilder().(*_BACnetConstructedDataIntegerValuePresentValueBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataLargeAnalogValuePresentValue() BACnetConstructedDataLargeAnalogValuePresentValueBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataLargeAnalogValuePresentValueBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataLargeAnalogValuePresentValueBuilder().(*_BACnetConstructedDataLargeAnalogValuePresentValueBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataLightingOutputPresentValue() BACnetConstructedDataLightingOutputPresentValueBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataLightingOutputPresentValueBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataLightingOutputPresentValueBuilder().(*_BACnetConstructedDataLightingOutputPresentValueBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataLifeSafetyPointPresentValue() BACnetConstructedDataLifeSafetyPointPresentValueBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataLifeSafetyPointPresentValueBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataLifeSafetyPointPresentValueBuilder().(*_BACnetConstructedDataLifeSafetyPointPresentValueBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataLifeSafetyZonePresentValue() BACnetConstructedDataLifeSafetyZonePresentValueBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataLifeSafetyZonePresentValueBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataLifeSafetyZonePresentValueBuilder().(*_BACnetConstructedDataLifeSafetyZonePresentValueBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataLoadControlPresentValue() BACnetConstructedDataLoadControlPresentValueBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataLoadControlPresentValueBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataLoadControlPresentValueBuilder().(*_BACnetConstructedDataLoadControlPresentValueBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataLoopPresentValue() BACnetConstructedDataLoopPresentValueBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataLoopPresentValueBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataLoopPresentValueBuilder().(*_BACnetConstructedDataLoopPresentValueBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataPulseConverterPresentValue() BACnetConstructedDataPulseConverterPresentValueBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataPulseConverterPresentValueBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataPulseConverterPresentValueBuilder().(*_BACnetConstructedDataPulseConverterPresentValueBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataGroupPresentValue() BACnetConstructedDataGroupPresentValueBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataGroupPresentValueBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataGroupPresentValueBuilder().(*_BACnetConstructedDataGroupPresentValueBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataGlobalGroupPresentValue() BACnetConstructedDataGlobalGroupPresentValueBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataGlobalGroupPresentValueBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataGlobalGroupPresentValueBuilder().(*_BACnetConstructedDataGlobalGroupPresentValueBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataOctetStringValuePresentValue() BACnetConstructedDataOctetStringValuePresentValueBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataOctetStringValuePresentValueBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataOctetStringValuePresentValueBuilder().(*_BACnetConstructedDataOctetStringValuePresentValueBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataSchedulePresentValue() BACnetConstructedDataSchedulePresentValueBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataSchedulePresentValueBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataSchedulePresentValueBuilder().(*_BACnetConstructedDataSchedulePresentValueBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataTimeValuePresentValue() BACnetConstructedDataTimeValuePresentValueBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataTimeValuePresentValueBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataTimeValuePresentValueBuilder().(*_BACnetConstructedDataTimeValuePresentValueBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataTimePatternValuePresentValue() BACnetConstructedDataTimePatternValuePresentValueBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataTimePatternValuePresentValueBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataTimePatternValuePresentValueBuilder().(*_BACnetConstructedDataTimePatternValuePresentValueBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataPresentValue() BACnetConstructedDataPresentValueBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataPresentValueBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataPresentValueBuilder().(*_BACnetConstructedDataPresentValueBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataPriority() BACnetConstructedDataPriorityBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataPriorityBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataPriorityBuilder().(*_BACnetConstructedDataPriorityBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataPriorityArray() BACnetConstructedDataPriorityArrayBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataPriorityArrayBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataPriorityArrayBuilder().(*_BACnetConstructedDataPriorityArrayBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataPriorityForWriting() BACnetConstructedDataPriorityForWritingBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataPriorityForWritingBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataPriorityForWritingBuilder().(*_BACnetConstructedDataPriorityForWritingBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataProcessIdentifier() BACnetConstructedDataProcessIdentifierBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataProcessIdentifierBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataProcessIdentifierBuilder().(*_BACnetConstructedDataProcessIdentifierBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataProcessIdentifierFilter() BACnetConstructedDataProcessIdentifierFilterBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataProcessIdentifierFilterBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataProcessIdentifierFilterBuilder().(*_BACnetConstructedDataProcessIdentifierFilterBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataProfileLocation() BACnetConstructedDataProfileLocationBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataProfileLocationBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataProfileLocationBuilder().(*_BACnetConstructedDataProfileLocationBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataProfileName() BACnetConstructedDataProfileNameBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataProfileNameBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataProfileNameBuilder().(*_BACnetConstructedDataProfileNameBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataProgramChange() BACnetConstructedDataProgramChangeBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataProgramChangeBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataProgramChangeBuilder().(*_BACnetConstructedDataProgramChangeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataProgramLocation() BACnetConstructedDataProgramLocationBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataProgramLocationBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataProgramLocationBuilder().(*_BACnetConstructedDataProgramLocationBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataProgramState() BACnetConstructedDataProgramStateBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataProgramStateBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataProgramStateBuilder().(*_BACnetConstructedDataProgramStateBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataPropertyList() BACnetConstructedDataPropertyListBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataPropertyListBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataPropertyListBuilder().(*_BACnetConstructedDataPropertyListBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataProportionalConstant() BACnetConstructedDataProportionalConstantBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataProportionalConstantBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataProportionalConstantBuilder().(*_BACnetConstructedDataProportionalConstantBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataProportionalConstantUnits() BACnetConstructedDataProportionalConstantUnitsBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataProportionalConstantUnitsBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataProportionalConstantUnitsBuilder().(*_BACnetConstructedDataProportionalConstantUnitsBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataProtocolLevel() BACnetConstructedDataProtocolLevelBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataProtocolLevelBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataProtocolLevelBuilder().(*_BACnetConstructedDataProtocolLevelBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataProtocolObjectTypesSupported() BACnetConstructedDataProtocolObjectTypesSupportedBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataProtocolObjectTypesSupportedBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataProtocolObjectTypesSupportedBuilder().(*_BACnetConstructedDataProtocolObjectTypesSupportedBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataProtocolRevision() BACnetConstructedDataProtocolRevisionBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataProtocolRevisionBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataProtocolRevisionBuilder().(*_BACnetConstructedDataProtocolRevisionBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataProtocolServicesSupported() BACnetConstructedDataProtocolServicesSupportedBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataProtocolServicesSupportedBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataProtocolServicesSupportedBuilder().(*_BACnetConstructedDataProtocolServicesSupportedBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataProtocolVersion() BACnetConstructedDataProtocolVersionBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataProtocolVersionBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataProtocolVersionBuilder().(*_BACnetConstructedDataProtocolVersionBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataPulseRate() BACnetConstructedDataPulseRateBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataPulseRateBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataPulseRateBuilder().(*_BACnetConstructedDataPulseRateBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataReadOnly() BACnetConstructedDataReadOnlyBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataReadOnlyBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataReadOnlyBuilder().(*_BACnetConstructedDataReadOnlyBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataReasonForDisable() BACnetConstructedDataReasonForDisableBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataReasonForDisableBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataReasonForDisableBuilder().(*_BACnetConstructedDataReasonForDisableBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataReasonForHalt() BACnetConstructedDataReasonForHaltBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataReasonForHaltBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataReasonForHaltBuilder().(*_BACnetConstructedDataReasonForHaltBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataRecipientList() BACnetConstructedDataRecipientListBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataRecipientListBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataRecipientListBuilder().(*_BACnetConstructedDataRecipientListBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataFileRecordCount() BACnetConstructedDataFileRecordCountBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataFileRecordCountBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataFileRecordCountBuilder().(*_BACnetConstructedDataFileRecordCountBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataRecordCount() BACnetConstructedDataRecordCountBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataRecordCountBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataRecordCountBuilder().(*_BACnetConstructedDataRecordCountBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataRecordsSinceNotification() BACnetConstructedDataRecordsSinceNotificationBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataRecordsSinceNotificationBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataRecordsSinceNotificationBuilder().(*_BACnetConstructedDataRecordsSinceNotificationBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataReferencePort() BACnetConstructedDataReferencePortBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataReferencePortBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataReferencePortBuilder().(*_BACnetConstructedDataReferencePortBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataRegisteredCarCall() BACnetConstructedDataRegisteredCarCallBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataRegisteredCarCallBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataRegisteredCarCallBuilder().(*_BACnetConstructedDataRegisteredCarCallBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataReliability() BACnetConstructedDataReliabilityBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataReliabilityBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataReliabilityBuilder().(*_BACnetConstructedDataReliabilityBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataReliabilityEvaluationInhibit() BACnetConstructedDataReliabilityEvaluationInhibitBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataReliabilityEvaluationInhibitBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataReliabilityEvaluationInhibitBuilder().(*_BACnetConstructedDataReliabilityEvaluationInhibitBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataAccessDoorRelinquishDefault() BACnetConstructedDataAccessDoorRelinquishDefaultBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataAccessDoorRelinquishDefaultBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataAccessDoorRelinquishDefaultBuilder().(*_BACnetConstructedDataAccessDoorRelinquishDefaultBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataAnalogOutputRelinquishDefault() BACnetConstructedDataAnalogOutputRelinquishDefaultBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataAnalogOutputRelinquishDefaultBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataAnalogOutputRelinquishDefaultBuilder().(*_BACnetConstructedDataAnalogOutputRelinquishDefaultBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataAnalogValueRelinquishDefault() BACnetConstructedDataAnalogValueRelinquishDefaultBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataAnalogValueRelinquishDefaultBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataAnalogValueRelinquishDefaultBuilder().(*_BACnetConstructedDataAnalogValueRelinquishDefaultBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataBinaryOutputRelinquishDefault() BACnetConstructedDataBinaryOutputRelinquishDefaultBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataBinaryOutputRelinquishDefaultBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataBinaryOutputRelinquishDefaultBuilder().(*_BACnetConstructedDataBinaryOutputRelinquishDefaultBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataBinaryValueRelinquishDefault() BACnetConstructedDataBinaryValueRelinquishDefaultBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataBinaryValueRelinquishDefaultBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataBinaryValueRelinquishDefaultBuilder().(*_BACnetConstructedDataBinaryValueRelinquishDefaultBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataBinaryLightingOutputRelinquishDefault() BACnetConstructedDataBinaryLightingOutputRelinquishDefaultBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataBinaryLightingOutputRelinquishDefaultBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataBinaryLightingOutputRelinquishDefaultBuilder().(*_BACnetConstructedDataBinaryLightingOutputRelinquishDefaultBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataBitStringValueRelinquishDefault() BACnetConstructedDataBitStringValueRelinquishDefaultBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataBitStringValueRelinquishDefaultBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataBitStringValueRelinquishDefaultBuilder().(*_BACnetConstructedDataBitStringValueRelinquishDefaultBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataCharacterStringValueRelinquishDefault() BACnetConstructedDataCharacterStringValueRelinquishDefaultBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataCharacterStringValueRelinquishDefaultBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataCharacterStringValueRelinquishDefaultBuilder().(*_BACnetConstructedDataCharacterStringValueRelinquishDefaultBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataDateValueRelinquishDefault() BACnetConstructedDataDateValueRelinquishDefaultBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataDateValueRelinquishDefaultBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataDateValueRelinquishDefaultBuilder().(*_BACnetConstructedDataDateValueRelinquishDefaultBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataDatePatternValueRelinquishDefault() BACnetConstructedDataDatePatternValueRelinquishDefaultBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataDatePatternValueRelinquishDefaultBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataDatePatternValueRelinquishDefaultBuilder().(*_BACnetConstructedDataDatePatternValueRelinquishDefaultBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataDateTimeValueRelinquishDefault() BACnetConstructedDataDateTimeValueRelinquishDefaultBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataDateTimeValueRelinquishDefaultBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataDateTimeValueRelinquishDefaultBuilder().(*_BACnetConstructedDataDateTimeValueRelinquishDefaultBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataDateTimePatternValueRelinquishDefault() BACnetConstructedDataDateTimePatternValueRelinquishDefaultBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataDateTimePatternValueRelinquishDefaultBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataDateTimePatternValueRelinquishDefaultBuilder().(*_BACnetConstructedDataDateTimePatternValueRelinquishDefaultBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataLargeAnalogValueRelinquishDefault() BACnetConstructedDataLargeAnalogValueRelinquishDefaultBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataLargeAnalogValueRelinquishDefaultBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataLargeAnalogValueRelinquishDefaultBuilder().(*_BACnetConstructedDataLargeAnalogValueRelinquishDefaultBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataLightingOutputRelinquishDefault() BACnetConstructedDataLightingOutputRelinquishDefaultBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataLightingOutputRelinquishDefaultBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataLightingOutputRelinquishDefaultBuilder().(*_BACnetConstructedDataLightingOutputRelinquishDefaultBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataTimePatternValueRelinquishDefault() BACnetConstructedDataTimePatternValueRelinquishDefaultBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataTimePatternValueRelinquishDefaultBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataTimePatternValueRelinquishDefaultBuilder().(*_BACnetConstructedDataTimePatternValueRelinquishDefaultBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataTimeValueRelinquishDefault() BACnetConstructedDataTimeValueRelinquishDefaultBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataTimeValueRelinquishDefaultBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataTimeValueRelinquishDefaultBuilder().(*_BACnetConstructedDataTimeValueRelinquishDefaultBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataIntegerValueRelinquishDefault() BACnetConstructedDataIntegerValueRelinquishDefaultBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataIntegerValueRelinquishDefaultBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataIntegerValueRelinquishDefaultBuilder().(*_BACnetConstructedDataIntegerValueRelinquishDefaultBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataOctetStringValueRelinquishDefault() BACnetConstructedDataOctetStringValueRelinquishDefaultBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataOctetStringValueRelinquishDefaultBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataOctetStringValueRelinquishDefaultBuilder().(*_BACnetConstructedDataOctetStringValueRelinquishDefaultBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataPositiveIntegerValueRelinquishDefault() BACnetConstructedDataPositiveIntegerValueRelinquishDefaultBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataPositiveIntegerValueRelinquishDefaultBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataPositiveIntegerValueRelinquishDefaultBuilder().(*_BACnetConstructedDataPositiveIntegerValueRelinquishDefaultBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataMultiStateOutputRelinquishDefault() BACnetConstructedDataMultiStateOutputRelinquishDefaultBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataMultiStateOutputRelinquishDefaultBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataMultiStateOutputRelinquishDefaultBuilder().(*_BACnetConstructedDataMultiStateOutputRelinquishDefaultBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataMultiStateValueRelinquishDefault() BACnetConstructedDataMultiStateValueRelinquishDefaultBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataMultiStateValueRelinquishDefaultBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataMultiStateValueRelinquishDefaultBuilder().(*_BACnetConstructedDataMultiStateValueRelinquishDefaultBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataRelinquishDefault() BACnetConstructedDataRelinquishDefaultBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataRelinquishDefaultBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataRelinquishDefaultBuilder().(*_BACnetConstructedDataRelinquishDefaultBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataRepresents() BACnetConstructedDataRepresentsBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataRepresentsBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataRepresentsBuilder().(*_BACnetConstructedDataRepresentsBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataRequestedShedLevel() BACnetConstructedDataRequestedShedLevelBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataRequestedShedLevelBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataRequestedShedLevelBuilder().(*_BACnetConstructedDataRequestedShedLevelBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataRequestedUpdateInterval() BACnetConstructedDataRequestedUpdateIntervalBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataRequestedUpdateIntervalBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataRequestedUpdateIntervalBuilder().(*_BACnetConstructedDataRequestedUpdateIntervalBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataRequired() BACnetConstructedDataRequiredBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataRequiredBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataRequiredBuilder().(*_BACnetConstructedDataRequiredBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataLargeAnalogValueResolution() BACnetConstructedDataLargeAnalogValueResolutionBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataLargeAnalogValueResolutionBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataLargeAnalogValueResolutionBuilder().(*_BACnetConstructedDataLargeAnalogValueResolutionBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataIntegerValueResolution() BACnetConstructedDataIntegerValueResolutionBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataIntegerValueResolutionBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataIntegerValueResolutionBuilder().(*_BACnetConstructedDataIntegerValueResolutionBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataPositiveIntegerValueResolution() BACnetConstructedDataPositiveIntegerValueResolutionBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataPositiveIntegerValueResolutionBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataPositiveIntegerValueResolutionBuilder().(*_BACnetConstructedDataPositiveIntegerValueResolutionBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataTimerResolution() BACnetConstructedDataTimerResolutionBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataTimerResolutionBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataTimerResolutionBuilder().(*_BACnetConstructedDataTimerResolutionBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataResolution() BACnetConstructedDataResolutionBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataResolutionBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataResolutionBuilder().(*_BACnetConstructedDataResolutionBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataRestartNotificationRecipients() BACnetConstructedDataRestartNotificationRecipientsBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataRestartNotificationRecipientsBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataRestartNotificationRecipientsBuilder().(*_BACnetConstructedDataRestartNotificationRecipientsBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataRestoreCompletionTime() BACnetConstructedDataRestoreCompletionTimeBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataRestoreCompletionTimeBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataRestoreCompletionTimeBuilder().(*_BACnetConstructedDataRestoreCompletionTimeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataRestorePreparationTime() BACnetConstructedDataRestorePreparationTimeBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataRestorePreparationTimeBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataRestorePreparationTimeBuilder().(*_BACnetConstructedDataRestorePreparationTimeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataRoutingTable() BACnetConstructedDataRoutingTableBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataRoutingTableBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataRoutingTableBuilder().(*_BACnetConstructedDataRoutingTableBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataScale() BACnetConstructedDataScaleBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataScaleBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataScaleBuilder().(*_BACnetConstructedDataScaleBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataScaleFactor() BACnetConstructedDataScaleFactorBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataScaleFactorBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataScaleFactorBuilder().(*_BACnetConstructedDataScaleFactorBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataScheduleDefault() BACnetConstructedDataScheduleDefaultBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataScheduleDefaultBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataScheduleDefaultBuilder().(*_BACnetConstructedDataScheduleDefaultBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataSecuredStatus() BACnetConstructedDataSecuredStatusBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataSecuredStatusBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataSecuredStatusBuilder().(*_BACnetConstructedDataSecuredStatusBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataSecurityPDUTimeout() BACnetConstructedDataSecurityPDUTimeoutBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataSecurityPDUTimeoutBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataSecurityPDUTimeoutBuilder().(*_BACnetConstructedDataSecurityPDUTimeoutBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataSecurityTimeWindow() BACnetConstructedDataSecurityTimeWindowBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataSecurityTimeWindowBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataSecurityTimeWindowBuilder().(*_BACnetConstructedDataSecurityTimeWindowBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataSegmentationSupported() BACnetConstructedDataSegmentationSupportedBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataSegmentationSupportedBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataSegmentationSupportedBuilder().(*_BACnetConstructedDataSegmentationSupportedBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataSerialNumber() BACnetConstructedDataSerialNumberBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataSerialNumberBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataSerialNumberBuilder().(*_BACnetConstructedDataSerialNumberBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataSetpoint() BACnetConstructedDataSetpointBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataSetpointBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataSetpointBuilder().(*_BACnetConstructedDataSetpointBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataSetpointReference() BACnetConstructedDataSetpointReferenceBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataSetpointReferenceBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataSetpointReferenceBuilder().(*_BACnetConstructedDataSetpointReferenceBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataSetting() BACnetConstructedDataSettingBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataSettingBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataSettingBuilder().(*_BACnetConstructedDataSettingBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataShedDuration() BACnetConstructedDataShedDurationBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataShedDurationBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataShedDurationBuilder().(*_BACnetConstructedDataShedDurationBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataShedLevelDescriptions() BACnetConstructedDataShedLevelDescriptionsBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataShedLevelDescriptionsBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataShedLevelDescriptionsBuilder().(*_BACnetConstructedDataShedLevelDescriptionsBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataShedLevels() BACnetConstructedDataShedLevelsBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataShedLevelsBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataShedLevelsBuilder().(*_BACnetConstructedDataShedLevelsBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataSilenced() BACnetConstructedDataSilencedBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataSilencedBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataSilencedBuilder().(*_BACnetConstructedDataSilencedBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataSlaveAddressBinding() BACnetConstructedDataSlaveAddressBindingBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataSlaveAddressBindingBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataSlaveAddressBindingBuilder().(*_BACnetConstructedDataSlaveAddressBindingBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataSlaveProxyEnable() BACnetConstructedDataSlaveProxyEnableBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataSlaveProxyEnableBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataSlaveProxyEnableBuilder().(*_BACnetConstructedDataSlaveProxyEnableBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataStartTime() BACnetConstructedDataStartTimeBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataStartTimeBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataStartTimeBuilder().(*_BACnetConstructedDataStartTimeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataStateChangeValues() BACnetConstructedDataStateChangeValuesBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataStateChangeValuesBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataStateChangeValuesBuilder().(*_BACnetConstructedDataStateChangeValuesBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataStateDescription() BACnetConstructedDataStateDescriptionBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataStateDescriptionBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataStateDescriptionBuilder().(*_BACnetConstructedDataStateDescriptionBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataStateText() BACnetConstructedDataStateTextBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataStateTextBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataStateTextBuilder().(*_BACnetConstructedDataStateTextBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataStatusFlags() BACnetConstructedDataStatusFlagsBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataStatusFlagsBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataStatusFlagsBuilder().(*_BACnetConstructedDataStatusFlagsBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataStopTime() BACnetConstructedDataStopTimeBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataStopTimeBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataStopTimeBuilder().(*_BACnetConstructedDataStopTimeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataStopWhenFull() BACnetConstructedDataStopWhenFullBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataStopWhenFullBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataStopWhenFullBuilder().(*_BACnetConstructedDataStopWhenFullBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataStrikeCount() BACnetConstructedDataStrikeCountBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataStrikeCountBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataStrikeCountBuilder().(*_BACnetConstructedDataStrikeCountBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataStructuredObjectList() BACnetConstructedDataStructuredObjectListBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataStructuredObjectListBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataStructuredObjectListBuilder().(*_BACnetConstructedDataStructuredObjectListBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataSubordinateAnnotations() BACnetConstructedDataSubordinateAnnotationsBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataSubordinateAnnotationsBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataSubordinateAnnotationsBuilder().(*_BACnetConstructedDataSubordinateAnnotationsBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataSubordinateList() BACnetConstructedDataSubordinateListBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataSubordinateListBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataSubordinateListBuilder().(*_BACnetConstructedDataSubordinateListBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataSubordinateNodeTypes() BACnetConstructedDataSubordinateNodeTypesBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataSubordinateNodeTypesBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataSubordinateNodeTypesBuilder().(*_BACnetConstructedDataSubordinateNodeTypesBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataSubordinateRelationships() BACnetConstructedDataSubordinateRelationshipsBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataSubordinateRelationshipsBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataSubordinateRelationshipsBuilder().(*_BACnetConstructedDataSubordinateRelationshipsBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataSubordinateTags() BACnetConstructedDataSubordinateTagsBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataSubordinateTagsBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataSubordinateTagsBuilder().(*_BACnetConstructedDataSubordinateTagsBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataSubscribedRecipients() BACnetConstructedDataSubscribedRecipientsBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataSubscribedRecipientsBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataSubscribedRecipientsBuilder().(*_BACnetConstructedDataSubscribedRecipientsBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataSupportedFormatClasses() BACnetConstructedDataSupportedFormatClassesBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataSupportedFormatClassesBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataSupportedFormatClassesBuilder().(*_BACnetConstructedDataSupportedFormatClassesBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataSupportedFormats() BACnetConstructedDataSupportedFormatsBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataSupportedFormatsBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataSupportedFormatsBuilder().(*_BACnetConstructedDataSupportedFormatsBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataSupportedSecurityAlgorithms() BACnetConstructedDataSupportedSecurityAlgorithmsBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataSupportedSecurityAlgorithmsBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataSupportedSecurityAlgorithmsBuilder().(*_BACnetConstructedDataSupportedSecurityAlgorithmsBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataSystemStatus() BACnetConstructedDataSystemStatusBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataSystemStatusBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataSystemStatusBuilder().(*_BACnetConstructedDataSystemStatusBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataTags() BACnetConstructedDataTagsBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataTagsBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataTagsBuilder().(*_BACnetConstructedDataTagsBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataThreatAuthority() BACnetConstructedDataThreatAuthorityBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataThreatAuthorityBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataThreatAuthorityBuilder().(*_BACnetConstructedDataThreatAuthorityBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataThreatLevel() BACnetConstructedDataThreatLevelBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataThreatLevelBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataThreatLevelBuilder().(*_BACnetConstructedDataThreatLevelBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataTimeDelay() BACnetConstructedDataTimeDelayBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataTimeDelayBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataTimeDelayBuilder().(*_BACnetConstructedDataTimeDelayBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataTimeDelayNormal() BACnetConstructedDataTimeDelayNormalBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataTimeDelayNormalBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataTimeDelayNormalBuilder().(*_BACnetConstructedDataTimeDelayNormalBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataTimeOfActiveTimeReset() BACnetConstructedDataTimeOfActiveTimeResetBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataTimeOfActiveTimeResetBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataTimeOfActiveTimeResetBuilder().(*_BACnetConstructedDataTimeOfActiveTimeResetBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataTimeOfDeviceRestart() BACnetConstructedDataTimeOfDeviceRestartBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataTimeOfDeviceRestartBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataTimeOfDeviceRestartBuilder().(*_BACnetConstructedDataTimeOfDeviceRestartBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataTimeOfStateCountReset() BACnetConstructedDataTimeOfStateCountResetBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataTimeOfStateCountResetBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataTimeOfStateCountResetBuilder().(*_BACnetConstructedDataTimeOfStateCountResetBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataTimeOfStrikeCountReset() BACnetConstructedDataTimeOfStrikeCountResetBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataTimeOfStrikeCountResetBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataTimeOfStrikeCountResetBuilder().(*_BACnetConstructedDataTimeOfStrikeCountResetBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataTimeSynchronizationInterval() BACnetConstructedDataTimeSynchronizationIntervalBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataTimeSynchronizationIntervalBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataTimeSynchronizationIntervalBuilder().(*_BACnetConstructedDataTimeSynchronizationIntervalBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataTimeSynchronizationRecipients() BACnetConstructedDataTimeSynchronizationRecipientsBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataTimeSynchronizationRecipientsBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataTimeSynchronizationRecipientsBuilder().(*_BACnetConstructedDataTimeSynchronizationRecipientsBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataTimerRunning() BACnetConstructedDataTimerRunningBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataTimerRunningBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataTimerRunningBuilder().(*_BACnetConstructedDataTimerRunningBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataTimerState() BACnetConstructedDataTimerStateBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataTimerStateBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataTimerStateBuilder().(*_BACnetConstructedDataTimerStateBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataTotalRecordCount() BACnetConstructedDataTotalRecordCountBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataTotalRecordCountBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataTotalRecordCountBuilder().(*_BACnetConstructedDataTotalRecordCountBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataTraceFlag() BACnetConstructedDataTraceFlagBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataTraceFlagBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataTraceFlagBuilder().(*_BACnetConstructedDataTraceFlagBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataLightingOutputTrackingValue() BACnetConstructedDataLightingOutputTrackingValueBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataLightingOutputTrackingValueBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataLightingOutputTrackingValueBuilder().(*_BACnetConstructedDataLightingOutputTrackingValueBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataTrackingValue() BACnetConstructedDataTrackingValueBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataTrackingValueBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataTrackingValueBuilder().(*_BACnetConstructedDataTrackingValueBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataTransactionNotificationClass() BACnetConstructedDataTransactionNotificationClassBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataTransactionNotificationClassBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataTransactionNotificationClassBuilder().(*_BACnetConstructedDataTransactionNotificationClassBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataTransition() BACnetConstructedDataTransitionBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataTransitionBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataTransitionBuilder().(*_BACnetConstructedDataTransitionBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataTrigger() BACnetConstructedDataTriggerBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataTriggerBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataTriggerBuilder().(*_BACnetConstructedDataTriggerBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataUnits() BACnetConstructedDataUnitsBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataUnitsBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataUnitsBuilder().(*_BACnetConstructedDataUnitsBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataUpdateInterval() BACnetConstructedDataUpdateIntervalBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataUpdateIntervalBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataUpdateIntervalBuilder().(*_BACnetConstructedDataUpdateIntervalBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataUpdateKeySetTimeout() BACnetConstructedDataUpdateKeySetTimeoutBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataUpdateKeySetTimeoutBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataUpdateKeySetTimeoutBuilder().(*_BACnetConstructedDataUpdateKeySetTimeoutBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataCredentialDataInputUpdateTime() BACnetConstructedDataCredentialDataInputUpdateTimeBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataCredentialDataInputUpdateTimeBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataCredentialDataInputUpdateTimeBuilder().(*_BACnetConstructedDataCredentialDataInputUpdateTimeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataUpdateTime() BACnetConstructedDataUpdateTimeBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataUpdateTimeBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataUpdateTimeBuilder().(*_BACnetConstructedDataUpdateTimeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataUserExternalIdentifier() BACnetConstructedDataUserExternalIdentifierBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataUserExternalIdentifierBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataUserExternalIdentifierBuilder().(*_BACnetConstructedDataUserExternalIdentifierBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataUserInformationReference() BACnetConstructedDataUserInformationReferenceBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataUserInformationReferenceBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataUserInformationReferenceBuilder().(*_BACnetConstructedDataUserInformationReferenceBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataUserName() BACnetConstructedDataUserNameBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataUserNameBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataUserNameBuilder().(*_BACnetConstructedDataUserNameBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataUserType() BACnetConstructedDataUserTypeBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataUserTypeBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataUserTypeBuilder().(*_BACnetConstructedDataUserTypeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataUsesRemaining() BACnetConstructedDataUsesRemainingBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataUsesRemainingBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataUsesRemainingBuilder().(*_BACnetConstructedDataUsesRemainingBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataUTCOffset() BACnetConstructedDataUTCOffsetBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataUTCOffsetBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataUTCOffsetBuilder().(*_BACnetConstructedDataUTCOffsetBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataUTCTimeSynchronizationRecipients() BACnetConstructedDataUTCTimeSynchronizationRecipientsBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataUTCTimeSynchronizationRecipientsBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataUTCTimeSynchronizationRecipientsBuilder().(*_BACnetConstructedDataUTCTimeSynchronizationRecipientsBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataValidSamples() BACnetConstructedDataValidSamplesBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataValidSamplesBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataValidSamplesBuilder().(*_BACnetConstructedDataValidSamplesBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataValueBeforeChange() BACnetConstructedDataValueBeforeChangeBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataValueBeforeChangeBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataValueBeforeChangeBuilder().(*_BACnetConstructedDataValueBeforeChangeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataValueChangeTime() BACnetConstructedDataValueChangeTimeBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataValueChangeTimeBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataValueChangeTimeBuilder().(*_BACnetConstructedDataValueChangeTimeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataValueSet() BACnetConstructedDataValueSetBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataValueSetBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataValueSetBuilder().(*_BACnetConstructedDataValueSetBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataValueSource() BACnetConstructedDataValueSourceBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataValueSourceBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataValueSourceBuilder().(*_BACnetConstructedDataValueSourceBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataValueSourceArray() BACnetConstructedDataValueSourceArrayBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataValueSourceArrayBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataValueSourceArrayBuilder().(*_BACnetConstructedDataValueSourceArrayBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataVarianceValue() BACnetConstructedDataVarianceValueBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataVarianceValueBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataVarianceValueBuilder().(*_BACnetConstructedDataVarianceValueBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataVendorIdentifier() BACnetConstructedDataVendorIdentifierBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataVendorIdentifierBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataVendorIdentifierBuilder().(*_BACnetConstructedDataVendorIdentifierBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataVendorName() BACnetConstructedDataVendorNameBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataVendorNameBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataVendorNameBuilder().(*_BACnetConstructedDataVendorNameBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataVerificationTime() BACnetConstructedDataVerificationTimeBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataVerificationTimeBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataVerificationTimeBuilder().(*_BACnetConstructedDataVerificationTimeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataVirtualMACAddressTable() BACnetConstructedDataVirtualMACAddressTableBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataVirtualMACAddressTableBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataVirtualMACAddressTableBuilder().(*_BACnetConstructedDataVirtualMACAddressTableBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataVTClassesSupported() BACnetConstructedDataVTClassesSupportedBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataVTClassesSupportedBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataVTClassesSupportedBuilder().(*_BACnetConstructedDataVTClassesSupportedBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataWeeklySchedule() BACnetConstructedDataWeeklyScheduleBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataWeeklyScheduleBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataWeeklyScheduleBuilder().(*_BACnetConstructedDataWeeklyScheduleBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataWindowInterval() BACnetConstructedDataWindowIntervalBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataWindowIntervalBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataWindowIntervalBuilder().(*_BACnetConstructedDataWindowIntervalBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataWindowSamples() BACnetConstructedDataWindowSamplesBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataWindowSamplesBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataWindowSamplesBuilder().(*_BACnetConstructedDataWindowSamplesBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataWriteStatus() BACnetConstructedDataWriteStatusBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataWriteStatusBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataWriteStatusBuilder().(*_BACnetConstructedDataWriteStatusBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataZoneFrom() BACnetConstructedDataZoneFromBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataZoneFromBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataZoneFromBuilder().(*_BACnetConstructedDataZoneFromBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataZoneMembers() BACnetConstructedDataZoneMembersBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataZoneMembersBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataZoneMembersBuilder().(*_BACnetConstructedDataZoneMembersBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataZoneTo() BACnetConstructedDataZoneToBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataZoneToBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataZoneToBuilder().(*_BACnetConstructedDataZoneToBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) AsBACnetConstructedDataUnspecified() BACnetConstructedDataUnspecifiedBuilder {
	if cb, ok := b.childBuilder.(BACnetConstructedDataUnspecifiedBuilder); ok {
		return cb
	}
	cb := NewBACnetConstructedDataUnspecifiedBuilder().(*_BACnetConstructedDataUnspecifiedBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetConstructedDataBuilder) Build() (BACnetConstructedData, error) {
	v, err := b.PartialBuild()
	if err != nil {
		return nil, errors.Wrap(err, "error occurred during partial build")
	}
	if b.childBuilder == nil {
		return nil, errors.New("no child builder present")
	}
	b.childBuilder.setParent(v)
	return b.childBuilder.buildForBACnetConstructedData()
}

func (b *_BACnetConstructedDataBuilder) MustBuild() BACnetConstructedData {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetConstructedDataBuilder) DeepCopy() any {
	_copy := b.CreateBACnetConstructedDataBuilder().(*_BACnetConstructedDataBuilder)
	_copy.childBuilder = b.childBuilder.DeepCopy().(_BACnetConstructedDataChildBuilder)
	_copy.childBuilder.setParent(_copy)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateBACnetConstructedDataBuilder creates a BACnetConstructedDataBuilder
func (b *_BACnetConstructedData) CreateBACnetConstructedDataBuilder() BACnetConstructedDataBuilder {
	if b == nil {
		return NewBACnetConstructedDataBuilder()
	}
	return &_BACnetConstructedDataBuilder{_BACnetConstructedData: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetConstructedData) GetOpeningTag() BACnetOpeningTag {
	return m.OpeningTag
}

func (m *_BACnetConstructedData) GetPeekedTagHeader() BACnetTagHeader {
	return m.PeekedTagHeader
}

func (m *_BACnetConstructedData) GetClosingTag() BACnetClosingTag {
	return m.ClosingTag
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for virtual fields.
///////////////////////

func (pm *_BACnetConstructedData) GetPeekedTagNumber() uint8 {
	m := pm._SubType
	ctx := context.Background()
	_ = ctx
	return uint8(m.GetPeekedTagHeader().GetActualTagNumber())
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetConstructedData(structType any) BACnetConstructedData {
	if casted, ok := structType.(BACnetConstructedData); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetConstructedData); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetConstructedData) GetTypeName() string {
	return "BACnetConstructedData"
}

func (m *_BACnetConstructedData) getLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(0)

	// Simple field (openingTag)
	lengthInBits += m.OpeningTag.GetLengthInBits(ctx)

	// A virtual field doesn't have any in- or output.

	// Simple field (closingTag)
	lengthInBits += m.ClosingTag.GetLengthInBits(ctx)

	return lengthInBits
}

func (m *_BACnetConstructedData) GetLengthInBits(ctx context.Context) uint16 {
	return m._SubType.GetLengthInBits(ctx)
}

func (m *_BACnetConstructedData) GetLengthInBytes(ctx context.Context) uint16 {
	return m._SubType.GetLengthInBits(ctx) / 8
}

func BACnetConstructedDataParse[T BACnetConstructedData](ctx context.Context, theBytes []byte, tagNumber uint8, objectTypeArgument BACnetObjectType, propertyIdentifierArgument BACnetPropertyIdentifier, arrayIndexArgument BACnetTagPayloadUnsignedInteger) (T, error) {
	return BACnetConstructedDataParseWithBuffer[T](ctx, utils.NewReadBufferByteBased(theBytes), tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
}

func BACnetConstructedDataParseWithBufferProducer[T BACnetConstructedData](tagNumber uint8, objectTypeArgument BACnetObjectType, propertyIdentifierArgument BACnetPropertyIdentifier, arrayIndexArgument BACnetTagPayloadUnsignedInteger) func(ctx context.Context, readBuffer utils.ReadBuffer) (T, error) {
	return func(ctx context.Context, readBuffer utils.ReadBuffer) (T, error) {
		v, err := BACnetConstructedDataParseWithBuffer[T](ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
		if err != nil {
			var zero T
			return zero, err
		}
		return v, nil
	}
}

func BACnetConstructedDataParseWithBuffer[T BACnetConstructedData](ctx context.Context, readBuffer utils.ReadBuffer, tagNumber uint8, objectTypeArgument BACnetObjectType, propertyIdentifierArgument BACnetPropertyIdentifier, arrayIndexArgument BACnetTagPayloadUnsignedInteger) (T, error) {
	v, err := (&_BACnetConstructedData{TagNumber: tagNumber, ArrayIndexArgument: arrayIndexArgument}).parse(ctx, readBuffer, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	if err != nil {
		var zero T
		return zero, err
	}
	vc, ok := v.(T)
	if !ok {
		var zero T
		return zero, errors.Errorf("Unexpected type %T. Expected type %T", v, *new(T))
	}
	return vc, nil
}

func (m *_BACnetConstructedData) parse(ctx context.Context, readBuffer utils.ReadBuffer, tagNumber uint8, objectTypeArgument BACnetObjectType, propertyIdentifierArgument BACnetPropertyIdentifier, arrayIndexArgument BACnetTagPayloadUnsignedInteger) (__bACnetConstructedData BACnetConstructedData, err error) {
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetConstructedData"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetConstructedData")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	openingTag, err := ReadSimpleField[BACnetOpeningTag](ctx, "openingTag", ReadComplex[BACnetOpeningTag](BACnetOpeningTagParseWithBufferProducer((uint8)(tagNumber)), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'openingTag' field"))
	}
	m.OpeningTag = openingTag

	peekedTagHeader, err := ReadPeekField[BACnetTagHeader](ctx, "peekedTagHeader", ReadComplex[BACnetTagHeader](BACnetTagHeaderParseWithBuffer, readBuffer), 0)
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'peekedTagHeader' field"))
	}
	m.PeekedTagHeader = peekedTagHeader

	peekedTagNumber, err := ReadVirtualField[uint8](ctx, "peekedTagNumber", (*uint8)(nil), peekedTagHeader.GetActualTagNumber())
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'peekedTagNumber' field"))
	}
	_ = peekedTagNumber

	// Switch Field (Depending on the discriminator values, passes the instantiation to a sub-type)
	var _child BACnetConstructedData
	switch {
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_ABSENTEE_LIMIT && peekedTagNumber == uint8(2): // BACnetConstructedDataAbsenteeLimit
		if _child, err = new(_BACnetConstructedDataAbsenteeLimit).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataAbsenteeLimit for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_ACCEPTED_MODES: // BACnetConstructedDataAcceptedModes
		if _child, err = new(_BACnetConstructedDataAcceptedModes).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataAcceptedModes for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_ACCESS_ALARM_EVENTS && peekedTagNumber == uint8(9): // BACnetConstructedDataAccessAlarmEvents
		if _child, err = new(_BACnetConstructedDataAccessAlarmEvents).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataAccessAlarmEvents for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_ACCESS_DOORS: // BACnetConstructedDataAccessDoors
		if _child, err = new(_BACnetConstructedDataAccessDoors).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataAccessDoors for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_ACCESS_EVENT && peekedTagNumber == uint8(9): // BACnetConstructedDataAccessEvent
		if _child, err = new(_BACnetConstructedDataAccessEvent).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataAccessEvent for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_ACCESS_EVENT_AUTHENTICATION_FACTOR: // BACnetConstructedDataAccessEventAuthenticationFactor
		if _child, err = new(_BACnetConstructedDataAccessEventAuthenticationFactor).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataAccessEventAuthenticationFactor for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_ACCESS_EVENT_CREDENTIAL: // BACnetConstructedDataAccessEventCredential
		if _child, err = new(_BACnetConstructedDataAccessEventCredential).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataAccessEventCredential for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_ACCESS_EVENT_TAG && peekedTagNumber == uint8(2): // BACnetConstructedDataAccessEventTag
		if _child, err = new(_BACnetConstructedDataAccessEventTag).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataAccessEventTag for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_ACCESS_EVENT_TIME: // BACnetConstructedDataAccessEventTime
		if _child, err = new(_BACnetConstructedDataAccessEventTime).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataAccessEventTime for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_ACCESS_TRANSACTION_EVENTS && peekedTagNumber == uint8(9): // BACnetConstructedDataAccessTransactionEvents
		if _child, err = new(_BACnetConstructedDataAccessTransactionEvents).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataAccessTransactionEvents for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_ACCOMPANIMENT: // BACnetConstructedDataAccompaniment
		if _child, err = new(_BACnetConstructedDataAccompaniment).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataAccompaniment for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_ACCOMPANIMENT_TIME && peekedTagNumber == uint8(2): // BACnetConstructedDataAccompanimentTime
		if _child, err = new(_BACnetConstructedDataAccompanimentTime).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataAccompanimentTime for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_ACK_REQUIRED && peekedTagNumber == uint8(9): // BACnetConstructedDataAckRequired
		if _child, err = new(_BACnetConstructedDataAckRequired).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataAckRequired for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_ACKED_TRANSITIONS && peekedTagNumber == uint8(9): // BACnetConstructedDataAckedTransitions
		if _child, err = new(_BACnetConstructedDataAckedTransitions).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataAckedTransitions for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_LOOP && propertyIdentifierArgument == BACnetPropertyIdentifier_ACTION && peekedTagNumber == uint8(9): // BACnetConstructedDataLoopAction
		if _child, err = new(_BACnetConstructedDataLoopAction).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataLoopAction for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_COMMAND && propertyIdentifierArgument == BACnetPropertyIdentifier_ACTION: // BACnetConstructedDataCommandAction
		if _child, err = new(_BACnetConstructedDataCommandAction).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataCommandAction for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_ACTION: // BACnetConstructedDataAction
		if _child, err = new(_BACnetConstructedDataAction).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataAction for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_ACTION_TEXT && peekedTagNumber == uint8(7): // BACnetConstructedDataActionText
		if _child, err = new(_BACnetConstructedDataActionText).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataActionText for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_ACTIVATION_TIME: // BACnetConstructedDataActivationTime
		if _child, err = new(_BACnetConstructedDataActivationTime).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataActivationTime for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_ACTIVE_AUTHENTICATION_POLICY && peekedTagNumber == uint8(2): // BACnetConstructedDataActiveAuthenticationPolicy
		if _child, err = new(_BACnetConstructedDataActiveAuthenticationPolicy).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataActiveAuthenticationPolicy for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_ACTIVE_COV_MULTIPLE_SUBSCRIPTIONS: // BACnetConstructedDataActiveCOVMultipleSubscriptions
		if _child, err = new(_BACnetConstructedDataActiveCOVMultipleSubscriptions).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataActiveCOVMultipleSubscriptions for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_ACTIVE_COV_SUBSCRIPTIONS: // BACnetConstructedDataActiveCOVSubscriptions
		if _child, err = new(_BACnetConstructedDataActiveCOVSubscriptions).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataActiveCOVSubscriptions for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_ACTIVE_TEXT && peekedTagNumber == uint8(7): // BACnetConstructedDataActiveText
		if _child, err = new(_BACnetConstructedDataActiveText).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataActiveText for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_ACTIVE_VT_SESSIONS: // BACnetConstructedDataActiveVTSessions
		if _child, err = new(_BACnetConstructedDataActiveVTSessions).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataActiveVTSessions for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_ACTUAL_SHED_LEVEL: // BACnetConstructedDataActualShedLevel
		if _child, err = new(_BACnetConstructedDataActualShedLevel).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataActualShedLevel for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_ACCESS_ZONE && propertyIdentifierArgument == BACnetPropertyIdentifier_ADJUST_VALUE && peekedTagNumber == uint8(3): // BACnetConstructedDataAccessZoneAdjustValue
		if _child, err = new(_BACnetConstructedDataAccessZoneAdjustValue).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataAccessZoneAdjustValue for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_PULSE_CONVERTER && propertyIdentifierArgument == BACnetPropertyIdentifier_ADJUST_VALUE && peekedTagNumber == uint8(4): // BACnetConstructedDataPulseConverterAdjustValue
		if _child, err = new(_BACnetConstructedDataPulseConverterAdjustValue).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataPulseConverterAdjustValue for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_ADJUST_VALUE && peekedTagNumber == uint8(3): // BACnetConstructedDataAdjustValue
		if _child, err = new(_BACnetConstructedDataAdjustValue).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataAdjustValue for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_ALARM_VALUE && peekedTagNumber == uint8(9): // BACnetConstructedDataAlarmValue
		if _child, err = new(_BACnetConstructedDataAlarmValue).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataAlarmValue for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_ACCESS_DOOR && propertyIdentifierArgument == BACnetPropertyIdentifier_ALARM_VALUES: // BACnetConstructedDataAccessDoorAlarmValues
		if _child, err = new(_BACnetConstructedDataAccessDoorAlarmValues).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataAccessDoorAlarmValues for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_ACCESS_ZONE && propertyIdentifierArgument == BACnetPropertyIdentifier_ALARM_VALUES: // BACnetConstructedDataAccessZoneAlarmValues
		if _child, err = new(_BACnetConstructedDataAccessZoneAlarmValues).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataAccessZoneAlarmValues for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_BITSTRING_VALUE && propertyIdentifierArgument == BACnetPropertyIdentifier_ALARM_VALUES && peekedTagNumber == uint8(8): // BACnetConstructedDataBitStringValueAlarmValues
		if _child, err = new(_BACnetConstructedDataBitStringValueAlarmValues).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataBitStringValueAlarmValues for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_CHARACTERSTRING_VALUE && propertyIdentifierArgument == BACnetPropertyIdentifier_ALARM_VALUES: // BACnetConstructedDataCharacterStringValueAlarmValues
		if _child, err = new(_BACnetConstructedDataCharacterStringValueAlarmValues).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataCharacterStringValueAlarmValues for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_LIFE_SAFETY_POINT && propertyIdentifierArgument == BACnetPropertyIdentifier_ALARM_VALUES: // BACnetConstructedDataLifeSafetyPointAlarmValues
		if _child, err = new(_BACnetConstructedDataLifeSafetyPointAlarmValues).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataLifeSafetyPointAlarmValues for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_LIFE_SAFETY_ZONE && propertyIdentifierArgument == BACnetPropertyIdentifier_ALARM_VALUES: // BACnetConstructedDataLifeSafetyZoneAlarmValues
		if _child, err = new(_BACnetConstructedDataLifeSafetyZoneAlarmValues).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataLifeSafetyZoneAlarmValues for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_MULTI_STATE_INPUT && propertyIdentifierArgument == BACnetPropertyIdentifier_ALARM_VALUES && peekedTagNumber == uint8(2): // BACnetConstructedDataMultiStateInputAlarmValues
		if _child, err = new(_BACnetConstructedDataMultiStateInputAlarmValues).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataMultiStateInputAlarmValues for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_MULTI_STATE_VALUE && propertyIdentifierArgument == BACnetPropertyIdentifier_ALARM_VALUES && peekedTagNumber == uint8(2): // BACnetConstructedDataMultiStateValueAlarmValues
		if _child, err = new(_BACnetConstructedDataMultiStateValueAlarmValues).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataMultiStateValueAlarmValues for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_TIMER && propertyIdentifierArgument == BACnetPropertyIdentifier_ALARM_VALUES: // BACnetConstructedDataTimerAlarmValues
		if _child, err = new(_BACnetConstructedDataTimerAlarmValues).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataTimerAlarmValues for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_ALARM_VALUES: // BACnetConstructedDataAlarmValues
		if _child, err = new(_BACnetConstructedDataAlarmValues).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataAlarmValues for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_ALIGN_INTERVALS && peekedTagNumber == uint8(1): // BACnetConstructedDataAlignIntervals
		if _child, err = new(_BACnetConstructedDataAlignIntervals).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataAlignIntervals for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_ACCESS_CREDENTIAL && propertyIdentifierArgument == BACnetPropertyIdentifier_ALL: // BACnetConstructedDataAccessCredentialAll
		if _child, err = new(_BACnetConstructedDataAccessCredentialAll).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataAccessCredentialAll for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_ACCESS_DOOR && propertyIdentifierArgument == BACnetPropertyIdentifier_ALL: // BACnetConstructedDataAccessDoorAll
		if _child, err = new(_BACnetConstructedDataAccessDoorAll).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataAccessDoorAll for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_ACCESS_POINT && propertyIdentifierArgument == BACnetPropertyIdentifier_ALL: // BACnetConstructedDataAccessPointAll
		if _child, err = new(_BACnetConstructedDataAccessPointAll).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataAccessPointAll for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_ACCESS_RIGHTS && propertyIdentifierArgument == BACnetPropertyIdentifier_ALL: // BACnetConstructedDataAccessRightsAll
		if _child, err = new(_BACnetConstructedDataAccessRightsAll).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataAccessRightsAll for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_ACCESS_USER && propertyIdentifierArgument == BACnetPropertyIdentifier_ALL: // BACnetConstructedDataAccessUserAll
		if _child, err = new(_BACnetConstructedDataAccessUserAll).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataAccessUserAll for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_ACCESS_ZONE && propertyIdentifierArgument == BACnetPropertyIdentifier_ALL: // BACnetConstructedDataAccessZoneAll
		if _child, err = new(_BACnetConstructedDataAccessZoneAll).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataAccessZoneAll for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_ACCUMULATOR && propertyIdentifierArgument == BACnetPropertyIdentifier_ALL: // BACnetConstructedDataAccumulatorAll
		if _child, err = new(_BACnetConstructedDataAccumulatorAll).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataAccumulatorAll for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_ALERT_ENROLLMENT && propertyIdentifierArgument == BACnetPropertyIdentifier_ALL: // BACnetConstructedDataAlertEnrollmentAll
		if _child, err = new(_BACnetConstructedDataAlertEnrollmentAll).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataAlertEnrollmentAll for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_ANALOG_INPUT && propertyIdentifierArgument == BACnetPropertyIdentifier_ALL: // BACnetConstructedDataAnalogInputAll
		if _child, err = new(_BACnetConstructedDataAnalogInputAll).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataAnalogInputAll for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_ANALOG_OUTPUT && propertyIdentifierArgument == BACnetPropertyIdentifier_ALL: // BACnetConstructedDataAnalogOutputAll
		if _child, err = new(_BACnetConstructedDataAnalogOutputAll).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataAnalogOutputAll for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_ANALOG_VALUE && propertyIdentifierArgument == BACnetPropertyIdentifier_ALL: // BACnetConstructedDataAnalogValueAll
		if _child, err = new(_BACnetConstructedDataAnalogValueAll).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataAnalogValueAll for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_AVERAGING && propertyIdentifierArgument == BACnetPropertyIdentifier_ALL: // BACnetConstructedDataAveragingAll
		if _child, err = new(_BACnetConstructedDataAveragingAll).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataAveragingAll for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_BINARY_INPUT && propertyIdentifierArgument == BACnetPropertyIdentifier_ALL: // BACnetConstructedDataBinaryInputAll
		if _child, err = new(_BACnetConstructedDataBinaryInputAll).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataBinaryInputAll for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_BINARY_LIGHTING_OUTPUT && propertyIdentifierArgument == BACnetPropertyIdentifier_ALL: // BACnetConstructedDataBinaryLightingOutputAll
		if _child, err = new(_BACnetConstructedDataBinaryLightingOutputAll).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataBinaryLightingOutputAll for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_BINARY_OUTPUT && propertyIdentifierArgument == BACnetPropertyIdentifier_ALL: // BACnetConstructedDataBinaryOutputAll
		if _child, err = new(_BACnetConstructedDataBinaryOutputAll).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataBinaryOutputAll for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_BINARY_VALUE && propertyIdentifierArgument == BACnetPropertyIdentifier_ALL: // BACnetConstructedDataBinaryValueAll
		if _child, err = new(_BACnetConstructedDataBinaryValueAll).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataBinaryValueAll for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_BITSTRING_VALUE && propertyIdentifierArgument == BACnetPropertyIdentifier_ALL: // BACnetConstructedDataBitstringValueAll
		if _child, err = new(_BACnetConstructedDataBitstringValueAll).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataBitstringValueAll for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_CALENDAR && propertyIdentifierArgument == BACnetPropertyIdentifier_ALL: // BACnetConstructedDataCalendarAll
		if _child, err = new(_BACnetConstructedDataCalendarAll).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataCalendarAll for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_CHANNEL && propertyIdentifierArgument == BACnetPropertyIdentifier_ALL: // BACnetConstructedDataChannelAll
		if _child, err = new(_BACnetConstructedDataChannelAll).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataChannelAll for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_CHARACTERSTRING_VALUE && propertyIdentifierArgument == BACnetPropertyIdentifier_ALL: // BACnetConstructedDataCharacterstringValueAll
		if _child, err = new(_BACnetConstructedDataCharacterstringValueAll).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataCharacterstringValueAll for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_COMMAND && propertyIdentifierArgument == BACnetPropertyIdentifier_ALL: // BACnetConstructedDataCommandAll
		if _child, err = new(_BACnetConstructedDataCommandAll).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataCommandAll for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_CREDENTIAL_DATA_INPUT && propertyIdentifierArgument == BACnetPropertyIdentifier_ALL: // BACnetConstructedDataCredentialDataInputAll
		if _child, err = new(_BACnetConstructedDataCredentialDataInputAll).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataCredentialDataInputAll for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_DATEPATTERN_VALUE && propertyIdentifierArgument == BACnetPropertyIdentifier_ALL: // BACnetConstructedDataDatepatternValueAll
		if _child, err = new(_BACnetConstructedDataDatepatternValueAll).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataDatepatternValueAll for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_DATE_VALUE && propertyIdentifierArgument == BACnetPropertyIdentifier_ALL: // BACnetConstructedDataDateValueAll
		if _child, err = new(_BACnetConstructedDataDateValueAll).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataDateValueAll for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_DATETIMEPATTERN_VALUE && propertyIdentifierArgument == BACnetPropertyIdentifier_ALL: // BACnetConstructedDataDatetimepatternValueAll
		if _child, err = new(_BACnetConstructedDataDatetimepatternValueAll).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataDatetimepatternValueAll for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_DATETIME_VALUE && propertyIdentifierArgument == BACnetPropertyIdentifier_ALL: // BACnetConstructedDataDatetimeValueAll
		if _child, err = new(_BACnetConstructedDataDatetimeValueAll).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataDatetimeValueAll for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_DEVICE && propertyIdentifierArgument == BACnetPropertyIdentifier_ALL: // BACnetConstructedDataDeviceAll
		if _child, err = new(_BACnetConstructedDataDeviceAll).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataDeviceAll for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_ELEVATOR_GROUP && propertyIdentifierArgument == BACnetPropertyIdentifier_ALL: // BACnetConstructedDataElevatorGroupAll
		if _child, err = new(_BACnetConstructedDataElevatorGroupAll).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataElevatorGroupAll for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_ESCALATOR && propertyIdentifierArgument == BACnetPropertyIdentifier_ALL: // BACnetConstructedDataEscalatorAll
		if _child, err = new(_BACnetConstructedDataEscalatorAll).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataEscalatorAll for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_EVENT_ENROLLMENT && propertyIdentifierArgument == BACnetPropertyIdentifier_ALL: // BACnetConstructedDataEventEnrollmentAll
		if _child, err = new(_BACnetConstructedDataEventEnrollmentAll).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataEventEnrollmentAll for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_EVENT_LOG && propertyIdentifierArgument == BACnetPropertyIdentifier_ALL: // BACnetConstructedDataEventLogAll
		if _child, err = new(_BACnetConstructedDataEventLogAll).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataEventLogAll for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_FILE && propertyIdentifierArgument == BACnetPropertyIdentifier_ALL: // BACnetConstructedDataFileAll
		if _child, err = new(_BACnetConstructedDataFileAll).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataFileAll for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_GLOBAL_GROUP && propertyIdentifierArgument == BACnetPropertyIdentifier_ALL: // BACnetConstructedDataGlobalGroupAll
		if _child, err = new(_BACnetConstructedDataGlobalGroupAll).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataGlobalGroupAll for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_GROUP && propertyIdentifierArgument == BACnetPropertyIdentifier_ALL: // BACnetConstructedDataGroupAll
		if _child, err = new(_BACnetConstructedDataGroupAll).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataGroupAll for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_INTEGER_VALUE && propertyIdentifierArgument == BACnetPropertyIdentifier_ALL: // BACnetConstructedDataIntegerValueAll
		if _child, err = new(_BACnetConstructedDataIntegerValueAll).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataIntegerValueAll for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_LARGE_ANALOG_VALUE && propertyIdentifierArgument == BACnetPropertyIdentifier_ALL: // BACnetConstructedDataLargeAnalogValueAll
		if _child, err = new(_BACnetConstructedDataLargeAnalogValueAll).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataLargeAnalogValueAll for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_LIFE_SAFETY_POINT && propertyIdentifierArgument == BACnetPropertyIdentifier_ALL: // BACnetConstructedDataLifeSafetyPointAll
		if _child, err = new(_BACnetConstructedDataLifeSafetyPointAll).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataLifeSafetyPointAll for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_LIFE_SAFETY_ZONE && propertyIdentifierArgument == BACnetPropertyIdentifier_ALL: // BACnetConstructedDataLifeSafetyZoneAll
		if _child, err = new(_BACnetConstructedDataLifeSafetyZoneAll).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataLifeSafetyZoneAll for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_LIFT && propertyIdentifierArgument == BACnetPropertyIdentifier_ALL: // BACnetConstructedDataLiftAll
		if _child, err = new(_BACnetConstructedDataLiftAll).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataLiftAll for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_LIGHTING_OUTPUT && propertyIdentifierArgument == BACnetPropertyIdentifier_ALL: // BACnetConstructedDataLightingOutputAll
		if _child, err = new(_BACnetConstructedDataLightingOutputAll).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataLightingOutputAll for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_LOAD_CONTROL && propertyIdentifierArgument == BACnetPropertyIdentifier_ALL: // BACnetConstructedDataLoadControlAll
		if _child, err = new(_BACnetConstructedDataLoadControlAll).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataLoadControlAll for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_LOOP && propertyIdentifierArgument == BACnetPropertyIdentifier_ALL: // BACnetConstructedDataLoopAll
		if _child, err = new(_BACnetConstructedDataLoopAll).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataLoopAll for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_MULTI_STATE_INPUT && propertyIdentifierArgument == BACnetPropertyIdentifier_ALL: // BACnetConstructedDataMultiStateInputAll
		if _child, err = new(_BACnetConstructedDataMultiStateInputAll).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataMultiStateInputAll for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_MULTI_STATE_OUTPUT && propertyIdentifierArgument == BACnetPropertyIdentifier_ALL: // BACnetConstructedDataMultiStateOutputAll
		if _child, err = new(_BACnetConstructedDataMultiStateOutputAll).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataMultiStateOutputAll for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_MULTI_STATE_VALUE && propertyIdentifierArgument == BACnetPropertyIdentifier_ALL: // BACnetConstructedDataMultiStateValueAll
		if _child, err = new(_BACnetConstructedDataMultiStateValueAll).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataMultiStateValueAll for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_NETWORK_PORT && propertyIdentifierArgument == BACnetPropertyIdentifier_ALL: // BACnetConstructedDataNetworkPortAll
		if _child, err = new(_BACnetConstructedDataNetworkPortAll).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataNetworkPortAll for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_NETWORK_SECURITY && propertyIdentifierArgument == BACnetPropertyIdentifier_ALL: // BACnetConstructedDataNetworkSecurityAll
		if _child, err = new(_BACnetConstructedDataNetworkSecurityAll).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataNetworkSecurityAll for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_NOTIFICATION_CLASS && propertyIdentifierArgument == BACnetPropertyIdentifier_ALL: // BACnetConstructedDataNotificationClassAll
		if _child, err = new(_BACnetConstructedDataNotificationClassAll).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataNotificationClassAll for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_NOTIFICATION_FORWARDER && propertyIdentifierArgument == BACnetPropertyIdentifier_ALL: // BACnetConstructedDataNotificationForwarderAll
		if _child, err = new(_BACnetConstructedDataNotificationForwarderAll).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataNotificationForwarderAll for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_OCTETSTRING_VALUE && propertyIdentifierArgument == BACnetPropertyIdentifier_ALL: // BACnetConstructedDataOctetstringValueAll
		if _child, err = new(_BACnetConstructedDataOctetstringValueAll).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataOctetstringValueAll for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_POSITIVE_INTEGER_VALUE && propertyIdentifierArgument == BACnetPropertyIdentifier_ALL: // BACnetConstructedDataPositiveIntegerValueAll
		if _child, err = new(_BACnetConstructedDataPositiveIntegerValueAll).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataPositiveIntegerValueAll for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_PROGRAM && propertyIdentifierArgument == BACnetPropertyIdentifier_ALL: // BACnetConstructedDataProgramAll
		if _child, err = new(_BACnetConstructedDataProgramAll).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataProgramAll for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_PULSE_CONVERTER && propertyIdentifierArgument == BACnetPropertyIdentifier_ALL: // BACnetConstructedDataPulseConverterAll
		if _child, err = new(_BACnetConstructedDataPulseConverterAll).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataPulseConverterAll for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_SCHEDULE && propertyIdentifierArgument == BACnetPropertyIdentifier_ALL: // BACnetConstructedDataScheduleAll
		if _child, err = new(_BACnetConstructedDataScheduleAll).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataScheduleAll for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_STRUCTURED_VIEW && propertyIdentifierArgument == BACnetPropertyIdentifier_ALL: // BACnetConstructedDataStructuredViewAll
		if _child, err = new(_BACnetConstructedDataStructuredViewAll).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataStructuredViewAll for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_TIMEPATTERN_VALUE && propertyIdentifierArgument == BACnetPropertyIdentifier_ALL: // BACnetConstructedDataTimepatternValueAll
		if _child, err = new(_BACnetConstructedDataTimepatternValueAll).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataTimepatternValueAll for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_TIME_VALUE && propertyIdentifierArgument == BACnetPropertyIdentifier_ALL: // BACnetConstructedDataTimeValueAll
		if _child, err = new(_BACnetConstructedDataTimeValueAll).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataTimeValueAll for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_TIMER && propertyIdentifierArgument == BACnetPropertyIdentifier_ALL: // BACnetConstructedDataTimerAll
		if _child, err = new(_BACnetConstructedDataTimerAll).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataTimerAll for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_TREND_LOG && propertyIdentifierArgument == BACnetPropertyIdentifier_ALL: // BACnetConstructedDataTrendLogAll
		if _child, err = new(_BACnetConstructedDataTrendLogAll).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataTrendLogAll for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_TREND_LOG_MULTIPLE && propertyIdentifierArgument == BACnetPropertyIdentifier_ALL: // BACnetConstructedDataTrendLogMultipleAll
		if _child, err = new(_BACnetConstructedDataTrendLogMultipleAll).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataTrendLogMultipleAll for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_ALL_WRITES_SUCCESSFUL && peekedTagNumber == uint8(1): // BACnetConstructedDataAllWritesSuccessful
		if _child, err = new(_BACnetConstructedDataAllWritesSuccessful).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataAllWritesSuccessful for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_ALLOW_GROUP_DELAY_INHIBIT && peekedTagNumber == uint8(1): // BACnetConstructedDataAllowGroupDelayInhibit
		if _child, err = new(_BACnetConstructedDataAllowGroupDelayInhibit).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataAllowGroupDelayInhibit for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_APDU_LENGTH && peekedTagNumber == uint8(2): // BACnetConstructedDataAPDULength
		if _child, err = new(_BACnetConstructedDataAPDULength).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataAPDULength for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_APDU_SEGMENT_TIMEOUT && peekedTagNumber == uint8(2): // BACnetConstructedDataAPDUSegmentTimeout
		if _child, err = new(_BACnetConstructedDataAPDUSegmentTimeout).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataAPDUSegmentTimeout for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_APDU_TIMEOUT && peekedTagNumber == uint8(2): // BACnetConstructedDataAPDUTimeout
		if _child, err = new(_BACnetConstructedDataAPDUTimeout).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataAPDUTimeout for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_APPLICATION_SOFTWARE_VERSION && peekedTagNumber == uint8(7): // BACnetConstructedDataApplicationSoftwareVersion
		if _child, err = new(_BACnetConstructedDataApplicationSoftwareVersion).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataApplicationSoftwareVersion for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_ARCHIVE && peekedTagNumber == uint8(1): // BACnetConstructedDataArchive
		if _child, err = new(_BACnetConstructedDataArchive).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataArchive for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_ASSIGNED_ACCESS_RIGHTS: // BACnetConstructedDataAssignedAccessRights
		if _child, err = new(_BACnetConstructedDataAssignedAccessRights).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataAssignedAccessRights for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_ASSIGNED_LANDING_CALLS: // BACnetConstructedDataAssignedLandingCalls
		if _child, err = new(_BACnetConstructedDataAssignedLandingCalls).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataAssignedLandingCalls for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_ATTEMPTED_SAMPLES && peekedTagNumber == uint8(2): // BACnetConstructedDataAttemptedSamples
		if _child, err = new(_BACnetConstructedDataAttemptedSamples).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataAttemptedSamples for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_AUTHENTICATION_FACTORS: // BACnetConstructedDataAuthenticationFactors
		if _child, err = new(_BACnetConstructedDataAuthenticationFactors).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataAuthenticationFactors for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_AUTHENTICATION_POLICY_LIST: // BACnetConstructedDataAuthenticationPolicyList
		if _child, err = new(_BACnetConstructedDataAuthenticationPolicyList).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataAuthenticationPolicyList for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_AUTHENTICATION_POLICY_NAMES && peekedTagNumber == uint8(7): // BACnetConstructedDataAuthenticationPolicyNames
		if _child, err = new(_BACnetConstructedDataAuthenticationPolicyNames).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataAuthenticationPolicyNames for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_AUTHENTICATION_STATUS && peekedTagNumber == uint8(9): // BACnetConstructedDataAuthenticationStatus
		if _child, err = new(_BACnetConstructedDataAuthenticationStatus).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataAuthenticationStatus for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_AUTHORIZATION_EXEMPTIONS && peekedTagNumber == uint8(9): // BACnetConstructedDataAuthorizationExemptions
		if _child, err = new(_BACnetConstructedDataAuthorizationExemptions).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataAuthorizationExemptions for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_AUTHORIZATION_MODE && peekedTagNumber == uint8(9): // BACnetConstructedDataAuthorizationMode
		if _child, err = new(_BACnetConstructedDataAuthorizationMode).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataAuthorizationMode for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_AUTO_SLAVE_DISCOVERY && peekedTagNumber == uint8(1): // BACnetConstructedDataAutoSlaveDiscovery
		if _child, err = new(_BACnetConstructedDataAutoSlaveDiscovery).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataAutoSlaveDiscovery for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_AVERAGE_VALUE && peekedTagNumber == uint8(4): // BACnetConstructedDataAverageValue
		if _child, err = new(_BACnetConstructedDataAverageValue).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataAverageValue for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_BACKUP_AND_RESTORE_STATE && peekedTagNumber == uint8(9): // BACnetConstructedDataBackupAndRestoreState
		if _child, err = new(_BACnetConstructedDataBackupAndRestoreState).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataBackupAndRestoreState for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_BACKUP_FAILURE_TIMEOUT && peekedTagNumber == uint8(2): // BACnetConstructedDataBackupFailureTimeout
		if _child, err = new(_BACnetConstructedDataBackupFailureTimeout).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataBackupFailureTimeout for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_BACKUP_PREPARATION_TIME && peekedTagNumber == uint8(2): // BACnetConstructedDataBackupPreparationTime
		if _child, err = new(_BACnetConstructedDataBackupPreparationTime).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataBackupPreparationTime for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_BACNET_IP_GLOBAL_ADDRESS: // BACnetConstructedDataBACnetIPGlobalAddress
		if _child, err = new(_BACnetConstructedDataBACnetIPGlobalAddress).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataBACnetIPGlobalAddress for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_BACNET_IP_MODE && peekedTagNumber == uint8(9): // BACnetConstructedDataBACnetIPMode
		if _child, err = new(_BACnetConstructedDataBACnetIPMode).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataBACnetIPMode for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_BACNET_IP_MULTICAST_ADDRESS && peekedTagNumber == uint8(6): // BACnetConstructedDataBACnetIPMulticastAddress
		if _child, err = new(_BACnetConstructedDataBACnetIPMulticastAddress).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataBACnetIPMulticastAddress for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_BACNET_IP_NAT_TRAVERSAL && peekedTagNumber == uint8(1): // BACnetConstructedDataBACnetIPNATTraversal
		if _child, err = new(_BACnetConstructedDataBACnetIPNATTraversal).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataBACnetIPNATTraversal for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_BACNET_IP_UDP_PORT && peekedTagNumber == uint8(2): // BACnetConstructedDataBACnetIPUDPPort
		if _child, err = new(_BACnetConstructedDataBACnetIPUDPPort).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataBACnetIPUDPPort for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_BACNET_IPV6_MODE && peekedTagNumber == uint8(9): // BACnetConstructedDataBACnetIPv6Mode
		if _child, err = new(_BACnetConstructedDataBACnetIPv6Mode).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataBACnetIPv6Mode for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_BACNET_IPV6_UDP_PORT && peekedTagNumber == uint8(2): // BACnetConstructedDataBACnetIPv6UDPPort
		if _child, err = new(_BACnetConstructedDataBACnetIPv6UDPPort).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataBACnetIPv6UDPPort for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_BACNET_IPV6_MULTICAST_ADDRESS && peekedTagNumber == uint8(6): // BACnetConstructedDataBACnetIPv6MulticastAddress
		if _child, err = new(_BACnetConstructedDataBACnetIPv6MulticastAddress).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataBACnetIPv6MulticastAddress for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_BASE_DEVICE_SECURITY_POLICY && peekedTagNumber == uint8(9): // BACnetConstructedDataBaseDeviceSecurityPolicy
		if _child, err = new(_BACnetConstructedDataBaseDeviceSecurityPolicy).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataBaseDeviceSecurityPolicy for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_BBMD_ACCEPT_FD_REGISTRATIONS && peekedTagNumber == uint8(1): // BACnetConstructedDataBBMDAcceptFDRegistrations
		if _child, err = new(_BACnetConstructedDataBBMDAcceptFDRegistrations).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataBBMDAcceptFDRegistrations for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_BBMD_BROADCAST_DISTRIBUTION_TABLE: // BACnetConstructedDataBBMDBroadcastDistributionTable
		if _child, err = new(_BACnetConstructedDataBBMDBroadcastDistributionTable).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataBBMDBroadcastDistributionTable for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_BBMD_FOREIGN_DEVICE_TABLE: // BACnetConstructedDataBBMDForeignDeviceTable
		if _child, err = new(_BACnetConstructedDataBBMDForeignDeviceTable).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataBBMDForeignDeviceTable for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_BELONGS_TO: // BACnetConstructedDataBelongsTo
		if _child, err = new(_BACnetConstructedDataBelongsTo).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataBelongsTo for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_BIAS && peekedTagNumber == uint8(4): // BACnetConstructedDataBias
		if _child, err = new(_BACnetConstructedDataBias).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataBias for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_BIT_MASK && peekedTagNumber == uint8(8): // BACnetConstructedDataBitMask
		if _child, err = new(_BACnetConstructedDataBitMask).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataBitMask for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_BIT_TEXT && peekedTagNumber == uint8(7): // BACnetConstructedDataBitText
		if _child, err = new(_BACnetConstructedDataBitText).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataBitText for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_BLINK_WARN_ENABLE && peekedTagNumber == uint8(1): // BACnetConstructedDataBlinkWarnEnable
		if _child, err = new(_BACnetConstructedDataBlinkWarnEnable).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataBlinkWarnEnable for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_BUFFER_SIZE && peekedTagNumber == uint8(2): // BACnetConstructedDataBufferSize
		if _child, err = new(_BACnetConstructedDataBufferSize).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataBufferSize for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_CAR_ASSIGNED_DIRECTION && peekedTagNumber == uint8(9): // BACnetConstructedDataCarAssignedDirection
		if _child, err = new(_BACnetConstructedDataCarAssignedDirection).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataCarAssignedDirection for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_CAR_DOOR_COMMAND && peekedTagNumber == uint8(9): // BACnetConstructedDataCarDoorCommand
		if _child, err = new(_BACnetConstructedDataCarDoorCommand).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataCarDoorCommand for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_CAR_DOOR_STATUS && peekedTagNumber == uint8(9): // BACnetConstructedDataCarDoorStatus
		if _child, err = new(_BACnetConstructedDataCarDoorStatus).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataCarDoorStatus for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_CAR_DOOR_TEXT && peekedTagNumber == uint8(7): // BACnetConstructedDataCarDoorText
		if _child, err = new(_BACnetConstructedDataCarDoorText).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataCarDoorText for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_CAR_DOOR_ZONE && peekedTagNumber == uint8(1): // BACnetConstructedDataCarDoorZone
		if _child, err = new(_BACnetConstructedDataCarDoorZone).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataCarDoorZone for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_CAR_DRIVE_STATUS && peekedTagNumber == uint8(9): // BACnetConstructedDataCarDriveStatus
		if _child, err = new(_BACnetConstructedDataCarDriveStatus).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataCarDriveStatus for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_CAR_LOAD && peekedTagNumber == uint8(4): // BACnetConstructedDataCarLoad
		if _child, err = new(_BACnetConstructedDataCarLoad).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataCarLoad for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_CAR_LOAD_UNITS && peekedTagNumber == uint8(9): // BACnetConstructedDataCarLoadUnits
		if _child, err = new(_BACnetConstructedDataCarLoadUnits).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataCarLoadUnits for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_CAR_MODE && peekedTagNumber == uint8(9): // BACnetConstructedDataCarMode
		if _child, err = new(_BACnetConstructedDataCarMode).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataCarMode for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_CAR_MOVING_DIRECTION && peekedTagNumber == uint8(9): // BACnetConstructedDataCarMovingDirection
		if _child, err = new(_BACnetConstructedDataCarMovingDirection).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataCarMovingDirection for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_CAR_POSITION && peekedTagNumber == uint8(2): // BACnetConstructedDataCarPosition
		if _child, err = new(_BACnetConstructedDataCarPosition).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataCarPosition for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_CHANGE_OF_STATE_COUNT && peekedTagNumber == uint8(2): // BACnetConstructedDataChangeOfStateCount
		if _child, err = new(_BACnetConstructedDataChangeOfStateCount).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataChangeOfStateCount for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_CHANGE_OF_STATE_TIME: // BACnetConstructedDataChangeOfStateTime
		if _child, err = new(_BACnetConstructedDataChangeOfStateTime).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataChangeOfStateTime for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_CHANGES_PENDING && peekedTagNumber == uint8(1): // BACnetConstructedDataChangesPending
		if _child, err = new(_BACnetConstructedDataChangesPending).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataChangesPending for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_CHANNEL_NUMBER && peekedTagNumber == uint8(2): // BACnetConstructedDataChannelNumber
		if _child, err = new(_BACnetConstructedDataChannelNumber).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataChannelNumber for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_CLIENT_COV_INCREMENT: // BACnetConstructedDataClientCOVIncrement
		if _child, err = new(_BACnetConstructedDataClientCOVIncrement).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataClientCOVIncrement for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_COMMAND && peekedTagNumber == uint8(9): // BACnetConstructedDataCommand
		if _child, err = new(_BACnetConstructedDataCommand).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataCommand for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_COMMAND_TIME_ARRAY: // BACnetConstructedDataCommandTimeArray
		if _child, err = new(_BACnetConstructedDataCommandTimeArray).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataCommandTimeArray for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_CONFIGURATION_FILES && peekedTagNumber == uint8(12): // BACnetConstructedDataConfigurationFiles
		if _child, err = new(_BACnetConstructedDataConfigurationFiles).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataConfigurationFiles for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_CONTROL_GROUPS && peekedTagNumber == uint8(2): // BACnetConstructedDataControlGroups
		if _child, err = new(_BACnetConstructedDataControlGroups).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataControlGroups for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_CONTROLLED_VARIABLE_REFERENCE: // BACnetConstructedDataControlledVariableReference
		if _child, err = new(_BACnetConstructedDataControlledVariableReference).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataControlledVariableReference for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_CONTROLLED_VARIABLE_UNITS && peekedTagNumber == uint8(9): // BACnetConstructedDataControlledVariableUnits
		if _child, err = new(_BACnetConstructedDataControlledVariableUnits).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataControlledVariableUnits for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_CONTROLLED_VARIABLE_VALUE && peekedTagNumber == uint8(4): // BACnetConstructedDataControlledVariableValue
		if _child, err = new(_BACnetConstructedDataControlledVariableValue).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataControlledVariableValue for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_COUNT && peekedTagNumber == uint8(2): // BACnetConstructedDataCount
		if _child, err = new(_BACnetConstructedDataCount).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataCount for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_COUNT_BEFORE_CHANGE && peekedTagNumber == uint8(2): // BACnetConstructedDataCountBeforeChange
		if _child, err = new(_BACnetConstructedDataCountBeforeChange).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataCountBeforeChange for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_COUNT_CHANGE_TIME: // BACnetConstructedDataCountChangeTime
		if _child, err = new(_BACnetConstructedDataCountChangeTime).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataCountChangeTime for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_INTEGER_VALUE && propertyIdentifierArgument == BACnetPropertyIdentifier_COV_INCREMENT && peekedTagNumber == uint8(2): // BACnetConstructedDataIntegerValueCOVIncrement
		if _child, err = new(_BACnetConstructedDataIntegerValueCOVIncrement).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataIntegerValueCOVIncrement for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_LARGE_ANALOG_VALUE && propertyIdentifierArgument == BACnetPropertyIdentifier_COV_INCREMENT && peekedTagNumber == uint8(5): // BACnetConstructedDataLargeAnalogValueCOVIncrement
		if _child, err = new(_BACnetConstructedDataLargeAnalogValueCOVIncrement).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataLargeAnalogValueCOVIncrement for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_POSITIVE_INTEGER_VALUE && propertyIdentifierArgument == BACnetPropertyIdentifier_COV_INCREMENT && peekedTagNumber == uint8(2): // BACnetConstructedDataPositiveIntegerValueCOVIncrement
		if _child, err = new(_BACnetConstructedDataPositiveIntegerValueCOVIncrement).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataPositiveIntegerValueCOVIncrement for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_COV_INCREMENT && peekedTagNumber == uint8(4): // BACnetConstructedDataCOVIncrement
		if _child, err = new(_BACnetConstructedDataCOVIncrement).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataCOVIncrement for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_COV_PERIOD && peekedTagNumber == uint8(2): // BACnetConstructedDataCOVPeriod
		if _child, err = new(_BACnetConstructedDataCOVPeriod).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataCOVPeriod for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_COV_RESUBSCRIPTION_INTERVAL && peekedTagNumber == uint8(2): // BACnetConstructedDataCOVResubscriptionInterval
		if _child, err = new(_BACnetConstructedDataCOVResubscriptionInterval).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataCOVResubscriptionInterval for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_COVU_PERIOD && peekedTagNumber == uint8(2): // BACnetConstructedDataCOVUPeriod
		if _child, err = new(_BACnetConstructedDataCOVUPeriod).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataCOVUPeriod for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_COVU_RECIPIENTS: // BACnetConstructedDataCOVURecipients
		if _child, err = new(_BACnetConstructedDataCOVURecipients).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataCOVURecipients for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_CREDENTIAL_DISABLE && peekedTagNumber == uint8(9): // BACnetConstructedDataCredentialDisable
		if _child, err = new(_BACnetConstructedDataCredentialDisable).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataCredentialDisable for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_CREDENTIAL_STATUS && peekedTagNumber == uint8(9): // BACnetConstructedDataCredentialStatus
		if _child, err = new(_BACnetConstructedDataCredentialStatus).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataCredentialStatus for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_CREDENTIALS: // BACnetConstructedDataCredentials
		if _child, err = new(_BACnetConstructedDataCredentials).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataCredentials for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_CREDENTIALS_IN_ZONE: // BACnetConstructedDataCredentialsInZone
		if _child, err = new(_BACnetConstructedDataCredentialsInZone).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataCredentialsInZone for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_CURRENT_COMMAND_PRIORITY: // BACnetConstructedDataCurrentCommandPriority
		if _child, err = new(_BACnetConstructedDataCurrentCommandPriority).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataCurrentCommandPriority for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_DATABASE_REVISION && peekedTagNumber == uint8(2): // BACnetConstructedDataDatabaseRevision
		if _child, err = new(_BACnetConstructedDataDatabaseRevision).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataDatabaseRevision for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_DATE_LIST: // BACnetConstructedDataDateList
		if _child, err = new(_BACnetConstructedDataDateList).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataDateList for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_DAYLIGHT_SAVINGS_STATUS && peekedTagNumber == uint8(1): // BACnetConstructedDataDaylightSavingsStatus
		if _child, err = new(_BACnetConstructedDataDaylightSavingsStatus).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataDaylightSavingsStatus for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_DAYS_REMAINING && peekedTagNumber == uint8(3): // BACnetConstructedDataDaysRemaining
		if _child, err = new(_BACnetConstructedDataDaysRemaining).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataDaysRemaining for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_INTEGER_VALUE && propertyIdentifierArgument == BACnetPropertyIdentifier_DEADBAND && peekedTagNumber == uint8(2): // BACnetConstructedDataIntegerValueDeadband
		if _child, err = new(_BACnetConstructedDataIntegerValueDeadband).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataIntegerValueDeadband for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_LARGE_ANALOG_VALUE && propertyIdentifierArgument == BACnetPropertyIdentifier_DEADBAND && peekedTagNumber == uint8(5): // BACnetConstructedDataLargeAnalogValueDeadband
		if _child, err = new(_BACnetConstructedDataLargeAnalogValueDeadband).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataLargeAnalogValueDeadband for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_POSITIVE_INTEGER_VALUE && propertyIdentifierArgument == BACnetPropertyIdentifier_DEADBAND && peekedTagNumber == uint8(2): // BACnetConstructedDataPositiveIntegerValueDeadband
		if _child, err = new(_BACnetConstructedDataPositiveIntegerValueDeadband).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataPositiveIntegerValueDeadband for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_DEADBAND && peekedTagNumber == uint8(4): // BACnetConstructedDataDeadband
		if _child, err = new(_BACnetConstructedDataDeadband).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataDeadband for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_DEFAULT_FADE_TIME && peekedTagNumber == uint8(2): // BACnetConstructedDataDefaultFadeTime
		if _child, err = new(_BACnetConstructedDataDefaultFadeTime).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataDefaultFadeTime for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_DEFAULT_RAMP_RATE && peekedTagNumber == uint8(4): // BACnetConstructedDataDefaultRampRate
		if _child, err = new(_BACnetConstructedDataDefaultRampRate).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataDefaultRampRate for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_DEFAULT_STEP_INCREMENT && peekedTagNumber == uint8(4): // BACnetConstructedDataDefaultStepIncrement
		if _child, err = new(_BACnetConstructedDataDefaultStepIncrement).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataDefaultStepIncrement for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_DEFAULT_SUBORDINATE_RELATIONSHIP && peekedTagNumber == uint8(9): // BACnetConstructedDataDefaultSubordinateRelationship
		if _child, err = new(_BACnetConstructedDataDefaultSubordinateRelationship).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataDefaultSubordinateRelationship for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_DEFAULT_TIMEOUT && peekedTagNumber == uint8(2): // BACnetConstructedDataDefaultTimeout
		if _child, err = new(_BACnetConstructedDataDefaultTimeout).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataDefaultTimeout for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_DEPLOYED_PROFILE_LOCATION && peekedTagNumber == uint8(7): // BACnetConstructedDataDeployedProfileLocation
		if _child, err = new(_BACnetConstructedDataDeployedProfileLocation).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataDeployedProfileLocation for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_DERIVATIVE_CONSTANT && peekedTagNumber == uint8(4): // BACnetConstructedDataDerivativeConstant
		if _child, err = new(_BACnetConstructedDataDerivativeConstant).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataDerivativeConstant for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_DERIVATIVE_CONSTANT_UNITS && peekedTagNumber == uint8(9): // BACnetConstructedDataDerivativeConstantUnits
		if _child, err = new(_BACnetConstructedDataDerivativeConstantUnits).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataDerivativeConstantUnits for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_DESCRIPTION && peekedTagNumber == uint8(7): // BACnetConstructedDataDescription
		if _child, err = new(_BACnetConstructedDataDescription).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataDescription for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_DESCRIPTION_OF_HALT && peekedTagNumber == uint8(7): // BACnetConstructedDataDescriptionOfHalt
		if _child, err = new(_BACnetConstructedDataDescriptionOfHalt).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataDescriptionOfHalt for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_DEVICE_ADDRESS_BINDING: // BACnetConstructedDataDeviceAddressBinding
		if _child, err = new(_BACnetConstructedDataDeviceAddressBinding).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataDeviceAddressBinding for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_DEVICE_TYPE && peekedTagNumber == uint8(7): // BACnetConstructedDataDeviceType
		if _child, err = new(_BACnetConstructedDataDeviceType).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataDeviceType for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_DIRECT_READING && peekedTagNumber == uint8(4): // BACnetConstructedDataDirectReading
		if _child, err = new(_BACnetConstructedDataDirectReading).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataDirectReading for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_DISTRIBUTION_KEY_REVISION && peekedTagNumber == uint8(2): // BACnetConstructedDataDistributionKeyRevision
		if _child, err = new(_BACnetConstructedDataDistributionKeyRevision).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataDistributionKeyRevision for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_DO_NOT_HIDE && peekedTagNumber == uint8(1): // BACnetConstructedDataDoNotHide
		if _child, err = new(_BACnetConstructedDataDoNotHide).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataDoNotHide for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_DOOR_ALARM_STATE && peekedTagNumber == uint8(9): // BACnetConstructedDataDoorAlarmState
		if _child, err = new(_BACnetConstructedDataDoorAlarmState).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataDoorAlarmState for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_DOOR_EXTENDED_PULSE_TIME && peekedTagNumber == uint8(2): // BACnetConstructedDataDoorExtendedPulseTime
		if _child, err = new(_BACnetConstructedDataDoorExtendedPulseTime).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataDoorExtendedPulseTime for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_DOOR_MEMBERS: // BACnetConstructedDataDoorMembers
		if _child, err = new(_BACnetConstructedDataDoorMembers).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataDoorMembers for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_DOOR_OPEN_TOO_LONG_TIME && peekedTagNumber == uint8(2): // BACnetConstructedDataDoorOpenTooLongTime
		if _child, err = new(_BACnetConstructedDataDoorOpenTooLongTime).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataDoorOpenTooLongTime for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_DOOR_PULSE_TIME && peekedTagNumber == uint8(2): // BACnetConstructedDataDoorPulseTime
		if _child, err = new(_BACnetConstructedDataDoorPulseTime).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataDoorPulseTime for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_DOOR_STATUS && peekedTagNumber == uint8(9): // BACnetConstructedDataDoorStatus
		if _child, err = new(_BACnetConstructedDataDoorStatus).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataDoorStatus for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_DOOR_UNLOCK_DELAY_TIME && peekedTagNumber == uint8(2): // BACnetConstructedDataDoorUnlockDelayTime
		if _child, err = new(_BACnetConstructedDataDoorUnlockDelayTime).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataDoorUnlockDelayTime for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_DUTY_WINDOW && peekedTagNumber == uint8(2): // BACnetConstructedDataDutyWindow
		if _child, err = new(_BACnetConstructedDataDutyWindow).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataDutyWindow for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_EFFECTIVE_PERIOD: // BACnetConstructedDataEffectivePeriod
		if _child, err = new(_BACnetConstructedDataEffectivePeriod).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataEffectivePeriod for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_EGRESS_ACTIVE && peekedTagNumber == uint8(1): // BACnetConstructedDataEgressActive
		if _child, err = new(_BACnetConstructedDataEgressActive).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataEgressActive for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_EGRESS_TIME && peekedTagNumber == uint8(2): // BACnetConstructedDataEgressTime
		if _child, err = new(_BACnetConstructedDataEgressTime).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataEgressTime for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_ELAPSED_ACTIVE_TIME && peekedTagNumber == uint8(2): // BACnetConstructedDataElapsedActiveTime
		if _child, err = new(_BACnetConstructedDataElapsedActiveTime).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataElapsedActiveTime for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_ELEVATOR_GROUP && peekedTagNumber == uint8(12): // BACnetConstructedDataElevatorGroup
		if _child, err = new(_BACnetConstructedDataElevatorGroup).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataElevatorGroup for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_ENABLE && peekedTagNumber == uint8(1): // BACnetConstructedDataEnable
		if _child, err = new(_BACnetConstructedDataEnable).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataEnable for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_ENERGY_METER && peekedTagNumber == uint8(4): // BACnetConstructedDataEnergyMeter
		if _child, err = new(_BACnetConstructedDataEnergyMeter).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataEnergyMeter for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_ENERGY_METER_REF: // BACnetConstructedDataEnergyMeterRef
		if _child, err = new(_BACnetConstructedDataEnergyMeterRef).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataEnergyMeterRef for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_ENTRY_POINTS: // BACnetConstructedDataEntryPoints
		if _child, err = new(_BACnetConstructedDataEntryPoints).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataEntryPoints for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_ERROR_LIMIT && peekedTagNumber == uint8(4): // BACnetConstructedDataErrorLimit
		if _child, err = new(_BACnetConstructedDataErrorLimit).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataErrorLimit for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_ESCALATOR_MODE && peekedTagNumber == uint8(9): // BACnetConstructedDataEscalatorMode
		if _child, err = new(_BACnetConstructedDataEscalatorMode).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataEscalatorMode for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_EVENT_ALGORITHM_INHIBIT && peekedTagNumber == uint8(1): // BACnetConstructedDataEventAlgorithmInhibit
		if _child, err = new(_BACnetConstructedDataEventAlgorithmInhibit).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataEventAlgorithmInhibit for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_EVENT_ALGORITHM_INHIBIT_REF: // BACnetConstructedDataEventAlgorithmInhibitRef
		if _child, err = new(_BACnetConstructedDataEventAlgorithmInhibitRef).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataEventAlgorithmInhibitRef for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_EVENT_DETECTION_ENABLE && peekedTagNumber == uint8(1): // BACnetConstructedDataEventDetectionEnable
		if _child, err = new(_BACnetConstructedDataEventDetectionEnable).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataEventDetectionEnable for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_EVENT_ENABLE && peekedTagNumber == uint8(8): // BACnetConstructedDataEventEnable
		if _child, err = new(_BACnetConstructedDataEventEnable).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataEventEnable for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_EVENT_MESSAGE_TEXTS: // BACnetConstructedDataEventMessageTexts
		if _child, err = new(_BACnetConstructedDataEventMessageTexts).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataEventMessageTexts for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_EVENT_MESSAGE_TEXTS_CONFIG: // BACnetConstructedDataEventMessageTextsConfig
		if _child, err = new(_BACnetConstructedDataEventMessageTextsConfig).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataEventMessageTextsConfig for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_EVENT_PARAMETERS: // BACnetConstructedDataEventParameters
		if _child, err = new(_BACnetConstructedDataEventParameters).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataEventParameters for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_EVENT_STATE && peekedTagNumber == uint8(9): // BACnetConstructedDataEventState
		if _child, err = new(_BACnetConstructedDataEventState).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataEventState for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_EVENT_TIME_STAMPS: // BACnetConstructedDataEventTimeStamps
		if _child, err = new(_BACnetConstructedDataEventTimeStamps).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataEventTimeStamps for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_EVENT_TYPE && peekedTagNumber == uint8(9): // BACnetConstructedDataEventType
		if _child, err = new(_BACnetConstructedDataEventType).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataEventType for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_EXCEPTION_SCHEDULE: // BACnetConstructedDataExceptionSchedule
		if _child, err = new(_BACnetConstructedDataExceptionSchedule).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataExceptionSchedule for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_EXECUTION_DELAY && peekedTagNumber == uint8(2): // BACnetConstructedDataExecutionDelay
		if _child, err = new(_BACnetConstructedDataExecutionDelay).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataExecutionDelay for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_EXIT_POINTS: // BACnetConstructedDataExitPoints
		if _child, err = new(_BACnetConstructedDataExitPoints).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataExitPoints for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_EXPECTED_SHED_LEVEL: // BACnetConstructedDataExpectedShedLevel
		if _child, err = new(_BACnetConstructedDataExpectedShedLevel).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataExpectedShedLevel for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_EXPIRATION_TIME: // BACnetConstructedDataExpirationTime
		if _child, err = new(_BACnetConstructedDataExpirationTime).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataExpirationTime for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_EXTENDED_TIME_ENABLE && peekedTagNumber == uint8(1): // BACnetConstructedDataExtendedTimeEnable
		if _child, err = new(_BACnetConstructedDataExtendedTimeEnable).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataExtendedTimeEnable for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_FAILED_ATTEMPT_EVENTS: // BACnetConstructedDataFailedAttemptEvents
		if _child, err = new(_BACnetConstructedDataFailedAttemptEvents).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataFailedAttemptEvents for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_FAILED_ATTEMPTS && peekedTagNumber == uint8(2): // BACnetConstructedDataFailedAttempts
		if _child, err = new(_BACnetConstructedDataFailedAttempts).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataFailedAttempts for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_FAILED_ATTEMPTS_TIME && peekedTagNumber == uint8(2): // BACnetConstructedDataFailedAttemptsTime
		if _child, err = new(_BACnetConstructedDataFailedAttemptsTime).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataFailedAttemptsTime for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_ACCUMULATOR && propertyIdentifierArgument == BACnetPropertyIdentifier_FAULT_HIGH_LIMIT && peekedTagNumber == uint8(2): // BACnetConstructedDataAccumulatorFaultHighLimit
		if _child, err = new(_BACnetConstructedDataAccumulatorFaultHighLimit).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataAccumulatorFaultHighLimit for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_ANALOG_INPUT && propertyIdentifierArgument == BACnetPropertyIdentifier_FAULT_HIGH_LIMIT && peekedTagNumber == uint8(4): // BACnetConstructedDataAnalogInputFaultHighLimit
		if _child, err = new(_BACnetConstructedDataAnalogInputFaultHighLimit).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataAnalogInputFaultHighLimit for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_ANALOG_VALUE && propertyIdentifierArgument == BACnetPropertyIdentifier_FAULT_HIGH_LIMIT && peekedTagNumber == uint8(4): // BACnetConstructedDataAnalogValueFaultHighLimit
		if _child, err = new(_BACnetConstructedDataAnalogValueFaultHighLimit).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataAnalogValueFaultHighLimit for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_INTEGER_VALUE && propertyIdentifierArgument == BACnetPropertyIdentifier_FAULT_HIGH_LIMIT && peekedTagNumber == uint8(3): // BACnetConstructedDataIntegerValueFaultHighLimit
		if _child, err = new(_BACnetConstructedDataIntegerValueFaultHighLimit).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataIntegerValueFaultHighLimit for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_LARGE_ANALOG_VALUE && propertyIdentifierArgument == BACnetPropertyIdentifier_FAULT_HIGH_LIMIT && peekedTagNumber == uint8(5): // BACnetConstructedDataLargeAnalogValueFaultHighLimit
		if _child, err = new(_BACnetConstructedDataLargeAnalogValueFaultHighLimit).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataLargeAnalogValueFaultHighLimit for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_POSITIVE_INTEGER_VALUE && propertyIdentifierArgument == BACnetPropertyIdentifier_FAULT_HIGH_LIMIT && peekedTagNumber == uint8(2): // BACnetConstructedDataPositiveIntegerValueFaultHighLimit
		if _child, err = new(_BACnetConstructedDataPositiveIntegerValueFaultHighLimit).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataPositiveIntegerValueFaultHighLimit for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_FAULT_HIGH_LIMIT && peekedTagNumber == uint8(2): // BACnetConstructedDataFaultHighLimit
		if _child, err = new(_BACnetConstructedDataFaultHighLimit).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataFaultHighLimit for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_ACCUMULATOR && propertyIdentifierArgument == BACnetPropertyIdentifier_FAULT_LOW_LIMIT && peekedTagNumber == uint8(2): // BACnetConstructedDataAccumulatorFaultLowLimit
		if _child, err = new(_BACnetConstructedDataAccumulatorFaultLowLimit).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataAccumulatorFaultLowLimit for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_ANALOG_INPUT && propertyIdentifierArgument == BACnetPropertyIdentifier_FAULT_LOW_LIMIT && peekedTagNumber == uint8(4): // BACnetConstructedDataAnalogInputFaultLowLimit
		if _child, err = new(_BACnetConstructedDataAnalogInputFaultLowLimit).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataAnalogInputFaultLowLimit for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_ANALOG_VALUE && propertyIdentifierArgument == BACnetPropertyIdentifier_FAULT_LOW_LIMIT && peekedTagNumber == uint8(4): // BACnetConstructedDataAnalogValueFaultLowLimit
		if _child, err = new(_BACnetConstructedDataAnalogValueFaultLowLimit).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataAnalogValueFaultLowLimit for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_LARGE_ANALOG_VALUE && propertyIdentifierArgument == BACnetPropertyIdentifier_FAULT_LOW_LIMIT && peekedTagNumber == uint8(5): // BACnetConstructedDataLargeAnalogValueFaultLowLimit
		if _child, err = new(_BACnetConstructedDataLargeAnalogValueFaultLowLimit).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataLargeAnalogValueFaultLowLimit for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_INTEGER_VALUE && propertyIdentifierArgument == BACnetPropertyIdentifier_FAULT_LOW_LIMIT && peekedTagNumber == uint8(3): // BACnetConstructedDataIntegerValueFaultLowLimit
		if _child, err = new(_BACnetConstructedDataIntegerValueFaultLowLimit).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataIntegerValueFaultLowLimit for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_POSITIVE_INTEGER_VALUE && propertyIdentifierArgument == BACnetPropertyIdentifier_FAULT_LOW_LIMIT && peekedTagNumber == uint8(2): // BACnetConstructedDataPositiveIntegerValueFaultLowLimit
		if _child, err = new(_BACnetConstructedDataPositiveIntegerValueFaultLowLimit).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataPositiveIntegerValueFaultLowLimit for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_FAULT_LOW_LIMIT && peekedTagNumber == uint8(4): // BACnetConstructedDataFaultLowLimit
		if _child, err = new(_BACnetConstructedDataFaultLowLimit).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataFaultLowLimit for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_FAULT_PARAMETERS: // BACnetConstructedDataFaultParameters
		if _child, err = new(_BACnetConstructedDataFaultParameters).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataFaultParameters for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_ESCALATOR && propertyIdentifierArgument == BACnetPropertyIdentifier_FAULT_SIGNALS: // BACnetConstructedDataEscalatorFaultSignals
		if _child, err = new(_BACnetConstructedDataEscalatorFaultSignals).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataEscalatorFaultSignals for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_LIFT && propertyIdentifierArgument == BACnetPropertyIdentifier_FAULT_SIGNALS: // BACnetConstructedDataLiftFaultSignals
		if _child, err = new(_BACnetConstructedDataLiftFaultSignals).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataLiftFaultSignals for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_FAULT_SIGNALS: // BACnetConstructedDataFaultSignals
		if _child, err = new(_BACnetConstructedDataFaultSignals).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataFaultSignals for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_FAULT_TYPE && peekedTagNumber == uint8(9): // BACnetConstructedDataFaultType
		if _child, err = new(_BACnetConstructedDataFaultType).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataFaultType for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_ACCESS_DOOR && propertyIdentifierArgument == BACnetPropertyIdentifier_FAULT_VALUES: // BACnetConstructedDataAccessDoorFaultValues
		if _child, err = new(_BACnetConstructedDataAccessDoorFaultValues).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataAccessDoorFaultValues for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_CHARACTERSTRING_VALUE && propertyIdentifierArgument == BACnetPropertyIdentifier_FAULT_VALUES: // BACnetConstructedDataCharacterStringValueFaultValues
		if _child, err = new(_BACnetConstructedDataCharacterStringValueFaultValues).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataCharacterStringValueFaultValues for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_LIFE_SAFETY_POINT && propertyIdentifierArgument == BACnetPropertyIdentifier_FAULT_VALUES: // BACnetConstructedDataLifeSafetyPointFaultValues
		if _child, err = new(_BACnetConstructedDataLifeSafetyPointFaultValues).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataLifeSafetyPointFaultValues for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_LIFE_SAFETY_ZONE && propertyIdentifierArgument == BACnetPropertyIdentifier_FAULT_VALUES: // BACnetConstructedDataLifeSafetyZoneFaultValues
		if _child, err = new(_BACnetConstructedDataLifeSafetyZoneFaultValues).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataLifeSafetyZoneFaultValues for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_MULTI_STATE_INPUT && propertyIdentifierArgument == BACnetPropertyIdentifier_FAULT_VALUES && peekedTagNumber == uint8(2): // BACnetConstructedDataMultiStateInputFaultValues
		if _child, err = new(_BACnetConstructedDataMultiStateInputFaultValues).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataMultiStateInputFaultValues for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_MULTI_STATE_VALUE && propertyIdentifierArgument == BACnetPropertyIdentifier_FAULT_VALUES && peekedTagNumber == uint8(2): // BACnetConstructedDataMultiStateValueFaultValues
		if _child, err = new(_BACnetConstructedDataMultiStateValueFaultValues).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataMultiStateValueFaultValues for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_FAULT_VALUES: // BACnetConstructedDataFaultValues
		if _child, err = new(_BACnetConstructedDataFaultValues).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataFaultValues for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_FD_BBMD_ADDRESS: // BACnetConstructedDataFDBBMDAddress
		if _child, err = new(_BACnetConstructedDataFDBBMDAddress).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataFDBBMDAddress for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_FD_SUBSCRIPTION_LIFETIME && peekedTagNumber == uint8(2): // BACnetConstructedDataFDSubscriptionLifetime
		if _child, err = new(_BACnetConstructedDataFDSubscriptionLifetime).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataFDSubscriptionLifetime for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_BINARY_LIGHTING_OUTPUT && propertyIdentifierArgument == BACnetPropertyIdentifier_FEEDBACK_VALUE && peekedTagNumber == uint8(9): // BACnetConstructedDataBinaryLightingOutputFeedbackValue
		if _child, err = new(_BACnetConstructedDataBinaryLightingOutputFeedbackValue).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataBinaryLightingOutputFeedbackValue for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_BINARY_OUTPUT && propertyIdentifierArgument == BACnetPropertyIdentifier_FEEDBACK_VALUE && peekedTagNumber == uint8(9): // BACnetConstructedDataBinaryOutputFeedbackValue
		if _child, err = new(_BACnetConstructedDataBinaryOutputFeedbackValue).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataBinaryOutputFeedbackValue for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_LIGHTING_OUTPUT && propertyIdentifierArgument == BACnetPropertyIdentifier_FEEDBACK_VALUE && peekedTagNumber == uint8(4): // BACnetConstructedDataLightingOutputFeedbackValue
		if _child, err = new(_BACnetConstructedDataLightingOutputFeedbackValue).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataLightingOutputFeedbackValue for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_MULTI_STATE_OUTPUT && propertyIdentifierArgument == BACnetPropertyIdentifier_FEEDBACK_VALUE && peekedTagNumber == uint8(2): // BACnetConstructedDataMultiStateOutputFeedbackValue
		if _child, err = new(_BACnetConstructedDataMultiStateOutputFeedbackValue).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataMultiStateOutputFeedbackValue for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_FILE_ACCESS_METHOD && peekedTagNumber == uint8(9): // BACnetConstructedDataFileAccessMethod
		if _child, err = new(_BACnetConstructedDataFileAccessMethod).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataFileAccessMethod for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_FILE_SIZE && peekedTagNumber == uint8(2): // BACnetConstructedDataFileSize
		if _child, err = new(_BACnetConstructedDataFileSize).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataFileSize for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_FILE_TYPE && peekedTagNumber == uint8(7): // BACnetConstructedDataFileType
		if _child, err = new(_BACnetConstructedDataFileType).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataFileType for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_FIRMWARE_REVISION && peekedTagNumber == uint8(7): // BACnetConstructedDataFirmwareRevision
		if _child, err = new(_BACnetConstructedDataFirmwareRevision).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataFirmwareRevision for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_FLOOR_TEXT && peekedTagNumber == uint8(7): // BACnetConstructedDataFloorText
		if _child, err = new(_BACnetConstructedDataFloorText).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataFloorText for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_FULL_DUTY_BASELINE && peekedTagNumber == uint8(4): // BACnetConstructedDataFullDutyBaseline
		if _child, err = new(_BACnetConstructedDataFullDutyBaseline).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataFullDutyBaseline for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_GLOBAL_IDENTIFIER && peekedTagNumber == uint8(2): // BACnetConstructedDataGlobalIdentifier
		if _child, err = new(_BACnetConstructedDataGlobalIdentifier).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataGlobalIdentifier for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_GROUP_ID && peekedTagNumber == uint8(2): // BACnetConstructedDataGroupID
		if _child, err = new(_BACnetConstructedDataGroupID).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataGroupID for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_GROUP_MEMBER_NAMES && peekedTagNumber == uint8(7): // BACnetConstructedDataGroupMemberNames
		if _child, err = new(_BACnetConstructedDataGroupMemberNames).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataGroupMemberNames for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_GLOBAL_GROUP && propertyIdentifierArgument == BACnetPropertyIdentifier_GROUP_MEMBERS: // BACnetConstructedDataGlobalGroupGroupMembers
		if _child, err = new(_BACnetConstructedDataGlobalGroupGroupMembers).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataGlobalGroupGroupMembers for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_ELEVATOR_GROUP && propertyIdentifierArgument == BACnetPropertyIdentifier_GROUP_MEMBERS && peekedTagNumber == uint8(12): // BACnetConstructedDataElevatorGroupGroupMembers
		if _child, err = new(_BACnetConstructedDataElevatorGroupGroupMembers).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataElevatorGroupGroupMembers for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_GROUP_MEMBERS && peekedTagNumber == uint8(12): // BACnetConstructedDataGroupMembers
		if _child, err = new(_BACnetConstructedDataGroupMembers).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataGroupMembers for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_GROUP_MODE && peekedTagNumber == uint8(9): // BACnetConstructedDataGroupMode
		if _child, err = new(_BACnetConstructedDataGroupMode).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataGroupMode for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_ACCUMULATOR && propertyIdentifierArgument == BACnetPropertyIdentifier_HIGH_LIMIT && peekedTagNumber == uint8(2): // BACnetConstructedDataAccumulatorHighLimit
		if _child, err = new(_BACnetConstructedDataAccumulatorHighLimit).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataAccumulatorHighLimit for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_LARGE_ANALOG_VALUE && propertyIdentifierArgument == BACnetPropertyIdentifier_HIGH_LIMIT && peekedTagNumber == uint8(5): // BACnetConstructedDataLargeAnalogValueHighLimit
		if _child, err = new(_BACnetConstructedDataLargeAnalogValueHighLimit).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataLargeAnalogValueHighLimit for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_INTEGER_VALUE && propertyIdentifierArgument == BACnetPropertyIdentifier_HIGH_LIMIT && peekedTagNumber == uint8(3): // BACnetConstructedDataIntegerValueHighLimit
		if _child, err = new(_BACnetConstructedDataIntegerValueHighLimit).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataIntegerValueHighLimit for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_POSITIVE_INTEGER_VALUE && propertyIdentifierArgument == BACnetPropertyIdentifier_HIGH_LIMIT && peekedTagNumber == uint8(2): // BACnetConstructedDataPositiveIntegerValueHighLimit
		if _child, err = new(_BACnetConstructedDataPositiveIntegerValueHighLimit).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataPositiveIntegerValueHighLimit for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_HIGH_LIMIT && peekedTagNumber == uint8(4): // BACnetConstructedDataHighLimit
		if _child, err = new(_BACnetConstructedDataHighLimit).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataHighLimit for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_HIGHER_DECK && peekedTagNumber == uint8(12): // BACnetConstructedDataHigherDeck
		if _child, err = new(_BACnetConstructedDataHigherDeck).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataHigherDeck for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_IN_PROCESS && peekedTagNumber == uint8(1): // BACnetConstructedDataInProcess
		if _child, err = new(_BACnetConstructedDataInProcess).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataInProcess for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_IN_PROGRESS && peekedTagNumber == uint8(9): // BACnetConstructedDataInProgress
		if _child, err = new(_BACnetConstructedDataInProgress).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataInProgress for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_INACTIVE_TEXT && peekedTagNumber == uint8(7): // BACnetConstructedDataInactiveText
		if _child, err = new(_BACnetConstructedDataInactiveText).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataInactiveText for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_INITIAL_TIMEOUT && peekedTagNumber == uint8(2): // BACnetConstructedDataInitialTimeout
		if _child, err = new(_BACnetConstructedDataInitialTimeout).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataInitialTimeout for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_INPUT_REFERENCE: // BACnetConstructedDataInputReference
		if _child, err = new(_BACnetConstructedDataInputReference).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataInputReference for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_INSTALLATION_ID && peekedTagNumber == uint8(2): // BACnetConstructedDataInstallationID
		if _child, err = new(_BACnetConstructedDataInstallationID).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataInstallationID for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_INSTANCE_OF && peekedTagNumber == uint8(7): // BACnetConstructedDataInstanceOf
		if _child, err = new(_BACnetConstructedDataInstanceOf).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataInstanceOf for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_INSTANTANEOUS_POWER && peekedTagNumber == uint8(4): // BACnetConstructedDataInstantaneousPower
		if _child, err = new(_BACnetConstructedDataInstantaneousPower).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataInstantaneousPower for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_INTEGRAL_CONSTANT && peekedTagNumber == uint8(4): // BACnetConstructedDataIntegralConstant
		if _child, err = new(_BACnetConstructedDataIntegralConstant).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataIntegralConstant for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_INTEGRAL_CONSTANT_UNITS && peekedTagNumber == uint8(9): // BACnetConstructedDataIntegralConstantUnits
		if _child, err = new(_BACnetConstructedDataIntegralConstantUnits).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataIntegralConstantUnits for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_ANALOG_INPUT && propertyIdentifierArgument == BACnetPropertyIdentifier_INTERFACE_VALUE: // BACnetConstructedDataAnalogInputInterfaceValue
		if _child, err = new(_BACnetConstructedDataAnalogInputInterfaceValue).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataAnalogInputInterfaceValue for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_ANALOG_OUTPUT && propertyIdentifierArgument == BACnetPropertyIdentifier_INTERFACE_VALUE: // BACnetConstructedDataAnalogOutputInterfaceValue
		if _child, err = new(_BACnetConstructedDataAnalogOutputInterfaceValue).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataAnalogOutputInterfaceValue for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_BINARY_INPUT && propertyIdentifierArgument == BACnetPropertyIdentifier_INTERFACE_VALUE: // BACnetConstructedDataBinaryInputInterfaceValue
		if _child, err = new(_BACnetConstructedDataBinaryInputInterfaceValue).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataBinaryInputInterfaceValue for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_BINARY_OUTPUT && propertyIdentifierArgument == BACnetPropertyIdentifier_INTERFACE_VALUE: // BACnetConstructedDataBinaryOutputInterfaceValue
		if _child, err = new(_BACnetConstructedDataBinaryOutputInterfaceValue).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataBinaryOutputInterfaceValue for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_MULTI_STATE_INPUT && propertyIdentifierArgument == BACnetPropertyIdentifier_INTERFACE_VALUE: // BACnetConstructedDataMultiStateInputInterfaceValue
		if _child, err = new(_BACnetConstructedDataMultiStateInputInterfaceValue).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataMultiStateInputInterfaceValue for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_MULTI_STATE_OUTPUT && propertyIdentifierArgument == BACnetPropertyIdentifier_INTERFACE_VALUE: // BACnetConstructedDataMultiStateOutputInterfaceValue
		if _child, err = new(_BACnetConstructedDataMultiStateOutputInterfaceValue).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataMultiStateOutputInterfaceValue for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_INTERVAL_OFFSET && peekedTagNumber == uint8(2): // BACnetConstructedDataIntervalOffset
		if _child, err = new(_BACnetConstructedDataIntervalOffset).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataIntervalOffset for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_IP_ADDRESS && peekedTagNumber == uint8(6): // BACnetConstructedDataIPAddress
		if _child, err = new(_BACnetConstructedDataIPAddress).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataIPAddress for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_IP_DEFAULT_GATEWAY && peekedTagNumber == uint8(6): // BACnetConstructedDataIPDefaultGateway
		if _child, err = new(_BACnetConstructedDataIPDefaultGateway).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataIPDefaultGateway for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_IP_DHCP_ENABLE && peekedTagNumber == uint8(1): // BACnetConstructedDataIPDHCPEnable
		if _child, err = new(_BACnetConstructedDataIPDHCPEnable).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataIPDHCPEnable for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_IP_DHCP_LEASE_TIME && peekedTagNumber == uint8(2): // BACnetConstructedDataIPDHCPLeaseTime
		if _child, err = new(_BACnetConstructedDataIPDHCPLeaseTime).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataIPDHCPLeaseTime for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_IP_DHCP_LEASE_TIME_REMAINING && peekedTagNumber == uint8(2): // BACnetConstructedDataIPDHCPLeaseTimeRemaining
		if _child, err = new(_BACnetConstructedDataIPDHCPLeaseTimeRemaining).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataIPDHCPLeaseTimeRemaining for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_IP_DHCP_SERVER && peekedTagNumber == uint8(6): // BACnetConstructedDataIPDHCPServer
		if _child, err = new(_BACnetConstructedDataIPDHCPServer).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataIPDHCPServer for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_IP_DNS_SERVER && peekedTagNumber == uint8(6): // BACnetConstructedDataIPDNSServer
		if _child, err = new(_BACnetConstructedDataIPDNSServer).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataIPDNSServer for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_IP_SUBNET_MASK && peekedTagNumber == uint8(6): // BACnetConstructedDataIPSubnetMask
		if _child, err = new(_BACnetConstructedDataIPSubnetMask).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataIPSubnetMask for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_IPV6_ADDRESS && peekedTagNumber == uint8(6): // BACnetConstructedDataIPv6Address
		if _child, err = new(_BACnetConstructedDataIPv6Address).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataIPv6Address for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_IPV6_AUTO_ADDRESSING_ENABLE && peekedTagNumber == uint8(1): // BACnetConstructedDataIPv6AutoAddressingEnable
		if _child, err = new(_BACnetConstructedDataIPv6AutoAddressingEnable).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataIPv6AutoAddressingEnable for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_IPV6_DEFAULT_GATEWAY && peekedTagNumber == uint8(6): // BACnetConstructedDataIPv6DefaultGateway
		if _child, err = new(_BACnetConstructedDataIPv6DefaultGateway).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataIPv6DefaultGateway for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_IPV6_DHCP_LEASE_TIME && peekedTagNumber == uint8(2): // BACnetConstructedDataIPv6DHCPLeaseTime
		if _child, err = new(_BACnetConstructedDataIPv6DHCPLeaseTime).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataIPv6DHCPLeaseTime for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_IPV6_DHCP_LEASE_TIME_REMAINING && peekedTagNumber == uint8(2): // BACnetConstructedDataIPv6DHCPLeaseTimeRemaining
		if _child, err = new(_BACnetConstructedDataIPv6DHCPLeaseTimeRemaining).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataIPv6DHCPLeaseTimeRemaining for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_IPV6_DHCP_SERVER && peekedTagNumber == uint8(6): // BACnetConstructedDataIPv6DHCPServer
		if _child, err = new(_BACnetConstructedDataIPv6DHCPServer).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataIPv6DHCPServer for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_IPV6_DNS_SERVER && peekedTagNumber == uint8(6): // BACnetConstructedDataIPv6DNSServer
		if _child, err = new(_BACnetConstructedDataIPv6DNSServer).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataIPv6DNSServer for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_IPV6_PREFIX_LENGTH && peekedTagNumber == uint8(2): // BACnetConstructedDataIPv6PrefixLength
		if _child, err = new(_BACnetConstructedDataIPv6PrefixLength).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataIPv6PrefixLength for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_IPV6_ZONE_INDEX && peekedTagNumber == uint8(7): // BACnetConstructedDataIPv6ZoneIndex
		if _child, err = new(_BACnetConstructedDataIPv6ZoneIndex).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataIPv6ZoneIndex for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_IS_UTC && peekedTagNumber == uint8(1): // BACnetConstructedDataIsUTC
		if _child, err = new(_BACnetConstructedDataIsUTC).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataIsUTC for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_KEY_SETS: // BACnetConstructedDataKeySets
		if _child, err = new(_BACnetConstructedDataKeySets).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataKeySets for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_LANDING_CALL_CONTROL: // BACnetConstructedDataLandingCallControl
		if _child, err = new(_BACnetConstructedDataLandingCallControl).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataLandingCallControl for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_LANDING_CALLS: // BACnetConstructedDataLandingCalls
		if _child, err = new(_BACnetConstructedDataLandingCalls).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataLandingCalls for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_LANDING_DOOR_STATUS: // BACnetConstructedDataLandingDoorStatus
		if _child, err = new(_BACnetConstructedDataLandingDoorStatus).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataLandingDoorStatus for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_LAST_ACCESS_EVENT && peekedTagNumber == uint8(9): // BACnetConstructedDataLastAccessEvent
		if _child, err = new(_BACnetConstructedDataLastAccessEvent).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataLastAccessEvent for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_LAST_ACCESS_POINT: // BACnetConstructedDataLastAccessPoint
		if _child, err = new(_BACnetConstructedDataLastAccessPoint).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataLastAccessPoint for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_LAST_COMMAND_TIME: // BACnetConstructedDataLastCommandTime
		if _child, err = new(_BACnetConstructedDataLastCommandTime).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataLastCommandTime for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_LAST_CREDENTIAL_ADDED: // BACnetConstructedDataLastCredentialAdded
		if _child, err = new(_BACnetConstructedDataLastCredentialAdded).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataLastCredentialAdded for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_LAST_CREDENTIAL_ADDED_TIME: // BACnetConstructedDataLastCredentialAddedTime
		if _child, err = new(_BACnetConstructedDataLastCredentialAddedTime).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataLastCredentialAddedTime for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_LAST_CREDENTIAL_REMOVED: // BACnetConstructedDataLastCredentialRemoved
		if _child, err = new(_BACnetConstructedDataLastCredentialRemoved).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataLastCredentialRemoved for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_LAST_CREDENTIAL_REMOVED_TIME: // BACnetConstructedDataLastCredentialRemovedTime
		if _child, err = new(_BACnetConstructedDataLastCredentialRemovedTime).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataLastCredentialRemovedTime for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_LAST_KEY_SERVER: // BACnetConstructedDataLastKeyServer
		if _child, err = new(_BACnetConstructedDataLastKeyServer).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataLastKeyServer for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_LAST_NOTIFY_RECORD && peekedTagNumber == uint8(2): // BACnetConstructedDataLastNotifyRecord
		if _child, err = new(_BACnetConstructedDataLastNotifyRecord).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataLastNotifyRecord for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_LAST_PRIORITY && peekedTagNumber == uint8(2): // BACnetConstructedDataLastPriority
		if _child, err = new(_BACnetConstructedDataLastPriority).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataLastPriority for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_LAST_RESTART_REASON && peekedTagNumber == uint8(9): // BACnetConstructedDataLastRestartReason
		if _child, err = new(_BACnetConstructedDataLastRestartReason).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataLastRestartReason for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_LAST_RESTORE_TIME: // BACnetConstructedDataLastRestoreTime
		if _child, err = new(_BACnetConstructedDataLastRestoreTime).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataLastRestoreTime for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_LAST_STATE_CHANGE && peekedTagNumber == uint8(9): // BACnetConstructedDataLastStateChange
		if _child, err = new(_BACnetConstructedDataLastStateChange).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataLastStateChange for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_LAST_USE_TIME: // BACnetConstructedDataLastUseTime
		if _child, err = new(_BACnetConstructedDataLastUseTime).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataLastUseTime for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_LIFE_SAFETY_ALARM_VALUES && peekedTagNumber == uint8(9): // BACnetConstructedDataLifeSafetyAlarmValues
		if _child, err = new(_BACnetConstructedDataLifeSafetyAlarmValues).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataLifeSafetyAlarmValues for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_LIGHTING_COMMAND: // BACnetConstructedDataLightingCommand
		if _child, err = new(_BACnetConstructedDataLightingCommand).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataLightingCommand for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_LIGHTING_COMMAND_DEFAULT_PRIORITY && peekedTagNumber == uint8(2): // BACnetConstructedDataLightingCommandDefaultPriority
		if _child, err = new(_BACnetConstructedDataLightingCommandDefaultPriority).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataLightingCommandDefaultPriority for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_LIMIT_ENABLE && peekedTagNumber == uint8(8): // BACnetConstructedDataLimitEnable
		if _child, err = new(_BACnetConstructedDataLimitEnable).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataLimitEnable for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_LIMIT_MONITORING_INTERVAL && peekedTagNumber == uint8(2): // BACnetConstructedDataLimitMonitoringInterval
		if _child, err = new(_BACnetConstructedDataLimitMonitoringInterval).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataLimitMonitoringInterval for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_LINK_SPEED && peekedTagNumber == uint8(4): // BACnetConstructedDataLinkSpeed
		if _child, err = new(_BACnetConstructedDataLinkSpeed).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataLinkSpeed for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_LINK_SPEED_AUTONEGOTIATE && peekedTagNumber == uint8(1): // BACnetConstructedDataLinkSpeedAutonegotiate
		if _child, err = new(_BACnetConstructedDataLinkSpeedAutonegotiate).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataLinkSpeedAutonegotiate for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_LINK_SPEEDS && peekedTagNumber == uint8(4): // BACnetConstructedDataLinkSpeeds
		if _child, err = new(_BACnetConstructedDataLinkSpeeds).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataLinkSpeeds for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_LIST_OF_GROUP_MEMBERS: // BACnetConstructedDataListOfGroupMembers
		if _child, err = new(_BACnetConstructedDataListOfGroupMembers).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataListOfGroupMembers for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_CHANNEL && propertyIdentifierArgument == BACnetPropertyIdentifier_LIST_OF_OBJECT_PROPERTY_REFERENCES: // BACnetConstructedDataChannelListOfObjectPropertyReferences
		if _child, err = new(_BACnetConstructedDataChannelListOfObjectPropertyReferences).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataChannelListOfObjectPropertyReferences for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_LIST_OF_OBJECT_PROPERTY_REFERENCES: // BACnetConstructedDataListOfObjectPropertyReferences
		if _child, err = new(_BACnetConstructedDataListOfObjectPropertyReferences).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataListOfObjectPropertyReferences for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_LOCAL_DATE && peekedTagNumber == uint8(10): // BACnetConstructedDataLocalDate
		if _child, err = new(_BACnetConstructedDataLocalDate).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataLocalDate for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_LOCAL_FORWARDING_ONLY && peekedTagNumber == uint8(1): // BACnetConstructedDataLocalForwardingOnly
		if _child, err = new(_BACnetConstructedDataLocalForwardingOnly).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataLocalForwardingOnly for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_LOCAL_TIME && peekedTagNumber == uint8(11): // BACnetConstructedDataLocalTime
		if _child, err = new(_BACnetConstructedDataLocalTime).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataLocalTime for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_LOCATION && peekedTagNumber == uint8(7): // BACnetConstructedDataLocation
		if _child, err = new(_BACnetConstructedDataLocation).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataLocation for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_LOCK_STATUS && peekedTagNumber == uint8(9): // BACnetConstructedDataLockStatus
		if _child, err = new(_BACnetConstructedDataLockStatus).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataLockStatus for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_LOCKOUT && peekedTagNumber == uint8(1): // BACnetConstructedDataLockout
		if _child, err = new(_BACnetConstructedDataLockout).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataLockout for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_LOCKOUT_RELINQUISH_TIME && peekedTagNumber == uint8(2): // BACnetConstructedDataLockoutRelinquishTime
		if _child, err = new(_BACnetConstructedDataLockoutRelinquishTime).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataLockoutRelinquishTime for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_EVENT_LOG && propertyIdentifierArgument == BACnetPropertyIdentifier_LOG_BUFFER: // BACnetConstructedDataEventLogLogBuffer
		if _child, err = new(_BACnetConstructedDataEventLogLogBuffer).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataEventLogLogBuffer for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_TREND_LOG && propertyIdentifierArgument == BACnetPropertyIdentifier_LOG_BUFFER: // BACnetConstructedDataTrendLogLogBuffer
		if _child, err = new(_BACnetConstructedDataTrendLogLogBuffer).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataTrendLogLogBuffer for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_TREND_LOG_MULTIPLE && propertyIdentifierArgument == BACnetPropertyIdentifier_LOG_BUFFER: // BACnetConstructedDataTrendLogMultipleLogBuffer
		if _child, err = new(_BACnetConstructedDataTrendLogMultipleLogBuffer).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataTrendLogMultipleLogBuffer for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_LOG_BUFFER: // BACnetConstructedDataLogBuffer
		if _child, err = new(_BACnetConstructedDataLogBuffer).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataLogBuffer for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_TREND_LOG && propertyIdentifierArgument == BACnetPropertyIdentifier_LOG_DEVICE_OBJECT_PROPERTY: // BACnetConstructedDataTrendLogLogDeviceObjectProperty
		if _child, err = new(_BACnetConstructedDataTrendLogLogDeviceObjectProperty).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataTrendLogLogDeviceObjectProperty for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_TREND_LOG_MULTIPLE && propertyIdentifierArgument == BACnetPropertyIdentifier_LOG_DEVICE_OBJECT_PROPERTY: // BACnetConstructedDataTrendLogMultipleLogDeviceObjectProperty
		if _child, err = new(_BACnetConstructedDataTrendLogMultipleLogDeviceObjectProperty).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataTrendLogMultipleLogDeviceObjectProperty for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_LOG_DEVICE_OBJECT_PROPERTY: // BACnetConstructedDataLogDeviceObjectProperty
		if _child, err = new(_BACnetConstructedDataLogDeviceObjectProperty).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataLogDeviceObjectProperty for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_LOG_INTERVAL && peekedTagNumber == uint8(2): // BACnetConstructedDataLogInterval
		if _child, err = new(_BACnetConstructedDataLogInterval).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataLogInterval for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_LOGGING_OBJECT && peekedTagNumber == uint8(12): // BACnetConstructedDataLoggingObject
		if _child, err = new(_BACnetConstructedDataLoggingObject).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataLoggingObject for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_LOGGING_RECORD: // BACnetConstructedDataLoggingRecord
		if _child, err = new(_BACnetConstructedDataLoggingRecord).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataLoggingRecord for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_LOGGING_TYPE && peekedTagNumber == uint8(9): // BACnetConstructedDataLoggingType
		if _child, err = new(_BACnetConstructedDataLoggingType).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataLoggingType for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_LOW_DIFF_LIMIT: // BACnetConstructedDataLowDiffLimit
		if _child, err = new(_BACnetConstructedDataLowDiffLimit).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataLowDiffLimit for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_ACCUMULATOR && propertyIdentifierArgument == BACnetPropertyIdentifier_LOW_LIMIT && peekedTagNumber == uint8(2): // BACnetConstructedDataAccumulatorLowLimit
		if _child, err = new(_BACnetConstructedDataAccumulatorLowLimit).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataAccumulatorLowLimit for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_LARGE_ANALOG_VALUE && propertyIdentifierArgument == BACnetPropertyIdentifier_LOW_LIMIT && peekedTagNumber == uint8(5): // BACnetConstructedDataLargeAnalogValueLowLimit
		if _child, err = new(_BACnetConstructedDataLargeAnalogValueLowLimit).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataLargeAnalogValueLowLimit for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_INTEGER_VALUE && propertyIdentifierArgument == BACnetPropertyIdentifier_LOW_LIMIT && peekedTagNumber == uint8(3): // BACnetConstructedDataIntegerValueLowLimit
		if _child, err = new(_BACnetConstructedDataIntegerValueLowLimit).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataIntegerValueLowLimit for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_POSITIVE_INTEGER_VALUE && propertyIdentifierArgument == BACnetPropertyIdentifier_LOW_LIMIT && peekedTagNumber == uint8(2): // BACnetConstructedDataPositiveIntegerValueLowLimit
		if _child, err = new(_BACnetConstructedDataPositiveIntegerValueLowLimit).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataPositiveIntegerValueLowLimit for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_LOW_LIMIT && peekedTagNumber == uint8(4): // BACnetConstructedDataLowLimit
		if _child, err = new(_BACnetConstructedDataLowLimit).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataLowLimit for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_LOWER_DECK && peekedTagNumber == uint8(12): // BACnetConstructedDataLowerDeck
		if _child, err = new(_BACnetConstructedDataLowerDeck).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataLowerDeck for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_MAC_ADDRESS && peekedTagNumber == uint8(6): // BACnetConstructedDataMACAddress
		if _child, err = new(_BACnetConstructedDataMACAddress).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataMACAddress for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_MACHINE_ROOM_ID && peekedTagNumber == uint8(12): // BACnetConstructedDataMachineRoomID
		if _child, err = new(_BACnetConstructedDataMachineRoomID).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataMachineRoomID for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_LIFE_SAFETY_ZONE && propertyIdentifierArgument == BACnetPropertyIdentifier_MAINTENANCE_REQUIRED && peekedTagNumber == uint8(1): // BACnetConstructedDataLifeSafetyZoneMaintenanceRequired
		if _child, err = new(_BACnetConstructedDataLifeSafetyZoneMaintenanceRequired).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataLifeSafetyZoneMaintenanceRequired for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_MAINTENANCE_REQUIRED && peekedTagNumber == uint8(9): // BACnetConstructedDataMaintenanceRequired
		if _child, err = new(_BACnetConstructedDataMaintenanceRequired).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataMaintenanceRequired for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_MAKING_CAR_CALL: // BACnetConstructedDataMakingCarCall
		if _child, err = new(_BACnetConstructedDataMakingCarCall).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataMakingCarCall for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_MANIPULATED_VARIABLE_REFERENCE: // BACnetConstructedDataManipulatedVariableReference
		if _child, err = new(_BACnetConstructedDataManipulatedVariableReference).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataManipulatedVariableReference for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_MANUAL_SLAVE_ADDRESS_BINDING: // BACnetConstructedDataManualSlaveAddressBinding
		if _child, err = new(_BACnetConstructedDataManualSlaveAddressBinding).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataManualSlaveAddressBinding for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_MASKED_ALARM_VALUES && peekedTagNumber == uint8(9): // BACnetConstructedDataMaskedAlarmValues
		if _child, err = new(_BACnetConstructedDataMaskedAlarmValues).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataMaskedAlarmValues for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_MAX_ACTUAL_VALUE && peekedTagNumber == uint8(4): // BACnetConstructedDataMaxActualValue
		if _child, err = new(_BACnetConstructedDataMaxActualValue).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataMaxActualValue for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_MAX_APDU_LENGTH_ACCEPTED && peekedTagNumber == uint8(2): // BACnetConstructedDataMaxAPDULengthAccepted
		if _child, err = new(_BACnetConstructedDataMaxAPDULengthAccepted).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataMaxAPDULengthAccepted for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_MAX_FAILED_ATTEMPTS && peekedTagNumber == uint8(2): // BACnetConstructedDataMaxFailedAttempts
		if _child, err = new(_BACnetConstructedDataMaxFailedAttempts).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataMaxFailedAttempts for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_DEVICE && propertyIdentifierArgument == BACnetPropertyIdentifier_MAX_INFO_FRAMES && peekedTagNumber == uint8(2): // BACnetConstructedDataDeviceMaxInfoFrames
		if _child, err = new(_BACnetConstructedDataDeviceMaxInfoFrames).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataDeviceMaxInfoFrames for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_NETWORK_PORT && propertyIdentifierArgument == BACnetPropertyIdentifier_MAX_INFO_FRAMES && peekedTagNumber == uint8(2): // BACnetConstructedDataNetworkPortMaxInfoFrames
		if _child, err = new(_BACnetConstructedDataNetworkPortMaxInfoFrames).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataNetworkPortMaxInfoFrames for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_MAX_INFO_FRAMES && peekedTagNumber == uint8(2): // BACnetConstructedDataMaxInfoFrames
		if _child, err = new(_BACnetConstructedDataMaxInfoFrames).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataMaxInfoFrames for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_DEVICE && propertyIdentifierArgument == BACnetPropertyIdentifier_MAX_MASTER && peekedTagNumber == uint8(2): // BACnetConstructedDataDeviceMaxMaster
		if _child, err = new(_BACnetConstructedDataDeviceMaxMaster).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataDeviceMaxMaster for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_NETWORK_PORT && propertyIdentifierArgument == BACnetPropertyIdentifier_MAX_MASTER && peekedTagNumber == uint8(2): // BACnetConstructedDataNetworkPortMaxMaster
		if _child, err = new(_BACnetConstructedDataNetworkPortMaxMaster).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataNetworkPortMaxMaster for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_MAX_MASTER && peekedTagNumber == uint8(2): // BACnetConstructedDataMaxMaster
		if _child, err = new(_BACnetConstructedDataMaxMaster).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataMaxMaster for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_ACCUMULATOR && propertyIdentifierArgument == BACnetPropertyIdentifier_MAX_PRES_VALUE && peekedTagNumber == uint8(2): // BACnetConstructedDataAccumulatorMaxPresValue
		if _child, err = new(_BACnetConstructedDataAccumulatorMaxPresValue).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataAccumulatorMaxPresValue for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_ANALOG_INPUT && propertyIdentifierArgument == BACnetPropertyIdentifier_MAX_PRES_VALUE && peekedTagNumber == uint8(4): // BACnetConstructedDataAnalogInputMaxPresValue
		if _child, err = new(_BACnetConstructedDataAnalogInputMaxPresValue).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataAnalogInputMaxPresValue for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_ANALOG_OUTPUT && propertyIdentifierArgument == BACnetPropertyIdentifier_MAX_PRES_VALUE && peekedTagNumber == uint8(4): // BACnetConstructedDataAnalogOutputMaxPresValue
		if _child, err = new(_BACnetConstructedDataAnalogOutputMaxPresValue).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataAnalogOutputMaxPresValue for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_ANALOG_VALUE && propertyIdentifierArgument == BACnetPropertyIdentifier_MAX_PRES_VALUE && peekedTagNumber == uint8(4): // BACnetConstructedDataAnalogValueMaxPresValue
		if _child, err = new(_BACnetConstructedDataAnalogValueMaxPresValue).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataAnalogValueMaxPresValue for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_LARGE_ANALOG_VALUE && propertyIdentifierArgument == BACnetPropertyIdentifier_MAX_PRES_VALUE && peekedTagNumber == uint8(5): // BACnetConstructedDataLargeAnalogValueMaxPresValue
		if _child, err = new(_BACnetConstructedDataLargeAnalogValueMaxPresValue).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataLargeAnalogValueMaxPresValue for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_INTEGER_VALUE && propertyIdentifierArgument == BACnetPropertyIdentifier_MAX_PRES_VALUE && peekedTagNumber == uint8(3): // BACnetConstructedDataIntegerValueMaxPresValue
		if _child, err = new(_BACnetConstructedDataIntegerValueMaxPresValue).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataIntegerValueMaxPresValue for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_POSITIVE_INTEGER_VALUE && propertyIdentifierArgument == BACnetPropertyIdentifier_MAX_PRES_VALUE && peekedTagNumber == uint8(2): // BACnetConstructedDataPositiveIntegerValueMaxPresValue
		if _child, err = new(_BACnetConstructedDataPositiveIntegerValueMaxPresValue).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataPositiveIntegerValueMaxPresValue for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_TIMER && propertyIdentifierArgument == BACnetPropertyIdentifier_MAX_PRES_VALUE && peekedTagNumber == uint8(2): // BACnetConstructedDataTimerMaxPresValue
		if _child, err = new(_BACnetConstructedDataTimerMaxPresValue).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataTimerMaxPresValue for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_MAX_PRES_VALUE && peekedTagNumber == uint8(4): // BACnetConstructedDataMaxPresValue
		if _child, err = new(_BACnetConstructedDataMaxPresValue).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataMaxPresValue for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_MAX_SEGMENTS_ACCEPTED && peekedTagNumber == uint8(2): // BACnetConstructedDataMaxSegmentsAccepted
		if _child, err = new(_BACnetConstructedDataMaxSegmentsAccepted).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataMaxSegmentsAccepted for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_MAXIMUM_OUTPUT && peekedTagNumber == uint8(4): // BACnetConstructedDataMaximumOutput
		if _child, err = new(_BACnetConstructedDataMaximumOutput).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataMaximumOutput for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_MAXIMUM_VALUE && peekedTagNumber == uint8(4): // BACnetConstructedDataMaximumValue
		if _child, err = new(_BACnetConstructedDataMaximumValue).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataMaximumValue for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_MAXIMUM_VALUE_TIMESTAMP: // BACnetConstructedDataMaximumValueTimestamp
		if _child, err = new(_BACnetConstructedDataMaximumValueTimestamp).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataMaximumValueTimestamp for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_MEMBER_OF: // BACnetConstructedDataMemberOf
		if _child, err = new(_BACnetConstructedDataMemberOf).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataMemberOf for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_MEMBER_STATUS_FLAGS && peekedTagNumber == uint8(8): // BACnetConstructedDataMemberStatusFlags
		if _child, err = new(_BACnetConstructedDataMemberStatusFlags).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataMemberStatusFlags for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_MEMBERS: // BACnetConstructedDataMembers
		if _child, err = new(_BACnetConstructedDataMembers).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataMembers for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_MIN_ACTUAL_VALUE && peekedTagNumber == uint8(4): // BACnetConstructedDataMinActualValue
		if _child, err = new(_BACnetConstructedDataMinActualValue).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataMinActualValue for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_ACCUMULATOR && propertyIdentifierArgument == BACnetPropertyIdentifier_MIN_PRES_VALUE && peekedTagNumber == uint8(2): // BACnetConstructedDataAccumulatorMinPresValue
		if _child, err = new(_BACnetConstructedDataAccumulatorMinPresValue).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataAccumulatorMinPresValue for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_INTEGER_VALUE && propertyIdentifierArgument == BACnetPropertyIdentifier_MIN_PRES_VALUE && peekedTagNumber == uint8(3): // BACnetConstructedDataIntegerValueMinPresValue
		if _child, err = new(_BACnetConstructedDataIntegerValueMinPresValue).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataIntegerValueMinPresValue for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_POSITIVE_INTEGER_VALUE && propertyIdentifierArgument == BACnetPropertyIdentifier_MIN_PRES_VALUE && peekedTagNumber == uint8(2): // BACnetConstructedDataPositiveIntegerValueMinPresValue
		if _child, err = new(_BACnetConstructedDataPositiveIntegerValueMinPresValue).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataPositiveIntegerValueMinPresValue for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_LARGE_ANALOG_VALUE && propertyIdentifierArgument == BACnetPropertyIdentifier_MIN_PRES_VALUE && peekedTagNumber == uint8(5): // BACnetConstructedDataLargeAnalogValueMinPresValue
		if _child, err = new(_BACnetConstructedDataLargeAnalogValueMinPresValue).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataLargeAnalogValueMinPresValue for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_TIMER && propertyIdentifierArgument == BACnetPropertyIdentifier_MIN_PRES_VALUE && peekedTagNumber == uint8(2): // BACnetConstructedDataTimerMinPresValue
		if _child, err = new(_BACnetConstructedDataTimerMinPresValue).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataTimerMinPresValue for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_MIN_PRES_VALUE && peekedTagNumber == uint8(4): // BACnetConstructedDataMinPresValue
		if _child, err = new(_BACnetConstructedDataMinPresValue).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataMinPresValue for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_MINIMUM_OFF_TIME && peekedTagNumber == uint8(2): // BACnetConstructedDataMinimumOffTime
		if _child, err = new(_BACnetConstructedDataMinimumOffTime).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataMinimumOffTime for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_MINIMUM_ON_TIME && peekedTagNumber == uint8(2): // BACnetConstructedDataMinimumOnTime
		if _child, err = new(_BACnetConstructedDataMinimumOnTime).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataMinimumOnTime for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_MINIMUM_OUTPUT && peekedTagNumber == uint8(4): // BACnetConstructedDataMinimumOutput
		if _child, err = new(_BACnetConstructedDataMinimumOutput).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataMinimumOutput for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_MINIMUM_VALUE && peekedTagNumber == uint8(4): // BACnetConstructedDataMinimumValue
		if _child, err = new(_BACnetConstructedDataMinimumValue).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataMinimumValue for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_MINIMUM_VALUE_TIMESTAMP: // BACnetConstructedDataMinimumValueTimestamp
		if _child, err = new(_BACnetConstructedDataMinimumValueTimestamp).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataMinimumValueTimestamp for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_MODE && peekedTagNumber == uint8(9): // BACnetConstructedDataMode
		if _child, err = new(_BACnetConstructedDataMode).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataMode for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_MODEL_NAME && peekedTagNumber == uint8(7): // BACnetConstructedDataModelName
		if _child, err = new(_BACnetConstructedDataModelName).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataModelName for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_MODIFICATION_DATE: // BACnetConstructedDataModificationDate
		if _child, err = new(_BACnetConstructedDataModificationDate).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataModificationDate for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_MUSTER_POINT && peekedTagNumber == uint8(1): // BACnetConstructedDataMusterPoint
		if _child, err = new(_BACnetConstructedDataMusterPoint).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataMusterPoint for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_NEGATIVE_ACCESS_RULES: // BACnetConstructedDataNegativeAccessRules
		if _child, err = new(_BACnetConstructedDataNegativeAccessRules).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataNegativeAccessRules for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_NETWORK_ACCESS_SECURITY_POLICIES: // BACnetConstructedDataNetworkAccessSecurityPolicies
		if _child, err = new(_BACnetConstructedDataNetworkAccessSecurityPolicies).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataNetworkAccessSecurityPolicies for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_NETWORK_INTERFACE_NAME && peekedTagNumber == uint8(7): // BACnetConstructedDataNetworkInterfaceName
		if _child, err = new(_BACnetConstructedDataNetworkInterfaceName).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataNetworkInterfaceName for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_NETWORK_NUMBER && peekedTagNumber == uint8(2): // BACnetConstructedDataNetworkNumber
		if _child, err = new(_BACnetConstructedDataNetworkNumber).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataNetworkNumber for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_NETWORK_NUMBER_QUALITY && peekedTagNumber == uint8(9): // BACnetConstructedDataNetworkNumberQuality
		if _child, err = new(_BACnetConstructedDataNetworkNumberQuality).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataNetworkNumberQuality for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_NETWORK_TYPE && peekedTagNumber == uint8(9): // BACnetConstructedDataNetworkType
		if _child, err = new(_BACnetConstructedDataNetworkType).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataNetworkType for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_NEXT_STOPPING_FLOOR && peekedTagNumber == uint8(2): // BACnetConstructedDataNextStoppingFloor
		if _child, err = new(_BACnetConstructedDataNextStoppingFloor).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataNextStoppingFloor for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_NODE_SUBTYPE && peekedTagNumber == uint8(7): // BACnetConstructedDataNodeSubtype
		if _child, err = new(_BACnetConstructedDataNodeSubtype).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataNodeSubtype for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_NODE_TYPE && peekedTagNumber == uint8(9): // BACnetConstructedDataNodeType
		if _child, err = new(_BACnetConstructedDataNodeType).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataNodeType for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_NOTIFICATION_CLASS && peekedTagNumber == uint8(2): // BACnetConstructedDataNotificationClass
		if _child, err = new(_BACnetConstructedDataNotificationClass).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataNotificationClass for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_NOTIFICATION_THRESHOLD && peekedTagNumber == uint8(2): // BACnetConstructedDataNotificationThreshold
		if _child, err = new(_BACnetConstructedDataNotificationThreshold).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataNotificationThreshold for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_NOTIFY_TYPE && peekedTagNumber == uint8(9): // BACnetConstructedDataNotifyType
		if _child, err = new(_BACnetConstructedDataNotifyType).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataNotifyType for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_NUMBER_OF_APDU_RETRIES && peekedTagNumber == uint8(2): // BACnetConstructedDataNumberOfAPDURetries
		if _child, err = new(_BACnetConstructedDataNumberOfAPDURetries).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataNumberOfAPDURetries for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_NUMBER_OF_AUTHENTICATION_POLICIES && peekedTagNumber == uint8(2): // BACnetConstructedDataNumberOfAuthenticationPolicies
		if _child, err = new(_BACnetConstructedDataNumberOfAuthenticationPolicies).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataNumberOfAuthenticationPolicies for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_NUMBER_OF_STATES && peekedTagNumber == uint8(2): // BACnetConstructedDataNumberOfStates
		if _child, err = new(_BACnetConstructedDataNumberOfStates).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataNumberOfStates for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_OBJECT_IDENTIFIER && peekedTagNumber == uint8(12): // BACnetConstructedDataObjectIdentifier
		if _child, err = new(_BACnetConstructedDataObjectIdentifier).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataObjectIdentifier for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_OBJECT_LIST: // BACnetConstructedDataObjectList
		if _child, err = new(_BACnetConstructedDataObjectList).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataObjectList for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_OBJECT_NAME && peekedTagNumber == uint8(7): // BACnetConstructedDataObjectName
		if _child, err = new(_BACnetConstructedDataObjectName).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataObjectName for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_OBJECT_PROPERTY_REFERENCE: // BACnetConstructedDataObjectPropertyReference
		if _child, err = new(_BACnetConstructedDataObjectPropertyReference).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataObjectPropertyReference for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_OBJECT_TYPE && peekedTagNumber == uint8(9): // BACnetConstructedDataObjectType
		if _child, err = new(_BACnetConstructedDataObjectType).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataObjectType for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_OCCUPANCY_COUNT && peekedTagNumber == uint8(2): // BACnetConstructedDataOccupancyCount
		if _child, err = new(_BACnetConstructedDataOccupancyCount).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataOccupancyCount for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_OCCUPANCY_COUNT_ADJUST && peekedTagNumber == uint8(1): // BACnetConstructedDataOccupancyCountAdjust
		if _child, err = new(_BACnetConstructedDataOccupancyCountAdjust).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataOccupancyCountAdjust for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_OCCUPANCY_COUNT_ENABLE && peekedTagNumber == uint8(1): // BACnetConstructedDataOccupancyCountEnable
		if _child, err = new(_BACnetConstructedDataOccupancyCountEnable).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataOccupancyCountEnable for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_OCCUPANCY_LOWER_LIMIT && peekedTagNumber == uint8(2): // BACnetConstructedDataOccupancyLowerLimit
		if _child, err = new(_BACnetConstructedDataOccupancyLowerLimit).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataOccupancyLowerLimit for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_OCCUPANCY_LOWER_LIMIT_ENFORCED && peekedTagNumber == uint8(1): // BACnetConstructedDataOccupancyLowerLimitEnforced
		if _child, err = new(_BACnetConstructedDataOccupancyLowerLimitEnforced).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataOccupancyLowerLimitEnforced for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_OCCUPANCY_STATE && peekedTagNumber == uint8(9): // BACnetConstructedDataOccupancyState
		if _child, err = new(_BACnetConstructedDataOccupancyState).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataOccupancyState for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_OCCUPANCY_UPPER_LIMIT && peekedTagNumber == uint8(2): // BACnetConstructedDataOccupancyUpperLimit
		if _child, err = new(_BACnetConstructedDataOccupancyUpperLimit).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataOccupancyUpperLimit for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_OCCUPANCY_UPPER_LIMIT_ENFORCED && peekedTagNumber == uint8(1): // BACnetConstructedDataOccupancyUpperLimitEnforced
		if _child, err = new(_BACnetConstructedDataOccupancyUpperLimitEnforced).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataOccupancyUpperLimitEnforced for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_OPERATION_DIRECTION && peekedTagNumber == uint8(9): // BACnetConstructedDataOperationDirection
		if _child, err = new(_BACnetConstructedDataOperationDirection).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataOperationDirection for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_OPERATION_EXPECTED && peekedTagNumber == uint8(9): // BACnetConstructedDataOperationExpected
		if _child, err = new(_BACnetConstructedDataOperationExpected).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataOperationExpected for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_OPTIONAL: // BACnetConstructedDataOptional
		if _child, err = new(_BACnetConstructedDataOptional).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataOptional for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_OUT_OF_SERVICE && peekedTagNumber == uint8(1): // BACnetConstructedDataOutOfService
		if _child, err = new(_BACnetConstructedDataOutOfService).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataOutOfService for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_OUTPUT_UNITS && peekedTagNumber == uint8(9): // BACnetConstructedDataOutputUnits
		if _child, err = new(_BACnetConstructedDataOutputUnits).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataOutputUnits for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_PACKET_REORDER_TIME && peekedTagNumber == uint8(2): // BACnetConstructedDataPacketReorderTime
		if _child, err = new(_BACnetConstructedDataPacketReorderTime).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataPacketReorderTime for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_PASSBACK_MODE: // BACnetConstructedDataPassbackMode
		if _child, err = new(_BACnetConstructedDataPassbackMode).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataPassbackMode for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_PASSBACK_TIMEOUT && peekedTagNumber == uint8(2): // BACnetConstructedDataPassbackTimeout
		if _child, err = new(_BACnetConstructedDataPassbackTimeout).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataPassbackTimeout for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_PASSENGER_ALARM && peekedTagNumber == uint8(1): // BACnetConstructedDataPassengerAlarm
		if _child, err = new(_BACnetConstructedDataPassengerAlarm).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataPassengerAlarm for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_POLARITY && peekedTagNumber == uint8(9): // BACnetConstructedDataPolarity
		if _child, err = new(_BACnetConstructedDataPolarity).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataPolarity for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_PORT_FILTER: // BACnetConstructedDataPortFilter
		if _child, err = new(_BACnetConstructedDataPortFilter).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataPortFilter for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_POSITIVE_ACCESS_RULES: // BACnetConstructedDataPositiveAccessRules
		if _child, err = new(_BACnetConstructedDataPositiveAccessRules).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataPositiveAccessRules for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_POWER && peekedTagNumber == uint8(4): // BACnetConstructedDataPower
		if _child, err = new(_BACnetConstructedDataPower).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataPower for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_POWER_MODE && peekedTagNumber == uint8(1): // BACnetConstructedDataPowerMode
		if _child, err = new(_BACnetConstructedDataPowerMode).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataPowerMode for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_PRESCALE: // BACnetConstructedDataPrescale
		if _child, err = new(_BACnetConstructedDataPrescale).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataPrescale for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_ACCESS_DOOR && propertyIdentifierArgument == BACnetPropertyIdentifier_PRESENT_VALUE && peekedTagNumber == uint8(9): // BACnetConstructedDataAccessDoorPresentValue
		if _child, err = new(_BACnetConstructedDataAccessDoorPresentValue).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataAccessDoorPresentValue for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_ALERT_ENROLLMENT && propertyIdentifierArgument == BACnetPropertyIdentifier_PRESENT_VALUE && peekedTagNumber == uint8(12): // BACnetConstructedDataAlertEnrollmentPresentValue
		if _child, err = new(_BACnetConstructedDataAlertEnrollmentPresentValue).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataAlertEnrollmentPresentValue for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_ANALOG_INPUT && propertyIdentifierArgument == BACnetPropertyIdentifier_PRESENT_VALUE && peekedTagNumber == uint8(4): // BACnetConstructedDataAnalogInputPresentValue
		if _child, err = new(_BACnetConstructedDataAnalogInputPresentValue).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataAnalogInputPresentValue for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_ANALOG_OUTPUT && propertyIdentifierArgument == BACnetPropertyIdentifier_PRESENT_VALUE && peekedTagNumber == uint8(4): // BACnetConstructedDataAnalogOutputPresentValue
		if _child, err = new(_BACnetConstructedDataAnalogOutputPresentValue).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataAnalogOutputPresentValue for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_ANALOG_VALUE && propertyIdentifierArgument == BACnetPropertyIdentifier_PRESENT_VALUE && peekedTagNumber == uint8(4): // BACnetConstructedDataAnalogValuePresentValue
		if _child, err = new(_BACnetConstructedDataAnalogValuePresentValue).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataAnalogValuePresentValue for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_BINARY_INPUT && propertyIdentifierArgument == BACnetPropertyIdentifier_PRESENT_VALUE && peekedTagNumber == uint8(9): // BACnetConstructedDataBinaryInputPresentValue
		if _child, err = new(_BACnetConstructedDataBinaryInputPresentValue).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataBinaryInputPresentValue for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_BINARY_OUTPUT && propertyIdentifierArgument == BACnetPropertyIdentifier_PRESENT_VALUE && peekedTagNumber == uint8(9): // BACnetConstructedDataBinaryOutputPresentValue
		if _child, err = new(_BACnetConstructedDataBinaryOutputPresentValue).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataBinaryOutputPresentValue for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_BINARY_VALUE && propertyIdentifierArgument == BACnetPropertyIdentifier_PRESENT_VALUE && peekedTagNumber == uint8(9): // BACnetConstructedDataBinaryValuePresentValue
		if _child, err = new(_BACnetConstructedDataBinaryValuePresentValue).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataBinaryValuePresentValue for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_BINARY_LIGHTING_OUTPUT && propertyIdentifierArgument == BACnetPropertyIdentifier_PRESENT_VALUE && peekedTagNumber == uint8(9): // BACnetConstructedDataBinaryLightingOutputPresentValue
		if _child, err = new(_BACnetConstructedDataBinaryLightingOutputPresentValue).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataBinaryLightingOutputPresentValue for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_BITSTRING_VALUE && propertyIdentifierArgument == BACnetPropertyIdentifier_PRESENT_VALUE && peekedTagNumber == uint8(8): // BACnetConstructedDataBitStringValuePresentValue
		if _child, err = new(_BACnetConstructedDataBitStringValuePresentValue).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataBitStringValuePresentValue for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_CALENDAR && propertyIdentifierArgument == BACnetPropertyIdentifier_PRESENT_VALUE && peekedTagNumber == uint8(1): // BACnetConstructedDataCalendarPresentValue
		if _child, err = new(_BACnetConstructedDataCalendarPresentValue).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataCalendarPresentValue for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_CHANNEL && propertyIdentifierArgument == BACnetPropertyIdentifier_PRESENT_VALUE: // BACnetConstructedDataChannelPresentValue
		if _child, err = new(_BACnetConstructedDataChannelPresentValue).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataChannelPresentValue for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_CHARACTERSTRING_VALUE && propertyIdentifierArgument == BACnetPropertyIdentifier_PRESENT_VALUE && peekedTagNumber == uint8(7): // BACnetConstructedDataCharacterStringValuePresentValue
		if _child, err = new(_BACnetConstructedDataCharacterStringValuePresentValue).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataCharacterStringValuePresentValue for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_CREDENTIAL_DATA_INPUT && propertyIdentifierArgument == BACnetPropertyIdentifier_PRESENT_VALUE: // BACnetConstructedDataCredentialDataInputPresentValue
		if _child, err = new(_BACnetConstructedDataCredentialDataInputPresentValue).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataCredentialDataInputPresentValue for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_DATE_VALUE && propertyIdentifierArgument == BACnetPropertyIdentifier_PRESENT_VALUE && peekedTagNumber == uint8(10): // BACnetConstructedDataDateValuePresentValue
		if _child, err = new(_BACnetConstructedDataDateValuePresentValue).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataDateValuePresentValue for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_DATEPATTERN_VALUE && propertyIdentifierArgument == BACnetPropertyIdentifier_PRESENT_VALUE && peekedTagNumber == uint8(10): // BACnetConstructedDataDatePatternValuePresentValue
		if _child, err = new(_BACnetConstructedDataDatePatternValuePresentValue).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataDatePatternValuePresentValue for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_DATETIME_VALUE && propertyIdentifierArgument == BACnetPropertyIdentifier_PRESENT_VALUE && peekedTagNumber == uint8(11): // BACnetConstructedDataDateTimeValuePresentValue
		if _child, err = new(_BACnetConstructedDataDateTimeValuePresentValue).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataDateTimeValuePresentValue for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_DATETIMEPATTERN_VALUE && propertyIdentifierArgument == BACnetPropertyIdentifier_PRESENT_VALUE && peekedTagNumber == uint8(11): // BACnetConstructedDataDateTimePatternValuePresentValue
		if _child, err = new(_BACnetConstructedDataDateTimePatternValuePresentValue).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataDateTimePatternValuePresentValue for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_INTEGER_VALUE && propertyIdentifierArgument == BACnetPropertyIdentifier_PRESENT_VALUE && peekedTagNumber == uint8(3): // BACnetConstructedDataIntegerValuePresentValue
		if _child, err = new(_BACnetConstructedDataIntegerValuePresentValue).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataIntegerValuePresentValue for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_LARGE_ANALOG_VALUE && propertyIdentifierArgument == BACnetPropertyIdentifier_PRESENT_VALUE && peekedTagNumber == uint8(5): // BACnetConstructedDataLargeAnalogValuePresentValue
		if _child, err = new(_BACnetConstructedDataLargeAnalogValuePresentValue).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataLargeAnalogValuePresentValue for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_LIGHTING_OUTPUT && propertyIdentifierArgument == BACnetPropertyIdentifier_PRESENT_VALUE && peekedTagNumber == uint8(4): // BACnetConstructedDataLightingOutputPresentValue
		if _child, err = new(_BACnetConstructedDataLightingOutputPresentValue).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataLightingOutputPresentValue for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_LIFE_SAFETY_POINT && propertyIdentifierArgument == BACnetPropertyIdentifier_PRESENT_VALUE && peekedTagNumber == uint8(9): // BACnetConstructedDataLifeSafetyPointPresentValue
		if _child, err = new(_BACnetConstructedDataLifeSafetyPointPresentValue).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataLifeSafetyPointPresentValue for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_LIFE_SAFETY_ZONE && propertyIdentifierArgument == BACnetPropertyIdentifier_PRESENT_VALUE && peekedTagNumber == uint8(9): // BACnetConstructedDataLifeSafetyZonePresentValue
		if _child, err = new(_BACnetConstructedDataLifeSafetyZonePresentValue).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataLifeSafetyZonePresentValue for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_LOAD_CONTROL && propertyIdentifierArgument == BACnetPropertyIdentifier_PRESENT_VALUE && peekedTagNumber == uint8(9): // BACnetConstructedDataLoadControlPresentValue
		if _child, err = new(_BACnetConstructedDataLoadControlPresentValue).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataLoadControlPresentValue for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_LOOP && propertyIdentifierArgument == BACnetPropertyIdentifier_PRESENT_VALUE && peekedTagNumber == uint8(4): // BACnetConstructedDataLoopPresentValue
		if _child, err = new(_BACnetConstructedDataLoopPresentValue).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataLoopPresentValue for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_PULSE_CONVERTER && propertyIdentifierArgument == BACnetPropertyIdentifier_PRESENT_VALUE && peekedTagNumber == uint8(4): // BACnetConstructedDataPulseConverterPresentValue
		if _child, err = new(_BACnetConstructedDataPulseConverterPresentValue).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataPulseConverterPresentValue for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_GROUP && propertyIdentifierArgument == BACnetPropertyIdentifier_PRESENT_VALUE: // BACnetConstructedDataGroupPresentValue
		if _child, err = new(_BACnetConstructedDataGroupPresentValue).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataGroupPresentValue for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_GLOBAL_GROUP && propertyIdentifierArgument == BACnetPropertyIdentifier_PRESENT_VALUE: // BACnetConstructedDataGlobalGroupPresentValue
		if _child, err = new(_BACnetConstructedDataGlobalGroupPresentValue).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataGlobalGroupPresentValue for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_OCTETSTRING_VALUE && propertyIdentifierArgument == BACnetPropertyIdentifier_PRESENT_VALUE && peekedTagNumber == uint8(6): // BACnetConstructedDataOctetStringValuePresentValue
		if _child, err = new(_BACnetConstructedDataOctetStringValuePresentValue).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataOctetStringValuePresentValue for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_SCHEDULE && propertyIdentifierArgument == BACnetPropertyIdentifier_PRESENT_VALUE: // BACnetConstructedDataSchedulePresentValue
		if _child, err = new(_BACnetConstructedDataSchedulePresentValue).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataSchedulePresentValue for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_TIME_VALUE && propertyIdentifierArgument == BACnetPropertyIdentifier_PRESENT_VALUE && peekedTagNumber == uint8(11): // BACnetConstructedDataTimeValuePresentValue
		if _child, err = new(_BACnetConstructedDataTimeValuePresentValue).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataTimeValuePresentValue for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_TIMEPATTERN_VALUE && propertyIdentifierArgument == BACnetPropertyIdentifier_PRESENT_VALUE && peekedTagNumber == uint8(11): // BACnetConstructedDataTimePatternValuePresentValue
		if _child, err = new(_BACnetConstructedDataTimePatternValuePresentValue).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataTimePatternValuePresentValue for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_PRESENT_VALUE && peekedTagNumber == uint8(2): // BACnetConstructedDataPresentValue
		if _child, err = new(_BACnetConstructedDataPresentValue).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataPresentValue for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_PRIORITY: // BACnetConstructedDataPriority
		if _child, err = new(_BACnetConstructedDataPriority).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataPriority for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_PRIORITY_ARRAY: // BACnetConstructedDataPriorityArray
		if _child, err = new(_BACnetConstructedDataPriorityArray).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataPriorityArray for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_PRIORITY_FOR_WRITING && peekedTagNumber == uint8(2): // BACnetConstructedDataPriorityForWriting
		if _child, err = new(_BACnetConstructedDataPriorityForWriting).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataPriorityForWriting for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_PROCESS_IDENTIFIER && peekedTagNumber == uint8(2): // BACnetConstructedDataProcessIdentifier
		if _child, err = new(_BACnetConstructedDataProcessIdentifier).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataProcessIdentifier for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_PROCESS_IDENTIFIER_FILTER: // BACnetConstructedDataProcessIdentifierFilter
		if _child, err = new(_BACnetConstructedDataProcessIdentifierFilter).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataProcessIdentifierFilter for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_PROFILE_LOCATION && peekedTagNumber == uint8(7): // BACnetConstructedDataProfileLocation
		if _child, err = new(_BACnetConstructedDataProfileLocation).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataProfileLocation for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_PROFILE_NAME && peekedTagNumber == uint8(7): // BACnetConstructedDataProfileName
		if _child, err = new(_BACnetConstructedDataProfileName).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataProfileName for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_PROGRAM_CHANGE && peekedTagNumber == uint8(9): // BACnetConstructedDataProgramChange
		if _child, err = new(_BACnetConstructedDataProgramChange).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataProgramChange for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_PROGRAM_LOCATION && peekedTagNumber == uint8(7): // BACnetConstructedDataProgramLocation
		if _child, err = new(_BACnetConstructedDataProgramLocation).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataProgramLocation for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_PROGRAM_STATE && peekedTagNumber == uint8(9): // BACnetConstructedDataProgramState
		if _child, err = new(_BACnetConstructedDataProgramState).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataProgramState for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_PROPERTY_LIST && peekedTagNumber == uint8(9): // BACnetConstructedDataPropertyList
		if _child, err = new(_BACnetConstructedDataPropertyList).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataPropertyList for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_PROPORTIONAL_CONSTANT && peekedTagNumber == uint8(4): // BACnetConstructedDataProportionalConstant
		if _child, err = new(_BACnetConstructedDataProportionalConstant).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataProportionalConstant for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_PROPORTIONAL_CONSTANT_UNITS && peekedTagNumber == uint8(9): // BACnetConstructedDataProportionalConstantUnits
		if _child, err = new(_BACnetConstructedDataProportionalConstantUnits).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataProportionalConstantUnits for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_PROTOCOL_LEVEL && peekedTagNumber == uint8(9): // BACnetConstructedDataProtocolLevel
		if _child, err = new(_BACnetConstructedDataProtocolLevel).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataProtocolLevel for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_PROTOCOL_OBJECT_TYPES_SUPPORTED && peekedTagNumber == uint8(8): // BACnetConstructedDataProtocolObjectTypesSupported
		if _child, err = new(_BACnetConstructedDataProtocolObjectTypesSupported).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataProtocolObjectTypesSupported for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_PROTOCOL_REVISION && peekedTagNumber == uint8(2): // BACnetConstructedDataProtocolRevision
		if _child, err = new(_BACnetConstructedDataProtocolRevision).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataProtocolRevision for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_PROTOCOL_SERVICES_SUPPORTED && peekedTagNumber == uint8(8): // BACnetConstructedDataProtocolServicesSupported
		if _child, err = new(_BACnetConstructedDataProtocolServicesSupported).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataProtocolServicesSupported for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_PROTOCOL_VERSION && peekedTagNumber == uint8(2): // BACnetConstructedDataProtocolVersion
		if _child, err = new(_BACnetConstructedDataProtocolVersion).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataProtocolVersion for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_PULSE_RATE && peekedTagNumber == uint8(2): // BACnetConstructedDataPulseRate
		if _child, err = new(_BACnetConstructedDataPulseRate).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataPulseRate for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_READ_ONLY && peekedTagNumber == uint8(1): // BACnetConstructedDataReadOnly
		if _child, err = new(_BACnetConstructedDataReadOnly).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataReadOnly for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_REASON_FOR_DISABLE && peekedTagNumber == uint8(9): // BACnetConstructedDataReasonForDisable
		if _child, err = new(_BACnetConstructedDataReasonForDisable).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataReasonForDisable for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_REASON_FOR_HALT && peekedTagNumber == uint8(9): // BACnetConstructedDataReasonForHalt
		if _child, err = new(_BACnetConstructedDataReasonForHalt).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataReasonForHalt for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_RECIPIENT_LIST: // BACnetConstructedDataRecipientList
		if _child, err = new(_BACnetConstructedDataRecipientList).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataRecipientList for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_FILE && propertyIdentifierArgument == BACnetPropertyIdentifier_RECORD_COUNT && peekedTagNumber == uint8(2): // BACnetConstructedDataFileRecordCount
		if _child, err = new(_BACnetConstructedDataFileRecordCount).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataFileRecordCount for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_RECORD_COUNT && peekedTagNumber == uint8(2): // BACnetConstructedDataRecordCount
		if _child, err = new(_BACnetConstructedDataRecordCount).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataRecordCount for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_RECORDS_SINCE_NOTIFICATION && peekedTagNumber == uint8(2): // BACnetConstructedDataRecordsSinceNotification
		if _child, err = new(_BACnetConstructedDataRecordsSinceNotification).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataRecordsSinceNotification for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_REFERENCE_PORT && peekedTagNumber == uint8(2): // BACnetConstructedDataReferencePort
		if _child, err = new(_BACnetConstructedDataReferencePort).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataReferencePort for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_REGISTERED_CAR_CALL: // BACnetConstructedDataRegisteredCarCall
		if _child, err = new(_BACnetConstructedDataRegisteredCarCall).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataRegisteredCarCall for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_RELIABILITY && peekedTagNumber == uint8(9): // BACnetConstructedDataReliability
		if _child, err = new(_BACnetConstructedDataReliability).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataReliability for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_RELIABILITY_EVALUATION_INHIBIT && peekedTagNumber == uint8(1): // BACnetConstructedDataReliabilityEvaluationInhibit
		if _child, err = new(_BACnetConstructedDataReliabilityEvaluationInhibit).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataReliabilityEvaluationInhibit for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_ACCESS_DOOR && propertyIdentifierArgument == BACnetPropertyIdentifier_RELINQUISH_DEFAULT && peekedTagNumber == uint8(9): // BACnetConstructedDataAccessDoorRelinquishDefault
		if _child, err = new(_BACnetConstructedDataAccessDoorRelinquishDefault).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataAccessDoorRelinquishDefault for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_ANALOG_OUTPUT && propertyIdentifierArgument == BACnetPropertyIdentifier_RELINQUISH_DEFAULT && peekedTagNumber == uint8(4): // BACnetConstructedDataAnalogOutputRelinquishDefault
		if _child, err = new(_BACnetConstructedDataAnalogOutputRelinquishDefault).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataAnalogOutputRelinquishDefault for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_ANALOG_VALUE && propertyIdentifierArgument == BACnetPropertyIdentifier_RELINQUISH_DEFAULT && peekedTagNumber == uint8(4): // BACnetConstructedDataAnalogValueRelinquishDefault
		if _child, err = new(_BACnetConstructedDataAnalogValueRelinquishDefault).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataAnalogValueRelinquishDefault for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_BINARY_OUTPUT && propertyIdentifierArgument == BACnetPropertyIdentifier_RELINQUISH_DEFAULT && peekedTagNumber == uint8(9): // BACnetConstructedDataBinaryOutputRelinquishDefault
		if _child, err = new(_BACnetConstructedDataBinaryOutputRelinquishDefault).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataBinaryOutputRelinquishDefault for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_BINARY_VALUE && propertyIdentifierArgument == BACnetPropertyIdentifier_RELINQUISH_DEFAULT && peekedTagNumber == uint8(9): // BACnetConstructedDataBinaryValueRelinquishDefault
		if _child, err = new(_BACnetConstructedDataBinaryValueRelinquishDefault).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataBinaryValueRelinquishDefault for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_BINARY_LIGHTING_OUTPUT && propertyIdentifierArgument == BACnetPropertyIdentifier_RELINQUISH_DEFAULT && peekedTagNumber == uint8(9): // BACnetConstructedDataBinaryLightingOutputRelinquishDefault
		if _child, err = new(_BACnetConstructedDataBinaryLightingOutputRelinquishDefault).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataBinaryLightingOutputRelinquishDefault for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_BITSTRING_VALUE && propertyIdentifierArgument == BACnetPropertyIdentifier_RELINQUISH_DEFAULT && peekedTagNumber == uint8(8): // BACnetConstructedDataBitStringValueRelinquishDefault
		if _child, err = new(_BACnetConstructedDataBitStringValueRelinquishDefault).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataBitStringValueRelinquishDefault for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_CHARACTERSTRING_VALUE && propertyIdentifierArgument == BACnetPropertyIdentifier_RELINQUISH_DEFAULT && peekedTagNumber == uint8(7): // BACnetConstructedDataCharacterStringValueRelinquishDefault
		if _child, err = new(_BACnetConstructedDataCharacterStringValueRelinquishDefault).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataCharacterStringValueRelinquishDefault for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_DATE_VALUE && propertyIdentifierArgument == BACnetPropertyIdentifier_RELINQUISH_DEFAULT && peekedTagNumber == uint8(10): // BACnetConstructedDataDateValueRelinquishDefault
		if _child, err = new(_BACnetConstructedDataDateValueRelinquishDefault).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataDateValueRelinquishDefault for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_DATEPATTERN_VALUE && propertyIdentifierArgument == BACnetPropertyIdentifier_RELINQUISH_DEFAULT && peekedTagNumber == uint8(10): // BACnetConstructedDataDatePatternValueRelinquishDefault
		if _child, err = new(_BACnetConstructedDataDatePatternValueRelinquishDefault).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataDatePatternValueRelinquishDefault for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_DATETIME_VALUE && propertyIdentifierArgument == BACnetPropertyIdentifier_RELINQUISH_DEFAULT: // BACnetConstructedDataDateTimeValueRelinquishDefault
		if _child, err = new(_BACnetConstructedDataDateTimeValueRelinquishDefault).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataDateTimeValueRelinquishDefault for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_DATETIMEPATTERN_VALUE && propertyIdentifierArgument == BACnetPropertyIdentifier_RELINQUISH_DEFAULT: // BACnetConstructedDataDateTimePatternValueRelinquishDefault
		if _child, err = new(_BACnetConstructedDataDateTimePatternValueRelinquishDefault).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataDateTimePatternValueRelinquishDefault for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_LARGE_ANALOG_VALUE && propertyIdentifierArgument == BACnetPropertyIdentifier_RELINQUISH_DEFAULT && peekedTagNumber == uint8(5): // BACnetConstructedDataLargeAnalogValueRelinquishDefault
		if _child, err = new(_BACnetConstructedDataLargeAnalogValueRelinquishDefault).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataLargeAnalogValueRelinquishDefault for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_LIGHTING_OUTPUT && propertyIdentifierArgument == BACnetPropertyIdentifier_RELINQUISH_DEFAULT && peekedTagNumber == uint8(4): // BACnetConstructedDataLightingOutputRelinquishDefault
		if _child, err = new(_BACnetConstructedDataLightingOutputRelinquishDefault).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataLightingOutputRelinquishDefault for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_TIMEPATTERN_VALUE && propertyIdentifierArgument == BACnetPropertyIdentifier_RELINQUISH_DEFAULT && peekedTagNumber == uint8(11): // BACnetConstructedDataTimePatternValueRelinquishDefault
		if _child, err = new(_BACnetConstructedDataTimePatternValueRelinquishDefault).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataTimePatternValueRelinquishDefault for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_TIME_VALUE && propertyIdentifierArgument == BACnetPropertyIdentifier_RELINQUISH_DEFAULT && peekedTagNumber == uint8(11): // BACnetConstructedDataTimeValueRelinquishDefault
		if _child, err = new(_BACnetConstructedDataTimeValueRelinquishDefault).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataTimeValueRelinquishDefault for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_INTEGER_VALUE && propertyIdentifierArgument == BACnetPropertyIdentifier_RELINQUISH_DEFAULT && peekedTagNumber == uint8(3): // BACnetConstructedDataIntegerValueRelinquishDefault
		if _child, err = new(_BACnetConstructedDataIntegerValueRelinquishDefault).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataIntegerValueRelinquishDefault for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_OCTETSTRING_VALUE && propertyIdentifierArgument == BACnetPropertyIdentifier_RELINQUISH_DEFAULT && peekedTagNumber == uint8(6): // BACnetConstructedDataOctetStringValueRelinquishDefault
		if _child, err = new(_BACnetConstructedDataOctetStringValueRelinquishDefault).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataOctetStringValueRelinquishDefault for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_POSITIVE_INTEGER_VALUE && propertyIdentifierArgument == BACnetPropertyIdentifier_RELINQUISH_DEFAULT && peekedTagNumber == uint8(2): // BACnetConstructedDataPositiveIntegerValueRelinquishDefault
		if _child, err = new(_BACnetConstructedDataPositiveIntegerValueRelinquishDefault).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataPositiveIntegerValueRelinquishDefault for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_MULTI_STATE_OUTPUT && propertyIdentifierArgument == BACnetPropertyIdentifier_RELINQUISH_DEFAULT && peekedTagNumber == uint8(2): // BACnetConstructedDataMultiStateOutputRelinquishDefault
		if _child, err = new(_BACnetConstructedDataMultiStateOutputRelinquishDefault).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataMultiStateOutputRelinquishDefault for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_MULTI_STATE_VALUE && propertyIdentifierArgument == BACnetPropertyIdentifier_RELINQUISH_DEFAULT && peekedTagNumber == uint8(2): // BACnetConstructedDataMultiStateValueRelinquishDefault
		if _child, err = new(_BACnetConstructedDataMultiStateValueRelinquishDefault).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataMultiStateValueRelinquishDefault for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_RELINQUISH_DEFAULT && peekedTagNumber == uint8(2): // BACnetConstructedDataRelinquishDefault
		if _child, err = new(_BACnetConstructedDataRelinquishDefault).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataRelinquishDefault for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_REPRESENTS: // BACnetConstructedDataRepresents
		if _child, err = new(_BACnetConstructedDataRepresents).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataRepresents for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_REQUESTED_SHED_LEVEL: // BACnetConstructedDataRequestedShedLevel
		if _child, err = new(_BACnetConstructedDataRequestedShedLevel).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataRequestedShedLevel for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_REQUESTED_UPDATE_INTERVAL && peekedTagNumber == uint8(2): // BACnetConstructedDataRequestedUpdateInterval
		if _child, err = new(_BACnetConstructedDataRequestedUpdateInterval).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataRequestedUpdateInterval for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_REQUIRED: // BACnetConstructedDataRequired
		if _child, err = new(_BACnetConstructedDataRequired).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataRequired for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_LARGE_ANALOG_VALUE && propertyIdentifierArgument == BACnetPropertyIdentifier_RESOLUTION && peekedTagNumber == uint8(5): // BACnetConstructedDataLargeAnalogValueResolution
		if _child, err = new(_BACnetConstructedDataLargeAnalogValueResolution).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataLargeAnalogValueResolution for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_INTEGER_VALUE && propertyIdentifierArgument == BACnetPropertyIdentifier_RESOLUTION && peekedTagNumber == uint8(3): // BACnetConstructedDataIntegerValueResolution
		if _child, err = new(_BACnetConstructedDataIntegerValueResolution).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataIntegerValueResolution for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_POSITIVE_INTEGER_VALUE && propertyIdentifierArgument == BACnetPropertyIdentifier_RESOLUTION && peekedTagNumber == uint8(2): // BACnetConstructedDataPositiveIntegerValueResolution
		if _child, err = new(_BACnetConstructedDataPositiveIntegerValueResolution).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataPositiveIntegerValueResolution for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_TIMER && propertyIdentifierArgument == BACnetPropertyIdentifier_RESOLUTION && peekedTagNumber == uint8(2): // BACnetConstructedDataTimerResolution
		if _child, err = new(_BACnetConstructedDataTimerResolution).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataTimerResolution for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_RESOLUTION && peekedTagNumber == uint8(4): // BACnetConstructedDataResolution
		if _child, err = new(_BACnetConstructedDataResolution).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataResolution for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_RESTART_NOTIFICATION_RECIPIENTS: // BACnetConstructedDataRestartNotificationRecipients
		if _child, err = new(_BACnetConstructedDataRestartNotificationRecipients).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataRestartNotificationRecipients for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_RESTORE_COMPLETION_TIME && peekedTagNumber == uint8(2): // BACnetConstructedDataRestoreCompletionTime
		if _child, err = new(_BACnetConstructedDataRestoreCompletionTime).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataRestoreCompletionTime for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_RESTORE_PREPARATION_TIME && peekedTagNumber == uint8(2): // BACnetConstructedDataRestorePreparationTime
		if _child, err = new(_BACnetConstructedDataRestorePreparationTime).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataRestorePreparationTime for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_ROUTING_TABLE: // BACnetConstructedDataRoutingTable
		if _child, err = new(_BACnetConstructedDataRoutingTable).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataRoutingTable for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_SCALE: // BACnetConstructedDataScale
		if _child, err = new(_BACnetConstructedDataScale).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataScale for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_SCALE_FACTOR && peekedTagNumber == uint8(4): // BACnetConstructedDataScaleFactor
		if _child, err = new(_BACnetConstructedDataScaleFactor).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataScaleFactor for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_SCHEDULE_DEFAULT: // BACnetConstructedDataScheduleDefault
		if _child, err = new(_BACnetConstructedDataScheduleDefault).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataScheduleDefault for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_SECURED_STATUS && peekedTagNumber == uint8(9): // BACnetConstructedDataSecuredStatus
		if _child, err = new(_BACnetConstructedDataSecuredStatus).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataSecuredStatus for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_SECURITY_PDU_TIMEOUT && peekedTagNumber == uint8(2): // BACnetConstructedDataSecurityPDUTimeout
		if _child, err = new(_BACnetConstructedDataSecurityPDUTimeout).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataSecurityPDUTimeout for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_SECURITY_TIME_WINDOW && peekedTagNumber == uint8(2): // BACnetConstructedDataSecurityTimeWindow
		if _child, err = new(_BACnetConstructedDataSecurityTimeWindow).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataSecurityTimeWindow for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_SEGMENTATION_SUPPORTED && peekedTagNumber == uint8(9): // BACnetConstructedDataSegmentationSupported
		if _child, err = new(_BACnetConstructedDataSegmentationSupported).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataSegmentationSupported for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_SERIAL_NUMBER && peekedTagNumber == uint8(7): // BACnetConstructedDataSerialNumber
		if _child, err = new(_BACnetConstructedDataSerialNumber).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataSerialNumber for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_SETPOINT && peekedTagNumber == uint8(4): // BACnetConstructedDataSetpoint
		if _child, err = new(_BACnetConstructedDataSetpoint).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataSetpoint for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_SETPOINT_REFERENCE: // BACnetConstructedDataSetpointReference
		if _child, err = new(_BACnetConstructedDataSetpointReference).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataSetpointReference for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_SETTING && peekedTagNumber == uint8(2): // BACnetConstructedDataSetting
		if _child, err = new(_BACnetConstructedDataSetting).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataSetting for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_SHED_DURATION && peekedTagNumber == uint8(2): // BACnetConstructedDataShedDuration
		if _child, err = new(_BACnetConstructedDataShedDuration).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataShedDuration for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_SHED_LEVEL_DESCRIPTIONS && peekedTagNumber == uint8(7): // BACnetConstructedDataShedLevelDescriptions
		if _child, err = new(_BACnetConstructedDataShedLevelDescriptions).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataShedLevelDescriptions for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_SHED_LEVELS && peekedTagNumber == uint8(2): // BACnetConstructedDataShedLevels
		if _child, err = new(_BACnetConstructedDataShedLevels).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataShedLevels for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_SILENCED && peekedTagNumber == uint8(9): // BACnetConstructedDataSilenced
		if _child, err = new(_BACnetConstructedDataSilenced).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataSilenced for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_SLAVE_ADDRESS_BINDING: // BACnetConstructedDataSlaveAddressBinding
		if _child, err = new(_BACnetConstructedDataSlaveAddressBinding).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataSlaveAddressBinding for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_SLAVE_PROXY_ENABLE && peekedTagNumber == uint8(1): // BACnetConstructedDataSlaveProxyEnable
		if _child, err = new(_BACnetConstructedDataSlaveProxyEnable).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataSlaveProxyEnable for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_START_TIME: // BACnetConstructedDataStartTime
		if _child, err = new(_BACnetConstructedDataStartTime).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataStartTime for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_STATE_CHANGE_VALUES: // BACnetConstructedDataStateChangeValues
		if _child, err = new(_BACnetConstructedDataStateChangeValues).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataStateChangeValues for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_STATE_DESCRIPTION && peekedTagNumber == uint8(7): // BACnetConstructedDataStateDescription
		if _child, err = new(_BACnetConstructedDataStateDescription).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataStateDescription for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_STATE_TEXT && peekedTagNumber == uint8(7): // BACnetConstructedDataStateText
		if _child, err = new(_BACnetConstructedDataStateText).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataStateText for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_STATUS_FLAGS && peekedTagNumber == uint8(8): // BACnetConstructedDataStatusFlags
		if _child, err = new(_BACnetConstructedDataStatusFlags).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataStatusFlags for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_STOP_TIME: // BACnetConstructedDataStopTime
		if _child, err = new(_BACnetConstructedDataStopTime).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataStopTime for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_STOP_WHEN_FULL && peekedTagNumber == uint8(1): // BACnetConstructedDataStopWhenFull
		if _child, err = new(_BACnetConstructedDataStopWhenFull).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataStopWhenFull for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_STRIKE_COUNT && peekedTagNumber == uint8(2): // BACnetConstructedDataStrikeCount
		if _child, err = new(_BACnetConstructedDataStrikeCount).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataStrikeCount for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_STRUCTURED_OBJECT_LIST: // BACnetConstructedDataStructuredObjectList
		if _child, err = new(_BACnetConstructedDataStructuredObjectList).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataStructuredObjectList for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_SUBORDINATE_ANNOTATIONS: // BACnetConstructedDataSubordinateAnnotations
		if _child, err = new(_BACnetConstructedDataSubordinateAnnotations).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataSubordinateAnnotations for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_SUBORDINATE_LIST: // BACnetConstructedDataSubordinateList
		if _child, err = new(_BACnetConstructedDataSubordinateList).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataSubordinateList for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_SUBORDINATE_NODE_TYPES && peekedTagNumber == uint8(9): // BACnetConstructedDataSubordinateNodeTypes
		if _child, err = new(_BACnetConstructedDataSubordinateNodeTypes).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataSubordinateNodeTypes for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_SUBORDINATE_RELATIONSHIPS && peekedTagNumber == uint8(9): // BACnetConstructedDataSubordinateRelationships
		if _child, err = new(_BACnetConstructedDataSubordinateRelationships).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataSubordinateRelationships for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_SUBORDINATE_TAGS: // BACnetConstructedDataSubordinateTags
		if _child, err = new(_BACnetConstructedDataSubordinateTags).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataSubordinateTags for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_SUBSCRIBED_RECIPIENTS: // BACnetConstructedDataSubscribedRecipients
		if _child, err = new(_BACnetConstructedDataSubscribedRecipients).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataSubscribedRecipients for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_SUPPORTED_FORMAT_CLASSES: // BACnetConstructedDataSupportedFormatClasses
		if _child, err = new(_BACnetConstructedDataSupportedFormatClasses).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataSupportedFormatClasses for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_SUPPORTED_FORMATS: // BACnetConstructedDataSupportedFormats
		if _child, err = new(_BACnetConstructedDataSupportedFormats).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataSupportedFormats for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_SUPPORTED_SECURITY_ALGORITHMS: // BACnetConstructedDataSupportedSecurityAlgorithms
		if _child, err = new(_BACnetConstructedDataSupportedSecurityAlgorithms).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataSupportedSecurityAlgorithms for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_SYSTEM_STATUS && peekedTagNumber == uint8(9): // BACnetConstructedDataSystemStatus
		if _child, err = new(_BACnetConstructedDataSystemStatus).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataSystemStatus for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_TAGS: // BACnetConstructedDataTags
		if _child, err = new(_BACnetConstructedDataTags).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataTags for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_THREAT_AUTHORITY: // BACnetConstructedDataThreatAuthority
		if _child, err = new(_BACnetConstructedDataThreatAuthority).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataThreatAuthority for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_THREAT_LEVEL: // BACnetConstructedDataThreatLevel
		if _child, err = new(_BACnetConstructedDataThreatLevel).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataThreatLevel for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_TIME_DELAY && peekedTagNumber == uint8(2): // BACnetConstructedDataTimeDelay
		if _child, err = new(_BACnetConstructedDataTimeDelay).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataTimeDelay for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_TIME_DELAY_NORMAL && peekedTagNumber == uint8(2): // BACnetConstructedDataTimeDelayNormal
		if _child, err = new(_BACnetConstructedDataTimeDelayNormal).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataTimeDelayNormal for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_TIME_OF_ACTIVE_TIME_RESET: // BACnetConstructedDataTimeOfActiveTimeReset
		if _child, err = new(_BACnetConstructedDataTimeOfActiveTimeReset).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataTimeOfActiveTimeReset for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_TIME_OF_DEVICE_RESTART: // BACnetConstructedDataTimeOfDeviceRestart
		if _child, err = new(_BACnetConstructedDataTimeOfDeviceRestart).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataTimeOfDeviceRestart for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_TIME_OF_STATE_COUNT_RESET: // BACnetConstructedDataTimeOfStateCountReset
		if _child, err = new(_BACnetConstructedDataTimeOfStateCountReset).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataTimeOfStateCountReset for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_TIME_OF_STRIKE_COUNT_RESET: // BACnetConstructedDataTimeOfStrikeCountReset
		if _child, err = new(_BACnetConstructedDataTimeOfStrikeCountReset).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataTimeOfStrikeCountReset for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_TIME_SYNCHRONIZATION_INTERVAL && peekedTagNumber == uint8(2): // BACnetConstructedDataTimeSynchronizationInterval
		if _child, err = new(_BACnetConstructedDataTimeSynchronizationInterval).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataTimeSynchronizationInterval for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_TIME_SYNCHRONIZATION_RECIPIENTS: // BACnetConstructedDataTimeSynchronizationRecipients
		if _child, err = new(_BACnetConstructedDataTimeSynchronizationRecipients).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataTimeSynchronizationRecipients for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_TIMER_RUNNING && peekedTagNumber == uint8(1): // BACnetConstructedDataTimerRunning
		if _child, err = new(_BACnetConstructedDataTimerRunning).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataTimerRunning for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_TIMER_STATE && peekedTagNumber == uint8(9): // BACnetConstructedDataTimerState
		if _child, err = new(_BACnetConstructedDataTimerState).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataTimerState for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_TOTAL_RECORD_COUNT && peekedTagNumber == uint8(2): // BACnetConstructedDataTotalRecordCount
		if _child, err = new(_BACnetConstructedDataTotalRecordCount).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataTotalRecordCount for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_TRACE_FLAG && peekedTagNumber == uint8(1): // BACnetConstructedDataTraceFlag
		if _child, err = new(_BACnetConstructedDataTraceFlag).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataTraceFlag for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_LIGHTING_OUTPUT && propertyIdentifierArgument == BACnetPropertyIdentifier_TRACKING_VALUE && peekedTagNumber == uint8(4): // BACnetConstructedDataLightingOutputTrackingValue
		if _child, err = new(_BACnetConstructedDataLightingOutputTrackingValue).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataLightingOutputTrackingValue for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_TRACKING_VALUE && peekedTagNumber == uint8(9): // BACnetConstructedDataTrackingValue
		if _child, err = new(_BACnetConstructedDataTrackingValue).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataTrackingValue for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_TRANSACTION_NOTIFICATION_CLASS && peekedTagNumber == uint8(2): // BACnetConstructedDataTransactionNotificationClass
		if _child, err = new(_BACnetConstructedDataTransactionNotificationClass).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataTransactionNotificationClass for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_TRANSITION && peekedTagNumber == uint8(9): // BACnetConstructedDataTransition
		if _child, err = new(_BACnetConstructedDataTransition).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataTransition for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_TRIGGER && peekedTagNumber == uint8(1): // BACnetConstructedDataTrigger
		if _child, err = new(_BACnetConstructedDataTrigger).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataTrigger for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_UNITS && peekedTagNumber == uint8(9): // BACnetConstructedDataUnits
		if _child, err = new(_BACnetConstructedDataUnits).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataUnits for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_UPDATE_INTERVAL && peekedTagNumber == uint8(2): // BACnetConstructedDataUpdateInterval
		if _child, err = new(_BACnetConstructedDataUpdateInterval).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataUpdateInterval for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_UPDATE_KEY_SET_TIMEOUT && peekedTagNumber == uint8(2): // BACnetConstructedDataUpdateKeySetTimeout
		if _child, err = new(_BACnetConstructedDataUpdateKeySetTimeout).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataUpdateKeySetTimeout for type-switch of BACnetConstructedData")
		}
	case objectTypeArgument == BACnetObjectType_CREDENTIAL_DATA_INPUT && propertyIdentifierArgument == BACnetPropertyIdentifier_UPDATE_TIME: // BACnetConstructedDataCredentialDataInputUpdateTime
		if _child, err = new(_BACnetConstructedDataCredentialDataInputUpdateTime).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataCredentialDataInputUpdateTime for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_UPDATE_TIME: // BACnetConstructedDataUpdateTime
		if _child, err = new(_BACnetConstructedDataUpdateTime).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataUpdateTime for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_USER_EXTERNAL_IDENTIFIER && peekedTagNumber == uint8(7): // BACnetConstructedDataUserExternalIdentifier
		if _child, err = new(_BACnetConstructedDataUserExternalIdentifier).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataUserExternalIdentifier for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_USER_INFORMATION_REFERENCE && peekedTagNumber == uint8(7): // BACnetConstructedDataUserInformationReference
		if _child, err = new(_BACnetConstructedDataUserInformationReference).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataUserInformationReference for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_USER_NAME && peekedTagNumber == uint8(7): // BACnetConstructedDataUserName
		if _child, err = new(_BACnetConstructedDataUserName).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataUserName for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_USER_TYPE && peekedTagNumber == uint8(9): // BACnetConstructedDataUserType
		if _child, err = new(_BACnetConstructedDataUserType).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataUserType for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_USES_REMAINING && peekedTagNumber == uint8(3): // BACnetConstructedDataUsesRemaining
		if _child, err = new(_BACnetConstructedDataUsesRemaining).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataUsesRemaining for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_UTC_OFFSET && peekedTagNumber == uint8(3): // BACnetConstructedDataUTCOffset
		if _child, err = new(_BACnetConstructedDataUTCOffset).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataUTCOffset for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_UTC_TIME_SYNCHRONIZATION_RECIPIENTS: // BACnetConstructedDataUTCTimeSynchronizationRecipients
		if _child, err = new(_BACnetConstructedDataUTCTimeSynchronizationRecipients).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataUTCTimeSynchronizationRecipients for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_VALID_SAMPLES && peekedTagNumber == uint8(2): // BACnetConstructedDataValidSamples
		if _child, err = new(_BACnetConstructedDataValidSamples).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataValidSamples for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_VALUE_BEFORE_CHANGE && peekedTagNumber == uint8(2): // BACnetConstructedDataValueBeforeChange
		if _child, err = new(_BACnetConstructedDataValueBeforeChange).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataValueBeforeChange for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_VALUE_CHANGE_TIME: // BACnetConstructedDataValueChangeTime
		if _child, err = new(_BACnetConstructedDataValueChangeTime).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataValueChangeTime for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_VALUE_SET && peekedTagNumber == uint8(2): // BACnetConstructedDataValueSet
		if _child, err = new(_BACnetConstructedDataValueSet).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataValueSet for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_VALUE_SOURCE: // BACnetConstructedDataValueSource
		if _child, err = new(_BACnetConstructedDataValueSource).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataValueSource for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_VALUE_SOURCE_ARRAY: // BACnetConstructedDataValueSourceArray
		if _child, err = new(_BACnetConstructedDataValueSourceArray).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataValueSourceArray for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_VARIANCE_VALUE && peekedTagNumber == uint8(4): // BACnetConstructedDataVarianceValue
		if _child, err = new(_BACnetConstructedDataVarianceValue).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataVarianceValue for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_VENDOR_IDENTIFIER && peekedTagNumber == uint8(2): // BACnetConstructedDataVendorIdentifier
		if _child, err = new(_BACnetConstructedDataVendorIdentifier).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataVendorIdentifier for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_VENDOR_NAME && peekedTagNumber == uint8(7): // BACnetConstructedDataVendorName
		if _child, err = new(_BACnetConstructedDataVendorName).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataVendorName for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_VERIFICATION_TIME && peekedTagNumber == uint8(3): // BACnetConstructedDataVerificationTime
		if _child, err = new(_BACnetConstructedDataVerificationTime).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataVerificationTime for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_VIRTUAL_MAC_ADDRESS_TABLE: // BACnetConstructedDataVirtualMACAddressTable
		if _child, err = new(_BACnetConstructedDataVirtualMACAddressTable).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataVirtualMACAddressTable for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_VT_CLASSES_SUPPORTED && peekedTagNumber == uint8(9): // BACnetConstructedDataVTClassesSupported
		if _child, err = new(_BACnetConstructedDataVTClassesSupported).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataVTClassesSupported for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_WEEKLY_SCHEDULE: // BACnetConstructedDataWeeklySchedule
		if _child, err = new(_BACnetConstructedDataWeeklySchedule).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataWeeklySchedule for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_WINDOW_INTERVAL && peekedTagNumber == uint8(2): // BACnetConstructedDataWindowInterval
		if _child, err = new(_BACnetConstructedDataWindowInterval).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataWindowInterval for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_WINDOW_SAMPLES && peekedTagNumber == uint8(2): // BACnetConstructedDataWindowSamples
		if _child, err = new(_BACnetConstructedDataWindowSamples).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataWindowSamples for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_WRITE_STATUS && peekedTagNumber == uint8(9): // BACnetConstructedDataWriteStatus
		if _child, err = new(_BACnetConstructedDataWriteStatus).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataWriteStatus for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_ZONE_FROM: // BACnetConstructedDataZoneFrom
		if _child, err = new(_BACnetConstructedDataZoneFrom).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataZoneFrom for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_ZONE_MEMBERS: // BACnetConstructedDataZoneMembers
		if _child, err = new(_BACnetConstructedDataZoneMembers).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataZoneMembers for type-switch of BACnetConstructedData")
		}
	case 0 == 0 && propertyIdentifierArgument == BACnetPropertyIdentifier_ZONE_TO: // BACnetConstructedDataZoneTo
		if _child, err = new(_BACnetConstructedDataZoneTo).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataZoneTo for type-switch of BACnetConstructedData")
		}
	case 0 == 0: // BACnetConstructedDataUnspecified
		if _child, err = new(_BACnetConstructedDataUnspecified).parse(ctx, readBuffer, m, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetConstructedDataUnspecified for type-switch of BACnetConstructedData")
		}
	default:
		return nil, errors.Errorf("Unmapped type for parameters [objectTypeArgument=%v, propertyIdentifierArgument=%v, peekedTagNumber=%v]", objectTypeArgument, propertyIdentifierArgument, peekedTagNumber)
	}

	closingTag, err := ReadSimpleField[BACnetClosingTag](ctx, "closingTag", ReadComplex[BACnetClosingTag](BACnetClosingTagParseWithBufferProducer((uint8)(tagNumber)), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'closingTag' field"))
	}
	m.ClosingTag = closingTag

	if closeErr := readBuffer.CloseContext("BACnetConstructedData"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetConstructedData")
	}

	return _child, nil
}

func (pm *_BACnetConstructedData) serializeParent(ctx context.Context, writeBuffer utils.WriteBuffer, child BACnetConstructedData, serializeChildFunction func() error) error {
	// We redirect all calls through client as some methods are only implemented there
	m := child
	_ = m
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pushErr := writeBuffer.PushContext("BACnetConstructedData"); pushErr != nil {
		return errors.Wrap(pushErr, "Error pushing for BACnetConstructedData")
	}

	if err := WriteSimpleField[BACnetOpeningTag](ctx, "openingTag", m.GetOpeningTag(), WriteComplex[BACnetOpeningTag](writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'openingTag' field")
	}
	// Virtual field
	peekedTagNumber := m.GetPeekedTagNumber()
	_ = peekedTagNumber
	if _peekedTagNumberErr := writeBuffer.WriteVirtual(ctx, "peekedTagNumber", m.GetPeekedTagNumber()); _peekedTagNumberErr != nil {
		return errors.Wrap(_peekedTagNumberErr, "Error serializing 'peekedTagNumber' field")
	}

	// Switch field (Depending on the discriminator values, passes the serialization to a sub-type)
	if _typeSwitchErr := serializeChildFunction(); _typeSwitchErr != nil {
		return errors.Wrap(_typeSwitchErr, "Error serializing sub-type field")
	}

	if err := WriteSimpleField[BACnetClosingTag](ctx, "closingTag", m.GetClosingTag(), WriteComplex[BACnetClosingTag](writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'closingTag' field")
	}

	if popErr := writeBuffer.PopContext("BACnetConstructedData"); popErr != nil {
		return errors.Wrap(popErr, "Error popping for BACnetConstructedData")
	}
	return nil
}

////
// Arguments Getter

func (m *_BACnetConstructedData) GetTagNumber() uint8 {
	return m.TagNumber
}
func (m *_BACnetConstructedData) GetArrayIndexArgument() BACnetTagPayloadUnsignedInteger {
	return m.ArrayIndexArgument
}

//
////

func (m *_BACnetConstructedData) IsBACnetConstructedData() {}

func (m *_BACnetConstructedData) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetConstructedData) deepCopy() *_BACnetConstructedData {
	if m == nil {
		return nil
	}
	_BACnetConstructedDataCopy := &_BACnetConstructedData{
		nil, // will be set by child
		utils.DeepCopy[BACnetOpeningTag](m.OpeningTag),
		utils.DeepCopy[BACnetTagHeader](m.PeekedTagHeader),
		utils.DeepCopy[BACnetClosingTag](m.ClosingTag),
		m.TagNumber,
		m.ArrayIndexArgument,
	}
	return _BACnetConstructedDataCopy
}
