/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetConfirmedServiceRequestReadRangeRangeByPosition is the corresponding interface of BACnetConfirmedServiceRequestReadRangeRangeByPosition
type BACnetConfirmedServiceRequestReadRangeRangeByPosition interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetConfirmedServiceRequestReadRangeRange
	// GetReferenceIndex returns ReferenceIndex (property field)
	GetReferenceIndex() BACnetApplicationTagUnsignedInteger
	// GetCount returns Count (property field)
	GetCount() BACnetApplicationTagSignedInteger
	// IsBACnetConfirmedServiceRequestReadRangeRangeByPosition is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetConfirmedServiceRequestReadRangeRangeByPosition()
	// CreateBuilder creates a BACnetConfirmedServiceRequestReadRangeRangeByPositionBuilder
	CreateBACnetConfirmedServiceRequestReadRangeRangeByPositionBuilder() BACnetConfirmedServiceRequestReadRangeRangeByPositionBuilder
}

// _BACnetConfirmedServiceRequestReadRangeRangeByPosition is the data-structure of this message
type _BACnetConfirmedServiceRequestReadRangeRangeByPosition struct {
	BACnetConfirmedServiceRequestReadRangeRangeContract
	ReferenceIndex BACnetApplicationTagUnsignedInteger
	Count          BACnetApplicationTagSignedInteger
}

var _ BACnetConfirmedServiceRequestReadRangeRangeByPosition = (*_BACnetConfirmedServiceRequestReadRangeRangeByPosition)(nil)
var _ BACnetConfirmedServiceRequestReadRangeRangeRequirements = (*_BACnetConfirmedServiceRequestReadRangeRangeByPosition)(nil)

// NewBACnetConfirmedServiceRequestReadRangeRangeByPosition factory function for _BACnetConfirmedServiceRequestReadRangeRangeByPosition
func NewBACnetConfirmedServiceRequestReadRangeRangeByPosition(peekedTagHeader BACnetTagHeader, openingTag BACnetOpeningTag, closingTag BACnetClosingTag, referenceIndex BACnetApplicationTagUnsignedInteger, count BACnetApplicationTagSignedInteger) *_BACnetConfirmedServiceRequestReadRangeRangeByPosition {
	if referenceIndex == nil {
		panic("referenceIndex of type BACnetApplicationTagUnsignedInteger for BACnetConfirmedServiceRequestReadRangeRangeByPosition must not be nil")
	}
	if count == nil {
		panic("count of type BACnetApplicationTagSignedInteger for BACnetConfirmedServiceRequestReadRangeRangeByPosition must not be nil")
	}
	_result := &_BACnetConfirmedServiceRequestReadRangeRangeByPosition{
		BACnetConfirmedServiceRequestReadRangeRangeContract: NewBACnetConfirmedServiceRequestReadRangeRange(peekedTagHeader, openingTag, closingTag),
		ReferenceIndex: referenceIndex,
		Count:          count,
	}
	_result.BACnetConfirmedServiceRequestReadRangeRangeContract.(*_BACnetConfirmedServiceRequestReadRangeRange)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetConfirmedServiceRequestReadRangeRangeByPositionBuilder is a builder for BACnetConfirmedServiceRequestReadRangeRangeByPosition
type BACnetConfirmedServiceRequestReadRangeRangeByPositionBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(referenceIndex BACnetApplicationTagUnsignedInteger, count BACnetApplicationTagSignedInteger) BACnetConfirmedServiceRequestReadRangeRangeByPositionBuilder
	// WithReferenceIndex adds ReferenceIndex (property field)
	WithReferenceIndex(BACnetApplicationTagUnsignedInteger) BACnetConfirmedServiceRequestReadRangeRangeByPositionBuilder
	// WithReferenceIndexBuilder adds ReferenceIndex (property field) which is build by the builder
	WithReferenceIndexBuilder(func(BACnetApplicationTagUnsignedIntegerBuilder) BACnetApplicationTagUnsignedIntegerBuilder) BACnetConfirmedServiceRequestReadRangeRangeByPositionBuilder
	// WithCount adds Count (property field)
	WithCount(BACnetApplicationTagSignedInteger) BACnetConfirmedServiceRequestReadRangeRangeByPositionBuilder
	// WithCountBuilder adds Count (property field) which is build by the builder
	WithCountBuilder(func(BACnetApplicationTagSignedIntegerBuilder) BACnetApplicationTagSignedIntegerBuilder) BACnetConfirmedServiceRequestReadRangeRangeByPositionBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetConfirmedServiceRequestReadRangeRangeBuilder
	// Build builds the BACnetConfirmedServiceRequestReadRangeRangeByPosition or returns an error if something is wrong
	Build() (BACnetConfirmedServiceRequestReadRangeRangeByPosition, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetConfirmedServiceRequestReadRangeRangeByPosition
}

// NewBACnetConfirmedServiceRequestReadRangeRangeByPositionBuilder() creates a BACnetConfirmedServiceRequestReadRangeRangeByPositionBuilder
func NewBACnetConfirmedServiceRequestReadRangeRangeByPositionBuilder() BACnetConfirmedServiceRequestReadRangeRangeByPositionBuilder {
	return &_BACnetConfirmedServiceRequestReadRangeRangeByPositionBuilder{_BACnetConfirmedServiceRequestReadRangeRangeByPosition: new(_BACnetConfirmedServiceRequestReadRangeRangeByPosition)}
}

type _BACnetConfirmedServiceRequestReadRangeRangeByPositionBuilder struct {
	*_BACnetConfirmedServiceRequestReadRangeRangeByPosition

	parentBuilder *_BACnetConfirmedServiceRequestReadRangeRangeBuilder

	err *utils.MultiError
}

var _ (BACnetConfirmedServiceRequestReadRangeRangeByPositionBuilder) = (*_BACnetConfirmedServiceRequestReadRangeRangeByPositionBuilder)(nil)

func (b *_BACnetConfirmedServiceRequestReadRangeRangeByPositionBuilder) setParent(contract BACnetConfirmedServiceRequestReadRangeRangeContract) {
	b.BACnetConfirmedServiceRequestReadRangeRangeContract = contract
	contract.(*_BACnetConfirmedServiceRequestReadRangeRange)._SubType = b._BACnetConfirmedServiceRequestReadRangeRangeByPosition
}

func (b *_BACnetConfirmedServiceRequestReadRangeRangeByPositionBuilder) WithMandatoryFields(referenceIndex BACnetApplicationTagUnsignedInteger, count BACnetApplicationTagSignedInteger) BACnetConfirmedServiceRequestReadRangeRangeByPositionBuilder {
	return b.WithReferenceIndex(referenceIndex).WithCount(count)
}

func (b *_BACnetConfirmedServiceRequestReadRangeRangeByPositionBuilder) WithReferenceIndex(referenceIndex BACnetApplicationTagUnsignedInteger) BACnetConfirmedServiceRequestReadRangeRangeByPositionBuilder {
	b.ReferenceIndex = referenceIndex
	return b
}

func (b *_BACnetConfirmedServiceRequestReadRangeRangeByPositionBuilder) WithReferenceIndexBuilder(builderSupplier func(BACnetApplicationTagUnsignedIntegerBuilder) BACnetApplicationTagUnsignedIntegerBuilder) BACnetConfirmedServiceRequestReadRangeRangeByPositionBuilder {
	builder := builderSupplier(b.ReferenceIndex.CreateBACnetApplicationTagUnsignedIntegerBuilder())
	var err error
	b.ReferenceIndex, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "BACnetApplicationTagUnsignedIntegerBuilder failed"))
	}
	return b
}

func (b *_BACnetConfirmedServiceRequestReadRangeRangeByPositionBuilder) WithCount(count BACnetApplicationTagSignedInteger) BACnetConfirmedServiceRequestReadRangeRangeByPositionBuilder {
	b.Count = count
	return b
}

func (b *_BACnetConfirmedServiceRequestReadRangeRangeByPositionBuilder) WithCountBuilder(builderSupplier func(BACnetApplicationTagSignedIntegerBuilder) BACnetApplicationTagSignedIntegerBuilder) BACnetConfirmedServiceRequestReadRangeRangeByPositionBuilder {
	builder := builderSupplier(b.Count.CreateBACnetApplicationTagSignedIntegerBuilder())
	var err error
	b.Count, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "BACnetApplicationTagSignedIntegerBuilder failed"))
	}
	return b
}

func (b *_BACnetConfirmedServiceRequestReadRangeRangeByPositionBuilder) Build() (BACnetConfirmedServiceRequestReadRangeRangeByPosition, error) {
	if b.ReferenceIndex == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'referenceIndex' not set"))
	}
	if b.Count == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'count' not set"))
	}
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._BACnetConfirmedServiceRequestReadRangeRangeByPosition.deepCopy(), nil
}

func (b *_BACnetConfirmedServiceRequestReadRangeRangeByPositionBuilder) MustBuild() BACnetConfirmedServiceRequestReadRangeRangeByPosition {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetConfirmedServiceRequestReadRangeRangeByPositionBuilder) Done() BACnetConfirmedServiceRequestReadRangeRangeBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetConfirmedServiceRequestReadRangeRangeBuilder().(*_BACnetConfirmedServiceRequestReadRangeRangeBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetConfirmedServiceRequestReadRangeRangeByPositionBuilder) buildForBACnetConfirmedServiceRequestReadRangeRange() (BACnetConfirmedServiceRequestReadRangeRange, error) {
	return b.Build()
}

func (b *_BACnetConfirmedServiceRequestReadRangeRangeByPositionBuilder) DeepCopy() any {
	_copy := b.CreateBACnetConfirmedServiceRequestReadRangeRangeByPositionBuilder().(*_BACnetConfirmedServiceRequestReadRangeRangeByPositionBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateBACnetConfirmedServiceRequestReadRangeRangeByPositionBuilder creates a BACnetConfirmedServiceRequestReadRangeRangeByPositionBuilder
func (b *_BACnetConfirmedServiceRequestReadRangeRangeByPosition) CreateBACnetConfirmedServiceRequestReadRangeRangeByPositionBuilder() BACnetConfirmedServiceRequestReadRangeRangeByPositionBuilder {
	if b == nil {
		return NewBACnetConfirmedServiceRequestReadRangeRangeByPositionBuilder()
	}
	return &_BACnetConfirmedServiceRequestReadRangeRangeByPositionBuilder{_BACnetConfirmedServiceRequestReadRangeRangeByPosition: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetConfirmedServiceRequestReadRangeRangeByPosition) GetParent() BACnetConfirmedServiceRequestReadRangeRangeContract {
	return m.BACnetConfirmedServiceRequestReadRangeRangeContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetConfirmedServiceRequestReadRangeRangeByPosition) GetReferenceIndex() BACnetApplicationTagUnsignedInteger {
	return m.ReferenceIndex
}

func (m *_BACnetConfirmedServiceRequestReadRangeRangeByPosition) GetCount() BACnetApplicationTagSignedInteger {
	return m.Count
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetConfirmedServiceRequestReadRangeRangeByPosition(structType any) BACnetConfirmedServiceRequestReadRangeRangeByPosition {
	if casted, ok := structType.(BACnetConfirmedServiceRequestReadRangeRangeByPosition); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetConfirmedServiceRequestReadRangeRangeByPosition); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetConfirmedServiceRequestReadRangeRangeByPosition) GetTypeName() string {
	return "BACnetConfirmedServiceRequestReadRangeRangeByPosition"
}

func (m *_BACnetConfirmedServiceRequestReadRangeRangeByPosition) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetConfirmedServiceRequestReadRangeRangeContract.(*_BACnetConfirmedServiceRequestReadRangeRange).getLengthInBits(ctx))

	// Simple field (referenceIndex)
	lengthInBits += m.ReferenceIndex.GetLengthInBits(ctx)

	// Simple field (count)
	lengthInBits += m.Count.GetLengthInBits(ctx)

	return lengthInBits
}

func (m *_BACnetConfirmedServiceRequestReadRangeRangeByPosition) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetConfirmedServiceRequestReadRangeRangeByPosition) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetConfirmedServiceRequestReadRangeRange) (__bACnetConfirmedServiceRequestReadRangeRangeByPosition BACnetConfirmedServiceRequestReadRangeRangeByPosition, err error) {
	m.BACnetConfirmedServiceRequestReadRangeRangeContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetConfirmedServiceRequestReadRangeRangeByPosition"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetConfirmedServiceRequestReadRangeRangeByPosition")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	referenceIndex, err := ReadSimpleField[BACnetApplicationTagUnsignedInteger](ctx, "referenceIndex", ReadComplex[BACnetApplicationTagUnsignedInteger](BACnetApplicationTagParseWithBufferProducer[BACnetApplicationTagUnsignedInteger](), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'referenceIndex' field"))
	}
	m.ReferenceIndex = referenceIndex

	count, err := ReadSimpleField[BACnetApplicationTagSignedInteger](ctx, "count", ReadComplex[BACnetApplicationTagSignedInteger](BACnetApplicationTagParseWithBufferProducer[BACnetApplicationTagSignedInteger](), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'count' field"))
	}
	m.Count = count

	if closeErr := readBuffer.CloseContext("BACnetConfirmedServiceRequestReadRangeRangeByPosition"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetConfirmedServiceRequestReadRangeRangeByPosition")
	}

	return m, nil
}

func (m *_BACnetConfirmedServiceRequestReadRangeRangeByPosition) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetConfirmedServiceRequestReadRangeRangeByPosition) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetConfirmedServiceRequestReadRangeRangeByPosition"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetConfirmedServiceRequestReadRangeRangeByPosition")
		}

		if err := WriteSimpleField[BACnetApplicationTagUnsignedInteger](ctx, "referenceIndex", m.GetReferenceIndex(), WriteComplex[BACnetApplicationTagUnsignedInteger](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'referenceIndex' field")
		}

		if err := WriteSimpleField[BACnetApplicationTagSignedInteger](ctx, "count", m.GetCount(), WriteComplex[BACnetApplicationTagSignedInteger](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'count' field")
		}

		if popErr := writeBuffer.PopContext("BACnetConfirmedServiceRequestReadRangeRangeByPosition"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetConfirmedServiceRequestReadRangeRangeByPosition")
		}
		return nil
	}
	return m.BACnetConfirmedServiceRequestReadRangeRangeContract.(*_BACnetConfirmedServiceRequestReadRangeRange).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetConfirmedServiceRequestReadRangeRangeByPosition) IsBACnetConfirmedServiceRequestReadRangeRangeByPosition() {
}

func (m *_BACnetConfirmedServiceRequestReadRangeRangeByPosition) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetConfirmedServiceRequestReadRangeRangeByPosition) deepCopy() *_BACnetConfirmedServiceRequestReadRangeRangeByPosition {
	if m == nil {
		return nil
	}
	_BACnetConfirmedServiceRequestReadRangeRangeByPositionCopy := &_BACnetConfirmedServiceRequestReadRangeRangeByPosition{
		m.BACnetConfirmedServiceRequestReadRangeRangeContract.(*_BACnetConfirmedServiceRequestReadRangeRange).deepCopy(),
		utils.DeepCopy[BACnetApplicationTagUnsignedInteger](m.ReferenceIndex),
		utils.DeepCopy[BACnetApplicationTagSignedInteger](m.Count),
	}
	_BACnetConfirmedServiceRequestReadRangeRangeByPositionCopy.BACnetConfirmedServiceRequestReadRangeRangeContract.(*_BACnetConfirmedServiceRequestReadRangeRange)._SubType = m
	return _BACnetConfirmedServiceRequestReadRangeRangeByPositionCopy
}

func (m *_BACnetConfirmedServiceRequestReadRangeRangeByPosition) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
