/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetClientCOVObject is the corresponding interface of BACnetClientCOVObject
type BACnetClientCOVObject interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetClientCOV
	// GetRealIncrement returns RealIncrement (property field)
	GetRealIncrement() BACnetApplicationTagReal
	// IsBACnetClientCOVObject is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetClientCOVObject()
	// CreateBuilder creates a BACnetClientCOVObjectBuilder
	CreateBACnetClientCOVObjectBuilder() BACnetClientCOVObjectBuilder
}

// _BACnetClientCOVObject is the data-structure of this message
type _BACnetClientCOVObject struct {
	BACnetClientCOVContract
	RealIncrement BACnetApplicationTagReal
}

var _ BACnetClientCOVObject = (*_BACnetClientCOVObject)(nil)
var _ BACnetClientCOVRequirements = (*_BACnetClientCOVObject)(nil)

// NewBACnetClientCOVObject factory function for _BACnetClientCOVObject
func NewBACnetClientCOVObject(peekedTagHeader BACnetTagHeader, realIncrement BACnetApplicationTagReal) *_BACnetClientCOVObject {
	if realIncrement == nil {
		panic("realIncrement of type BACnetApplicationTagReal for BACnetClientCOVObject must not be nil")
	}
	_result := &_BACnetClientCOVObject{
		BACnetClientCOVContract: NewBACnetClientCOV(peekedTagHeader),
		RealIncrement:           realIncrement,
	}
	_result.BACnetClientCOVContract.(*_BACnetClientCOV)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetClientCOVObjectBuilder is a builder for BACnetClientCOVObject
type BACnetClientCOVObjectBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(realIncrement BACnetApplicationTagReal) BACnetClientCOVObjectBuilder
	// WithRealIncrement adds RealIncrement (property field)
	WithRealIncrement(BACnetApplicationTagReal) BACnetClientCOVObjectBuilder
	// WithRealIncrementBuilder adds RealIncrement (property field) which is build by the builder
	WithRealIncrementBuilder(func(BACnetApplicationTagRealBuilder) BACnetApplicationTagRealBuilder) BACnetClientCOVObjectBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetClientCOVBuilder
	// Build builds the BACnetClientCOVObject or returns an error if something is wrong
	Build() (BACnetClientCOVObject, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetClientCOVObject
}

// NewBACnetClientCOVObjectBuilder() creates a BACnetClientCOVObjectBuilder
func NewBACnetClientCOVObjectBuilder() BACnetClientCOVObjectBuilder {
	return &_BACnetClientCOVObjectBuilder{_BACnetClientCOVObject: new(_BACnetClientCOVObject)}
}

type _BACnetClientCOVObjectBuilder struct {
	*_BACnetClientCOVObject

	parentBuilder *_BACnetClientCOVBuilder

	err *utils.MultiError
}

var _ (BACnetClientCOVObjectBuilder) = (*_BACnetClientCOVObjectBuilder)(nil)

func (b *_BACnetClientCOVObjectBuilder) setParent(contract BACnetClientCOVContract) {
	b.BACnetClientCOVContract = contract
	contract.(*_BACnetClientCOV)._SubType = b._BACnetClientCOVObject
}

func (b *_BACnetClientCOVObjectBuilder) WithMandatoryFields(realIncrement BACnetApplicationTagReal) BACnetClientCOVObjectBuilder {
	return b.WithRealIncrement(realIncrement)
}

func (b *_BACnetClientCOVObjectBuilder) WithRealIncrement(realIncrement BACnetApplicationTagReal) BACnetClientCOVObjectBuilder {
	b.RealIncrement = realIncrement
	return b
}

func (b *_BACnetClientCOVObjectBuilder) WithRealIncrementBuilder(builderSupplier func(BACnetApplicationTagRealBuilder) BACnetApplicationTagRealBuilder) BACnetClientCOVObjectBuilder {
	builder := builderSupplier(b.RealIncrement.CreateBACnetApplicationTagRealBuilder())
	var err error
	b.RealIncrement, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "BACnetApplicationTagRealBuilder failed"))
	}
	return b
}

func (b *_BACnetClientCOVObjectBuilder) Build() (BACnetClientCOVObject, error) {
	if b.RealIncrement == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'realIncrement' not set"))
	}
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._BACnetClientCOVObject.deepCopy(), nil
}

func (b *_BACnetClientCOVObjectBuilder) MustBuild() BACnetClientCOVObject {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetClientCOVObjectBuilder) Done() BACnetClientCOVBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetClientCOVBuilder().(*_BACnetClientCOVBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetClientCOVObjectBuilder) buildForBACnetClientCOV() (BACnetClientCOV, error) {
	return b.Build()
}

func (b *_BACnetClientCOVObjectBuilder) DeepCopy() any {
	_copy := b.CreateBACnetClientCOVObjectBuilder().(*_BACnetClientCOVObjectBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateBACnetClientCOVObjectBuilder creates a BACnetClientCOVObjectBuilder
func (b *_BACnetClientCOVObject) CreateBACnetClientCOVObjectBuilder() BACnetClientCOVObjectBuilder {
	if b == nil {
		return NewBACnetClientCOVObjectBuilder()
	}
	return &_BACnetClientCOVObjectBuilder{_BACnetClientCOVObject: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetClientCOVObject) GetParent() BACnetClientCOVContract {
	return m.BACnetClientCOVContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetClientCOVObject) GetRealIncrement() BACnetApplicationTagReal {
	return m.RealIncrement
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetClientCOVObject(structType any) BACnetClientCOVObject {
	if casted, ok := structType.(BACnetClientCOVObject); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetClientCOVObject); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetClientCOVObject) GetTypeName() string {
	return "BACnetClientCOVObject"
}

func (m *_BACnetClientCOVObject) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetClientCOVContract.(*_BACnetClientCOV).getLengthInBits(ctx))

	// Simple field (realIncrement)
	lengthInBits += m.RealIncrement.GetLengthInBits(ctx)

	return lengthInBits
}

func (m *_BACnetClientCOVObject) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetClientCOVObject) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetClientCOV) (__bACnetClientCOVObject BACnetClientCOVObject, err error) {
	m.BACnetClientCOVContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetClientCOVObject"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetClientCOVObject")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	realIncrement, err := ReadSimpleField[BACnetApplicationTagReal](ctx, "realIncrement", ReadComplex[BACnetApplicationTagReal](BACnetApplicationTagParseWithBufferProducer[BACnetApplicationTagReal](), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'realIncrement' field"))
	}
	m.RealIncrement = realIncrement

	if closeErr := readBuffer.CloseContext("BACnetClientCOVObject"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetClientCOVObject")
	}

	return m, nil
}

func (m *_BACnetClientCOVObject) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetClientCOVObject) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetClientCOVObject"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetClientCOVObject")
		}

		if err := WriteSimpleField[BACnetApplicationTagReal](ctx, "realIncrement", m.GetRealIncrement(), WriteComplex[BACnetApplicationTagReal](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'realIncrement' field")
		}

		if popErr := writeBuffer.PopContext("BACnetClientCOVObject"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetClientCOVObject")
		}
		return nil
	}
	return m.BACnetClientCOVContract.(*_BACnetClientCOV).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetClientCOVObject) IsBACnetClientCOVObject() {}

func (m *_BACnetClientCOVObject) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetClientCOVObject) deepCopy() *_BACnetClientCOVObject {
	if m == nil {
		return nil
	}
	_BACnetClientCOVObjectCopy := &_BACnetClientCOVObject{
		m.BACnetClientCOVContract.(*_BACnetClientCOV).deepCopy(),
		utils.DeepCopy[BACnetApplicationTagReal](m.RealIncrement),
	}
	_BACnetClientCOVObjectCopy.BACnetClientCOVContract.(*_BACnetClientCOV)._SubType = m
	return _BACnetClientCOVObjectCopy
}

func (m *_BACnetClientCOVObject) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
