/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetChannelValueTime is the corresponding interface of BACnetChannelValueTime
type BACnetChannelValueTime interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetChannelValue
	// GetTimeValue returns TimeValue (property field)
	GetTimeValue() BACnetApplicationTagTime
	// IsBACnetChannelValueTime is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetChannelValueTime()
	// CreateBuilder creates a BACnetChannelValueTimeBuilder
	CreateBACnetChannelValueTimeBuilder() BACnetChannelValueTimeBuilder
}

// _BACnetChannelValueTime is the data-structure of this message
type _BACnetChannelValueTime struct {
	BACnetChannelValueContract
	TimeValue BACnetApplicationTagTime
}

var _ BACnetChannelValueTime = (*_BACnetChannelValueTime)(nil)
var _ BACnetChannelValueRequirements = (*_BACnetChannelValueTime)(nil)

// NewBACnetChannelValueTime factory function for _BACnetChannelValueTime
func NewBACnetChannelValueTime(peekedTagHeader BACnetTagHeader, timeValue BACnetApplicationTagTime) *_BACnetChannelValueTime {
	if timeValue == nil {
		panic("timeValue of type BACnetApplicationTagTime for BACnetChannelValueTime must not be nil")
	}
	_result := &_BACnetChannelValueTime{
		BACnetChannelValueContract: NewBACnetChannelValue(peekedTagHeader),
		TimeValue:                  timeValue,
	}
	_result.BACnetChannelValueContract.(*_BACnetChannelValue)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetChannelValueTimeBuilder is a builder for BACnetChannelValueTime
type BACnetChannelValueTimeBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(timeValue BACnetApplicationTagTime) BACnetChannelValueTimeBuilder
	// WithTimeValue adds TimeValue (property field)
	WithTimeValue(BACnetApplicationTagTime) BACnetChannelValueTimeBuilder
	// WithTimeValueBuilder adds TimeValue (property field) which is build by the builder
	WithTimeValueBuilder(func(BACnetApplicationTagTimeBuilder) BACnetApplicationTagTimeBuilder) BACnetChannelValueTimeBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetChannelValueBuilder
	// Build builds the BACnetChannelValueTime or returns an error if something is wrong
	Build() (BACnetChannelValueTime, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetChannelValueTime
}

// NewBACnetChannelValueTimeBuilder() creates a BACnetChannelValueTimeBuilder
func NewBACnetChannelValueTimeBuilder() BACnetChannelValueTimeBuilder {
	return &_BACnetChannelValueTimeBuilder{_BACnetChannelValueTime: new(_BACnetChannelValueTime)}
}

type _BACnetChannelValueTimeBuilder struct {
	*_BACnetChannelValueTime

	parentBuilder *_BACnetChannelValueBuilder

	err *utils.MultiError
}

var _ (BACnetChannelValueTimeBuilder) = (*_BACnetChannelValueTimeBuilder)(nil)

func (b *_BACnetChannelValueTimeBuilder) setParent(contract BACnetChannelValueContract) {
	b.BACnetChannelValueContract = contract
	contract.(*_BACnetChannelValue)._SubType = b._BACnetChannelValueTime
}

func (b *_BACnetChannelValueTimeBuilder) WithMandatoryFields(timeValue BACnetApplicationTagTime) BACnetChannelValueTimeBuilder {
	return b.WithTimeValue(timeValue)
}

func (b *_BACnetChannelValueTimeBuilder) WithTimeValue(timeValue BACnetApplicationTagTime) BACnetChannelValueTimeBuilder {
	b.TimeValue = timeValue
	return b
}

func (b *_BACnetChannelValueTimeBuilder) WithTimeValueBuilder(builderSupplier func(BACnetApplicationTagTimeBuilder) BACnetApplicationTagTimeBuilder) BACnetChannelValueTimeBuilder {
	builder := builderSupplier(b.TimeValue.CreateBACnetApplicationTagTimeBuilder())
	var err error
	b.TimeValue, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "BACnetApplicationTagTimeBuilder failed"))
	}
	return b
}

func (b *_BACnetChannelValueTimeBuilder) Build() (BACnetChannelValueTime, error) {
	if b.TimeValue == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'timeValue' not set"))
	}
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._BACnetChannelValueTime.deepCopy(), nil
}

func (b *_BACnetChannelValueTimeBuilder) MustBuild() BACnetChannelValueTime {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetChannelValueTimeBuilder) Done() BACnetChannelValueBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetChannelValueBuilder().(*_BACnetChannelValueBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetChannelValueTimeBuilder) buildForBACnetChannelValue() (BACnetChannelValue, error) {
	return b.Build()
}

func (b *_BACnetChannelValueTimeBuilder) DeepCopy() any {
	_copy := b.CreateBACnetChannelValueTimeBuilder().(*_BACnetChannelValueTimeBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateBACnetChannelValueTimeBuilder creates a BACnetChannelValueTimeBuilder
func (b *_BACnetChannelValueTime) CreateBACnetChannelValueTimeBuilder() BACnetChannelValueTimeBuilder {
	if b == nil {
		return NewBACnetChannelValueTimeBuilder()
	}
	return &_BACnetChannelValueTimeBuilder{_BACnetChannelValueTime: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetChannelValueTime) GetParent() BACnetChannelValueContract {
	return m.BACnetChannelValueContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetChannelValueTime) GetTimeValue() BACnetApplicationTagTime {
	return m.TimeValue
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetChannelValueTime(structType any) BACnetChannelValueTime {
	if casted, ok := structType.(BACnetChannelValueTime); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetChannelValueTime); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetChannelValueTime) GetTypeName() string {
	return "BACnetChannelValueTime"
}

func (m *_BACnetChannelValueTime) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetChannelValueContract.(*_BACnetChannelValue).getLengthInBits(ctx))

	// Simple field (timeValue)
	lengthInBits += m.TimeValue.GetLengthInBits(ctx)

	return lengthInBits
}

func (m *_BACnetChannelValueTime) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetChannelValueTime) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetChannelValue) (__bACnetChannelValueTime BACnetChannelValueTime, err error) {
	m.BACnetChannelValueContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetChannelValueTime"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetChannelValueTime")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	timeValue, err := ReadSimpleField[BACnetApplicationTagTime](ctx, "timeValue", ReadComplex[BACnetApplicationTagTime](BACnetApplicationTagParseWithBufferProducer[BACnetApplicationTagTime](), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'timeValue' field"))
	}
	m.TimeValue = timeValue

	if closeErr := readBuffer.CloseContext("BACnetChannelValueTime"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetChannelValueTime")
	}

	return m, nil
}

func (m *_BACnetChannelValueTime) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetChannelValueTime) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetChannelValueTime"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetChannelValueTime")
		}

		if err := WriteSimpleField[BACnetApplicationTagTime](ctx, "timeValue", m.GetTimeValue(), WriteComplex[BACnetApplicationTagTime](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'timeValue' field")
		}

		if popErr := writeBuffer.PopContext("BACnetChannelValueTime"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetChannelValueTime")
		}
		return nil
	}
	return m.BACnetChannelValueContract.(*_BACnetChannelValue).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetChannelValueTime) IsBACnetChannelValueTime() {}

func (m *_BACnetChannelValueTime) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetChannelValueTime) deepCopy() *_BACnetChannelValueTime {
	if m == nil {
		return nil
	}
	_BACnetChannelValueTimeCopy := &_BACnetChannelValueTime{
		m.BACnetChannelValueContract.(*_BACnetChannelValue).deepCopy(),
		utils.DeepCopy[BACnetApplicationTagTime](m.TimeValue),
	}
	_BACnetChannelValueTimeCopy.BACnetChannelValueContract.(*_BACnetChannelValue)._SubType = m
	return _BACnetChannelValueTimeCopy
}

func (m *_BACnetChannelValueTime) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
