/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetChannelValueReal is the corresponding interface of BACnetChannelValueReal
type BACnetChannelValueReal interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetChannelValue
	// GetRealValue returns RealValue (property field)
	GetRealValue() BACnetApplicationTagReal
	// IsBACnetChannelValueReal is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetChannelValueReal()
	// CreateBuilder creates a BACnetChannelValueRealBuilder
	CreateBACnetChannelValueRealBuilder() BACnetChannelValueRealBuilder
}

// _BACnetChannelValueReal is the data-structure of this message
type _BACnetChannelValueReal struct {
	BACnetChannelValueContract
	RealValue BACnetApplicationTagReal
}

var _ BACnetChannelValueReal = (*_BACnetChannelValueReal)(nil)
var _ BACnetChannelValueRequirements = (*_BACnetChannelValueReal)(nil)

// NewBACnetChannelValueReal factory function for _BACnetChannelValueReal
func NewBACnetChannelValueReal(peekedTagHeader BACnetTagHeader, realValue BACnetApplicationTagReal) *_BACnetChannelValueReal {
	if realValue == nil {
		panic("realValue of type BACnetApplicationTagReal for BACnetChannelValueReal must not be nil")
	}
	_result := &_BACnetChannelValueReal{
		BACnetChannelValueContract: NewBACnetChannelValue(peekedTagHeader),
		RealValue:                  realValue,
	}
	_result.BACnetChannelValueContract.(*_BACnetChannelValue)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetChannelValueRealBuilder is a builder for BACnetChannelValueReal
type BACnetChannelValueRealBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(realValue BACnetApplicationTagReal) BACnetChannelValueRealBuilder
	// WithRealValue adds RealValue (property field)
	WithRealValue(BACnetApplicationTagReal) BACnetChannelValueRealBuilder
	// WithRealValueBuilder adds RealValue (property field) which is build by the builder
	WithRealValueBuilder(func(BACnetApplicationTagRealBuilder) BACnetApplicationTagRealBuilder) BACnetChannelValueRealBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetChannelValueBuilder
	// Build builds the BACnetChannelValueReal or returns an error if something is wrong
	Build() (BACnetChannelValueReal, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetChannelValueReal
}

// NewBACnetChannelValueRealBuilder() creates a BACnetChannelValueRealBuilder
func NewBACnetChannelValueRealBuilder() BACnetChannelValueRealBuilder {
	return &_BACnetChannelValueRealBuilder{_BACnetChannelValueReal: new(_BACnetChannelValueReal)}
}

type _BACnetChannelValueRealBuilder struct {
	*_BACnetChannelValueReal

	parentBuilder *_BACnetChannelValueBuilder

	err *utils.MultiError
}

var _ (BACnetChannelValueRealBuilder) = (*_BACnetChannelValueRealBuilder)(nil)

func (b *_BACnetChannelValueRealBuilder) setParent(contract BACnetChannelValueContract) {
	b.BACnetChannelValueContract = contract
	contract.(*_BACnetChannelValue)._SubType = b._BACnetChannelValueReal
}

func (b *_BACnetChannelValueRealBuilder) WithMandatoryFields(realValue BACnetApplicationTagReal) BACnetChannelValueRealBuilder {
	return b.WithRealValue(realValue)
}

func (b *_BACnetChannelValueRealBuilder) WithRealValue(realValue BACnetApplicationTagReal) BACnetChannelValueRealBuilder {
	b.RealValue = realValue
	return b
}

func (b *_BACnetChannelValueRealBuilder) WithRealValueBuilder(builderSupplier func(BACnetApplicationTagRealBuilder) BACnetApplicationTagRealBuilder) BACnetChannelValueRealBuilder {
	builder := builderSupplier(b.RealValue.CreateBACnetApplicationTagRealBuilder())
	var err error
	b.RealValue, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "BACnetApplicationTagRealBuilder failed"))
	}
	return b
}

func (b *_BACnetChannelValueRealBuilder) Build() (BACnetChannelValueReal, error) {
	if b.RealValue == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'realValue' not set"))
	}
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._BACnetChannelValueReal.deepCopy(), nil
}

func (b *_BACnetChannelValueRealBuilder) MustBuild() BACnetChannelValueReal {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetChannelValueRealBuilder) Done() BACnetChannelValueBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetChannelValueBuilder().(*_BACnetChannelValueBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetChannelValueRealBuilder) buildForBACnetChannelValue() (BACnetChannelValue, error) {
	return b.Build()
}

func (b *_BACnetChannelValueRealBuilder) DeepCopy() any {
	_copy := b.CreateBACnetChannelValueRealBuilder().(*_BACnetChannelValueRealBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateBACnetChannelValueRealBuilder creates a BACnetChannelValueRealBuilder
func (b *_BACnetChannelValueReal) CreateBACnetChannelValueRealBuilder() BACnetChannelValueRealBuilder {
	if b == nil {
		return NewBACnetChannelValueRealBuilder()
	}
	return &_BACnetChannelValueRealBuilder{_BACnetChannelValueReal: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetChannelValueReal) GetParent() BACnetChannelValueContract {
	return m.BACnetChannelValueContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetChannelValueReal) GetRealValue() BACnetApplicationTagReal {
	return m.RealValue
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetChannelValueReal(structType any) BACnetChannelValueReal {
	if casted, ok := structType.(BACnetChannelValueReal); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetChannelValueReal); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetChannelValueReal) GetTypeName() string {
	return "BACnetChannelValueReal"
}

func (m *_BACnetChannelValueReal) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetChannelValueContract.(*_BACnetChannelValue).getLengthInBits(ctx))

	// Simple field (realValue)
	lengthInBits += m.RealValue.GetLengthInBits(ctx)

	return lengthInBits
}

func (m *_BACnetChannelValueReal) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetChannelValueReal) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetChannelValue) (__bACnetChannelValueReal BACnetChannelValueReal, err error) {
	m.BACnetChannelValueContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetChannelValueReal"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetChannelValueReal")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	realValue, err := ReadSimpleField[BACnetApplicationTagReal](ctx, "realValue", ReadComplex[BACnetApplicationTagReal](BACnetApplicationTagParseWithBufferProducer[BACnetApplicationTagReal](), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'realValue' field"))
	}
	m.RealValue = realValue

	if closeErr := readBuffer.CloseContext("BACnetChannelValueReal"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetChannelValueReal")
	}

	return m, nil
}

func (m *_BACnetChannelValueReal) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetChannelValueReal) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetChannelValueReal"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetChannelValueReal")
		}

		if err := WriteSimpleField[BACnetApplicationTagReal](ctx, "realValue", m.GetRealValue(), WriteComplex[BACnetApplicationTagReal](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'realValue' field")
		}

		if popErr := writeBuffer.PopContext("BACnetChannelValueReal"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetChannelValueReal")
		}
		return nil
	}
	return m.BACnetChannelValueContract.(*_BACnetChannelValue).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetChannelValueReal) IsBACnetChannelValueReal() {}

func (m *_BACnetChannelValueReal) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetChannelValueReal) deepCopy() *_BACnetChannelValueReal {
	if m == nil {
		return nil
	}
	_BACnetChannelValueRealCopy := &_BACnetChannelValueReal{
		m.BACnetChannelValueContract.(*_BACnetChannelValue).deepCopy(),
		utils.DeepCopy[BACnetApplicationTagReal](m.RealValue),
	}
	_BACnetChannelValueRealCopy.BACnetChannelValueContract.(*_BACnetChannelValue)._SubType = m
	return _BACnetChannelValueRealCopy
}

func (m *_BACnetChannelValueReal) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
