/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetChannelValue is the corresponding interface of BACnetChannelValue
type BACnetChannelValue interface {
	BACnetChannelValueContract
	BACnetChannelValueRequirements
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	// IsBACnetChannelValue is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetChannelValue()
	// CreateBuilder creates a BACnetChannelValueBuilder
	CreateBACnetChannelValueBuilder() BACnetChannelValueBuilder
}

// BACnetChannelValueContract provides a set of functions which can be overwritten by a sub struct
type BACnetChannelValueContract interface {
	// GetPeekedTagHeader returns PeekedTagHeader (property field)
	GetPeekedTagHeader() BACnetTagHeader
	// GetPeekedTagNumber returns PeekedTagNumber (virtual field)
	GetPeekedTagNumber() uint8
	// GetPeekedIsContextTag returns PeekedIsContextTag (virtual field)
	GetPeekedIsContextTag() bool
	// IsBACnetChannelValue is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetChannelValue()
	// CreateBuilder creates a BACnetChannelValueBuilder
	CreateBACnetChannelValueBuilder() BACnetChannelValueBuilder
}

// BACnetChannelValueRequirements provides a set of functions which need to be implemented by a sub struct
type BACnetChannelValueRequirements interface {
	GetLengthInBits(ctx context.Context) uint16
	GetLengthInBytes(ctx context.Context) uint16
	// GetPeekedIsContextTag returns PeekedIsContextTag (discriminator field)
	GetPeekedIsContextTag() bool
	// GetPeekedTagNumber returns PeekedTagNumber (discriminator field)
	GetPeekedTagNumber() uint8
}

// _BACnetChannelValue is the data-structure of this message
type _BACnetChannelValue struct {
	_SubType interface {
		BACnetChannelValueContract
		BACnetChannelValueRequirements
	}
	PeekedTagHeader BACnetTagHeader
}

var _ BACnetChannelValueContract = (*_BACnetChannelValue)(nil)

// NewBACnetChannelValue factory function for _BACnetChannelValue
func NewBACnetChannelValue(peekedTagHeader BACnetTagHeader) *_BACnetChannelValue {
	if peekedTagHeader == nil {
		panic("peekedTagHeader of type BACnetTagHeader for BACnetChannelValue must not be nil")
	}
	return &_BACnetChannelValue{PeekedTagHeader: peekedTagHeader}
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetChannelValueBuilder is a builder for BACnetChannelValue
type BACnetChannelValueBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(peekedTagHeader BACnetTagHeader) BACnetChannelValueBuilder
	// WithPeekedTagHeader adds PeekedTagHeader (property field)
	WithPeekedTagHeader(BACnetTagHeader) BACnetChannelValueBuilder
	// WithPeekedTagHeaderBuilder adds PeekedTagHeader (property field) which is build by the builder
	WithPeekedTagHeaderBuilder(func(BACnetTagHeaderBuilder) BACnetTagHeaderBuilder) BACnetChannelValueBuilder
	// AsBACnetChannelValueNull converts this build to a subType of BACnetChannelValue. It is always possible to return to current builder using Done()
	AsBACnetChannelValueNull() BACnetChannelValueNullBuilder
	// AsBACnetChannelValueReal converts this build to a subType of BACnetChannelValue. It is always possible to return to current builder using Done()
	AsBACnetChannelValueReal() BACnetChannelValueRealBuilder
	// AsBACnetChannelValueEnumerated converts this build to a subType of BACnetChannelValue. It is always possible to return to current builder using Done()
	AsBACnetChannelValueEnumerated() BACnetChannelValueEnumeratedBuilder
	// AsBACnetChannelValueUnsigned converts this build to a subType of BACnetChannelValue. It is always possible to return to current builder using Done()
	AsBACnetChannelValueUnsigned() BACnetChannelValueUnsignedBuilder
	// AsBACnetChannelValueBoolean converts this build to a subType of BACnetChannelValue. It is always possible to return to current builder using Done()
	AsBACnetChannelValueBoolean() BACnetChannelValueBooleanBuilder
	// AsBACnetChannelValueInteger converts this build to a subType of BACnetChannelValue. It is always possible to return to current builder using Done()
	AsBACnetChannelValueInteger() BACnetChannelValueIntegerBuilder
	// AsBACnetChannelValueDouble converts this build to a subType of BACnetChannelValue. It is always possible to return to current builder using Done()
	AsBACnetChannelValueDouble() BACnetChannelValueDoubleBuilder
	// AsBACnetChannelValueTime converts this build to a subType of BACnetChannelValue. It is always possible to return to current builder using Done()
	AsBACnetChannelValueTime() BACnetChannelValueTimeBuilder
	// AsBACnetChannelValueCharacterString converts this build to a subType of BACnetChannelValue. It is always possible to return to current builder using Done()
	AsBACnetChannelValueCharacterString() BACnetChannelValueCharacterStringBuilder
	// AsBACnetChannelValueOctetString converts this build to a subType of BACnetChannelValue. It is always possible to return to current builder using Done()
	AsBACnetChannelValueOctetString() BACnetChannelValueOctetStringBuilder
	// AsBACnetChannelValueBitString converts this build to a subType of BACnetChannelValue. It is always possible to return to current builder using Done()
	AsBACnetChannelValueBitString() BACnetChannelValueBitStringBuilder
	// AsBACnetChannelValueDate converts this build to a subType of BACnetChannelValue. It is always possible to return to current builder using Done()
	AsBACnetChannelValueDate() BACnetChannelValueDateBuilder
	// AsBACnetChannelValueObjectidentifier converts this build to a subType of BACnetChannelValue. It is always possible to return to current builder using Done()
	AsBACnetChannelValueObjectidentifier() BACnetChannelValueObjectidentifierBuilder
	// AsBACnetChannelValueLightingCommand converts this build to a subType of BACnetChannelValue. It is always possible to return to current builder using Done()
	AsBACnetChannelValueLightingCommand() BACnetChannelValueLightingCommandBuilder
	// Build builds the BACnetChannelValue or returns an error if something is wrong
	PartialBuild() (BACnetChannelValueContract, error)
	// MustBuild does the same as Build but panics on error
	PartialMustBuild() BACnetChannelValueContract
	// Build builds the BACnetChannelValue or returns an error if something is wrong
	Build() (BACnetChannelValue, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetChannelValue
}

// NewBACnetChannelValueBuilder() creates a BACnetChannelValueBuilder
func NewBACnetChannelValueBuilder() BACnetChannelValueBuilder {
	return &_BACnetChannelValueBuilder{_BACnetChannelValue: new(_BACnetChannelValue)}
}

type _BACnetChannelValueChildBuilder interface {
	utils.Copyable
	setParent(BACnetChannelValueContract)
	buildForBACnetChannelValue() (BACnetChannelValue, error)
}

type _BACnetChannelValueBuilder struct {
	*_BACnetChannelValue

	childBuilder _BACnetChannelValueChildBuilder

	err *utils.MultiError
}

var _ (BACnetChannelValueBuilder) = (*_BACnetChannelValueBuilder)(nil)

func (b *_BACnetChannelValueBuilder) WithMandatoryFields(peekedTagHeader BACnetTagHeader) BACnetChannelValueBuilder {
	return b.WithPeekedTagHeader(peekedTagHeader)
}

func (b *_BACnetChannelValueBuilder) WithPeekedTagHeader(peekedTagHeader BACnetTagHeader) BACnetChannelValueBuilder {
	b.PeekedTagHeader = peekedTagHeader
	return b
}

func (b *_BACnetChannelValueBuilder) WithPeekedTagHeaderBuilder(builderSupplier func(BACnetTagHeaderBuilder) BACnetTagHeaderBuilder) BACnetChannelValueBuilder {
	builder := builderSupplier(b.PeekedTagHeader.CreateBACnetTagHeaderBuilder())
	var err error
	b.PeekedTagHeader, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "BACnetTagHeaderBuilder failed"))
	}
	return b
}

func (b *_BACnetChannelValueBuilder) PartialBuild() (BACnetChannelValueContract, error) {
	if b.PeekedTagHeader == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'peekedTagHeader' not set"))
	}
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._BACnetChannelValue.deepCopy(), nil
}

func (b *_BACnetChannelValueBuilder) PartialMustBuild() BACnetChannelValueContract {
	build, err := b.PartialBuild()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetChannelValueBuilder) AsBACnetChannelValueNull() BACnetChannelValueNullBuilder {
	if cb, ok := b.childBuilder.(BACnetChannelValueNullBuilder); ok {
		return cb
	}
	cb := NewBACnetChannelValueNullBuilder().(*_BACnetChannelValueNullBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetChannelValueBuilder) AsBACnetChannelValueReal() BACnetChannelValueRealBuilder {
	if cb, ok := b.childBuilder.(BACnetChannelValueRealBuilder); ok {
		return cb
	}
	cb := NewBACnetChannelValueRealBuilder().(*_BACnetChannelValueRealBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetChannelValueBuilder) AsBACnetChannelValueEnumerated() BACnetChannelValueEnumeratedBuilder {
	if cb, ok := b.childBuilder.(BACnetChannelValueEnumeratedBuilder); ok {
		return cb
	}
	cb := NewBACnetChannelValueEnumeratedBuilder().(*_BACnetChannelValueEnumeratedBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetChannelValueBuilder) AsBACnetChannelValueUnsigned() BACnetChannelValueUnsignedBuilder {
	if cb, ok := b.childBuilder.(BACnetChannelValueUnsignedBuilder); ok {
		return cb
	}
	cb := NewBACnetChannelValueUnsignedBuilder().(*_BACnetChannelValueUnsignedBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetChannelValueBuilder) AsBACnetChannelValueBoolean() BACnetChannelValueBooleanBuilder {
	if cb, ok := b.childBuilder.(BACnetChannelValueBooleanBuilder); ok {
		return cb
	}
	cb := NewBACnetChannelValueBooleanBuilder().(*_BACnetChannelValueBooleanBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetChannelValueBuilder) AsBACnetChannelValueInteger() BACnetChannelValueIntegerBuilder {
	if cb, ok := b.childBuilder.(BACnetChannelValueIntegerBuilder); ok {
		return cb
	}
	cb := NewBACnetChannelValueIntegerBuilder().(*_BACnetChannelValueIntegerBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetChannelValueBuilder) AsBACnetChannelValueDouble() BACnetChannelValueDoubleBuilder {
	if cb, ok := b.childBuilder.(BACnetChannelValueDoubleBuilder); ok {
		return cb
	}
	cb := NewBACnetChannelValueDoubleBuilder().(*_BACnetChannelValueDoubleBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetChannelValueBuilder) AsBACnetChannelValueTime() BACnetChannelValueTimeBuilder {
	if cb, ok := b.childBuilder.(BACnetChannelValueTimeBuilder); ok {
		return cb
	}
	cb := NewBACnetChannelValueTimeBuilder().(*_BACnetChannelValueTimeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetChannelValueBuilder) AsBACnetChannelValueCharacterString() BACnetChannelValueCharacterStringBuilder {
	if cb, ok := b.childBuilder.(BACnetChannelValueCharacterStringBuilder); ok {
		return cb
	}
	cb := NewBACnetChannelValueCharacterStringBuilder().(*_BACnetChannelValueCharacterStringBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetChannelValueBuilder) AsBACnetChannelValueOctetString() BACnetChannelValueOctetStringBuilder {
	if cb, ok := b.childBuilder.(BACnetChannelValueOctetStringBuilder); ok {
		return cb
	}
	cb := NewBACnetChannelValueOctetStringBuilder().(*_BACnetChannelValueOctetStringBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetChannelValueBuilder) AsBACnetChannelValueBitString() BACnetChannelValueBitStringBuilder {
	if cb, ok := b.childBuilder.(BACnetChannelValueBitStringBuilder); ok {
		return cb
	}
	cb := NewBACnetChannelValueBitStringBuilder().(*_BACnetChannelValueBitStringBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetChannelValueBuilder) AsBACnetChannelValueDate() BACnetChannelValueDateBuilder {
	if cb, ok := b.childBuilder.(BACnetChannelValueDateBuilder); ok {
		return cb
	}
	cb := NewBACnetChannelValueDateBuilder().(*_BACnetChannelValueDateBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetChannelValueBuilder) AsBACnetChannelValueObjectidentifier() BACnetChannelValueObjectidentifierBuilder {
	if cb, ok := b.childBuilder.(BACnetChannelValueObjectidentifierBuilder); ok {
		return cb
	}
	cb := NewBACnetChannelValueObjectidentifierBuilder().(*_BACnetChannelValueObjectidentifierBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetChannelValueBuilder) AsBACnetChannelValueLightingCommand() BACnetChannelValueLightingCommandBuilder {
	if cb, ok := b.childBuilder.(BACnetChannelValueLightingCommandBuilder); ok {
		return cb
	}
	cb := NewBACnetChannelValueLightingCommandBuilder().(*_BACnetChannelValueLightingCommandBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetChannelValueBuilder) Build() (BACnetChannelValue, error) {
	v, err := b.PartialBuild()
	if err != nil {
		return nil, errors.Wrap(err, "error occurred during partial build")
	}
	if b.childBuilder == nil {
		return nil, errors.New("no child builder present")
	}
	b.childBuilder.setParent(v)
	return b.childBuilder.buildForBACnetChannelValue()
}

func (b *_BACnetChannelValueBuilder) MustBuild() BACnetChannelValue {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetChannelValueBuilder) DeepCopy() any {
	_copy := b.CreateBACnetChannelValueBuilder().(*_BACnetChannelValueBuilder)
	_copy.childBuilder = b.childBuilder.DeepCopy().(_BACnetChannelValueChildBuilder)
	_copy.childBuilder.setParent(_copy)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateBACnetChannelValueBuilder creates a BACnetChannelValueBuilder
func (b *_BACnetChannelValue) CreateBACnetChannelValueBuilder() BACnetChannelValueBuilder {
	if b == nil {
		return NewBACnetChannelValueBuilder()
	}
	return &_BACnetChannelValueBuilder{_BACnetChannelValue: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetChannelValue) GetPeekedTagHeader() BACnetTagHeader {
	return m.PeekedTagHeader
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for virtual fields.
///////////////////////

func (pm *_BACnetChannelValue) GetPeekedTagNumber() uint8 {
	m := pm._SubType
	ctx := context.Background()
	_ = ctx
	return uint8(m.GetPeekedTagHeader().GetActualTagNumber())
}

func (pm *_BACnetChannelValue) GetPeekedIsContextTag() bool {
	m := pm._SubType
	ctx := context.Background()
	_ = ctx
	return bool(bool((m.GetPeekedTagHeader().GetTagClass()) == (TagClass_CONTEXT_SPECIFIC_TAGS)))
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetChannelValue(structType any) BACnetChannelValue {
	if casted, ok := structType.(BACnetChannelValue); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetChannelValue); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetChannelValue) GetTypeName() string {
	return "BACnetChannelValue"
}

func (m *_BACnetChannelValue) getLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(0)

	// A virtual field doesn't have any in- or output.

	// A virtual field doesn't have any in- or output.

	return lengthInBits
}

func (m *_BACnetChannelValue) GetLengthInBits(ctx context.Context) uint16 {
	return m._SubType.GetLengthInBits(ctx)
}

func (m *_BACnetChannelValue) GetLengthInBytes(ctx context.Context) uint16 {
	return m._SubType.GetLengthInBits(ctx) / 8
}

func BACnetChannelValueParse[T BACnetChannelValue](ctx context.Context, theBytes []byte) (T, error) {
	return BACnetChannelValueParseWithBuffer[T](ctx, utils.NewReadBufferByteBased(theBytes))
}

func BACnetChannelValueParseWithBufferProducer[T BACnetChannelValue]() func(ctx context.Context, readBuffer utils.ReadBuffer) (T, error) {
	return func(ctx context.Context, readBuffer utils.ReadBuffer) (T, error) {
		v, err := BACnetChannelValueParseWithBuffer[T](ctx, readBuffer)
		if err != nil {
			var zero T
			return zero, err
		}
		return v, nil
	}
}

func BACnetChannelValueParseWithBuffer[T BACnetChannelValue](ctx context.Context, readBuffer utils.ReadBuffer) (T, error) {
	v, err := (&_BACnetChannelValue{}).parse(ctx, readBuffer)
	if err != nil {
		var zero T
		return zero, err
	}
	vc, ok := v.(T)
	if !ok {
		var zero T
		return zero, errors.Errorf("Unexpected type %T. Expected type %T", v, *new(T))
	}
	return vc, nil
}

func (m *_BACnetChannelValue) parse(ctx context.Context, readBuffer utils.ReadBuffer) (__bACnetChannelValue BACnetChannelValue, err error) {
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetChannelValue"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetChannelValue")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	peekedTagHeader, err := ReadPeekField[BACnetTagHeader](ctx, "peekedTagHeader", ReadComplex[BACnetTagHeader](BACnetTagHeaderParseWithBuffer, readBuffer), 0)
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'peekedTagHeader' field"))
	}
	m.PeekedTagHeader = peekedTagHeader

	peekedTagNumber, err := ReadVirtualField[uint8](ctx, "peekedTagNumber", (*uint8)(nil), peekedTagHeader.GetActualTagNumber())
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'peekedTagNumber' field"))
	}
	_ = peekedTagNumber

	peekedIsContextTag, err := ReadVirtualField[bool](ctx, "peekedIsContextTag", (*bool)(nil), bool((peekedTagHeader.GetTagClass()) == (TagClass_CONTEXT_SPECIFIC_TAGS)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'peekedIsContextTag' field"))
	}
	_ = peekedIsContextTag

	// Validation
	if !(bool((!(peekedIsContextTag))) || bool((bool(bool(peekedIsContextTag) && bool(bool((peekedTagHeader.GetLengthValueType()) != (0x6)))) && bool(bool((peekedTagHeader.GetLengthValueType()) != (0x7)))))) {
		return nil, errors.WithStack(utils.ParseValidationError{Message: "unexpected opening or closing tag"})
	}

	// Switch Field (Depending on the discriminator values, passes the instantiation to a sub-type)
	var _child BACnetChannelValue
	switch {
	case peekedTagNumber == 0x0 && peekedIsContextTag == bool(false): // BACnetChannelValueNull
		if _child, err = new(_BACnetChannelValueNull).parse(ctx, readBuffer, m); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetChannelValueNull for type-switch of BACnetChannelValue")
		}
	case peekedTagNumber == 0x4 && peekedIsContextTag == bool(false): // BACnetChannelValueReal
		if _child, err = new(_BACnetChannelValueReal).parse(ctx, readBuffer, m); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetChannelValueReal for type-switch of BACnetChannelValue")
		}
	case peekedTagNumber == 0x9 && peekedIsContextTag == bool(false): // BACnetChannelValueEnumerated
		if _child, err = new(_BACnetChannelValueEnumerated).parse(ctx, readBuffer, m); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetChannelValueEnumerated for type-switch of BACnetChannelValue")
		}
	case peekedTagNumber == 0x2 && peekedIsContextTag == bool(false): // BACnetChannelValueUnsigned
		if _child, err = new(_BACnetChannelValueUnsigned).parse(ctx, readBuffer, m); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetChannelValueUnsigned for type-switch of BACnetChannelValue")
		}
	case peekedTagNumber == 0x1 && peekedIsContextTag == bool(false): // BACnetChannelValueBoolean
		if _child, err = new(_BACnetChannelValueBoolean).parse(ctx, readBuffer, m); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetChannelValueBoolean for type-switch of BACnetChannelValue")
		}
	case peekedTagNumber == 0x3 && peekedIsContextTag == bool(false): // BACnetChannelValueInteger
		if _child, err = new(_BACnetChannelValueInteger).parse(ctx, readBuffer, m); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetChannelValueInteger for type-switch of BACnetChannelValue")
		}
	case peekedTagNumber == 0x5 && peekedIsContextTag == bool(false): // BACnetChannelValueDouble
		if _child, err = new(_BACnetChannelValueDouble).parse(ctx, readBuffer, m); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetChannelValueDouble for type-switch of BACnetChannelValue")
		}
	case peekedTagNumber == 0xB && peekedIsContextTag == bool(false): // BACnetChannelValueTime
		if _child, err = new(_BACnetChannelValueTime).parse(ctx, readBuffer, m); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetChannelValueTime for type-switch of BACnetChannelValue")
		}
	case peekedTagNumber == 0x7 && peekedIsContextTag == bool(false): // BACnetChannelValueCharacterString
		if _child, err = new(_BACnetChannelValueCharacterString).parse(ctx, readBuffer, m); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetChannelValueCharacterString for type-switch of BACnetChannelValue")
		}
	case peekedTagNumber == 0x6 && peekedIsContextTag == bool(false): // BACnetChannelValueOctetString
		if _child, err = new(_BACnetChannelValueOctetString).parse(ctx, readBuffer, m); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetChannelValueOctetString for type-switch of BACnetChannelValue")
		}
	case peekedTagNumber == 0x8 && peekedIsContextTag == bool(false): // BACnetChannelValueBitString
		if _child, err = new(_BACnetChannelValueBitString).parse(ctx, readBuffer, m); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetChannelValueBitString for type-switch of BACnetChannelValue")
		}
	case peekedTagNumber == 0xA && peekedIsContextTag == bool(false): // BACnetChannelValueDate
		if _child, err = new(_BACnetChannelValueDate).parse(ctx, readBuffer, m); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetChannelValueDate for type-switch of BACnetChannelValue")
		}
	case peekedTagNumber == 0xC && peekedIsContextTag == bool(false): // BACnetChannelValueObjectidentifier
		if _child, err = new(_BACnetChannelValueObjectidentifier).parse(ctx, readBuffer, m); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetChannelValueObjectidentifier for type-switch of BACnetChannelValue")
		}
	case peekedTagNumber == uint8(0) && peekedIsContextTag == bool(true): // BACnetChannelValueLightingCommand
		if _child, err = new(_BACnetChannelValueLightingCommand).parse(ctx, readBuffer, m); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetChannelValueLightingCommand for type-switch of BACnetChannelValue")
		}
	default:
		return nil, errors.Errorf("Unmapped type for parameters [peekedTagNumber=%v, peekedIsContextTag=%v]", peekedTagNumber, peekedIsContextTag)
	}

	if closeErr := readBuffer.CloseContext("BACnetChannelValue"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetChannelValue")
	}

	return _child, nil
}

func (pm *_BACnetChannelValue) serializeParent(ctx context.Context, writeBuffer utils.WriteBuffer, child BACnetChannelValue, serializeChildFunction func() error) error {
	// We redirect all calls through client as some methods are only implemented there
	m := child
	_ = m
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pushErr := writeBuffer.PushContext("BACnetChannelValue"); pushErr != nil {
		return errors.Wrap(pushErr, "Error pushing for BACnetChannelValue")
	}
	// Virtual field
	peekedTagNumber := m.GetPeekedTagNumber()
	_ = peekedTagNumber
	if _peekedTagNumberErr := writeBuffer.WriteVirtual(ctx, "peekedTagNumber", m.GetPeekedTagNumber()); _peekedTagNumberErr != nil {
		return errors.Wrap(_peekedTagNumberErr, "Error serializing 'peekedTagNumber' field")
	}
	// Virtual field
	peekedIsContextTag := m.GetPeekedIsContextTag()
	_ = peekedIsContextTag
	if _peekedIsContextTagErr := writeBuffer.WriteVirtual(ctx, "peekedIsContextTag", m.GetPeekedIsContextTag()); _peekedIsContextTagErr != nil {
		return errors.Wrap(_peekedIsContextTagErr, "Error serializing 'peekedIsContextTag' field")
	}

	// Switch field (Depending on the discriminator values, passes the serialization to a sub-type)
	if _typeSwitchErr := serializeChildFunction(); _typeSwitchErr != nil {
		return errors.Wrap(_typeSwitchErr, "Error serializing sub-type field")
	}

	if popErr := writeBuffer.PopContext("BACnetChannelValue"); popErr != nil {
		return errors.Wrap(popErr, "Error popping for BACnetChannelValue")
	}
	return nil
}

func (m *_BACnetChannelValue) IsBACnetChannelValue() {}

func (m *_BACnetChannelValue) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetChannelValue) deepCopy() *_BACnetChannelValue {
	if m == nil {
		return nil
	}
	_BACnetChannelValueCopy := &_BACnetChannelValue{
		nil, // will be set by child
		utils.DeepCopy[BACnetTagHeader](m.PeekedTagHeader),
	}
	return _BACnetChannelValueCopy
}
