/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetAuthenticationStatusTagged is the corresponding interface of BACnetAuthenticationStatusTagged
type BACnetAuthenticationStatusTagged interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	// GetHeader returns Header (property field)
	GetHeader() BACnetTagHeader
	// GetValue returns Value (property field)
	GetValue() BACnetAuthenticationStatus
	// IsBACnetAuthenticationStatusTagged is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetAuthenticationStatusTagged()
	// CreateBuilder creates a BACnetAuthenticationStatusTaggedBuilder
	CreateBACnetAuthenticationStatusTaggedBuilder() BACnetAuthenticationStatusTaggedBuilder
}

// _BACnetAuthenticationStatusTagged is the data-structure of this message
type _BACnetAuthenticationStatusTagged struct {
	Header BACnetTagHeader
	Value  BACnetAuthenticationStatus

	// Arguments.
	TagNumber uint8
	TagClass  TagClass
}

var _ BACnetAuthenticationStatusTagged = (*_BACnetAuthenticationStatusTagged)(nil)

// NewBACnetAuthenticationStatusTagged factory function for _BACnetAuthenticationStatusTagged
func NewBACnetAuthenticationStatusTagged(header BACnetTagHeader, value BACnetAuthenticationStatus, tagNumber uint8, tagClass TagClass) *_BACnetAuthenticationStatusTagged {
	if header == nil {
		panic("header of type BACnetTagHeader for BACnetAuthenticationStatusTagged must not be nil")
	}
	return &_BACnetAuthenticationStatusTagged{Header: header, Value: value, TagNumber: tagNumber, TagClass: tagClass}
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetAuthenticationStatusTaggedBuilder is a builder for BACnetAuthenticationStatusTagged
type BACnetAuthenticationStatusTaggedBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(header BACnetTagHeader, value BACnetAuthenticationStatus) BACnetAuthenticationStatusTaggedBuilder
	// WithHeader adds Header (property field)
	WithHeader(BACnetTagHeader) BACnetAuthenticationStatusTaggedBuilder
	// WithHeaderBuilder adds Header (property field) which is build by the builder
	WithHeaderBuilder(func(BACnetTagHeaderBuilder) BACnetTagHeaderBuilder) BACnetAuthenticationStatusTaggedBuilder
	// WithValue adds Value (property field)
	WithValue(BACnetAuthenticationStatus) BACnetAuthenticationStatusTaggedBuilder
	// WithArgTagNumber sets a parser argument
	WithArgTagNumber(uint8) BACnetAuthenticationStatusTaggedBuilder
	// WithArgTagClass sets a parser argument
	WithArgTagClass(TagClass) BACnetAuthenticationStatusTaggedBuilder
	// Build builds the BACnetAuthenticationStatusTagged or returns an error if something is wrong
	Build() (BACnetAuthenticationStatusTagged, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetAuthenticationStatusTagged
}

// NewBACnetAuthenticationStatusTaggedBuilder() creates a BACnetAuthenticationStatusTaggedBuilder
func NewBACnetAuthenticationStatusTaggedBuilder() BACnetAuthenticationStatusTaggedBuilder {
	return &_BACnetAuthenticationStatusTaggedBuilder{_BACnetAuthenticationStatusTagged: new(_BACnetAuthenticationStatusTagged)}
}

type _BACnetAuthenticationStatusTaggedBuilder struct {
	*_BACnetAuthenticationStatusTagged

	err *utils.MultiError
}

var _ (BACnetAuthenticationStatusTaggedBuilder) = (*_BACnetAuthenticationStatusTaggedBuilder)(nil)

func (b *_BACnetAuthenticationStatusTaggedBuilder) WithMandatoryFields(header BACnetTagHeader, value BACnetAuthenticationStatus) BACnetAuthenticationStatusTaggedBuilder {
	return b.WithHeader(header).WithValue(value)
}

func (b *_BACnetAuthenticationStatusTaggedBuilder) WithHeader(header BACnetTagHeader) BACnetAuthenticationStatusTaggedBuilder {
	b.Header = header
	return b
}

func (b *_BACnetAuthenticationStatusTaggedBuilder) WithHeaderBuilder(builderSupplier func(BACnetTagHeaderBuilder) BACnetTagHeaderBuilder) BACnetAuthenticationStatusTaggedBuilder {
	builder := builderSupplier(b.Header.CreateBACnetTagHeaderBuilder())
	var err error
	b.Header, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "BACnetTagHeaderBuilder failed"))
	}
	return b
}

func (b *_BACnetAuthenticationStatusTaggedBuilder) WithValue(value BACnetAuthenticationStatus) BACnetAuthenticationStatusTaggedBuilder {
	b.Value = value
	return b
}

func (b *_BACnetAuthenticationStatusTaggedBuilder) WithArgTagNumber(tagNumber uint8) BACnetAuthenticationStatusTaggedBuilder {
	b.TagNumber = tagNumber
	return b
}
func (b *_BACnetAuthenticationStatusTaggedBuilder) WithArgTagClass(tagClass TagClass) BACnetAuthenticationStatusTaggedBuilder {
	b.TagClass = tagClass
	return b
}

func (b *_BACnetAuthenticationStatusTaggedBuilder) Build() (BACnetAuthenticationStatusTagged, error) {
	if b.Header == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'header' not set"))
	}
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._BACnetAuthenticationStatusTagged.deepCopy(), nil
}

func (b *_BACnetAuthenticationStatusTaggedBuilder) MustBuild() BACnetAuthenticationStatusTagged {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetAuthenticationStatusTaggedBuilder) DeepCopy() any {
	_copy := b.CreateBACnetAuthenticationStatusTaggedBuilder().(*_BACnetAuthenticationStatusTaggedBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateBACnetAuthenticationStatusTaggedBuilder creates a BACnetAuthenticationStatusTaggedBuilder
func (b *_BACnetAuthenticationStatusTagged) CreateBACnetAuthenticationStatusTaggedBuilder() BACnetAuthenticationStatusTaggedBuilder {
	if b == nil {
		return NewBACnetAuthenticationStatusTaggedBuilder()
	}
	return &_BACnetAuthenticationStatusTaggedBuilder{_BACnetAuthenticationStatusTagged: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetAuthenticationStatusTagged) GetHeader() BACnetTagHeader {
	return m.Header
}

func (m *_BACnetAuthenticationStatusTagged) GetValue() BACnetAuthenticationStatus {
	return m.Value
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetAuthenticationStatusTagged(structType any) BACnetAuthenticationStatusTagged {
	if casted, ok := structType.(BACnetAuthenticationStatusTagged); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetAuthenticationStatusTagged); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetAuthenticationStatusTagged) GetTypeName() string {
	return "BACnetAuthenticationStatusTagged"
}

func (m *_BACnetAuthenticationStatusTagged) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(0)

	// Simple field (header)
	lengthInBits += m.Header.GetLengthInBits(ctx)

	// Manual Field (value)
	lengthInBits += uint16(int32(m.GetHeader().GetActualLength()) * int32(int32(8)))

	return lengthInBits
}

func (m *_BACnetAuthenticationStatusTagged) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func BACnetAuthenticationStatusTaggedParse(ctx context.Context, theBytes []byte, tagNumber uint8, tagClass TagClass) (BACnetAuthenticationStatusTagged, error) {
	return BACnetAuthenticationStatusTaggedParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes), tagNumber, tagClass)
}

func BACnetAuthenticationStatusTaggedParseWithBufferProducer(tagNumber uint8, tagClass TagClass) func(ctx context.Context, readBuffer utils.ReadBuffer) (BACnetAuthenticationStatusTagged, error) {
	return func(ctx context.Context, readBuffer utils.ReadBuffer) (BACnetAuthenticationStatusTagged, error) {
		return BACnetAuthenticationStatusTaggedParseWithBuffer(ctx, readBuffer, tagNumber, tagClass)
	}
}

func BACnetAuthenticationStatusTaggedParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer, tagNumber uint8, tagClass TagClass) (BACnetAuthenticationStatusTagged, error) {
	v, err := (&_BACnetAuthenticationStatusTagged{TagNumber: tagNumber, TagClass: tagClass}).parse(ctx, readBuffer, tagNumber, tagClass)
	if err != nil {
		return nil, err
	}
	return v, nil
}

func (m *_BACnetAuthenticationStatusTagged) parse(ctx context.Context, readBuffer utils.ReadBuffer, tagNumber uint8, tagClass TagClass) (__bACnetAuthenticationStatusTagged BACnetAuthenticationStatusTagged, err error) {
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetAuthenticationStatusTagged"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetAuthenticationStatusTagged")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	header, err := ReadSimpleField[BACnetTagHeader](ctx, "header", ReadComplex[BACnetTagHeader](BACnetTagHeaderParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'header' field"))
	}
	m.Header = header

	// Validation
	if !(bool((header.GetTagClass()) == (tagClass))) {
		return nil, errors.WithStack(utils.ParseValidationError{Message: "tag class doesn't match"})
	}

	// Validation
	if !(bool((bool((header.GetTagClass()) == (TagClass_APPLICATION_TAGS)))) || bool((bool((header.GetActualTagNumber()) == (tagNumber))))) {
		return nil, errors.WithStack(utils.ParseAssertError{Message: "tagnumber doesn't match"})
	}

	value, err := ReadManualField[BACnetAuthenticationStatus](ctx, "value", readBuffer, EnsureType[BACnetAuthenticationStatus](ReadEnumGenericFailing(ctx, readBuffer, header.GetActualLength(), BACnetAuthenticationStatus_NOT_READY)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'value' field"))
	}
	m.Value = value

	if closeErr := readBuffer.CloseContext("BACnetAuthenticationStatusTagged"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetAuthenticationStatusTagged")
	}

	return m, nil
}

func (m *_BACnetAuthenticationStatusTagged) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetAuthenticationStatusTagged) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pushErr := writeBuffer.PushContext("BACnetAuthenticationStatusTagged"); pushErr != nil {
		return errors.Wrap(pushErr, "Error pushing for BACnetAuthenticationStatusTagged")
	}

	if err := WriteSimpleField[BACnetTagHeader](ctx, "header", m.GetHeader(), WriteComplex[BACnetTagHeader](writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'header' field")
	}

	if err := WriteManualField[BACnetAuthenticationStatus](ctx, "value", func(ctx context.Context) error { return WriteEnumGeneric(ctx, writeBuffer, m.GetValue()) }, writeBuffer); err != nil {
		return errors.Wrap(err, "Error serializing 'value' field")
	}

	if popErr := writeBuffer.PopContext("BACnetAuthenticationStatusTagged"); popErr != nil {
		return errors.Wrap(popErr, "Error popping for BACnetAuthenticationStatusTagged")
	}
	return nil
}

////
// Arguments Getter

func (m *_BACnetAuthenticationStatusTagged) GetTagNumber() uint8 {
	return m.TagNumber
}
func (m *_BACnetAuthenticationStatusTagged) GetTagClass() TagClass {
	return m.TagClass
}

//
////

func (m *_BACnetAuthenticationStatusTagged) IsBACnetAuthenticationStatusTagged() {}

func (m *_BACnetAuthenticationStatusTagged) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetAuthenticationStatusTagged) deepCopy() *_BACnetAuthenticationStatusTagged {
	if m == nil {
		return nil
	}
	_BACnetAuthenticationStatusTaggedCopy := &_BACnetAuthenticationStatusTagged{
		utils.DeepCopy[BACnetTagHeader](m.Header),
		m.Value,
		m.TagNumber,
		m.TagClass,
	}
	return _BACnetAuthenticationStatusTaggedCopy
}

func (m *_BACnetAuthenticationStatusTagged) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
